/*
 * Decompiled with CFR 0.152.
 */
package CustomComponent;

import CustomComponent.DocumentType;
import common.gui.component.JTextFieldFilter;
import common.gui.util.AppConfig;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.text.Document;

public class NxGTextField
extends JTextField
implements ActionListener,
FocusListener {
    private DocumentType docType;
    Color start = Color.RED;
    Timer blendTimmer = new Timer(0, null);
    Color disableColor = Color.LIGHT_GRAY.brighter();

    public NxGTextField() {
        this.setBorder(AppConfig.emptyBorder);
        Object ob = UIManager.get("TextField.disabledBackground");
        if (ob instanceof Color) {
            this.disableColor = (Color)ob;
        }
        this.addFocusListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public String getText() {
        return super.getText().trim();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.selectAll();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public void setError(boolean isError) {
        final Timer errorTimmer = new Timer(0, null);
        if (isError) {
            ActionListener ac = new ActionListener(){
                int i = 0;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (this.i >= 6) {
                        NxGTextField.this.setBorder(AppConfig.errorBorder);
                        errorTimmer.stop();
                    } else {
                        if (this.i % 2 == 0) {
                            NxGTextField.this.setBorder(AppConfig.errorBorder);
                        } else {
                            NxGTextField.this.setBorder(AppConfig.emptyBorder);
                        }
                        ++this.i;
                    }
                }
            };
            errorTimmer.addActionListener(ac);
            errorTimmer.setDelay(100);
            errorTimmer.setRepeats(true);
            errorTimmer.start();
        } else {
            errorTimmer.stop();
            this.setBorder(AppConfig.emptyBorder);
        }
    }

    public void setDocument(DocumentType docType) {
        if (docType == DocumentType.LOWERCASE) {
            this.setDocument((Document)new JTextFieldFilter("abcdefghijklmnopqrstuvwxyz"));
            this.setHorizontalAlignment(2);
        } else if (docType == DocumentType.UPPERCASE) {
            this.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ"));
            this.setHorizontalAlignment(2);
        } else if (docType == DocumentType.NUMERIC) {
            this.setDocument((Document)new JTextFieldFilter("0123456789"));
            this.setHorizontalAlignment(4);
        } else if (docType == DocumentType.ALPHA) {
            this.setDocument((Document)new JTextFieldFilter("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"));
            this.setHorizontalAlignment(2);
        } else if (docType == DocumentType.MBILE) {
            this.setDocument((Document)new JTextFieldFilter("+- 0123456789"));
            this.setHorizontalAlignment(4);
        } else if (docType == DocumentType.FLOAT) {
            this.setDocument((Document)new JTextFieldFilter("0123456789."));
            this.setHorizontalAlignment(4);
        } else if (docType == DocumentType.ALPHA_NUMERIC) {
            this.setDocument((Document)new JTextFieldFilter("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 "));
            this.setHorizontalAlignment(2);
        } else if (docType == DocumentType.SCRIP) {
            this.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-"));
            this.setHorizontalAlignment(2);
        } else {
            this.setDocument((Document)new JTextFieldFilter("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 "));
        }
        this.docType = docType;
    }

    public void setDocument(DocumentType docType, int lengthAllowed) {
        if (docType == DocumentType.LOWERCASE) {
            this.setDocument((Document)new JTextFieldFilter("abcdefghijklmnopqrstuvwxyz", lengthAllowed));
            this.setHorizontalAlignment(2);
        } else if (docType == DocumentType.UPPERCASE) {
            this.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ", lengthAllowed));
            this.setHorizontalAlignment(2);
        } else if (docType == DocumentType.NUMERIC) {
            this.setDocument((Document)new JTextFieldFilter("0123456789", lengthAllowed));
            this.setHorizontalAlignment(4);
        } else if (docType == DocumentType.ALPHA) {
            this.setDocument((Document)new JTextFieldFilter("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", lengthAllowed));
            this.setHorizontalAlignment(2);
        } else if (docType == DocumentType.MBILE) {
            this.setDocument((Document)new JTextFieldFilter("+- 0123456789", lengthAllowed));
            this.setHorizontalAlignment(4);
        } else if (docType == DocumentType.FLOAT) {
            this.setDocument((Document)new JTextFieldFilter("0123456789.", lengthAllowed));
            this.setHorizontalAlignment(4);
        } else if (docType == DocumentType.ALPHA_NUMERIC) {
            this.setDocument((Document)new JTextFieldFilter("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 ", lengthAllowed));
            this.setHorizontalAlignment(2);
        } else if (docType == DocumentType.SCRIP) {
            this.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-"));
            this.setHorizontalAlignment(2);
        } else {
            this.setDocument((Document)new JTextFieldFilter("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 ", lengthAllowed));
        }
        this.docType = docType;
    }

    public DocumentType getDocumentType() {
        return this.docType;
    }

    public void setBlendColor(final Color dist) {
        this.blendTimmer.stop();
        this.blendTimmer = new Timer(0, null);
        ActionListener ac = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color now = NxGTextField.this.getBackground();
                if (now.getRGB() == dist.getRGB()) {
                    NxGTextField.this.blendTimmer.stop();
                } else {
                    NxGTextField.this.setBackground(NxGTextField.this.Blend(now, dist, 0.95f));
                }
            }
        };
        this.blendTimmer.addActionListener(ac);
        this.blendTimmer.setDelay(10);
        this.blendTimmer.setRepeats(true);
        this.blendTimmer.start();
    }

    Color Blend(Color clOne, Color clTwo, float fAmount) {
        float fInverse = 1.0f - fAmount;
        float[] afOne = new float[3];
        clOne.getColorComponents(afOne);
        float[] afTwo = new float[3];
        clTwo.getColorComponents(afTwo);
        float[] afResult = new float[]{afOne[0] * fAmount + afTwo[0] * fInverse, afOne[1] * fAmount + afTwo[1] * fInverse, afOne[2] * fAmount + afTwo[2] * fInverse};
        return new Color(afResult[0], afResult[1], afResult[2]);
    }
}

