/*
 * Decompiled with CFR 0.152.
 */
package Exposure;

import Exposure.ClientInformation;
import Exposure.PanelCollaterals;
import Exposure.PanelCumulativeSummery;
import Exposure.PanelExposure;
import Exposure.PanelOpenPosition;
import Exposure.PanelPortfolioSummary;
import Exposure.SearchBy;
import MyDocking.Mediator;
import common.gui.util.LogCommon;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kse.util.LogsKSE;

public class CustomExposure
extends JPanel {
    Mediator mediator = Mediator.getInstance();
    public SearchBy PnlSearchBy = null;
    public ClientInformation PnlClientInfo = null;
    public PanelCollaterals PnlCollateras = null;
    public PanelOpenPosition PnlOpenPosition = null;
    public PanelCumulativeSummery PnlCumulativeSummery = null;
    public PanelPortfolioSummary PnlPortfolioSummary = null;
    public PanelExposure PnlExpsoure = null;
    String Identifier = "b";
    JTabbedPane tabbedPane = new JTabbedPane();
    public static Hashtable<String, String> Tab = new Hashtable();
    public Hashtable<String, String> AlreadyMap = new Hashtable();
    public ArrayList<String> IndexMap = new ArrayList();
    public String SelectedAccount = "";
    private String printTitleText = "Exposure";

    public CustomExposure() {
        this.mediator.setExposure(this);
        if (LogsKSE.Exposure_Tab_Detail != null && LogsKSE.Exposure_Tab_Detail.length() > 0) {
            LogsKSE.Exposure_Tab_Detail = LogsKSE.Exposure_Tab_Detail.replaceAll("\\|", "");
            String[] TabList = LogsKSE.Exposure_Tab_Detail.split("\\;", -1);
            for (int i = 0; i < TabList.length; ++i) {
                if (TabList[i].length() <= 0) continue;
                Tab.put(TabList[i].split("\\,", -1)[1], TabList[i].split("\\,", -1)[0]);
                this.IndexMap.add(TabList[i].split("\\,", -1)[1]);
            }
        } else {
            Tab.put("a", "Client Info");
            Tab.put("b", "Portfolio");
            Tab.put("c", "Collaterals");
            Tab.put("d", "Open Position");
            Tab.put("g", "Cumulative Summery");
            Tab.put("h", "Portfolio Summary");
        }
        this.AlreadyMap.put("a", "");
        this.AlreadyMap.put("b", "");
        this.AlreadyMap.put("c", "");
        this.AlreadyMap.put("d", "");
        this.AlreadyMap.put("g", "");
        this.AlreadyMap.put("h", "");
        this.PnlSearchBy = new SearchBy(this);
        this.initComponents();
        this.setDefaultTabAsExposure();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CustomExposure.this.tbdPaneStateChanged(evt);
            }
        });
        this.PnlSearchBy.SetPreferedAccount();
    }

    private void setDefaultTabAsExposure() {
        try {
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                String Title2 = this.tabbedPane.getTitleAt(i);
                if (Tab.get("b") == null || !Tab.get("b").equalsIgnoreCase(Title2)) continue;
                this.tabbedPane.setSelectedIndex(i);
                this.PnlSearchBy.setPrintText(this.printTitleText);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void tbdPaneStateChanged(ChangeEvent evt) {
        String Title2 = this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex());
        this.PnlSearchBy.setPrintText(Title2);
        Enumeration<String> e = Tab.keys();
        while (e.hasMoreElements()) {
            String Key2 = e.nextElement();
            if (!Tab.get(Key2).equalsIgnoreCase(Title2)) continue;
            this.Identifier = Key2;
            if (this.Identifier.equalsIgnoreCase("g")) {
                this.PnlSearchBy.EnableDisable(true);
            } else {
                this.PnlSearchBy.EnableDisable(true);
            }
            if (this.Identifier.equalsIgnoreCase("a")) {
                this.PnlSearchBy.ShowHideReportControl(false);
                break;
            }
            this.PnlSearchBy.ShowHideReportControl(true);
            break;
        }
        this.doRefresh();
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.PnlSearchBy);
        this.add(Box.createRigidArea(new Dimension(5, 5)));
        this.add(this.tabbedPane);
        for (int i = 0; i < this.IndexMap.size(); ++i) {
            String Key2 = this.IndexMap.get(i);
            if (Key2.equalsIgnoreCase("a")) {
                this.PnlClientInfo = new ClientInformation();
                this.tabbedPane.addTab(Tab.get(Key2), this.PnlClientInfo);
            }
            if (Key2.equalsIgnoreCase("b")) {
                this.PnlExpsoure = new PanelExposure();
                this.tabbedPane.addTab(Tab.get(Key2), this.PnlExpsoure);
                continue;
            }
            if (Key2.equalsIgnoreCase("d")) {
                this.PnlOpenPosition = new PanelOpenPosition();
                this.tabbedPane.addTab(Tab.get(Key2), this.PnlOpenPosition);
                continue;
            }
            if (Key2.equalsIgnoreCase("c")) {
                this.PnlCollateras = new PanelCollaterals();
                this.tabbedPane.addTab(Tab.get(Key2), this.PnlCollateras);
                continue;
            }
            if (Key2.equalsIgnoreCase("g")) {
                this.PnlCumulativeSummery = new PanelCumulativeSummery();
                this.tabbedPane.addTab(Tab.get(Key2), this.PnlCumulativeSummery);
                continue;
            }
            if (!Key2.equalsIgnoreCase("h")) continue;
            this.PnlPortfolioSummary = new PanelPortfolioSummary();
            this.tabbedPane.addTab(Tab.get(Key2), this.PnlPortfolioSummary);
        }
    }

    public void doRefresh() {
        if (LogCommon.UserID == null) {
            return;
        }
        String account = this.SelectedAccount;
        if (account == null) {
            return;
        }
        if (account.equalsIgnoreCase("")) {
            this.setEmptyAccountData();
            return;
        }
        if (this.Identifier.equalsIgnoreCase("a")) {
            if (!this.AlreadyMap.get("a").equalsIgnoreCase(this.SelectedAccount)) {
                this.AlreadyMap.put("a", this.SelectedAccount);
                this.PnlClientInfo.GetData();
            }
        } else if (this.Identifier.equalsIgnoreCase("b")) {
            if (!this.AlreadyMap.get("b").equalsIgnoreCase(this.SelectedAccount)) {
                this.AlreadyMap.put("b", this.SelectedAccount);
                this.PnlExpsoure.GetData();
            }
        } else if (this.Identifier.equalsIgnoreCase("c")) {
            if (!this.AlreadyMap.get("c").equalsIgnoreCase(this.SelectedAccount)) {
                this.AlreadyMap.put("c", this.SelectedAccount);
                this.PnlCollateras.GetData();
            }
        } else if (this.Identifier.equalsIgnoreCase("d")) {
            if (!this.AlreadyMap.get("d").equalsIgnoreCase(this.SelectedAccount)) {
                this.AlreadyMap.put("d", this.SelectedAccount);
                this.PnlOpenPosition.GetData();
            }
        } else if (this.Identifier.equalsIgnoreCase("g")) {
            if (!this.AlreadyMap.get("g").equalsIgnoreCase("-")) {
                this.AlreadyMap.put("g", "-");
                this.PnlCumulativeSummery.GetData();
            }
        } else if (this.Identifier.equalsIgnoreCase("h") && !this.AlreadyMap.get("h").equalsIgnoreCase("-")) {
            this.AlreadyMap.put("h", "-");
            this.PnlPortfolioSummary.GetData();
        }
    }

    private void setEmptyAccountData() {
        if (this.Identifier.equalsIgnoreCase("b")) {
            this.PnlExpsoure.emptyExposure();
        } else if (this.Identifier.equalsIgnoreCase("c")) {
            this.PnlCollateras.ClearAll();
        } else if (this.Identifier.equalsIgnoreCase("d")) {
            this.PnlOpenPosition.ClearAll();
        } else if (this.Identifier.equalsIgnoreCase("g")) {
            this.PnlCumulativeSummery.ClearAll();
        } else if (this.Identifier.equalsIgnoreCase("h")) {
            this.PnlPortfolioSummary.ClearAll();
        }
    }

    public void updateclientinfo(String msg) {
        if (this.PnlClientInfo != null) {
            this.PnlClientInfo.UpdateClientInfo(msg);
        }
    }

    public void updatedynamicexposure(String msg) {
        if (this.PnlExpsoure != null) {
            this.PnlExpsoure.ExpouserForm(msg);
        }
    }

    public void updatecollateral(String str) {
        if (this.PnlCollateras != null) {
            this.PnlCollateras.collateral.fillCollateral(str);
        }
    }

    public void updateopenposition(String str) {
        if (this.PnlOpenPosition != null) {
            this.PnlOpenPosition.openPosition.fillOpenPosition(str);
        }
    }

    public void updatecumulativesummary(String str) {
        if (this.PnlCumulativeSummery != null) {
            this.PnlCumulativeSummery.cumulativeSummary.fillCumulativeSummary(str);
        }
    }

    public void updatclieninfostatus(String str) {
        this.PnlClientInfo.updatestatus(str);
    }

    public void updatexposurestatus(String str) {
        this.PnlExpsoure.updatestatus(str);
    }

    public void updatecollateralstatus(String str) {
        this.PnlCollateras.updatestatus(str);
    }

    public void updateopenpositionstatus(String str) {
        this.PnlOpenPosition.updatestatus(str);
    }

    public void updatecumulativesummarystatus(String str) {
        this.PnlCumulativeSummery.updatestatus(str);
    }

    public void updateStatusPortfolioSummary(String str) {
        this.PnlPortfolioSummary.setData(str);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new CustomExposure().setVisible(true);
            }
        });
    }

    public void getFocus() {
        this.PnlSearchBy.getFocus();
    }
}

