/*
 * Decompiled with CFR 0.152.
 */
package Exposure;

import MyDocking.Mediator;
import RendersNModels.PrograssBar;
import Utilities.LoadLogs;
import Utilities.ThreadWithName;
import common.gui.util.AppConfig;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class PanelExposure
extends JPanel {
    public Hashtable<String, ArrayList> ExposureGroups = new Hashtable();
    ArrayList<String> ExposureFieldAndValue1 = new ArrayList();
    ArrayList<String> ExposureFieldAndValue2 = new ArrayList();
    ArrayList<String> ExposureFieldAndValue3 = new ArrayList();
    Vector columns = new Vector();
    Vector rows = new Vector();
    String[] columnNames = new String[]{"", "", "", "", "", ""};
    DefaultTableModel exposureModel = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    };
    ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    private LanguageCentre languageCentre = new LanguageCentre();
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator4;
    private JLabel lblExposureMessage;
    private JPanel pnl_1;
    private JPanel pnl_2;
    private JPanel pnl_3;
    public JTable tblExposure;

    public PanelExposure() {
        this.initComponents();
        this.pnl_1.setLayout(new BoxLayout(this.pnl_1, 1));
        this.pnl_2.setLayout(new BoxLayout(this.pnl_2, 1));
        this.pnl_3.setLayout(new BoxLayout(this.pnl_3, 1));
        for (int i = 0; i < this.columnNames.length; ++i) {
            this.columns.addElement(this.columnNames[i]);
        }
        this.exposureModel.setDataVector(this.rows, this.columns);
        this.tblExposure.setModel(this.exposureModel);
        this.tblExposure.setRowHeight(AppConfig.rowHeight);
        this.tblExposure.getTableHeader().setReorderingAllowed(false);
        this.tblExposure.setSelectionMode(0);
        this.tblExposure.setDefaultRenderer(Object.class, new PrograssBar());
        JTableHeader header = this.tblExposure.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
    }

    public void ExpouserForm(String msg) {
        Mediator.getInstance().println(msg);
        if (msg.trim().equalsIgnoreCase("")) {
            this.emptyExposure();
            return;
        }
        if (msg.trim().length() <= 0) {
            this.emptyExposure();
            return;
        }
        if (msg.trim().equalsIgnoreCase("Invalid Account")) {
            this.updatestatus(msg);
            this.emptyExposure();
            return;
        }
        String[] resArray = msg.split("\\~", -1);
        String[] str = resArray[0].split("\\|", -1);
        String[] headerFeed = str[0].split("\\;", -1);
        this.columns.clear();
        for (int i = 0; i < headerFeed.length - 1; ++i) {
            this.columns.addElement(headerFeed[i] + "");
        }
        this.exposureModel.setDataVector(this.rows, this.columns);
        this.rows.clear();
        this.tblExposure.removeNotify();
        if (!AppConfig.houseName.equalsIgnoreCase("TAURUS")) {
            String[] strB = str[1].split("\\;", -1);
            Vector<Object> per = new Vector<Object>();
            for (int i = 0; i < strB.length - 1; ++i) {
                try {
                    int pers = (int)(Double.parseDouble(strB[i]) * 100.0) / 100;
                    if (pers > 100) {
                        pers = 100;
                    }
                    per.addElement(pers);
                    continue;
                }
                catch (Exception e) {
                    per.addElement(strB[i]);
                }
            }
            this.rows.addElement(per);
        }
        int temcounter = 2;
        if (AppConfig.houseName.equalsIgnoreCase("TAURUS")) {
            temcounter = 1;
        }
        for (int j = temcounter; j < str.length - 1; ++j) {
            Vector<String> row = new Vector<String>();
            String[] str123 = str[j].split("\\;", -1);
            for (int i = 0; i < str123.length - 1; ++i) {
                String string = str123[i];
                if (i > 0) {
                    try {
                        if (string.indexOf(".") >= 0) {
                            row.addElement(" " + Util.format2digit((String)string.toString().trim().replaceAll("\\,", "")) + " ");
                            continue;
                        }
                        row.addElement(" " + Util.format0digit((String)string.toString().trim().replaceAll("\\,", "")) + " ");
                    }
                    catch (NumberFormatException ex) {
                        row.addElement(string);
                    }
                    continue;
                }
                row.addElement(string);
            }
            this.rows.addElement(row);
        }
        if (resArray.length > 1) {
            this.SetDynamicField(resArray[1]);
        }
        if (!AppConfig.houseName.equalsIgnoreCase("TAURUS")) {
            this.tblExposure.getColumnModel().getColumn(0).setPreferredWidth(180);
        }
        this.tblExposure.addNotify();
        this.lblExposureMessage.setIcon(null);
        this.lblExposureMessage.setText(" ");
    }

    private void SetDynamicField(String msg) {
        int i;
        this.pnl_1.removeAll();
        this.pnl_2.removeAll();
        this.pnl_3.removeAll();
        this.ExposureFieldAndValue1.clear();
        this.ExposureFieldAndValue2.clear();
        this.ExposureFieldAndValue3.clear();
        String[] Temp = msg.split("\\|", -1);
        String[] FieldAndIndex = Temp[0].split("\\;", -1);
        String[] FieldTitle = new String[FieldAndIndex.length];
        String[] FieldIndex = new String[FieldAndIndex.length];
        for (i = 0; i < FieldAndIndex.length; ++i) {
            if (FieldAndIndex[i].length() <= 0) continue;
            FieldTitle[i] = FieldAndIndex[i].split("\\,", -1)[0];
            FieldIndex[i] = FieldAndIndex[i].split("\\,", -1)[1];
        }
        if (Temp.length > 1) {
            String[] FieldValue = Temp[1].split("\\;", -1);
            for (i = 0; i < FieldTitle.length; ++i) {
                JPanel pnl = new JPanel();
                pnl.setLayout(new BoxLayout(pnl, 0));
                JLabel lbl = new JLabel(FieldTitle[i]);
                Dimension d = new Dimension(140, 20);
                lbl.setPreferredSize(d);
                lbl.setMaximumSize(d);
                lbl.setMinimumSize(d);
                pnl.add(lbl);
                JTextField txtField = new JTextField();
                d = new Dimension(100, 20);
                txtField.setPreferredSize(d);
                txtField.setMaximumSize(d);
                txtField.setMinimumSize(d);
                txtField.setEditable(false);
                txtField.setHorizontalAlignment(4);
                txtField.setText(Util.format2digit((String)FieldValue[i]));
                if (Double.parseDouble(FieldValue[i]) > 0.0) {
                    txtField.setForeground(MyColors.cellFGGreen);
                } else if (Double.parseDouble(FieldValue[i]) < 0.0) {
                    txtField.setForeground(MyColors.cellFGRed);
                } else {
                    txtField.setForeground(Color.blue);
                }
                pnl.add(Box.createRigidArea(new Dimension(15, 0)));
                pnl.add(txtField);
                if (FieldIndex[i].equalsIgnoreCase("1")) {
                    this.pnl_1.add(pnl);
                    this.pnl_1.add(Box.createRigidArea(new Dimension(5, 5)));
                    this.ExposureFieldAndValue1.add(lbl.getText().replaceAll("\\~", "") + "~" + txtField.getText().replaceAll("\\~", ""));
                    continue;
                }
                if (FieldIndex[i].equalsIgnoreCase("2")) {
                    this.pnl_2.add(pnl);
                    this.pnl_2.add(Box.createRigidArea(new Dimension(5, 5)));
                    this.ExposureFieldAndValue2.add(lbl.getText().replaceAll("\\~", "") + "~" + txtField.getText().replaceAll("\\~", ""));
                    continue;
                }
                if (!FieldIndex[i].equalsIgnoreCase("3")) continue;
                this.pnl_3.add(pnl);
                this.pnl_3.add(Box.createRigidArea(new Dimension(5, 5)));
                this.ExposureFieldAndValue3.add(lbl.getText().replaceAll("\\~", "") + "~" + txtField.getText().replaceAll("\\~", ""));
            }
        }
        if (this.ExposureFieldAndValue1.size() <= 0) {
            this.pnl_1.setVisible(false);
        } else {
            this.pnl_1.setVisible(true);
        }
        if (this.ExposureFieldAndValue2.size() <= 0) {
            this.pnl_2.setVisible(false);
        } else {
            this.pnl_2.setVisible(true);
        }
        if (this.ExposureFieldAndValue3.size() <= 0) {
            this.pnl_3.setVisible(false);
        } else {
            this.pnl_3.setVisible(true);
        }
        this.ExposureGroups.clear();
        this.ExposureGroups.put("1", this.ExposureFieldAndValue1);
        this.ExposureGroups.put("2", this.ExposureFieldAndValue2);
        this.ExposureGroups.put("3", this.ExposureFieldAndValue3);
    }

    public void emptyExposure() {
        this.lblExposureMessage.setIcon(null);
        this.lblExposureMessage.setText(" ");
        this.removeExpTableOnly();
    }

    private void removeExpTableOnly() {
        int numrows = this.exposureModel.getRowCount();
        for (int i = 0; i < numrows; ++i) {
            this.exposureModel.removeRow(0);
        }
    }

    public void GetData() {
        this.lblExposureMessage.setIcon(this.loaderIcon);
        this.lblExposureMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
        LoadLogs loadLogs = new LoadLogs("DynamicExposure=", true);
        new ThreadWithName(loadLogs, "DynamicExposure").start();
    }

    void updatestatus(String str) {
        this.lblExposureMessage.setIcon(null);
        this.lblExposureMessage.setText(str);
    }

    private void initComponents() {
        this.jSeparator4 = new JSeparator();
        this.lblExposureMessage = new JLabel();
        this.pnl_1 = new JPanel();
        this.pnl_2 = new JPanel();
        this.pnl_3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tblExposure = new JTable();
        this.lblExposureMessage.setText(" ");
        this.lblExposureMessage.setVerticalAlignment(1);
        this.pnl_1.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, new Font("Tahoma", 1, 12), new Color(0, 0, 0)));
        this.pnl_1.setLayout(new BoxLayout(this.pnl_1, 2));
        this.pnl_2.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, new Font("Tahoma", 1, 12), new Color(0, 0, 0)));
        this.pnl_2.setMaximumSize(new Dimension(294, 500));
        this.pnl_2.setLayout(new BoxLayout(this.pnl_2, 2));
        this.pnl_3.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, new Font("Tahoma", 1, 12), new Color(0, 0, 0)));
        this.pnl_3.setMaximumSize(new Dimension(294, 500));
        this.pnl_3.setLayout(new BoxLayout(this.pnl_3, 2));
        this.jScrollPane1.setPreferredSize(new Dimension(452, 100));
        this.tblExposure.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.tblExposure);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 819, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.pnl_1, -2, 348, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnl_3, -2, 294, -2).addComponent(this.pnl_2, -2, 294, -2))).addComponent(this.lblExposureMessage, GroupLayout.Alignment.TRAILING, -1, 819, Short.MAX_VALUE)).addContainerGap()).addComponent(this.jSeparator4, GroupLayout.Alignment.TRAILING, -1, 839, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.pnl_2, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnl_3, -1, 67, Short.MAX_VALUE)).addComponent(this.pnl_1, -1, 129, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 241, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblExposureMessage, -2, 18, -2)));
    }

    void setMessage(String message) {
        this.lblExposureMessage.setText(message);
    }
}

