/*
 * Decompiled with CFR 0.152.
 */
package Exposure;

import CustomComponent.JTableFilter;
import CustomComponent.JTableTotal;
import CustomComponent.NxGLabelGradeint;
import CustomComponent.NxGTableCellRender;
import RendersNModels.FilteredOpenPositionModel;
import RendersNModels.OpenPositionModel;
import Utilities.LoadLogs;
import Utilities.ThreadWithName;
import common.gui.util.AppConfig;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class PanelOpenPosition
extends JPanel {
    OpenPosition openPosition = new OpenPosition();
    public OpenPositionModel openModel = null;
    public DefaultTableModel filteropenModel = null;
    Vector openColumns = new Vector();
    public Vector openRow = new Vector();
    public TableRowSorter<TableModel> openSorter = null;
    JTableFilter opePositionFilter = null;
    JTableTotal OpenPostionTotal = null;
    ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    public boolean IsModelExist = false;
    ArrayList DataType = new ArrayList();
    List<Class> columnDataType = new ArrayList<Class>();
    public double[] Total;
    OpenPositionTableCellRenderer render = new OpenPositionTableCellRenderer();
    private LanguageCentre languageCentre = new LanguageCentre();
    protected JScrollPane jScrollPane3;
    private JSeparator jSeparator1;
    public JLabel lblOpenPositionMessage;
    private JPanel pnlOpenOpsitionFilter;
    private JPanel pnlOpenPostionTotal;
    public JTable table;

    public PanelOpenPosition() {
        this.initComponents();
    }

    private void setOpenPositionFilter() {
        this.pnlOpenOpsitionFilter.removeAll();
        ArrayList opePositionFilterType = (ArrayList)this.DataType.clone();
        if (this.opePositionFilter == null) {
            this.opePositionFilter = new JTableFilter(this.table, opePositionFilterType);
            this.opePositionFilter.setPrefMinMax();
        }
        this.pnlOpenOpsitionFilter.add(this.opePositionFilter);
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                PanelOpenPosition.this.opePositionFilter.changeMargin();
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this.repaint();
    }

    private void setOpenPositionTotal() {
        this.pnlOpenPostionTotal.removeAll();
        if (this.OpenPostionTotal == null) {
            this.OpenPostionTotal = new JTableTotal(this.table, (ArrayList)this.DataType.clone());
            this.OpenPostionTotal.setPrefMinMax();
        }
        this.pnlOpenPostionTotal.add(this.OpenPostionTotal);
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                PanelOpenPosition.this.OpenPostionTotal.changeMargin();
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this.repaint();
    }

    public void GetData() {
        this.lblOpenPositionMessage.setIcon(this.loaderIcon);
        this.lblOpenPositionMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
        LoadLogs loadLogs = new LoadLogs("openposition=", true);
        new ThreadWithName(loadLogs, "openposition").start();
    }

    public void ClearAll() {
        this.openPosition.removeOpenTable();
        this.lblOpenPositionMessage.setText("No record found.");
        this.lblOpenPositionMessage.setIcon(null);
    }

    void updatestatus(String str) {
        this.lblOpenPositionMessage.setIcon(null);
        this.lblOpenPositionMessage.setText(str);
    }

    private void initComponents() {
        this.pnlOpenOpsitionFilter = new JPanel();
        this.pnlOpenPostionTotal = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.table = new JTable(this.openModel);
        this.jSeparator1 = new JSeparator();
        this.lblOpenPositionMessage = new JLabel();
        this.pnlOpenOpsitionFilter.setLayout(new GridLayout(1, 0));
        this.pnlOpenPostionTotal.setLayout(new GridLayout(1, 0));
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[]{"Market", "Scrip", "Volume", "Transaction Price", "Transaction Amount", "MTM Price", "MTM Amount", "Profit/Loss"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.table.setMinimumSize(new Dimension(30, 0));
        this.table.setSelectionForeground(new Color(51, 51, 51));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                PanelOpenPosition.this.tableMouseExited(evt);
            }
        });
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                PanelOpenPosition.this.tableMouseMoved(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.table);
        this.lblOpenPositionMessage.setText(" ");
        this.lblOpenPositionMessage.setVerticalAlignment(1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlOpenOpsitionFilter, -1, 717, Short.MAX_VALUE).addComponent(this.pnlOpenPostionTotal, GroupLayout.Alignment.TRAILING, -1, 717, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblOpenPositionMessage, -1, 658, Short.MAX_VALUE).addGap(49, 49, 49)).addComponent(this.jSeparator1, -1, 717, Short.MAX_VALUE).addComponent(this.jScrollPane3, -1, 717, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.pnlOpenOpsitionFilter, -2, 23, -2).addGap(0, 0, 0).addComponent(this.pnlOpenPostionTotal, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 172, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblOpenPositionMessage, -2, 18, -2)));
    }

    private void tableMouseExited(MouseEvent evt) {
        this.render.setRowNo(-1);
    }

    private void tableMouseMoved(MouseEvent evt) {
        int row = this.table.rowAtPoint(evt.getPoint());
        if (row != this.render.getRowNo()) {
            this.render.setRowNo(row);
            this.repaint();
        }
    }

    void setMessage(String message) {
        this.lblOpenPositionMessage.setText(message);
    }

    public TableModel NewModel() {
        int count = this.table.getRowCount();
        Vector rows = new Vector();
        for (int i = 0; i < count; ++i) {
            Vector<Object> rowsData = new Vector<Object>();
            for (int j = 0; j < 13; ++j) {
                rowsData.addElement(this.table.getModel().getValueAt(this.table.convertRowIndexToModel(i), j));
            }
            rows.add(rowsData);
        }
        this.filteropenModel = new FilteredOpenPositionModel(rows, this.openColumns);
        return this.filteropenModel;
    }

    class OpenPosition {
        public synchronized void fillOpenPosition(String msg) {
            PanelOpenPosition.this.openSorter = new TableRowSorter<TableModel>(PanelOpenPosition.this.table.getModel());
            PanelOpenPosition.this.table.setRowSorter(PanelOpenPosition.this.openSorter);
            PanelOpenPosition.this.lblOpenPositionMessage.setText("");
            PanelOpenPosition.this.lblOpenPositionMessage.setIcon(null);
            this.removeOpenTable();
            if (msg.trim().equalsIgnoreCase("Invalid Account")) {
                PanelOpenPosition.this.lblOpenPositionMessage.setForeground(MyColors.ErrorBG);
                PanelOpenPosition.this.lblOpenPositionMessage.setText("Invalid Account");
                PanelOpenPosition.this.lblOpenPositionMessage.setIcon(null);
                return;
            }
            if (msg.indexOf("|") < 0) {
                PanelOpenPosition.this.lblOpenPositionMessage.setForeground(MyColors.successMessageFG);
                PanelOpenPosition.this.lblOpenPositionMessage.setText("No record found");
                PanelOpenPosition.this.lblOpenPositionMessage.setIcon(null);
                return;
            }
            boolean Added = false;
            String[] str = msg.trim().split("\\|", -1);
            PanelOpenPosition.this.openColumns.clear();
            String[] Header = str[0].split("\\;", -1);
            for (int i = 0; i < Header.length; ++i) {
                PanelOpenPosition.this.openColumns.add(Header[i]);
            }
            PanelOpenPosition.this.DataType.clear();
            PanelOpenPosition.this.columnDataType.clear();
            if (str.length < 2) {
                PanelOpenPosition.this.lblOpenPositionMessage.setForeground(MyColors.successMessageFG);
                PanelOpenPosition.this.lblOpenPositionMessage.setText("No record found");
                PanelOpenPosition.this.lblOpenPositionMessage.setIcon(null);
                return;
            }
            for (int rowS = 1; rowS < str.length; ++rowS) {
                Vector<String> row = new Vector<String>();
                if (str[rowS].length() <= 0) continue;
                String[] str2 = str[rowS].split("\\;", -1);
                if (str2.length <= 0) {
                    PanelOpenPosition.this.lblOpenPositionMessage.setForeground(MyColors.successMessageFG);
                    PanelOpenPosition.this.lblOpenPositionMessage.setText("No record found");
                    PanelOpenPosition.this.lblOpenPositionMessage.setIcon(null);
                    return;
                }
                for (int col = 0; col < str2.length; ++col) {
                    String s = str2[col].replaceAll("\\,", "");
                    row.addElement(String.valueOf(s));
                    if (rowS != 1) continue;
                    this.SetDataType(s);
                }
                Added = true;
                PanelOpenPosition.this.openRow.addElement(row);
            }
            if (Added && PanelOpenPosition.this.IsModelExist) {
                PanelOpenPosition.this.table.addNotify();
            }
            if (!PanelOpenPosition.this.IsModelExist) {
                PanelOpenPosition.this.IsModelExist = true;
                PanelOpenPosition.this.openModel = new OpenPositionModel(PanelOpenPosition.this.openRow, PanelOpenPosition.this.openColumns);
                PanelOpenPosition.this.table.setModel(PanelOpenPosition.this.openModel);
                PanelOpenPosition.this.table.setRowHeight(AppConfig.rowHeight);
                PanelOpenPosition.this.table.getTableHeader().setReorderingAllowed(false);
                PanelOpenPosition.this.table.setSelectionMode(0);
                for (int k = 0; k < PanelOpenPosition.this.openColumns.size(); ++k) {
                    PanelOpenPosition.this.table.getColumn(PanelOpenPosition.this.openColumns.elementAt(k)).setCellRenderer(PanelOpenPosition.this.render);
                }
                PanelOpenPosition.this.openModel.setCloumnDataType(PanelOpenPosition.this.columnDataType);
                PanelOpenPosition.this.setOpenPositionFilter();
                PanelOpenPosition.this.setOpenPositionTotal();
                JTableHeader header = PanelOpenPosition.this.table.getTableHeader();
                ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
            }
            if (PanelOpenPosition.this.table.getRowCount() > 1) {
                PanelOpenPosition.this.lblOpenPositionMessage.setText(Util.format0digit((String)(PanelOpenPosition.this.table.getRowCount() + "".trim().replaceAll("\\,", ""))) + " records found.");
            } else {
                PanelOpenPosition.this.lblOpenPositionMessage.setText(Util.format0digit((String)(PanelOpenPosition.this.table.getRowCount() + "".trim().replaceAll("\\,", ""))) + " record found.");
            }
            PanelOpenPosition.this.lblOpenPositionMessage.setIcon(null);
            this.MakeTotal();
            if (PanelOpenPosition.this.openSorter != null) {
                PanelOpenPosition.this.openSorter.sort();
            }
            PanelOpenPosition.this.table.updateUI();
            PanelOpenPosition.this.repaint();
        }

        public void removeOpenTable() {
            PanelOpenPosition.this.openRow.clear();
            if (PanelOpenPosition.this.openSorter != null) {
                PanelOpenPosition.this.openSorter.sort();
            }
            if (PanelOpenPosition.this.OpenPostionTotal != null) {
                PanelOpenPosition.this.OpenPostionTotal.setTotalValues();
            }
            PanelOpenPosition.this.table.updateUI();
            PanelOpenPosition.this.table.repaint();
        }

        public void SetDataType(String Val) {
            try {
                if (Val.indexOf(".") > -1) {
                    Double.parseDouble(Val.replaceAll("\\,", ""));
                    PanelOpenPosition.this.DataType.add("Double");
                    PanelOpenPosition.this.columnDataType.add(Double.class);
                } else {
                    Integer.parseInt(Val.replaceAll("\\,", ""));
                    PanelOpenPosition.this.DataType.add("Integer");
                    PanelOpenPosition.this.columnDataType.add(Integer.class);
                }
            }
            catch (Exception e) {
                PanelOpenPosition.this.DataType.add("String");
                PanelOpenPosition.this.columnDataType.add(String.class);
            }
        }

        public void MakeTotal() {
            try {
                int i;
                PanelOpenPosition.this.Total = new double[PanelOpenPosition.this.DataType.size()];
                for (i = 0; i < PanelOpenPosition.this.DataType.size(); ++i) {
                    PanelOpenPosition.this.Total[i] = 0.0;
                }
                for (i = 0; i < PanelOpenPosition.this.openRow.size(); ++i) {
                    Vector Col = (Vector)PanelOpenPosition.this.openRow.get(i);
                    for (int j = 0; j < PanelOpenPosition.this.DataType.size(); ++j) {
                        PanelOpenPosition.this.Total[j] = PanelOpenPosition.this.Total[j] + this.CheckISDouble(Col.get(j).toString());
                    }
                }
                Vector<String> NewRow = new Vector<String>();
                NewRow.addElement("Total");
                DecimalFormat twoPlacesWithComma = new DecimalFormat("###.##");
                twoPlacesWithComma.setMinimumFractionDigits(2);
                twoPlacesWithComma.setMaximumFractionDigits(2);
                for (int i2 = 1; i2 < PanelOpenPosition.this.Total.length; ++i2) {
                    NewRow.addElement(twoPlacesWithComma.format(PanelOpenPosition.this.Total[i2]));
                }
                if (PanelOpenPosition.this.OpenPostionTotal != null) {
                    PanelOpenPosition.this.OpenPostionTotal.setTotalValues(NewRow);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public double CheckISDouble(String str) {
            double RetVal = 0.0;
            try {
                RetVal = Double.parseDouble(str.replaceAll("\\,", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return RetVal;
        }
    }

    private class OpenPositionTableCellRenderer
    extends NxGTableCellRender {
        private OpenPositionTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            NxGLabelGradeint cell = new NxGLabelGradeint();
            String stCol = table.getColumnModel().getColumn(column).getIdentifier().toString();
            cell.setForeground(MyColors.cellRenderFG);
            cell.setVerticalAlignment(0);
            if (obj == null) {
                obj = "";
            }
            boolean isTotalRow = false;
            if (row == PanelOpenPosition.this.openModel.getRowCount() - 1 && PanelOpenPosition.this.openModel.getValueAt(row, 0).toString().equalsIgnoreCase("Total")) {
                isTotalRow = true;
            }
            if (PanelOpenPosition.this.DataType.get(column).toString().equalsIgnoreCase("Double")) {
                cell.setHorizontalAlignment(4);
                cell.setText(" " + Util.format2digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
            } else if (PanelOpenPosition.this.DataType.get(column).toString().equalsIgnoreCase("Integer")) {
                cell.setHorizontalAlignment(4);
                cell.setText(" " + Util.format0digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
            } else if (PanelOpenPosition.this.DataType.get(column).toString().equalsIgnoreCase("String")) {
                cell.setHorizontalAlignment(2);
                cell.setText(" " + obj.toString() + " ");
            }
            if (row % 2 == 0) {
                cell.setGradient(this.getOddColorStart(), this.getOddColorEnd());
            } else {
                cell.setGradient(this.getEvenColorStart(), this.getEvenColorEnd());
            }
            if (isSelected) {
                cell.setGradient(this.getSelectColorStart(), this.getSelectColorEnd());
                cell.setForeground(Color.WHITE);
            }
            if ((this.getRowNo() != -1 || this.getRowNo() <= row) && this.getRowNo() == row) {
                cell.setGradient(this.getRoleOverColorStart(), this.getRoleOverColorEnd());
                cell.setForeground(Color.WHITE);
            }
            if (isTotalRow) {
                cell.setFont(new Font(cell.getFont().getFontName(), 1, cell.getFont().getSize()));
            }
            return cell;
        }
    }
}

