/*
 * Decompiled with CFR 0.152.
 */
package Logs;

import Control.JasperFileChooser;
import Control.ReportControl;
import Control.ReportControlEvent;
import Control.ReportControlListener;
import CustomComponent.MyTime;
import Logs.CustomTableModel1;
import Logs.LogValue;
import MyDocking.Mediator;
import Utilities.LoadLogs;
import Utilities.LogsTC;
import Utilities.ThreadWithName;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.text.JTextComponent;
import kse.util.LogsKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import reports.Jasper_Report;
import reports.Report_ActivityLog;

public class ActivityLog
extends JPanel
implements ActionListener,
ItemListener,
ReportControlListener {
    Mediator mediator = Mediator.getInstance();
    public String UserName = "";
    String LogString = "";
    CustomTableModel1 tabModel = null;
    int BuyCount = 0;
    int SellCount = 0;
    public static boolean isOpen = false;
    ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    private static final int indexTrader = 0;
    private static final int indexMarket = 1;
    private static final int indexScrip = 2;
    private static final int indexAccount = 3;
    private static final int indexPrice = 4;
    private static final int indexOrderNo = 5;
    private static final int indexHouseOrderNo = 6;
    private static final int indexTotalVol = 7;
    private static final int indexFillVol = 8;
    private static final int indexRemaining = 9;
    private static final int indexTicket = 10;
    private static final int indexTotalVal = 11;
    private static final int indexAction = 12;
    private static final int indexType = 13;
    private static final int indexTime = 14;
    private AutoCompleteSupport autoComplete;
    private AutoCompleteSupport autoCompleteScrip;
    private AutoCompleteSupport autoCompleteMarket;
    private JTextComponent editorScrip;
    private JTextComponent editorTrader;
    private LanguageCentre languageCentre = new LanguageCentre();
    private boolean isCallWebService = true;
    private JButton btnRefresh;
    private JComboBox cbAccountNo;
    private JCheckBox cbBuy;
    private JComboBox cbMarkets;
    private JComboBox cbScrip;
    private JCheckBox cbSell;
    private JComboBox cbTrader;
    private JSeparator jSeparator1;
    private JLabel lblAccount;
    private JLabel lblMarket;
    private JLabel lblMessage;
    private JLabel lblSymbol;
    private JLabel lblTrader;
    private ReportControl reportControl1;
    private JScrollPane srp;
    private JTable table;
    public String JRXMLFileName = "ActivityLog.jrxml";

    public ActivityLog(String User) {
        this.mediator.setActivityLog(this);
        this.UserName = User;
        this.initComponents();
        this.init();
        this.table.setEnabled(false);
        this.setSize(630, 550);
        this.LogRecieved(LogsKSE.DailyActivityLog);
        this.table.getTableHeader().setReorderingAllowed(false);
        JTableHeader header = this.table.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
        this.table.setAutoResizeMode(0);
        this.table.getColumnModel().getColumn(6).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(12).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(13).setPreferredWidth(55);
        this.table.getColumnModel().getColumn(14).setPreferredWidth(120);
        this.table.moveColumn(this.table.getColumnModel().getColumnIndex(this.languageCentre.getValue(LanguageConstant.Type)), 12);
        this.cbSell.setForeground(MyColors.SellBG);
        this.cbBuy.setForeground(MyColors.BuyBG);
        this.reportControl1.addListener(this);
        this.setLanguageValues();
    }

    public void LogRecieved(String Str) {
        this.isCallWebService = true;
        if (Str.equalsIgnoreCase("No Record found") || Str.equalsIgnoreCase("")) {
            this.lblMessage.setText(this.languageCentre.getValue(LanguageConstant.NoRecordsFound));
            this.lblMessage.setIcon(null);
        } else if (Str.equalsIgnoreCase("Exception")) {
            this.lblMessage.setText(this.languageCentre.getValue(LanguageConstant.ErrorInLoadingDailyActivityLog));
            this.lblMessage.setIcon(null);
        } else {
            this.LogString = Str;
            this.UpdateTableSafe(Str);
        }
    }

    public void GetLog() {
        if (this.isCallWebService) {
            this.isCallWebService = false;
            this.emptyTable();
            LoadLogs loadLogs = new LoadLogs("DAILYACTIVITYLOG=", true, false);
            new ThreadWithName(loadLogs, "DAILYACTIVITYLOG").start();
            this.lblMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
            this.lblMessage.setIcon(this.loaderIcon);
        }
    }

    private synchronized void UpdateTable2(String Logstr) {
        this.UpdateTableSafe(Logstr);
    }

    private void UpdateTableSafe(final String Logstr) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.UpdateTable(Logstr);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActivityLog.this.UpdateTable(Logstr);
                }
            });
        }
    }

    private void UpdateTable(String Logstr) {
        this.lblMessage.setText(" ");
        this.lblMessage.setIcon(null);
        this.BuyCount = 0;
        this.SellCount = 0;
        if (Logstr.indexOf(";") < 1) {
            this.lblMessage.setText(this.languageCentre.getValue(LanguageConstant.NoRecordsFound));
            return;
        }
        String[] list = Logstr.split("\\|", -1);
        Object[][] data = new Object[list.length][15];
        int j = 0;
        for (int i = 0; i < list.length; ++i) {
            if (list[i].trim().equalsIgnoreCase("")) continue;
            String[] Val = list[i].split("\\;", -1);
            String Trader = "";
            Trader = this.cbTrader.getSelectedItem() == null ? this.editorTrader.getText() : this.cbTrader.getSelectedItem().toString();
            String Account = this.cbAccountNo.getSelectedItem() + "";
            String Market = this.cbMarkets.getSelectedItem().toString().trim();
            String Symbol = "";
            Symbol = this.cbScrip.getSelectedItem() == null ? this.editorScrip.getText() : this.cbScrip.getSelectedItem().toString().trim();
            if (Symbol.equalsIgnoreCase("ALL")) {
                Symbol = "";
            }
            if (Account.equalsIgnoreCase("ALL")) {
                Account = "";
            }
            if (Trader.equalsIgnoreCase("ALL")) {
                Trader = "";
            }
            String Type2 = "";
            if (this.cbSell.isSelected()) {
                Type2 = "SEL";
            }
            if (this.cbBuy.isSelected()) {
                Type2 = "BUY";
            }
            if (this.cbBuy.isSelected() && this.cbSell.isSelected()) {
                Type2 = "";
            }
            if (!Val[0].trim().equalsIgnoreCase(Trader) && Trader.length() > 0 || !"ALL".equalsIgnoreCase(Market) && !Val[1].trim().equalsIgnoreCase(Market) || !Val[2].trim().equalsIgnoreCase(Symbol) && Symbol.length() > 0 || !Val[3].trim().equalsIgnoreCase(Account) && Account.length() > 0) continue;
            String temp = Val[13].trim();
            if (temp.equalsIgnoreCase("SHS")) {
                temp = "SEL";
            }
            if (!temp.equalsIgnoreCase(Type2) && Type2.length() > 0) continue;
            Color BGColor = null;
            Color FGColor = null;
            if (Val[12].trim().equalsIgnoreCase("TRD") && Val[13].trim().equalsIgnoreCase("BUY")) {
                BGColor = MyColors.dailyActivityLogBuyBGFill;
                FGColor = MyColors.dailyActivityLogBuyFGFill;
                ++this.BuyCount;
            }
            if (Val[12].trim().equalsIgnoreCase("CHG") && Val[13].trim().equalsIgnoreCase("BUY")) {
                BGColor = Color.WHITE;
                FGColor = MyColors.dailyActivityLogBuyFGFill;
                ++this.BuyCount;
            }
            if (Val[12].trim().equalsIgnoreCase("CLX") && Val[13].trim().equalsIgnoreCase("BUY")) {
                BGColor = MyColors.dailyActivityLogBuyBGCancel;
                FGColor = MyColors.dailyActivityLogBuyFGCancel;
                ++this.BuyCount;
            }
            if (Val[12].trim().equalsIgnoreCase("QUE") && Val[13].trim().equalsIgnoreCase("BUY")) {
                BGColor = MyColors.dailyActivityLogBuyBGQ;
                FGColor = MyColors.dailyActivityLogBuyFGQ;
                ++this.BuyCount;
            }
            if (Val[12].trim().equalsIgnoreCase("REJ") && Val[13].trim().equalsIgnoreCase("BUY")) {
                BGColor = MyColors.dailyActivityLogRejectBG;
                FGColor = MyColors.dailyActivityLogRejectFG;
                ++this.BuyCount;
            }
            if (Val[12].trim().equalsIgnoreCase("PEN") && Val[13].trim().equalsIgnoreCase("BUY")) {
                BGColor = MyColors.BuyOHRowColor;
                FGColor = MyColors.BuyOHTxtColor;
                ++this.BuyCount;
            }
            if (Val[12].trim().equalsIgnoreCase("TRD") && Val[13].trim().equalsIgnoreCase("SEL")) {
                BGColor = MyColors.dailyActivityLogSellBGFill;
                FGColor = MyColors.dailyActivityLogSellFGFill;
                ++this.SellCount;
            }
            if (Val[12].trim().equalsIgnoreCase("TRD") && Val[13].trim().equalsIgnoreCase("SHS")) {
                BGColor = MyColors.dailyActivityLogSellBGFill;
                FGColor = MyColors.dailyActivityLogSellFGFill;
                ++this.SellCount;
            }
            if (Val[12].trim().equalsIgnoreCase("CHG") && Val[13].trim().equalsIgnoreCase("SEL")) {
                BGColor = MyColors.dailyActivityLogBGReplaced;
                FGColor = MyColors.dailyActivityLogFGReplaced;
                ++this.SellCount;
            }
            if (Val[12].trim().equalsIgnoreCase("CLX") && Val[13].trim().equalsIgnoreCase("SEL")) {
                BGColor = MyColors.dailyActivityLogSellBGCancel;
                FGColor = MyColors.dailyActivityLogSellFGCancel;
                ++this.SellCount;
            }
            if (Val[12].trim().equalsIgnoreCase("QUE") && Val[13].trim().equalsIgnoreCase("SEL")) {
                BGColor = MyColors.dailyActivityLogSellBGQ;
                FGColor = MyColors.dailyActivityLogSellFGQ;
                ++this.SellCount;
            }
            if (Val[12].trim().equalsIgnoreCase("QUE") && Val[13].trim().equalsIgnoreCase("SHS")) {
                BGColor = MyColors.dailyActivityLogSellBGQ;
                FGColor = MyColors.dailyActivityLogSellFGQ;
                ++this.SellCount;
            }
            if (Val[12].trim().equalsIgnoreCase("REJ") && Val[13].trim().equalsIgnoreCase("SEL")) {
                BGColor = MyColors.dailyActivityLogRejectBG;
                FGColor = MyColors.dailyActivityLogRejectFG;
                ++this.SellCount;
            }
            if (Val[12].trim().equalsIgnoreCase("PEN") && Val[13].trim().equalsIgnoreCase("SEL")) {
                BGColor = MyColors.SelOHRowColor;
                FGColor = MyColors.SelOHTxtColor;
                ++this.SellCount;
            }
            data[j][0] = new LogValue(Val[0], 100, FGColor, BGColor, 2);
            data[j][1] = new LogValue(Val[1], 100, FGColor, BGColor, 2);
            data[j][2] = new LogValue(Val[2], 100, FGColor, BGColor, 2);
            data[j][3] = new LogValue(Val[3], 100, FGColor, BGColor, 2);
            data[j][4] = new LogValue(Val[4], 100, FGColor, BGColor, 4, "DOUBLE");
            data[j][5] = new LogValue(Val[5], 100, FGColor, BGColor, 2);
            data[j][6] = new LogValue(Val[6], 100, FGColor, BGColor, 2);
            data[j][7] = new LogValue(Val[7], 100, FGColor, BGColor, 4);
            data[j][8] = new LogValue(Val[8], 100, FGColor, BGColor, 4);
            data[j][9] = new LogValue(Val[9], 100, FGColor, BGColor, 4);
            data[j][10] = new LogValue(Val[10], 100, FGColor, BGColor, 4);
            data[j][11] = new LogValue(Val[11], 100, FGColor, BGColor, 4, "DOUBLE");
            data[j][12] = LogCommon.actionMap.containsKey(Val[12].toUpperCase()) ? new LogValue(LogCommon.actionMap.get(Val[12].toUpperCase()), 100, FGColor, BGColor, 2) : new LogValue(Val[12], 100, FGColor, BGColor, 2);
            data[j][13] = new LogValue(Val[13], 100, FGColor, BGColor, 2);
            data[j][14] = new LogValue(Val[14], 100, FGColor, BGColor, 2);
            ++j;
        }
        Object[][] Newdata = new Object[j][15];
        for (int k = 0; k < j; ++k) {
            for (int L = 0; L < 15; ++L) {
                if (L == 14) {
                    try {
                        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss-dd-MM-yyyy");
                        Date date = formatter.parse((String)((LogValue)data[k][L]).Value);
                        formatter = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss");
                        ((LogValue)data[k][L]).Value = formatter.format(date);
                        Newdata[k][L] = data[k][L];
                    }
                    catch (Exception e) {
                        Newdata[k][L] = data[k][L];
                    }
                    continue;
                }
                if (L == 13) {
                    LogValue dt = (LogValue)data[k][L];
                    if (dt.Value.toString().trim().equalsIgnoreCase("SEL")) {
                        dt.Value = "Sell";
                    } else if (dt.Value.toString().trim().equalsIgnoreCase("BUY")) {
                        dt.Value = "Buy";
                    } else if (dt.Value.toString().trim().equalsIgnoreCase("SHS")) {
                        dt.Value = "Short Sell";
                    }
                    Newdata[k][L] = dt;
                    continue;
                }
                Newdata[k][L] = data[k][L];
            }
        }
        this.tabModel.data = Newdata;
        this.table.setModel(this.tabModel);
        this.tabModel.update();
        if (this.tabModel.getRowCount() > 1) {
            this.lblMessage.setText(Util.format0digit((String)(this.tabModel.getRowCount() + "".trim().replaceAll("\\,", ""))) + " " + this.languageCentre.getValue(LanguageConstant.RecordsFound) + " .     " + this.languageCentre.getValue(LanguageConstant.Buy) + " (" + Util.format0digit((String)(this.BuyCount + "")) + ")     " + this.languageCentre.getValue(LanguageConstant.Sell) + " (" + Util.format0digit((String)(this.SellCount + "")) + ")");
        } else {
            this.lblMessage.setText(Util.format0digit((String)(this.tabModel.getRowCount() + "".trim().replaceAll("\\,", ""))) + " " + this.languageCentre.getValue(LanguageConstant.RecordFound) + " .     " + this.languageCentre.getValue(LanguageConstant.Buy) + " (" + Util.format0digit((String)(this.BuyCount + "")) + ")     " + this.languageCentre.getValue(LanguageConstant.Sell) + " (" + Util.format0digit((String)(this.SellCount + "")) + ")");
        }
        this.lblMessage.setIcon(null);
    }

    private void init() {
        this.setMarkets();
        this.cbMarkets.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ActivityLog.this.UpdateTable2(ActivityLog.this.LogString);
            }
        });
        this.cbMarkets.addActionListener(this);
        this.setAllScrip();
        this.editorScrip = (JTextComponent)this.cbScrip.getEditor().getEditorComponent();
        this.editorScrip.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ActivityLog.this.UpdateTable2(ActivityLog.this.LogString);
            }
        });
        this.setTreader();
        ArrayList<String> allAccount = new ArrayList<String>();
        for (String s : LogsTC.accountAll.keySet()) {
            allAccount.add(s);
        }
        Collections.sort(allAccount);
        allAccount.add(0, "ALL");
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(allAccount.toArray()));
        this.autoComplete = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])allAccount.toArray()));
        this.cbAccountNo.setSelectedItem("ALL");
        this.cbAccountNo.setEditable(true);
        this.cbAccountNo.addActionListener(this);
        this.cbAccountNo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ActivityLog.this.UpdateTable2(ActivityLog.this.LogString);
            }
        });
        this.cbBuy.addItemListener(this);
        this.cbSell.addItemListener(this);
        this.btnRefresh.addActionListener(this);
        this.btnRefresh.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ActivityLog.this.OnEnter(evt);
            }
        });
        this.tabModel = new CustomTableModel1();
        this.table = new JTable(this.tabModel);
        FontMetrics metrics = this.getFontMetrics(LogCommon.LogFont);
        int fontHeight = metrics.getHeight();
        this.table.setRowHeight(fontHeight);
        this.table.setAutoCreateRowSorter(false);
        for (int k = 0; k < this.tabModel.columnNames.length; ++k) {
            this.table.getColumn(this.tabModel.columnNames[k]).setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable tblDataTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel ret = (JLabel)super.getTableCellRendererComponent(tblDataTable, value, isSelected, hasFocus, row, column);
                    ret.setFont(LogCommon.LogFont);
                    if (column == 4 || column == 11) {
                        if (value instanceof LogValue) {
                            LogValue dt = (LogValue)value;
                            dt.Value = Util.format2digit((String)dt.Value.toString().trim().replaceAll("\\,", ""));
                            ret.setHorizontalAlignment(dt.Align);
                            ret.setBackground(dt.BackColor);
                            ret.setForeground(dt.ForColor);
                            ret.setText(" " + dt.Value.toString().trim() + " ");
                        }
                    } else if (column == 8 || column == 7 || column == 9) {
                        if (value instanceof LogValue) {
                            LogValue dt = (LogValue)value;
                            dt.Value = Util.format0digit((String)dt.Value.toString().trim().replaceAll("\\,", ""));
                            ret.setHorizontalAlignment(dt.Align);
                            ret.setBackground(dt.BackColor);
                            ret.setForeground(dt.ForColor);
                            ret.setText(" " + dt.Value.toString().trim() + " ");
                        }
                    } else if (value instanceof LogValue) {
                        LogValue dt = (LogValue)value;
                        ret.setHorizontalAlignment(dt.Align);
                        ret.setBackground(dt.BackColor);
                        ret.setForeground(dt.ForColor);
                        ret.setText(" " + dt.Value.toString().trim() + " ");
                    }
                    return ret;
                }
            });
        }
        this.srp.getViewport().add(this.table);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public void OnEnter(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.UpdateTable2(this.LogString);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.btnRefresh) {
            this.GetLog();
        } else if (evt.getSource() == this.cbAccountNo) {
            this.UpdateTable2(this.LogString);
        } else if (evt.getSource() == this.cbMarkets) {
            this.UpdateTable2(this.LogString);
        } else if (evt.getSource() == this.cbTrader) {
            this.UpdateTable2(this.LogString);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.cbBuy || source == this.cbSell) {
            this.UpdateTable2(this.LogString);
        }
    }

    private void initComponents() {
        this.jSeparator1 = new JSeparator();
        this.srp = new JScrollPane();
        this.table = new JTable();
        this.lblMessage = new JLabel();
        this.lblMarket = new JLabel();
        this.cbMarkets = new JComboBox();
        this.lblSymbol = new JLabel();
        this.lblTrader = new JLabel();
        this.cbTrader = new JComboBox();
        this.lblAccount = new JLabel();
        this.cbAccountNo = new JComboBox();
        this.cbBuy = new JCheckBox();
        this.btnRefresh = new JButton();
        this.cbSell = new JCheckBox();
        this.reportControl1 = new ReportControl();
        this.cbScrip = new JComboBox();
        this.jSeparator1.setName("jSeparator1");
        this.srp.setName("srp");
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.setName("table");
        this.srp.setViewportView(this.table);
        this.lblMessage.setText("jLabel1");
        this.lblMessage.setName("lblMessage");
        this.lblMarket.setText("Market");
        this.lblMarket.setName("lblMarket");
        this.cbMarkets.setName("cbMarkets");
        this.lblSymbol.setText("Scrip");
        this.lblSymbol.setName("lblSymbol");
        this.lblTrader.setText("Trader");
        this.lblTrader.setName("lblTrader");
        this.cbTrader.setName("cbTrader");
        this.lblAccount.setText("Account");
        this.lblAccount.setName("lblAccount");
        this.cbAccountNo.setName("cbAccountNo");
        this.cbBuy.setText("Buy");
        this.cbBuy.setName("cbBuy");
        this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/Images/refresh.png")));
        this.btnRefresh.setText("Refresh");
        this.btnRefresh.setToolTipText("Reload from server");
        this.btnRefresh.setName("Activity log -> btnRefresh");
        this.cbSell.setText("Sell");
        this.cbSell.setName("cbSell");
        this.reportControl1.setName("reportControl1");
        this.cbScrip.setName("cbScrip");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.srp).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblTrader, -2, 40, -2).addGap(10, 10, 10).addComponent(this.cbTrader, -2, 80, -2).addGap(10, 10, 10).addComponent(this.lblAccount, -2, 50, -2).addGap(10, 10, 10).addComponent(this.cbAccountNo, -2, 80, -2).addGap(10, 10, 10).addComponent(this.cbBuy)).addComponent(this.lblMessage, -2, 607, -2)).addGap(0, 41, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.lblMarket, -2, 40, -2).addGap(10, 10, 10).addComponent(this.cbMarkets, -2, 80, -2).addGap(10, 10, 10).addComponent(this.lblSymbol, -2, 50, -2).addGap(10, 10, 10).addComponent(this.cbScrip, -2, 80, -2).addGap(10, 10, 10).addComponent(this.cbSell).addGap(9, 9, 9).addComponent(this.btnRefresh, -2, 165, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.reportControl1, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblTrader, -2, 23, -2).addComponent(this.cbTrader, -2, 23, -2).addComponent(this.lblAccount, -2, 23, -2).addComponent(this.cbAccountNo, -2, 23, -2).addComponent(this.cbBuy)).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMarket, -2, 23, -2).addComponent(this.cbMarkets, -2, 23, -2).addComponent(this.lblSymbol, -2, 23, -2).addComponent(this.cbScrip, -2, 23, -2).addComponent(this.cbSell).addComponent(this.btnRefresh, -2, 23, -2).addComponent(this.reportControl1, -2, -1, -2)).addGap(5, 5, 5).addComponent(this.srp, -1, 80, Short.MAX_VALUE).addGap(6, 6, 6).addComponent(this.jSeparator1, -2, -1, -2).addGap(3, 3, 3).addComponent(this.lblMessage, -2, 20, -2)));
    }

    public Font GetOrderHistoryFont() {
        return this.table.getFont();
    }

    public String[][] getTableRows() {
        String[][] obj = new String[this.table.getModel().getRowCount()][this.table.getModel().getColumnCount()];
        for (int i = 0; i < this.table.getModel().getRowCount(); ++i) {
            for (int j = 0; j < this.table.getModel().getColumnCount(); ++j) {
                Object value = this.table.getModel().getValueAt(i, j);
                obj[i][j] = value instanceof LogValue ? ((LogValue)value).Value.toString() : value.toString();
            }
        }
        return obj;
    }

    private void setTreader() {
        Vector<String> allTrader = new Vector<String>();
        allTrader.addElement("ALL");
        allTrader.addElement(LogCommon.UserID);
        Collections.sort(allTrader);
        this.cbTrader.setModel(new DefaultComboBoxModel(allTrader));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbTrader, (EventList)GlazedLists.eventListOf((Object[])allTrader.toArray()));
        this.cbTrader.setSelectedItem("ALL");
        this.editorTrader = (JTextComponent)this.cbTrader.getEditor().getEditorComponent();
        this.editorTrader.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ActivityLog.this.UpdateTable2(ActivityLog.this.LogString);
            }
        });
    }

    public void updateAccount() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Object[] acc = new String[LogsTC.accountAll.size() + 1];
                    System.arraycopy(LogsTC.accountAll.keySet().toArray(), 0, acc, 0, LogsTC.accountAll.size());
                    acc[LogsTC.accountAll.size()] = "ALL";
                    ActivityLog.this.autoComplete.uninstall();
                    ActivityLog.this.cbAccountNo.setModel(new DefaultComboBoxModel<String>(acc));
                    ActivityLog.this.autoComplete = AutoCompleteSupport.install((JComboBox)ActivityLog.this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])acc));
                    ActivityLog.this.cbAccountNo.setSelectedItem("ALL");
                    ActivityLog.this.GetLog();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public void setAllScrip() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ActivityLog.this.autoCompleteScrip != null && ActivityLog.this.autoCompleteScrip.isInstalled()) {
                        ActivityLog.this.autoCompleteScrip.uninstall();
                    }
                    Vector allScrip = new Vector(LogCommon.SymbolAndSymbolName.keySet());
                    allScrip.addElement("ALL");
                    Collections.sort(allScrip);
                    ActivityLog.this.cbScrip.setModel(new DefaultComboBoxModel(allScrip));
                    ActivityLog.this.autoCompleteScrip = AutoCompleteSupport.install((JComboBox)ActivityLog.this.cbScrip, (EventList)GlazedLists.eventListOf((Object[])allScrip.toArray()));
                    ActivityLog.this.cbScrip.setSelectedItem("ALL");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public void setMarkets() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ActivityLog.this.autoCompleteMarket != null && ActivityLog.this.autoCompleteMarket.isInstalled()) {
                    ActivityLog.this.autoCompleteMarket.uninstall();
                }
                Vector<String> allMarket = new Vector<String>();
                allMarket.addElement("ALL");
                for (int i = 0; i < LogCommon.markets.length; ++i) {
                    allMarket.addElement(LogCommon.markets[i]);
                }
                Collections.sort(allMarket);
                ActivityLog.this.cbMarkets.setModel(new DefaultComboBoxModel(allMarket));
                ActivityLog.this.autoCompleteMarket = AutoCompleteSupport.install((JComboBox)ActivityLog.this.cbMarkets, (EventList)GlazedLists.eventListOf((Object[])allMarket.toArray()));
                ActivityLog.this.cbMarkets.setSelectedItem("ALL");
                ActivityLog.this.autoCompleteMarket.setStrict(true);
            }
        });
    }

    public void emptyTable() {
        this.lblMessage.setText(this.languageCentre.getValue(LanguageConstant.NoRecordsFound));
        this.lblMessage.setIcon(null);
        this.tabModel.data = new Object[0][];
        this.tabModel.fireTableDataChanged();
        this.table.setModel(this.tabModel);
        this.tableDataChange();
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActivityLog.this.table.addNotify();
                    ActivityLog.this.table.repaint();
                }
            });
        }
    }

    public void Refresh() {
        FontMetrics metrics = this.getFontMetrics(LogCommon.LogFont);
        int fontHeight = metrics.getHeight();
        this.table.setRowHeight(fontHeight);
        this.tableDataChange();
    }

    @Override
    public void ReportControl_Print(ReportControlEvent e) {
        Report_ActivityLog Report = new Report_ActivityLog(this.JRXMLFileName, this.getTableRows());
        this.SetParameters((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.PrintReport();
    }

    @Override
    public void ReportControl_Save(ReportControlEvent e) {
        String FileName;
        boolean result;
        Report_ActivityLog Report = new Report_ActivityLog(this.JRXMLFileName, this.getTableRows());
        this.SetParameters((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Activity Log-" + MyTime.getInstance().getDate()));
        fc.addAllJasperChoosableFileFilter();
        fc.setAcceptAllFileFilterUsed(false);
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && !(result = Report.Export(FileName = fc.getSelectedFile().getAbsolutePath() + "." + fc.getExtenstion()))) {
            JOptionPane.showMessageDialog(null, this.languageCentre.getValue(LanguageConstant.ErrorInSavingFile));
        }
    }

    @Override
    public void ReportControl_Pdf(ReportControlEvent e) {
        String FileName;
        boolean result;
        Report_ActivityLog Report = new Report_ActivityLog(this.JRXMLFileName, this.getTableRows());
        this.SetParameters((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Activity Log-" + MyTime.getInstance().getDate()));
        fc.addPdfFileFilter();
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && (result = Report.ExportToPdf(FileName = fc.getSelectedFile().getAbsolutePath().replaceAll("\"", "") + "." + fc.getExtenstion()))) {
            Object[] options = new String[]{this.languageCentre.getValue("Yes"), this.languageCentre.getValue("No")};
            int Option = JOptionPane.showOptionDialog(null, this.languageCentre.getValue(LanguageConstant.ActivityLogReportCreatedDoYouWantToOpenIt), "PDF", 0, 1, null, options, null);
            if (Option == 0) {
                try {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + FileName);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void ReportControl_View(ReportControlEvent e) {
        Report_ActivityLog Report = new Report_ActivityLog(this.JRXMLFileName, this.getTableRows());
        this.SetParameters((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.generateReport();
    }

    @Override
    public void ReportControl_CustomExport(ReportControlEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void SetParameters(Jasper_Report Report) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("PrintDate", MyTime.getInstance().getTimeAndDateForReport());
        Report.SetParameter(param);
    }

    private void setLanguageValues() {
        this.lblMarket.setText(this.languageCentre.getValue(LanguageConstant.Market));
        this.lblSymbol.setText(this.languageCentre.getValue(LanguageConstant.Scrip));
        this.lblTrader.setText(this.languageCentre.getValue(LanguageConstant.Trader));
        this.lblAccount.setText(this.languageCentre.getValue("Account"));
        this.cbBuy.setText(this.languageCentre.getValue(LanguageConstant.Buy));
        this.btnRefresh.setText(this.languageCentre.getValue(LanguageConstant.Refresh));
        this.cbSell.setText(this.languageCentre.getValue(LanguageConstant.Sell));
    }
}

