/*
 * Decompiled with CFR 0.152.
 */
package Logs;

import Control.JasperFileChooser;
import Control.ReportControl;
import Control.ReportControlEvent;
import Control.ReportControlListener;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import RendersNModels.DailyReportCellRenderer;
import Utilities.LoadLogs;
import Utilities.ThreadWithName;
import common.gui.util.AppConfig;
import common.gui.util.Util;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import languages.LanguageCentre;
import languages.LanguageConstant;
import reports.Jasper_Report;
import reports.Report_DailyTradeReport;

public class DailyTradeReport
extends JPanel
implements ReportControlListener {
    Mediator mediator = Mediator.getInstance();
    DefaultTableModel dailyReportModel = new DefaultTableModel(new Object[0][], new String[]{"Name", "Account Code", "Scrip", "Volume", "Price (Rs.)", "Profit / Loss"}){

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    };
    private int rowCount = 0;
    private ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    private DailyReportCellRenderer render = new DailyReportCellRenderer();
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnRefresh;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblMessages;
    private ReportControl reportControl1;
    private JTable table;
    public String JRXMLFileName = "DailyTradeReport.jrxml";

    public DailyTradeReport() {
        this.initComponents();
        this.mediator.setDailyTradeReport(this);
        this.table.setModel(this.dailyReportModel);
        JTableHeader header = this.table.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
        this.table.setSelectionMode(0);
        this.table.setDefaultRenderer(Object.class, this.render);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(270);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setRowHeight(AppConfig.rowHeight);
        this.getLog();
        this.reportControl1.addListener(this);
    }

    public void getLog() {
        LoadLogs DailyRpt = new LoadLogs("DAILYREPORT=", true);
        new ThreadWithName(DailyRpt, "DAILYREPORT").start();
        this.lblMessages.setText(this.languageCentre.getValue(LanguageConstant.Loading));
        this.lblMessages.setIcon(this.loaderIcon);
    }

    public void fillDailyReportDetail(String result) {
        this.lblMessages.setText(" ");
        this.lblMessages.setIcon(null);
        this.rowCount = 0;
        this.dailyReportModel = (DefaultTableModel)this.table.getModel();
        this.removeDailyReportTable();
        if (result.indexOf("=") > 0) {
            String[] str1 = result.split("=");
            if (str1[1].indexOf("|") > 0) {
                String[] str = str1[1].split("\\|", -1);
                for (int rows = 0; rows < str.length - 1; ++rows) {
                    Vector<String> row = new Vector<String>();
                    String[] str2 = str[rows].split(";");
                    if (!str2[0].trim().equalsIgnoreCase("")) {
                        ++this.rowCount;
                    }
                    for (int col = 0; col < str2.length; ++col) {
                        row.addElement(str2[col]);
                    }
                    this.dailyReportModel.addRow(row);
                }
                this.table.setModel(this.dailyReportModel);
                this.lblMessages.setText(Util.format0digit((String)(this.rowCount + "".trim().replaceAll("\\,", ""))) + " Record(s) ");
                this.repaint();
            }
        } else {
            this.lblMessages.setText(result);
        }
        this.tableDataChange();
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DailyTradeReport.this.table.addNotify();
                    DailyTradeReport.this.table.repaint();
                }
            });
        }
    }

    private void removeDailyReportTable() {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        int numrows = model.getRowCount();
        for (int i = 0; i < numrows; ++i) {
            model.removeRow(0);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.lblMessages = new JLabel();
        this.btnRefresh = new JButton();
        this.jSeparator1 = new JSeparator();
        this.reportControl1 = new ReportControl();
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Account Code", "Scrip", "Volume", "Price (Rs.)"}));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                DailyTradeReport.this.tableMouseExited(evt);
            }
        });
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                DailyTradeReport.this.tableMouseMoved(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        this.lblMessages.setText(" ");
        this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/Images/refresh.png")));
        this.btnRefresh.setText("Refresh");
        this.btnRefresh.setName("DailyTradeReport -> btnRefresh");
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DailyTradeReport.this.btnRefreshActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 310, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.lblMessages, -1, 179, Short.MAX_VALUE).addGap(20, 20, 20).addComponent(this.btnRefresh)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 196, Short.MAX_VALUE).addComponent(this.reportControl1, -2, -1, -2)).addComponent(this.jScrollPane1, -1, 290, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.reportControl1, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 118, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 2, -2).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblMessages).addComponent(this.btnRefresh))));
    }

    private void btnRefreshActionPerformed(ActionEvent evt) {
        this.getLog();
    }

    private void tableMouseExited(MouseEvent evt) {
        this.render.setRowNo(-1);
    }

    private void tableMouseMoved(MouseEvent evt) {
        int row = this.table.rowAtPoint(evt.getPoint());
        if (row != this.render.getRowNo()) {
            this.render.setRowNo(row);
            this.repaint();
        }
    }

    @Override
    public void ReportControl_Print(ReportControlEvent e) {
        Report_DailyTradeReport Report = new Report_DailyTradeReport(this.JRXMLFileName, this.table.getModel());
        this.SetParamenters((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.PrintReport();
    }

    @Override
    public void ReportControl_Save(ReportControlEvent e) {
        String FileName;
        boolean result;
        Report_DailyTradeReport Report = new Report_DailyTradeReport(this.JRXMLFileName, this.table.getModel());
        this.SetParamenters((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File(this.getReportTitle() + "-" + MyTime.getInstance().getDate()));
        fc.addAllJasperChoosableFileFilter();
        fc.setAcceptAllFileFilterUsed(false);
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && !(result = Report.Export(FileName = fc.getSelectedFile().getAbsolutePath() + "." + fc.getExtenstion()))) {
            JOptionPane.showMessageDialog(null, "Error in saving file.");
        }
    }

    @Override
    public void ReportControl_Pdf(ReportControlEvent e) {
        int Option;
        String FileName;
        boolean result;
        Report_DailyTradeReport Report = new Report_DailyTradeReport(this.JRXMLFileName, this.table.getModel());
        this.SetParamenters((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File(this.getReportTitle() + "-" + MyTime.getInstance().getDate()));
        fc.addPdfFileFilter();
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && (result = Report.ExportToPdf(FileName = fc.getSelectedFile().getAbsolutePath().replaceAll("\"", "") + "." + fc.getExtenstion())) && (Option = JOptionPane.showConfirmDialog(null, this.getReportTitle() + " created. Do you want to open it?", "PDF", 0)) == 0) {
            try {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + FileName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void ReportControl_View(ReportControlEvent e) {
        Report_DailyTradeReport Report = new Report_DailyTradeReport(this.JRXMLFileName, this.table.getModel());
        this.SetParamenters((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.generateReport();
    }

    @Override
    public void ReportControl_CustomExport(ReportControlEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void SetParamenters(Jasper_Report Report) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("PrintDate", MyTime.getInstance().getTimeAndDateForReport());
        param.put("ReportTitle", this.getReportTitle());
        Report.SetParameter(param);
    }

    public void setError(Exception ex) {
        this.lblMessages.setIcon(null);
        this.lblMessages.setText("Error in loading " + this.getReportTitle());
        this.removeDailyReportTable();
        this.tableDataChange();
    }

    private Object getReportTitle() {
        if (AppConfig.houseName.equalsIgnoreCase("JSGCL")) {
            return "Blocked Profit Loss Details";
        }
        return "Daily Trade Report";
    }
}

