/*
 * Decompiled with CFR 0.152.
 */
package Logs;

import Control.JasperFileChooser;
import Control.ReportControl;
import Control.ReportControlEvent;
import Control.ReportControlListener;
import CustomComponent.MyTime;
import Logs.TradeLogSaveOption;
import MyDocking.Mediator;
import Utilities.LoadLogs;
import Utilities.LogsTC;
import Utilities.ThreadWithName;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.component.NxGTable;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.DateFormatter;
import javax.swing.text.JTextComponent;
import kse.gui.bean.TradeOutLogBean;
import kse.gui.model.TradeOutLogModel;
import kse.gui.render.TradeOutLogRender;
import kse.util.LogsKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import reports.Jasper_Report;
import reports.Report_TradeOutLog;

public class TradeOutLog
extends JPanel
implements ActionListener,
ItemListener,
FocusListener,
ReportControlListener {
    Mediator mediator = Mediator.getInstance();
    String BuySum = "";
    String SellSum = "";
    double buySum = 0.0;
    double sellSum = 0.0;
    private JTextComponent editorScrip;
    private JTextComponent editorMarket;
    private JTextComponent editorTrader;
    private JTextComponent editorAccount;
    int LastSortCol = -1;
    String LastSortOrd = "ASC";
    int SellCount = 0;
    int BuyCount = 0;
    public static boolean isOpen = false;
    private AutoCompleteSupport autoComplete;
    private AutoCompleteSupport autoCompleteScrip;
    private AutoCompleteSupport autoCompleteMarket;
    private AutoCompleteSupport autoCompleteAccount;
    private Vector<String> columns = new Vector();
    private Vector<TradeOutLogBean> row = new Vector<TradeOutLogBean>(){

        @Override
        public synchronized String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("  Trade log{");
            for (TradeOutLogBean tradeOutLogBean : this) {
                sb.append("[").append(tradeOutLogBean).append("]").append(Util.LineSeparator);
            }
            sb.append("}");
            return sb.toString();
        }
    };
    private Vector<TradeOutLogBean> rowsAll = new Vector<TradeOutLogBean>(){

        @Override
        public synchronized String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("  Trade log{");
            for (TradeOutLogBean tradeOutLogBean : this) {
                sb.append("[").append(tradeOutLogBean).append("]").append(Util.LineSeparator);
            }
            sb.append("}");
            return sb.toString();
        }
    };
    private TradeOutLogModel model = null;
    private TradeOutLogRender render = null;
    private LanguageCentre languageCentre = new LanguageCentre();
    private boolean isCallWebService = true;
    private JButton btnReload;
    private JButton btnReset;
    private JComboBox cbAccountNo;
    private JCheckBox cbBuy;
    private JComboBox cbMarkets;
    private JComboBox cbScrip;
    private JCheckBox cbSell;
    private JComboBox cbTrader;
    private JSeparator jSeparator1;
    private JLabel lblAccNumber;
    private JLabel lblBuy;
    private JLabel lblBuy1;
    private JLabel lblMarket;
    private JLabel lblMessage;
    private JLabel lblSell;
    private JLabel lblSell1;
    private JLabel lblSymbol;
    private JLabel lblSyncTime;
    private JLabel lblTrader;
    private ReportControl reportControl1;
    private JScrollPane scrollPane;
    private JSpinner spEndTime;
    private JSpinner spStartTime;
    private NxGTable table;
    private JTextField txtBuySum;
    private JTextField txtSellSum;
    public String JRXMLFileName = "TradeLog.jrxml";

    public TradeOutLog() {
        this.mediator.setTradeLog(this);
        this.setBounds(100, 150, 800, 500);
        this.initComponents();
        this.init();
        this.btnReset.setVisible(AppConfig.isShowResetButton);
        this.initTable();
        this.setLanguageValues();
    }

    private void initTable() {
        this.columns.add(this.languageCentre.getValue(LanguageConstant.Trader));
        this.columns.add(this.languageCentre.getValue(LanguageConstant.Market));
        this.columns.add(this.languageCentre.getValue(LanguageConstant.Scrip));
        this.columns.add(this.languageCentre.getValue(LanguageConstant.Time));
        this.columns.add(this.languageCentre.getValue("Counter"));
        this.columns.add(this.languageCentre.getValue(LanguageConstant.OrderNo));
        this.columns.add(this.languageCentre.getValue(LanguageConstant.Type));
        this.columns.add(this.languageCentre.getValue(LanguageConstant.FillVolume));
        this.columns.add(this.languageCentre.getValue(LanguageConstant.Price));
        this.columns.add(this.languageCentre.getValue(LanguageConstant.Ticket));
        this.columns.add(this.languageCentre.getValue("Account"));
        this.columns.add(this.languageCentre.getValue(LanguageConstant.Action));
        this.columns.add(this.languageCentre.getValue(LanguageConstant.Flag));
        this.columns.add(this.languageCentre.getValue(LanguageConstant.TotalVolume));
        this.columns.add(this.languageCentre.getValue(LanguageConstant.TotalValue));
        this.columns.add(this.languageCentre.getValue(LanguageConstant.Remaining));
        this.model = new TradeOutLogModel(this.row, this.columns);
        this.table.setModel((TableModel)this.model);
        this.render = new TradeOutLogRender();
        for (int k = 0; k < this.model.getColumnCount(); ++k) {
            this.table.getColumn((Object)this.model.getColumnName(k)).setCellRenderer((TableCellRenderer)this.render);
        }
        FontMetrics metrics = this.getFontMetrics(LogCommon.LogFont);
        int fontHeight = metrics.getHeight();
        this.table.setRowHeight(fontHeight);
        this.table.setRowSorter(null);
        this.cbSell.setForeground(MyColors.SellBG);
        this.cbBuy.setForeground(MyColors.BuyBG);
        this.table.setColumnControlVisible(false);
        this.tableDataChange(false);
        this.setSorter();
    }

    private void setSorter() {
        JTableHeader tableHeader = this.table.getTableHeader();
        tableHeader.addMouseListener(new ColumnListner(this.table));
        tableHeader.setReorderingAllowed(false);
    }

    public void init() {
        this.setMarkets();
        this.editorMarket = (JTextComponent)this.cbMarkets.getEditor().getEditorComponent();
        this.editorMarket.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                TradeOutLog.this.OnEnter(evt);
            }
        });
        this.setAllScrip();
        this.editorScrip = (JTextComponent)this.cbScrip.getEditor().getEditorComponent();
        this.editorScrip.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TradeOutLog.this.OnEnter(evt);
            }
        });
        this.setTreader();
        this.setAccount();
        this.txtSellSum.setEnabled(false);
        this.txtBuySum.setEnabled(false);
        this.cbTrader.addActionListener(this);
        this.btnReset.addActionListener(this);
        this.btnReload.addActionListener(this);
        this.cbBuy.addItemListener(this);
        this.cbSell.addItemListener(this);
        Calendar calendarStart = Calendar.getInstance();
        calendarStart.set(11, 8);
        calendarStart.set(12, 0);
        calendarStart.set(13, 0);
        SpinnerDateModel modelStart = new SpinnerDateModel();
        modelStart.setValue(calendarStart.getTime());
        this.spStartTime.setModel(modelStart);
        JSpinner.DateEditor editorStart = new JSpinner.DateEditor(this.spStartTime, "HH:mm:ss");
        DateFormatter formatterStart = (DateFormatter)editorStart.getTextField().getFormatter();
        formatterStart.setAllowsInvalid(false);
        formatterStart.setOverwriteMode(true);
        this.spStartTime.setEditor(editorStart);
        Calendar calendarEnd = Calendar.getInstance();
        calendarEnd.set(11, 17);
        calendarEnd.set(12, 0);
        calendarEnd.set(13, 0);
        SpinnerDateModel modelEnd = new SpinnerDateModel();
        modelEnd.setValue(calendarEnd.getTime());
        this.spEndTime.setModel(modelEnd);
        JSpinner.DateEditor editorEnd = new JSpinner.DateEditor(this.spEndTime, "HH:mm:ss");
        DateFormatter formatterEnd = (DateFormatter)editorEnd.getTextField().getFormatter();
        formatterEnd.setAllowsInvalid(false);
        formatterEnd.setOverwriteMode(true);
        this.spEndTime.setEditor(editorEnd);
        editorEnd.getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TradeOutLog.this.OnEnter(e);
            }
        });
        editorStart.getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TradeOutLog.this.OnEnter(e);
            }
        });
        this.scrollPane.setViewportView((Component)this.table);
        this.reportControl1.addListener(this);
        this.reportControl1.ShowCustomExportButton();
    }

    private void setAccount() {
        ArrayList<String> allAccount = new ArrayList<String>();
        for (String s : LogsTC.accountAll.keySet()) {
            allAccount.add(s);
        }
        Collections.sort(allAccount);
        allAccount.add(0, "ALL");
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(allAccount.toArray()));
        this.autoComplete = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])allAccount.toArray()));
        this.cbAccountNo.setSelectedItem("ALL");
        this.editorAccount = (JTextComponent)this.cbAccountNo.getEditor().getEditorComponent();
        this.editorAccount.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TradeOutLog.this.OnEnter(e);
            }
        });
    }

    private void setTreader() {
        Vector<String> allTrader = new Vector<String>();
        allTrader.addElement("ALL");
        allTrader.addElement(LogCommon.UserID);
        Collections.sort(allTrader);
        this.cbTrader.setModel(new DefaultComboBoxModel(allTrader));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbTrader, (EventList)GlazedLists.eventListOf((Object[])allTrader.toArray()));
        this.cbTrader.setSelectedItem("ALL");
        this.editorTrader = (JTextComponent)this.cbTrader.getEditor().getEditorComponent();
        this.editorTrader.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    TradeOutLog.this.OnEnter(evt);
                }
            }
        });
    }

    public void updateAccount() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Object[] acc = new String[LogsTC.accountAll.size() + 1];
                    System.arraycopy(LogsTC.accountAll.keySet().toArray(), 0, acc, 0, LogsTC.accountAll.size());
                    acc[LogsTC.accountAll.size()] = "ALL";
                    TradeOutLog.this.autoComplete.uninstall();
                    TradeOutLog.this.cbAccountNo.setModel(new DefaultComboBoxModel<String>(acc));
                    TradeOutLog.this.autoComplete = AutoCompleteSupport.install((JComboBox)TradeOutLog.this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])acc));
                    TradeOutLog.this.cbAccountNo.setSelectedItem("ALL");
                    TradeOutLog.this.getLogFromServer();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public void setAllScrip() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (TradeOutLog.this.autoCompleteScrip != null && TradeOutLog.this.autoCompleteScrip.isInstalled()) {
                        TradeOutLog.this.autoCompleteScrip.uninstall();
                    }
                    Vector allScrip = new Vector(LogCommon.SymbolAndSymbolName.keySet());
                    allScrip.addElement("ALL");
                    Collections.sort(allScrip);
                    TradeOutLog.this.cbScrip.setModel(new DefaultComboBoxModel(allScrip));
                    TradeOutLog.this.autoCompleteScrip = AutoCompleteSupport.install((JComboBox)TradeOutLog.this.cbScrip, (EventList)GlazedLists.eventListOf((Object[])allScrip.toArray()));
                    TradeOutLog.this.cbScrip.setSelectedItem("ALL");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public void setMarkets() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TradeOutLog.this.autoCompleteMarket != null && TradeOutLog.this.autoCompleteMarket.isInstalled()) {
                    TradeOutLog.this.autoCompleteMarket.uninstall();
                }
                Vector<String> allMarket = new Vector<String>();
                allMarket.addElement("ALL");
                for (int i = 0; i < LogCommon.markets.length; ++i) {
                    allMarket.addElement(LogCommon.markets[i]);
                }
                Collections.sort(allMarket);
                TradeOutLog.this.cbMarkets.setModel(new DefaultComboBoxModel(allMarket));
                TradeOutLog.this.autoCompleteMarket = AutoCompleteSupport.install((JComboBox)TradeOutLog.this.cbMarkets, (EventList)GlazedLists.eventListOf((Object[])allMarket.toArray()));
                TradeOutLog.this.cbMarkets.setSelectedItem("ALL");
                TradeOutLog.this.autoCompleteMarket.setStrict(true);
            }
        });
    }

    public void OnEnter(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.rowFilter();
        }
    }

    public void setResult(String result) {
        this.isCallWebService = true;
        if (result.equalsIgnoreCase("No Record(s) found")) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Normal, (String)this.languageCentre.getValue(LanguageConstant.NoRecordsFound));
        } else if (result.equalsIgnoreCase("Exception")) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Normal, (String)this.languageCentre.getValue(LanguageConstant.ErrorInLoadingTradeLog));
        }
    }

    private void initComponents() {
        this.lblMarket = new JLabel();
        this.cbMarkets = new JComboBox();
        this.lblAccNumber = new JLabel();
        this.lblSymbol = new JLabel();
        this.lblBuy = new JLabel();
        this.txtBuySum = new JTextField();
        this.lblTrader = new JLabel();
        this.lblSell = new JLabel();
        this.txtSellSum = new JTextField();
        this.btnReset = new JButton();
        this.btnReload = new JButton();
        this.cbBuy = new JCheckBox();
        this.cbSell = new JCheckBox();
        this.lblMessage = new JLabel();
        this.cbAccountNo = new JComboBox();
        this.cbTrader = new JComboBox();
        this.reportControl1 = new ReportControl();
        this.jSeparator1 = new JSeparator();
        this.cbScrip = new JComboBox();
        this.scrollPane = new JScrollPane();
        this.table = new NxGTable();
        this.lblSell1 = new JLabel();
        this.lblBuy1 = new JLabel();
        this.spStartTime = new JSpinner();
        this.spEndTime = new JSpinner();
        this.lblSyncTime = new JLabel();
        this.lblMarket.setText("Market");
        this.lblAccNumber.setText("Account");
        this.lblSymbol.setText("Scrip");
        this.lblBuy.setText("Bought");
        this.txtBuySum.setEditable(false);
        this.txtBuySum.setHorizontalAlignment(4);
        this.txtBuySum.setText(" ");
        this.lblTrader.setText("Trader");
        this.lblSell.setText("Sold");
        this.txtSellSum.setEditable(false);
        this.txtSellSum.setHorizontalAlignment(4);
        this.txtSellSum.setText(" ");
        this.btnReset.setIcon(new ImageIcon(this.getClass().getResource("/Images/reset.png")));
        this.btnReset.setToolTipText("Reset filters");
        this.btnReset.setName("Trade Log -> btnReset");
        this.btnReload.setIcon(new ImageIcon(this.getClass().getResource("/Images/refresh.png")));
        this.btnReload.setToolTipText("Reload from server");
        this.btnReload.setName("Trade Log -> btnReload");
        this.cbBuy.setText("Buy");
        this.cbBuy.setMaximumSize(new Dimension(43, 20));
        this.cbBuy.setMinimumSize(new Dimension(43, 20));
        this.cbBuy.setPreferredSize(new Dimension(43, 20));
        this.cbSell.setText("Sell");
        this.cbSell.setMaximumSize(new Dimension(43, 23));
        this.cbSell.setMinimumSize(new Dimension(43, 23));
        this.cbSell.setPreferredSize(new Dimension(43, 23));
        this.lblMessage.setText("No record found. ");
        this.table.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.setAutoResizeMode(0);
        this.scrollPane.setViewportView((Component)this.table);
        this.lblSell1.setText("End");
        this.lblBuy1.setText("Start");
        this.lblSyncTime.setFont(new Font("Tahoma", 0, 10));
        this.lblSyncTime.setText("Last Sync:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblTrader, -2, 40, -2).addGap(10, 10, 10).addComponent(this.cbTrader, -2, 80, -2).addGap(10, 10, 10).addComponent(this.lblAccNumber, -2, 50, -2).addGap(10, 10, 10).addComponent(this.cbAccountNo, -2, 80, -2).addGap(10, 10, 10).addComponent(this.cbBuy, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.lblSell1, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spEndTime, -2, 79, -2)).addGroup(layout.createSequentialGroup().addComponent(this.lblBuy1, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spStartTime, -2, 79, -2))).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblBuy, -2, 40, -2).addGap(0, 0, 0).addComponent(this.txtBuySum, -2, 90, -2)).addGroup(layout.createSequentialGroup().addComponent(this.lblSell, -2, 40, -2).addGap(0, 0, 0).addComponent(this.txtSellSum, -2, 90, -2))).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnReset, -2, 44, -2).addGroup(layout.createSequentialGroup().addComponent(this.btnReload, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblSyncTime, -1, -1, Short.MAX_VALUE))).addGap(52, 52, 52)).addGroup(layout.createSequentialGroup().addComponent(this.lblMessage, -1, -1, Short.MAX_VALUE).addGap(149, 149, 149)).addGroup(layout.createSequentialGroup().addComponent(this.lblMarket, -2, 40, -2).addGap(10, 10, 10).addComponent(this.cbMarkets, -2, 80, -2).addGap(10, 10, 10).addComponent(this.lblSymbol, -2, 40, -2).addGap(10, 10, 10).addComponent(this.cbScrip, -2, 80, -2).addGap(10, 10, 10).addComponent(this.cbSell, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 376, Short.MAX_VALUE).addComponent(this.reportControl1, -2, 129, -2).addContainerGap()))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane).addContainerGap()));
        layout.linkSize(0, this.lblAccNumber, this.lblSymbol);
        layout.linkSize(0, this.lblBuy, this.lblSell);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblTrader, -2, 23, -2).addComponent(this.cbTrader, -2, 23, -2).addComponent(this.lblAccNumber, -2, 23, -2).addComponent(this.cbAccountNo, -2, 23, -2).addComponent(this.cbBuy, -2, 23, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblBuy, -2, 23, -2).addComponent(this.spStartTime, -2, 23, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtBuySum, -2, 23, -2).addComponent(this.btnReset, -2, 23, -2))).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMarket, -2, 23, -2).addComponent(this.cbMarkets, -2, 23, -2).addComponent(this.lblSymbol, -2, 23, -2).addComponent(this.cbScrip, -2, 23, -2).addComponent(this.cbSell, -2, 23, -2).addComponent(this.lblSell, -2, 23, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtSellSum, -2, 23, -2).addComponent(this.btnReload, -2, 23, -2)).addComponent(this.reportControl1, -2, -1, -2).addComponent(this.lblSyncTime, -2, 23, -2))).addGroup(layout.createSequentialGroup().addComponent(this.lblBuy1, -2, 23, -2).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSell1, -2, 23, -2).addComponent(this.spEndTime, -2, 23, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane, -1, 367, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 3, -2).addGap(2, 2, 2).addComponent(this.lblMessage, -2, 20, -2)));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.btnReload) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss dd/MM");
            Date date = new Date();
            this.lblSyncTime.setText("Last Sync: " + dateFormat.format(date));
            this.getLogFromServer();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.cbBuy || source == this.cbSell) {
            this.rowFilter();
        }
    }

    public boolean isAuthenticated() {
        return true;
    }

    private void getLogFromServer() {
        if (this.isCallWebService) {
            this.isCallWebService = false;
            LogsTC.TradelogHashTable.clear();
            LogsKSE.isTradelogLoad = false;
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Loading, (String)this.languageCentre.getValue(LanguageConstant.Loading));
            LoadLogs loadLogs = new LoadLogs("TRADELOG=", true, false);
            new ThreadWithName(loadLogs, "TRADELOG").start();
        }
    }

    public void emptyTable() {
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Normal, (String)this.languageCentre.getValue(LanguageConstant.NoRecordsFound));
        this.txtBuySum.setText("");
        this.txtSellSum.setText("");
        this.row.clear();
        this.tableDataChange(false);
    }

    private void tableDataChange(final boolean isPackAll) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.table.addNotify();
            if (isPackAll) {
                this.table.packAll();
            }
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TradeOutLog.this.table.addNotify();
                    if (isPackAll) {
                        TradeOutLog.this.table.packAll();
                    }
                    TradeOutLog.this.table.repaint();
                }
            });
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        if (source == this.cbAccountNo) {
            this.editorScrip.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public Font GetTradeLogFont() {
        return this.table.getFont();
    }

    public void Refresh() {
        FontMetrics metrics = this.getFontMetrics(LogCommon.LogFont);
        int fontHeight = metrics.getHeight();
        this.table.setRowHeight(fontHeight);
        this.tableDataChange(false);
    }

    @Override
    public void ReportControl_Print(ReportControlEvent e) {
        Report_TradeOutLog Report = new Report_TradeOutLog(this.JRXMLFileName, (JTable)this.table);
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.PrintReport();
    }

    @Override
    public void ReportControl_Save(ReportControlEvent e) {
        String FileName;
        boolean result;
        Report_TradeOutLog Report = new Report_TradeOutLog(this.JRXMLFileName, (JTable)this.table);
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File(this.languageCentre.getValue(LanguageConstant.TradeLog) + "-" + MyTime.getInstance().getDate()));
        fc.addAllJasperChoosableFileFilter();
        fc.setAcceptAllFileFilterUsed(false);
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && !(result = Report.Export(FileName = fc.getSelectedFile().getAbsolutePath() + "." + fc.getExtenstion()))) {
            JOptionPane.showMessageDialog(null, this.languageCentre.getValue(LanguageConstant.ErrorInSavingFile));
        }
    }

    @Override
    public void ReportControl_Pdf(ReportControlEvent e) {
        Report_TradeOutLog Report = new Report_TradeOutLog(this.JRXMLFileName, (JTable)this.table);
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File(this.languageCentre.getValue(LanguageConstant.TradeLog) + "-" + MyTime.getInstance().getDate()));
        fc.addPdfFileFilter();
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null) {
            String FileName = fc.getSelectedFile().getAbsolutePath().replaceAll("\"", "") + "." + fc.getExtenstion();
            boolean result = Report.ExportToPdf(FileName);
            if (result) {
                int Option = JOptionPane.showConfirmDialog(null, this.languageCentre.getValue(LanguageConstant.TradeLogReportCreatedDoYouWantToOpenIt), "PDF", 0);
                if (Option == 0) {
                    try {
                        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + FileName);
                    }
                    catch (IOException iOException) {}
                }
            } else {
                JOptionPane.showMessageDialog(null, this.languageCentre.getValue(LanguageConstant.ErrorInCreatingPDFfile));
            }
        }
    }

    @Override
    public void ReportControl_View(ReportControlEvent e) {
        Report_TradeOutLog Report = new Report_TradeOutLog(this.JRXMLFileName, (JTable)this.table);
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.generateReport();
    }

    @Override
    public void ReportControl_CustomExport(ReportControlEvent e) {
        try {
            Report_TradeOutLog Report = new Report_TradeOutLog(this.JRXMLFileName, (JTable)this.table);
            if (!Report.isHasPage()) {
                return;
            }
            TradeLogSaveOption td = new TradeLogSaveOption();
            int option = td.getOption();
            JasperFileChooser fc = new JasperFileChooser(new File(""));
            fc.setSelectedFile(new File(this.languageCentre.getValue(LanguageConstant.TradeLog) + "-" + MyTime.getInstance().getDate()));
            fc.addCSVFileFilter();
            fc.showSaveDialog(this);
            String FileName = fc.getSelectedFile().getAbsolutePath().replaceAll("\"", "") + "." + fc.getExtenstion();
            if (option == 0 && fc.getSelectedFile() != null) {
                try {
                    Report.CustomExport(FileName, this.table.getModel());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (option == 1 && fc.getSelectedFile() != null) {
                try {
                    Report.CustomExportNew(FileName, this.table.getModel());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (option == 3 && fc.getSelectedFile() != null) {
                try {
                    Report.CustomExportISE(FileName, this.table.getModel());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (option == 4 && fc.getSelectedFile() != null) {
                try {
                    Report.CustomExportF5(FileName, this.table.getModel());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (option == 3 && fc.getSelectedFile() != null) {
                try {
                    Report.CustomExportB2B(FileName, this.table.getModel());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void SetParameter(Jasper_Report Report) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Buy Count", this.BuyCount + "");
        param.put("Sell Count", this.SellCount + "");
        param.put("Bought", this.BuySum);
        param.put("Sold", this.SellSum);
        param.put("PrintDate", MyTime.getInstance().getTimeAndDateForReport());
        Report.SetParameter(param);
    }

    public void LogRecieved(String Str) {
        this.isCallWebService = true;
        this.mediator.println("Trade Log = " + Str);
        this.lblMessage.setIcon(null);
        if (Str.equalsIgnoreCase("No Record found") || Str.equalsIgnoreCase("")) {
            this.lblMessage.setText(this.languageCentre.getValue(LanguageConstant.NoRecordsFound));
        } else if (Str.equalsIgnoreCase("Exception")) {
            this.lblMessage.setText(this.languageCentre.getValue(LanguageConstant.ErrorInLoadingTradeLog));
        } else {
            this.UpdateTableNew(Str);
        }
    }

    private synchronized void UpdateTableNew(String Logstr) {
        this.rowsAll.clear();
        this.emptyTable();
        this.lblMessage.setText(" ");
        this.lblMessage.setIcon(null);
        if (Logstr.indexOf(";") < 1) {
            this.lblMessage.setText(this.languageCentre.getValue(LanguageConstant.NoRecordsFound));
            return;
        }
        if (Logstr.indexOf("|") > 0) {
            String[] data = Logstr.split("\\|", -1);
            for (int i = 0; i < data.length; ++i) {
                String string = data[i];
                if (string.trim().equalsIgnoreCase("")) continue;
                TradeOutLogBean b = TradeOutLogBean.parse((String)string, (boolean)false);
                this.rowsAll.add(b);
            }
            this.rowFilter();
        }
    }

    private void rowFilter() {
        this.emptyTable();
        String Trader = "";
        String Account = this.getSelectedAccount();
        String scrip = "";
        String Type2 = "";
        String market = "";
        int BuyCount2 = 0;
        int SellCount2 = 0;
        double buySum2 = 0.0;
        double sellSum2 = 0.0;
        Date start = (Date)this.spStartTime.getValue();
        Date end = (Date)this.spEndTime.getValue();
        this.setTodayDate(start);
        this.setTodayDate(end);
        Trader = this.cbTrader.getSelectedItem() == null ? this.editorTrader.getText() : this.cbTrader.getSelectedItem().toString();
        market = this.cbMarkets.getSelectedItem() == null ? this.editorMarket.getText() : this.cbMarkets.getSelectedItem().toString();
        scrip = this.cbScrip.getSelectedItem() == null ? this.editorScrip.getText() : this.cbScrip.getSelectedItem().toString().trim();
        if (scrip.equalsIgnoreCase("ALL")) {
            scrip = "";
        }
        if (market.equalsIgnoreCase("ALL")) {
            market = "";
        }
        if (Account.equalsIgnoreCase("ALL")) {
            Account = "";
        }
        if (Trader.equalsIgnoreCase("ALL")) {
            Trader = "";
        }
        if (this.cbSell.isSelected()) {
            Type2 = "SELL";
        }
        if (this.cbBuy.isSelected()) {
            Type2 = "BUY";
        }
        if (this.cbBuy.isSelected() && this.cbSell.isSelected()) {
            Type2 = "";
        }
        for (TradeOutLogBean b : this.rowsAll) {
            if (!b.getTrader().equalsIgnoreCase(Trader) && Trader.length() > 0 || !b.getScrip().trim().equalsIgnoreCase(scrip) && scrip.length() > 0 || !b.getMarket().trim().equalsIgnoreCase(market) && market.length() > 0 || (!LogCommon.isFilter ? !b.getAccount().trim().equalsIgnoreCase(Account) && Account.length() > 0 : b.getAccount().trim().indexOf(Account) == -1 && Account.length() > 0)) continue;
            if (!b.getType().equalsIgnoreCase(Type2) && Type2.length() > 0 || b.getDateTime().getTime() < start.getTime() || b.getDateTime().getTime() > end.getTime()) continue;
            if (b.getType().equalsIgnoreCase("Buy")) {
                buySum2 += (double)b.getFillVolume() * b.getPrice();
                ++BuyCount2;
            }
            if (b.getType().equalsIgnoreCase("Sell")) {
                sellSum2 += (double)b.getFillVolume() * b.getPrice();
                ++SellCount2;
            }
            this.row.add(b);
        }
        if (this.model.getRowCount() > 1) {
            this.lblMessage.setText(Util.format0digit((String)(this.model.getRowCount() + "".trim().replaceAll("\\,", ""))) + " " + this.languageCentre.getValue(LanguageConstant.RecordsFound) + ".     " + this.languageCentre.getValue(LanguageConstant.Buy) + " (" + Util.format0digit((String)(BuyCount2 + "")) + ")     " + this.languageCentre.getValue(LanguageConstant.Sell) + " (" + Util.format0digit((String)(SellCount2 + "")) + ")");
        } else {
            this.lblMessage.setText(Util.format0digit((String)(this.model.getRowCount() + "".trim().replaceAll("\\,", ""))) + " " + this.languageCentre.getValue(LanguageConstant.RecordFound) + ".     " + this.languageCentre.getValue(LanguageConstant.Buy) + " (" + Util.format0digit((String)(BuyCount2 + "")) + ")     " + this.languageCentre.getValue(LanguageConstant.Sell) + " (" + Util.format0digit((String)(SellCount2 + "")) + ")");
        }
        this.SellCount = SellCount2;
        this.BuyCount = BuyCount2;
        this.txtBuySum.setText(Util.format2digit((String)(buySum2 + "")));
        this.txtSellSum.setText(Util.format2digit((String)(sellSum2 + "")));
        this.lblMessage.setIcon(null);
        this.tableDataChange(true);
    }

    private void rowFilter(TradeOutLogBean b) {
        String Trader = "";
        String Account = this.getSelectedAccount();
        String scrip = "";
        String Type2 = "";
        String market = "";
        int BuyCount2 = 0;
        int SellCount2 = 0;
        double buySum2 = 0.0;
        double sellSum2 = 0.0;
        Trader = this.cbTrader.getSelectedItem() == null ? this.editorTrader.getText() : this.cbTrader.getSelectedItem().toString();
        market = this.cbMarkets.getSelectedItem() == null ? this.editorMarket.getText() : this.cbMarkets.getSelectedItem().toString();
        scrip = this.cbScrip.getSelectedItem() == null ? this.editorScrip.getText() : this.cbScrip.getSelectedItem().toString().trim();
        if (scrip.equalsIgnoreCase("ALL")) {
            scrip = "";
        }
        if (market.equalsIgnoreCase("ALL")) {
            market = "";
        }
        if (Account.equalsIgnoreCase("ALL")) {
            Account = "";
        }
        if (Trader.equalsIgnoreCase("ALL")) {
            Trader = "";
        }
        if (this.cbSell.isSelected()) {
            Type2 = "SELL";
        }
        if (this.cbBuy.isSelected()) {
            Type2 = "BUY";
        }
        if (this.cbBuy.isSelected() && this.cbSell.isSelected()) {
            Type2 = "";
        }
        if (!b.getTrader().equalsIgnoreCase(Trader) && Trader.length() > 0) {
            return;
        }
        if (!b.getScrip().trim().equalsIgnoreCase(scrip) && scrip.length() > 0) {
            return;
        }
        if (!b.getMarket().trim().equalsIgnoreCase(market) && market.length() > 0) {
            return;
        }
        if (LogCommon.isFilter ? b.getAccount().trim().indexOf(Account) == -1 && Account.length() > 0 : !b.getAccount().trim().equalsIgnoreCase(Account) && Account.length() > 0) {
            return;
        }
        if (!b.getType().equalsIgnoreCase(Type2) && Type2.length() > 0) {
            return;
        }
        try {
            buySum2 = Double.parseDouble(this.txtBuySum.getText().trim().replaceAll("\\,", ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            sellSum2 = Double.parseDouble(this.txtSellSum.getText().trim().replaceAll("\\,", ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (b.getType().equalsIgnoreCase("Buy")) {
            buySum2 += (double)b.getFillVolume() * b.getPrice();
            ++BuyCount2;
        }
        if (b.getType().equalsIgnoreCase("Sell")) {
            sellSum2 += (double)b.getFillVolume() * b.getPrice();
            ++SellCount2;
        }
        this.row.add(b);
        if (this.model.getRowCount() > 1) {
            this.lblMessage.setText(Util.format0digit((String)(this.model.getRowCount() + "".trim().replaceAll("\\,", ""))) + " " + this.languageCentre.getValue(LanguageConstant.RecordsFound) + ".     " + this.languageCentre.getValue(LanguageConstant.Buy) + " (" + Util.format0digit((String)(BuyCount2 + "")) + ")     " + this.languageCentre.getValue(LanguageConstant.Sell) + " (" + Util.format0digit((String)(SellCount2 + "")) + ")");
        } else {
            this.lblMessage.setText(Util.format0digit((String)(this.model.getRowCount() + "".trim().replaceAll("\\,", ""))) + " " + this.languageCentre.getValue(LanguageConstant.RecordFound) + ".     " + this.languageCentre.getValue(LanguageConstant.Buy) + " (" + Util.format0digit((String)(BuyCount2 + "")) + ")     " + this.languageCentre.getValue(LanguageConstant.Sell) + " (" + Util.format0digit((String)(SellCount2 + "")) + ")");
        }
        this.SellCount += SellCount2;
        this.BuyCount += BuyCount2;
        this.txtBuySum.setText(Util.format2digit((String)(buySum2 + "")));
        this.txtSellSum.setText(Util.format2digit((String)(sellSum2 + "")));
        this.lblMessage.setIcon(null);
    }

    private String getSelectedAccount() {
        if (this.cbAccountNo.getSelectedItem() == null) {
            return "";
        }
        if (this.cbAccountNo.getSelectedItem().toString().trim().equalsIgnoreCase("")) {
            return "";
        }
        if (this.cbAccountNo.getSelectedItem().toString().trim().equalsIgnoreCase("ALL")) {
            return "ALL";
        }
        return this.cbAccountNo.getSelectedItem().toString().trim();
    }

    public void addTrade(TradeOutLogBean tlog) {
        this.rowsAll.add(tlog);
        this.rowFilter(tlog);
    }

    private Date setTodayDate(Date st) {
        Calendar cal = Calendar.getInstance();
        Calendar cur = Calendar.getInstance();
        cal.setTime(st);
        cal.set(1, cur.get(1));
        cal.set(2, cur.get(2));
        cal.set(5, cur.get(5));
        st.setTime(cal.getTimeInMillis());
        return st;
    }

    private void deleteSummaryRows() {
        Vector<TradeOutLogBean> rowsTemp = new Vector<TradeOutLogBean>(this.row.size());
        for (TradeOutLogBean b : this.row) {
            if (b.getAccount().equalsIgnoreCase("Total") || b.getAccount().equalsIgnoreCase("Gr. Total") || b.getAccount().equalsIgnoreCase("G.Total")) continue;
            rowsTemp.add(b);
        }
        this.row.clear();
        this.row.addAll(rowsTemp);
    }

    private void setLanguageValues() {
        this.lblMarket.setText(this.languageCentre.getValue(LanguageConstant.Market));
        this.lblAccNumber.setText(this.languageCentre.getValue("Account"));
        this.lblSymbol.setText(this.languageCentre.getValue(LanguageConstant.Scrip));
        this.lblBuy.setText(this.languageCentre.getValue(LanguageConstant.Bought));
        this.lblTrader.setText(this.languageCentre.getValue(LanguageConstant.Trader));
        this.lblSell.setText(this.languageCentre.getValue(LanguageConstant.Sold));
        this.btnReset.setToolTipText(this.languageCentre.getValue(LanguageConstant.ResetFilters));
        this.btnReload.setToolTipText(this.languageCentre.getValue(LanguageConstant.ReloadFromServer));
        this.cbBuy.setText(this.languageCentre.getValue(LanguageConstant.Buy));
        this.cbSell.setText(this.languageCentre.getValue(LanguageConstant.Sell));
    }

    private class ColumnListner
    extends MouseAdapter {
        private final NxGTable table;
        protected int sortCol = 0;
        protected boolean isSortAsc = true;
        private TableColumnModel colModel;

        public ColumnListner(NxGTable table) {
            this.table = table;
            this.colModel = table.getColumnModel();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            final MouseEvent evt2 = e;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (TradeOutLog.this.row.size() > 1) {
                        ColumnListner.this.sortTable(evt2);
                    }
                }
            }, "TradeLog sortTable").start();
        }

        private void sortTable(MouseEvent e) {
            int columnModelIndex;
            int modelIndex;
            String oldMessage = TradeOutLog.this.lblMessage.getText();
            Util.setMessage((JLabel)TradeOutLog.this.lblMessage, (MessageType)MessageType.Loading, (String)TradeOutLog.this.languageCentre.getValue(LanguageConstant.PleaseWaitWhileSorting));
            if (AppConfig.isWriteTradeLog) {
                TradeOutLog.this.mediator.WriteTradeLogInFile("RowsAll Before Sort : " + TradeOutLog.this.rowsAll + Util.LineSeparator + Util.LineSeparator);
            }
            if ((modelIndex = this.colModel.getColumn(columnModelIndex = this.colModel.getColumnIndexAtX(e.getX())).getModelIndex()) < 0) {
                return;
            }
            if (this.sortCol == modelIndex) {
                this.isSortAsc = !this.isSortAsc;
            } else {
                this.sortCol = modelIndex;
            }
            if (AppConfig.isWriteTradeLog) {
                TradeOutLog.this.mediator.WriteTradeLogInFile("Rows Before Sort : " + TradeOutLog.this.row + Util.LineSeparator + Util.LineSeparator);
            }
            Collections.sort(TradeOutLog.this.row, new TradeOutLogComparator(this.sortCol, this.isSortAsc));
            TradeOutLog.this.deleteSummaryRows();
            if (this.sortCol == 10) {
                Collections.sort(TradeOutLog.this.row, new TradeOutLogComparator(2, this.isSortAsc));
                if (AppConfig.isWriteTradeLog) {
                    TradeOutLog.this.mediator.WriteTradeLogInFile("Row After Scrip Sort : " + TradeOutLog.this.row + Util.LineSeparator + Util.LineSeparator);
                }
                Collections.sort(TradeOutLog.this.row, new TradeOutLogComparator(10, this.isSortAsc));
                if (AppConfig.isWriteTradeLog) {
                    TradeOutLog.this.mediator.WriteTradeLogInFile("Row After Account Sort : " + TradeOutLog.this.row + Util.LineSeparator + Util.LineSeparator);
                }
                this.addSummaryRowsForAccount();
                if (AppConfig.isWriteTradeLog) {
                    TradeOutLog.this.mediator.WriteTradeLogInFile("Row After addSummaryRowsForAccount : " + TradeOutLog.this.row + Util.LineSeparator + Util.LineSeparator);
                }
            } else if (this.sortCol == 2) {
                Collections.sort(TradeOutLog.this.row, new TradeOutLogComparator(2, this.isSortAsc));
                if (AppConfig.isWriteTradeLog) {
                    TradeOutLog.this.mediator.WriteTradeLogInFile("Row After Scrip Sort 2 : " + TradeOutLog.this.row + Util.LineSeparator + Util.LineSeparator);
                }
                this.addSummaryRowsForContract();
                if (AppConfig.isWriteTradeLog) {
                    TradeOutLog.this.mediator.WriteTradeLogInFile("Row After addSummaryRowsForContract : " + TradeOutLog.this.row + Util.LineSeparator + Util.LineSeparator);
                }
            }
            this.table.tableChanged(new TableModelEvent((TableModel)TradeOutLog.this.model));
            TradeOutLog.this.tableDataChange(true);
            Util.setMessage((JLabel)TradeOutLog.this.lblMessage, (MessageType)MessageType.Normal, (String)oldMessage);
            if (AppConfig.isWriteTradeLog) {
                TradeOutLog.this.mediator.WriteTradeLogInFile("Row After Sort : " + TradeOutLog.this.row + Util.LineSeparator + Util.LineSeparator);
            }
        }

        private void addSummaryRowsForAccount() {
            Vector rowsTemp = new Vector(TradeOutLog.this.row.size());
            rowsTemp.addAll(TradeOutLog.this.row);
            TradeOutLog.this.row.clear();
            String accoutPrv = ((TradeOutLogBean)rowsTemp.get(0)).getAccount();
            String scripPrv = ((TradeOutLogBean)rowsTemp.get(0)).getScrip();
            long fillVolumeTotalBuyTrader = 0L;
            double totolAmountBuyTrader = 0.0;
            long fillVolumeTotalSellTrader = 0L;
            double totolAmountSellTrader = 0.0;
            long fillVolumeTotalBuyAccount = 0L;
            double totalAmountBuyAccount = 0.0;
            double averageBuyAccount = 0.0;
            long fillVolumeTotalSellAccount = 0L;
            double totalAmountSellAccount = 0.0;
            double averageSellAccount = 0.0;
            long fillVolumeTotalBuyScrip = 0L;
            double totolAmountBuyScrip = 0.0;
            double averageBuyScrip = 0.0;
            long fillVolumeTotalSellScrip = 0L;
            double totolAmountSellScrip = 0.0;
            double averageSellScrip = 0.0;
            for (int i = 0; i < rowsTemp.size(); ++i) {
                TradeOutLogBean bAccountSumm;
                TradeOutLogBean bContractSumm;
                if (accoutPrv.equalsIgnoreCase(((TradeOutLogBean)rowsTemp.get(i)).getAccount())) {
                    if (((TradeOutLogBean)rowsTemp.get(i)).getType().equalsIgnoreCase("Buy")) {
                        fillVolumeTotalBuyAccount += ((TradeOutLogBean)rowsTemp.get(i)).getFillVolume();
                        totalAmountBuyAccount += (double)((TradeOutLogBean)rowsTemp.get(i)).getFillVolume() * ((TradeOutLogBean)rowsTemp.get(i)).getPrice();
                    } else if (((TradeOutLogBean)rowsTemp.get(i)).getType().equalsIgnoreCase("Sell")) {
                        fillVolumeTotalSellAccount += ((TradeOutLogBean)rowsTemp.get(i)).getFillVolume();
                        totalAmountSellAccount += (double)((TradeOutLogBean)rowsTemp.get(i)).getFillVolume() * ((TradeOutLogBean)rowsTemp.get(i)).getPrice();
                    }
                    if (scripPrv.equalsIgnoreCase(((TradeOutLogBean)rowsTemp.get(i)).getScrip())) {
                        if (((TradeOutLogBean)rowsTemp.get(i)).getType().equalsIgnoreCase("Buy")) {
                            fillVolumeTotalBuyScrip += ((TradeOutLogBean)rowsTemp.get(i)).getFillVolume();
                            totolAmountBuyScrip += (double)((TradeOutLogBean)rowsTemp.get(i)).getFillVolume() * ((TradeOutLogBean)rowsTemp.get(i)).getPrice();
                        } else if (((TradeOutLogBean)rowsTemp.get(i)).getType().equalsIgnoreCase("Sell")) {
                            fillVolumeTotalSellScrip += ((TradeOutLogBean)rowsTemp.get(i)).getFillVolume();
                            totolAmountSellScrip += (double)((TradeOutLogBean)rowsTemp.get(i)).getFillVolume() * ((TradeOutLogBean)rowsTemp.get(i)).getPrice();
                        }
                    } else {
                        averageBuyScrip = totolAmountBuyScrip / (double)fillVolumeTotalBuyScrip;
                        averageSellScrip = totolAmountSellScrip / (double)fillVolumeTotalSellScrip;
                        bContractSumm = new TradeOutLogBean();
                        bContractSumm.setAccount("Total");
                        bContractSumm.setAverageBuy(averageBuyScrip);
                        bContractSumm.setTotalFillBuy(fillVolumeTotalBuyScrip);
                        bContractSumm.setTotolAmountBuy(totolAmountBuyScrip);
                        bContractSumm.setAverageSell(averageSellScrip);
                        bContractSumm.setTotalFillSell(fillVolumeTotalSellScrip);
                        bContractSumm.setTotolAmountSell(totolAmountSellScrip);
                        TradeOutLog.this.row.add(bContractSumm);
                        averageBuyScrip = 0.0;
                        averageSellScrip = 0.0;
                        fillVolumeTotalBuyScrip = 0L;
                        totolAmountBuyScrip = 0.0;
                        fillVolumeTotalSellScrip = 0L;
                        totolAmountSellScrip = 0.0;
                        if (i < rowsTemp.size()) {
                            scripPrv = ((TradeOutLogBean)rowsTemp.get(i)).getScrip();
                            if (((TradeOutLogBean)rowsTemp.get(i)).getType().equalsIgnoreCase("Buy")) {
                                fillVolumeTotalBuyScrip = ((TradeOutLogBean)rowsTemp.get(i)).getFillVolume();
                                totolAmountBuyScrip = (double)((TradeOutLogBean)rowsTemp.get(i)).getFillVolume() * ((TradeOutLogBean)rowsTemp.get(i)).getPrice();
                            } else if (((TradeOutLogBean)rowsTemp.get(i)).getType().equalsIgnoreCase("Sell")) {
                                fillVolumeTotalSellScrip = ((TradeOutLogBean)rowsTemp.get(i)).getFillVolume();
                                totolAmountSellScrip = (double)((TradeOutLogBean)rowsTemp.get(i)).getFillVolume() * ((TradeOutLogBean)rowsTemp.get(i)).getPrice();
                            }
                        }
                    }
                    TradeOutLog.this.row.add(rowsTemp.get(i));
                } else {
                    averageBuyScrip = totolAmountBuyScrip / (double)fillVolumeTotalBuyScrip;
                    averageSellScrip = totolAmountSellScrip / (double)fillVolumeTotalSellScrip;
                    bContractSumm = new TradeOutLogBean();
                    bContractSumm.setAccount("Total");
                    bContractSumm.setAverageBuy(averageBuyScrip);
                    bContractSumm.setTotalFillBuy(fillVolumeTotalBuyScrip);
                    bContractSumm.setTotolAmountBuy(totolAmountBuyScrip);
                    bContractSumm.setAverageSell(averageSellScrip);
                    bContractSumm.setTotalFillSell(fillVolumeTotalSellScrip);
                    bContractSumm.setTotolAmountSell(totolAmountSellScrip);
                    TradeOutLog.this.row.add(bContractSumm);
                    fillVolumeTotalBuyScrip = 0L;
                    totolAmountBuyScrip = 0.0;
                    fillVolumeTotalSellScrip = 0L;
                    totolAmountSellScrip = 0.0;
                    averageBuyScrip = 0.0;
                    averageSellScrip = 0.0;
                    if (i + 1 < rowsTemp.size()) {
                        scripPrv = ((TradeOutLogBean)rowsTemp.get(i)).getScrip();
                        if (((TradeOutLogBean)rowsTemp.get(i)).getType().equalsIgnoreCase("Buy")) {
                            fillVolumeTotalBuyScrip = ((TradeOutLogBean)rowsTemp.get(i)).getFillVolume();
                            totolAmountBuyScrip = (double)((TradeOutLogBean)rowsTemp.get(i)).getFillVolume() * ((TradeOutLogBean)rowsTemp.get(i)).getPrice();
                        } else if (((TradeOutLogBean)rowsTemp.get(i)).getType().equalsIgnoreCase("Sell")) {
                            fillVolumeTotalSellScrip = ((TradeOutLogBean)rowsTemp.get(i)).getFillVolume();
                            totolAmountSellScrip = (double)((TradeOutLogBean)rowsTemp.get(i)).getFillVolume() * ((TradeOutLogBean)rowsTemp.get(i)).getPrice();
                        }
                    }
                    averageBuyAccount = totalAmountBuyAccount / (double)fillVolumeTotalBuyAccount;
                    averageSellAccount = totalAmountSellAccount / (double)fillVolumeTotalSellAccount;
                    fillVolumeTotalBuyTrader += fillVolumeTotalBuyAccount;
                    totolAmountBuyTrader += totalAmountBuyAccount;
                    totolAmountSellTrader += totalAmountSellAccount;
                    fillVolumeTotalSellTrader += fillVolumeTotalSellAccount;
                    bAccountSumm = new TradeOutLogBean();
                    bAccountSumm.setAccount("Gr. Total");
                    bAccountSumm.setAverageBuy(averageBuyAccount);
                    bAccountSumm.setTotalFillBuy(fillVolumeTotalBuyAccount);
                    bAccountSumm.setTotolAmountBuy(totalAmountBuyAccount);
                    bAccountSumm.setAverageSell(averageSellAccount);
                    bAccountSumm.setTotalFillSell(fillVolumeTotalSellAccount);
                    bAccountSumm.setTotolAmountSell(totalAmountSellAccount);
                    TradeOutLog.this.row.add(bAccountSumm);
                    fillVolumeTotalBuyAccount = 0L;
                    totalAmountBuyAccount = 0.0;
                    averageBuyAccount = 0.0;
                    fillVolumeTotalSellAccount = 0L;
                    totalAmountSellAccount = 0.0;
                    averageSellAccount = 0.0;
                    if (i < rowsTemp.size()) {
                        accoutPrv = ((TradeOutLogBean)rowsTemp.get(i)).getAccount();
                        if (((TradeOutLogBean)rowsTemp.get(i)).getType().equalsIgnoreCase("Buy")) {
                            fillVolumeTotalBuyAccount = ((TradeOutLogBean)rowsTemp.get(i)).getFillVolume();
                            totalAmountBuyAccount = (double)((TradeOutLogBean)rowsTemp.get(i)).getFillVolume() * ((TradeOutLogBean)rowsTemp.get(i)).getPrice();
                        } else if (((TradeOutLogBean)rowsTemp.get(i)).getType().equalsIgnoreCase("Sell")) {
                            fillVolumeTotalSellAccount = ((TradeOutLogBean)rowsTemp.get(i)).getFillVolume();
                            totalAmountSellAccount = (double)((TradeOutLogBean)rowsTemp.get(i)).getFillVolume() * ((TradeOutLogBean)rowsTemp.get(i)).getPrice();
                        }
                    }
                    TradeOutLog.this.row.add(rowsTemp.get(i));
                }
                if (i != rowsTemp.size() - 1) continue;
                averageBuyScrip = totolAmountBuyScrip / (double)fillVolumeTotalBuyScrip;
                averageSellScrip = totolAmountSellScrip / (double)fillVolumeTotalSellScrip;
                bContractSumm = new TradeOutLogBean();
                bContractSumm.setAccount("Total");
                bContractSumm.setAverageBuy(averageBuyScrip);
                bContractSumm.setTotalFillBuy(fillVolumeTotalBuyScrip);
                bContractSumm.setTotolAmountBuy(totolAmountBuyScrip);
                bContractSumm.setAverageSell(averageSellScrip);
                bContractSumm.setTotalFillSell(fillVolumeTotalSellScrip);
                bContractSumm.setTotolAmountSell(totolAmountSellScrip);
                TradeOutLog.this.row.add(bContractSumm);
                averageBuyAccount = totalAmountBuyAccount / (double)fillVolumeTotalBuyAccount;
                averageSellAccount = totalAmountSellAccount / (double)fillVolumeTotalSellAccount;
                fillVolumeTotalBuyTrader += fillVolumeTotalBuyAccount;
                totolAmountSellTrader += totalAmountSellAccount;
                fillVolumeTotalSellTrader += fillVolumeTotalSellAccount;
                bAccountSumm = new TradeOutLogBean();
                TradeOutLog.this.BuySum = "";
                TradeOutLog.this.BuySum = Util.format2digit((String)String.valueOf(totolAmountBuyTrader += totalAmountBuyAccount));
                bAccountSumm.setAccount("Gr. Total");
                bAccountSumm.setAverageBuy(averageBuyAccount);
                bAccountSumm.setTotalFillBuy(fillVolumeTotalBuyAccount);
                bAccountSumm.setTotolAmountBuy(totalAmountBuyAccount);
                TradeOutLog.this.SellSum = "";
                TradeOutLog.this.SellSum = Util.format2digit((String)String.valueOf(totolAmountSellTrader));
                bAccountSumm.setAverageSell(averageSellAccount);
                bAccountSumm.setTotalFillSell(fillVolumeTotalSellAccount);
                bAccountSumm.setTotolAmountSell(totalAmountSellAccount);
                TradeOutLog.this.row.add(bAccountSumm);
                TradeOutLogBean bTraderSumm = new TradeOutLogBean();
                bTraderSumm.setAccount("G.Total");
                bTraderSumm.setTotalFillBuy(fillVolumeTotalBuyTrader);
                bTraderSumm.setTotolAmountBuy(totolAmountBuyTrader);
                bTraderSumm.setTotalFillSell(fillVolumeTotalSellTrader);
                bTraderSumm.setTotolAmountSell(totolAmountSellTrader);
                TradeOutLog.this.row.add(bTraderSumm);
            }
        }

        private void addSummaryRowsForContract() {
            Vector rowsTemp = new Vector(TradeOutLog.this.row.size());
            rowsTemp.addAll(TradeOutLog.this.row);
            TradeOutLog.this.row.clear();
            String contractPrv = ((TradeOutLogBean)rowsTemp.get(0)).getScrip();
            long fillVolumeTotalBuyContract = 0L;
            double totolAmountBuyContract = 0.0;
            long fillVolumeTotalSellContract = 0L;
            double totolAmountSellContract = 0.0;
            double averageBuyContract = 0.0;
            double averageSellContract = 0.0;
            long fillVolumeTotalBuyContractAll = 0L;
            double totolAmountBuyContractAll = 0.0;
            long fillVolumeTotalSellContractAll = 0L;
            double totolAmountSellContractAll = 0.0;
            for (int i = 0; i < rowsTemp.size(); ++i) {
                TradeOutLogBean bContractSumm;
                TradeOutLogBean tradedOrderBean = (TradeOutLogBean)rowsTemp.elementAt(i);
                if (contractPrv.equalsIgnoreCase(tradedOrderBean.getScrip())) {
                    TradeOutLog.this.row.add(tradedOrderBean);
                    if (tradedOrderBean.getType().equalsIgnoreCase("Buy")) {
                        fillVolumeTotalBuyContract += tradedOrderBean.getFillVolume();
                        totolAmountBuyContract += (double)tradedOrderBean.getFillVolume() * tradedOrderBean.getPrice();
                    } else if (((TradeOutLogBean)rowsTemp.get(i)).getType().equalsIgnoreCase("Sell")) {
                        fillVolumeTotalSellContract += tradedOrderBean.getFillVolume();
                        totolAmountSellContract += (double)tradedOrderBean.getFillVolume() * tradedOrderBean.getPrice();
                    }
                } else {
                    averageBuyContract = totolAmountBuyContract / (double)fillVolumeTotalBuyContract;
                    averageSellContract = totolAmountSellContract / (double)fillVolumeTotalSellContract;
                    fillVolumeTotalBuyContractAll += fillVolumeTotalBuyContract;
                    fillVolumeTotalSellContractAll += fillVolumeTotalSellContract;
                    totolAmountBuyContractAll += totolAmountBuyContract;
                    totolAmountSellContractAll += totolAmountSellContract;
                    bContractSumm = new TradeOutLogBean();
                    bContractSumm.setAccount("Total");
                    bContractSumm.setAverageBuy(averageBuyContract);
                    bContractSumm.setTotalFillBuy(fillVolumeTotalBuyContract);
                    bContractSumm.setTotolAmountBuy(totolAmountBuyContract);
                    bContractSumm.setAverageSell(averageSellContract);
                    bContractSumm.setTotalFillSell(fillVolumeTotalSellContract);
                    bContractSumm.setTotolAmountSell(totolAmountSellContract);
                    TradeOutLog.this.row.add(bContractSumm);
                    fillVolumeTotalBuyContract = 0L;
                    totolAmountBuyContract = 0.0;
                    fillVolumeTotalSellContract = 0L;
                    totolAmountSellContract = 0.0;
                    averageBuyContract = 0.0;
                    averageSellContract = 0.0;
                    TradeOutLog.this.row.add(tradedOrderBean);
                    if (i < rowsTemp.size()) {
                        contractPrv = ((TradeOutLogBean)rowsTemp.get(i)).getScrip();
                        if (((TradeOutLogBean)rowsTemp.get(i)).getType().equalsIgnoreCase("Buy")) {
                            fillVolumeTotalBuyContract = ((TradeOutLogBean)rowsTemp.get(i)).getFillVolume();
                            totolAmountBuyContract = (double)((TradeOutLogBean)rowsTemp.get(i)).getFillVolume() * ((TradeOutLogBean)rowsTemp.get(i)).getPrice();
                        } else if (((TradeOutLogBean)rowsTemp.get(i)).getType().equalsIgnoreCase("Sell")) {
                            fillVolumeTotalSellContract = ((TradeOutLogBean)rowsTemp.get(i)).getFillVolume();
                            totolAmountSellContract = (double)((TradeOutLogBean)rowsTemp.get(i)).getFillVolume() * ((TradeOutLogBean)rowsTemp.get(i)).getPrice();
                        }
                    }
                }
                if (i != rowsTemp.size() - 1) continue;
                averageBuyContract = totolAmountBuyContract / (double)fillVolumeTotalBuyContract;
                averageSellContract = totolAmountSellContract / (double)fillVolumeTotalSellContract;
                fillVolumeTotalBuyContractAll += fillVolumeTotalBuyContract;
                fillVolumeTotalSellContractAll += fillVolumeTotalSellContract;
                totolAmountBuyContractAll += totolAmountBuyContract;
                totolAmountSellContractAll += totolAmountSellContract;
                bContractSumm = new TradeOutLogBean();
                bContractSumm.setAccount("Total");
                bContractSumm.setAverageBuy(averageBuyContract);
                bContractSumm.setTotalFillBuy(fillVolumeTotalBuyContract);
                bContractSumm.setTotolAmountBuy(totolAmountBuyContract);
                bContractSumm.setAverageSell(averageSellContract);
                bContractSumm.setTotalFillSell(fillVolumeTotalSellContract);
                bContractSumm.setTotolAmountSell(totolAmountSellContract);
                TradeOutLog.this.row.add(bContractSumm);
                TradeOutLogBean bContractAllSumm = new TradeOutLogBean();
                bContractAllSumm.setAccount("G.Total");
                bContractAllSumm.setTotalFillBuy(fillVolumeTotalBuyContractAll);
                bContractAllSumm.setTotolAmountBuy(totolAmountBuyContractAll);
                bContractAllSumm.setTotalFillSell(fillVolumeTotalSellContractAll);
                bContractAllSumm.setTotolAmountSell(totolAmountSellContractAll);
                TradeOutLog.this.row.add(bContractAllSumm);
            }
        }
    }

    private class TradeOutLogComparator
    implements Comparator<TradeOutLogBean> {
        int colIndex = 0;
        boolean isAsc = true;
        public static final int indexTotalValue = 14;
        public static final int indexRemaining = 15;

        public TradeOutLogComparator(int colIndex, boolean isAsc) {
            this.colIndex = colIndex;
            this.isAsc = isAsc;
        }

        @Override
        public int compare(TradeOutLogBean b1, TradeOutLogBean b2) {
            int result = 0;
            switch (this.colIndex) {
                case 0: {
                    result = b1.getTrader().compareTo(b2.getTrader());
                    break;
                }
                case 1: {
                    result = b1.getMarket().compareTo(b2.getMarket());
                    break;
                }
                case 2: {
                    result = b1.getScrip().compareTo(b2.getScrip());
                    break;
                }
                case 3: {
                    result = b1.getTime().compareTo(b2.getTime());
                    break;
                }
                case 4: {
                    result = b1.getCounter() < b2.getCounter() ? -1 : (b1.getCounter() > b2.getCounter() ? 1 : 0);
                    break;
                }
                case 5: {
                    result = b1.getOrderNo().compareTo(b2.getOrderNo());
                    break;
                }
                case 6: {
                    result = b1.getType().compareTo(b2.getType());
                    break;
                }
                case 7: {
                    result = b1.getFillVolume() < b2.getFillVolume() ? -1 : (b1.getFillVolume() > b2.getFillVolume() ? 1 : 0);
                    break;
                }
                case 8: {
                    result = b1.getPrice() < b2.getPrice() ? -1 : (b1.getPrice() > b2.getPrice() ? 1 : 0);
                    break;
                }
                case 9: {
                    result = b1.getTicket().compareTo(b2.getTicket());
                    break;
                }
                case 10: {
                    result = b1.getAccount().compareTo(b2.getAccount());
                    break;
                }
                case 11: {
                    result = b1.getAction().compareTo(b2.getAction());
                    break;
                }
                case 12: {
                    result = b1.getFlag().compareTo(b2.getFlag());
                    break;
                }
                case 13: {
                    result = b1.getTotalVolume() < b2.getTotalVolume() ? -1 : (b1.getTotalVolume() > b2.getTotalVolume() ? 1 : 0);
                    break;
                }
                case 14: {
                    result = b1.getTotalValue() < b2.getTotalValue() ? -1 : (b1.getTotalValue() > b2.getTotalValue() ? 1 : 0);
                    break;
                }
                case 15: {
                    int n = b1.getRemaining() < b2.getRemaining() ? -1 : (result = b1.getRemaining() > b2.getRemaining() ? 1 : 0);
                }
            }
            if (!this.isAsc) {
                result = -result;
            }
            return result;
        }
    }
}

