/*
 * Decompiled with CFR 0.152.
 */
package Logs;

import CATALYST.Control.Utilities;
import CATALYST.Socket.EncryptDecrypt;
import Control.JasperFileChooser;
import Control.ReportControl;
import Control.ReportControlEvent;
import Control.ReportControlListener;
import CustomComponent.ForgetMouseListner;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import RendersNModels.WithdrawStatementCellRender;
import Utilities.LogsTC;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.bean.AccountBean;
import common.gui.component.JTextFieldFilter;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.MyColors;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.text.Document;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXDatePicker;
import reports.Jasper_Report;
import reports.Report_WithdrawlStatement;

public class WithdrawStatement
extends JPanel
implements FocusListener,
ReportControlListener,
ActionListener {
    Mediator mediator = Mediator.getInstance();
    String[] columns = new String[]{"Serail No", "Requested Date", "Amount Requested", "Amount Approved", "Withdrawal Mode", "Comments", "Status"};
    HashMap<String, String> map = new HashMap();
    Vector rows = new Vector();
    Vector column = new Vector();
    DefaultTableModel model = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                if (row < 0 || row >= this.getRowCount()) {
                    return "";
                }
                Vector rowVector = (Vector)this.dataVector.elementAt(row);
                return rowVector.elementAt(column);
            }
            catch (Exception e) {
                return "";
            }
        }
    };
    private int rowindex = -1;
    private AutoCompleteSupport autoCom;
    private WithdrawStatementCellRender render = new WithdrawStatementCellRender();
    private LanguageCentre languageCentre = new LanguageCentre();
    Timer timer = new Timer(10, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            WithdrawStatement.this.cbAccountNo.requestFocus();
            WithdrawStatement.this.timer.stop();
        }
    });
    private JButton btnGet;
    private JComboBox cbAccountNo;
    private JComboBox cbName;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblForgetPinCode;
    private JLabel lblMessage;
    private JMenuItem menuCancel;
    private JPopupMenu poopupMenu;
    private ReportControl reportControl1;
    private JTable table;
    private JXDatePicker txtEndDate;
    private JPasswordField txtPinCode;
    private JXDatePicker txtStartDate;
    public String JRXMLFileName = "Withdrawlstatement.jrxml";

    public WithdrawStatement() {
        this.mediator.setWithDrawStatement(this);
        this.initComponents();
        for (int i = 0; i < this.columns.length; ++i) {
            this.column.addElement(this.columns[i]);
        }
        this.model.setDataVector(this.rows, this.column);
        this.table.setModel(this.model);
        this.table.setRowHeight(AppConfig.rowHeight);
        this.table.setDefaultRenderer(Object.class, this.render);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(170);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(170);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(400);
        this.table.getColumnModel().getColumn(6).setPreferredWidth(120);
        JTableHeader header = this.table.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
        this.autoCom = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])LogsTC.accountAll.keySet().toArray()));
        this.autoCom.setStrict(true);
        this.cbAccountNo.addActionListener(this);
        String[] names = new String[LogsTC.accountAll.size()];
        int i = 0;
        for (String key : LogsTC.accountAll.keySet()) {
            AccountBean ac = LogsTC.accountAll.get(key);
            names[i++] = ac.getName();
        }
        this.cbAccountNo.requestFocus();
        this.cbName.setModel(new DefaultComboBoxModel<String>(names));
        this.cbName.addActionListener(this);
        this.txtPinCode.addFocusListener(this);
        this.txtPinCode.setDocument((Document)new JTextFieldFilter("0123456789", 4));
        if (LogCommon.preferredAccount.equalsIgnoreCase("")) {
            this.cbAccountNo.setSelectedItem("");
        } else {
            this.cbAccountNo.setSelectedItem(LogCommon.preferredAccount);
        }
        this.txtStartDate.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.txtEndDate.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.txtStartDate.setDate(new Date(System.currentTimeMillis()));
        this.txtEndDate.setDate(new Date(System.currentTimeMillis()));
        ForgetMouseListner forgetMouseListner = new ForgetMouseListner(this.lblForgetPinCode);
        this.lblForgetPinCode.setForeground(MyColors.ForgotPincodeFG);
        this.lblForgetPinCode.setText("<html>Forgot PIN?</html>");
        this.lblForgetPinCode.addMouseListener(forgetMouseListner);
        this.lblForgetPinCode.setMaximumSize(new Dimension(84, 14));
        this.lblForgetPinCode.setMinimumSize(new Dimension(84, 14));
        this.lblForgetPinCode.setPreferredSize(new Dimension(84, 14));
        this.reportControl1.addListener(this);
        this.map.put("N", "In Process");
        this.map.put("A", "Approved");
        this.map.put("P", "Pending");
        this.map.put("R", "Rejected");
        this.map.put("C", "Cancel");
        this.table.removeColumn(this.table.getColumnModel().getColumn(0));
        this.table.setComponentPopupMenu(this.poopupMenu);
        this.timer.start();
        this.txtPinCode.setText(LogCommon.pinCode);
    }

    public void Update(String input) {
        this.fillWithdrawDetail(input);
    }

    private void fillWithdrawDetail(String result) {
        this.lblMessage.setText(" ");
        this.lblMessage.setIcon(null);
        this.model = (DefaultTableModel)this.table.getModel();
        this.removeAccStatementTable();
        if (result.equalsIgnoreCase("INVALID PIN")) {
            this.lblMessage.setForeground(MyColors.errorMessageFG);
            this.lblMessage.setText("Invalid PIN");
            return;
        }
        if (result.equalsIgnoreCase("NO RECORD(S) FOUND")) {
            this.lblMessage.setForeground(MyColors.successMessageFG);
            this.lblMessage.setText("No record found");
            this.lblMessage.setIcon(null);
            return;
        }
        String[] str = result.split("\\#", -1);
        for (int col = 0; col < str.length - 1; ++col) {
            String[] as;
            if (str[col].length() <= 0 || (as = Utilities.split((String)str[col], (char)';')).length <= 7) continue;
            Vector<String> a = new Vector<String>();
            a.add(as[0]);
            a.add(as[1]);
            a.add(as[2]);
            a.add(as[3]);
            a.add(as[4]);
            a.add(as[5]);
            a.add(as[6]);
            a.add(as[7]);
            a.add(as[8]);
            this.model.addRow(a);
        }
        this.table.setModel(this.model);
        this.lblMessage.setIcon(null);
        this.lblMessage.setText(Util.format0digit((String)(this.model.getRowCount() + "".trim().replaceAll("\\,", ""))) + " Record(s)");
        this.repaint();
    }

    private void removeAccStatementTable() {
        DefaultTableModel model1 = (DefaultTableModel)this.table.getModel();
        int numrows = model1.getRowCount();
        for (int i = 0; i < numrows; ++i) {
            model1.removeRow(0);
        }
    }

    private void initComponents() {
        this.poopupMenu = new JPopupMenu();
        this.menuCancel = new JMenuItem();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.lblMessage = new JLabel();
        this.jLabel2 = new JLabel();
        this.txtPinCode = new JPasswordField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.btnGet = new JButton();
        this.cbAccountNo = new JComboBox();
        this.lblForgetPinCode = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.reportControl1 = new ReportControl();
        this.txtEndDate = new JXDatePicker();
        this.txtStartDate = new JXDatePicker();
        this.jLabel5 = new JLabel();
        this.cbName = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.menuCancel.setIcon(new ImageIcon(this.getClass().getResource("/Images/close16.png")));
        this.menuCancel.setText("Cancel                                ");
        this.menuCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WithdrawStatement.this.menuCancelActionPerformed(evt);
            }
        });
        this.poopupMenu.add(this.menuCancel);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Account");
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[]{"Serial No", "Requested Date", "Amount Requested", "Amount Approved", "Withdrawal Mode", "Comments", "Status"}));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                WithdrawStatement.this.tableMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                WithdrawStatement.this.tableMousePressed(evt);
            }
        });
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                WithdrawStatement.this.tableMouseMoved(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        this.lblMessage.setVerticalAlignment(1);
        this.lblMessage.setFocusable(false);
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("PIN");
        this.txtPinCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WithdrawStatement.this.txtPinCodeActionPerformed(evt);
            }
        });
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("Start Date");
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText("End Date");
        this.btnGet.setIcon(new ImageIcon(this.getClass().getResource("/Images/get.png")));
        this.btnGet.setText("Get");
        this.btnGet.setName("WithdrawStatement -> btnGet");
        this.btnGet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WithdrawStatement.this.btnGetActionPerformed(evt);
            }
        });
        this.cbAccountNo.setEditable(true);
        this.cbAccountNo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                WithdrawStatement.this.cbAccountNoKeyPressed(evt);
            }
        });
        this.lblForgetPinCode.setText("Forgot PIN?");
        this.txtEndDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WithdrawStatement.this.txtEndDateActionPerformed(evt);
            }
        });
        this.txtStartDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WithdrawStatement.this.txtStartDateActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Name");
        this.cbName.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel6.setText("   ");
        this.jLabel7.setText(" ");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.txtStartDate, -2, 110, -2).addGap(10, 10, 10).addComponent(this.jLabel4).addGap(6, 6, 6).addComponent((Component)this.txtEndDate, -2, 110, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnGet).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblForgetPinCode)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(21, 21, 21).addComponent(this.cbAccountNo, -2, 110, -2).addGap(10, 10, 10).addComponent(this.jLabel5, -2, 40, -2).addGap(10, 10, 10).addComponent(this.cbName, -2, 186, -2).addGap(10, 10, 10).addComponent(this.jLabel2, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtPinCode, -2, 48, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reportControl1, -2, -1, -2))).addContainerGap()).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblMessage, -2, 560, -2).addGap(120, 120, 120)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 20, -2).addComponent(this.cbAccountNo, -2, -1, -2).addComponent(this.jLabel5, -2, 20, -2).addComponent(this.cbName, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2, -2, 20, -2).addComponent(this.txtPinCode, -2, -1, -2))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -2, 20, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4, -2, 20, -2).addComponent((Component)this.txtEndDate, -2, -1, -2).addComponent((Component)this.txtStartDate, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnGet).addComponent(this.jLabel6)))).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblForgetPinCode).addComponent(this.jLabel7))))).addComponent(this.reportControl1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 237, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 4, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMessage, -2, 20, -2)));
    }

    private void btnGetActionPerformed(ActionEvent evt) {
        this.getWithdrawalStatement();
    }

    private synchronized void fillTable(String result) {
        this.rows.clear();
        this.table.addNotify();
        if (result == null) {
            return;
        }
        if (result.indexOf("|") >= 0) {
            String[] row = result.split("\\|", -1);
            for (int i = 0; i < row.length; ++i) {
                if (row[i].indexOf(";") < 0) continue;
                String[] col = row[i].split("\\;", -1);
                Vector<String> v = new Vector<String>();
                for (int j = 0; j < col.length; ++j) {
                    if (j == 6) {
                        if (!this.map.containsKey(col[j].toString().toUpperCase())) continue;
                        v.addElement(this.map.get(col[j]));
                        continue;
                    }
                    v.addElement(col[j]);
                }
                this.rows.addElement(v);
            }
        }
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        this.table.addNotify();
    }

    private void txtPinCodeActionPerformed(ActionEvent evt) {
        this.txtStartDate.requestFocus();
    }

    private void cbAccountNoKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.txtPinCode.requestFocus();
        }
    }

    private void menuCancelActionPerformed(ActionEvent evt) {
        int row = this.table.getSelectedRow();
        String status = this.table.getValueAt(row, 5).toString();
        if (!status.equalsIgnoreCase("In Process")) {
            JOptionPane.showMessageDialog(TradeCast.getInstance().frame, "This Withdrawal request cannot be cancelled!");
            return;
        }
        int choice = JOptionPane.showConfirmDialog(TradeCast.getInstance().frame, "Do you want to cancel this withdrawal request?", "Confirmation", 2, 0);
        if (choice == 0) {
            if (status.equalsIgnoreCase("In Process")) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                final String accountNo = this.cbAccountNo.getSelectedItem().toString();
                final String serialNo = this.table.getModel().getValueAt(row, 0).toString();
                String reqDate = this.table.getModel().getValueAt(row, 1).toString().trim();
                Date dd = null;
                try {
                    dd = df.parse(reqDate);
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                    dd = new Date(System.currentTimeMillis());
                }
                final String requestedDate = df.format(dd);
                this.mediator.println(" requestedDate = " + requestedDate);
                new Thread(){

                    @Override
                    public void run() {
                        String result = "";
                        try {
                            Util.setMessage((JLabel)WithdrawStatement.this.lblMessage, (MessageType)MessageType.Loading, (String)"Please wait");
                            WithdrawStatement.this.mediator.println(" Logs.UserID, " + LogCommon.UserID + " accountNo, " + accountNo + " serialNo, " + serialNo + " requestedDate, " + requestedDate + " sending sataus  = C");
                            result = WebService.getInstance().getPort().updateWithdrawalRequest(LogCommon.UserID, accountNo, serialNo, requestedDate, "C", "");
                            if (result.equalsIgnoreCase("Success")) {
                                Util.setMessage((JLabel)WithdrawStatement.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
                                JOptionPane.showMessageDialog(TradeCast.getInstance().frame, "Withdrawal cancellation request has been sent.", "Request submitted", 1);
                                WithdrawStatement.this.getWithdrawalStatement();
                            } else {
                                Util.setMessage((JLabel)WithdrawStatement.this.lblMessage, (MessageType)MessageType.Error, (String)result);
                            }
                        }
                        catch (Exception ex) {
                            Util.setMessage((JLabel)WithdrawStatement.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in submitting cancellation request");
                            Mediator.getInstance().PrintLog(ex, result);
                            ex.printStackTrace();
                        }
                    }
                }.start();
            } else {
                JOptionPane.showMessageDialog(TradeCast.getInstance().frame, "Request can not be cancel!");
            }
        }
    }

    private void tableMousePressed(MouseEvent evt) {
        if (SwingUtilities.isRightMouseButton(evt)) {
            if (this.rowindex < 0) {
                JOptionPane.showMessageDialog(null, "Please select row");
                return;
            }
            this.table.getSelectionModel().setSelectionInterval(this.rowindex, this.rowindex);
        }
    }

    private void tableMouseMoved(MouseEvent evt) {
        this.rowindex = this.table.rowAtPoint(evt.getPoint());
        int row = this.table.rowAtPoint(evt.getPoint());
        if (row != this.render.getRowNo()) {
            this.render.setRowNo(row);
            this.repaint();
        }
    }

    private void txtStartDateActionPerformed(ActionEvent evt) {
        this.txtEndDate.requestFocus();
    }

    private void txtEndDateActionPerformed(ActionEvent evt) {
        this.btnGet.requestFocus();
    }

    private void tableMouseExited(MouseEvent evt) {
        this.render.setRowNo(-1);
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        if (source != this.cbAccountNo && source == this.txtPinCode) {
            this.txtPinCode.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    private void AccountChange() {
        this.cbName.removeActionListener(this);
        this.cbName.setSelectedIndex(this.cbAccountNo.getSelectedIndex());
        this.cbName.addActionListener(this);
        this.txtPinCode.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.cbAccountNo) {
            if (e.getModifiers() == 16) {
                this.AccountChange();
            } else if (e.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
                this.AccountChange();
            }
        } else if (obj == this.cbName) {
            this.cbAccountNo.removeActionListener(this);
            this.cbAccountNo.setSelectedIndex(this.cbName.getSelectedIndex());
            this.cbAccountNo.addActionListener(this);
        }
    }

    @Override
    public void ReportControl_Print(ReportControlEvent e) {
        Report_WithdrawlStatement Report = new Report_WithdrawlStatement(this.JRXMLFileName, this.table.getModel());
        this.SetParamenters((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.PrintReport();
    }

    @Override
    public void ReportControl_Save(ReportControlEvent e) {
        String FileName;
        boolean result;
        Report_WithdrawlStatement Report = new Report_WithdrawlStatement(this.JRXMLFileName, this.table.getModel());
        this.SetParamenters((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Cash Withdrawal Statement-" + MyTime.getInstance().getDate()));
        fc.addAllJasperChoosableFileFilter();
        fc.setAcceptAllFileFilterUsed(false);
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && !(result = Report.Export(FileName = fc.getSelectedFile().getAbsolutePath() + "." + fc.getExtenstion()))) {
            JOptionPane.showMessageDialog(null, "Error in saving file.");
        }
    }

    @Override
    public void ReportControl_Pdf(ReportControlEvent e) {
        int Option;
        String FileName;
        boolean result;
        Report_WithdrawlStatement Report = new Report_WithdrawlStatement(this.JRXMLFileName, this.table.getModel());
        this.SetParamenters((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Cash Withdrawl Statement-" + MyTime.getInstance().getDate()));
        fc.addPdfFileFilter();
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && (result = Report.ExportToPdf(FileName = fc.getSelectedFile().getAbsolutePath().replaceAll("\"", "") + "." + fc.getExtenstion())) && (Option = JOptionPane.showConfirmDialog(null, "Withdraw Statement report created. Do you want to open it?", "PDF", 0)) == 0) {
            try {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + FileName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void ReportControl_View(ReportControlEvent e) {
        Report_WithdrawlStatement Report = new Report_WithdrawlStatement(this.JRXMLFileName, this.table.getModel());
        this.SetParamenters((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.generateReport();
    }

    @Override
    public void ReportControl_CustomExport(ReportControlEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void SetParamenters(Jasper_Report Report) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("PrintDate", MyTime.getInstance().getTimeAndDateForReport());
        param.put("AccountNo", this.cbAccountNo.getSelectedItem());
        param.put("AccountName", this.cbName.getSelectedItem());
        param.put("FromDate", LogsTC.dateFormatAcc.format(this.txtStartDate.getDate()));
        param.put("ToDate", LogsTC.dateFormatAcc.format(this.txtEndDate.getDate()));
        Report.SetParameter(param);
    }

    private void getWithdrawalStatement() {
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        if (this.cbAccountNo.getSelectedItem().toString().length() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select account");
            this.cbAccountNo.requestFocus();
            return;
        }
        if (this.txtPinCode.getText().length() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter PIN");
            this.txtPinCode.requestFocus();
            return;
        }
        if (this.txtEndDate.getDate().compareTo(this.txtStartDate.getDate()) == -1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Start date should grater then OR equal from end date");
            this.txtStartDate.requestFocus();
            return;
        }
        this.rows.clear();
        this.table.addNotify();
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Loading, (String)this.languageCentre.getValue(LanguageConstant.Loading));
        new Thread(){
            String pin;
            String account;
            String startDate;
            String endDate;
            {
                this.pin = EncryptDecrypt.getInstance().EncryptText(String.valueOf(WithdrawStatement.this.txtPinCode.getPassword()));
                this.account = WithdrawStatement.this.cbAccountNo.getSelectedItem().toString();
                this.startDate = LogsTC.dateFormatAcc.format(WithdrawStatement.this.txtStartDate.getDate());
                this.endDate = LogsTC.dateFormatAcc.format(WithdrawStatement.this.txtEndDate.getDate());
            }

            @Override
            public void run() {
                String result = "";
                try {
                    result = WebService.getInstance().getPort().getWithdrawalStatement(LogCommon.UserID, this.pin, this.account, this.startDate, this.endDate, "TradeCast");
                    Mediator.getInstance().println("Withdrawal statement  = " + result);
                    if (result.equalsIgnoreCase("Error")) {
                        Util.setMessage((JLabel)WithdrawStatement.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading Cash Withdrawal Statement");
                    } else if (result.equalsIgnoreCase("Invalid Pincode")) {
                        Util.setMessage((JLabel)WithdrawStatement.this.lblMessage, (MessageType)MessageType.Error, (String)"Invalid PIN");
                    } else if (result.equalsIgnoreCase("NO Record")) {
                        Util.setMessage((JLabel)WithdrawStatement.this.lblMessage, (MessageType)MessageType.Error, (String)"No record Found");
                    } else {
                        WithdrawStatement.this.rows.clear();
                        WithdrawStatement.this.table.addNotify();
                        WithdrawStatement.this.fillTable(result);
                    }
                }
                catch (Exception ex) {
                    Util.setMessage((JLabel)WithdrawStatement.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading Cash Withdrawal Statement");
                    WithdrawStatement.this.mediator.println(ex.toString());
                    WithdrawStatement.this.mediator.PrintLog(ex, result);
                }
            }
        }.start();
    }
}

