/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import MessageWindow.MessageDisplay;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import kse.util.LogsKSE;

public class AnnouncementTabComparator
implements Comparator {
    public static final int idIndex = 0;
    public static final int dateTimeIndex = 1;
    public static final int companyIndex = 2;
    public static final int FYEIndex = 3;
    public static final int scripIndex = 4;
    public static final int dividendIndex = 5;
    public static final int PLBeforeTaxIndex = 6;
    public static final int PLAfterTaxIndex = 7;
    public static final int EPSIndex = 8;
    public static final int AGMIndex = 9;
    public static final int bookClosureIndex = 10;
    public static final int manualEntryIndex = 11;
    public static final int miscIndex = 12;
    public static final int fileDataIndex = 13;
    public static final int isBlinkIndex = 14;
    public static final int isReadIndex = 15;
    public static final int isHyperLink = 16;
    public static final String period = "Period";
    public static final String bookClosureStartDate = "Book Closure Start Date";
    public static final String bookClosureEndDate = "Book Closure End Date";
    public static final String divedend = "Divedend";
    public static final String bonus = "Bonus";
    public static final String right = "Right";
    public static final String discount = "Discount";
    public static final String premium = "Premium";
    protected int m_sortCol;
    protected boolean m_sortAsc;

    public AnnouncementTabComparator(int sortCol, boolean sortAsc) {
        this.m_sortCol = sortCol;
        this.m_sortAsc = sortAsc;
    }

    public int compare(Object o1, Object o2) {
        int result = 0;
        try {
            MessageDisplay ann1 = null;
            MessageDisplay ann2 = null;
            if (o1 instanceof MessageDisplay || o2 instanceof MessageDisplay) {
                ann1 = (MessageDisplay)o1;
                ann2 = (MessageDisplay)o2;
            }
            switch (this.m_sortCol) {
                case 0: {
                    result = ann1.announcement.id.compareTo(ann2.announcement.id);
                    break;
                }
                case 1: {
                    Date d1 = LogsKSE.sdfMessage.parse(ann1.announcement.dateTime);
                    Date d2 = LogsKSE.sdfMessage.parse(ann2.announcement.dateTime);
                    result = d1.compareTo(d2);
                    break;
                }
                case 2: {
                    result = ann1.announcement.company.compareTo(ann2.announcement.company);
                    break;
                }
                case 3: {
                    result = ann1.announcement.FYE.compareTo(ann2.announcement.FYE);
                    break;
                }
                case 4: {
                    result = ann1.announcement.scrip.compareTo(ann2.announcement.scrip);
                    break;
                }
                case 5: {
                    result = ann1.announcement.divedend.compareTo(ann2.announcement.divedend);
                    break;
                }
                case 6: {
                    result = ann1.announcement.PLBeforeTax.compareTo(ann2.announcement.PLBeforeTax);
                    break;
                }
                case 7: {
                    result = ann1.announcement.PLAfterTax.compareTo(ann2.announcement.PLAfterTax);
                    break;
                }
                case 8: {
                    result = ann1.announcement.EPS.compareTo(ann2.announcement.EPS);
                    break;
                }
                case 9: {
                    result = ann1.announcement.AGM.compareTo(ann2.announcement.AGM);
                    break;
                }
                case 10: {
                    result = ann1.announcement.bookClosure.compareTo(ann2.announcement.bookClosure);
                    break;
                }
                case 12: {
                    result = ann1.announcement.misc.compareTo(ann2.announcement.misc);
                    break;
                }
                case 13: {
                    result = ann1.announcement.fileData.compareTo(ann2.announcement.fileData);
                }
            }
            if (!this.m_sortAsc) {
                result = -result;
            }
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

