/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import MessageWindow.MessageDisplay;
import Utilities.LogsTC;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;

public class BoardMeetingComparator
implements Comparator {
    protected int m_sortCol;
    protected boolean m_sortAsc;
    public static final int idIndex = 0;
    public static final int dateTimeIndex = 1;
    public static final int typeIndex = 2;
    public static final int scripIndex = 3;
    public static final int detailIndex = 4;
    public static final int companyNameIndex = 5;
    public static final int isBlinkIndex = 6;
    public static final int isReadIndex = 7;

    public BoardMeetingComparator(int sortCol, boolean sortAsc) {
        this.m_sortCol = sortCol;
        this.m_sortAsc = sortAsc;
    }

    public int compare(Object o1, Object o2) {
        int result = 0;
        try {
            MessageDisplay s1 = null;
            MessageDisplay s2 = null;
            if (o1 instanceof MessageDisplay && o2 instanceof MessageDisplay) {
                s1 = (MessageDisplay)o1;
                s2 = (MessageDisplay)o2;
            }
            switch (this.m_sortCol) {
                case 1: {
                    Date d1 = LogsTC.boardMeetingDateFormat.parse(s1.message.dateTime.value);
                    Date d2 = LogsTC.boardMeetingDateFormat.parse(s2.message.dateTime.value);
                    result = d1.compareTo(d2);
                    break;
                }
                case 3: {
                    result = s1.message.subject.value.compareTo(s2.message.subject.value);
                    break;
                }
                case 5: {
                    result = s1.message.description.value.compareTo(s2.message.description.value);
                    break;
                }
                case 4: {
                    result = s1.message.detail.value.compareTo(s2.message.detail.value);
                }
            }
            if (!this.m_sortAsc) {
                result = -result;
            }
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

