/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import MessageWindow.BoardMeetingScripDetail;
import MessageWindow.BoardMeetingTab;
import Utilities.LogsTC;
import common.gui.util.AppConfig;
import common.gui.util.MyColors;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class BoardMeetingHolder
extends JPanel {
    public static final String treeTitle = "Board Meetings";
    DefaultMutableTreeNode root = new DefaultMutableTreeNode("Board Meetings");
    private BoardMeetingTab boardMeetingTab;
    private BoardMeetingScripDetail boardMeetingScripDetail;
    private JScrollPane jScrollPane1;
    public JTree tree;

    public BoardMeetingHolder(BoardMeetingTab boardMeetingTab) {
        this.initComponents();
        this.boardMeetingTab = boardMeetingTab;
        this.setCommonValues();
    }

    public BoardMeetingHolder(BoardMeetingScripDetail boardMeetingScripDetail) {
        this.initComponents();
        this.boardMeetingScripDetail = boardMeetingScripDetail;
        this.setCommonValues();
    }

    private void setCommonValues() {
        ImageIcon childIcon = new ImageIcon(this.getClass().getResource("/Images/Day.png"));
        ImageIcon ParentIcon = new ImageIcon(this.getClass().getResource("/Images/Week.png"));
        MyRenderer render = new MyRenderer((Icon)childIcon, ParentIcon);
        this.tree.setCellRenderer(render);
        this.tree.setBorder(null);
        render.setTextSelectionColor(Color.BLACK);
        render.setBackgroundSelectionColor(MyColors.MarketWatchSelectedRowColor);
        render.setBorderSelectionColor(MyColors.MarketWatchSelectedRowColor);
        render.setBorder(null);
    }

    public void expandAll() {
        for (int row = 0; row < this.tree.getRowCount(); ++row) {
            this.tree.expandRow(row);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tree = new JTree(this.root);
        this.setBackground(new Color(255, 255, 255));
        this.jScrollPane1.setBorder(null);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BoardMeetingHolder.this.treeMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                BoardMeetingHolder.this.treeMousePressed(evt);
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                BoardMeetingHolder.this.treeValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tree);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 180, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 58, Short.MAX_VALUE));
    }

    private void treeMouseClicked(MouseEvent evt) {
    }

    private void treeMousePressed(MouseEvent evt) {
    }

    private void treeValueChanged(TreeSelectionEvent evt) {
        if (this.tree.getLastSelectedPathComponent() != null) {
            String url = this.tree.getLastSelectedPathComponent().toString();
            if (url.equalsIgnoreCase("Today")) {
                url = LogsTC.boardMeetingDateFormat.format(new Date(System.currentTimeMillis()));
            }
            if (this.boardMeetingTab != null) {
                new Thread(new FilterRow(url)).start();
            }
        }
    }

    class FilterRow
    implements Runnable {
        String url = "";

        public FilterRow(String url) {
            this.url = url;
        }

        @Override
        public void run() {
            BoardMeetingHolder.this.boardMeetingTab.addFilterRow(this.url);
        }
    }

    class MyRenderer
    extends DefaultTreeCellRenderer {
        Icon childlIcon;
        Icon ParentIcon;
        ImageIcon rootIcon = new ImageIcon(this.getClass().getResource("/Images/Meeting16x16.png"));

        public MyRenderer(Icon childlIcon, Icon ParentIcon) {
            this.childlIcon = childlIcon;
            this.ParentIcon = ParentIcon;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setFont(AppConfig.defaultPlanFont);
            if (value != null) {
                if (value.toString().indexOf("Current Week") >= 0 || value.toString().indexOf("Last Week") >= 0 || value.toString().indexOf("Next Week") >= 0 || value.toString().indexOf("Later") >= 0) {
                    this.setIcon(this.ParentIcon);
                    this.setFont(AppConfig.defaultPlanFont);
                    return this;
                }
                if (value.toString().indexOf(BoardMeetingHolder.treeTitle) >= 0) {
                    this.setIcon(this.rootIcon);
                    this.setFont(this.getFont().deriveFont(1));
                    return this;
                }
            }
            if (leaf) {
                this.setIcon(this.childlIcon);
            } else {
                this.setIcon(this.ParentIcon);
            }
            this.setTextSelectionColor(Color.BLACK);
            this.setBackgroundSelectionColor(MyColors.MarketWatchSelectedRowColor);
            this.setBorderSelectionColor(MyColors.MarketWatchSelectedRowColor);
            this.setBorder(null);
            return this;
        }
    }
}

