/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import MessageWindow.MessageDisplay;
import MessageWindow.PMEX_MessageDisplay;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

public class DisplayModel
extends DefaultTableModel {
    private Vector<MessageDisplay> rows;
    private Vector<PMEX_MessageDisplay> rowsPMEX;
    private boolean isCellEditable = false;

    public DisplayModel(Vector<MessageDisplay> v, boolean isCellEditable) {
        this.rows = v;
        this.isCellEditable = isCellEditable;
    }

    public DisplayModel(Vector<PMEX_MessageDisplay> v) {
        this.rowsPMEX = v;
        this.isCellEditable = true;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.isCellEditable;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return String.class;
    }

    @Override
    public Object getValueAt(int row, int column) {
        try {
            if (row < 0 || row >= this.getRowCount()) {
                return "";
            }
            Object rowObject = this.dataVector.elementAt(row);
            if (rowObject instanceof MessageDisplay) {
                return (MessageDisplay)rowObject;
            }
            if (rowObject instanceof PMEX_MessageDisplay) {
                return (PMEX_MessageDisplay)rowObject;
            }
            return "";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        try {
            if (this.rows != null) {
                if (this.rows.size() < 0 || this.rows.size() >= this.getRowCount()) {
                    return;
                }
                MessageDisplay md = this.rows.get(row);
                this.rows.set(row, md);
            } else if (this.rowsPMEX != null) {
                if (this.rowsPMEX.size() < 0 || this.rowsPMEX.size() >= this.getRowCount()) {
                    return;
                }
                PMEX_MessageDisplay md = this.rowsPMEX.get(row);
                this.rowsPMEX.set(row, md);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

