/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import MessageWindow.Feed;
import MessageWindow.FeedMessage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class FeedParser {
    static final String ID = "id";
    static final String GUID = "guid";
    static final String TITLE = "title";
    static final String PUB_DATE = "pubDate";
    static final String DESCRIPTION = "description";
    static final String LINK = "link";
    static final String ITEM = "item";
    static final String ENTERY = "entry";
    static final String PUBLISHED = "published";
    static final String SUMMARY = "summary";
    URL url;

    public void setURL(String feedUrl) {
        try {
            if (feedUrl.trim().equalsIgnoreCase("")) {
                return;
            }
            this.url = new URL(feedUrl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public Feed readFeed() throws UnsupportedOperationException, IOException, XMLStreamException {
        Feed feed = null;
        int st = this.isValidRSS(this.url);
        if (st == 0) {
            feed = this.readAtomFeed();
        } else if (st == 1) {
            feed = this.readChannelFeed();
        }
        return feed;
    }

    private Feed readChannelFeed() {
        Feed feed = null;
        try {
            boolean isFeedHeader = true;
            String description = "";
            String title = "";
            String link = "";
            String pubdate = "";
            String id = "";
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            InputStream in = this.read();
            XMLEventReader eventReader = inputFactory.createXMLEventReader(in);
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                if (event.isStartElement()) {
                    if (event.asStartElement().getName().getLocalPart().equalsIgnoreCase(ITEM)) {
                        if (isFeedHeader) {
                            isFeedHeader = false;
                            feed = new Feed(title, link, description, pubdate, id);
                        }
                        event = eventReader.nextEvent();
                        continue;
                    }
                    if (event.asStartElement().getName().getLocalPart().equalsIgnoreCase(TITLE)) {
                        event = eventReader.nextEvent();
                        try {
                            title = event.asCharacters().getData();
                        }
                        catch (ClassCastException e) {
                            title = "";
                        }
                        continue;
                    }
                    if (event.asStartElement().getName().getLocalPart().equalsIgnoreCase(GUID)) {
                        event = eventReader.nextEvent();
                        try {
                            id = event.asCharacters().getData();
                        }
                        catch (ClassCastException e) {
                            id = "";
                        }
                        continue;
                    }
                    if (event.asStartElement().getName().getLocalPart().equalsIgnoreCase(DESCRIPTION)) {
                        event = eventReader.nextEvent();
                        try {
                            description = event.asCharacters().getData();
                        }
                        catch (ClassCastException e) {
                            description = "";
                        }
                        continue;
                    }
                    if (event.asStartElement().getName().getLocalPart().equalsIgnoreCase(LINK)) {
                        event = eventReader.nextEvent();
                        try {
                            link = event.asCharacters().getData();
                        }
                        catch (ClassCastException e) {
                            link = "";
                        }
                        continue;
                    }
                    if (!event.asStartElement().getName().getLocalPart().equalsIgnoreCase(PUB_DATE)) continue;
                    event = eventReader.nextEvent();
                    try {
                        pubdate = event.asCharacters().getData();
                    }
                    catch (ClassCastException e) {
                        pubdate = "";
                    }
                    continue;
                }
                if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equalsIgnoreCase(ITEM)) continue;
                FeedMessage message = new FeedMessage();
                message.setDescription(description);
                message.setLink(link);
                message.setTitle(title);
                message.setPubDate(pubdate);
                message.setId(id);
                feed.getMessages().add(message);
                event = eventReader.nextEvent();
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return feed;
    }

    public String getDefaultTitle(String url) {
        String dTitle = "";
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            URL url1 = new URL(url);
            InputStream in = url1.openStream();
            XMLEventReader reader = inputFactory.createXMLEventReader(in);
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (!event.isStartElement() || !event.asStartElement().getName().getLocalPart().equalsIgnoreCase(TITLE)) continue;
                event = reader.nextEvent();
                dTitle = event.asCharacters().getData();
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dTitle;
    }

    private Feed readAtomFeed() {
        Feed feed = null;
        try {
            boolean isFeedHeader = true;
            String Entry2 = "";
            String published = "";
            String title = "";
            String summary = "";
            String link = "";
            String id = "";
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            InputStream in = this.read();
            XMLEventReader reader = inputFactory.createXMLEventReader(in);
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.isStartElement()) {
                    if (event.asStartElement().getName().getLocalPart().equalsIgnoreCase(ENTERY)) {
                        if (isFeedHeader) {
                            isFeedHeader = false;
                            feed = new Feed(title, link, summary, published, id);
                        }
                        event = reader.nextEvent();
                        continue;
                    }
                    if (event.asStartElement().getName().getLocalPart().equalsIgnoreCase(ID)) {
                        event = reader.nextEvent();
                        try {
                            id = event.asCharacters().getData();
                        }
                        catch (ClassCastException e) {
                            id = "";
                        }
                        continue;
                    }
                    if (event.asStartElement().getName().getLocalPart().equalsIgnoreCase(TITLE)) {
                        event = reader.nextEvent();
                        try {
                            title = event.asCharacters().getData();
                        }
                        catch (ClassCastException e) {
                            title = "";
                        }
                        continue;
                    }
                    if (event.asStartElement().getName().getLocalPart().equalsIgnoreCase(PUBLISHED)) {
                        event = reader.nextEvent();
                        try {
                            published = event.asCharacters().getData();
                        }
                        catch (ClassCastException e) {
                            published = "";
                        }
                        continue;
                    }
                    if (event.asStartElement().getName().getLocalPart().equalsIgnoreCase(SUMMARY)) {
                        event = reader.nextEvent();
                        try {
                            summary = event.asCharacters().getData();
                        }
                        catch (ClassCastException e) {
                            summary = "";
                        }
                        continue;
                    }
                    if (!event.asStartElement().getName().getLocalPart().equalsIgnoreCase(LINK)) continue;
                    Iterator<Attribute> iterator = event.asStartElement().getAttributes();
                    while (iterator.hasNext()) {
                        String[] str;
                        String st = iterator.next().toString();
                        if (st.indexOf("href") < 0 || (str = st.split("\\'", -1)).length < 1) continue;
                        link = str[1];
                    }
                    continue;
                }
                if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equalsIgnoreCase(ENTERY)) continue;
                FeedMessage message = new FeedMessage();
                message.setDescription(summary);
                message.setLink(link);
                message.setTitle(title);
                message.setPubDate(published);
                message.setId(id);
                feed.getMessages().add(message);
                event = reader.nextEvent();
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return feed;
    }

    private InputStream read() {
        try {
            return this.url.openStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int isValidRSS(URL url) throws IOException, XMLStreamException {
        int isAtom = -1;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        InputStream in = url.openStream();
        XMLEventReader reader2 = inputFactory.createXMLEventReader(in);
        int i = 0;
        while (i <= 4) {
            ++i;
            XMLEvent event = reader2.nextEvent();
            if (!event.isStartElement()) continue;
            if (event.asStartElement().getName().getLocalPart().equalsIgnoreCase("feed")) {
                isAtom = 0;
            }
            if (!event.asStartElement().getName().getLocalPart().equalsIgnoreCase("rss")) continue;
            isAtom = 1;
        }
        return isAtom;
    }

    public static int isValidRSS(String url2) throws IOException, XMLStreamException {
        int isAtom = -1;
        URL url = new URL(url2);
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        InputStream in = url.openStream();
        XMLEventReader reader2 = inputFactory.createXMLEventReader(in);
        int i = 0;
        while (i <= 4) {
            ++i;
            XMLEvent event = reader2.nextEvent();
            if (!event.isStartElement()) continue;
            if (event.asStartElement().getName().getLocalPart().equalsIgnoreCase("feed")) {
                isAtom = 0;
            }
            if (!event.asStartElement().getName().getLocalPart().equalsIgnoreCase("rss")) continue;
            isAtom = 1;
        }
        return isAtom;
    }
}

