/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import Beans.Announcement;
import MessageWindow.AnnouncementLiveTab;
import MessageWindow.AnnouncementScripDetail;
import MessageWindow.AnnouncementTab;
import MessageWindow.BoardMeetingScripDetail;
import MessageWindow.BoardMeetingTab;
import MessageWindow.MarginCallTab;
import MessageWindow.Message;
import MessageWindow.MyTab;
import MessageWindow.RSSMessage;
import MessageWindow.RSSTab;
import MessageWindow.ShowAnnouncementScripDetailSearchResult;
import MessageWindow.ShowAnnouncementSearchResult;
import MessageWindow.ShowMessage;
import MessageWindow.ShowSearchResult;
import MessageWindow.ShowSearchResultScripDetail;
import MyDocking.Mediator;
import MyDocking.MessageWindowCenter;
import MyDocking.TradeCast;
import Utilities.LogsTC;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.LoginMode;
import common.gui.util.MyColors;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.html.HTMLEditorKit;
import kse.gui.bean.MarginCallBean;
import kse.util.LogsKSE;
import languages.LanguageConstant;

public class MessageDisplay
extends JPanel
implements HyperlinkListener {
    JPopupMenu popupMenu = new JPopupMenu();
    JMenuItem selectAll = new JMenuItem("Select All");
    JMenuItem copy = new JMenuItem("Copy");
    JMenuItem markAsRead = new JMenuItem("Mark As Read");
    JMenuItem markAsUnread = new JMenuItem("Mark As Unread");
    public Message message = null;
    public RSSMessage feed = null;
    private JTable table;
    public int totalMsg = 0;
    private Color readColor = Color.LIGHT_GRAY;
    private Color blinkColor = Color.YELLOW;
    private Color RSSreadColor = Color.BLUE;
    private Color RSSunReadColor = Color.CYAN;
    private Color RSSblinkColor = Color.YELLOW;
    String type = "";
    private ShowSearchResult showSearchResult = null;
    private ShowSearchResultScripDetail showSearchResultScripDetail = null;
    private int searchCount;
    public MarginCallBean margin;
    public Announcement announcement;
    private Vector<MessageDisplay> rows = null;
    private String find = "";
    private MyTab myTab = null;
    private ShowAnnouncementSearchResult showAnnouncementSearchResult;
    private ShowAnnouncementScripDetailSearchResult showAnnouncementScripDetailSearchResult;
    private AnnouncementScripDetail announcementScripDetail;
    private AnnouncementTab announcementTab;
    private AnnouncementLiveTab announcementLiveTab;
    private int totalMessage;
    private MarginCallTab marginCallTab;
    private static ShowMessage newsShowMessage;
    private static ShowMessage boardShowMessage;
    private static ShowMessage houseShowMessage;
    private static ShowMessage announcementShowMessage;
    private static ShowMessage marginShowMessage;
    private BoardMeetingTab boardMeetingTab;
    private BoardMeetingScripDetail boardMeetingScripDetail;
    public JEditorPane editorPane;
    private JLabel lblMore;

    public MessageDisplay(MyTab myTab, Message m, JTable table, String type, Vector<MessageDisplay> rows) {
        DocumentListener[] listeners;
        this.rows = rows;
        this.myTab = myTab;
        this.SetValue(m, table, type);
        AbstractDocument doc = (AbstractDocument)this.editorPane.getDocument();
        for (DocumentListener documentListener : listeners = doc.getDocumentListeners()) {
            if (!documentListener.getClass().getName().equals("javax.swing.text.DefaultCaret$Handler")) continue;
            doc.removeDocumentListener(documentListener);
        }
        this.setText();
    }

    public MessageDisplay(ShowSearchResult sp, Message m, JTable table, String type, int count, Vector<MessageDisplay> rows, String find) {
        DocumentListener[] listeners;
        this.showSearchResult = sp;
        this.searchCount = count;
        this.rows = rows;
        this.find = find;
        this.SetValue(m, table, type);
        this.setTextSearch(true);
        AbstractDocument doc = (AbstractDocument)this.editorPane.getDocument();
        for (DocumentListener documentListener : listeners = doc.getDocumentListeners()) {
            if (!documentListener.getClass().getName().equals("javax.swing.text.DefaultCaret$Handler")) continue;
            doc.removeDocumentListener(documentListener);
        }
    }

    public MessageDisplay(ShowSearchResultScripDetail showSearchResultScripDetail, Message m, JTable table, String type, int count, Vector<MessageDisplay> rows, String find) {
        DocumentListener[] listeners;
        this.showSearchResultScripDetail = showSearchResultScripDetail;
        this.searchCount = count;
        this.rows = rows;
        this.find = find;
        this.SetValue(m, table, type);
        this.setTextSearch(true);
        AbstractDocument doc = (AbstractDocument)this.editorPane.getDocument();
        for (DocumentListener documentListener : listeners = doc.getDocumentListeners()) {
            if (!documentListener.getClass().getName().equals("javax.swing.text.DefaultCaret$Handler")) continue;
            doc.removeDocumentListener(documentListener);
        }
    }

    public MessageDisplay(MarginCallTab marginCallTab, MarginCallBean m, JTable table, String type, Vector<MessageDisplay> rows) {
        DocumentListener[] listeners;
        this.marginCallTab = marginCallTab;
        this.margin = m;
        this.table = table;
        this.rows = rows;
        this.type = type;
        this.initComponent();
        this.editorPane.setContentType("text/html");
        this.lblMore.setCursor(Cursor.getPredefinedCursor(12));
        this.editorPane.addHyperlinkListener(this);
        this.lblMore.setVisible(false);
        this.setMarginCallText(false);
        AbstractDocument doc = (AbstractDocument)this.editorPane.getDocument();
        for (DocumentListener documentListener : listeners = doc.getDocumentListeners()) {
            if (!documentListener.getClass().getName().equals("javax.swing.text.DefaultCaret$Handler")) continue;
            doc.removeDocumentListener(documentListener);
        }
    }

    public MessageDisplay(ShowAnnouncementSearchResult showAnnouncementSearchResult, AnnouncementTab announcementTab, Announcement announcement, JTable table, Vector<MessageDisplay> rows, String find, int totalMessage) {
        DocumentListener[] listeners;
        this.table = table;
        this.announcement = announcement;
        this.announcementTab = announcementTab;
        this.showAnnouncementSearchResult = showAnnouncementSearchResult;
        this.rows = rows;
        this.find = find;
        this.totalMessage = totalMessage;
        this.initComponent();
        this.lblMore.setCursor(Cursor.getPredefinedCursor(12));
        this.editorPane.addHyperlinkListener(this);
        AbstractDocument doc = (AbstractDocument)this.editorPane.getDocument();
        for (DocumentListener documentListener : listeners = doc.getDocumentListeners()) {
            if (!documentListener.getClass().getName().equals("javax.swing.text.DefaultCaret$Handler")) continue;
            doc.removeDocumentListener(documentListener);
        }
        this.setPopupMenuForAnnouncements();
        this.setAnnouncementText(true, totalMessage);
    }

    public MessageDisplay(ShowAnnouncementSearchResult showAnnouncementSearchResult, AnnouncementLiveTab announcementLiveTab, Announcement announcement, JTable table, Vector<MessageDisplay> rows, String find, int totalMessage) {
        DocumentListener[] listeners;
        this.table = table;
        this.announcement = announcement;
        this.announcementLiveTab = announcementLiveTab;
        this.showAnnouncementSearchResult = showAnnouncementSearchResult;
        this.rows = rows;
        this.find = find;
        this.totalMessage = totalMessage;
        this.initComponent();
        this.lblMore.setCursor(Cursor.getPredefinedCursor(12));
        this.editorPane.addHyperlinkListener(this);
        AbstractDocument doc = (AbstractDocument)this.editorPane.getDocument();
        for (DocumentListener documentListener : listeners = doc.getDocumentListeners()) {
            if (!documentListener.getClass().getName().equals("javax.swing.text.DefaultCaret$Handler")) continue;
            doc.removeDocumentListener(documentListener);
        }
        this.setPopupMenuForAnnouncements();
        this.setAnnouncementText(true, totalMessage);
    }

    public MessageDisplay(ShowAnnouncementScripDetailSearchResult showAnnouncementSearchResult, AnnouncementScripDetail announcementTab, Announcement announcement, JTable table, Vector<MessageDisplay> rows, String find, int totalMessage) {
        DocumentListener[] listeners;
        this.table = table;
        this.announcement = announcement;
        this.announcementScripDetail = announcementTab;
        this.showAnnouncementScripDetailSearchResult = showAnnouncementSearchResult;
        this.rows = rows;
        this.find = find;
        this.totalMessage = totalMessage;
        this.initComponents();
        this.lblMore.setCursor(Cursor.getPredefinedCursor(12));
        this.editorPane.addHyperlinkListener(this);
        AbstractDocument doc = (AbstractDocument)this.editorPane.getDocument();
        for (DocumentListener documentListener : listeners = doc.getDocumentListeners()) {
            if (!documentListener.getClass().getName().equals("javax.swing.text.DefaultCaret$Handler")) continue;
            doc.removeDocumentListener(documentListener);
        }
        this.setPopupMenuForAnnouncements();
        this.setAnnouncementText(true, totalMessage);
    }

    public MessageDisplay(RSSMessage m) {
        DocumentListener[] listeners;
        this.feed = m;
        this.totalMsg = LogsKSE.RSSMsgCount;
        this.RSSreadColor = MyColors.RSSReadBG;
        this.RSSunReadColor = MyColors.RSSUnReadBG;
        this.initComponent();
        this.editorPane.setContentType("text/html");
        this.lblMore.setCursor(Cursor.getPredefinedCursor(12));
        this.lblMore.setText("open in browser... ");
        this.editorPane.addHyperlinkListener(this);
        ++RSSTab.RssCounter;
        this.RSS_setRSSText();
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editorPane, GroupLayout.Alignment.TRAILING, -1, 188, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.lblMore, -2, 93, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.editorPane, -2, 15, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMore)));
        AbstractDocument doc = (AbstractDocument)this.editorPane.getDocument();
        for (DocumentListener documentListener : listeners = doc.getDocumentListeners()) {
            if (!documentListener.getClass().getName().equals("javax.swing.text.DefaultCaret$Handler")) continue;
            doc.removeDocumentListener(documentListener);
        }
    }

    public MessageDisplay(BoardMeetingTab boardMeetingTab, Message m, JTable table, String type, Vector<MessageDisplay> rows, String find) {
        DocumentListener[] listeners;
        this.rows = rows;
        this.boardMeetingTab = boardMeetingTab;
        this.find = find;
        this.SetValue(m, table, type);
        this.setBoardMeetingText(true);
        AbstractDocument doc = (AbstractDocument)this.editorPane.getDocument();
        for (DocumentListener documentListener : listeners = doc.getDocumentListeners()) {
            if (!documentListener.getClass().getName().equals("javax.swing.text.DefaultCaret$Handler")) continue;
            doc.removeDocumentListener(documentListener);
        }
    }

    public MessageDisplay(BoardMeetingScripDetail boardMeetingScripDetail, Message m, JTable table, String type, Vector<MessageDisplay> rows, String find) {
        DocumentListener[] listeners;
        this.rows = rows;
        this.boardMeetingScripDetail = boardMeetingScripDetail;
        this.find = find;
        this.SetValue(m, table, type);
        this.setBoardMeetingText(true);
        AbstractDocument doc = (AbstractDocument)this.editorPane.getDocument();
        for (DocumentListener documentListener : listeners = doc.getDocumentListeners()) {
            if (!documentListener.getClass().getName().equals("javax.swing.text.DefaultCaret$Handler")) continue;
            doc.removeDocumentListener(documentListener);
        }
    }

    private void SetValue(Message m, JTable table, String type) {
        this.table = table;
        this.message = m;
        this.type = type;
        if (type.equalsIgnoreCase(LanguageConstant.News)) {
            this.totalMsg = LogsKSE.newsMsgCount;
            this.readColor = MyColors.newsReadBG;
        } else if (type.equalsIgnoreCase("Commodity News")) {
            this.totalMsg = LogsKSE.newsPMEXMsgCount;
            this.readColor = MyColors.newsReadBG;
        } else if (type.equalsIgnoreCase("BOARD_MEETING")) {
            this.totalMsg = LogsKSE.boardMsgCount;
            this.readColor = MyColors.boardReadBG;
        } else if (type.equalsIgnoreCase("HOUSE_MESSAGE")) {
            this.totalMsg = LogsKSE.houseMsgCount;
            this.readColor = MyColors.houseReadBG;
        } else if (type.equalsIgnoreCase("Board_Meetings")) {
            this.totalMsg = this.boardMeetingScripDetail != null ? BoardMeetingScripDetail.totalMessage : LogsKSE.boardMsgCount2;
            this.readColor = MyColors.boardReadBG;
        }
        this.initComponent();
        this.editorPane.setContentType("text/html");
        this.lblMore.setCursor(Cursor.getPredefinedCursor(12));
        this.editorPane.addHyperlinkListener(this);
        this.setPopupMenu();
    }

    private void setPopupMenu() {
        this.markAsRead.setIcon(new ImageIcon(this.getClass().getResource("/Images/markRead.png")));
        this.markAsRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageDisplay.this.markAsRead();
            }
        });
        this.markAsUnread.setIcon(new ImageIcon(this.getClass().getResource("/Images/markUnread.png")));
        this.markAsUnread.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageDisplay.this.markAsUnread();
            }
        });
        this.selectAll.setIcon(new ImageIcon(this.getClass().getResource("/Images/paste.png")));
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageDisplay.this.editorPane.selectAll();
            }
        });
        this.copy.setIcon(new ImageIcon(this.getClass().getResource("/Images/paste.png")));
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Util.setClipboard((String)MessageDisplay.this.editorPane.getSelectedText());
            }
        });
        this.popupMenu.add(this.markAsRead);
        this.popupMenu.add(this.markAsUnread);
    }

    public void setColor(boolean status) {
        if (this.message != null) {
            if (status && this.message.isRead) {
                String color = Integer.toHexString(this.blinkColor.getRGB() & 0xFFFFFF);
                this.setTextRead(color);
            } else if (status && !this.message.isRead) {
                String color = Integer.toHexString(this.blinkColor.getRGB() & 0xFFFFFF);
                this.setTextUnRead(color);
            } else if (this.message.isRead) {
                String color = Integer.toHexString(this.readColor.getRGB() & 0xFFFFFF);
                this.setTextRead(color);
            } else {
                String color = Integer.toHexString(this.readColor.getRGB() & 0xFFFFFF);
                this.setTextUnRead(color);
            }
        }
    }

    private void setText() {
        if (this.message != null) {
            if (this.message.isRead) {
                this.setTextRead(true);
            } else {
                this.setTextUnRead(true);
            }
        }
    }

    public void setTextUpdated() {
        if (this.type.equalsIgnoreCase(LanguageConstant.News)) {
            this.totalMsg = LogsKSE.newsMsgCount;
        } else if (this.type.equalsIgnoreCase("Commodity News")) {
            this.totalMsg = LogsKSE.newsPMEXMsgCount;
        } else if (this.type.equalsIgnoreCase("BOARD_MEETING")) {
            this.totalMsg = LogsKSE.boardMsgCount;
        } else if (this.type.equalsIgnoreCase("HOUSE_MESSAGE")) {
            this.totalMsg = LogsKSE.houseMsgCount;
        }
        if (this.message != null) {
            if (this.message.isRead) {
                if (!this.find.equalsIgnoreCase("")) {
                    this.setTextSearch(false);
                } else {
                    this.setTextRead(false);
                }
            } else if (!this.find.equalsIgnoreCase("")) {
                this.setTextSearch(false);
            } else {
                this.setTextUnRead(false);
            }
        }
    }

    public void setBoardMeetingText(boolean isNewLine) {
        if (this.message != null) {
            if (this.message.isRead) {
                this.setBoardMeetingTextRead(isNewLine);
            } else {
                this.setBoardMeetingTextUnRead(isNewLine);
            }
        }
    }

    private void setBoardMeetingTextRead(boolean isNewLine) {
        if (isNewLine && this.message != null) {
            this.message.msgNo = this.table.getRowCount() + 1;
        }
        int totalCount = 0;
        if (this.find == null) {
            if (this.boardMeetingScripDetail != null) {
                this.totalMsg = BoardMeetingScripDetail.totalMessage;
                totalCount = BoardMeetingScripDetail.totalMessage;
            } else {
                this.totalMsg = LogsKSE.boardMsgCount2;
                totalCount = LogsKSE.boardMsgCount2;
            }
        } else {
            totalCount = BoardMeetingTab.totalMessage;
        }
        String color = Integer.toHexString(this.readColor.getRGB() & 0xFFFFFF);
        String HtmlText = "<html><table border=0px CELLPADDING='-1' width='100%' height='100px'><tr width='100%' COLOR='#373737' BGColor='#" + color + "'><td width='92%' style='margin:2px; padding-left:2px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b><a href='' style='color:#373737; text-decoration:none'>" + MessageDisplay.HightLight(this.message.subject.value.trim(), this.find) + " (" + MessageDisplay.HightLight(this.message.description.value.trim(), this.find) + ")</a></b></font></td><td width='8%' nowrap='nowrap' color='#000000' valign=top style='text-align:right; padding-top:3px; padding-right:3px;'><font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + this.message.dateTime.value.trim() + " | " + Util.format0digit((String)(this.message.msgNo + "")) + " of " + Util.format0digit((String)(totalCount + "")) + "</td></tr><tr ><td colspan=2 style='margin:2px; padding-left:2px; padding-top:2px;'><div style='overflow:hidden; height:38px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'>" + MessageDisplay.HightLight(this.message.detail.value.trim(), this.find) + "</font></div></td></tr></table></html>";
        this.editorPane.setText(HtmlText);
        this.editorPane.setCaretPosition(0);
    }

    private void setBoardMeetingTextUnRead(boolean isNewLine) {
        if (isNewLine && this.message != null) {
            this.message.msgNo = this.table.getRowCount() + 1;
        }
        int totalCount = 0;
        if (this.find == null) {
            if (this.boardMeetingScripDetail != null) {
                this.totalMsg = BoardMeetingScripDetail.totalMessage;
                totalCount = BoardMeetingScripDetail.totalMessage;
            } else {
                this.totalMsg = LogsKSE.boardMsgCount2;
                totalCount = LogsKSE.boardMsgCount2;
            }
        } else {
            totalCount = BoardMeetingTab.totalMessage;
        }
        String color = Integer.toHexString(this.readColor.getRGB() & 0xFFFFFF);
        if (this.message != null) {
            String HtmlText = "<html><table border=0px CELLPADDING='-1' width='100%' height='100px'><tr COLOR='#373737' BGColor='#" + color + "'><td width='92%' style='margin:2px; padding-left:2px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b><a href='' style='color:#373737; text-decoration:none'>" + MessageDisplay.HightLight(this.message.subject.value, this.find) + " (" + MessageDisplay.HightLight(this.message.description.value, this.find) + ")</a></b></font></td><td width='8%' nowrap='nowrap' color='#000000' valign=top style='text-align:right; padding-top:3px; padding-right:3px;'><font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + this.message.dateTime.value + " | " + Util.format0digit((String)(this.message.msgNo + "")) + " of " + Util.format0digit((String)(totalCount + "")) + "</font></td></tr><tr ><td colspan=2 style=' margin:2px; padding-left:2px; padding-top:2px;'><div style='overflow:hidden; height:38px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b>" + MessageDisplay.HightLight(this.message.detail.value, this.find) + "</b></font></div></td></tr></table></html>";
            this.editorPane.setText(HtmlText);
            this.editorPane.setCaretPosition(0);
        }
    }

    private void setTextRead(boolean isNewLine) {
        if (isNewLine && this.message != null) {
            this.message.msgNo = this.table.getRowCount() + 1;
        }
        String color = Integer.toHexString(this.readColor.getRGB() & 0xFFFFFF);
        if (this.message != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            sb.append("<table border=0px CELLPADDING='-1' width='100%' height='100px'>");
            sb.append("<tr width='100%' COLOR='#373737' BGColor='#" + color + "'>");
            sb.append("<td width='92%' style='margin:2px; padding-left:2px;'>");
            sb.append("<font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'>");
            sb.append("<b>");
            sb.append("<a href='' style='color:#373737; text-decoration:none'>" + this.message.subject.value.trim());
            if (this.message.description.value.trim().length() > 0) {
                sb.append(" (" + this.message.description.value.trim() + ")");
            }
            sb.append("</a>");
            sb.append("</b>");
            sb.append("</font>");
            sb.append("</td>");
            sb.append("<td width='8%' nowrap='nowrap' color='#000000' valign=top style='text-align:right; padding-top:3px; padding-right:3px;'>");
            sb.append("<font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + this.message.dateTime.value.trim() + " | " + Util.format0digit((String)(this.message.msgNo + "")) + " of " + Util.format0digit((String)(this.totalMsg + "")) + "</td>");
            sb.append("</tr>");
            sb.append("<tr >");
            sb.append("<td colspan=2 style='margin:2px; padding-left:2px; padding-top:2px;'><div style='overflow:hidden; height:38px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'>" + this.message.detail.value.trim() + "</font></div></td>");
            sb.append("</tr>");
            sb.append("</table>");
            sb.append("</html>");
            this.editorPane.setText(sb.toString());
        }
    }

    private void setTextUnRead(boolean isNewLine) {
        if (isNewLine && this.message != null) {
            this.message.msgNo = this.table.getRowCount() + 1;
        }
        String color = Integer.toHexString(this.readColor.getRGB() & 0xFFFFFF);
        if (this.message != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            sb.append("<table border=0px CELLPADDING='-1' width='100%' height='100px'>");
            sb.append("<tr COLOR='#373737' BGColor='#").append(color).append("'>");
            sb.append("<td width='92%' style='margin:2px; padding-left:2px;'>");
            sb.append("<font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'>");
            sb.append("<b>");
            sb.append("<a href='' style='color:#373737; text-decoration:none'>").append(this.message.subject.value);
            if (this.message.description.value.trim().length() > 0) {
                sb.append(" (").append(this.message.description.value).append(")");
            }
            sb.append("</a>");
            sb.append("</b>");
            sb.append("</font>");
            sb.append("</td>");
            sb.append("<td width='8%' nowrap='nowrap' color='#000000' valign=top style='text-align:right; padding-top:3px; padding-right:3px;'>");
            sb.append("<font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + this.message.dateTime.value + " | " + Util.format0digit((String)(this.message.msgNo + "")) + " of " + Util.format0digit((String)(this.totalMsg + "")) + "</font></td>");
            sb.append("</tr>");
            sb.append("<tr >");
            sb.append("<td colspan=2 style=' margin:2px; padding-left:2px; padding-top:2px;'><div style='overflow:hidden; height:38px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b>" + this.message.detail.value + "</b></font></div></td>");
            sb.append("</tr>");
            sb.append("</table>");
            sb.append("</html>");
            this.editorPane.setText(sb.toString());
        }
    }

    private void setTextRead(String color) {
        if (this.message != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            sb.append("<table border=0px CELLPADDING='-1' width='100%' height='100px'>");
            sb.append("<tr COLOR='#373737' BGColor='#" + color + "'>");
            sb.append("<td width='92%' style='margin:2px; padding-left:2px;'>");
            sb.append("<font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b><a href='' style='color:#373737; text-decoration:none'>" + this.message.subject.value);
            if (this.message.description.value.trim().length() > 0) {
                sb.append(" (" + this.message.description.value + ")");
            }
            sb.append("</a></b></font></td>");
            sb.append("<td width='8%' nowrap='nowrap' color='#000000' valign=top style='text-align:right; padding-top:3px; padding-right:3px;'>");
            sb.append("<font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + this.message.dateTime.value + " | " + Util.format0digit((String)(this.message.msgNo + "")) + " of " + Util.format0digit((String)(this.totalMsg + "")) + "</font></td>");
            sb.append("</tr>");
            sb.append("<tr >");
            sb.append("<td colspan=2 style=' margin:2px; padding-left:2px; padding-top:2px;'><div style='overflow:hidden; height:38px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'>" + this.message.detail.value + "</font></div></td>");
            sb.append("</tr>");
            sb.append("</table>");
            sb.append("</html>");
            this.editorPane.setText(sb.toString());
        }
    }

    private void setTextSearch(boolean st) {
        if (this.message != null) {
            if (this.message.isRead) {
                this.setTextReadSearch(st);
            } else {
                this.setTextUnReadSearch(st);
            }
        }
    }

    private void setTextReadSearch(boolean isNewLine) {
        if (isNewLine && this.message != null) {
            this.message.msgNo = this.table.getRowCount() + 1;
        }
        String color = Integer.toHexString(this.readColor.getRGB() & 0xFFFFFF);
        if (this.message != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            sb.append("<table border=0px CELLPADDING='-1' width='100%' height='100px'>");
            sb.append("<tr COLOR='#373737' BGColor='#" + color + "'>");
            sb.append("<td width='92%' style='margin:2px; padding-left:2px;'>");
            sb.append("<font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'>");
            sb.append("<b>");
            sb.append("<a href='' style='color:#373737; text-decoration:none'>" + MessageDisplay.HightLight(this.message.subject.value, this.find));
            if (this.message.description.value.trim().length() > 0) {
                sb.append(" (" + MessageDisplay.HightLight(this.message.description.value, this.find) + ")");
            }
            sb.append("</a>");
            sb.append("</b>");
            sb.append("</font>");
            sb.append("</td>");
            sb.append("<td width='8%' nowrap='nowrap' color='#000000' valign=top style='text-align:right; padding-top:3px; padding-right:3px;'>");
            sb.append("<font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + this.message.dateTime.value + " | " + Util.format0digit((String)(this.message.msgNo + "")) + " of " + Util.format0digit((String)(this.searchCount + "")) + "</font></td>");
            sb.append("</tr>");
            sb.append("<tr >");
            sb.append("<td colspan=2 style=' margin:2px; padding-left:2px; padding-top:2px;'><div style='overflow:hidden; height:38px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'>" + MessageDisplay.HightLight(this.message.detail.value, this.find) + "</font></div></td>");
            sb.append("</tr>");
            sb.append("</table>");
            sb.append("</html>");
            this.editorPane.setText(sb.toString());
        }
    }

    private void setTextUnReadSearch(boolean isNewLine) {
        if (isNewLine && this.message != null) {
            this.message.msgNo = this.table.getRowCount() + 1;
        }
        if (this.message != null) {
            String color = Integer.toHexString(this.readColor.getRGB() & 0xFFFFFF);
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            sb.append("<table border=0px CELLPADDING='-1' width='100%' height='100px'>");
            sb.append("<tr COLOR='#373737' BGColor='#" + color + "'>");
            sb.append("<td width='92%' style='margin:2px; padding-left:2px;'>");
            sb.append("<font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'>");
            sb.append("<b>");
            sb.append("<a href='' style='color:#373737; text-decoration:none'>" + MessageDisplay.HightLight(this.message.subject.value, this.find));
            if (this.message.description.value.trim().length() > 0) {
                sb.append(" (" + MessageDisplay.HightLight(this.message.description.value, this.find) + ")");
            }
            sb.append("</a></b></font></td>");
            sb.append("<td width='8%' nowrap='nowrap' color='#000000' valign=top style='text-align:right; padding-top:3px; padding-right:3px;'>");
            sb.append("<font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + this.message.dateTime.value + " | " + Util.format0digit((String)(this.message.msgNo + "")) + " of " + Util.format0digit((String)(this.searchCount + "")) + "</font></td>");
            sb.append("</tr>");
            sb.append("<tr >");
            sb.append("<td colspan=2 style=' margin:2px; padding-left:2px; padding-top:2px;'><div style='overflow:hidden; height:38px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b>" + MessageDisplay.HightLight(this.message.detail.value, this.find) + "</b></font></div></td>");
            sb.append("</tr>");
            sb.append("</table>");
            sb.append("</html>");
            this.editorPane.setText(sb.toString());
        }
    }

    private void setTextUnRead(String color) {
        if (this.message != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            sb.append("<table border=0px CELLPADDING='-1' width='100%' height='100px'>");
            sb.append("<tr COLOR='#373737' BGColor='#" + color + "'>");
            sb.append("<td width='92%' style='margin:2px; padding-left:2px;'>");
            sb.append("<font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b>");
            sb.append("<a href='' style='color:#373737; text-decoration:none'>" + this.message.subject.value);
            if (this.message.description.value.trim().length() > 0) {
                sb.append(" (" + this.message.description.value + ")");
            }
            sb.append("</a></b></font></td>");
            sb.append("<td width='8%' nowrap='nowrap' color='#000000' valign=top style='text-align:right; padding-top:3px; padding-right:3px;'>");
            sb.append("<font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + this.message.dateTime.value + " | " + Util.format0digit((String)(this.message.msgNo + "")) + " of " + Util.format0digit((String)(this.totalMsg + "")) + "</font></td>");
            sb.append("</tr>");
            sb.append("<tr >");
            sb.append("<td colspan=2 style=' margin:2px; padding-left:2px; padding-top:2px;'><div style='overflow:hidden; height:38px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b>" + this.message.detail.value + "</b></font></div></td>");
            sb.append("</tr>");
            sb.append("</table>");
            sb.append("</html>");
            this.editorPane.setText(sb.toString());
        }
    }

    public void setRSSTextUnReadUpdated(int count, int size) {
        String color = Integer.toHexString(this.RSSunReadColor.getRGB() & 0xFFFFFF);
        if (this.feed != null) {
            String HtmlText = "<html><table border=0px CELLPADDING='-1' width='100%' height='100px'><tr COLOR='#373737' BGColor='#" + color + "'><td width='92%' style='margin:2px; padding-left:2px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b><a href='' style='color:#373737; text-decoration:none'>" + this.feed.title.value + "</a></b></font></td><td width='8%' nowrap='nowrap' color='#' valign=top style='text-align:right;'><font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + Util.format0digit((String)(count + "")) + " of " + Util.format0digit((String)(size + "")) + "</font></td></tr><tr color='#000000'><td colspan=2 style='margin:2px; padding-left:2px; padding-top:2px;'><font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + this.feed.pubDate.value + "</font></td></tr><tr ><td colspan=2 style=' margin:2px; padding-left:2px; padding-top:2px;'><div style='overflow:hidden; height:38px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b>" + this.feed.summary.value + "</b></font></div></td></tr></table></html>";
            this.editorPane.setText(HtmlText);
        }
    }

    private void initComponents() {
        this.editorPane = new JEditorPane();
        this.editorPane.setContentType("text/html");
        this.editorPane.setEditorKit(new HTMLEditorKit());
        this.lblMore = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.editorPane.setEditable(false);
        this.editorPane.setText("hjgkh kjgjkg kjgk kjgk kjgk kjgk gkgk kjg kujhgikg kg kgk k jgkjgk gkjg kjg");
        this.editorPane.setMaximumSize(new Dimension(500, 200));
        this.editorPane.setMinimumSize(new Dimension(106, 200));
        this.editorPane.setName("editorPane");
        this.editorPane.setPreferredSize(new Dimension(500, 200));
        this.editorPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MessageDisplay.this.editorPaneMousePressed(evt);
            }
        });
        this.lblMore.setForeground(new Color(153, 153, 153));
        this.lblMore.setHorizontalAlignment(4);
        this.lblMore.setText("more... ");
        this.lblMore.setName("lblMore");
        this.lblMore.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                MessageDisplay.this.lblMoreMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                MessageDisplay.this.lblMoreMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                MessageDisplay.this.lblMoreMousePressed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editorPane, GroupLayout.Alignment.TRAILING, -1, 188, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.lblMore, -2, 40, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.editorPane, -2, 15, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMore)));
    }

    private void editorPaneMousePressed(MouseEvent evt) {
        if (this.myTab != null) {
            this.myTab.stopBlink(this.message.id.value);
        }
        if (this.boardMeetingTab != null) {
            this.boardMeetingTab.stopBlink(this.message.id.value);
        }
        if (this.announcementTab != null) {
            this.announcementTab.stopBlink(this.announcement.id);
        }
        if (this.marginCallTab != null) {
            this.marginCallTab.stopBlink(this.marginCallTab.getRowNo(this.margin.account));
        }
        if (SwingUtilities.isRightMouseButton(evt)) {
            if (this.editorPane.getSelectedText() == null) {
                this.copy.setEnabled(false);
            } else {
                this.copy.setEnabled(true);
            }
            if (this.message != null) {
                if (this.message.isRead) {
                    this.markAsRead.setEnabled(false);
                    this.markAsUnread.setEnabled(true);
                } else {
                    this.markAsRead.setEnabled(true);
                    this.markAsUnread.setEnabled(false);
                }
            } else if (this.announcement != null) {
                if (this.announcement.isRead) {
                    this.markAsRead.setEnabled(false);
                    this.markAsUnread.setEnabled(true);
                } else {
                    this.markAsRead.setEnabled(true);
                    this.markAsUnread.setEnabled(false);
                }
            }
            this.popupMenu.show(this.editorPane, evt.getX(), evt.getY());
        }
    }

    private void lblMoreMousePressed(MouseEvent evt) {
        this.showPopup();
    }

    private void lblMoreMouseEntered(MouseEvent evt) {
        this.lblMore.setForeground(MyColors.tabPaneselectedForeground);
    }

    private void lblMoreMouseExited(MouseEvent evt) {
        this.lblMore.setForeground(new Color(153, 153, 153));
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (e.getDescription().indexOf("http://") == 0 || e.getDescription().indexOf("https://") == 0) {
                MessageWindowCenter.openAnnouncementLink(e, this.announcement, e.getDescription());
            } else {
                this.showPopup();
            }
        }
    }

    private void showPopup() {
        if (this.message != null) {
            this.message.isRead = true;
            this.setRead(true, this.message.id.value);
            if (this.type.equalsIgnoreCase("Board_Meetings")) {
                this.setBoardMeetingText(false);
            } else if (!this.find.equalsIgnoreCase("")) {
                this.setTextSearch(false);
            } else {
                this.setTextRead(false);
            }
            if (this.showSearchResult != null) {
                if (this.showSearchResult.myTab != null) {
                    if (LanguageConstant.News.equalsIgnoreCase(this.message.type.value)) {
                        if (newsShowMessage != null) {
                            newsShowMessage.dispose();
                        }
                        newsShowMessage = new ShowMessage(this.myTab, TradeCast.getInstance().frame, this.message, this.message.type.value, this, this.rows);
                        LogsTC.showMessageWidow.push(newsShowMessage);
                    } else if ("Commodity News".equalsIgnoreCase(this.message.type.value)) {
                        if (newsShowMessage != null) {
                            newsShowMessage.dispose();
                        }
                        newsShowMessage = new ShowMessage(this.myTab, TradeCast.getInstance().frame, this.message, this.message.type.value, this, this.rows);
                        LogsTC.showMessageWidow.push(newsShowMessage);
                    } else if ("BOARD_MEETING".equalsIgnoreCase(this.message.type.value)) {
                        if (boardShowMessage != null) {
                            boardShowMessage.dispose();
                        }
                        boardShowMessage = new ShowMessage(this.myTab, TradeCast.getInstance().frame, this.message, this.message.type.value, this, this.rows);
                        LogsTC.showMessageWidow.push(boardShowMessage);
                    } else if ("HOUSE_MESSAGE".equalsIgnoreCase(this.message.type.value)) {
                        if (houseShowMessage != null) {
                            houseShowMessage.dispose();
                        }
                        houseShowMessage = new ShowMessage(this.myTab, TradeCast.getInstance().frame, this.message, this.message.type.value, this, this.rows);
                        LogsTC.showMessageWidow.push(houseShowMessage);
                    }
                    this.showSearchResult.myTab.setReadunRead(this.message);
                }
            } else if (LanguageConstant.News.equalsIgnoreCase(this.message.type.value)) {
                if (newsShowMessage != null) {
                    newsShowMessage.dispose();
                }
                newsShowMessage = new ShowMessage(this.myTab, TradeCast.getInstance().frame, this.message, this.message.type.value, this, this.rows);
                LogsTC.showMessageWidow.push(newsShowMessage);
            } else if ("Commodity News".equalsIgnoreCase(this.message.type.value)) {
                if (newsShowMessage != null) {
                    newsShowMessage.dispose();
                }
                newsShowMessage = new ShowMessage(this.myTab, TradeCast.getInstance().frame, this.message, this.message.type.value, this, this.rows);
                LogsTC.showMessageWidow.push(newsShowMessage);
            } else if ("BOARD_MEETING".equalsIgnoreCase(this.message.type.value)) {
                if (boardShowMessage != null) {
                    boardShowMessage.dispose();
                }
                boardShowMessage = new ShowMessage(this.boardMeetingTab, TradeCast.getInstance().frame, this.message, this.message.type.value, this, this.rows);
                LogsTC.showMessageWidow.push(boardShowMessage);
            } else if ("HOUSE_MESSAGE".equalsIgnoreCase(this.message.type.value)) {
                if (houseShowMessage != null) {
                    houseShowMessage.dispose();
                }
                houseShowMessage = new ShowMessage(this.myTab, TradeCast.getInstance().frame, this.message, this.message.type.value, this, this.rows);
                LogsTC.showMessageWidow.push(houseShowMessage);
            }
        } else if (this.feed != null) {
            Mediator.getInstance().openURLinOSBrowser(this.feed.link.value);
            this.feed.isRead = true;
            this.RSS_setRSSText();
        } else if (this.margin != null) {
            if (marginShowMessage != null) {
                marginShowMessage.dispose();
            }
            marginShowMessage = new ShowMessage(TradeCast.getInstance().frame, this.margin, this, this.rows);
            LogsTC.showMessageWidow.push(marginShowMessage);
        } else if (this.announcement != null) {
            this.announcement.isRead = true;
            if (this.showAnnouncementSearchResult != null && this.showAnnouncementSearchResult.announcementTab != null) {
                ShowMessage.isAnnouncementsSearchOpen = true;
                this.setAnnouncementText(true, AnnouncementTab.TotalMessageSearch);
                if (announcementShowMessage != null) {
                    announcementShowMessage.dispose();
                }
                announcementShowMessage = new ShowMessage(this.showAnnouncementSearchResult.announcementTab, TradeCast.getInstance().frame, this.announcement, this, this.rows, AnnouncementTab.TotalMessageSearch);
                LogsTC.showMessageWidow.push(announcementShowMessage);
                this.showAnnouncementSearchResult.announcementTab.setReadunRead(this.announcement);
            }
            if (this.showAnnouncementScripDetailSearchResult != null) {
                if (this.showAnnouncementScripDetailSearchResult.announcementScripDetail != null) {
                    ShowMessage.isAnnouncementsSearchOpen = true;
                    this.setAnnouncementText(true, AnnouncementScripDetail.TotalMessageSearch);
                    if (announcementShowMessage != null) {
                        announcementShowMessage.dispose();
                    }
                    announcementShowMessage = new ShowMessage(this.showAnnouncementScripDetailSearchResult.announcementScripDetail, TradeCast.getInstance().frame, this.announcement, this, this.rows, AnnouncementScripDetail.TotalMessageSearch);
                    LogsTC.showMessageWidow.push(announcementShowMessage);
                    this.showAnnouncementScripDetailSearchResult.announcementScripDetail.setReadunRead(this.announcement);
                }
            } else if (this.announcementScripDetail != null) {
                ShowMessage.isAnnouncementsSearchOpen = false;
                this.setRead(true, this.announcement.id);
                this.setAnnouncementText(true, AnnouncementScripDetail.TotalMessage);
                if (announcementShowMessage != null) {
                    announcementShowMessage.dispose();
                }
                announcementShowMessage = new ShowMessage(TradeCast.getInstance().frame, this.announcementScripDetail, this.announcement, this, this.rows, AnnouncementScripDetail.TotalMessage);
                LogsTC.showMessageWidow.push(announcementShowMessage);
            } else {
                if (this.announcementTab != null) {
                    ShowMessage.isAnnouncementsSearchOpen = false;
                    this.setRead(true, this.announcement.id);
                    this.setAnnouncementText(true, AnnouncementTab.TotalMessage);
                    if (announcementShowMessage != null) {
                        announcementShowMessage.dispose();
                    }
                    announcementShowMessage = new ShowMessage(TradeCast.getInstance().frame, this.announcementTab, this.announcement, this, this.rows, AnnouncementTab.TotalMessage);
                    LogsTC.showMessageWidow.push(announcementShowMessage);
                }
                if (this.announcementLiveTab != null) {
                    ShowMessage.isAnnouncementsSearchOpen = false;
                    this.setRead(true, this.announcement.id);
                    this.setAnnouncementText(true, AnnouncementLiveTab.TotalMessage);
                    if (announcementShowMessage != null) {
                        announcementShowMessage.dispose();
                    }
                    announcementShowMessage = new ShowMessage(TradeCast.getInstance().frame, this.announcementLiveTab, this.announcement, this, this.rows, AnnouncementLiveTab.TotalMessage);
                    LogsTC.showMessageWidow.push(announcementShowMessage);
                }
            }
        }
    }

    protected void setRead(final boolean status, final String id) {
        new Thread("MessageDisplay setRead"){

            @Override
            public void run() {
                try {
                    if (MessageDisplay.this.message != null) {
                        WebService.getInstance().getPort().updateUserMessages(LogCommon.UserID, MessageDisplay.this.message.type.value, id, status);
                    } else if (MessageDisplay.this.announcement != null && AppConfig.loginMode != LoginMode.PMEX) {
                        WebService.getInstance().getPort().updateUserMessages(LogCommon.UserID, LanguageConstant.Announcement, id, status);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }.start();
    }

    public static String convert(String str) {
        StringBuffer ostr = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch >= ' ' && ch <= '~') {
                ostr.append(ch);
                continue;
            }
            ostr.append("\\u");
            String hex = Integer.toHexString(str.charAt(i) & 0xFFFF);
            for (int j = 0; j < 4 - hex.length(); ++j) {
                ostr.append("0");
            }
            ostr.append(hex.toLowerCase());
        }
        return new String(ostr);
    }

    public void setMarginCallText(boolean isBlink) {
        if (LogsKSE.MarginCallText.indexOf("~~") >= 0) {
            String[] DynamicText = LogsKSE.MarginCallText.split("\\~~", -1);
            String HtmlText = "";
            DynamicText[0] = DynamicText[0].replaceAll("%ACCOUNT%", this.margin.account);
            DynamicText[0] = DynamicText[0].replaceAll("%CALL%", this.margin.call);
            DynamicText[0] = DynamicText[0].replaceAll("%ACCOUNTNAME%", this.margin.name);
            DynamicText[0] = DynamicText[0].replaceAll("%RS%", this.margin.shortfall);
            DynamicText[0] = DynamicText[0].replaceAll("%PERCENT%", this.margin.shortfallPer + "%");
            DynamicText[0] = DynamicText[0].replaceAll("%DATETIME%", this.margin.dateTime + " | " + this.margin.msgID + " of " + MarginCallTab.TotalMessage);
            DynamicText[1] = DynamicText[1].replaceAll("%ACCOUNT%", this.margin.account);
            DynamicText[1] = DynamicText[1].replaceAll("%CALL%", this.margin.call);
            DynamicText[1] = DynamicText[1].replaceAll("%ACCOUNTNAME%", this.margin.name);
            DynamicText[1] = DynamicText[1].replaceAll("%RS%", this.margin.shortfall);
            DynamicText[1] = DynamicText[1].replaceAll("%PERCENT%", this.margin.shortfallPer + "%");
            DynamicText[1] = DynamicText[1].replaceAll("%DATETIME%", this.margin.dateTime + " | " + this.margin.msgID + " of " + MarginCallTab.TotalMessage);
            DynamicText[2] = DynamicText[2].replaceAll("%ACCOUNT%", this.margin.account);
            DynamicText[2] = DynamicText[2].replaceAll("%CALL%", this.margin.call);
            DynamicText[2] = DynamicText[2].replaceAll("%ACCOUNTNAME%", this.margin.name);
            DynamicText[2] = DynamicText[2].replaceAll("%RS%", this.margin.shortfall);
            DynamicText[2] = DynamicText[2].replaceAll("%PERCENT%", this.margin.shortfallPer + "%");
            DynamicText[2] = DynamicText[2].replaceAll("%DATETIME%", this.margin.dateTime + " | " + this.margin.msgID + " of " + MarginCallTab.TotalMessage);
            String color = "ffcc66";
            if (this.margin.call.equalsIgnoreCase("First Margin Call")) {
                color = Integer.toHexString(MyColors.marginCall1st.getRGB() & 0xFFFFFF);
                if (isBlink) {
                    color = Integer.toHexString(Color.YELLOW.getRGB() & 0xFFFFFF);
                }
                DynamicText[0] = DynamicText[0].replaceAll("%HEADERBGCOLOR%", color);
                HtmlText = DynamicText[0];
            } else if (this.margin.call.equalsIgnoreCase("Second Margin Call")) {
                color = Integer.toHexString(MyColors.marginCall2nd.getRGB() & 0xFFFFFF);
                if (isBlink) {
                    color = Integer.toHexString(Color.YELLOW.getRGB() & 0xFFFFFF);
                }
                DynamicText[1] = DynamicText[1].replaceAll("%HEADERBGCOLOR%", color);
                HtmlText = DynamicText[1];
            } else if (this.margin.call.equalsIgnoreCase("Final Margin Call")) {
                color = Integer.toHexString(MyColors.marginCall3rd.getRGB() & 0xFFFFFF);
                if (isBlink) {
                    color = Integer.toHexString(Color.YELLOW.getRGB() & 0xFFFFFF);
                }
                DynamicText[2] = DynamicText[2].replaceAll("%HEADERBGCOLOR%", color);
                HtmlText = DynamicText[2];
            }
            this.editorPane.setText(HtmlText);
        }
    }

    public void setMarginCallText(int no, int count) {
        if (LogsKSE.MarginCallText.indexOf("~~") >= 0) {
            String[] DynamicText = LogsKSE.MarginCallText.split("\\~~", -1);
            String HtmlText = "";
            DynamicText[0] = DynamicText[0].replaceAll("%ACCOUNT%", this.margin.account);
            DynamicText[0] = DynamicText[0].replaceAll("%CALL%", this.margin.call);
            DynamicText[0] = DynamicText[0].replaceAll("%ACCOUNTNAME%", this.margin.name);
            DynamicText[0] = DynamicText[0].replaceAll("%RS%", this.margin.shortfall);
            DynamicText[0] = DynamicText[0].replaceAll("%PERCENT%", this.margin.shortfallPer + "%");
            DynamicText[0] = DynamicText[0].replaceAll("%DATETIME%", this.margin.dateTime + " | " + Util.format0digit((String)(no + "")) + " of " + Util.format0digit((String)(count + "")));
            DynamicText[1] = DynamicText[1].replaceAll("%ACCOUNT%", this.margin.account);
            DynamicText[1] = DynamicText[1].replaceAll("%CALL%", this.margin.call);
            DynamicText[1] = DynamicText[1].replaceAll("%ACCOUNTNAME%", this.margin.name);
            DynamicText[1] = DynamicText[1].replaceAll("%RS%", this.margin.shortfall);
            DynamicText[1] = DynamicText[1].replaceAll("%PERCENT%", this.margin.shortfallPer + "%");
            DynamicText[1] = DynamicText[1].replaceAll("%DATETIME%", this.margin.dateTime + " | " + Util.format0digit((String)(no + "")) + " of " + Util.format0digit((String)(count + "")));
            DynamicText[2] = DynamicText[2].replaceAll("%ACCOUNT%", this.margin.account);
            DynamicText[2] = DynamicText[2].replaceAll("%CALL%", this.margin.call);
            DynamicText[2] = DynamicText[2].replaceAll("%ACCOUNTNAME%", this.margin.name);
            DynamicText[2] = DynamicText[2].replaceAll("%RS%", this.margin.shortfall);
            DynamicText[2] = DynamicText[2].replaceAll("%PERCENT%", this.margin.shortfallPer + "%");
            DynamicText[2] = DynamicText[2].replaceAll("%DATETIME%", this.margin.dateTime + " | " + Util.format0digit((String)(no + "")) + " of " + Util.format0digit((String)(count + "")));
            String color = "ffcc66";
            if (this.margin.call.equalsIgnoreCase("First Margin Call")) {
                color = Integer.toHexString(MyColors.marginCall1st.getRGB() & 0xFFFFFF);
                DynamicText[0] = DynamicText[0].replaceAll("%HEADERBGCOLOR%", color);
                HtmlText = DynamicText[0];
            } else if (this.margin.call.equalsIgnoreCase("Second Margin Call")) {
                color = Integer.toHexString(MyColors.marginCall2nd.getRGB() & 0xFFFFFF);
                DynamicText[1] = DynamicText[1].replaceAll("%HEADERBGCOLOR%", color);
                HtmlText = DynamicText[1];
            } else if (this.margin.call.equalsIgnoreCase("Final Margin Call")) {
                color = Integer.toHexString(MyColors.marginCall3rd.getRGB() & 0xFFFFFF);
                DynamicText[2] = DynamicText[2].replaceAll("%HEADERBGCOLOR%", color);
                HtmlText = DynamicText[2];
            }
            this.editorPane.setText(HtmlText);
        }
    }

    public synchronized void RSS_setRSSColor(boolean status) {
        if (status) {
            String color = Integer.toHexString(Color.YELLOW.getRGB() & 0xFFFFFF);
            this.RSS_setRSSTextRead(color);
        } else {
            String color = Integer.toHexString(this.RSSreadColor.getRGB() & 0xFFFFFF);
            this.RSS_setRSSTextRead(color);
        }
    }

    private void RSS_setRSSText() {
        String color = Integer.toHexString(this.RSSreadColor.getRGB() & 0xFFFFFF);
        this.RSS_setRSSTextRead(color);
    }

    public synchronized void RSS_setRSSTextRead(String color) {
        if (this.feed != null) {
            String HtmlText = "<html><table border=0px CELLPADDING='-1' width='100%' height='100px'><tr COLOR='#373737' BGColor='#" + color + "'><td width='95%' style='margin:2px; padding-left:2px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'>" + this.feed.title.value.trim() + "</font></td><td width='5%' nowrap='nowrap' color='#000000' valign=top style='padding:2px; text-align:right;'><font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + Util.format0digit((String)(RSSTab.RssCounter + "")) + " of " + Util.format0digit((String)(this.totalMsg + "")) + "</font></td></tr><tr color='#000000'><td colspan=2 style='margin:2px; padding-left:2px; padding-top:2px;'><font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + this.feed.pubDate.value + "</font></td></tr><tr ><td colspan=2 style=' margin:2px; padding-left:2px; padding-top:2px;'><div style='overflow:hidden; height:38px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'>" + this.feed.summary.value + "</font></div></td></tr></table></html>";
            this.editorPane.setText(HtmlText);
        }
    }

    public synchronized void RSS_setRSSTextUnRead(String color) {
        if (this.feed != null) {
            String HtmlText = "<html><table border=0px CELLPADDING='-1' width='100%' height='100px'><tr COLOR='#373737' BGColor='#" + color + "'><td width='95%' style='margin:2px; padding-left:2px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b><a href='' style='color:#373737; text-decoration:none'>" + this.feed.title.value + "</a></b></font></td><td width='5%' nowrap='nowrap' color='#000000' valign=top style='padding:2px; text-align:right;'><font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + Util.format0digit((String)(RSSTab.RssCounter + "")) + " of " + Util.format0digit((String)(this.totalMsg + "")) + "</font></td></tr><tr color='#000000'><td colspan=2 style='margin:2px; padding-left:2px; padding-top:2px;'><font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + this.feed.pubDate.value + "</font></td></tr><tr ><td colspan=2 style=' margin:2px; padding-left:2px; padding-top:2px;'><div style='overflow:hidden; height:38px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><b>" + this.feed.summary.value + "</b></font></div></td></tr></table></html>";
            this.editorPane.setText(HtmlText);
            this.repaint();
        }
    }

    public static String HightLight(String originaltext, String findwhat) {
        if (findwhat == null) {
            return originaltext;
        }
        if (findwhat.equalsIgnoreCase("")) {
            return originaltext;
        }
        int findwhatlength = findwhat.length();
        String Title2 = "";
        String TitleInUpperCase = originaltext.toUpperCase();
        String findwhatInUpperCase = findwhat.toUpperCase();
        int Cursor2 = 0;
        int index = 0;
        while (TitleInUpperCase.indexOf(findwhatInUpperCase) > -1) {
            index = TitleInUpperCase.indexOf(findwhatInUpperCase);
            Title2 = Title2 + originaltext.substring(Cursor2, index) + "<span style='background-color:yellow'>" + originaltext.substring(index, index + findwhatlength) + "</span>";
            originaltext = originaltext.substring(index + findwhatlength, originaltext.length());
            if (TitleInUpperCase.length() > index + findwhatlength) {
                // empty if block
            }
            TitleInUpperCase = TitleInUpperCase.substring(index + findwhatlength, TitleInUpperCase.length());
        }
        Title2 = Title2.length() == 0 ? originaltext : Title2 + originaltext.substring(0, originaltext.length());
        return Title2;
    }

    public synchronized void RSS_setRSSTextUnReadUpdated(int count, int size, String findwhat) {
        String color = Integer.toHexString(this.RSSunReadColor.getRGB() & 0xFFFFFF);
        if (this.feed != null) {
            String HtmlText = "<html><table border=0px CELLPADDING='-1' width='100%' height='100px'><tr COLOR='#373737' BGColor='#" + color + "'><td width='95%' style='margin:2px; padding-left:2px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'><a href='' style='color:#373737; text-decoration:none'>" + MessageDisplay.HightLight(this.feed.title.value, findwhat) + "</a></font></td><td  width='5%' nowrap='nowrap' color='#000000' valign=top style='padding:2px; text-align:right;'><font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + Util.format0digit((String)(count + "")) + " of " + Util.format0digit((String)(size + "")) + "</font></td></tr><tr color='#000000'><td colspan=2 style='margin:2px; padding-left:2px; padding-top:1px;'><font style='font-family: Tahoma, Tahoma; font-size:9pt; font-style:normal' >" + this.feed.pubDate.value + "</font></td></tr><tr ><td colspan=2 style=' margin:2px; padding-left:2px; padding-top:1px;'><div style='overflow:hidden; height:38px;'><font style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal'>" + MessageDisplay.HightLight(this.feed.summary.value, findwhat) + "</font></div></td></tr></table></html>";
            this.editorPane.setText(HtmlText);
        }
    }

    private void setPopupMenuForAnnouncements() {
        this.markAsRead.setIcon(new ImageIcon(this.getClass().getResource("/Images/markRead.png")));
        this.markAsRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageDisplay.this.markAsRead();
            }
        });
        this.markAsUnread.setIcon(new ImageIcon(this.getClass().getResource("/Images/markUnread.png")));
        this.markAsUnread.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageDisplay.this.markAsUnread();
            }
        });
        this.popupMenu.add(this.markAsRead);
        this.popupMenu.add(this.markAsUnread);
    }

    private void setAnnouncementText(String color, int totalMessage) {
        if (this.announcement != null) {
            if (this.announcement.isRead && this.announcement.isManualEntry) {
                this.setAnnouncementTextRead(color, totalMessage);
            } else if (!this.announcement.isRead && this.announcement.isManualEntry) {
                this.setAnnouncementTextUnRead(color, totalMessage);
            } else if (this.announcement.isRead && !this.announcement.isManualEntry) {
                this.setAnnouncementFileTextRead(color, totalMessage);
            } else if (!this.announcement.isRead && !this.announcement.isManualEntry) {
                this.setAnnouncementFileTextUnRead(color, totalMessage);
            }
        }
    }

    public void setAnnouncementText(boolean status, int totalMessage) {
        String color = Integer.toHexString(MyColors.AnnouncementsBG.getRGB() & 0xFFFFFF);
        if (status) {
            color = Integer.toHexString(MyColors.AnnouncementsBG.getRGB() & 0xFFFFFF);
            this.setAnnouncementText(color, totalMessage);
        } else {
            color = Integer.toHexString(Color.YELLOW.getRGB() & 0xFFFFFF);
            this.setAnnouncementText(color, totalMessage);
        }
    }

    private void setAnnouncementTextRead(String color, int totalMessage) {
        if (this.announcement != null) {
            StringBuilder sb = new StringBuilder();
            String td = "<td colspan = '2' style='padding-left:3px; margin-top:3px'>";
            sb.append("<html>");
            sb.append("<table style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal' width='100%' border='0px' cellpadding ='0px' cellspacing='0px' bgcolor='white'>");
            sb.append("<tr style='height:15px; background-color:#" + color + "'>");
            sb.append("<td style='margin:2px; padding-left:2px; height: 15px;' color='black'>");
            sb.append("<b>");
            sb.append("<a href='" + this.announcement.scrip + "' style='color:#373737; text-decoration:none'>");
            sb.append(MessageDisplay.HightLight(this.announcement.scrip + " (" + this.announcement.company + ")", this.find));
            sb.append("</a>");
            sb.append("</b>");
            sb.append("</td>");
            sb.append("<td nowrap='nowrap' color='light-gray' valign=top style='text-align:right;margin:3px; padding-right:3px; height: 15px;'>");
            sb.append(this.announcement.dateTime);
            sb.append(" | " + Util.format0digit((String)(this.announcement.msgNo + "")) + " of " + Util.format0digit((String)(totalMessage + "")));
            sb.append("</td>");
            sb.append("</tr>");
            if (!this.announcement.AGM.equalsIgnoreCase("")) {
                sb.append("<tr >");
                sb.append(td);
                sb.append(MessageDisplay.HightLight("Annual General Meeting will be held on " + this.announcement.AGM, this.find));
                sb.append("</td>");
                sb.append("</tr>");
            }
            if (!this.announcement.EPS.equalsIgnoreCase("")) {
                boolean isDouble = false;
                try {
                    Double.parseDouble(this.announcement.EPS);
                    isDouble = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sb.append("<tr >");
                sb.append(td);
                if (isDouble) {
                    sb.append(MessageDisplay.HightLight("Earning per Share is Rs. " + Util.format2digit((String)this.announcement.EPS) + "/-", this.find));
                } else {
                    sb.append(MessageDisplay.HightLight("Earning per Share is " + this.announcement.EPS, this.find));
                }
                sb.append("</td>");
                sb.append("</tr>");
            }
            if (!this.announcement.FYE.equalsIgnoreCase("")) {
                sb.append("<tr >");
                sb.append(td);
                sb.append(MessageDisplay.HightLight("Financial year ended " + this.announcement.FYE, this.find));
                sb.append("</td>");
                sb.append("</tr>");
            }
            if (!this.announcement.PLBeforeTax.equalsIgnoreCase("")) {
                sb.append("<tr >");
                sb.append(td);
                double dd = 0.0;
                try {
                    dd = Double.parseDouble(this.announcement.PLBeforeTax);
                }
                catch (Exception ex) {
                    sb.append(MessageDisplay.HightLight("Profit / Loss before Taxation is " + this.announcement.PLBeforeTax, this.find));
                }
                if (dd >= 0.0) {
                    sb.append(MessageDisplay.HightLight("Profit before Taxation is Rs. " + Util.format0digit((String)this.announcement.PLBeforeTax) + " Million", this.find));
                } else {
                    sb.append(MessageDisplay.HightLight("Loss before Taxation is Rs. " + Util.format0digit((String)this.announcement.PLBeforeTax) + " Million", this.find));
                }
                sb.append("</td>");
                sb.append("</tr>");
            }
            if (!this.announcement.PLAfterTax.equalsIgnoreCase("")) {
                sb.append("<tr >");
                sb.append(td);
                double dd = 0.0;
                try {
                    dd = Double.parseDouble(this.announcement.PLAfterTax);
                }
                catch (Exception ex) {
                    sb.append(MessageDisplay.HightLight("Profit / Loss after Taxation is " + this.announcement.PLAfterTax, this.find));
                }
                if (dd >= 0.0) {
                    sb.append(MessageDisplay.HightLight("Profit after Taxation is Rs. " + Util.format0digit((String)this.announcement.PLAfterTax) + " Million", this.find));
                } else {
                    sb.append(MessageDisplay.HightLight("Loss after Taxation is Rs. " + Util.format0digit((String)this.announcement.PLAfterTax) + " Million", this.find));
                }
                sb.append("</td>");
                sb.append("</tr>");
            }
            if (!this.announcement.bookClosureStartDate.equalsIgnoreCase("")) {
                sb.append("<tr >");
                sb.append(td);
                sb.append(MessageDisplay.HightLight("Book Closure from " + this.announcement.bookClosureStartDate + " to " + this.announcement.bookClosureEndDate, this.find));
                sb.append("</td>");
                sb.append("</tr>");
            }
            if (!this.announcement.divedend.equalsIgnoreCase("")) {
                sb.append("<tr >");
                sb.append(td);
                try {
                    Double.parseDouble(this.announcement.divedend);
                    sb.append(MessageDisplay.HightLight("Dividend issued for the " + this.announcement.period + " is " + Util.format2digit((String)this.announcement.divedend) + "%", this.find));
                }
                catch (Exception ex) {
                    sb.append(MessageDisplay.HightLight("Dividend issued for the " + this.announcement.period + " is " + this.announcement.divedend, this.find));
                }
                sb.append("</td>");
                sb.append("</tr>");
            }
            if (this.announcement.divedend.equalsIgnoreCase("") && !this.announcement.period.equalsIgnoreCase("")) {
                sb.append("<tr >");
                sb.append(td);
                sb.append("Period (" + MessageDisplay.HightLight(this.announcement.period, this.find) + ")");
                sb.append("</td>");
                sb.append("</tr>");
            }
            if (!this.announcement.bonus.equalsIgnoreCase("")) {
                sb.append("<tr >");
                sb.append(td);
                try {
                    Double.parseDouble(this.announcement.bonus);
                    sb.append(MessageDisplay.HightLight("Bonus shares issued for the " + this.announcement.period + " are " + Util.format2digit((String)this.announcement.bonus) + "%", this.find));
                }
                catch (Exception ex) {
                    sb.append(MessageDisplay.HightLight("Bonus shares issued for the " + this.announcement.period + " are " + this.announcement.bonus, this.find));
                }
                sb.append("</td>");
                sb.append("</tr>");
            }
            if (!this.announcement.right.equalsIgnoreCase("") && !this.announcement.premium.equalsIgnoreCase("")) {
                sb.append("<tr >");
                sb.append(td);
                try {
                    Double.parseDouble(this.announcement.premium);
                    sb.append(MessageDisplay.HightLight("Right shares issued for the " + this.announcement.period + " are " + Util.format2digit((String)this.announcement.right) + "%, at the Premium of Rs. " + Util.format2digit((String)this.announcement.premium) + "/- per share", this.find));
                }
                catch (Exception ex) {
                    sb.append(MessageDisplay.HightLight("Right shares issued for the " + this.announcement.period + " are " + this.announcement.right + "%, at the Premium of " + this.announcement.premium + " per share", this.find));
                }
                sb.append("</td>");
                sb.append("</tr>");
            } else if (!this.announcement.right.equalsIgnoreCase("") && !this.announcement.discount.equalsIgnoreCase("")) {
                sb.append("<tr >");
                sb.append(td);
                try {
                    Double.parseDouble(this.announcement.discount);
                    sb.append(MessageDisplay.HightLight("Right shares issued for the " + this.announcement.period + " are " + Util.format2digit((String)this.announcement.right) + "%, at the Discount of " + Util.format2digit((String)this.announcement.discount) + "%", this.find));
                }
                catch (Exception ex) {
                    sb.append(MessageDisplay.HightLight("Right shares issued for the " + this.announcement.period + " are " + this.announcement.right + "%, at the Discount of " + this.announcement.discount + "%", this.find));
                }
                sb.append("</td>");
                sb.append("</tr>");
            } else if (!this.announcement.right.equalsIgnoreCase("")) {
                sb.append("<tr >");
                sb.append(td);
                try {
                    Double.parseDouble(this.announcement.right);
                    sb.append(MessageDisplay.HightLight("Right shares issued " + Util.format2digit((String)this.announcement.right) + "%, at Par Value", this.find));
                }
                catch (Exception ex) {
                    sb.append(MessageDisplay.HightLight("Right shares issued " + this.announcement.right + "%, at Par Value", this.find));
                }
                sb.append("</td>");
                sb.append("</tr>");
            }
            if (!this.announcement.fileData.equalsIgnoreCase("")) {
                if (this.announcement.fileData.indexOf("|") >= 0) {
                    String[] data = this.announcement.fileData.split("\\|");
                    for (int i = 0; i < data.length; ++i) {
                        String string = data[i];
                        sb.append("<tr >");
                        sb.append(td);
                        sb.append(MessageDisplay.HightLight(string, this.find));
                        sb.append("</td>");
                        sb.append("</tr>");
                    }
                } else {
                    sb.append("<tr >");
                    sb.append(td);
                    sb.append(MessageDisplay.HightLight(this.announcement.fileData, this.find));
                    sb.append("</td>");
                    sb.append("</tr>");
                }
            }
            sb.append(MessageDisplay.getHyperLinkText(this.announcement.hyperLink, this.find));
            sb.append("</table>");
            sb.append("</html>");
            this.editorPane.setText(sb.toString());
        }
    }

    private void setAnnouncementTextUnRead(String color, int totalMessage) {
        if (this.announcement != null) {
            StringBuilder sb = new StringBuilder();
            String td = "<td colspan = '2' style='padding-left:3px; margin-top:3px'>";
            sb.append("<html>");
            sb.append("<table style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal' width='100%' border='0px' cellpadding ='0px' cellspacing='0px' bgcolor='white'>");
            sb.append("<tr style='height:15px; background-color:#" + color + "'>");
            sb.append("<td style='margin:2px; padding-left:2px; height: 15px;' color='black'>");
            sb.append("<b >");
            sb.append("<a href='" + this.announcement.scrip + "' style='color:#373737; text-decoration:none'>");
            sb.append(MessageDisplay.HightLight(this.announcement.scrip + " (" + this.announcement.company + ")", this.find));
            sb.append("</a>");
            sb.append("</b >");
            sb.append("</td>");
            sb.append("<td nowrap='nowrap' color='light-gray' valign=top style='text-align:right;margin:3px; padding-right:3px; height: 15px;'>");
            sb.append(this.announcement.dateTime);
            sb.append(" | " + Util.format0digit((String)(this.announcement.msgNo + "")) + " of " + Util.format0digit((String)(totalMessage + "")));
            sb.append("</td>");
            sb.append("</tr>");
            if (!this.announcement.AGM.equalsIgnoreCase("")) {
                sb.append("<tr >");
                sb.append(td);
                sb.append("<b>");
                sb.append(MessageDisplay.HightLight("Annual General Meeting will be held on " + this.announcement.AGM, this.find));
                sb.append("</b>");
                sb.append("</td>");
                sb.append("</tr>");
            }
            if (!this.announcement.EPS.equalsIgnoreCase("")) {
                boolean isDouble = false;
                try {
                    Double.parseDouble(this.announcement.EPS);
                    isDouble = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sb.append("<tr >");
                sb.append(td);
                sb.append("<b>");
                if (isDouble) {
                    sb.append(MessageDisplay.HightLight("Earning per Share is Rs. " + Util.format2digit((String)this.announcement.EPS) + "/-", this.find));
                } else {
                    sb.append(MessageDisplay.HightLight("Earning per Share is " + this.announcement.EPS, this.find));
                }
                sb.append("</b>");
                sb.append("</td>");
                sb.append("</tr>");
            }
            if (!this.announcement.FYE.equalsIgnoreCase("")) {
                sb.append("<tr >");
                sb.append(td);
                sb.append("<b>");
                sb.append(MessageDisplay.HightLight("Financial year ended " + this.announcement.FYE, this.find));
                sb.append("</b>");
                sb.append("</td>");
                sb.append("</tr>");
            }
            if (!this.announcement.PLBeforeTax.equalsIgnoreCase("")) {
                sb.append("<tr >");
                sb.append(td);
                sb.append("<b>");
                double dd = 0.0;
                try {
                    dd = Double.parseDouble(this.announcement.PLBeforeTax);
                }
                catch (Exception ex) {
                    sb.append(MessageDisplay.HightLight("Profit / Loss before Taxation is " + this.announcement.PLBeforeTax, this.find));
                }
                if (dd >= 0.0) {
                    sb.append(MessageDisplay.HightLight("Profit before Taxation is Rs. " + Util.format0digit((String)this.announcement.PLBeforeTax) + " Million", this.find));
                } else {
                    sb.append(MessageDisplay.HightLight("Loss before Taxation is Rs. " + Util.format0digit((String)this.announcement.PLBeforeTax) + " Million", this.find));
                }
                sb.append("</b>");
                sb.append("</td>");
                sb.append("</tr>");
            }
            if (!this.announcement.PLAfterTax.equalsIgnoreCase("")) {
                sb.append("<tr >");
                sb.append(td);
                sb.append("<b>");
                double dd = 0.0;
                try {
                    dd = Double.parseDouble(this.announcement.PLAfterTax);
                }
                catch (Exception ex) {
                    sb.append(MessageDisplay.HightLight("Profit / Loss after Taxation is " + this.announcement.PLAfterTax, this.find));
                }
                if (dd >= 0.0) {
                    sb.append(MessageDisplay.HightLight("Profit after Taxation is Rs. " + Util.format0digit((String)this.announcement.PLAfterTax) + " Million", this.find));
                } else {
                    sb.append(MessageDisplay.HightLight("Loss after Taxation is Rs. " + Util.format0digit((String)this.announcement.PLAfterTax) + " Million", this.find));
                }
                sb.append("</b>");
                sb.append("</td>");
                sb.append("</tr>");
            }
            if (!this.announcement.bookClosureStartDate.equalsIgnoreCase("")) {
                sb.append("<tr >");
                sb.append(td);
                sb.append("<b>");
                sb.append(MessageDisplay.HightLight("Book Closure from " + this.announcement.bookClosureStartDate + " to " + this.announcement.bookClosureEndDate, this.find));
                sb.append("<b>");
                sb.append("</td>");
                sb.append("</tr>");
            }
            if (!this.announcement.divedend.equalsIgnoreCase("")) {
                sb.append("<tr >");
                sb.append(td);
                sb.append("<b>");
                try {
                    Double.parseDouble(this.announcement.divedend);
                    sb.append(MessageDisplay.HightLight("Dividend issued for the " + this.announcement.period + " is " + Util.format2digit((String)this.announcement.divedend) + "%", this.find));
                }
                catch (Exception ex) {
                    sb.append(MessageDisplay.HightLight("Dividend issued for the " + this.announcement.period + " is " + this.announcement.divedend, this.find));
                }
                sb.append("</b>");
                sb.append("</td>");
                sb.append("</tr>");
            }
            if (this.announcement.divedend.equalsIgnoreCase("") && !this.announcement.period.equalsIgnoreCase("")) {
                sb.append("<tr >");
                sb.append(td);
                sb.append("<b>Period (" + MessageDisplay.HightLight(this.announcement.period, this.find) + ")</b>");
                sb.append("</td>");
                sb.append("</tr>");
            }
            if (!this.announcement.bonus.equalsIgnoreCase("")) {
                sb.append("<tr >");
                sb.append(td);
                sb.append("<b>");
                try {
                    Double.parseDouble(this.announcement.bonus);
                    sb.append(MessageDisplay.HightLight("Bonus shares issued for the " + this.announcement.period + " are " + Util.format2digit((String)this.announcement.bonus) + "%", this.find));
                }
                catch (Exception ex) {
                    sb.append(MessageDisplay.HightLight("Bonus shares issued for the " + this.announcement.period + " are " + this.announcement.bonus, this.find));
                }
                sb.append("<b>");
                sb.append("</td>");
                sb.append("</tr>");
            }
            if (!this.announcement.right.equalsIgnoreCase("") && !this.announcement.premium.equalsIgnoreCase("")) {
                sb.append("<tr >");
                sb.append(td);
                sb.append("<b>");
                try {
                    Double.parseDouble(this.announcement.premium);
                    sb.append(MessageDisplay.HightLight("Right shares issued for the " + this.announcement.period + " are " + Util.format2digit((String)this.announcement.right) + "%, at the Premium of Rs. " + Util.format2digit((String)this.announcement.premium) + "/- per share", this.find));
                }
                catch (Exception ex) {
                    sb.append(MessageDisplay.HightLight("Right shares issued for the " + this.announcement.period + " are " + this.announcement.right + "%, at the Premium of " + this.announcement.premium + " per share", this.find));
                }
                sb.append("</b>");
                sb.append("</td>");
                sb.append("</tr>");
            } else if (!this.announcement.right.equalsIgnoreCase("") && !this.announcement.discount.equalsIgnoreCase("")) {
                sb.append("<tr >");
                sb.append(td);
                sb.append("<b>");
                try {
                    Double.parseDouble(this.announcement.discount);
                    sb.append(MessageDisplay.HightLight("Right shares issued for the " + this.announcement.period + " are " + Util.format2digit((String)this.announcement.right) + "%, at the Discount of " + Util.format2digit((String)this.announcement.discount) + "%", this.find));
                }
                catch (Exception ex) {
                    sb.append(MessageDisplay.HightLight("Right shares issued for the " + this.announcement.period + " are " + this.announcement.right + "%, at the Discount of " + this.announcement.discount + "%", this.find));
                }
                sb.append("</b>");
                sb.append("</td>");
                sb.append("</tr>");
            } else if (!this.announcement.right.equalsIgnoreCase("")) {
                sb.append("<tr >");
                sb.append(td);
                sb.append("<b>");
                try {
                    Double.parseDouble(this.announcement.right);
                    sb.append(MessageDisplay.HightLight("Right shares issued " + Util.format2digit((String)this.announcement.right) + "%, at Par Value", this.find));
                }
                catch (Exception ex) {
                    sb.append(MessageDisplay.HightLight("Right shares issued " + this.announcement.right + "%, at Par Value", this.find));
                }
                sb.append("</b>");
                sb.append("</td>");
                sb.append("</tr>");
            }
            if (!this.announcement.fileData.equalsIgnoreCase("")) {
                if (this.announcement.fileData.indexOf("|") >= 0) {
                    String[] data = this.announcement.fileData.split("\\|");
                    for (int i = 0; i < data.length; ++i) {
                        String string = data[i];
                        sb.append("<tr >");
                        sb.append(td);
                        sb.append("<b>");
                        sb.append(MessageDisplay.HightLight(string, this.find));
                        sb.append("</b>");
                        sb.append("</td>");
                        sb.append("</tr>");
                    }
                } else {
                    sb.append("<tr >");
                    sb.append(td);
                    sb.append("<b>");
                    sb.append(MessageDisplay.HightLight(this.announcement.fileData, this.find));
                    sb.append("</b>");
                    sb.append("</td>");
                    sb.append("</tr>");
                }
            }
            sb.append(MessageDisplay.getHyperLinkText(this.announcement.hyperLink, this.find));
            sb.append("</table>");
            sb.append("</html>");
            this.editorPane.setText(sb.toString());
        }
    }

    private void setAnnouncementFileTextUnRead(String color, int totalMessage) {
        if (this.announcement != null) {
            StringBuilder sb = new StringBuilder();
            String td = "<td colspan = '2' style='padding-left:3px; margin-top:3px'>";
            sb.append("<html>");
            sb.append("<table style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal' width='100%' border='0px' cellpadding ='0px' cellspacing='0px' bgcolor='white'>");
            sb.append("<tr style='height:15px; background-color:#" + color + "'>");
            sb.append("<td style='margin:2px; padding-left:2px; height: 15px;' color='black'>");
            sb.append("<b >");
            sb.append("<a href='" + this.announcement.scrip + "' style='color:#373737; text-decoration:none'>");
            sb.append(MessageDisplay.HightLight(this.announcement.scrip + " (" + this.announcement.company + ")", this.find));
            sb.append("</a>");
            sb.append("</b >");
            sb.append("</td>");
            sb.append("<td nowrap='nowrap' color='light-gray' valign=top style='text-align:right;margin:3px; padding-right:3px; height: 15px;'>");
            sb.append(this.announcement.dateTime);
            sb.append(" | " + Util.format0digit((String)(this.announcement.msgNo + "")) + " of " + Util.format0digit((String)(totalMessage + "")));
            sb.append("</td>");
            sb.append("</tr>");
            if (this.announcement.fileData.indexOf("|") >= 0) {
                String[] data = this.announcement.fileData.split("\\|");
                for (int i = 0; i < data.length; ++i) {
                    String string = data[i];
                    sb.append("<tr >");
                    sb.append(td);
                    sb.append("<b>");
                    sb.append(MessageDisplay.HightLight(string, this.find));
                    sb.append("</b>");
                    sb.append("</td>");
                    sb.append("</tr>");
                }
            } else {
                sb.append("<tr >");
                sb.append(td);
                sb.append("<b>");
                sb.append(MessageDisplay.HightLight(this.announcement.fileData, this.find));
                sb.append("</b>");
                sb.append("</td>");
                sb.append("</tr>");
            }
            sb.append(MessageDisplay.getHyperLinkText(this.announcement.hyperLink, this.find));
            sb.append("</table>");
            sb.append("</html>");
            this.editorPane.setText(sb.toString());
        }
    }

    private void setAnnouncementFileTextRead(String color, int totalMessage) {
        if (this.announcement != null) {
            StringBuilder sb = new StringBuilder();
            String td = "<td colspan = '2' style='padding-left:3px; margin-top:3px'>";
            sb.append("<html>");
            sb.append("<table style='font-family: Tahoma, Tahoma; font-size:11pt; font-style:normal' width='100%' border='0px' cellpadding ='0px' cellspacing='0px' bgcolor='white'>");
            sb.append("<tr style='height:15px; background-color:#" + color + "'>");
            sb.append("<td style='margin:2px; padding-left:2px; height: 15px;' color='black'>");
            sb.append("<b>");
            sb.append("<a href='" + this.announcement.scrip + "' style='color:#373737; text-decoration:none'>");
            sb.append(MessageDisplay.HightLight(this.announcement.scrip + " (" + this.announcement.company + ")", this.find));
            sb.append("</a>");
            sb.append("</b>");
            sb.append("</td>");
            sb.append("<td nowrap='nowrap' color='light-gray' valign=top style='text-align:right;margin:3px; padding-right:3px; height: 15px;'>");
            sb.append(this.announcement.dateTime);
            sb.append(" | " + Util.format0digit((String)(this.announcement.msgNo + "")) + " of " + Util.format0digit((String)(totalMessage + "")));
            sb.append("</td>");
            sb.append("</tr>");
            if (this.announcement.fileData.indexOf("|") >= 0) {
                String[] data = this.announcement.fileData.split("\\|");
                for (int i = 0; i < data.length; ++i) {
                    String string = data[i];
                    sb.append("<tr >");
                    sb.append(td);
                    sb.append(MessageDisplay.HightLight(string, this.find));
                    sb.append("</td>");
                    sb.append("</tr>");
                }
            } else {
                sb.append("<tr >");
                sb.append(td);
                sb.append(MessageDisplay.HightLight(this.announcement.fileData, this.find));
                sb.append("</td>");
                sb.append("</tr>");
            }
            sb.append(MessageDisplay.getHyperLinkText(this.announcement.hyperLink, this.find));
            sb.append("</table>");
            sb.append("</html>");
            this.editorPane.setText(sb.toString());
        }
    }

    private void markAsRead() {
        if (this.message != null) {
            this.message.isRead = true;
            this.setTextRead(false);
            this.setColor(false);
            this.setRead(true, this.message.id.value);
            if (!this.find.equalsIgnoreCase("")) {
                this.setTextReadSearch(false);
            }
            if (this.showSearchResult != null && this.showSearchResult.myTab != null) {
                this.showSearchResult.myTab.setReadunRead(this.message);
            }
        } else if (this.announcement != null) {
            this.announcement.isRead = true;
            this.setAnnouncementText(true, this.totalMessage);
            this.setRead(true, this.announcement.id);
            if (this.showAnnouncementSearchResult != null && this.showAnnouncementSearchResult.announcementTab != null) {
                this.showAnnouncementSearchResult.announcementTab.setReadunRead(this.announcement);
            }
        }
    }

    private void markAsUnread() {
        if (this.message != null) {
            this.message.isRead = false;
            this.setTextUnRead(false);
            this.setColor(false);
            this.setRead(false, this.message.id.value);
            if (!this.find.equalsIgnoreCase("")) {
                this.setTextUnReadSearch(false);
            }
            if (this.showSearchResult != null && this.showSearchResult.myTab != null) {
                this.showSearchResult.myTab.setReadunRead(this.message);
            }
        } else if (this.announcement != null) {
            this.announcement.isRead = false;
            this.setAnnouncementText(true, this.totalMessage);
            this.setRead(false, this.announcement.id);
            if (this.showAnnouncementSearchResult != null && this.showAnnouncementSearchResult.announcementTab != null) {
                this.showAnnouncementSearchResult.announcementTab.setReadunRead(this.announcement);
            }
        }
    }

    public static String getHyperLinkText(String HyperLink, String find) {
        StringBuilder sb = new StringBuilder();
        if (HyperLink.contains("|")) {
            String[] ahref = HyperLink.split("\\|", -1);
            for (int i = 0; i < ahref.length; ++i) {
                String string = ahref[i];
                sb.append(MessageDisplay.makeHyperLink(string, find));
            }
        } else {
            return MessageDisplay.makeHyperLink(HyperLink, find);
        }
        return sb.toString();
    }

    private static String makeHyperLink(String HyperLink, String find) {
        StringBuilder sb = new StringBuilder();
        if (HyperLink.length() > 0) {
            sb.append("<tr>");
            sb.append("<td>");
            sb.append("<a href='").append(AppConfig.AnnouncementURL).append(HyperLink).append("' style='text-decoration:none'>");
            sb.append(MessageDisplay.HightLight(HyperLink, find));
            sb.append("</a>");
            sb.append("</td>");
            sb.append("</tr>");
        }
        return sb.toString();
    }

    private void initComponent() {
        this.initComponents();
    }
}

