/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import MessageWindow.RSSTab;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import common.gui.util.AppConfig;
import common.gui.util.MessageType;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class RSSListForm
extends JDialog {
    Class[] types = new Class[]{Object.class, Object.class};
    boolean[] canEdit = new boolean[]{false, false};
    String[] col = new String[]{"Title", "Link"};
    Vector rows = new Vector();
    Vector columns = new Vector();
    DefaultTableModel model = new DefaultTableModel(){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return RSSListForm.this.types[columnIndex];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return RSSListForm.this.canEdit[column];
        }
    };
    private final RSSTab rssTab;
    private static String URLs = "";
    private final String rowSpliter = "~@~";
    private final String colSpliter = "|";
    private JButton btnAdd;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblMessage;
    private JTable table;

    public RSSListForm(RSSTab rssTab) {
        super((Frame)TradeCast.getInstance().frame, false);
        this.rssTab = rssTab;
        this.initComponents();
        this.setSize(new Dimension(545, 500));
        this.setResizable(false);
        this.setDialogLocation();
        for (int i = 0; i < this.col.length; ++i) {
            this.columns.add(this.col[i]);
        }
        this.model.setDataVector(this.rows, this.columns);
        this.table.setModel(this.model);
        this.table.setRowHeight(AppConfig.rowHeight);
        this.table.getTableHeader().setReorderingAllowed(false);
        ((JLabel)((Object)this.table.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(0);
        this.table.setSelectionMode(0);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(450);
        for (int k = 0; k < this.columns.size(); ++k) {
            this.table.getColumn(this.columns.elementAt(k)).setCellRenderer(new RSSListRender());
        }
        this.lblMessage.setText("");
        new Thread("RSSListForm"){

            @Override
            public void run() {
                if (URLs.indexOf("~@~") > 0) {
                    RSSListForm.this.setDefaultLinks(URLs);
                } else {
                    RSSListForm.this.setDefaultLinks();
                }
            }
        }.start();
        this.setVisible(true);
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RSSListForm.this.Dispose();
                TradeCast.getInstance().GetTopWindow();
            }
        });
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RSSListForm.this.table.addNotify();
                    RSSListForm.this.table.repaint();
                }
            });
        }
    }

    private void Dispose() {
        this.dispose();
    }

    private void setDialogLocation() {
        Rectangle r = TradeCast.getInstance().frame.getBounds();
        int x = r.x + (r.width - this.getSize().width) / 2;
        int y = r.y + (r.height - this.getSize().height) / 2;
        this.setLocation(x, y);
    }

    private void setDefaultLinks(String s) {
        this.rows.clear();
        this.table.addNotify();
        if (s.indexOf("~@~") >= 0) {
            String[] Rows = s.split("\\~@~", -1);
            for (int i = 0; i < Rows.length; ++i) {
                if (Rows[i].indexOf("|") < 0) continue;
                String[] colu = Rows[i].split("\\|", -1);
                Vector<String> v = new Vector<String>();
                v.addElement(colu[1]);
                v.addElement(colu[0]);
                this.rows.addElement(v);
            }
        }
        this.tableDataChange();
    }

    public void setDefaultLinks() {
        try {
            String s;
            URLs = "";
            URL url = new URL(AppConfig.TradeCastURL + "/RSS/links.txt");
            URLConnection urlConn = url.openConnection();
            urlConn.setDoInput(true);
            urlConn.setUseCaches(false);
            DataInputStream dis = new DataInputStream(urlConn.getInputStream());
            while ((s = dis.readLine()) != null) {
                if (s.trim().equalsIgnoreCase("")) continue;
                if (s.indexOf("|") >= 0) {
                    String[] ss = s.split("\\|", -1);
                    URLs = URLs + s + "~@~";
                    Vector<String> v = new Vector<String>();
                    v.addElement(ss[1]);
                    v.addElement(ss[0]);
                    this.rows.addElement(v);
                    continue;
                }
                URLs = URLs + s + "|" + "~@~";
                Vector<String> v = new Vector<String>();
                v.addElement("");
                v.addElement(s);
                this.rows.addElement(v);
            }
            dis.close();
        }
        catch (MalformedURLException mue) {
            Mediator.getInstance().PrintLog(mue, "");
            mue.printStackTrace();
        }
        catch (IOException ioe) {
            Mediator.getInstance().PrintLog(ioe, "");
            ioe.printStackTrace();
        }
        this.tableDataChange();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.jSeparator1 = new JSeparator();
        this.btnAdd = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.lblMessage = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("RSS Library");
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Selection", "Title", "Link"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Boolean.class, Object.class, Object.class};
                this.canEdit = new boolean[]{true, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.table.setSelectionForeground(new Color(0, 0, 0));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RSSListForm.this.tableMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        this.btnAdd.setIcon(new ImageIcon(this.getClass().getResource("/Images/RSSSubscribe.png")));
        this.btnAdd.setText("Add");
        this.btnAdd.setName("RSSListForm -> btnAdd");
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RSSListForm.this.btnAddActionPerformed(evt);
            }
        });
        this.jPanel1.setLayout(null);
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setText("RSS Library");
        this.jPanel1.add(this.jLabel2);
        this.jLabel2.setBounds(40, 14, 100, 20);
        this.jLabel3.setText("Add RSS feed of your own choice.");
        this.jPanel1.add(this.jLabel3);
        this.jLabel3.setBounds(60, 34, 170, 20);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/Images/RssLibrary.png")));
        this.jPanel1.add(this.jLabel1);
        this.jLabel1.setBounds(0, 0, 541, 70);
        this.lblMessage.setText("jLabel4");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.lblMessage, -2, 402, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 35, Short.MAX_VALUE).addComponent(this.btnAdd, -2, 84, -2).addGap(3, 3, 3)).addComponent(this.jPanel1, -1, 542, Short.MAX_VALUE).addComponent(this.jSeparator1, -1, 542, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 542, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanel1, -2, 72, -2).addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 79, Short.MAX_VALUE).addGap(3, 3, 3).addComponent(this.jSeparator1, -2, -1, -2).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnAdd).addComponent(this.lblMessage, -2, 20, -2)).addGap(3, 3, 3)));
        this.pack();
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        this.addURL();
    }

    private void tableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.addURL();
        }
    }

    private void addURL() {
        final int rowIndex = this.table.getSelectedRow();
        if (rowIndex < 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select RSS source to add.");
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                RSSListForm.this.setVisible(false);
                ((RSSListForm)RSSListForm.this).rssTab.txtURL.setText(RSSListForm.this.table.getValueAt(rowIndex, 1) + "");
                RSSListForm.this.rssTab.addURL();
                RSSListForm.this.dispose();
            }
        }, "addURL").start();
    }

    private class RSSListRender
    extends DefaultTableCellRenderer {
        private RSSListRender() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel cell = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null) {
                cell.setText(" " + value);
                if (row % 2 == 0) {
                    cell.setBackground(MyColors.cellRenderEven);
                } else {
                    cell.setBackground(MyColors.cellRenderOdd);
                }
            }
            if (isSelected) {
                cell.setBackground(MyColors.SelectionFG);
            }
            return cell;
        }
    }
}

