/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import MessageWindow.DisplayModel;
import MessageWindow.Feed;
import MessageWindow.FeedMessage;
import MessageWindow.FeedParser;
import MessageWindow.MessageDisplay;
import MessageWindow.MessageRender;
import MessageWindow.MsgWin;
import MessageWindow.RSSListForm;
import MessageWindow.RSSMessage;
import MessageWindow.RSSSearchPanel;
import MessageWindow.RSSURLHolder;
import MessageWindow.SearchNotFound;
import MessageWindow.ShowRSSSearchResult;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Utilities.LogsTC;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import kse.util.LogsKSE;
import org.jdesktop.swingx.JXCollapsiblePane;

public class RSSTab
extends JPanel {
    public static int RssCounter = 0;
    Feed feed = null;
    String[][] URLTitleInfo = new String[4][2];
    int countURL;
    String[] columnNames = new String[]{"Title"};
    Hashtable<String, javax.swing.Timer> timerMap = new Hashtable();
    public Vector<MessageDisplay> rows = new Vector();
    Vector columns = new Vector();
    public DisplayModel tableModel = new DisplayModel(this.rows, true);
    int id = 0;
    final int idIndex = 0;
    final int dateTimeIndex = 1;
    final int subjectIndex = 3;
    final int detailIndex = 4;
    final int duration = 300000;
    final int StartAfterDuration = 60000;
    HashMap<String, Boolean> diplayedMap = new HashMap();
    HashMap<String, Feed> feedMap = new HashMap();
    public HashMap<String, String> URLMap = new HashMap();
    String type = "";
    public static DefaultMutableTreeNode nNode;
    public MutableTreeNode node;
    public MutableTreeNode mNode;
    public DefaultTreeModel model;
    public TreePath path;
    FeedParser feedParser = new FeedParser();
    ArrayList idList = new ArrayList();
    Timer feedTimmer = new Timer();
    MessageRender messageRender = new MessageRender();
    public RSSURLHolder rssUrlHolder = null;
    public static final int RSSTitleIndexSort = 0;
    public static final int RSSSumIndexSort = 1;
    private boolean isAsec;
    BasicArrowButton dropDownAsc = null;
    BasicArrowButton dropDownDec = null;
    public RSSSearchPanel RSSSearch = null;
    private Hashtable<String, ArrayList<String>> ReadUnReadHolder = new Hashtable();
    private Hashtable<String, ArrayList<String>> ReadUnReadHolderForPopUP = new Hashtable();
    public MsgWin msgwind;
    HashMap<String, Date> lastUpdateTime = new HashMap();
    private JXCollapsiblePane Add_CollapsiblePane;
    public JButton btnAdd;
    private JButton btnAsen;
    private JButton btnDecn;
    private JButton btnExpand;
    private JButton btnSearch1;
    private ButtonGroup buttonGroup1;
    private JXCollapsiblePane collapsiblePane;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JToolBar.Separator jSeparator5;
    private JToolBar jToolBar1;
    public JLabel lblMessage;
    private JLabel lblRSSLibrary;
    private JLabel lblRSSSource;
    private JCheckBoxMenuItem menuDescription;
    private JCheckBoxMenuItem menuSubject;
    private JPopupMenu popupMenu;
    private JPopupMenu sortMenu;
    public JTable table;
    public JTextField txtURL;
    TimerTask timer = new TimerTask(){

        @Override
        public void run() {
            if (LogCommon.RSSURL.indexOf("$") > 0) {
                String[] url = LogCommon.RSSURL.split("\\$");
                for (int i = 0; i < url.length; ++i) {
                    try {
                        String selectedurl;
                        String URL2 = url[i].split("\\|")[0];
                        RSSTab.this.feedParser.setURL(URL2);
                        RSSTab.this.feed = RSSTab.this.ReadFeed(RSSTab.this.feedParser);
                        RSSTab.this.feedMap.put(url[i].split("\\|")[0], RSSTab.this.feed);
                        if (RSSTab.this.rssUrlHolder.tree.getLastSelectedPathComponent() != null && !RSSTab.this.rssUrlHolder.tree.getLastSelectedPathComponent().toString().equalsIgnoreCase(RSSTab.this.rssUrlHolder.treeTitle) && (selectedurl = RSSTab.this.rssUrlHolder.getRSSURL(RSSTab.this.rssUrlHolder.tree.getLastSelectedPathComponent().toString().split("\\(")[0])).equalsIgnoreCase(url[i].split("\\|")[0])) {
                            RSSTab.this.rssUrlHolder.getRSSFeedParser(selectedurl);
                        }
                        RSSTab.this.rssUrlHolder.RenameNode(url[i].split("\\|")[1], RSSTab.this.feed.getMessages().size());
                        RSSTab.this.setUpdateTime(URL2);
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    };
    boolean FirstTimeInTab = true;

    public RSSTab() {
        try {
            this.initComponents();
            this.lblRSSLibrary.setCursor(Cursor.getPredefinedCursor(12));
            this.lblRSSLibrary.setText("<html> RSS Library</html>");
            this.lblRSSLibrary.setForeground(MyColors.ForgotPincodeFG);
            if (Util.isWindow7()) {
                this.menuDescription.setIcon(null);
                this.menuSubject.setIcon(null);
            }
            for (int i = 0; i < this.columnNames.length; ++i) {
                this.columns.addElement(this.columnNames[i]);
            }
            this.tableModel.setDataVector(this.rows, this.columns);
            this.table.setModel(this.tableModel);
            this.table.setTableHeader(null);
            this.table.setDefaultRenderer(Object.class, this.messageRender);
            TableColumn col = this.table.getColumnModel().getColumn(0);
            col.setCellEditor(this.messageRender);
            this.rssUrlHolder = new RSSURLHolder(this);
            this.Add_CollapsiblePane.add((Component)this.rssUrlHolder);
            this.Add_CollapsiblePane.setDirection(JXCollapsiblePane.Direction.LEFT);
            this.Add_CollapsiblePane.setCollapsed(false);
            this.rssUrlHolder.expandAll();
            this.RSSSearch = new RSSSearchPanel(this);
            this.collapsiblePane.add((Component)this.RSSSearch);
            this.collapsiblePane.setCollapsed(true);
            this.table.setRowHeight(90);
            this.btnDecn.setLayout(new BorderLayout());
            this.btnDecn.setMargin(new Insets(-5, -5, -5, -5));
            this.dropDownDec = new BasicArrowButton(5);
            this.dropDownDec.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
            this.dropDownDec.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    RSSTab.this.isAsec = false;
                    RSSTab.this.sortMenu.show(RSSTab.this.btnDecn, evt.getX() + 2, evt.getY() + 7);
                }
            });
            this.btnDecn.add((Component)this.dropDownDec, "East");
            this.btnAsen.setLayout(new BorderLayout());
            this.btnAsen.setMargin(new Insets(-5, -5, -5, -5));
            this.dropDownAsc = new BasicArrowButton(5);
            this.dropDownAsc.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
            this.dropDownAsc.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    RSSTab.this.isAsec = true;
                    RSSTab.this.sortMenu.show(RSSTab.this.btnAsen, evt.getX() + 2, evt.getY() + 7);
                }
            });
            this.btnAsen.add((Component)this.dropDownAsc, "East");
            this.feedTimmer.schedule(this.timer, 60000L, 300000L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.tableModel.fireTableDataChanged();
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RSSTab.this.tableModel.fireTableDataChanged();
                    RSSTab.this.table.addNotify();
                    RSSTab.this.table.repaint();
                }
            });
        }
    }

    public synchronized void addAllRows(Feed feed_, List list, String url) {
        ArrayList al = (ArrayList)list;
        LogsKSE.RSSMsgCount = al.size();
        ArrayList<Object> ReadUnReadList = new ArrayList();
        if (this.ReadUnReadHolder.containsKey(url)) {
            ReadUnReadList = this.ReadUnReadHolder.get(url);
        } else {
            this.ReadUnReadHolder.put(url, ReadUnReadList);
        }
        boolean FirstVisit = true;
        if (ReadUnReadList.size() > 0) {
            FirstVisit = false;
        }
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        this.rows.clear();
        RssCounter = 0;
        for (int i = 0; i < al.size(); ++i) {
            if (!(al.get(i) instanceof FeedMessage)) continue;
            FeedMessage fm = (FeedMessage)al.get(i);
            if (FirstVisit) {
                ReadUnReadList.add(url + " " + fm.getTitle());
                this.addRow(fm, false);
                continue;
            }
            if (ReadUnReadList.contains(url + " " + fm.getTitle())) {
                this.addRow(fm, false);
                continue;
            }
            ReadUnReadList.add(url + " " + fm.getTitle());
            this.addRow(fm, true);
        }
        this.tableDataChange();
        this.setUpdateTime(url);
        Util.ScrollToFirstOrLastRow((boolean)LogCommon.isTop, (JTable)this.table, (JScrollPane)this.jScrollPane1);
    }

    private synchronized void addRow(FeedMessage fm, boolean isBlink) {
        if (fm != null) {
            RSSMessage m = new RSSMessage();
            m.id.value = ++this.id + "";
            m.title.value = fm.getTitle();
            m.pubDate.value = fm.getPubDate();
            m.summary.value = fm.getDescription();
            m.link.value = fm.getLink();
            this.RSSSearch.setFeedValues(m);
            if (LogCommon.isTop) {
                MessageDisplay dispay = new MessageDisplay(m);
                this.rows.add(0, dispay);
            } else {
                MessageDisplay dispay = new MessageDisplay(m);
                this.rows.add(this.rows.size(), dispay);
            }
            if (isBlink) {
                this.timerMap.put(m.id.value, this.Blink(m.id.value, isBlink));
            }
        }
    }

    public synchronized javax.swing.Timer Blink(final String idNO, boolean isStart) {
        final javax.swing.Timer BlinkTimmer = new javax.swing.Timer(0, null);
        ActionListener ac = new ActionListener(){
            int i = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.i >= 10) {
                    int rowNo = RSSTab.this.getRowNo(idNO);
                    if (rowNo >= 0) {
                        MessageDisplay md = RSSTab.this.rows.get(rowNo);
                        md.RSS_setRSSColor(false);
                        BlinkTimmer.stop();
                        RSSTab.this.tableDataChange();
                        RSSTab.this.timerMap.remove(md.feed.id.value);
                    }
                } else {
                    int rowNo = RSSTab.this.getRowNo(idNO);
                    if (rowNo >= 0) {
                        MessageDisplay md = RSSTab.this.rows.get(rowNo);
                        if (this.i % 2 == 0) {
                            md.RSS_setRSSColor(false);
                        } else {
                            md.RSS_setRSSColor(true);
                        }
                        RSSTab.this.tableDataChange();
                        ++this.i;
                    }
                }
            }
        };
        BlinkTimmer.addActionListener(ac);
        BlinkTimmer.setDelay(500);
        BlinkTimmer.setRepeats(true);
        if (isStart) {
            BlinkTimmer.start();
        }
        return BlinkTimmer;
    }

    public void stopBlink(int rowNo) {
        try {
            MessageDisplay md = this.rows.get(rowNo);
            if (this.timerMap.containsKey(md.feed.id.value)) {
                javax.swing.Timer T = this.timerMap.get(md.feed.id.value);
                T.stop();
                this.timerMap.remove(md.feed.id.value);
                md.RSS_setRSSColor(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getRowNo(String msgID) {
        for (int i = 0; i < this.rows.size(); ++i) {
            MessageDisplay md = this.rows.get(i);
            if (!md.feed.id.value.equalsIgnoreCase(msgID)) continue;
            return i;
        }
        return -1;
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.sortMenu = new JPopupMenu();
        this.menuSubject = new JCheckBoxMenuItem();
        this.menuDescription = new JCheckBoxMenuItem();
        this.buttonGroup1 = new ButtonGroup();
        this.jToolBar1 = new JToolBar();
        this.btnExpand = new JButton();
        this.btnSearch1 = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.btnAsen = new JButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.btnDecn = new JButton();
        this.jSeparator5 = new JToolBar.Separator();
        this.lblRSSSource = new JLabel();
        this.txtURL = new JTextField();
        this.btnAdd = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.lblRSSLibrary = new JLabel();
        this.jSeparator2 = new JToolBar.Separator();
        this.lblMessage = new JLabel();
        this.jPanel1 = new JPanel();
        this.collapsiblePane = new JXCollapsiblePane();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.Add_CollapsiblePane = new JXCollapsiblePane();
        this.buttonGroup1.add(this.menuSubject);
        this.menuSubject.setSelected(true);
        this.menuSubject.setText("Subject");
        this.menuSubject.setIcon(new ImageIcon(this.getClass().getResource("/Images/subject16.png")));
        this.menuSubject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RSSTab.this.menuSubjectActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuSubject);
        this.buttonGroup1.add(this.menuDescription);
        this.menuDescription.setText("Description");
        this.menuDescription.setIcon(new ImageIcon(this.getClass().getResource("/Images/description16.png")));
        this.menuDescription.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RSSTab.this.menuDescriptionActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuDescription);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setMaximumSize(new Dimension(116, 21));
        this.jToolBar1.setMinimumSize(new Dimension(116, 21));
        this.jToolBar1.setPreferredSize(new Dimension(100, 18));
        this.btnExpand.setIcon(new ImageIcon(this.getClass().getResource("/Images/LeftArrow.png")));
        this.btnExpand.setToolTipText("RSS Sources");
        this.btnExpand.setFocusable(false);
        this.btnExpand.setHorizontalAlignment(2);
        this.btnExpand.setHorizontalTextPosition(4);
        this.btnExpand.setMaximumSize(new Dimension(16, 18));
        this.btnExpand.setMinimumSize(new Dimension(18, 12));
        this.btnExpand.setVerticalTextPosition(3);
        this.btnExpand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RSSTab.this.btnExpandActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnExpand);
        this.btnSearch1.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
        this.btnSearch1.setText("Search");
        this.btnSearch1.setToolTipText("Search");
        this.btnSearch1.setFocusable(false);
        this.btnSearch1.setHorizontalTextPosition(4);
        this.btnSearch1.setMaximumSize(new Dimension(65, 18));
        this.btnSearch1.setVerticalTextPosition(3);
        this.btnSearch1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RSSTab.this.btnSearch1ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnSearch1);
        this.jSeparator3.setMinimumSize(new Dimension(8, 3));
        this.jSeparator3.setPreferredSize(new Dimension(8, 3));
        this.jToolBar1.add(this.jSeparator3);
        this.btnAsen.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
        this.btnAsen.setToolTipText("Sort Ascending");
        this.btnAsen.setFocusable(false);
        this.btnAsen.setHorizontalTextPosition(0);
        this.btnAsen.setMaximumSize(new Dimension(35, 18));
        this.btnAsen.setMinimumSize(new Dimension(35, 12));
        this.btnAsen.setPreferredSize(new Dimension(35, 12));
        this.btnAsen.setVerticalTextPosition(3);
        this.btnAsen.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RSSTab.this.btnAsenMousePressed(evt);
            }
        });
        this.btnAsen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RSSTab.this.btnAsenActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnAsen);
        this.jSeparator4.setMinimumSize(new Dimension(8, 3));
        this.jSeparator4.setPreferredSize(new Dimension(8, 3));
        this.jToolBar1.add(this.jSeparator4);
        this.btnDecn.setIcon(new ImageIcon(this.getClass().getResource("/Images/descending12.png")));
        this.btnDecn.setToolTipText("Sort Descending");
        this.btnDecn.setFocusable(false);
        this.btnDecn.setHorizontalTextPosition(0);
        this.btnDecn.setMaximumSize(new Dimension(35, 18));
        this.btnDecn.setMinimumSize(new Dimension(35, 12));
        this.btnDecn.setPreferredSize(new Dimension(35, 12));
        this.btnDecn.setVerticalTextPosition(3);
        this.btnDecn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RSSTab.this.btnDecnMousePressed(evt);
            }
        });
        this.btnDecn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RSSTab.this.btnDecnActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnDecn);
        this.jSeparator5.setMinimumSize(new Dimension(8, 3));
        this.jSeparator5.setPreferredSize(new Dimension(8, 3));
        this.jToolBar1.add(this.jSeparator5);
        this.lblRSSSource.setHorizontalAlignment(2);
        this.lblRSSSource.setIcon(new ImageIcon(this.getClass().getResource("/Images/RSSSources.png")));
        this.lblRSSSource.setText("RSS Source  ");
        this.lblRSSSource.setMaximumSize(new Dimension(80, 18));
        this.lblRSSSource.setMinimumSize(new Dimension(80, 18));
        this.lblRSSSource.setPreferredSize(new Dimension(80, 18));
        this.jToolBar1.add(this.lblRSSSource);
        this.txtURL.setText("Please enter source");
        this.txtURL.setForeground(Color.darkGray);
        this.txtURL.setMaximumSize(new Dimension(180, 22));
        this.txtURL.setMinimumSize(new Dimension(180, 22));
        this.txtURL.setPreferredSize(new Dimension(180, 22));
        this.txtURL.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RSSTab.this.txtURLMouseClicked(evt);
            }
        });
        this.txtURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RSSTab.this.txtURLActionPerformed(evt);
            }
        });
        this.txtURL.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                RSSTab.this.txtURLFocusGained(evt);
            }
        });
        this.jToolBar1.add(this.txtURL);
        this.btnAdd.setIcon(new ImageIcon(this.getClass().getResource("/Images/RSSSubscribe.png")));
        this.btnAdd.setText("Subscribe");
        this.btnAdd.setOpaque(false);
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RSSTab.this.btnAddActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnAdd);
        this.jSeparator1.setMinimumSize(new Dimension(8, 3));
        this.jSeparator1.setPreferredSize(new Dimension(8, 3));
        this.jToolBar1.add(this.jSeparator1);
        this.lblRSSLibrary.setText("RSS Library");
        this.lblRSSLibrary.setVerticalAlignment(3);
        this.lblRSSLibrary.setMaximumSize(new Dimension(57, 18));
        this.lblRSSLibrary.setMinimumSize(new Dimension(57, 18));
        this.lblRSSLibrary.setPreferredSize(new Dimension(57, 18));
        this.lblRSSLibrary.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                RSSTab.this.lblRSSLibraryMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                RSSTab.this.lblRSSLibraryMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                RSSTab.this.lblRSSLibraryMousePressed(evt);
            }
        });
        this.jToolBar1.add(this.lblRSSLibrary);
        this.jSeparator2.setMinimumSize(new Dimension(8, 3));
        this.jSeparator2.setPreferredSize(new Dimension(8, 3));
        this.jToolBar1.add(this.jSeparator2);
        this.lblMessage.setVerticalAlignment(3);
        this.lblMessage.setMaximumSize(new Dimension(150, 18));
        this.lblMessage.setMinimumSize(new Dimension(150, 18));
        this.lblMessage.setPreferredSize(new Dimension(150, 18));
        this.jToolBar1.add(this.lblMessage);
        this.jPanel1.setPreferredSize(new Dimension(461, 400));
        this.collapsiblePane.setOpaque(false);
        this.jScrollPane1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RSSTab.this.jScrollPane1MouseClicked(evt);
            }
        });
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}}, new String[]{"Title", "Published Date", "Description", "Details"}));
        this.table.setRowSelectionAllowed(false);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RSSTab.this.tableMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                RSSTab.this.tableMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                RSSTab.this.tableMousePressed(evt);
            }
        });
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                RSSTab.this.tableMouseMoved(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        this.Add_CollapsiblePane.setBackground(new Color(255, 255, 255));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.collapsiblePane, -1, 660, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGap(1, 1, 1).addComponent((Component)this.Add_CollapsiblePane, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 659, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent((Component)this.collapsiblePane, -2, -1, -2).addGap(0, 0, 0).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 153, Short.MAX_VALUE).addComponent((Component)this.Add_CollapsiblePane, -1, 153, Short.MAX_VALUE)).addGap(0, 0, 0)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, 660, Short.MAX_VALUE).addComponent(this.jToolBar1, -1, 660, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 18, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, 153, Short.MAX_VALUE)));
    }

    private void showPopupMenu(MouseEvent evt, Component com) {
        if (SwingUtilities.isRightMouseButton(evt)) {
            this.popupMenu.show(com, evt.getX(), evt.getY());
        }
    }

    private void tableMousePressed(MouseEvent evt) {
        int row = this.table.getSelectedRow();
        this.stopBlink(row);
    }

    private void tableMouseClicked(MouseEvent evt) {
        this.showPopupMenu(evt, this.table);
    }

    private void tableMouseEntered(MouseEvent evt) {
    }

    private void jScrollPane1MouseClicked(MouseEvent evt) {
        this.showPopupMenu(evt, this.jScrollPane1);
    }

    private void tableMouseMoved(MouseEvent evt) {
        int row = this.table.getSelectedRow();
        if (row > -1 && row < this.rows.size()) {
            MessageDisplay md = this.rows.get(row);
            if (!this.timerMap.containsKey(md.feed.id.value)) {
                try {
                    int rowindex = this.table.rowAtPoint(evt.getPoint());
                    this.table.editCellAt(rowindex, 0);
                    TableCellEditor tableCellEditor = this.table.getCellEditor(rowindex, 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                RSSTab.this.addURL();
            }
        }, "btnAddActionPerformed").start();
    }

    private void btnExpandActionPerformed(ActionEvent evt) {
        boolean state = this.Add_CollapsiblePane.isCollapsed();
        if (state) {
            this.Add_CollapsiblePane.setCollapsed(false);
            this.btnExpand.setIcon(new ImageIcon(this.getClass().getResource("/Images/LeftArrow.png")));
        } else {
            this.Add_CollapsiblePane.setCollapsed(true);
            this.btnExpand.setIcon(new ImageIcon(this.getClass().getResource("/Images/RightArrow.png")));
        }
    }

    private void menuSubjectActionPerformed(ActionEvent evt) {
        this.callSort(0, this.isAsec);
    }

    private void menuDescriptionActionPerformed(ActionEvent evt) {
        this.callSort(1, this.isAsec);
    }

    private void btnAsenActionPerformed(ActionEvent evt) {
        if (this.menuSubject.isSelected()) {
            this.callSort(0, true);
        } else if (this.menuDescription.isSelected()) {
            this.callSort(1, true);
        }
    }

    private void btnDecnActionPerformed(ActionEvent evt) {
        if (this.menuSubject.isSelected()) {
            this.callSort(0, false);
        } else if (this.menuDescription.isSelected()) {
            this.callSort(1, false);
        }
    }

    private void btnAsenMousePressed(MouseEvent evt) {
    }

    private void btnDecnMousePressed(MouseEvent evt) {
    }

    private void txtURLMouseClicked(MouseEvent evt) {
        if (SwingUtilities.isRightMouseButton(evt)) {
            this.rssUrlHolder.popupMenu2.show(this.txtURL, evt.getX(), evt.getY());
        }
    }

    private void btnSearch1ActionPerformed(ActionEvent evt) {
        boolean state = this.collapsiblePane.isCollapsed();
        this.collapsiblePane.setCollapsed(!state);
        this.RSSSearch.ClearText();
    }

    private void txtURLFocusGained(FocusEvent evt) {
        this.txtURL.selectAll();
    }

    private void lblRSSLibraryMouseEntered(MouseEvent evt) {
        this.lblRSSLibrary.setText("<html><u> RSS Library</u></html>");
    }

    private void lblRSSLibraryMouseExited(MouseEvent evt) {
        this.lblRSSLibrary.setText("<html> RSS Library</html>");
    }

    private void lblRSSLibraryMousePressed(MouseEvent evt) {
        new RSSListForm(this);
    }

    private void txtURLActionPerformed(ActionEvent evt) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                RSSTab.this.addURL();
            }
        }, "txtURLActionPerformed").start();
    }

    public void deleteTreeRow() {
        String nodeName = this.rssUrlHolder.tree.getLastSelectedPathComponent().toString();
        int Selectindex = this.rssUrlHolder.tree.getRowForPath(this.rssUrlHolder.tree.getSelectionPath());
        int con = JOptionPane.showConfirmDialog(null, "Do you want to delete RSS source", "RSS Source Deletion", 0);
        if (con == 0) {
            this.rssUrlHolder.removeNode(nodeName);
            this.rows.clear();
            this.tableDataChange();
            String url = this.rssUrlHolder.getRSSURL(nodeName.split("\\(")[0]);
            this.URLMap.remove(url);
            this.AddURLInfo();
        }
    }

    public synchronized Feed ReadFeed(FeedParser feedParser) throws Exception {
        Feed feed = feedParser.readFeed();
        String URL2 = feedParser.url.toString();
        if (this.lastUpdateTime.containsKey(URL2)) {
            this.lastUpdateTime.remove(URL2);
            this.lastUpdateTime.put(URL2, new Date());
        } else {
            this.lastUpdateTime.put(URL2, new Date());
        }
        ArrayList<Object> ReadUnReadList = null;
        if (this.ReadUnReadHolderForPopUP.containsKey(URL2)) {
            int NewRSSCounter = 0;
            ReadUnReadList = this.ReadUnReadHolderForPopUP.get(URL2);
            ArrayList al = (ArrayList)feed.getMessages();
            for (int j = 0; j < al.size(); ++j) {
                if (!(al.get(j) instanceof FeedMessage)) continue;
                FeedMessage fm = (FeedMessage)al.get(j);
                if (ReadUnReadList.contains(URL2 + " " + fm.getTitle())) continue;
                ReadUnReadList.add(URL2 + " " + fm.getTitle());
                ++NewRSSCounter;
            }
            if (NewRSSCounter > 0 && LogCommon.DesktopAlert_RSS) {
                Mediator.getInstance().toasterManager.showToaster(Mediator.getInstance().toasterManager, this.URLMap.get(URL2), NewRSSCounter + " New RSS Feed", "RSS");
                NewRSSCounter = 0;
            }
        } else {
            ReadUnReadList = new ArrayList();
            this.ReadUnReadHolderForPopUP.put(URL2, ReadUnReadList);
            ArrayList al = (ArrayList)feed.getMessages();
            for (int j = 0; j < al.size(); ++j) {
                if (!(al.get(j) instanceof FeedMessage)) continue;
                FeedMessage fm = (FeedMessage)al.get(j);
                ReadUnReadList.add(URL2 + " " + fm.getTitle());
            }
        }
        this.setUpdateTime(URL2);
        return feed;
    }

    public void Refresh(String RefreshURL) {
        try {
            this.feedParser.setURL(RefreshURL);
            this.feed = this.ReadFeed(this.feedParser);
            this.feedMap.put(RefreshURL, this.feed);
            this.rssUrlHolder.getRSSFeedParser(RefreshURL);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addURL() {
        if (this.URLMap.size() >= AppConfig.RSSURLMaxCount) {
            JOptionPane.showMessageDialog(null, "We are sorry; you can not add more then " + AppConfig.RSSURLMaxCount + " RSS Sources.");
            this.txtURL.requestFocus();
            this.btnAdd.setEnabled(true);
            this.txtURL.setEnabled(true);
            return;
        }
        try {
            String url = this.txtURL.getText().trim();
            if (url.length() <= 0 || url.equalsIgnoreCase("Please enter source")) {
                JOptionPane.showMessageDialog(null, "Plese enter source and hit subscribe button.");
                this.lblMessage.setIcon(null);
                this.lblMessage.setText("");
                this.txtURL.requestFocus();
                this.btnAdd.setEnabled(true);
                this.txtURL.setEnabled(true);
                return;
            }
            if (this.URLMap.containsKey(url)) {
                JOptionPane.showMessageDialog(null, "Provided source already exists.");
                this.lblMessage.setIcon(null);
                this.lblMessage.setText("");
                this.txtURL.requestFocus();
                this.btnAdd.setEnabled(true);
                this.txtURL.setEnabled(true);
                return;
            }
            this.lblMessage.setText("  Verifying...");
            this.lblMessage.setIcon(this.rssUrlHolder.loaderIcon);
            if (!Util.isPageExists((String)url)) {
                this.lblMessage.setIcon(null);
                this.lblMessage.setText("");
                this.txtURL.requestFocus();
                this.btnAdd.setEnabled(true);
                this.txtURL.setEnabled(true);
                JOptionPane.showMessageDialog(null, "Provided source is invalid.");
                return;
            }
            if (FeedParser.isValidRSS(url) == -1) {
                this.lblMessage.setIcon(null);
                this.lblMessage.setText("");
                this.btnAdd.setEnabled(true);
                this.txtURL.setEnabled(true);
                JOptionPane.showMessageDialog(null, "Provided source is invalid.");
                return;
            }
            this.btnAdd.setEnabled(false);
            this.txtURL.setEnabled(false);
            if (!this.rssUrlHolder.model.contains(url)) {
                this.addNode(url);
                this.lblMessage.setText("");
                this.lblMessage.setIcon(null);
                this.txtURL.setText("");
            }
            this.btnAdd.setEnabled(true);
            this.txtURL.setEnabled(true);
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.lblMessage.setIcon(null);
            this.lblMessage.setText("");
            this.txtURL.requestFocus();
            this.btnAdd.setEnabled(true);
            this.txtURL.setEnabled(true);
            JOptionPane.showMessageDialog(null, "Provided source is invalid.");
            return;
        }
    }

    public void addNode(String nodeName) {
        this.model = (DefaultTreeModel)this.rssUrlHolder.tree.getModel();
        if (!nodeName.equals("")) {
            this.Add_CollapsiblePane.setCollapsed(false);
            this.btnExpand.setIcon(new ImageIcon(this.getClass().getResource("/Images/LeftArrow.png")));
            String TextURLs = this.txtURL.getText().trim();
            String DTitle = new FeedParser().getDefaultTitle(this.txtURL.getText().trim()).split("\\|")[0];
            nNode = new DefaultMutableTreeNode(DTitle);
            if (TextURLs != null && !this.URLMap.containsKey(TextURLs)) {
                this.URLMap.put(TextURLs, DTitle);
            }
            this.AddURLInfo();
            this.path = this.rssUrlHolder.tree.getNextMatch(this.rssUrlHolder.treeTitle, 0, Position.Bias.Forward);
            this.node = (MutableTreeNode)this.path.getLastPathComponent();
            this.model.insertNodeInto(nNode, this.node, this.node.getChildCount());
            TreePath treePath = this.rssUrlHolder.tree.getNextMatch(DTitle, 0, Position.Bias.Forward);
            if (treePath == null) {
                this.rssUrlHolder.tree.setSelectionPath(this.path);
                this.rssUrlHolder.tree.scrollPathToVisible(this.path);
            } else {
                this.rssUrlHolder.tree.setSelectionPath(treePath);
                this.rssUrlHolder.tree.scrollPathToVisible(treePath);
            }
            this.rssUrlHolder.getRSSFeedParser(this.txtURL.getText().trim());
            this.rssUrlHolder.expandAll();
            if (this.feedMap.containsKey(TextURLs)) {
                Feed feed2 = this.feedMap.get(TextURLs);
                this.rssUrlHolder.RenameNode(DTitle, feed2.getMessages().size());
            }
        }
    }

    public void AddURLInfo() {
        LogCommon.RSSURL = "";
        Iterator<Map.Entry<String, String>> iterator = this.URLMap.entrySet().iterator();
        while (iterator.hasNext()) {
            String[] mapa = iterator.next().toString().split("\\=");
            LogCommon.RSSURL = LogCommon.RSSURL + mapa[0] + "|" + mapa[1] + "$";
        }
    }

    private void callSort(int index, boolean ascSec) {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        Collections.sort(this.rows, new MyRSSComparator(index, ascSec));
        this.table.tableChanged(new TableModelEvent(this.tableModel));
        this.tableDataChange();
    }

    public Vector<MessageDisplay> callSort(Vector<MessageDisplay> rows_, int index, boolean ascSec) {
        Collections.sort(rows_, new MyRSSComparator(index, ascSec));
        return rows_;
    }

    public void callSearch(String findWhat, ShowRSSSearchResult showRSSSearch) {
        String find = findWhat.toUpperCase().trim();
        Vector<MessageDisplay> temp = new Vector<MessageDisplay>();
        for (int i = 0; i < this.rows.size(); ++i) {
            MessageDisplay messageDisplay = this.rows.elementAt(i);
            String titTemp = messageDisplay.feed.title.value.toUpperCase();
            String SummeryTemp = messageDisplay.feed.summary.value.toUpperCase();
            if (titTemp.indexOf(find) < 0 && SummeryTemp.indexOf(find) < 0) continue;
            temp.add(messageDisplay);
        }
        Util.setMessage((JLabel)this.RSSSearch.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        if (temp.size() <= 0) {
            SearchNotFound ss = new SearchNotFound((Frame)TradeCast.getInstance().frame, true, findWhat);
            ss.setVisible(true);
        } else if (showRSSSearch != null) {
            showRSSSearch.addAllDataWithoutBlink(temp, findWhat);
            showRSSSearch.requestFocus();
        } else {
            ShowRSSSearchResult showSearchResult = new ShowRSSSearchResult(this, TradeCast.getInstance().frame, false, this.type);
            showSearchResult.setVisible(true);
            showSearchResult.addAllDataWithoutBlink(temp, findWhat);
            showSearchResult.requestFocus();
        }
    }

    public void TabChange() {
        if (this.FirstTimeInTab) {
            this.FirstTimeInTab = false;
            this.collapsiblePane.setCollapsed(false);
            this.collapsiblePane.setCollapsed(true);
            this.rssUrlHolder.LoadOnFirstVisit();
        }
    }

    private void setUpdateTime(String url) {
        if (this.lastUpdateTime.containsKey(url) && this.rssUrlHolder.lastShowingURL.equalsIgnoreCase(url)) {
            this.lblMessage.setText("  Last updated : " + LogsTC.RSSDateFormat.format(this.lastUpdateTime.get(url)));
        }
    }

    class MyRSSComparator
    implements Comparator {
        protected int m_sortCol;
        protected boolean m_sortAsc;

        public MyRSSComparator(int sortCol, boolean sortAsc) {
            this.m_sortCol = sortCol;
            this.m_sortAsc = sortAsc;
        }

        public int compare(Object o1, Object o2) {
            int result = 0;
            MessageDisplay s1 = null;
            MessageDisplay s2 = null;
            if (o1 instanceof MessageDisplay && o2 instanceof MessageDisplay) {
                s1 = (MessageDisplay)o1;
                s2 = (MessageDisplay)o2;
            }
            switch (this.m_sortCol) {
                case 0: {
                    result = s1.feed.title.value.compareTo(s2.feed.title.value);
                    break;
                }
                case 1: {
                    result = s1.feed.summary.value.compareTo(s2.feed.summary.value);
                }
            }
            if (!this.m_sortAsc) {
                result = -result;
            }
            return result;
        }
    }
}

