/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import MessageWindow.Feed;
import MessageWindow.RSSTab;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.MyColors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import javax.xml.stream.XMLStreamException;

public class RSSURLHolder
extends JPanel {
    ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    DefaultListModel model = new DefaultListModel();
    private RSSTab rssTab;
    final String treeTitle = "RSS Sources";
    String lastShowingURL = "RSS Sources";
    final DefaultMutableTreeNode RSSURL = new DefaultMutableTreeNode("RSS Sources");
    JPopupMenu popupMenu = new JPopupMenu();
    JPopupMenu popupMenu2 = new JPopupMenu();
    private JScrollPane jScrollPane2;
    public JTree tree;

    public RSSURLHolder(final RSSTab rssTab) {
        this.rssTab = rssTab;
        this.initComponents();
        ImageIcon ChildIcon = new ImageIcon(this.getClass().getResource("/Images/RSS.png"));
        ImageIcon ParentIcon = new ImageIcon(this.getClass().getResource("/Images/RSSSources.png"));
        MyRenderer render = new MyRenderer((Icon)ChildIcon, ParentIcon);
        this.tree.setCellRenderer(render);
        this.tree.setBorder(null);
        render.setTextSelectionColor(Color.BLACK);
        render.setBackgroundSelectionColor(MyColors.MarketWatchSelectedRowColor);
        render.setBorderSelectionColor(MyColors.MarketWatchSelectedRowColor);
        render.setBorder(null);
        JMenuItem removeURL = new JMenuItem("Delete       ");
        removeURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String nodeName = RSSURLHolder.this.tree.getLastSelectedPathComponent().toString();
                int Selectindex = RSSURLHolder.this.tree.getRowForPath(RSSURLHolder.this.tree.getSelectionPath());
                String name = nodeName.split("\\(")[0];
                int con = JOptionPane.showConfirmDialog(null, "Do you want to delete " + name + "?", "RSS Source Deletion", 0);
                if (con == 0) {
                    RSSURLHolder.this.removeNode(nodeName);
                    rssTab.rows.clear();
                    rssTab.table.addNotify();
                    String url = RSSURLHolder.this.getRSSURL(nodeName.split("\\(")[0]);
                    rssTab.URLMap.remove(url);
                    rssTab.AddURLInfo();
                }
            }
        });
        removeURL.setIcon(new ImageIcon(this.getClass().getResource("/Images/delete.png")));
        this.popupMenu.add(removeURL);
        JMenuItem refresh = new JMenuItem("Refresh       ");
        refresh.addActionListener(new ActionListener(){
            boolean InRefresh = false;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!this.InRefresh) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            InRefresh = true;
                            String nodeName = RSSURLHolder.this.tree.getLastSelectedPathComponent().toString();
                            String url = RSSURLHolder.this.getRSSURL(nodeName.split("\\(")[0]);
                            rssTab.Refresh(url);
                            InRefresh = false;
                        }
                    }, "refresh").start();
                }
            }
        });
        refresh.setIcon(new ImageIcon(this.getClass().getResource("/Images/refresh.png")));
        this.popupMenu.add(refresh);
        JMenuItem paste = new JMenuItem("Paste        ");
        paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                rssTab.txtURL.setText(RSSURLHolder.this.getClipboard());
            }
        });
        paste.setIcon(new ImageIcon(this.getClass().getResource("/Images/paste.png")));
        this.popupMenu2.add(paste);
        if (!LogCommon.RSSURL.equalsIgnoreCase("null")) {
            this.addNodes(LogCommon.RSSURL);
        }
    }

    public void getRemoveRSSURLUpdate(String name, int index) {
        LogCommon.RSSURL = "";
        for (int i = 0; i < this.rssTab.countURL; ++i) {
            if (this.rssTab.URLTitleInfo[i][1].equalsIgnoreCase(name)) continue;
            LogCommon.RSSURL = LogCommon.RSSURL + this.rssTab.URLTitleInfo[i][0] + "|" + this.rssTab.URLTitleInfo[i][1] + "$";
        }
        --this.rssTab.countURL;
    }

    public void addNode(String nodeName) {
        this.rssTab.model = (DefaultTreeModel)this.tree.getModel();
        if (nodeName != null) {
            RSSTab.nNode = new DefaultMutableTreeNode(nodeName);
            this.rssTab.path = this.tree.getNextMatch("RSS Sources", 0, Position.Bias.Forward);
            this.rssTab.node = (MutableTreeNode)this.rssTab.path.getLastPathComponent();
            this.rssTab.model.insertNodeInto(RSSTab.nNode, this.rssTab.node, this.rssTab.node.getChildCount());
        }
    }

    private void addNodes(String nodeName) {
        if (!nodeName.equalsIgnoreCase("")) {
            String[] Url = nodeName.split("\\$");
            for (int i = 0; i < Url.length; ++i) {
                String[] URLFeed = Url[i].split("\\|");
                if (!this.rssTab.URLMap.containsKey(URLFeed[0])) {
                    this.rssTab.URLMap.put(URLFeed[0], URLFeed[1]);
                }
                if (Url[i].equals("")) continue;
                this.addNode(URLFeed[1]);
            }
        }
    }

    public void removeNode(String nodeName) {
        this.rssTab.model = (DefaultTreeModel)this.tree.getModel();
        if (!nodeName.equals("")) {
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            if (selNode == null) {
                return;
            }
            MutableTreeNode parent = (MutableTreeNode)selNode.getParent();
            if (parent == null) {
                return;
            }
            MutableTreeNode toBeSelNode = selNode.getPreviousSibling();
            if (toBeSelNode == null) {
                toBeSelNode = selNode.getNextSibling();
            }
            if (toBeSelNode == null) {
                toBeSelNode = parent;
            }
            Object[] nodes = this.rssTab.model.getPathToRoot(toBeSelNode);
            TreePath path = new TreePath(nodes);
            this.tree.scrollPathToVisible(path);
            this.tree.setSelectionPath(path);
            this.rssTab.model.removeNodeFromParent(selNode);
        }
        if (nodeName.equalsIgnoreCase(this.lastShowingURL)) {
            this.rssTab.rows.clear();
            this.rssTab.table.addNotify();
        }
    }

    public void RenameNode(String text, int Size) {
        try {
            int startRow = 0;
            String prefix = text;
            TreePath path = this.tree.getNextMatch(prefix, startRow, Position.Bias.Forward);
            MutableTreeNode node = (MutableTreeNode)path.getLastPathComponent();
            node.setUserObject(text + "(" + Size + ")");
            this.rssTab.model.nodeChanged(node);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setText(KeyEvent evt) {
        if (38 == evt.getKeyCode() || 40 == evt.getKeyCode()) {
            // empty if block
        }
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.tree = new JTree(this.RSSURL);
        this.jScrollPane2.setName("jScrollPane2");
        this.tree.setName("tree");
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RSSURLHolder.this.treeMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                RSSURLHolder.this.treeMousePressed(evt);
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                RSSURLHolder.this.treeValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.tree);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 189, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING, -1, 77, Short.MAX_VALUE));
    }

    private void treeMousePressed(MouseEvent evt) {
    }

    public String getRSSURL(String str) {
        for (String obj : this.rssTab.URLMap.keySet()) {
            String st = this.rssTab.URLMap.get(obj).toString();
            if (!st.equalsIgnoreCase(str)) continue;
            return obj.toString();
        }
        return "";
    }

    public void getRSSFeedParser(String url) {
        if (url.equalsIgnoreCase("RSS Sources") || url.equalsIgnoreCase("")) {
            return;
        }
        this.lastShowingURL = url;
        if (this.rssTab.feedMap.containsKey(url)) {
            try {
                Feed feed = this.rssTab.feedMap.get(url);
                ArrayList al = (ArrayList)feed.getMessages();
                this.rssTab.addAllRows(feed, al, url);
                this.RenameNode(this.rssTab.URLMap.get(url).toString(), feed.getMessages().size());
            }
            catch (UnsupportedOperationException ex) {
                ex.printStackTrace();
            }
        } else {
            try {
                this.rssTab.feedParser.setURL(url);
                Feed feed = this.rssTab.ReadFeed(this.rssTab.feedParser);
                this.rssTab.feedMap.put(url, feed);
                this.rssTab.addAllRows(feed, feed.getMessages(), url);
                this.rssTab.table.getSelectionModel().setSelectionInterval(0, 0);
                this.RenameNode(this.rssTab.URLMap.get(url).toString(), feed.getMessages().size());
            }
            catch (UnsupportedOperationException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (XMLStreamException ex) {
                ex.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void treeMouseClicked(MouseEvent evt) {
        if (!this.tree.getLastSelectedPathComponent().toString().equalsIgnoreCase("RSS Sources") && SwingUtilities.isRightMouseButton(evt) && !this.tree.isSelectionEmpty()) {
            this.popupMenu.show(this.tree, evt.getX(), evt.getY());
        }
    }

    private void treeValueChanged(TreeSelectionEvent evt) {
        if (this.tree.getLastSelectedPathComponent() != null && !this.tree.getLastSelectedPathComponent().toString().equalsIgnoreCase("RSS Sources")) {
            final String url = this.getRSSURL(this.tree.getLastSelectedPathComponent().toString().split("\\(")[0]);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    RSSURLHolder.this.getRSSFeedParser(url);
                }
            }, "treeValueChanged").start();
        }
    }

    public String getClipboard() {
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String text = (String)t.getTransferData(DataFlavor.stringFlavor);
                return text;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    void LoadOnFirstVisit() {
        String URLForFirstTime = "";
        if (this.rssTab.URLMap.size() > 0) {
            Iterator<String> en = this.rssTab.URLMap.keySet().iterator();
            if (en.hasNext()) {
                URLForFirstTime = en.next().toString();
            }
            this.expandAll();
            this.tree.setSelectionInterval(1, 1);
        }
    }

    public void expandAll() {
        for (int row = 0; row < this.tree.getRowCount(); ++row) {
            this.tree.expandRow(row);
        }
    }

    class MyRenderer
    extends DefaultTreeCellRenderer {
        Icon tutorialIcon;
        Icon ParentIcon;

        public MyRenderer(Icon icon, Icon ParentIcon) {
            this.tutorialIcon = icon;
            this.ParentIcon = ParentIcon;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (leaf) {
                this.setIcon(this.tutorialIcon);
            } else {
                this.setIcon(this.ParentIcon);
            }
            this.setTextSelectionColor(Color.BLACK);
            this.setBackgroundSelectionColor(MyColors.MarketWatchSelectedRowColor);
            this.setBorderSelectionColor(MyColors.MarketWatchSelectedRowColor);
            this.setBorder(null);
            return this;
        }
    }
}

