/*
 * Decompiled with CFR 0.152.
 */
package MessageWindow;

import MessageWindow.BoardMeetingScripDetail;
import MessageWindow.BoardMeetingTab;
import MessageWindow.DisplayModel;
import MessageWindow.Message;
import MessageWindow.MessageDisplay;
import MessageWindow.MessageRender;
import MessageWindow.MyTab;
import MessageWindow.PMEX_MessageDisplay;
import MessageWindow.PMEX_MyTab;
import MessageWindow.SearchPanelScripDetail;
import MyDocking.Mediator;
import common.gui.util.LogCommon;
import common.gui.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.JXCollapsiblePane;

public class ShowSearchResultScripDetail
extends JDialog {
    String[] columnNames = new String[]{""};
    Vector<MessageDisplay> rows = new Vector();
    Vector<PMEX_MessageDisplay> rowsPMEX = new Vector();
    Vector columns = new Vector();
    DisplayModel model = null;
    String type = "";
    Mediator mediator = Mediator.getInstance();
    MessageRender messageRender = new MessageRender();
    public MyTab myTab = null;
    public PMEX_MyTab myTabPMEX = null;
    private boolean isAsec = true;
    private JButton dropDownDec;
    private JButton dropDownAsc;
    private BoardMeetingScripDetail boardMeetingScripDetail;
    private JButton btnAsen;
    private JButton btnClose;
    private JButton btnDecn;
    private JButton btnSearch;
    private ButtonGroup buttonGroup1;
    private JXCollapsiblePane collapsiblePane;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JLabel lblMessage;
    private JCheckBoxMenuItem menuDate;
    private JCheckBoxMenuItem menuDescription;
    private JCheckBoxMenuItem menuDetails;
    private JCheckBoxMenuItem menuSubject;
    private JPopupMenu sortMenu;
    private JTable table;
    private JToolBar toolBar;

    public ShowSearchResultScripDetail(BoardMeetingScripDetail boardMeetingScripDetail, JFrame parent, boolean modal, String type) {
        super((Frame)parent, modal);
        this.boardMeetingScripDetail = boardMeetingScripDetail;
        this.initComponents();
        this.type = type;
        if (type.equalsIgnoreCase("BOARD_MEETING")) {
            this.type = "Board_Meeting";
        }
        this.init2();
        this.initTable();
        SearchPanelScripDetail searchPanel = new SearchPanelScripDetail(this, boardMeetingScripDetail, type);
        searchPanel.setScrip();
        this.collapsiblePane.add((Component)searchPanel);
        this.collapsiblePane.setCollapsed(true);
        this.setDialogLocation(parent);
    }

    private void initTable() {
        for (int i = 0; i < this.columnNames.length; ++i) {
            this.columns.addElement(this.columnNames[i]);
        }
        this.model = new DisplayModel(this.rows, true);
        this.model.setDataVector(this.rows, this.columns);
        this.table.setModel(this.model);
        this.table.setDefaultRenderer(Object.class, this.messageRender);
        TableColumn com = this.table.getColumnModel().getColumn(0);
        com.setCellEditor(this.messageRender);
        this.table.setTableHeader(null);
        this.table.setRowHeight(100);
        this.table.setSelectionMode(0);
    }

    private void initTablePMEX() {
        for (int i = 0; i < this.columnNames.length; ++i) {
            this.columns.addElement(this.columnNames[i]);
        }
        this.model = new DisplayModel(this.rowsPMEX);
        this.model.setDataVector(this.rowsPMEX, this.columns);
        this.table.setModel(this.model);
        this.table.setDefaultRenderer(Object.class, this.messageRender);
        TableColumn com = this.table.getColumnModel().getColumn(0);
        com.setCellEditor(this.messageRender);
        this.table.setTableHeader(null);
        this.table.setRowHeight(100);
        this.table.setSelectionMode(0);
    }

    private void init2() {
        this.setTitle("Search results");
        this.setIconImage(new ImageIcon(this.getClass().getResource("/Images/search12.png")).getImage());
        if (Util.isWindow7()) {
            this.menuDescription.setIcon(null);
            this.menuSubject.setIcon(null);
            this.menuDate.setIcon(null);
            this.menuDetails.setIcon(null);
        }
        this.btnDecn.setLayout(new BorderLayout());
        this.btnDecn.setMargin(new Insets(-5, -5, -5, -5));
        this.dropDownDec = new BasicArrowButton(5);
        this.dropDownDec.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
        this.dropDownDec.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ShowSearchResultScripDetail.this.isAsec = false;
                ShowSearchResultScripDetail.this.sortMenu.show(ShowSearchResultScripDetail.this.btnDecn, evt.getX() + 2, evt.getY() + 7);
            }
        });
        this.btnDecn.add((Component)this.dropDownDec, "East");
        this.btnAsen.setLayout(new BorderLayout());
        this.btnAsen.setMargin(new Insets(-5, -5, -5, -5));
        this.dropDownAsc = new BasicArrowButton(5);
        this.dropDownAsc.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
        this.dropDownAsc.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ShowSearchResultScripDetail.this.isAsec = true;
                ShowSearchResultScripDetail.this.sortMenu.show(ShowSearchResultScripDetail.this.btnAsen, evt.getX() + 2, evt.getY() + 7);
            }
        });
        this.btnAsen.add((Component)this.dropDownAsc, "East");
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShowSearchResultScripDetail.this.dispose();
            }
        });
    }

    private void setDialogLocation(Frame f) {
        Rectangle r = f.getBounds();
        int x = r.x + (r.width - this.getSize().width) / 2;
        int y = r.y + (r.height - this.getSize().height) / 2;
        this.setLocation(x, y);
    }

    public void addAllDataWithoutBlink(String result, String find) {
        if (result != null) {
            this.rows.clear();
            this.model.fireTableDataChanged();
            this.table.addNotify();
            this.table.repaint();
            if (result.indexOf("|") >= 0) {
                String[] rowsVal = result.split("\\|", -1);
                for (int i = 0; i < rowsVal.length; ++i) {
                    if (rowsVal[i].indexOf(";") < 0) continue;
                    String[] columnVal = rowsVal[i].split("\\;", -1);
                    Message m = this.myTab.parse(columnVal);
                    m.isBlink = true;
                    MessageDisplay display = new MessageDisplay(this, m, this.table, this.type, rowsVal.length - 1, this.rows, find);
                    if (LogCommon.isTop) {
                        this.rows.add(0, display);
                    } else {
                        this.rows.add(this.rows.size(), display);
                    }
                    this.table.addNotify();
                    this.model.fireTableDataChanged();
                    this.table.repaint();
                    this.table.updateUI();
                    Util.ScrollToFirstOrLastRow((boolean)LogCommon.isTop, (JTable)this.table, (JScrollPane)this.jScrollPane1);
                }
            }
            this.lblMessage.setText(Util.format0digit((String)(this.rows.size() + "")) + " Record(s)  ");
        }
    }

    public synchronized void addBoardMeetingData(String msg, String find) {
        this.rows.clear();
        this.table.addNotify();
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        if (msg.indexOf("|") >= 0) {
            String[] rowsVal = msg.split("\\|", -1);
            BoardMeetingTab.totalMessage = rowsVal.length - 1;
            Message message = null;
            for (int i = 0; i < rowsVal.length; ++i) {
                if (rowsVal[i].indexOf(";") < 0) continue;
                String[] columnVal = rowsVal[i].split("\\;", -1);
                try {
                    message = this.boardMeetingScripDetail.parse(columnVal);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    ex.printStackTrace();
                }
                if (message == null) continue;
                message.isBlink = false;
                MessageDisplay display = new MessageDisplay(this.boardMeetingScripDetail, message, this.table, this.type, this.rows, find);
                if (LogCommon.isTop) {
                    this.rows.add(0, display);
                    continue;
                }
                this.rows.add(this.rows.size(), display);
            }
        }
        this.table.addNotify();
    }

    public void callSort(int index, boolean ascSec) {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        if (this.myTab != null) {
            this.myTab.callSort(this.rows, index, ascSec);
            this.table.tableChanged(new TableModelEvent(this.model));
            this.table.repaint();
        }
        if (this.myTabPMEX != null) {
            this.myTabPMEX.callSort(this.rowsPMEX, index, ascSec);
            this.table.tableChanged(new TableModelEvent(this.model));
            this.table.repaint();
        } else if (this.boardMeetingScripDetail != null) {
            this.boardMeetingScripDetail.callSort(this.rows, index, ascSec);
            this.table.tableChanged(new TableModelEvent(this.model));
            this.table.repaint();
        }
    }

    private void initComponents() {
        this.sortMenu = new JPopupMenu();
        this.menuDate = new JCheckBoxMenuItem();
        this.menuSubject = new JCheckBoxMenuItem();
        this.menuDescription = new JCheckBoxMenuItem();
        this.menuDetails = new JCheckBoxMenuItem();
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.jSeparator1 = new JSeparator();
        this.lblMessage = new JLabel();
        this.toolBar = new JToolBar();
        this.btnSearch = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.btnAsen = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.btnDecn = new JButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.jPanel1 = new JPanel();
        this.collapsiblePane = new JXCollapsiblePane();
        this.btnClose = new JButton();
        this.sortMenu.setName("sortMenu");
        this.buttonGroup1.add(this.menuDate);
        this.menuDate.setSelected(true);
        this.menuDate.setText("Date");
        this.menuDate.setIcon(new ImageIcon(this.getClass().getResource("/Images/date16.png")));
        this.menuDate.setName("menuDate");
        this.menuDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowSearchResultScripDetail.this.menuDateActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuDate);
        this.buttonGroup1.add(this.menuSubject);
        this.menuSubject.setText("Subject");
        this.menuSubject.setIcon(new ImageIcon(this.getClass().getResource("/Images/subject16.png")));
        this.menuSubject.setName("menuSubject");
        this.menuSubject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowSearchResultScripDetail.this.menuSubjectActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuSubject);
        this.buttonGroup1.add(this.menuDescription);
        this.menuDescription.setText("Description");
        this.menuDescription.setIcon(new ImageIcon(this.getClass().getResource("/Images/description16.png")));
        this.menuDescription.setName("menuDescription");
        this.menuDescription.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowSearchResultScripDetail.this.menuDescriptionActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuDescription);
        this.buttonGroup1.add(this.menuDetails);
        this.menuDetails.setText("Details");
        this.menuDetails.setIcon(new ImageIcon(this.getClass().getResource("/Images/detail16.png")));
        this.menuDetails.setName("menuDetails");
        this.menuDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowSearchResultScripDetail.this.menuDetailsActionPerformed(evt);
            }
        });
        this.sortMenu.add(this.menuDetails);
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(825, 446));
        this.jScrollPane1.setName("jScrollPane1");
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.setName("table");
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ShowSearchResultScripDetail.this.tableMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                ShowSearchResultScripDetail.this.tableMousePressed(evt);
            }
        });
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ShowSearchResultScripDetail.this.tableMouseMoved(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        this.jSeparator1.setName("jSeparator1");
        this.lblMessage.setText(" ");
        this.lblMessage.setName("lblMessage");
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setMaximumSize(new Dimension(116, 21));
        this.toolBar.setMinimumSize(new Dimension(116, 21));
        this.toolBar.setName("toolBar");
        this.toolBar.setPreferredSize(new Dimension(100, 18));
        this.btnSearch.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
        this.btnSearch.setText("Search");
        this.btnSearch.setFocusable(false);
        this.btnSearch.setHorizontalAlignment(2);
        this.btnSearch.setHorizontalTextPosition(4);
        this.btnSearch.setMaximumSize(new Dimension(61, 18));
        this.btnSearch.setMinimumSize(new Dimension(61, 18));
        this.btnSearch.setName("btnSearch");
        this.btnSearch.setPreferredSize(new Dimension(61, 18));
        this.btnSearch.setVerticalTextPosition(3);
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowSearchResultScripDetail.this.btnSearchActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnSearch);
        this.jSeparator2.setName("jSeparator2");
        this.toolBar.add(this.jSeparator2);
        this.btnAsen.setIcon(new ImageIcon(this.getClass().getResource("/Images/ascending12.png")));
        this.btnAsen.setToolTipText("Sort Ascending");
        this.btnAsen.setFocusable(false);
        this.btnAsen.setHorizontalTextPosition(0);
        this.btnAsen.setMaximumSize(new Dimension(38, 18));
        this.btnAsen.setMinimumSize(new Dimension(38, 18));
        this.btnAsen.setName("btnAsen");
        this.btnAsen.setPreferredSize(new Dimension(38, 18));
        this.btnAsen.setVerticalTextPosition(3);
        this.btnAsen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowSearchResultScripDetail.this.btnAsenActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnAsen);
        this.jSeparator3.setName("jSeparator3");
        this.toolBar.add(this.jSeparator3);
        this.btnDecn.setIcon(new ImageIcon(this.getClass().getResource("/Images/descending12.png")));
        this.btnDecn.setToolTipText("Sort Descending");
        this.btnDecn.setFocusable(false);
        this.btnDecn.setHorizontalTextPosition(0);
        this.btnDecn.setMaximumSize(new Dimension(38, 18));
        this.btnDecn.setMinimumSize(new Dimension(38, 18));
        this.btnDecn.setName("btnDecn");
        this.btnDecn.setPreferredSize(new Dimension(38, 18));
        this.btnDecn.setVerticalTextPosition(3);
        this.btnDecn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowSearchResultScripDetail.this.btnDecnActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnDecn);
        this.jSeparator4.setName("jSeparator4");
        this.toolBar.add(this.jSeparator4);
        this.jPanel1.setName("jPanel1");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 652, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.toolBar.add(this.jPanel1);
        this.collapsiblePane.setName("collapsiblePane");
        this.btnClose.setText("Close");
        this.btnClose.setName("btnClose");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowSearchResultScripDetail.this.btnCloseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.toolBar, -1, 815, Short.MAX_VALUE).addContainerGap()).addComponent((Component)this.collapsiblePane, -1, 825, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 825, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.lblMessage, -2, 675, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 63, Short.MAX_VALUE).addComponent(this.btnClose, -2, 72, -2).addGap(5, 5, 5)).addComponent(this.jSeparator1, -1, 825, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.toolBar, -2, 21, -2).addGap(0, 0, 0).addComponent((Component)this.collapsiblePane, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 391, Short.MAX_VALUE).addGap(3, 3, 3).addComponent(this.jSeparator1, -2, -1, -2).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.btnClose).addGap(3, 3, 3)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.lblMessage, -2, 23, -2).addGap(3, 3, 3)))));
        this.pack();
    }

    private void btnSearchActionPerformed(ActionEvent evt) {
        boolean state = this.collapsiblePane.isCollapsed();
        this.collapsiblePane.setCollapsed(!state);
    }

    private void menuDateActionPerformed(ActionEvent evt) {
        this.callSort(1, this.isAsec);
    }

    private void menuSubjectActionPerformed(ActionEvent evt) {
        this.callSort(3, this.isAsec);
    }

    private void menuDescriptionActionPerformed(ActionEvent evt) {
        this.callSort(5, this.isAsec);
    }

    private void menuDetailsActionPerformed(ActionEvent evt) {
        this.callSort(4, this.isAsec);
    }

    private void btnAsenActionPerformed(ActionEvent evt) {
        if (this.menuDate.isSelected()) {
            this.callSort(1, true);
        } else if (this.menuSubject.isSelected()) {
            this.callSort(3, true);
        } else if (this.menuDescription.isSelected()) {
            this.callSort(5, true);
        } else if (this.menuDetails.isSelected()) {
            this.callSort(4, true);
        }
    }

    private void btnDecnActionPerformed(ActionEvent evt) {
        if (this.menuDate.isSelected()) {
            this.callSort(1, false);
        } else if (this.menuSubject.isSelected()) {
            this.callSort(3, false);
        } else if (this.menuDescription.isSelected()) {
            this.callSort(5, false);
        } else if (this.menuDetails.isSelected()) {
            this.callSort(4, false);
        }
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void tableMousePressed(MouseEvent evt) {
    }

    private void tableMouseEntered(MouseEvent evt) {
    }

    private void tableMouseMoved(MouseEvent evt) {
        try {
            int rowindex = this.table.rowAtPoint(evt.getPoint());
            this.table.editCellAt(rowindex, 0);
            TableCellEditor tableCellEditor = this.table.getCellEditor(rowindex, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

