/*
 * Decompiled with CFR 0.152.
 */
package Orders;

import Beans.OrderBean;
import CustomComponent.NxGComboBox;
import CustomComponent.NxGPassword;
import CustomComponent.NxGSpinner;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Orders.KSE_FastOrder;
import Orders.OrderConfirmation;
import Orders.PriceOutOfRange;
import RendersNModels.ComboBoxToolTipRender;
import Utilities.LogsTC;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.component.NxGDialogBox;
import common.gui.util.AppConfig;
import common.gui.util.ImageUtil;
import common.gui.util.LogCommon;
import common.gui.util.MyColors;
import common.gui.util.Util;
import common.interfaces.AddContract;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import kse.util.LogsKSE;

public class KSE_FastOrderPanel
extends JPanel
implements AddContract,
ActionListener {
    Mediator mediator = Mediator.getInstance();
    private AutoCompleteSupport autoCompleteContract;
    private AutoCompleteSupport autoComOrderType;
    private AutoCompleteSupport autoCompleteMarket;
    private AutoCompleteSupport autoComOrder;
    private final SpinnerNumberModel priceModel = new SpinnerNumberModel(0.0, 0.0, 1000000.0, 0.01);
    private final SpinnerNumberModel limitModel = new SpinnerNumberModel(0.0, 0.0, 1000000.0, 0.01);
    private final SpinnerNumberModel volumeModel = new SpinnerNumberModel(0, 0, 1000000, 10);
    public static String contractPrompt = "All";
    private int ID = 0;
    private final KSE_FastOrder fastOrder;
    private final NxGPassword txtPinCode;
    private JButton btnSendAll;
    private JCheckBox isSavePIN;
    NxGDialogBox jd = null;
    private String WinType;
    private AutoCompleteSupport autoCompleteScrip;
    ColorComboBoxEditor editor;
    private JButton btnRemove;
    private JButton btnReset;
    private JButton btnSubmit;
    private JComboBox cbAccountNo;
    private JComboBox cbOrder;
    private JComboBox cbScript;
    private JComboBox cmbMarket;
    private JComboBox cmbType;
    private JToolBar jToolBar1;
    private JSpinner spDiscPrice;
    private JSpinner spLimitPrice;
    private JSpinner spPrice;
    private JSpinner spVolume;

    public KSE_FastOrderPanel(KSE_FastOrder fastOrder, NxGPassword txtPinCode, int id, JButton btnSendAll, JCheckBox isSavePIN) {
        this.initComponents();
        this.fastOrder = fastOrder;
        this.txtPinCode = txtPinCode;
        this.btnSendAll = btnSendAll;
        this.isSavePIN = isSavePIN;
        this.ID = id;
        this.setThis();
        this.spLimitPrice.setEnabled(false);
        this.addContract();
        this.setOrderTypes();
        this.setOrder();
        this.setAccounts();
        this.setModels();
        this.setMarkets(false);
        this.cmbMarket.setRenderer(new ComboBoxToolTipRender(LogsTC.tooltipsMarket, ""));
        this.spVolume.setModel(this.volumeModel);
        this.setListener();
        this.editor = new ColorComboBoxEditor();
        this.cbOrder.setEditor(this.editor);
    }

    private void setThis() {
        this.cbScript.addActionListener(this);
        this.cbOrder.addActionListener(this);
        this.cmbType.addActionListener(this);
        this.cbAccountNo.addActionListener(this);
    }

    private void removeThis() {
        this.cbScript.removeActionListener(this);
        this.cbOrder.removeActionListener(this);
        this.cmbType.removeActionListener(this);
        this.cbAccountNo.removeActionListener(this);
    }

    private void setListener() {
        ((JSpinner.DefaultEditor)this.spPrice.getEditor()).getTextField().setFocusTraversalKeys(0, Collections.EMPTY_SET);
        ((JSpinner.DefaultEditor)this.spVolume.getEditor()).getTextField().setFocusTraversalKeys(0, Collections.EMPTY_SET);
        ((JSpinner.DefaultEditor)this.spLimitPrice.getEditor()).getTextField().setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.cmbMarket.getEditor().getEditorComponent().setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.cbScript.getEditor().getEditorComponent().setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.cbOrder.getEditor().getEditorComponent().setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.cmbType.getEditor().getEditorComponent().setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.cbAccountNo.getEditor().getEditorComponent().setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.txtPinCode.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.cmbMarket.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                super.keyPressed(evt);
                if (evt.getKeyCode() == 10 || evt.getKeyCode() == 9) {
                    String val = KSE_FastOrderPanel.this.cmbMarket.getSelectedItem().toString().trim();
                    if (val.trim().length() <= 0 || val.equalsIgnoreCase("0") || val.equalsIgnoreCase("0.0")) {
                        ((NxGComboBox)KSE_FastOrderPanel.this.cmbMarket).setError(true);
                    } else {
                        ((NxGComboBox)KSE_FastOrderPanel.this.cmbMarket).setError(false);
                        if (KSE_FastOrderPanel.this.cbScript.isEnabled()) {
                            KSE_FastOrderPanel.this.cbScript.getEditor().getEditorComponent().requestFocus();
                        } else {
                            KSE_FastOrderPanel.this.cbOrder.requestFocus();
                        }
                    }
                }
            }
        });
        this.cbScript.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                super.keyPressed(evt);
                if (evt.getKeyCode() == 10 || evt.getKeyCode() == 9) {
                    String val = KSE_FastOrderPanel.this.cbScript.getSelectedItem().toString().trim();
                    if (val.trim().length() <= 0 || val.equalsIgnoreCase("0") || val.equalsIgnoreCase("0.0")) {
                        ((NxGComboBox)KSE_FastOrderPanel.this.cbScript).setError(true);
                    } else {
                        ((NxGComboBox)KSE_FastOrderPanel.this.cbScript).setError(false);
                        if (KSE_FastOrderPanel.this.cbOrder.isEnabled()) {
                            KSE_FastOrderPanel.this.cbOrder.getEditor().getEditorComponent().requestFocus();
                        } else {
                            KSE_FastOrderPanel.this.cmbType.getEditor().getEditorComponent().requestFocus();
                        }
                    }
                }
            }
        });
        this.cbOrder.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                super.keyPressed(evt);
                if (evt.getKeyCode() == 10 || evt.getKeyCode() == 9) {
                    String val = KSE_FastOrderPanel.this.cbOrder.getSelectedItem().toString().trim();
                    if (val.trim().length() <= 0 || val.equalsIgnoreCase("0") || val.equalsIgnoreCase("0.0")) {
                        ((NxGComboBox)KSE_FastOrderPanel.this.cbOrder).setError(true);
                    } else {
                        ((NxGComboBox)KSE_FastOrderPanel.this.cbOrder).setError(false);
                        if (KSE_FastOrderPanel.this.cmbType.isEnabled()) {
                            KSE_FastOrderPanel.this.cmbType.getEditor().getEditorComponent().requestFocus();
                        } else {
                            KSE_FastOrderPanel.this.cbAccountNo.getEditor().getEditorComponent().requestFocus();
                        }
                    }
                }
            }
        });
        this.cmbType.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                super.keyPressed(evt);
                if (evt.getKeyCode() == 10 || evt.getKeyCode() == 9) {
                    String val = KSE_FastOrderPanel.this.cmbType.getSelectedItem().toString().trim();
                    if (val.trim().length() <= 0 || val.equalsIgnoreCase("0") || val.equalsIgnoreCase("0.0")) {
                        ((NxGComboBox)KSE_FastOrderPanel.this.cmbType).setError(true);
                    } else {
                        ((NxGComboBox)KSE_FastOrderPanel.this.cmbType).setError(false);
                        if (KSE_FastOrderPanel.this.cbAccountNo.isEnabled()) {
                            KSE_FastOrderPanel.this.cbAccountNo.getEditor().getEditorComponent().requestFocus();
                        } else {
                            ((JSpinner.DefaultEditor)KSE_FastOrderPanel.this.spVolume.getEditor()).getTextField().requestFocus();
                        }
                    }
                }
            }
        });
        this.cbAccountNo.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                super.keyPressed(evt);
                if (evt.getKeyCode() == 10 || evt.getKeyCode() == 9) {
                    String val = KSE_FastOrderPanel.this.cbAccountNo.getSelectedItem().toString().trim();
                    if (val.trim().length() <= 0 || val.equalsIgnoreCase("0") || val.equalsIgnoreCase("0.0")) {
                        ((NxGComboBox)KSE_FastOrderPanel.this.cbAccountNo).setError(true);
                    } else {
                        ((NxGComboBox)KSE_FastOrderPanel.this.cbAccountNo).setError(false);
                        if (KSE_FastOrderPanel.this.spVolume.isEnabled()) {
                            ((JSpinner.DefaultEditor)KSE_FastOrderPanel.this.spVolume.getEditor()).getTextField().requestFocus();
                        } else {
                            KSE_FastOrderPanel.this.btnSubmit.requestFocus();
                        }
                    }
                }
            }
        });
        ((JSpinner.DefaultEditor)this.spVolume.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                super.keyPressed(evt);
                if (evt.getKeyCode() == 10 || evt.getKeyCode() == 9) {
                    String val = ((JSpinner.DefaultEditor)KSE_FastOrderPanel.this.spVolume.getEditor()).getTextField().getText();
                    if (val.trim().length() <= 0 || val.equalsIgnoreCase("0") || val.equalsIgnoreCase("0.0")) {
                        ((NxGSpinner)KSE_FastOrderPanel.this.spVolume).setError(true);
                        ((JSpinner.DefaultEditor)KSE_FastOrderPanel.this.spVolume.getEditor()).getTextField().requestFocus();
                    } else {
                        ((NxGSpinner)KSE_FastOrderPanel.this.spVolume).setError(false);
                        if (KSE_FastOrderPanel.this.spPrice.isEnabled()) {
                            ((JSpinner.DefaultEditor)KSE_FastOrderPanel.this.spPrice.getEditor()).getTextField().requestFocus();
                        } else {
                            KSE_FastOrderPanel.this.btnSubmit.requestFocus();
                        }
                    }
                }
            }
        });
        ((JSpinner.DefaultEditor)this.spPrice.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                super.keyPressed(evt);
                if (evt.getKeyCode() == 10 || evt.getKeyCode() == 9) {
                    String val = ((JSpinner.DefaultEditor)KSE_FastOrderPanel.this.spPrice.getEditor()).getTextField().getText();
                    if (val.trim().length() <= 0 || val.equalsIgnoreCase("0") || val.equalsIgnoreCase("0.0")) {
                        ((NxGSpinner)KSE_FastOrderPanel.this.spPrice).setError(true);
                        ((JSpinner.DefaultEditor)KSE_FastOrderPanel.this.spPrice.getEditor()).getTextField().requestFocus();
                        KSE_FastOrderPanel.this.setPriceFromFeedAndSubcribe(false);
                    } else {
                        ((NxGSpinner)KSE_FastOrderPanel.this.spPrice).setError(false);
                        if (KSE_FastOrderPanel.this.spLimitPrice.isEnabled()) {
                            ((JSpinner.DefaultEditor)KSE_FastOrderPanel.this.spLimitPrice.getEditor()).getTextField().requestFocus();
                        } else {
                            KSE_FastOrderPanel.this.btnSubmit.requestFocus();
                        }
                    }
                }
            }
        });
        ((JSpinner.DefaultEditor)this.spLimitPrice.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                super.keyPressed(evt);
                if (evt.getKeyCode() == 10 || evt.getKeyCode() == 9) {
                    String val = ((JSpinner.DefaultEditor)KSE_FastOrderPanel.this.spLimitPrice.getEditor()).getTextField().getText();
                    if (val.trim().length() <= 0 || val.equalsIgnoreCase("0") || val.equalsIgnoreCase("0.0")) {
                        ((NxGSpinner)KSE_FastOrderPanel.this.spLimitPrice).setError(true);
                        ((JSpinner.DefaultEditor)KSE_FastOrderPanel.this.spLimitPrice.getEditor()).getTextField().requestFocus();
                    } else {
                        ((NxGSpinner)KSE_FastOrderPanel.this.spLimitPrice).setError(false);
                        KSE_FastOrderPanel.this.btnSubmit.requestFocus();
                    }
                }
            }
        });
        ((JSpinner.DefaultEditor)this.spVolume.getEditor()).getTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                KSE_FastOrderPanel.this.spinnerSetTextSelected(e);
            }
        });
        ((JSpinner.DefaultEditor)this.spPrice.getEditor()).getTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                KSE_FastOrderPanel.this.spinnerSetTextSelected(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                String val = ((JSpinner.DefaultEditor)KSE_FastOrderPanel.this.spPrice.getEditor()).getTextField().getText();
                if (val.trim().length() <= 0 || val.equalsIgnoreCase("0") || val.equalsIgnoreCase("0.0")) {
                    KSE_FastOrderPanel.this.setPriceFromFeedAndSubcribe(false);
                }
            }
        });
        ((JSpinner.DefaultEditor)this.spLimitPrice.getEditor()).getTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                KSE_FastOrderPanel.this.spinnerSetTextSelected(e);
            }
        });
        this.txtPinCode.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                if (e.getKeyCode() == 10 || e.getKeyCode() == 9) {
                    String _val = KSE_FastOrderPanel.this.txtPinCode.getText().trim();
                    if (_val.length() <= 0 || _val.equalsIgnoreCase("0") || _val.equalsIgnoreCase("0.0")) {
                        KSE_FastOrderPanel.this.txtPinCode.setError(true);
                    } else {
                        KSE_FastOrderPanel.this.txtPinCode.setError(false);
                        if (KSE_FastOrderPanel.this.isSavePIN.isSelected()) {
                            KSE_FastOrderPanel.this.btnSendAll.requestFocus();
                        } else {
                            KSE_FastOrderPanel.this.isSavePIN.requestFocus();
                        }
                    }
                }
            }
        });
        this.isSavePIN.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                if (e.getKeyCode() == 10 || e.getKeyCode() == 10) {
                    boolean flag = KSE_FastOrderPanel.this.isSavePIN.isSelected();
                    KSE_FastOrderPanel.this.btnSendAll.requestFocus();
                }
            }
        });
    }

    private void spinnerSetTextSelected(FocusEvent e) {
        JFormattedTextField textField = (JFormattedTextField)e.getComponent();
        textField.setText(textField.getText());
        textField.selectAll();
    }

    public void resetValues() {
        this.resetError();
        this.removeThis();
        this.setOrderOptions(LogCommon.OrderOption);
        ((NxGComboBox)this.cmbMarket).setSelectedItem("REG");
        ((NxGComboBox)this.cbScript).setSelectedItem("");
        ((NxGComboBox)this.cbOrder).setSelectedItem("Buy");
        this.editor = new ColorComboBoxEditor();
        this.cbOrder.setEditor(this.editor);
        ((NxGComboBox)this.cmbType).setSelectedItem("Limit");
        ((NxGComboBox)this.cbAccountNo).setSelectedItem("");
        ((NxGSpinner)this.spPrice).setEnabled(true);
        ((NxGSpinner)this.spPrice).setError(false);
        ((NxGSpinner)this.spLimitPrice).setValue(0);
        ((NxGSpinner)this.spLimitPrice).setEnabled(false);
        ((NxGSpinner)this.spVolume).setError(false);
        ((NxGSpinner)this.spVolume).setValue(0);
        ((NxGSpinner)this.spDiscPrice).setValue(0);
        this.setThis();
    }

    private void resetError() {
        ((NxGComboBox)this.cmbMarket).setError(false);
        ((NxGComboBox)this.cbScript).setError(false);
        ((NxGComboBox)this.cbOrder).setError(false);
        ((NxGComboBox)this.cmbType).setError(false);
        ((NxGComboBox)this.cbAccountNo).setError(false);
        ((NxGSpinner)this.spPrice).setError(false);
        ((NxGSpinner)this.spLimitPrice).setError(false);
        ((NxGSpinner)this.spVolume).setError(false);
        this.txtPinCode.setError(false);
    }

    private void setOrder() {
        if (this.autoComOrder != null && this.autoComOrder.isInstalled()) {
            this.autoComOrder.uninstall();
        }
        this.autoComOrder = AutoCompleteSupport.install((JComboBox)this.cbOrder, (EventList)GlazedLists.eventListOf((Object[])new String[]{"Buy", "Sell"}));
        this.autoComOrder.setStrict(true);
        this.cbOrder.setSelectedItem("Buy");
    }

    private void setOrderTypes() {
        if (this.autoComOrderType != null && this.autoComOrderType.isInstalled()) {
            this.autoComOrderType.uninstall();
        }
        this.autoComOrderType = AutoCompleteSupport.install((JComboBox)this.cmbType, (EventList)GlazedLists.eventListOf((Object[])new String[]{"Limit", "SLO", "MKT", "FOK", "MIT"}));
        this.cmbType.setSelectedItem("Limit");
    }

    private void setAccounts() {
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(LogsTC.accountAll.keySet().toArray()));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])LogsTC.accountAll.keySet().toArray()));
        support.setStrict(false);
        if (LogCommon.preferredAccount.trim().length() > 0) {
            this.cbAccountNo.setSelectedItem(LogCommon.preferredAccount);
        } else {
            this.cbAccountNo.setSelectedItem("");
        }
    }

    private void setModels() {
        this.spPrice.setModel(this.priceModel);
        this.spLimitPrice.setModel(this.limitModel);
        this.spVolume.setModel(this.volumeModel);
    }

    private void setPriceFromFeedAndSubcribe(boolean isSendFeedRequest) {
    }

    private void setPriceOfFeed(double price) {
        if ((this.spPrice.getValue().toString().trim().length() <= 0 || this.spPrice.getValue().toString().equalsIgnoreCase("0") || this.spPrice.getValue().toString().equalsIgnoreCase("0.0")) && this.spPrice.isEnabled()) {
            this.spPrice.setValue(price);
        }
    }

    private void orderTypeChange() {
        String type_ = this.cmbType.getSelectedItem().toString();
        if (type_.equalsIgnoreCase("SLO") || type_.equalsIgnoreCase("MIT")) {
            this.spLimitPrice.setEnabled(true);
            this.spPrice.setEnabled(true);
            return;
        }
        if (!type_.equalsIgnoreCase("MKT")) {
            this.spPrice.setEnabled(true);
            this.spLimitPrice.setEnabled(false);
            this.spLimitPrice.setValue(0);
            return;
        }
        this.spPrice.setEnabled(false);
        this.spPrice.setValue(0);
        this.spLimitPrice.setEnabled(false);
        this.spLimitPrice.setValue(0);
    }

    private void sendOrder() {
        if (this.isBasicValide()) {
            OrderBean bean = this.getBean();
            boolean continueorder = true;
            if (bean.getOrderType().equalsIgnoreCase("MKT")) {
                continueorder = true;
            } else if (LogsKSE.CheckPriceLimit && bean.getUpperCap() > 0.0 && bean.getLowerLock() > 0.0) {
                if (bean.getOrderType().equalsIgnoreCase("SLO") || bean.getOrderType().equalsIgnoreCase("MIT")) {
                    if (bean.getLimit() > bean.getUpperCap() || bean.getLimit() < bean.getLowerLock()) {
                        PriceOutOfRange pricerange = new PriceOutOfRange(TradeCast.getInstance().frame, true, bean);
                        continueorder = false;
                    }
                } else if (bean.getPrice() > bean.getUpperCap() || bean.getPrice() < bean.getLowerLock()) {
                    PriceOutOfRange pricerange = new PriceOutOfRange(TradeCast.getInstance().frame, true, bean);
                    continueorder = false;
                }
            }
            if (continueorder) {
                if (LogCommon.isConfirmation) {
                    this.ExecuteOrderWithPrompt();
                } else {
                    this.ExecuteOrderWithoutPrompt();
                }
            } else if (bean.getOrderType().equalsIgnoreCase("SLO") || bean.getOrderType().equalsIgnoreCase("MIT")) {
                ((JSpinner.DefaultEditor)this.spLimitPrice.getEditor()).getTextField().requestFocus();
            } else {
                ((JSpinner.DefaultEditor)this.spPrice.getEditor()).getTextField().requestFocus();
            }
        }
    }

    private String getOrderType() {
        String mkt = this.cmbMarket.getSelectedItem().toString();
        if (!mkt.equalsIgnoreCase("LB")) {
            mkt = this.cmbType.getSelectedItem().toString();
        }
        return mkt;
    }

    public void setOrderOptions(String result) {
        try {
            Number step;
            Number max;
            Number min;
            Number value;
            Number step2;
            Number max2;
            Number min2;
            Number value2;
            String[] val;
            if (result.indexOf(";") > 0) {
                LogCommon.OrderOption = result;
            }
            if (LogCommon.OrderOption.indexOf(";") > 0) {
                val = LogCommon.OrderOption.split("\\;", -1);
                value2 = new Integer(Integer.parseInt(val[0]));
                min2 = new Integer(1);
                max2 = new Integer(999999);
                step2 = new Integer(Integer.parseInt(val[1]));
                this.volumeModel.setMinimum((Comparable<?>)((Object)min2));
                this.volumeModel.setMaximum((Comparable<?>)((Object)max2));
                this.volumeModel.setStepSize(step2);
                this.volumeModel.setValue(value2);
            } else {
                value = new Integer(100);
                min = new Integer(1);
                max = new Integer(999999);
                step = new Integer(1);
                this.volumeModel.setMinimum((Comparable<?>)((Object)min));
                this.volumeModel.setMaximum((Comparable<?>)((Object)max));
                this.volumeModel.setStepSize(step);
                this.volumeModel.setValue(value);
            }
            if (LogCommon.OrderOption.indexOf(";") > 0) {
                val = LogCommon.OrderOption.split("\\;", -1);
                value2 = new Double(0.0);
                min2 = new Double(0.0);
                max2 = new Double(999999.99);
                step2 = new Double(Double.parseDouble(val[2]));
                this.priceModel.setMinimum((Comparable<?>)((Object)min2));
                this.priceModel.setMaximum((Comparable<?>)((Object)max2));
                this.priceModel.setStepSize(step2);
                this.priceModel.setValue(value2);
                this.limitModel.setMinimum((Comparable<?>)((Object)min2));
                this.limitModel.setMaximum((Comparable<?>)((Object)max2));
                this.limitModel.setStepSize(step2);
                this.limitModel.setValue(value2);
            } else {
                value = new Double(0.0);
                min = new Double(0.0);
                max = new Double(999999.99);
                step = new Double(0.01);
                this.priceModel.setMinimum((Comparable<?>)((Object)min));
                this.priceModel.setMaximum((Comparable<?>)((Object)max));
                this.priceModel.setStepSize(step);
                this.priceModel.setValue(value);
                this.limitModel.setMinimum((Comparable<?>)((Object)min));
                this.limitModel.setMaximum((Comparable<?>)((Object)max));
                this.limitModel.setStepSize(step);
            }
        }
        catch (Exception ex) {
            Mediator.getInstance().PrintLog(ex, "");
        }
    }

    public OrderBean getBean() {
        OrderBean bean = new OrderBean();
        bean.setMarket(this.cmbMarket.getSelectedItem().toString());
        bean.setScrip(this.cbScript.getSelectedItem().toString().trim());
        bean.setVolume(this.spVolume.getValue().toString());
        bean.setDsicVolume(this.spDiscPrice.getValue().toString());
        bean.setPrice(this.spPrice.getValue().toString());
        bean.setAccount(this.cbAccountNo.getSelectedItem().toString());
        bean.setPIN(this.txtPinCode.getText());
        bean.setOrderType(this.getOrderType());
        if (this.WinType.equalsIgnoreCase("Leverage Buy") || this.WinType.equalsIgnoreCase("LeverageBuy")) {
            bean.setOrderTransactionType("BUY");
        } else {
            bean.setOrderTransactionType(this.WinType);
        }
        try {
            String cps = this.mediator.logsCommon.getCaps(this.cbScript.getSelectedItem().toString(), this.getMarket());
            if (cps.length() > 0) {
                bean.setUpperCap(Double.parseDouble(cps.split(":")[0]));
                bean.setLowerLock(Double.parseDouble(cps.split(":")[1]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.cmbType.getSelectedItem().toString().equalsIgnoreCase("SLO") || this.cmbType.getSelectedItem().toString().equalsIgnoreCase("MIT")) {
            bean.setLimit(Double.parseDouble(this.spLimitPrice.getValue().toString().trim()));
        }
        if (this.cmbType.getSelectedItem().toString().equalsIgnoreCase("Limit")) {
            bean.setOrderType("NOR");
        } else if (this.cmbType.getSelectedItem().toString().equalsIgnoreCase("SLO")) {
            bean.setOrderType("SLO");
        } else if (this.cmbType.getSelectedItem().toString().equalsIgnoreCase("MKT")) {
            bean.setOrderType("MKT");
        } else if (this.cmbType.getSelectedItem().toString().equalsIgnoreCase("MIT")) {
            bean.setOrderType("MIT");
        } else if (this.cmbType.getSelectedItem().toString().equalsIgnoreCase("FOK") && (this.WinType.equalsIgnoreCase("SELL") || this.WinType.equalsIgnoreCase("SEL"))) {
            bean.setOrderType("HIT");
        } else if (this.cmbType.getSelectedItem().toString().equalsIgnoreCase("FOK") && this.WinType.equalsIgnoreCase("BUY")) {
            bean.setOrderType("TAK");
        }
        return bean;
    }

    private String getContract() {
        return this.cbScript.getSelectedItem().toString();
    }

    private String getMarket() {
        return this.cmbMarket.getSelectedItem() + "";
    }

    private double getLimitPrice() {
        return Double.parseDouble(this.spPrice.getValue() + "");
    }

    private double getTriggerPrice() {
        return Double.parseDouble(this.spLimitPrice.getValue() + "");
    }

    private String getType() {
        return this.cbOrder.getSelectedItem().toString().trim();
    }

    public String getContractWithMarket() {
        if (!this.getContract().equalsIgnoreCase(contractPrompt)) {
            return this.getContract() + ":" + this.getMarket();
        }
        return "";
    }

    private void initComponents() {
        this.cbScript = new NxGComboBox();
        this.cbOrder = new NxGComboBox();
        this.cmbType = new NxGComboBox();
        this.cbAccountNo = new NxGComboBox();
        this.spVolume = new NxGSpinner();
        this.spPrice = new NxGSpinner();
        this.spLimitPrice = new NxGSpinner();
        this.jToolBar1 = new JToolBar();
        this.btnSubmit = new JButton();
        this.btnReset = new JButton();
        this.btnRemove = new JButton();
        this.spDiscPrice = new NxGSpinner();
        this.cmbMarket = new NxGComboBox();
        this.cbScript.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbScript.setOpaque(false);
        this.cbScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSE_FastOrderPanel.this.cbScriptActionPerformed(evt);
            }
        });
        this.cbOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSE_FastOrderPanel.this.cbOrderActionPerformed(evt);
            }
        });
        this.cmbType.setModel(new DefaultComboBoxModel<String>(new String[]{"Stop Loss"}));
        this.cmbType.setBorder(null);
        this.cmbType.setOpaque(false);
        this.cmbType.setPreferredSize(new Dimension(55, 20));
        this.cmbType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSE_FastOrderPanel.this.cmbTypeActionPerformed(evt);
            }
        });
        this.cbAccountNo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbAccountNo.setOpaque(false);
        this.cbAccountNo.setPreferredSize(new Dimension(55, 20));
        this.cbAccountNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSE_FastOrderPanel.this.cbAccountNoActionPerformed(evt);
            }
        });
        this.spVolume.setOpaque(false);
        this.spPrice.setOpaque(false);
        this.spLimitPrice.setOpaque(false);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.btnSubmit.setIcon(new ImageIcon(this.getClass().getResource("/Images/tick.png")));
        this.btnSubmit.setToolTipText("Send Order");
        this.btnSubmit.setHorizontalTextPosition(0);
        this.btnSubmit.setName("KSE_FastOrderPanel -> btnSubmit");
        this.btnSubmit.setOpaque(false);
        this.btnSubmit.setPreferredSize(new Dimension(43, 23));
        this.btnSubmit.setVerticalTextPosition(3);
        this.btnSubmit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSE_FastOrderPanel.this.btnSubmitActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnSubmit);
        this.btnReset.setIcon(new ImageIcon(this.getClass().getResource("/Images/refresh.png")));
        this.btnReset.setToolTipText("Reset Values");
        this.btnReset.setHorizontalTextPosition(0);
        this.btnReset.setName("KSE_FastOrderPanel -> btnReset");
        this.btnReset.setOpaque(false);
        this.btnReset.setVerticalTextPosition(3);
        this.btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSE_FastOrderPanel.this.btnResetActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnReset);
        this.btnRemove.setIcon(new ImageIcon(this.getClass().getResource("/Images/close12x12.png")));
        this.btnRemove.setToolTipText("Remove");
        this.btnRemove.setHorizontalTextPosition(0);
        this.btnRemove.setName("KSE_FastOrderPanel -> btnRemove");
        this.btnRemove.setOpaque(false);
        this.btnRemove.setVerticalTextPosition(3);
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSE_FastOrderPanel.this.btnRemoveActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnRemove);
        this.spDiscPrice.setOpaque(false);
        this.cmbMarket.setOpaque(false);
        this.cmbMarket.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSE_FastOrderPanel.this.cmbMarketActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cmbMarket, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbScript, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbOrder, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmbType, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAccountNo, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spVolume, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spPrice, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spLimitPrice, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spDiscPrice, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToolBar1, -2, 66, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spVolume, -2, 20, -2).addComponent(this.spPrice, -2, 20, -2).addComponent(this.spLimitPrice, -2, 20, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbScript, -2, -1, -2).addComponent(this.cmbMarket, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbOrder, -2, -1, -2).addComponent(this.cmbType, -2, 20, -2).addComponent(this.cbAccountNo, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, GroupLayout.Alignment.TRAILING, -2, 20, -2).addComponent(this.spDiscPrice, GroupLayout.Alignment.TRAILING, -2, 20, -2)));
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        this.fastOrder.removeOrdePanel(this.getID());
    }

    private void btnSubmitActionPerformed(ActionEvent evt) {
        this.sendOrder();
    }

    private void cmbTypeActionPerformed(ActionEvent evt) {
    }

    private void btnResetActionPerformed(ActionEvent evt) {
        this.resetValues();
    }

    private void cbScriptActionPerformed(ActionEvent evt) {
    }

    private void cbOrderActionPerformed(ActionEvent evt) {
        this.WinType = this.cbOrder.getSelectedItem().toString().trim();
    }

    private void cbAccountNoActionPerformed(ActionEvent evt) {
    }

    private void cmbMarketActionPerformed(ActionEvent evt) {
    }

    public void addContract() {
        if (this.autoCompleteContract != null && this.autoCompleteContract.isInstalled()) {
            this.autoCompleteContract.uninstall();
        }
        Vector allScrip = new Vector(LogCommon.SymbolAndSymbolName.keySet());
        Collections.sort(allScrip);
        this.cbScript.setModel(new DefaultComboBoxModel(allScrip));
        this.autoCompleteScrip = AutoCompleteSupport.install((JComboBox)this.cbScript, (EventList)GlazedLists.eventListOf((Object[])allScrip.toArray()));
    }

    public int getID() {
        return this.ID;
    }

    public boolean isBasicValide() {
        this.resetError();
        String cont = ((NxGComboBox)this.cbScript).getSelectedItem().toString();
        String order = ((NxGComboBox)this.cbOrder).getSelectedItem().toString();
        String orderType = ((NxGComboBox)this.cmbType).getSelectedItem().toString();
        String accountNo = ((NxGComboBox)this.cbAccountNo).getSelectedItem().toString();
        String cbMarket = ((NxGComboBox)this.cmbMarket).getSelectedItem().toString();
        if (cont.equalsIgnoreCase("") || cont.equalsIgnoreCase(contractPrompt)) {
            ((NxGComboBox)this.cbScript).setError(true);
            ((NxGComboBox)this.cbScript).requestFocus();
            return false;
        }
        if (order.equalsIgnoreCase("")) {
            ((NxGComboBox)this.cbOrder).setError(true);
            ((NxGComboBox)this.cbOrder).requestFocus();
            return false;
        }
        if (orderType.equalsIgnoreCase("")) {
            ((NxGComboBox)this.cmbType).setError(true);
            ((NxGComboBox)this.cmbType).requestFocus();
            return false;
        }
        if (accountNo.equalsIgnoreCase("")) {
            ((NxGComboBox)this.cbAccountNo).setError(true);
            ((NxGComboBox)this.cbAccountNo).requestFocus();
            return false;
        }
        if (!LogsTC.accountAll.containsKey(this.cbAccountNo.getSelectedItem().toString())) {
            ((NxGComboBox)this.cbAccountNo).setError(true);
            ((NxGComboBox)this.cbAccountNo).requestFocus();
            return false;
        }
        if (this.spVolume.getValue().toString().trim().length() <= 0 || this.spVolume.getValue().toString().equalsIgnoreCase("0") || this.spVolume.getValue().toString().equalsIgnoreCase("0.0")) {
            ((NxGSpinner)this.spVolume).setError(true);
            ((JSpinner.DefaultEditor)this.spVolume.getEditor()).getTextField().requestFocus();
            return false;
        }
        if ((this.spPrice.getValue().toString().trim().length() <= 0 || this.spPrice.getValue().toString().equalsIgnoreCase("0") || this.spPrice.getValue().toString().equalsIgnoreCase("0.0")) && this.spPrice.isEnabled()) {
            ((NxGSpinner)this.spPrice).setError(true);
            ((JSpinner.DefaultEditor)this.spPrice.getEditor()).getTextField().requestFocus();
            return false;
        }
        if ((this.spLimitPrice.getValue().toString().trim().length() <= 0 || this.spLimitPrice.getValue().toString().equalsIgnoreCase("0") || this.spLimitPrice.getValue().toString().equalsIgnoreCase("0.0")) && this.spLimitPrice.isEnabled()) {
            ((NxGSpinner)this.spLimitPrice).setError(true);
            ((JSpinner.DefaultEditor)this.spLimitPrice.getEditor()).getTextField().requestFocus();
            return false;
        }
        if (cbMarket.equalsIgnoreCase("") || cbMarket.equalsIgnoreCase(contractPrompt)) {
            ((NxGSpinner)this.spLimitPrice).setError(true);
            ((NxGSpinner)this.spLimitPrice).requestFocus();
            return false;
        }
        if (this.txtPinCode.getText().trim().length() <= 0) {
            this.txtPinCode.setError(true);
            this.txtPinCode.requestFocus();
            return false;
        }
        if (this.cmbMarket.getSelectedItem().toString().equalsIgnoreCase("FUT")) {
            String sym = this.cbScript.getSelectedItem().toString().trim();
            if (sym.indexOf("-") >= 0) {
                boolean isFut = false;
                String[] ss = sym.split("\\-", -1);
                String[] MarketMonth = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
                for (int i = 0; i < MarketMonth.length; ++i) {
                    if (ss[1].toUpperCase().indexOf(MarketMonth[i]) < 0) continue;
                    isFut = true;
                    break;
                }
                if (!isFut) {
                    ((NxGComboBox)this.cbScript).setError(true);
                    this.cbScript.requestFocus();
                    return false;
                }
                return true;
            }
            ((NxGComboBox)this.cbScript).setError(true);
            return false;
        }
        return true;
    }

    private String getType2() {
        if (this.getType().equalsIgnoreCase("Buy")) {
            return "BUY";
        }
        return "SEL";
    }

    public void MessageSent(boolean b) {
        if (b) {
            // empty if block
        }
    }

    public void setMarkets(boolean isLeverageBuy) {
        if (isLeverageBuy) {
            this.cmbMarket.setModel(new DefaultComboBoxModel<String>(new String[]{"LB"}));
            this.cmbType.setModel(new DefaultComboBoxModel<String>(new String[]{"Limit"}));
            this.cmbMarket.setEnabled(false);
            this.cmbType.setEnabled(false);
        } else {
            Vector<String> allMarket = new Vector<String>();
            for (int i = 0; i < LogCommon.markets.length; ++i) {
                allMarket.addElement(LogCommon.markets[i]);
            }
            Collections.sort(allMarket);
            this.cmbMarket.setModel(new DefaultComboBoxModel(allMarket));
            this.autoCompleteMarket = AutoCompleteSupport.install((JComboBox)this.cmbMarket, (EventList)GlazedLists.eventListOf((Object[])allMarket.toArray()));
            this.cmbMarket.setSelectedItem("REG");
            this.autoCompleteMarket.setStrict(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.cbScript) {
            if (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
                this.spPrice.setValue(0);
                if (this.cbScript.getSelectedItem().toString().trim().length() <= 0 || this.cbScript.getSelectedItem().toString().equalsIgnoreCase(contractPrompt)) {
                    ((NxGComboBox)this.cbScript).setError(true);
                    this.cbScript.requestFocus();
                } else {
                    ((NxGComboBox)this.cbScript).setError(false);
                    this.cbOrder.requestFocus();
                    this.setPriceFromFeedAndSubcribe(true);
                }
            }
        } else if (source == this.cbOrder) {
            if (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
                if (this.cbOrder.getSelectedItem().toString().trim().length() <= 0) {
                    ((NxGComboBox)this.cbOrder).setError(true);
                    this.cbOrder.requestFocus();
                } else {
                    ((NxGComboBox)this.cbOrder).setError(false);
                    this.cmbType.requestFocus();
                }
            }
        } else if (source == this.cmbType) {
            if (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
                this.orderTypeChange();
            }
        } else if (source == this.cbAccountNo && (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited"))) {
            if (this.cbAccountNo.getSelectedItem().toString().trim().length() <= 0) {
                ((NxGComboBox)this.cbAccountNo).setError(true);
                this.cbAccountNo.requestFocus();
            } else {
                ((NxGComboBox)this.cbAccountNo).setError(false);
            }
        }
    }

    private void ExecuteOrderWithPrompt() {
        OrderBean bean = this.getBean();
        OrderConfirmation OC = new OrderConfirmation(this.WinType, bean, false);
        this.jd = new NxGDialogBox((Frame)TradeCast.getInstance().frame, true);
        try {
            if (AppConfig.houseIcon == null) {
                AppConfig.houseIcon = ImageUtil.downloadImage((String)(AppConfig.TradeCastURL + "/HouseImages/small.png"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.jd.setIconImage(AppConfig.houseIcon);
        this.jd.getContentPane().add(OC);
        if (this.WinType.equalsIgnoreCase("Sell")) {
            this.jd.setTitle("Sell Order Confirmation");
        } else if (this.WinType.equalsIgnoreCase("Buy")) {
            this.jd.setTitle("Buy Order Confirmation");
        } else {
            this.jd.setTitle(this.WinType + " Order Confirmation");
        }
        if (Util.isWindow7()) {
            this.jd.setSize(320, 225);
        } else {
            this.jd.setSize(320, 220);
        }
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension d = kit.getScreenSize();
        this.jd.setLocation(new Point((d.width - 320) / 2, (d.height - 190) / 2));
        this.jd.setResizable(false);
        this.jd.setVisible(true);
    }

    private void ExecuteOrderWithoutPrompt() {
        OrderBean bean = this.getBean();
        String TransType = "";
        if (this.WinType.equalsIgnoreCase("BUY")) {
            TransType = "BUY";
        } else if (this.WinType.equalsIgnoreCase("SELL") || this.WinType.equalsIgnoreCase("SEL")) {
            TransType = "SEL";
        } else if (this.WinType.equalsIgnoreCase("SHORT SELL") || this.WinType.equalsIgnoreCase("SHORT SEL")) {
            TransType = "SHS";
        } else if (this.WinType.equalsIgnoreCase("Leverage Buy") || this.WinType.equalsIgnoreCase("LeverageBuy")) {
            bean.setOrderTransactionType("BUY");
        }
        boolean result = false;
        if (this.WinType.equalsIgnoreCase("Leverage Buy") || this.WinType.equalsIgnoreCase("LeverageBuy")) {
            bean.setOrderTransactionType("BUY");
            result = this.mediator.SendOrder(bean);
        } else if (bean.getOrderType().equalsIgnoreCase("SLO")) {
            if (LogsKSE.MarketStauts.equalsIgnoreCase("OHO") || LogsKSE.MarketStauts.equalsIgnoreCase("OHP")) {
                JOptionPane.showMessageDialog(null, "SLO Order is not allowed in Off Hour Transaction");
            } else {
                result = this.mediator.SendOrderSLO(bean);
            }
        } else if (bean.getOrderType().equalsIgnoreCase("MIT") || bean.getOrderType().equalsIgnoreCase("MIT")) {
            if (LogsKSE.MarketStauts.equalsIgnoreCase("OHO") || LogsKSE.MarketStauts.equalsIgnoreCase("OHP")) {
                JOptionPane.showMessageDialog(null, "MIT Order is not allowed in Off Hour Transaction");
            } else {
                result = this.mediator.SendOrderMIT(bean);
            }
        } else if (bean.getOrderType().equalsIgnoreCase("HIT") || bean.getOrderType().equalsIgnoreCase("TAK")) {
            if (LogsKSE.MarketStauts.equalsIgnoreCase("OHO") || LogsKSE.MarketStauts.equalsIgnoreCase("OHP")) {
                JOptionPane.showMessageDialog(null, "FOK Order is not allowed in Off Hour Transaction");
            } else {
                result = this.mediator.SendOrderHitTak(bean);
            }
        } else if (TransType.equalsIgnoreCase("SHS")) {
            result = this.mediator.SendOrderShortSel(bean);
        } else if (bean.getOrderType().equalsIgnoreCase("MKT")) {
            result = this.mediator.SendMarketOrder(bean);
        } else {
            if (bean.getOrderTransactionType().equalsIgnoreCase("SELL")) {
                bean.setOrderTransactionType("SEL");
            } else if (this.WinType.equalsIgnoreCase("SHORT SELL")) {
                bean.setOrderTransactionType("SHS");
            }
            result = this.mediator.SendOrder(bean);
        }
        this.MessageSent(result);
        ((JSpinner.DefaultEditor)this.spVolume.getEditor()).getTextField().requestFocus();
    }

    private class ColorComboBoxEditor
    implements ComboBoxEditor {
        JLabel lbl = new JLabel();

        public ColorComboBoxEditor() {
            this.lbl.setOpaque(true);
            this.lbl.setBackground(MyColors.BuyBG);
            this.lbl.setBorder(BorderFactory.createLineBorder(Color.WHITE));
            this.lbl.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    super.keyPressed(e);
                    if (e.getKeyCode() == 10 || e.getKeyCode() == 9) {
                        String val = KSE_FastOrderPanel.this.cbOrder.getSelectedItem().toString().trim();
                        if (val.trim().length() <= 0 || val.equalsIgnoreCase("0") || val.equalsIgnoreCase("0.0")) {
                            ((NxGComboBox)KSE_FastOrderPanel.this.cbOrder).setError(true);
                        } else {
                            ((NxGComboBox)KSE_FastOrderPanel.this.cbOrder).setError(false);
                            if (KSE_FastOrderPanel.this.cmbType.isEnabled()) {
                                KSE_FastOrderPanel.this.cmbType.getEditor().getEditorComponent().requestFocus();
                            } else {
                                KSE_FastOrderPanel.this.cbAccountNo.getEditor().getEditorComponent().requestFocus();
                            }
                        }
                    }
                }
            });
        }

        @Override
        public Component getEditorComponent() {
            return this.lbl;
        }

        @Override
        public void setItem(Object anObject) {
            this.lbl.setText(anObject.toString());
        }

        @Override
        public Object getItem() {
            if (this.lbl.getText().trim().equalsIgnoreCase("Sell")) {
                this.lbl.setBackground(MyColors.SellBG);
            } else {
                this.lbl.setBackground(MyColors.BuyBG);
            }
            return this.lbl.getText();
        }

        @Override
        public void selectAll() {
        }

        @Override
        public void addActionListener(ActionListener l) {
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }
    }
}

