/*
 * Decompiled with CFR 0.152.
 */
package Orders;

import Beans.OrderBean;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import common.gui.component.NxGDialogBox;
import common.gui.util.MessageType;
import common.gui.util.Util;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;

public class OddLotPrompt
extends NxGDialogBox {
    public static final int CancelOption_DoNothing = -1;
    public static final int SendIntoPreOpenMarket = 0;
    public static final int SendIntoOpenMarket = 1;
    public static final int MixLot = 2;
    public static final int OddLot = 3;
    private int option = -1;
    private String scrip = "";
    private int splitVol1 = 0;
    private int splitVol2 = 0;
    private OrderBean bean;
    private JButton btnCancel;
    private JButton btnOK;
    private ButtonGroup buttonGroup1;
    private JRadioButton isNotSplit;
    private JRadioButton isSplitInTwo;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSeparator jSeparator1;
    private JLabel lblMessage;
    private JLabel lblSplit1;
    private JLabel lblSplit2;
    private JLabel lblTitle;

    public OddLotPrompt(String scrip, int splitVol1, int splitVol2, OrderBean bean) {
        super((Frame)TradeCast.getInstance().frame, true);
        this.scrip = scrip;
        this.splitVol1 = splitVol1;
        this.splitVol2 = splitVol2;
        this.bean = bean;
        this.initComponents();
        this.setText();
        this.setCommenValues();
    }

    public OddLotPrompt(int lotType) {
        super((Frame)TradeCast.getInstance().frame, true);
        this.initComponents();
        this.setText(lotType);
        this.setCommenValues();
    }

    private void setCommenValues() {
        this.setTitle("Odd Lot order confirmation");
        if (Util.isWindow7()) {
            this.setBounds(0, 0, 525, 300);
        } else {
            this.setBounds(0, 0, 525, 305);
        }
        this.setResizable(false);
        this.setLocationRelativeTo(null);
    }

    public int getOption() {
        return this.option;
    }

    private void setText() {
        if (this.splitVol1 <= 1) {
            this.lblSplit1.setText("<html>Place <b>" + Util.format0digit((String)(this.splitVol1 + "")) + "</b> share of " + this.scrip + "  in <b>Pre-Open Market</b> state.</html>");
        } else {
            this.lblSplit1.setText("<html>Place <b>" + Util.format0digit((String)(this.splitVol1 + "")) + "</b> shares of " + this.scrip + "  in <b>Pre-Open Market</b> state.</html>");
        }
        if (this.splitVol2 <= 1) {
            this.lblSplit2.setText("<html>Place <b>" + Util.format0digit((String)(this.splitVol2 + "")) + "</b> share of " + this.scrip + " in <b>Open Market</b> state.</html>");
        } else {
            this.lblSplit2.setText("<html>Place <b>" + Util.format0digit((String)(this.splitVol2 + "")) + "</b> shares of " + this.scrip + " in <b>Open Market</b> state.</html>");
        }
        if (this.splitVol1 + this.splitVol2 <= 1) {
            this.lblTitle.setText("<html>You have placed an odd lot order of <b>" + Util.format0digit((String)(this.splitVol1 + this.splitVol2 + "")) + " share of " + this.scrip + "</b>, to proceed further</html>");
            this.isNotSplit.setText("Place " + Util.format0digit((String)(this.splitVol1 + this.splitVol2 + "")) + " share of " + this.scrip + " in Open Market state.");
        } else {
            this.lblTitle.setText("<html>You have placed an odd lot order of <b>" + Util.format0digit((String)(this.splitVol1 + this.splitVol2 + "")) + " shares of " + this.scrip + "</b>, to proceed further</html>");
            this.isNotSplit.setText("Place " + Util.format0digit((String)(this.splitVol1 + this.splitVol2 + "")) + " shares of " + this.scrip + " in Open Market state.");
        }
    }

    private void setText(int lotType) {
        if (lotType == 2) {
            this.lblTitle.setText("You have placed some odd lot orders also, to proceed further");
        } else if (lotType == 3) {
            this.lblTitle.setText("You have placed all odd lot orders, to proceed further");
        }
        this.isSplitInTwo.setText("Split all odd lot orders in two:");
        this.lblSplit1.setText("<html>Place normal lots in <b>Pre-Open Market</b> state.</html>");
        this.lblSplit2.setText("<html>Place odd lots in <b>Open Market</b> state.</html>");
        this.isNotSplit.setText("Place all odd lot orders in Open Market state.");
    }

    public void orderValidationFail() {
        this.option = -1;
        this.dispose();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.lblTitle = new JLabel();
        this.isSplitInTwo = new JRadioButton();
        this.lblSplit2 = new JLabel();
        this.lblSplit1 = new JLabel();
        this.isNotSplit = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        this.btnCancel = new JButton();
        this.btnOK = new JButton();
        this.lblMessage = new JLabel();
        this.jLabel4 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(null);
        this.jLabel3.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/offhour.png")));
        this.getContentPane().add(this.jLabel3);
        this.jLabel3.setBounds(390, 0, 60, 70);
        this.jLabel2.setFont(new Font("Tahoma", 1, 12));
        this.jLabel2.setText("Off Hour Orders");
        this.getContentPane().add(this.jLabel2);
        this.jLabel2.setBounds(30, 30, 300, 30);
        this.jLabel1.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/HeaderBG.png")));
        this.getContentPane().add(this.jLabel1);
        this.jLabel1.setBounds(0, 0, 540, 70);
        this.lblTitle.setText("You have placed an odd lot order of 501 to proceed further, please select the following option.");
        this.getContentPane().add(this.lblTitle);
        this.lblTitle.setBounds(20, 80, 480, 20);
        this.buttonGroup1.add(this.isSplitInTwo);
        this.isSplitInTwo.setFont(new Font("Tahoma", 1, 11));
        this.isSplitInTwo.setText("Split it in two orders:");
        this.getContentPane().add(this.isSplitInTwo);
        this.isSplitInTwo.setBounds(30, 130, 300, 23);
        this.lblSplit2.setText("Place 1 shares of PPL in Open Market state.");
        this.getContentPane().add(this.lblSplit2);
        this.lblSplit2.setBounds(70, 170, 350, 20);
        this.lblSplit1.setText("Place 500 shares of PPL in Pre-Open Market state.");
        this.getContentPane().add(this.lblSplit1);
        this.lblSplit1.setBounds(70, 150, 330, 20);
        this.buttonGroup1.add(this.isNotSplit);
        this.isNotSplit.setFont(new Font("Tahoma", 1, 11));
        this.isNotSplit.setText("Place 501 shares of PPL in Open Market state.");
        this.getContentPane().add(this.isNotSplit);
        this.isNotSplit.setBounds(30, 200, 320, 23);
        this.getContentPane().add(this.jSeparator1);
        this.jSeparator1.setBounds(0, 230, 540, 2);
        this.btnCancel.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/close.png")));
        this.btnCancel.setText("Cancel");
        this.btnCancel.setName("OddLotPrompt -> btnCancel");
        this.btnCancel.setPreferredSize(new Dimension(85, 23));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OddLotPrompt.this.btnCancelActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.btnCancel);
        this.btnCancel.setBounds(420, 238, 85, 25);
        this.btnOK.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/tick.png")));
        this.btnOK.setText("OK");
        this.btnOK.setMaximumSize(new Dimension(65, 23));
        this.btnOK.setMinimumSize(new Dimension(65, 23));
        this.btnOK.setName("OddLotPrompt -> btnOK");
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OddLotPrompt.this.btnOKActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.btnOK);
        this.btnOK.setBounds(330, 238, 85, 25);
        this.lblMessage.setText(" ");
        this.getContentPane().add(this.lblMessage);
        this.lblMessage.setBounds(30, 240, 280, 20);
        this.jLabel4.setText("please select one of the following options:");
        this.getContentPane().add(this.jLabel4);
        this.jLabel4.setBounds(20, 100, 420, 20);
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.option = -1;
        this.dispose();
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        if (!this.isSplitInTwo.isSelected() && !this.isNotSplit.isSelected()) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Please select any one of the options");
            return;
        }
        if (this.isSplitInTwo.isSelected()) {
            this.option = 0;
            if (this.bean != null) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Loading, (String)"Validating Order...");
                Mediator.getInstance().SendOrderValidate(this.bean);
                return;
            }
        } else if (this.isNotSplit.isSelected()) {
            this.option = 1;
        }
        this.dispose();
    }
}

