/*
 * Decompiled with CFR 0.152.
 */
package Orders;

import Beans.OrderBean;
import CustomComponent.ForgetMouseListner;
import CustomComponent.MyOptionPane;
import MyDocking.Mediator;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.MyColors;
import common.gui.util.Title;
import common.gui.util.Util;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import kse.util.LogsKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class OrderConfirmation
extends JPanel {
    private Mediator mediator = Mediator.getInstance();
    private String pincode = "";
    private LanguageCentre languageCentre = new LanguageCentre();
    OrderBean bean = null;
    String WinType;
    private final boolean isAskForPIN;
    private JButton btnDecline;
    private JButton btnExecute;
    private JCheckBox cbSave;
    public static JCheckBox cbShowPrompt;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JSeparator jSeparator1;
    private JLabel lblForgetPinCode;
    private JLabel lblPIN;
    private JTextField txtAccount;
    private JTextField txtDiscVolume;
    private JTextField txtLimit;
    private JTextField txtMarket;
    private JTextField txtOrderType;
    private JPasswordField txtPIN;
    private JTextField txtPrice;
    private JTextField txtSymbol;
    private JTextField txtVolume;

    public OrderConfirmation(String WinType, OrderBean bean, boolean isAskForPIN) {
        this.initComponents();
        this.bean = bean;
        this.WinType = WinType;
        this.isAskForPIN = isAskForPIN;
        this.setLanguageValues();
        this.setFields(bean);
        this.setAskForPIN();
    }

    public void setFields(OrderBean bean) {
        this.txtMarket.setText(bean.getMarket());
        this.txtSymbol.setText(bean.getScrip());
        this.txtPrice.setText(Util.format2digit((String)bean.getPriceString()));
        this.txtVolume.setText(Util.format0digit((String)bean.getVolumeString()));
        this.txtDiscVolume.setText(Util.format0digit((String)bean.getDiscVolumeString()));
        this.txtAccount.setText(bean.getAccount());
        if (bean.getOrderType().equalsIgnoreCase("SLO") || bean.getOrderType().equalsIgnoreCase("MIT") || bean.getOrderType().equalsIgnoreCase("MIT")) {
            this.txtLimit.setText(Util.format2digit((String)bean.getLimitString()));
        }
        if (bean.getOrderType().equalsIgnoreCase("MKT")) {
            this.txtPrice.setText("Market Order");
            this.txtPrice.setHorizontalAlignment(2);
        }
        this.pincode = bean.getPIN();
        if (bean.getOrderTransactionType().equalsIgnoreCase("BUY")) {
            this.setBackground(MyColors.BuyBG);
            cbShowPrompt.setBackground(MyColors.BuyBG);
        } else if (bean.getOrderTransactionType().equalsIgnoreCase("SELL") || bean.getOrderTransactionType().equalsIgnoreCase("SEL") || bean.getOrderTransactionType().equalsIgnoreCase("Short Sell")) {
            this.setBackground(MyColors.SellBG);
            cbShowPrompt.setBackground(MyColors.SellBG);
        } else if (bean.getMarket().equalsIgnoreCase("LB")) {
            this.setBackground(MyColors.BuyBG);
            cbShowPrompt.setBackground(MyColors.BuyBG);
        }
        if (bean.getOrderType().equalsIgnoreCase("NOR")) {
            this.txtOrderType.setText("Limit");
        } else if (bean.getOrderType().equalsIgnoreCase("SLO")) {
            this.txtOrderType.setText("SLO");
        } else if (bean.getOrderType().equalsIgnoreCase("MKT")) {
            this.txtOrderType.setText("MKT");
        } else if (bean.getOrderType().equalsIgnoreCase("MIT")) {
            this.txtOrderType.setText("MIT");
        } else if (bean.getOrderType().equalsIgnoreCase("HIT")) {
            this.txtOrderType.setText("FOK");
        } else if (bean.getOrderType().equalsIgnoreCase("TAK")) {
            this.txtOrderType.setText("FOK");
        } else if (bean.getOrderType().equalsIgnoreCase("MFS")) {
            this.txtOrderType.setText("Limit");
        }
        this.btnExecute.requestFocus();
        cbShowPrompt.setSelected(LogCommon.isConfirmation);
        this.getFocus();
    }

    public void getFocus() {
        new Thread("OrderConfirmation getFocus"){

            @Override
            public void run() {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (OrderConfirmation.this.isAskForPIN) {
                    OrderConfirmation.this.txtPIN.requestFocus();
                } else {
                    OrderConfirmation.this.btnExecute.requestFocus();
                }
            }
        }.start();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.txtSymbol = new JTextField();
        this.txtMarket = new JTextField();
        this.txtPrice = new JTextField();
        this.txtAccount = new JTextField();
        this.txtVolume = new JTextField();
        this.txtOrderType = new JTextField();
        this.btnExecute = new JButton();
        this.btnDecline = new JButton();
        cbShowPrompt = new JCheckBox();
        this.txtLimit = new JTextField();
        this.jLabel8 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.lblPIN = new JLabel();
        this.txtPIN = new JPasswordField();
        this.lblForgetPinCode = new JLabel();
        this.cbSave = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.txtDiscVolume = new JTextField();
        this.setLayout(null);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Market");
        this.add(this.jLabel1);
        this.jLabel1.setBounds(5, 10, 50, 20);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Scrip");
        this.add(this.jLabel2);
        this.jLabel2.setBounds(5, 40, 50, 20);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Order Type");
        this.add(this.jLabel3);
        this.jLabel3.setBounds(145, 10, 60, 20);
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("Volume");
        this.add(this.jLabel4);
        this.jLabel4.setBounds(145, 40, 60, 20);
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText("Price");
        this.add(this.jLabel5);
        this.jLabel5.setBounds(5, 70, 50, 20);
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText("Disc Volume");
        this.add(this.jLabel6);
        this.jLabel6.setBounds(145, 70, 60, 20);
        this.txtSymbol.setEditable(false);
        this.txtSymbol.setFocusable(false);
        this.add(this.txtSymbol);
        this.txtSymbol.setBounds(60, 40, 80, 20);
        this.txtMarket.setEditable(false);
        this.txtMarket.setFocusable(false);
        this.add(this.txtMarket);
        this.txtMarket.setBounds(60, 10, 80, 20);
        this.txtPrice.setEditable(false);
        this.txtPrice.setHorizontalAlignment(4);
        this.txtPrice.setFocusable(false);
        this.add(this.txtPrice);
        this.txtPrice.setBounds(60, 70, 80, 20);
        this.txtAccount.setEditable(false);
        this.txtAccount.setFocusable(false);
        this.add(this.txtAccount);
        this.txtAccount.setBounds(210, 100, 80, 20);
        this.txtVolume.setEditable(false);
        this.txtVolume.setHorizontalAlignment(4);
        this.txtVolume.setFocusable(false);
        this.add(this.txtVolume);
        this.txtVolume.setBounds(210, 40, 80, 20);
        this.txtOrderType.setEditable(false);
        this.txtOrderType.setFocusable(false);
        this.add(this.txtOrderType);
        this.txtOrderType.setBounds(210, 10, 80, 20);
        this.btnExecute.setText("Execute");
        this.btnExecute.setName("OrderConfirmation -> btnExecute");
        this.btnExecute.setOpaque(false);
        this.btnExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderConfirmation.this.btnExecuteActionPerformed(evt);
            }
        });
        this.add(this.btnExecute);
        this.btnExecute.setBounds(120, 160, 80, 23);
        this.btnDecline.setText("Decline");
        this.btnDecline.setName("OrderConfirmation -> btnDecline");
        this.btnDecline.setOpaque(false);
        this.btnDecline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderConfirmation.this.btnDeclineActionPerformed(evt);
            }
        });
        this.add(this.btnDecline);
        this.btnDecline.setBounds(211, 160, 80, 23);
        cbShowPrompt.setText("Always open this order confirmation window");
        cbShowPrompt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderConfirmation.this.cbShowPromptActionPerformed(evt);
            }
        });
        this.add(cbShowPrompt);
        cbShowPrompt.setBounds(10, 123, 70, 23);
        this.txtLimit.setEditable(false);
        this.txtLimit.setHorizontalAlignment(4);
        this.txtLimit.setFocusable(false);
        this.add(this.txtLimit);
        this.txtLimit.setBounds(60, 100, 80, 20);
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText("Limit Price");
        this.add(this.jLabel8);
        this.jLabel8.setBounds(5, 100, 50, 20);
        this.add(this.jSeparator1);
        this.jSeparator1.setBounds(0, 152, 370, 3);
        this.lblPIN.setHorizontalAlignment(4);
        this.lblPIN.setText("PIN");
        this.add(this.lblPIN);
        this.lblPIN.setBounds(10, 160, 50, 20);
        this.txtPIN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderConfirmation.this.txtPINActionPerformed(evt);
            }
        });
        this.txtPIN.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                OrderConfirmation.this.txtPINFocusGained(evt);
            }
        });
        this.add(this.txtPIN);
        this.txtPIN.setBounds(80, 160, 40, 20);
        this.lblForgetPinCode.setText("Forgot PIN?");
        this.add(this.lblForgetPinCode);
        this.lblForgetPinCode.setBounds(190, 120, 60, 20);
        this.cbSave.setText("Save Pin");
        this.cbSave.setOpaque(false);
        this.cbSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderConfirmation.this.cbSaveActionPerformed(evt);
            }
        });
        this.add(this.cbSave);
        this.cbSave.setBounds(110, 120, 67, 23);
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText("Account");
        this.add(this.jLabel7);
        this.jLabel7.setBounds(145, 100, 60, 20);
        this.txtDiscVolume.setEditable(false);
        this.txtDiscVolume.setHorizontalAlignment(4);
        this.txtDiscVolume.setFocusable(false);
        this.add(this.txtDiscVolume);
        this.txtDiscVolume.setBounds(210, 70, 80, 20);
    }

    private void btnExecuteActionPerformed(ActionEvent evt) {
        if (this.bean != null) {
            if (this.isAskForPIN) {
                if (this.txtPIN.getText().trim().length() <= 0) {
                    MyOptionPane.showMessage(MessageType.Warring, this.languageCentre.getValue(LanguageConstant.PleaseEnterPIN), this.languageCentre.getValue(LanguageConstant.Error), true);
                    this.txtPIN.requestFocus();
                    return;
                }
                this.bean.setPIN(this.txtPIN.getText());
            }
            if (this.bean.getOrderTransactionType().equalsIgnoreCase("SELL")) {
                this.bean.setOrderTransactionType("SEL");
            } else if (this.WinType.equalsIgnoreCase("SHORT SELL")) {
                this.bean.setOrderTransactionType("SHS");
            } else if (this.WinType.equalsIgnoreCase("Leverage Buy") || this.WinType.equalsIgnoreCase("LeverageBuy") || this.bean.getOrderTransactionType().equalsIgnoreCase("Leverage Buy") || this.bean.getOrderTransactionType().equalsIgnoreCase("LeverageBuy") || this.WinType.equalsIgnoreCase(Title.MFS) || this.bean.getOrderTransactionType().equalsIgnoreCase(Title.MFS)) {
                this.bean.setOrderTransactionType("BUY");
            }
            boolean result = false;
            boolean continueorder = true;
            if (continueorder) {
                if (this.WinType.equalsIgnoreCase("Leverage Buy") || this.WinType.equalsIgnoreCase("LeverageBuy") || this.WinType.equalsIgnoreCase(Title.MFS)) {
                    result = this.WinType.equalsIgnoreCase(LanguageConstant.ChangeOrder) ? this.SendOrderChange(this.bean) : this.mediator.SendOrder(this.bean);
                } else if (this.bean.getOrderType().equalsIgnoreCase("SLO")) {
                    if (LogsKSE.MarketStauts.equalsIgnoreCase("OHO") || LogsKSE.MarketStauts.equalsIgnoreCase("OHP")) {
                        new Thread(){

                            @Override
                            public void run() {
                                MyOptionPane.showMessage(MessageType.Information, OrderConfirmation.this.languageCentre.getValue(LanguageConstant.StopLossOrderIsNotAllowedInOffHourTransaction), OrderConfirmation.this.languageCentre.getValue(LanguageConstant.StopLossOrder), true);
                            }
                        }.start();
                    } else {
                        result = this.WinType.equalsIgnoreCase(LanguageConstant.ChangeOrder) ? this.SendOrderChange(this.bean) : this.mediator.SendOrderSLO(this.bean);
                    }
                } else if (this.bean.getOrderType().equalsIgnoreCase("MIT") || this.bean.getOrderType().equalsIgnoreCase("MIT")) {
                    if (LogsKSE.MarketStauts.equalsIgnoreCase("OHO") || LogsKSE.MarketStauts.equalsIgnoreCase("OHP")) {
                        new Thread(){

                            @Override
                            public void run() {
                                MyOptionPane.showMessage(MessageType.Information, OrderConfirmation.this.languageCentre.getValue(LanguageConstant.MarketIfTouchOrderIsNotAllowedInOffHourTransaction), OrderConfirmation.this.languageCentre.getValue(LanguageConstant.MarketIfTouchOrder), true);
                            }
                        }.start();
                    } else {
                        result = this.WinType.equalsIgnoreCase(LanguageConstant.ChangeOrder) ? this.SendOrderChange(this.bean) : this.mediator.SendOrderMIT(this.bean);
                    }
                } else if (this.bean.getOrderType().equalsIgnoreCase("HIT") || this.bean.getOrderType().equalsIgnoreCase("TAK")) {
                    if (LogsKSE.MarketStauts.equalsIgnoreCase("OHO") || LogsKSE.MarketStauts.equalsIgnoreCase("OHP")) {
                        new Thread(){

                            @Override
                            public void run() {
                                MyOptionPane.showMessage(MessageType.Information, OrderConfirmation.this.languageCentre.getValue(LanguageConstant.FillOrKillOrderIsNotAllowedInOffHourTransaction), OrderConfirmation.this.languageCentre.getValue(LanguageConstant.FillOrKillOrder), true);
                            }
                        }.start();
                    } else {
                        result = this.WinType.equalsIgnoreCase(LanguageConstant.ChangeOrder) ? this.SendOrderChange(this.bean) : this.mediator.SendOrderHitTak(this.bean);
                    }
                } else {
                    result = this.bean.getOrderTransactionType().equalsIgnoreCase("SHS") ? (this.WinType.equalsIgnoreCase(LanguageConstant.ChangeOrder) ? this.SendOrderChange(this.bean) : this.mediator.SendOrderShortSel(this.bean)) : (this.bean.getOrderType().equalsIgnoreCase("MKT") ? (this.WinType.equalsIgnoreCase(LanguageConstant.ChangeOrder) ? this.SendOrderChange(this.bean) : this.mediator.SendMarketOrder(this.bean)) : (LogsKSE.MarketStauts.equalsIgnoreCase("OHO") || LogsKSE.MarketStauts.equalsIgnoreCase("OHP") ? (this.WinType.equalsIgnoreCase(LanguageConstant.ChangeOrder) ? this.SendOrderChange(this.bean) : this.mediator.SendOrder(this.bean)) : (this.WinType.equalsIgnoreCase(LanguageConstant.ChangeOrder) ? this.SendOrderChange(this.bean) : this.mediator.SendOrder(this.bean))));
                }
            }
            if (this.WinType.equalsIgnoreCase(LanguageConstant.ChangeOrder) && this.mediator.changeOrder != null) {
                this.mediator.changeOrder.MessageSent(result);
            } else if ((this.WinType.equalsIgnoreCase("LeverageBuy") || this.WinType.equalsIgnoreCase("Leverage Buy") || this.WinType.equalsIgnoreCase(Title.MFS)) && this.mediator.buysell != null) {
                this.mediator.buysell.MessageSent(result);
            } else if (this.bean.getOrderTransactionType().equalsIgnoreCase("BUY") && this.mediator.buysell != null) {
                this.mediator.buysell.MessageSent(result);
            } else if ((this.bean.getOrderTransactionType().equalsIgnoreCase("SELL") || this.bean.getOrderTransactionType().equalsIgnoreCase("SEL")) && this.mediator.buysell != null) {
                this.mediator.buysell.MessageSent(result);
            } else if (this.WinType.equalsIgnoreCase("SHORT SELL") && this.mediator.shortsell != null) {
                this.mediator.shortsell.MessageSent(result);
            }
            if (this.mediator.neworder != null) {
                this.mediator.neworder.reset(result);
            }
            ((JDialog)this.getRootPane().getParent()).dispose();
        }
    }

    private void cbShowPromptActionPerformed(ActionEvent evt) {
        LogCommon.isConfirmation = cbShowPrompt.isSelected();
    }

    private void btnDeclineActionPerformed(ActionEvent evt) {
        if (this.bean != null) {
            if (this.WinType.equalsIgnoreCase(LanguageConstant.ChangeOrder) && this.mediator.changeOrder != null) {
                this.mediator.changeOrder.MessageSent(false);
            } else if ((this.WinType.equalsIgnoreCase("LeverageBuy") || this.WinType.equalsIgnoreCase("Leverage Buy") || this.WinType.equalsIgnoreCase(Title.MFS)) && this.mediator.buysell != null) {
                this.mediator.buysell.MessageSent(false);
            } else if (this.bean.getOrderTransactionType().equalsIgnoreCase("BUY") && this.mediator.buysell != null) {
                this.mediator.buysell.MessageSent(false);
            } else if (this.bean.getOrderTransactionType().equalsIgnoreCase("SELL") && this.mediator.buysell != null) {
                this.mediator.buysell.MessageSent(false);
            } else if (this.WinType.equalsIgnoreCase("SHORT SELL") && this.mediator.shortsell != null) {
                this.mediator.shortsell.MessageSent(false);
            }
            if (this.mediator.neworder != null) {
                this.mediator.neworder.reset(false);
            }
            ((JDialog)this.getRootPane().getParent()).dispose();
        }
    }

    private void txtPINFocusGained(FocusEvent evt) {
        this.txtPIN.selectAll();
    }

    private void txtPINActionPerformed(ActionEvent evt) {
        if (this.txtPIN.getText().length() <= 0) {
            MyOptionPane.showMessage(MessageType.Warring, this.languageCentre.getValue(LanguageConstant.PleaseEnterPIN), this.languageCentre.getValue(LanguageConstant.Error), true);
            this.txtPIN.requestFocus();
            return;
        }
        this.btnExecute.requestFocus();
    }

    private void cbSaveActionPerformed(ActionEvent evt) {
        LogCommon.pinCode = this.cbSave.isSelected() ? this.txtPIN.getText() : "";
    }

    private void setAskForPIN() {
        this.lblPIN.setVisible(this.isAskForPIN);
        this.txtPIN.setVisible(this.isAskForPIN);
        this.lblForgetPinCode.setVisible(this.isAskForPIN);
        cbShowPrompt.setVisible(!this.isAskForPIN);
        if (LogCommon.pinCode.length() > 0) {
            this.txtPIN.setText(LogCommon.pinCode);
            this.cbSave.setSelected(true);
        }
        if (this.isAskForPIN) {
            this.lblForgetPinCode.setForeground(MyColors.ForgotPincodeFG);
            this.lblForgetPinCode.setText("<html>" + this.languageCentre.getValue(LanguageConstant.ForgotPIN) + "</html>");
            ForgetMouseListner forgetMouseListner = new ForgetMouseListner(this.lblForgetPinCode);
            this.lblForgetPinCode.addMouseListener(forgetMouseListner);
            this.lblPIN.setBounds(5, 130, 50, 20);
            this.txtPIN.setBounds(60, 130, 45, 20);
            this.cbSave.setBounds(110, 130, 90, 20);
            this.lblForgetPinCode.setBounds(210, 130, 60, 20);
            this.jSeparator1.setBounds(0, 154, 600, 3);
        } else {
            cbShowPrompt.setBounds(10, 125, 240, 20);
            this.lblPIN.setBounds(160, 100, 50, 20);
            this.txtPIN.setBounds(210, 100, 80, 20);
        }
    }

    private boolean SendOrderChange(OrderBean bean) {
        if (LogsKSE.MarketStauts.indexOf("PRE") >= 0 || LogsKSE.MarketStauts.indexOf("OHP") >= 0) {
            MyOptionPane.showMessage(MessageType.Warring, this.languageCentre.getValue(LanguageConstant.YouCanNotChangeYourOrderInPreOpenMarketState), true);
            return false;
        }
        return this.mediator.SendOrderChange(bean);
    }

    private void setLanguageValues() {
        this.jLabel1.setText(this.languageCentre.getValue(LanguageConstant.Market));
        this.jLabel2.setText(this.languageCentre.getValue(LanguageConstant.Scrip));
        this.jLabel3.setText(this.languageCentre.getValue(LanguageConstant.OrderType));
        this.jLabel4.setText(this.languageCentre.getValue(LanguageConstant.Volume));
        this.jLabel5.setText(this.languageCentre.getValue(LanguageConstant.Price));
        this.jLabel6.setText(this.languageCentre.getValue(LanguageConstant.DiscVolume));
        this.btnExecute.setText(this.languageCentre.getValue(LanguageConstant.Execute));
        this.btnDecline.setText(this.languageCentre.getValue(LanguageConstant.Decline));
        cbShowPrompt.setText(this.languageCentre.getValue(LanguageConstant.AlwaysOpenThisOrderConfirmationWindow));
        this.jLabel8.setText(this.languageCentre.getValue(LanguageConstant.LimitPrice));
        this.lblPIN.setText(this.languageCentre.getValue(LanguageConstant.PIN));
        this.lblForgetPinCode.setText(this.languageCentre.getValue(LanguageConstant.ForgotPIN));
        this.cbSave.setText(this.languageCentre.getValue(LanguageConstant.SavePIN));
        this.jLabel7.setText(this.languageCentre.getValue("Account"));
    }
}

