/*
 * Decompiled with CFR 0.152.
 */
package Orders;

import Beans.OrderBean;
import CustomComponent.DocumentType;
import CustomComponent.MyOptionPane;
import CustomComponent.NxGPassword;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Orders.ExecuteMarketDialog;
import Utilities.LogsTC;
import Utilities.OutstandingLogUtil;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.component.NxGTable;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import kse.gui.bean.OrderImportBean;
import kse.gui.model.OrderImportModel;
import kse.gui.render.OrderImportRender;
import kse.util.LogsKSE;

public class OrderImport
extends JPanel
implements ActionListener,
ItemListener {
    Vector<String> columns = new Vector();
    Vector<OrderImportBean> rows = new Vector();
    Vector<OrderImportBean> rowsAll = new Vector();
    OrderImportModel model;
    OrderImportRender render;
    private AutoCompleteSupport autoCompleteScrip;
    private AutoCompleteSupport autoCompleteMarket;
    private AutoCompleteSupport autoCompleteAccount;
    private JTextComponent editorScrip;
    private JTextComponent editorMarket;
    private JTextComponent editorAccount;
    JFileChooser chooser = new JFileChooser();
    public static ArrayList<OrderBean> list = new ArrayList();
    private final Cursor handCursor = new Cursor(12);
    final Cursor defaultCursor = new Cursor(0);
    private boolean isOutstandingOrder;
    private JButton btnClearAll;
    private JButton btnOpenFile;
    private JButton btnSendOrder;
    private JComboBox cbAccountNo;
    private JCheckBox cbBuy;
    private JComboBox cbMarkets;
    private JComboBox cbScrip;
    private JCheckBox cbSell;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel lblMarket;
    private JLabel lblMessage;
    private JLabel lblPinCode;
    private JScrollPane scrollPane;
    private NxGTable table;
    private NxGPassword txtPinCode;

    public OrderImport() {
        this.initComponents();
        this.init();
        this.initTable();
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".txt") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Text File(*.txt)";
            }
        });
    }

    public void init() {
        this.setMarkets();
        this.editorMarket = (JTextComponent)this.cbMarkets.getEditor().getEditorComponent();
        this.editorMarket.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                OrderImport.this.OnEnter(evt);
            }
        });
        this.setAllScrip();
        this.editorScrip = (JTextComponent)this.cbScrip.getEditor().getEditorComponent();
        this.editorScrip.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OrderImport.this.OnEnter(evt);
            }
        });
        this.setAccount();
        this.cbBuy.addItemListener(this);
        this.cbSell.addItemListener(this);
        if (LogCommon.pinCode.length() > 0) {
            this.txtPinCode.setText(LogCommon.pinCode);
        }
        this.txtPinCode.setDocument(DocumentType.NUMERIC, 4);
    }

    private void initTable() {
        this.columns.add("Remove");
        this.columns.add("Market");
        this.columns.add("Scrip");
        this.columns.add("Price");
        this.columns.add("Volume");
        this.columns.add("Account");
        this.columns.add("Type");
        this.model = new OrderImportModel(this.rows, this.columns);
        this.table.setModel((TableModel)this.model);
        this.render = new OrderImportRender();
        for (int k = 0; k < this.model.getColumnCount(); ++k) {
            this.table.getColumn((Object)this.model.getColumnName(k)).setCellRenderer((TableCellRenderer)this.render);
        }
        this.cbSell.setForeground(MyColors.SellBG);
        this.cbBuy.setForeground(MyColors.BuyBG);
        this.table.setColumnControlVisible(false);
        this.table.setSortOrderCycle(new SortOrder[]{SortOrder.ASCENDING});
        this.tableDataChange(false);
        this.setSorter();
    }

    private void setSorter() {
        JTableHeader tableHeader = this.table.getTableHeader();
        tableHeader.addMouseListener(new ColumnListner(this.table));
        tableHeader.setReorderingAllowed(false);
    }

    private void tableDataChange(final boolean isPackAll) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.model.fireTableDataChanged();
            this.table.addNotify();
            if (isPackAll) {
                this.table.packAll();
            }
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OrderImport.this.model.fireTableDataChanged();
                    OrderImport.this.table.addNotify();
                    if (isPackAll) {
                        OrderImport.this.table.packAll();
                    }
                    OrderImport.this.table.repaint();
                }
            });
        }
    }

    private void setMarkets() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (OrderImport.this.autoCompleteMarket != null && OrderImport.this.autoCompleteMarket.isInstalled()) {
                    OrderImport.this.autoCompleteMarket.uninstall();
                }
                Vector<String> allMarket = new Vector<String>();
                allMarket.addElement("ALL");
                for (int i = 0; i < LogCommon.markets.length; ++i) {
                    allMarket.addElement(LogCommon.markets[i]);
                }
                Collections.sort(allMarket);
                OrderImport.this.cbMarkets.setModel(new DefaultComboBoxModel(allMarket));
                OrderImport.this.autoCompleteMarket = AutoCompleteSupport.install((JComboBox)OrderImport.this.cbMarkets, (EventList)GlazedLists.eventListOf((Object[])allMarket.toArray()));
                OrderImport.this.cbMarkets.setSelectedItem("ALL");
                OrderImport.this.autoCompleteMarket.setStrict(true);
            }
        });
    }

    private void setAccount() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (OrderImport.this.autoCompleteAccount != null && OrderImport.this.autoCompleteAccount.isInstalled()) {
                        OrderImport.this.autoCompleteAccount.uninstall();
                    }
                    ArrayList<String> allAccount = new ArrayList<String>();
                    for (String s : LogsTC.accountAll.keySet()) {
                        allAccount.add(s);
                    }
                    Collections.sort(allAccount);
                    allAccount.add(0, "ALL");
                    OrderImport.this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(allAccount.toArray()));
                    OrderImport.this.autoCompleteAccount = AutoCompleteSupport.install((JComboBox)OrderImport.this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])allAccount.toArray()));
                    OrderImport.this.cbAccountNo.setSelectedItem("ALL");
                    OrderImport.this.editorAccount = (JTextComponent)OrderImport.this.cbAccountNo.getEditor().getEditorComponent();
                    OrderImport.this.editorAccount.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyReleased(KeyEvent e) {
                            OrderImport.this.OnEnter(e);
                        }
                    });
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public void setAllScrip() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (OrderImport.this.autoCompleteScrip != null && OrderImport.this.autoCompleteScrip.isInstalled()) {
                        OrderImport.this.autoCompleteScrip.uninstall();
                    }
                    Vector allScrip = new Vector(LogCommon.SymbolAndSymbolName.keySet());
                    allScrip.addElement("ALL");
                    Collections.sort(allScrip);
                    OrderImport.this.cbScrip.setModel(new DefaultComboBoxModel(allScrip));
                    OrderImport.this.autoCompleteScrip = AutoCompleteSupport.install((JComboBox)OrderImport.this.cbScrip, (EventList)GlazedLists.eventListOf((Object[])allScrip.toArray()));
                    OrderImport.this.cbScrip.setSelectedItem("ALL");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private void initComponents() {
        this.lblMarket = new JLabel();
        this.cbMarkets = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.cbScrip = new JComboBox();
        this.cbAccountNo = new JComboBox();
        this.cbBuy = new JCheckBox();
        this.cbSell = new JCheckBox();
        this.scrollPane = new JScrollPane();
        this.table = new NxGTable();
        this.lblMessage = new JLabel();
        this.btnOpenFile = new JButton();
        this.txtPinCode = new NxGPassword();
        this.lblPinCode = new JLabel();
        this.btnSendOrder = new JButton();
        this.btnClearAll = new JButton();
        this.setLayout(null);
        this.lblMarket.setText("Market");
        this.add(this.lblMarket);
        this.lblMarket.setBounds(10, 10, 40, 23);
        this.add(this.cbMarkets);
        this.cbMarkets.setBounds(60, 10, 80, 23);
        this.jLabel1.setText("Account");
        this.add(this.jLabel1);
        this.jLabel1.setBounds(10, 40, 50, 23);
        this.jLabel2.setText("Scrip");
        this.add(this.jLabel2);
        this.jLabel2.setBounds(150, 10, 34, 23);
        this.cbScrip.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.add(this.cbScrip);
        this.cbScrip.setBounds(190, 10, 80, 23);
        this.cbAccountNo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.add(this.cbAccountNo);
        this.cbAccountNo.setBounds(60, 40, 80, 23);
        this.cbBuy.setText("Buy");
        this.add(this.cbBuy);
        this.cbBuy.setBounds(150, 40, 50, 23);
        this.cbSell.setText("Sell");
        this.add(this.cbSell);
        this.cbSell.setBounds(200, 40, 41, 23);
        this.table.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[]{"Status"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OrderImport.this.tableMouseClicked(evt);
            }
        });
        this.table.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                OrderImport.this.tableMouseMoved(evt);
            }
        });
        this.scrollPane.setViewportView((Component)this.table);
        this.add(this.scrollPane);
        this.scrollPane.setBounds(10, 69, 380, 390);
        this.lblMessage.setText(" ");
        this.add(this.lblMessage);
        this.lblMessage.setBounds(10, 465, 180, 22);
        this.btnOpenFile.setIcon(new ImageIcon(this.getClass().getResource("/Images/openCDC.png")));
        this.btnOpenFile.setText("Open File");
        this.btnOpenFile.setName("OrderImport -> btnOpenFile");
        this.btnOpenFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderImport.this.btnOpenFileActionPerformed(evt);
            }
        });
        this.add(this.btnOpenFile);
        this.btnOpenFile.setBounds(290, 10, 100, 23);
        this.txtPinCode.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.add(this.txtPinCode);
        this.txtPinCode.setBounds(240, 465, 40, 22);
        this.lblPinCode.setHorizontalAlignment(0);
        this.lblPinCode.setText("PIN");
        this.add(this.lblPinCode);
        this.lblPinCode.setBounds(190, 465, 40, 22);
        this.btnSendOrder.setText("Send Order");
        this.btnSendOrder.setName("OrderImport -> btnSendOrder");
        this.btnSendOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderImport.this.btnSendOrderActionPerformed(evt);
            }
        });
        this.add(this.btnSendOrder);
        this.btnSendOrder.setBounds(289, 465, 100, 22);
        this.btnClearAll.setIcon(new ImageIcon(this.getClass().getResource("/Images/close16.png")));
        this.btnClearAll.setText("Clear All");
        this.btnClearAll.setName("OrderImport -> btnClearAll");
        this.btnClearAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderImport.this.btnClearAllActionPerformed(evt);
            }
        });
        this.add(this.btnClearAll);
        this.btnClearAll.setBounds(290, 40, 100, 23);
    }

    private void btnOpenFileActionPerformed(ActionEvent evt) {
        this.openAndLoadFile();
    }

    private void btnSendOrderActionPerformed(ActionEvent evt) {
        this.txtPinCode.setError(false);
        if (this.rows.size() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Please add order(s)");
        } else if (this.txtPinCode.getText().trim().length() < 4) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Please enter PIN");
            this.txtPinCode.requestFocus();
            this.txtPinCode.setError(true);
        } else {
            this.sendOrder();
            TradeCast.getInstance().CloseForm(FormName.OrderImport);
        }
    }

    private void tableMouseClicked(MouseEvent evt) {
        int viewRow = this.table.getSelectedRow();
        int viewColumn = this.table.getSelectedColumn();
        if (viewRow >= 0 && viewColumn == 0) {
            int modelRow = this.table.convertRowIndexToModel(viewRow);
            this.rows.remove(modelRow);
        }
        this.tableDataChange(false);
        if (this.model.getRowCount() > 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)(Util.format0digit((String)(this.model.getRowCount() + "".trim().replaceAll("\\,", ""))) + " records found."));
        } else {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)(Util.format0digit((String)(this.model.getRowCount() + "".trim().replaceAll("\\,", ""))) + " record found."));
        }
    }

    private void tableMouseMoved(MouseEvent evt) {
        TableColumnModel colModel = this.table.getColumnModel();
        int vColIndex = colModel.getColumnIndexAtX(evt.getX());
        int mColIndex = this.table.convertColumnIndexToModel(vColIndex);
        if ("Remove".equalsIgnoreCase(this.table.getColumnName(mColIndex))) {
            this.table.setCursor(this.handCursor);
        } else {
            this.table.setCursor(this.defaultCursor);
        }
    }

    private void btnClearAllActionPerformed(ActionEvent evt) {
        list.clear();
        this.rows.clear();
        this.rowsAll.clear();
        this.tableDataChange(false);
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.cbBuy || source == this.cbSell) {
            this.rowFilter();
        }
    }

    private void OnEnter(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.rowFilter();
        }
    }

    private void rowFilter() {
        this.rows.clear();
        String account = this.getAccount();
        String market = this.getMarket();
        String scrip = this.getScrip();
        String Type2 = "";
        if (this.cbSell.isSelected()) {
            Type2 = "SELL";
        }
        if (this.cbBuy.isSelected()) {
            Type2 = "BUY";
        }
        if (this.cbBuy.isSelected() && this.cbSell.isSelected()) {
            Type2 = "";
        }
        for (OrderImportBean b : this.rowsAll) {
            if (!b.getScrip().trim().equalsIgnoreCase(scrip) && scrip.length() > 0 || !b.getMarket().trim().equalsIgnoreCase(market) && market.length() > 0 || !b.getAccount().trim().equalsIgnoreCase(account) && account.length() > 0 || !b.getType().equalsIgnoreCase(Type2) && Type2.length() > 0) continue;
            this.rows.add(b);
        }
        if (this.model.getRowCount() > 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)(Util.format0digit((String)(this.model.getRowCount() + "".trim().replaceAll("\\,", ""))) + " records found."));
        } else {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)(Util.format0digit((String)(this.model.getRowCount() + "".trim().replaceAll("\\,", ""))) + " record found."));
        }
        this.lblMessage.setIcon(null);
        this.tableDataChange(false);
    }

    private String getAccount() {
        if (this.cbAccountNo.getSelectedItem() == null) {
            return "";
        }
        String a = this.cbAccountNo.getSelectedItem().toString();
        if (a.equalsIgnoreCase("all")) {
            return "";
        }
        return a;
    }

    private String getMarket() {
        if (this.cbMarkets.getSelectedItem() == null) {
            return "";
        }
        String a = this.cbMarkets.getSelectedItem().toString();
        if (a.equalsIgnoreCase("all")) {
            return "";
        }
        return a;
    }

    private String getScrip() {
        if (this.cbScrip.getSelectedItem() == null) {
            return "";
        }
        String a = this.cbScrip.getSelectedItem().toString();
        if (a.equalsIgnoreCase("all")) {
            return "";
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openAndLoadFile() {
        File f = new File(System.getProperty("user.home"));
        this.chooser.setSelectedFile(f);
        int returnVal = this.chooser.showOpenDialog(TradeCast.getInstance().frame);
        if (returnVal == 0) {
            File file = this.chooser.getSelectedFile();
            String fileName = file.getName();
            if (fileName.indexOf(".txt") < 0) {
                fileName = fileName + ".txt";
            }
            String parent = file.getParent();
            String path = parent + Util.FileSeparator + fileName;
            BufferedReader br = null;
            try {
                String sCurrentLine;
                br = new BufferedReader(new FileReader(path));
                this.isOutstandingOrder = false;
                while ((sCurrentLine = br.readLine()) != null) {
                    String[] data;
                    if (sCurrentLine.trim().length() < 0 || (data = sCurrentLine.split("\\;", -1)).length <= 5) continue;
                    try {
                        OrderImportBean bean = new OrderImportBean();
                        bean.setMarket(data[0]);
                        bean.setScrip(data[1]);
                        bean.setPrice(Double.parseDouble(data[2]));
                        bean.setVolume(Long.parseLong(data[3]));
                        bean.setAccount(data[4]);
                        bean.setType(data[5]);
                        if (!bean.isValid()) continue;
                        bean.setInOutsanding(OutstandingLogUtil.isInOutstaning(bean));
                        this.rowsAll.add(bean);
                        if (this.isOutstandingOrder) continue;
                        this.isOutstandingOrder = bean.isInOutsanding();
                    }
                    catch (NumberFormatException ex) {
                        ex.printStackTrace();
                    }
                }
                this.rowFilter();
                if (this.isOutstandingOrder) {
                    MyOptionPane.showMessage(MessageType.Information, "Some orders are already in outstanding, which are highlighted with yellow color", true);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void sendOrder() {
        list.clear();
        for (OrderImportBean orderExportImportBean : this.rows) {
            list.add(this.getConvert(orderExportImportBean));
        }
        ExecuteMarketDialog executeMarket = new ExecuteMarketDialog(TradeCast.getInstance().frame, list, false);
        int n = executeMarket.Option;
        if (n == 0) {
            OrderImport.SendBasketOrder();
        }
    }

    private OrderBean getConvert(OrderImportBean b) {
        OrderBean bean = new OrderBean();
        bean.setMarket(b.getMarket());
        bean.setScrip(b.getScrip());
        bean.setVolume(b.getVolume() + "");
        bean.setPrice(b.getPrice());
        bean.setAccount(b.getAccount());
        bean.setPIN(this.txtPinCode.getText());
        bean.setOrderTransactionType(b.getType());
        bean.setOrderType("NOR");
        return bean;
    }

    public static synchronized void SendBasketOrder() {
        if (list.size() > 0) {
            LogsKSE.IsInOrderExportProcess = true;
            boolean result = false;
            OrderBean bean = list.remove(0);
            result = Mediator.getInstance().SendOrderBascket(bean);
            if (!(result || LogsKSE.MarketStauts.equalsIgnoreCase("OHO") && LogsKSE.MarketStauts.equalsIgnoreCase("OHP"))) {
                LogsKSE.IsInOrderExportProcess = false;
                int countt = list.size() + 1;
                list.clear();
                Mediator.getInstance().msgCenter.AddMessageInMsgWin("Order<>" + Mediator.getInstance().myTime.getTime() + " - Your " + countt + " Order Export has been rejected.");
            }
        } else {
            LogsKSE.IsInOrderExportProcess = false;
        }
    }

    private class ColumnListner
    extends MouseAdapter {
        private final NxGTable table;
        protected int sortCol = 0;
        protected boolean isSortAsc = true;
        private TableColumnModel colModel;

        public ColumnListner(NxGTable table) {
            this.table = table;
            this.colModel = table.getColumnModel();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            final MouseEvent evt2 = e;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (OrderImport.this.rows.size() > 1) {
                        ColumnListner.this.sortTable(evt2);
                    }
                }
            }, "Order Export Import sortTable").start();
        }

        private void sortTable(MouseEvent e) {
            try {
                String oldMessage = OrderImport.this.lblMessage.getText();
                Util.setMessage((JLabel)OrderImport.this.lblMessage, (MessageType)MessageType.Loading, (String)"Please wait while sorting...");
                int columnModelIndex = this.colModel.getColumnIndexAtX(e.getX());
                int modelIndex = this.colModel.getColumn(columnModelIndex).getModelIndex();
                if (modelIndex < 0) {
                    return;
                }
                if (this.sortCol == modelIndex) {
                    this.isSortAsc = !this.isSortAsc;
                } else {
                    this.sortCol = modelIndex;
                }
                Collections.sort(OrderImport.this.rows, new OrderExportImportComparator(this.sortCol, this.isSortAsc));
                OrderImport.this.tableDataChange(false);
                Util.setMessage((JLabel)OrderImport.this.lblMessage, (MessageType)MessageType.Normal, (String)oldMessage);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private class OrderExportImportComparator
    implements Comparator<OrderImportBean> {
        int colIndex = 0;
        boolean isAsc = true;

        public OrderExportImportComparator(int colIndex, boolean isAsc) {
            this.colIndex = colIndex;
            this.isAsc = isAsc;
        }

        @Override
        public int compare(OrderImportBean b1, OrderImportBean b2) {
            int result = 0;
            switch (this.colIndex) {
                case 5: {
                    result = b1.getAccount().compareTo(b2.getAccount());
                    break;
                }
                case 1: {
                    result = b1.getMarket().compareTo(b2.getMarket());
                    break;
                }
                case 3: {
                    result = b1.getPrice() < b2.getPrice() ? -1 : (b1.getPrice() > b2.getPrice() ? 1 : 0);
                    break;
                }
                case 2: {
                    result = b1.getScrip().compareTo(b2.getScrip());
                    break;
                }
                case 6: {
                    result = b1.getType().compareTo(b2.getType());
                    break;
                }
                case 4: {
                    int n = b1.getVolume() < b2.getVolume() ? -1 : (result = b1.getVolume() > b2.getVolume() ? 1 : 0);
                }
            }
            if (!this.isAsc) {
                result = -result;
            }
            return result;
        }
    }
}

