/*
 * Decompiled with CFR 0.152.
 */
package Orders;

import CustomComponent.MyOptionPane;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Orders.StrategyOrderDetailDialog;
import Utilities.CompressManager;
import Utilities.LogsTC;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.component.NxGTable;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import kse.gui.bean.StrategyOrderBean;
import kse.gui.model.StrategyOrderModel;
import kse.gui.render.StrategyOrderRender;
import kse.util.LogsKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import login.LoginServer;

public class StrategyOrder
extends JPanel
implements ActionListener,
ItemListener {
    private Vector<String> columns = new Vector();
    private Vector<StrategyOrderBean> rows = new Vector();
    private Vector<StrategyOrderBean> rowsAll = new Vector();
    private StrategyOrderModel model;
    private StrategyOrderRender render;
    private Mediator mediator = Mediator.getInstance();
    private AutoCompleteSupport autoCompleteScrip;
    private AutoCompleteSupport autoCompleteMarket;
    private AutoCompleteSupport autoCompleteAccount;
    private JTextComponent editorScrip;
    private JTextComponent editorMarket;
    private JTextComponent editorAccount;
    private Timer timer2 = null;
    private final int CALL_DELAY = 1000;
    final Cursor handCursor = new Cursor(12);
    final Cursor defaultCursor = new Cursor(0);
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnGet;
    private JComboBox cbAccountNo;
    private JCheckBox cbBuy;
    private JComboBox cbMarkets;
    private JComboBox cbScrip;
    private JCheckBox cbSell;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSeparator jSeparator1;
    private JLabel lblMarket;
    private JLabel lblMessage;
    private JScrollPane scrollPane;
    private NxGTable table;

    public StrategyOrder() {
        this.initComponents();
        this.init();
        this.initTable();
        this.StartTimer();
        this.mediator.setStrategyOrder(this);
    }

    public void init() {
        this.setMarkets();
        this.editorMarket = (JTextComponent)this.cbMarkets.getEditor().getEditorComponent();
        this.editorMarket.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                StrategyOrder.this.OnEnter(evt);
            }
        });
        this.setAllScrip();
        this.editorScrip = (JTextComponent)this.cbScrip.getEditor().getEditorComponent();
        this.editorScrip.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StrategyOrder.this.OnEnter(evt);
            }
        });
        this.setAccount();
        this.cbBuy.addItemListener(this);
        this.cbSell.addItemListener(this);
    }

    private void setMarkets() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (StrategyOrder.this.autoCompleteMarket != null && StrategyOrder.this.autoCompleteMarket.isInstalled()) {
                    StrategyOrder.this.autoCompleteMarket.uninstall();
                }
                Vector<String> allMarket = new Vector<String>();
                allMarket.addElement("ALL");
                for (int i = 0; i < LogCommon.markets.length; ++i) {
                    allMarket.addElement(LogCommon.markets[i]);
                }
                Collections.sort(allMarket);
                StrategyOrder.this.cbMarkets.setModel(new DefaultComboBoxModel(allMarket));
                StrategyOrder.this.autoCompleteMarket = AutoCompleteSupport.install((JComboBox)StrategyOrder.this.cbMarkets, (EventList)GlazedLists.eventListOf((Object[])allMarket.toArray()));
                StrategyOrder.this.cbMarkets.setSelectedItem("ALL");
                StrategyOrder.this.autoCompleteMarket.setStrict(true);
            }
        });
    }

    private void setAccount() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (StrategyOrder.this.autoCompleteAccount != null && StrategyOrder.this.autoCompleteAccount.isInstalled()) {
                        StrategyOrder.this.autoCompleteAccount.uninstall();
                    }
                    ArrayList<String> allAccount = new ArrayList<String>();
                    for (String s : LogsTC.accountAll.keySet()) {
                        allAccount.add(s);
                    }
                    Collections.sort(allAccount);
                    allAccount.add(0, "ALL");
                    StrategyOrder.this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(allAccount.toArray()));
                    StrategyOrder.this.autoCompleteAccount = AutoCompleteSupport.install((JComboBox)StrategyOrder.this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])allAccount.toArray()));
                    StrategyOrder.this.cbAccountNo.setSelectedItem("ALL");
                    StrategyOrder.this.editorAccount = (JTextComponent)StrategyOrder.this.cbAccountNo.getEditor().getEditorComponent();
                    StrategyOrder.this.editorAccount.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyReleased(KeyEvent e) {
                            StrategyOrder.this.OnEnter(e);
                        }
                    });
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public void setAllScrip() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (StrategyOrder.this.autoCompleteScrip != null && StrategyOrder.this.autoCompleteScrip.isInstalled()) {
                        StrategyOrder.this.autoCompleteScrip.uninstall();
                    }
                    Vector allScrip = new Vector(LogCommon.SymbolAndSymbolName.keySet());
                    allScrip.addElement("ALL");
                    Collections.sort(allScrip);
                    StrategyOrder.this.cbScrip.setModel(new DefaultComboBoxModel(allScrip));
                    StrategyOrder.this.autoCompleteScrip = AutoCompleteSupport.install((JComboBox)StrategyOrder.this.cbScrip, (EventList)GlazedLists.eventListOf((Object[])allScrip.toArray()));
                    StrategyOrder.this.cbScrip.setSelectedItem("ALL");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private void initTable() {
        this.columns.add("ID");
        this.columns.add("Market");
        this.columns.add("Scrip");
        this.columns.add("Volume");
        this.columns.add("Price");
        this.columns.add("Account");
        this.columns.add("Type");
        this.columns.add("Client Order ID");
        this.columns.add("Cancel Request");
        this.columns.add("Replace Request");
        this.columns.add("Traded Volume");
        this.columns.add("Average Price");
        this.columns.add("Details");
        this.model = new StrategyOrderModel(this.rows, this.columns);
        this.table.setModel((TableModel)this.model);
        this.render = new StrategyOrderRender();
        for (int k = 0; k < this.model.getColumnCount(); ++k) {
            this.table.getColumn((Object)this.model.getColumnName(k)).setCellRenderer((TableCellRenderer)this.render);
        }
        this.table.setColumnControlVisible(false);
        this.table.setSortOrderCycle(new SortOrder[]{SortOrder.ASCENDING});
        this.table.removeColumn(this.table.getColumn((Object)"ID"));
        this.table.removeColumn(this.table.getColumn((Object)"Client Order ID"));
        this.table.removeColumn(this.table.getColumn((Object)"Cancel Request"));
        this.table.removeColumn(this.table.getColumn((Object)"Replace Request"));
        this.tableDataChange(false);
        this.setSorter();
    }

    private void setSorter() {
        JTableHeader tableHeader = this.table.getTableHeader();
        tableHeader.addMouseListener(new ColumnListner(this.table));
        tableHeader.setReorderingAllowed(false);
    }

    private void tableDataChange(final boolean isPackAll) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.model.fireTableDataChanged();
            this.table.addNotify();
            if (isPackAll) {
                this.table.packAll();
            }
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StrategyOrder.this.model.fireTableDataChanged();
                    StrategyOrder.this.table.addNotify();
                    if (isPackAll) {
                        StrategyOrder.this.table.packAll();
                    }
                    StrategyOrder.this.table.repaint();
                }
            });
        }
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.table = new NxGTable();
        this.lblMessage = new JLabel();
        this.btnGet = new JButton();
        this.lblMarket = new JLabel();
        this.cbMarkets = new JComboBox();
        this.jLabel2 = new JLabel();
        this.cbScrip = new JComboBox();
        this.cbSell = new JCheckBox();
        this.cbBuy = new JCheckBox();
        this.cbAccountNo = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.table.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[]{"Status"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StrategyOrder.this.tableMouseClicked(evt);
            }
        });
        this.table.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                StrategyOrder.this.tableMouseMoved(evt);
            }
        });
        this.scrollPane.setViewportView((Component)this.table);
        this.lblMessage.setText(" ");
        this.btnGet.setIcon(new ImageIcon(this.getClass().getResource("/Images/refresh.png")));
        this.btnGet.setText("Refresh");
        this.btnGet.setName("StrategyOrder -> btnGet");
        this.btnGet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StrategyOrder.this.btnGetActionPerformed(evt);
            }
        });
        this.lblMarket.setText("Market");
        this.jLabel2.setText("Scrip");
        this.cbScrip.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbSell.setText("Sell");
        this.cbBuy.setText("Buy");
        this.cbAccountNo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel1.setText("Account");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblMarket, -2, 40, -2).addGap(10, 10, 10).addComponent(this.cbMarkets, -2, 80, -2).addGap(10, 10, 10).addComponent(this.jLabel2, -2, 34, -2).addGap(4, 4, 4).addComponent(this.cbScrip, -2, 78, -2).addGap(10, 10, 10).addComponent(this.jLabel1, -2, 50, -2).addGap(4, 4, 4).addComponent(this.cbAccountNo, -2, 80, -2).addGap(2, 2, 2).addComponent(this.cbBuy, -2, 50, -2).addGap(0, 0, 0).addComponent(this.cbSell).addGap(6, 6, 6).addComponent(this.btnGet, -2, 96, -2)).addComponent(this.scrollPane).addComponent(this.lblMessage, -1, -1, Short.MAX_VALUE)).addGap(10, 10, 10)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMarket, -2, 23, -2).addComponent(this.cbMarkets, -2, 23, -2).addComponent(this.jLabel2, -2, 23, -2).addComponent(this.cbScrip, -2, 23, -2).addComponent(this.jLabel1, -2, 23, -2).addComponent(this.btnGet).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbAccountNo, -2, 23, -2).addComponent(this.cbBuy).addComponent(this.cbSell)))).addGap(5, 5, 5).addComponent(this.scrollPane, -1, 378, Short.MAX_VALUE).addGap(5, 5, 5).addComponent(this.jSeparator1, -2, 3, -2).addGap(2, 2, 2).addComponent(this.lblMessage, -2, 20, -2).addGap(5, 5, 5)));
    }

    private void btnGetActionPerformed(ActionEvent evt) {
        this.rows.clear();
        this.rowsAll.clear();
        this.tableDataChange(false);
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Loading, (String)this.languageCentre.getValue(LanguageConstant.Loading));
    }

    private void tableMouseClicked(MouseEvent evt) {
        int viewRow = this.table.getSelectedRow();
        TableColumnModel colModel = this.table.getColumnModel();
        int vColIndex = colModel.getColumnIndexAtX(evt.getX());
        if ("Details".equalsIgnoreCase(this.table.getColumnName(vColIndex))) {
            StrategyOrderBean sb = this.rows.get(viewRow);
            sb.getClientOrderID();
            StrategyOrderDetailDialog strategyOrderDetailDialog = new StrategyOrderDetailDialog(TradeCast.getInstance().frame, sb);
        }
        if (evt.getClickCount() == 2) {
            int modelRow = this.table.convertRowIndexToModel(viewRow);
            StrategyOrderBean bean = this.rows.get(modelRow);
            if (bean.getType().equalsIgnoreCase("Buy")) {
                this.openWindow(FormName.Buy, bean);
            } else if (bean.getType().equalsIgnoreCase("Sel") || bean.getType().equalsIgnoreCase("Sell")) {
                this.openWindow(FormName.Sell, bean);
            } else {
                MyOptionPane.showMessage(MessageType.Information, "Invalid order type " + bean.getType(), false);
            }
        }
    }

    private void tableMouseMoved(MouseEvent evt) {
        TableColumnModel colModel = this.table.getColumnModel();
        int vColIndex = colModel.getColumnIndexAtX(evt.getX());
        if ("Details".equalsIgnoreCase(this.table.getColumnName(vColIndex))) {
            this.table.setCursor(this.handCursor);
        } else {
            this.table.setCursor(this.defaultCursor);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.cbBuy || source == this.cbSell) {
            this.rowFilter();
        }
    }

    private void OnEnter(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.rowFilter();
        }
    }

    private void rowFilter() {
        this.rows.clear();
        String account = this.getAccount();
        String market = this.getMarket();
        String scrip = this.getScrip();
        String Type2 = "";
        if (this.cbSell.isSelected()) {
            Type2 = "SELL";
        }
        if (this.cbBuy.isSelected()) {
            Type2 = "BUY";
        }
        if (this.cbBuy.isSelected() && this.cbSell.isSelected()) {
            Type2 = "";
        }
        for (StrategyOrderBean b : this.rowsAll) {
            if (!b.getScrip().trim().equalsIgnoreCase(scrip) && scrip.length() > 0 || !b.getMarket().trim().equalsIgnoreCase(market) && market.length() > 0 || !b.getAccount().trim().equalsIgnoreCase(account) && account.length() > 0 || !b.getType().equalsIgnoreCase(Type2) && Type2.length() > 0) continue;
            this.rows.add(b);
        }
        this.tableDataChange(false);
        if (this.model.getRowCount() > 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)(Util.format0digit((String)(this.model.getRowCount() + "".trim().replaceAll("\\,", ""))) + " records found."));
        } else {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)(Util.format0digit((String)(this.model.getRowCount() + "".trim().replaceAll("\\,", ""))) + " record found."));
        }
    }

    private String getAccount() {
        if (this.cbAccountNo.getSelectedItem() == null) {
            return "";
        }
        String a = this.cbAccountNo.getSelectedItem().toString();
        if (a.equalsIgnoreCase("all")) {
            return "";
        }
        return a;
    }

    private String getMarket() {
        if (this.cbMarkets.getSelectedItem() == null) {
            return "";
        }
        String a = this.cbMarkets.getSelectedItem().toString();
        if (a.equalsIgnoreCase("all")) {
            return "";
        }
        return a;
    }

    private String getScrip() {
        if (this.cbScrip.getSelectedItem() == null) {
            return "";
        }
        String a = this.cbScrip.getSelectedItem().toString();
        if (a.equalsIgnoreCase("all")) {
            return "";
        }
        return a;
    }

    public void openWindow(FormName formName, StrategyOrderBean bean) {
        LogsKSE.SelectedMarket = bean.getMarket();
        LogsKSE.SelectedSymbol = bean.getScrip();
        if (formName == FormName.Buy) {
            TradeCast.getInstance().ShowDynamicForm(FormName.Buy, LanguageConstant.Buy);
            if (this.mediator.buysell != null) {
                this.mediator.buysell.initBuySell(LanguageConstant.Buy, LogCommon.UserID, bean.getMarket().trim(), bean.getScrip().trim(), FormName.Buy, "");
                this.mediator.buysell.setOtherInfor(bean.getClientOrderID(), bean.getVolume(), bean.getPrice(), bean.getAccount());
            }
        } else if (formName == FormName.Sell) {
            TradeCast.getInstance().ShowDynamicForm(FormName.Sell, LanguageConstant.Sell);
            if (this.mediator.buysell != null) {
                this.mediator.buysell.initBuySell(LanguageConstant.Sell, LogCommon.UserID, bean.getMarket().trim(), bean.getScrip().trim(), FormName.Sell, "");
                this.mediator.buysell.setOtherInfor(bean.getClientOrderID(), bean.getVolume(), bean.getPrice(), bean.getAccount());
            }
        }
    }

    private synchronized void fillTable(String result) {
        this.rows.clear();
        this.rowsAll.clear();
        if (result.trim().indexOf("|") > 0) {
            String[] allRows = result.split("\\|", -1);
            for (int i = 0; i < allRows.length - 1; ++i) {
                String singleRow = allRows[i];
                StrategyOrderBean bean = StrategyOrderBean.parse((String)singleRow);
                this.rowsAll.add(bean);
            }
        }
        this.rowFilter();
        this.tableDataChange(true);
    }

    public synchronized void getDataFromWebService() {
        new Thread((Runnable)new StrategyOrderThread(), "Strategy Order -> getDataFromWebService").start();
    }

    private void StartTimer() {
        this.timer2 = new Timer();
        this.timer2.schedule((TimerTask)new RemindTask(), 0L, 1000L);
    }

    public void StopTimer() {
        if (this.timer2 != null) {
            this.timer2.cancel();
        }
    }

    private class ColumnListner
    extends MouseAdapter {
        private final NxGTable table;
        protected int sortCol = 0;
        protected boolean isSortAsc = true;
        private TableColumnModel colModel;

        public ColumnListner(NxGTable table) {
            this.table = table;
            this.colModel = table.getColumnModel();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            final MouseEvent evt2 = e;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (StrategyOrder.this.rows.size() > 1) {
                        ColumnListner.this.sortTable(evt2);
                    }
                }
            }, "Strategy Order sort Table").start();
        }

        private void sortTable(MouseEvent e) {
            try {
                String oldMessage = StrategyOrder.this.lblMessage.getText();
                Util.setMessage((JLabel)StrategyOrder.this.lblMessage, (MessageType)MessageType.Loading, (String)"Please wait while sorting...");
                int columnModelIndex = this.colModel.getColumnIndexAtX(e.getX());
                int modelIndex = this.colModel.getColumn(columnModelIndex).getModelIndex();
                if (modelIndex < 0) {
                    return;
                }
                if (this.sortCol == modelIndex) {
                    this.isSortAsc = !this.isSortAsc;
                } else {
                    this.sortCol = modelIndex;
                }
                Collections.sort(StrategyOrder.this.rows, new StrategyOrderComparator(this.sortCol, this.isSortAsc));
                StrategyOrder.this.tableDataChange(false);
                Util.setMessage((JLabel)StrategyOrder.this.lblMessage, (MessageType)MessageType.Normal, (String)oldMessage);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private class RemindTask
    extends SwingTimerTask {
        private RemindTask() {
        }

        @Override
        public void doRun() {
            StrategyOrder.this.getDataFromWebService();
        }
    }

    private class StrategyOrderComparator
    implements Comparator<StrategyOrderBean> {
        int colIndex = 0;
        boolean isAsc = true;

        public StrategyOrderComparator(int colIndex, boolean isAsc) {
            this.colIndex = colIndex;
            this.isAsc = isAsc;
        }

        @Override
        public int compare(StrategyOrderBean b1, StrategyOrderBean b2) {
            int result = 0;
            switch (this.colIndex) {
                case 6: {
                    result = b1.getAccount().compareTo(b2.getAccount());
                    break;
                }
                case 1: {
                    result = b1.getMarket().compareTo(b2.getMarket());
                    break;
                }
                case 4: {
                    result = b1.getPrice() < b2.getPrice() ? -1 : (b1.getPrice() > b2.getPrice() ? 1 : 0);
                    break;
                }
                case 2: {
                    result = b1.getScrip().compareTo(b2.getScrip());
                    break;
                }
                case 5: {
                    result = b1.getType().compareTo(b2.getType());
                    break;
                }
                case 3: {
                    int n = b1.getVolume() < b2.getVolume() ? -1 : (result = b1.getVolume() > b2.getVolume() ? 1 : 0);
                }
            }
            if (!this.isAsc) {
                result = -result;
            }
            return result;
        }
    }

    private class StrategyOrderThread
    implements Runnable {
        private StrategyOrderThread() {
        }

        @Override
        public void run() {
            String result = "";
            try {
                Util.setMessage((JLabel)StrategyOrder.this.lblMessage, (MessageType)MessageType.Loading, (String)StrategyOrder.this.languageCentre.getValue(LanguageConstant.Loading));
                String accountNo = "";
                String scrip = "";
                LoginServer port = WebService.getInstance().getPort();
                byte[] data = port.getCompressedData(LogCommon.UserID, "StrategyOrder=", accountNo);
                result = CompressManager.unzipStringFromBytes(data);
                if (result.trim().length() > 0) {
                    StrategyOrder.this.fillTable(result);
                } else {
                    Util.setMessage((JLabel)StrategyOrder.this.lblMessage, (MessageType)MessageType.Normal, (String)"No record found");
                }
            }
            catch (Exception ex) {
                Util.setMessage((JLabel)StrategyOrder.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in Loading");
                ex.printStackTrace();
                Mediator.getInstance().PrintLog(ex, result);
            }
        }
    }

    private abstract class SwingTimerTask
    extends TimerTask {
        private SwingTimerTask() {
        }

        public abstract void doRun();

        @Override
        public void run() {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(this);
            } else {
                this.doRun();
            }
        }
    }
}

