/*
 * Decompiled with CFR 0.152.
 */
package Orders;

import MyDocking.Mediator;
import Utilities.CompressManager;
import common.gui.component.NxGDialogBox;
import common.gui.component.NxGTable;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kse.gui.bean.StrategyOrderBean;
import kse.gui.bean.StrategyOrderDetailsBean;
import kse.gui.model.StrategyOrderDetailsModel;
import kse.gui.render.StrategyOrderDetailsRender;
import languages.LanguageCentre;
import languages.LanguageConstant;
import login.LoginServer;

public class StrategyOrderDetailDialog
extends NxGDialogBox {
    private Vector<String> columns = new Vector();
    private Vector<StrategyOrderDetailsBean> rows = new Vector();
    private StrategyOrderDetailsModel model;
    private StrategyOrderDetailsRender render;
    private LanguageCentre languageCentre = new LanguageCentre();
    private StrategyOrderBean bean;
    private JButton btnClose;
    private JButton btnRefresh;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JSeparator jSeparator1;
    private JLabel lblMessage;
    private JScrollPane scrollPane;
    private NxGTable table;
    private JTextField txtAccount;
    private JTextField txtAveragePrice;
    private JTextField txtMarket;
    private JTextField txtPrice;
    private JTextField txtScrip;
    private JTextField txtTotalVolume;
    private JTextField txtTradeVolume;
    private JTextField txtType;

    public StrategyOrderDetailDialog(Frame parent, StrategyOrderBean bean) {
        super(parent, true);
        try {
            this.bean = bean;
            this.initComponents();
            this.setTitle("Strategy Order Details");
            this.initTable();
            this.setValues(bean);
            this.setFocus();
            this.setBounds(0, 0, 595, 440);
            this.setLocationRelativeTo(parent);
            this.getData(bean);
            this.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initTable() {
        this.columns.add("Market");
        this.columns.add("Scrip");
        this.columns.add("Volume");
        this.columns.add("Price");
        this.columns.add("Account");
        this.columns.add("Type");
        this.columns.add("Client Order No");
        this.columns.add("Order No");
        this.columns.add("Time");
        this.model = new StrategyOrderDetailsModel(this.rows, this.columns);
        this.table.setModel((TableModel)this.model);
        this.render = new StrategyOrderDetailsRender();
        for (int k = 0; k < this.model.getColumnCount(); ++k) {
            this.table.getColumn((Object)this.model.getColumnName(k)).setCellRenderer((TableCellRenderer)this.render);
        }
        this.table.setColumnControlVisible(false);
        this.table.setSortOrderCycle(new SortOrder[]{SortOrder.ASCENDING});
        ((JLabel)((Object)this.table.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(0);
        this.table.setRowHeight(18);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setColumnControlVisible(false);
        this.table.removeColumn(this.table.getColumn((Object)"Market"));
        this.table.removeColumn(this.table.getColumn((Object)"Scrip"));
        this.tableDataChange(false);
    }

    private void tableDataChange(final boolean isPackAll) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.model.fireTableDataChanged();
            this.table.addNotify();
            if (isPackAll) {
                this.table.packAll();
            }
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StrategyOrderDetailDialog.this.model.fireTableDataChanged();
                    StrategyOrderDetailDialog.this.table.addNotify();
                    if (isPackAll) {
                        StrategyOrderDetailDialog.this.table.packAll();
                    }
                    StrategyOrderDetailDialog.this.table.repaint();
                }
            });
        }
    }

    private void setFocus() {
        new Thread("Strategy Order Detail Dialog"){

            @Override
            public void run() {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                StrategyOrderDetailDialog.this.btnRefresh.requestFocus();
            }
        }.start();
    }

    private void initComponents() {
        this.btnRefresh = new JButton();
        this.btnClose = new JButton();
        this.jSeparator1 = new JSeparator();
        this.lblMessage = new JLabel();
        this.scrollPane = new JScrollPane();
        this.table = new NxGTable();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.txtScrip = new JTextField();
        this.txtMarket = new JTextField();
        this.txtPrice = new JTextField();
        this.txtTotalVolume = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.txtAveragePrice = new JTextField();
        this.txtTradeVolume = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.txtAccount = new JTextField();
        this.jLabel8 = new JLabel();
        this.txtType = new JTextField();
        this.jLabel9 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.btnRefresh.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/refresh.png")));
        this.btnRefresh.setText("Refresh");
        this.btnRefresh.setName("StrategyOrderDetailDialog -> btnRefresh");
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StrategyOrderDetailDialog.this.btnRefreshActionPerformed(evt);
            }
        });
        this.btnClose.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/close.png")));
        this.btnClose.setText("Close");
        this.btnClose.setName("StrategyOrderDetailDialog -> btnClose");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StrategyOrderDetailDialog.this.btnCloseActionPerformed(evt);
            }
        });
        this.lblMessage.setHorizontalAlignment(2);
        this.lblMessage.setText(" ");
        this.table.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[]{"Status", "Market", "Scrip", "Order Type", "Volume", "Price", "Time"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false, false, false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.scrollPane.setViewportView((Component)this.table);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(6).setPreferredWidth(130);
        this.jLabel2.setText("Market");
        this.jLabel3.setText("Scrip");
        this.txtScrip.setEditable(false);
        this.txtMarket.setEditable(false);
        this.txtPrice.setEditable(false);
        this.txtPrice.setHorizontalAlignment(4);
        this.txtTotalVolume.setEditable(false);
        this.txtTotalVolume.setHorizontalAlignment(4);
        this.jLabel4.setText("Total Volume");
        this.jLabel5.setText("Price");
        this.txtAveragePrice.setEditable(false);
        this.txtAveragePrice.setHorizontalAlignment(4);
        this.txtTradeVolume.setEditable(false);
        this.txtTradeVolume.setHorizontalAlignment(4);
        this.jLabel6.setText("Traded Volume");
        this.jLabel7.setText("Average Price");
        this.txtAccount.setEditable(false);
        this.jLabel8.setText("Account");
        this.txtType.setEditable(false);
        this.jLabel9.setText("Type");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 40, -2).addGap(0, 0, 0).addComponent(this.txtMarket, -2, 70, -2).addGap(10, 10, 10).addComponent(this.jLabel8, -2, 50, -2).addGap(0, 0, 0).addComponent(this.txtAccount, -2, 70, -2).addGap(10, 10, 10).addComponent(this.jLabel4, -2, 80, -2).addGap(0, 0, 0).addComponent(this.txtTotalVolume, -2, 70, -2).addGap(10, 10, 10).addComponent(this.jLabel5, -2, 80, -2).addGap(0, 0, 0).addComponent(this.txtPrice, -2, 70, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 40, -2).addGap(0, 0, 0).addComponent(this.txtScrip, -2, 70, -2).addGap(10, 10, 10).addComponent(this.jLabel9, -2, 50, -2).addGap(0, 0, 0).addComponent(this.txtType, -2, 70, -2).addGap(10, 10, 10).addComponent(this.jLabel6, -2, 80, -2).addGap(0, 0, 0).addComponent(this.txtTradeVolume, -2, 70, -2).addGap(10, 10, 10).addComponent(this.jLabel7, -2, 80, -2).addGap(0, 0, 0).addComponent(this.txtAveragePrice, -2, 70, -2)).addComponent(this.scrollPane).addGroup(layout.createSequentialGroup().addComponent(this.lblMessage, -1, -1, Short.MAX_VALUE).addGap(20, 20, 20).addComponent(this.btnRefresh, -2, 100, -2).addGap(10, 10, 10).addComponent(this.btnClose, -2, 100, -2))).addGap(10, 10, 10)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -2, 20, -2).addComponent(this.txtMarket, -2, -1, -2).addComponent(this.jLabel8, -2, 20, -2).addComponent(this.txtAccount, -2, -1, -2).addComponent(this.jLabel4, -2, 20, -2).addComponent(this.txtTotalVolume, -2, -1, -2).addComponent(this.jLabel5, -2, 20, -2).addComponent(this.txtPrice, -2, -1, -2)).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -2, 20, -2).addComponent(this.txtScrip, -2, -1, -2).addComponent(this.jLabel9, -2, 20, -2).addComponent(this.txtType, -2, -1, -2).addComponent(this.jLabel6, -2, 20, -2).addComponent(this.txtTradeVolume, -2, -1, -2).addComponent(this.jLabel7, -2, 20, -2).addComponent(this.txtAveragePrice, -2, -1, -2)).addGap(5, 5, 5).addComponent(this.scrollPane, -1, 380, Short.MAX_VALUE).addGap(5, 5, 5).addComponent(this.jSeparator1, -2, 3, -2).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnRefresh).addComponent(this.lblMessage, -2, 20, -2)).addComponent(this.btnClose, -2, 25, -2)).addGap(5, 5, 5)));
        this.pack();
    }

    private void btnRefreshActionPerformed(ActionEvent evt) {
        this.getData(this.bean);
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void getData(StrategyOrderBean bean) {
        Mediator.getInstance().println("get data  = ");
        new Thread((Runnable)new StrategyOrderDetailsThread(), "Strategy Order Details Thread").start();
    }

    private void setValues(StrategyOrderBean bean) {
        this.txtMarket.setText(bean.getMarket());
        this.txtScrip.setText(bean.getScrip());
        this.txtAccount.setText(bean.getAccount());
        this.txtType.setText(bean.getType());
        this.txtTotalVolume.setText(Util.format0digit((String)(bean.getVolume() + "")));
        this.txtTradeVolume.setText(Util.format0digit((String)(bean.getTradedVolume() + "")));
        this.txtPrice.setText(Util.format2digit((String)(bean.getPrice() + "")));
        this.txtAveragePrice.setText(Util.format2digit((String)(bean.getAveragePrice() + "")));
    }

    private synchronized void fillTable(String result) {
        this.rows.clear();
        if (result.trim().indexOf("|") > 0) {
            String[] allRows = result.split("\\|", -1);
            for (int i = 0; i < allRows.length - 1; ++i) {
                String singleRow = allRows[i];
                StrategyOrderDetailsBean bean = StrategyOrderDetailsBean.parse((String)singleRow);
                this.rows.add(bean);
            }
        }
        this.tableDataChange(true);
        if (this.model.getRowCount() > 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)(Util.format0digit((String)(this.model.getRowCount() + "".trim().replaceAll("\\,", ""))) + " records found."));
        } else {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)(Util.format0digit((String)(this.model.getRowCount() + "".trim().replaceAll("\\,", ""))) + " record found."));
        }
    }

    private class StrategyOrderDetailsThread
    implements Runnable {
        private StrategyOrderDetailsThread() {
        }

        @Override
        public void run() {
            String result = "";
            try {
                Util.setMessage((JLabel)StrategyOrderDetailDialog.this.lblMessage, (MessageType)MessageType.Loading, (String)StrategyOrderDetailDialog.this.languageCentre.getValue(LanguageConstant.Loading));
                LoginServer port = WebService.getInstance().getPort();
                byte[] data = port.getCompressedData(LogCommon.UserID, "StrategyOrderDetails=", StrategyOrderDetailDialog.this.bean.getClientOrderID());
                result = CompressManager.unzipStringFromBytes(data);
                if (result.trim().length() > 0) {
                    StrategyOrderDetailDialog.this.fillTable(result);
                } else {
                    Util.setMessage((JLabel)StrategyOrderDetailDialog.this.lblMessage, (MessageType)MessageType.Normal, (String)"No record found");
                }
            }
            catch (Exception ex) {
                Util.setMessage((JLabel)StrategyOrderDetailDialog.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in Loading");
                ex.printStackTrace();
                Mediator.getInstance().PrintLog(ex, result);
            }
        }
    }
}

