/*
 * Decompiled with CFR 0.152.
 */
package Orders;

import Beans.OrderBean;
import CATALYST.Control.MarketFeed;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Orders.PriceOutOfRange;
import Orders.TradeOption;
import Utilities.LogsTC;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.util.LogCommon;
import common.gui.util.MyColors;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import kse.util.LogsKSE;

public class Trade
extends JPanel
implements FocusListener {
    Thread timeThread = null;
    public static SpinnerNumberModel volumeModel;
    public static SpinnerNumberModel priceModel;
    private String market = "";
    private String Scrip = "";
    String icats = "";
    public static String pin;
    public static boolean serviceCalled;
    Mediator mediator = Mediator.getInstance();
    private JButton btnBuy;
    private JButton btnSell;
    public JComboBox cbAccountNo;
    private JCheckBox cbSavePin;
    private JSeparator jSeparator1;
    private JLabel lblAccount;
    private JLabel lblError;
    private JLabel lblPin;
    private JLabel lblPrice;
    private JLabel lblSettings;
    private JLabel lblSymbol;
    private JLabel lblVolume;
    private JSpinner spPrice;
    public JSpinner spVolume;
    public JPasswordField txtPinCode;
    Timer runable = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Trade.this.spVolume.setModel(volumeModel);
            JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)Trade.this.spVolume.getEditor();
            editor.getTextField().requestFocus();
            Trade.this.runable.stop();
        }
    });

    public Trade() {
        this.initComponents();
        this.mediator.setTrade(this);
        this.SetAccounts();
        this.lblError.setText(" ");
        this.lblSettings.setText("<html><b>Settings</b></html>");
        ((JSpinner.DefaultEditor)this.spVolume.getEditor()).getTextField().setFocusTraversalKeys(0, Collections.EMPTY_SET);
        ((JSpinner.DefaultEditor)this.spVolume.getEditor()).getTextField().addFocusListener(this);
        ((JSpinner.DefaultEditor)this.spPrice.getEditor()).getTextField().setFocusTraversalKeys(0, Collections.EMPTY_SET);
        ((JSpinner.DefaultEditor)this.spPrice.getEditor()).getTextField().addFocusListener(this);
        this.setDefaultsValues(LogCommon.TradeOption);
        this.update(LogsKSE.SelectedSymbol, LogsKSE.SelectedMarket);
        this.btnSell.setCursor(Cursor.getPredefinedCursor(12));
        this.btnBuy.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void getFocus() {
        ((JSpinner.DefaultEditor)this.spVolume.getEditor()).getTextField().requestFocus();
    }

    public void setErrorResult() {
        this.lblError.setText("Error in gettting Default Settings");
    }

    public void update(String symbol, String market) {
        this.Scrip = symbol;
        this.market = market;
        String Title2 = "()";
        if (LogCommon.SymbolAndSymbolName.containsKey(symbol)) {
            Title2 = " (" + ((String)LogCommon.SymbolAndSymbolName.get(symbol)).toString() + ")";
        }
        this.lblSymbol.setText(" " + symbol + "-" + market + Title2);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Trade.class.getName()).log(Level.SEVERE, null, ex);
        }
        MarketFeed mktFeed = this.mediator.MwPanel.GetSingleFeed(symbol, market);
        if (mktFeed != null) {
            try {
                this.spPrice.setValue(Double.parseDouble(mktFeed.lTrdPrice));
                Double value1 = new Double(Double.parseDouble(mktFeed.lTrdPrice));
                Double min1 = new Double(0.0);
                Double max1 = new Double(9999999.0);
                Double step1 = new Double(0.1);
                priceModel = new SpinnerNumberModel(value1, min1, max1, step1);
                this.spPrice.setModel(priceModel);
            }
            catch (NumberFormatException ex) {
                Double value1 = new Double(0.0);
                Double min1 = new Double(0.0);
                Double max1 = new Double(9999999.0);
                Double step1 = new Double(0.1);
                priceModel = new SpinnerNumberModel(value1, min1, max1, step1);
                this.spPrice.setModel(priceModel);
            }
        } else {
            Double value1 = new Double(0.0);
            Double min1 = new Double(0.0);
            Double max1 = new Double(9999999.0);
            Double step1 = new Double(0.1);
            priceModel = new SpinnerNumberModel(value1, min1, max1, step1);
            this.spPrice.setModel(priceModel);
        }
    }

    public void setValues() {
    }

    public void SetAccounts() {
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(LogsTC.accountAll.keySet().toArray()));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])LogsTC.accountAll.keySet().toArray()));
        if (LogCommon.preferredAccount.equalsIgnoreCase("")) {
            this.cbAccountNo.setSelectedItem("");
        } else {
            this.cbAccountNo.setSelectedItem(LogCommon.preferredAccount);
        }
        this.cbAccountNo.requestFocus();
        if (LogCommon.pinCode.length() > 0) {
            this.txtPinCode.setText(LogCommon.pinCode);
            this.cbSavePin.setSelected(true);
        } else {
            this.txtPinCode.setText("");
            this.cbSavePin.setSelected(false);
        }
    }

    public void setDefaultsValues(String result) {
        if (result.indexOf(";") > 0) {
            LogCommon.TradeOption = result;
        }
        if (LogCommon.TradeOption.indexOf(";") > 0) {
            String[] val = LogCommon.TradeOption.split("\\;", -1);
            Double value = new Double(Double.parseDouble(val[0]));
            Double min = new Double(1.0);
            Double max = new Double(999999.0);
            Double step = new Double(Double.parseDouble(val[1]));
            volumeModel = new SpinnerNumberModel(value, min, max, step);
            this.spVolume.setModel(volumeModel);
        } else {
            Double value = new Double(1000.0);
            Double min = new Double(1.0);
            Double max = new Double(999999.0);
            Double step = new Double(100.0);
            volumeModel = new SpinnerNumberModel(value, min, max, step);
            this.spVolume.setModel(volumeModel);
        }
        Double value1 = new Double(1.0);
        Double min1 = new Double(1.0);
        Double max1 = new Double(9999999.0);
        Double step1 = new Double(0.1);
        priceModel = new SpinnerNumberModel(value1, min1, max1, step1);
        this.spPrice.setModel(priceModel);
    }

    public void setAccountWebSer() {
    }

    public void MessageSent(boolean success) {
        if (success) {
            this.spVolume.setValue(0);
            this.spPrice.setValue(0);
            ((JSpinner.DefaultEditor)this.spVolume.getEditor()).getTextField().requestFocus();
        }
    }

    private void initComponents() {
        this.lblSymbol = new JLabel();
        this.lblError = new JLabel();
        this.cbSavePin = new JCheckBox();
        this.btnBuy = new JButton();
        this.btnSell = new JButton();
        this.lblVolume = new JLabel();
        this.lblPrice = new JLabel();
        this.spVolume = new JSpinner();
        this.spPrice = new JSpinner();
        this.lblAccount = new JLabel();
        this.cbAccountNo = new JComboBox();
        this.lblPin = new JLabel();
        this.txtPinCode = new JPasswordField();
        this.jSeparator1 = new JSeparator();
        this.lblSettings = new JLabel();
        this.setLayout(null);
        this.lblSymbol.setFont(new Font("Tahoma", 1, 11));
        this.lblSymbol.setText("Symbol");
        this.lblSymbol.setName("lblSymbol");
        this.add(this.lblSymbol);
        this.lblSymbol.setBounds(10, 10, 350, 14);
        this.lblError.setText(" ");
        this.lblError.setName("lblError");
        this.add(this.lblError);
        this.lblError.setBounds(10, 117, 340, 14);
        this.cbSavePin.setText("Save Pin");
        this.cbSavePin.setName("cbSavePin");
        this.cbSavePin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Trade.this.cbSavePinActionPerformed(evt);
            }
        });
        this.add(this.cbSavePin);
        this.cbSavePin.setBounds(100, 80, 67, 23);
        this.btnBuy.setIcon(new ImageIcon(this.getClass().getResource("/Images/Buy.jpg")));
        this.btnBuy.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.btnBuy.setName("Trade -> btnBuy");
        this.btnBuy.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Trade.this.btnBuyMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                Trade.this.btnBuyMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                Trade.this.btnBuyMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                Trade.this.btnBuyMousePressed(evt);
            }
        });
        this.btnBuy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Trade.this.btnBuyActionPerformed(evt);
            }
        });
        this.add(this.btnBuy);
        this.btnBuy.setBounds(190, 80, 85, 20);
        this.btnSell.setIcon(new ImageIcon(this.getClass().getResource("/Images/Sell.jpg")));
        this.btnSell.setName("Trade -> btnSell");
        this.btnSell.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Trade.this.btnSellMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                Trade.this.btnSellMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                Trade.this.btnSellMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                Trade.this.btnSellMousePressed(evt);
            }
        });
        this.btnSell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Trade.this.btnSellActionPerformed(evt);
            }
        });
        this.add(this.btnSell);
        this.btnSell.setBounds(280, 80, 85, 20);
        this.lblVolume.setText(" Volume");
        this.lblVolume.setName("lblVolume");
        this.add(this.lblVolume);
        this.lblVolume.setBounds(10, 30, 80, 14);
        this.lblPrice.setText(" Price");
        this.lblPrice.setName("lblPrice");
        this.add(this.lblPrice);
        this.lblPrice.setBounds(100, 30, 60, 14);
        this.spVolume.setMaximumSize(new Dimension(85, Short.MAX_VALUE));
        this.spVolume.setMinimumSize(new Dimension(85, 20));
        this.spVolume.setName("spVolume");
        this.spVolume.setPreferredSize(new Dimension(85, 20));
        this.add(this.spVolume);
        this.spVolume.setBounds(10, 50, 85, 20);
        this.spPrice.setName("spPrice");
        this.add(this.spPrice);
        this.spPrice.setBounds(100, 50, 85, 20);
        this.lblAccount.setText(" Account");
        this.lblAccount.setName("lblAccount");
        this.add(this.lblAccount);
        this.lblAccount.setBounds(190, 30, 60, 14);
        this.cbAccountNo.setName("cbAccountNo");
        this.add(this.cbAccountNo);
        this.cbAccountNo.setBounds(190, 50, 85, 20);
        this.lblPin.setText("PIN");
        this.lblPin.setName("lblPin");
        this.add(this.lblPin);
        this.lblPin.setBounds(281, 30, 60, 14);
        this.txtPinCode.setName("txtPinCode");
        this.txtPinCode.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                Trade.this.txtPinCodeKeyPressed(evt);
            }
        });
        this.add(this.txtPinCode);
        this.txtPinCode.setBounds(280, 50, 85, 20);
        this.jSeparator1.setName("jSeparator1");
        this.add(this.jSeparator1);
        this.jSeparator1.setBounds(0, 110, 380, 2);
        this.lblSettings.setFont(new Font("Tahoma", 1, 11));
        this.lblSettings.setIcon(new ImageIcon(this.getClass().getResource("/Images/option.png")));
        this.lblSettings.setText("Settings");
        this.lblSettings.setName("lblSettings");
        this.lblSettings.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                Trade.this.lblSettingsMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                Trade.this.lblSettingsMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                Trade.this.lblSettingsMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                Trade.this.lblSettingsMouseReleased(evt);
            }
        });
        this.add(this.lblSettings);
        this.lblSettings.setBounds(10, 80, 70, 20);
    }

    private void cbSavePinActionPerformed(ActionEvent evt) {
        LogCommon.pinCode = this.cbSavePin.isSelected() ? this.txtPinCode.getText() : "";
    }

    private void btnBuyMouseClicked(MouseEvent evt) {
        this.btnBuy.setIcon(new ImageIcon(this.getClass().getResource("/Images/Buy-pressed.jpg")));
    }

    private void btnBuyMouseEntered(MouseEvent evt) {
        this.btnBuy.setIcon(new ImageIcon(this.getClass().getResource("/Images/Buy-Over1.jpg")));
    }

    private void btnBuyMouseExited(MouseEvent evt) {
        this.btnBuy.setIcon(new ImageIcon(this.getClass().getResource("/Images/Buy.jpg")));
    }

    private void btnBuyMousePressed(MouseEvent evt) {
        this.btnBuy.setIcon(new ImageIcon(this.getClass().getResource("/Images/Buy-pressed.jpg")));
    }

    private void btnBuyActionPerformed(ActionEvent evt) {
        if (this.cbAccountNo.getSelectedItem() == null) {
            this.lblError.setText("Please enter Account");
            this.lblError.setForeground(MyColors.errorMessageFG);
            this.cbAccountNo.requestFocus();
            return;
        }
        if (this.cbAccountNo.getSelectedItem().toString().length() < 1) {
            this.lblError.setText("Please enter Account");
            this.lblError.setForeground(MyColors.errorMessageFG);
            this.cbAccountNo.requestFocus();
            return;
        }
        if (this.txtPinCode.getText().length() < 1) {
            this.lblError.setText("Please enter PIN");
            this.lblError.setForeground(MyColors.errorMessageFG);
            this.txtPinCode.requestFocus();
            return;
        }
        if (!this.IsPriceInRange()) {
            return;
        }
        this.lblError.setText(" ");
        this.lblError.setForeground(Color.BLACK);
        int volume = 0;
        try {
            volume = (int)Double.parseDouble(this.spVolume.getValue().toString().trim());
            volume = Math.abs(volume);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        boolean result = false;
        OrderBean bean = new OrderBean();
        bean.setOrderTransactionType("BUY");
        bean.setScrip(this.Scrip);
        bean.setMarket(this.market);
        bean.setPrice(this.spPrice.getValue().toString());
        bean.setVolume(volume);
        bean.setAccount(this.cbAccountNo.getSelectedItem().toString());
        bean.setPIN(this.txtPinCode.getText());
        result = LogsKSE.MarketStauts.equalsIgnoreCase("OHO") || LogsKSE.MarketStauts.equalsIgnoreCase("OHP") ? this.mediator.SendOrder(bean) : this.mediator.SendOrder(bean);
        this.MessageSent(result);
    }

    private void btnSellMouseClicked(MouseEvent evt) {
        this.btnSell.setIcon(new ImageIcon(this.getClass().getResource("/Images/Sell-pressed.jpg")));
    }

    private void btnSellMouseEntered(MouseEvent evt) {
        this.btnSell.setIcon(new ImageIcon(this.getClass().getResource("/Images/Sell-Over1.jpg")));
    }

    private void btnSellMouseExited(MouseEvent evt) {
        this.btnSell.setIcon(new ImageIcon(this.getClass().getResource("/Images/Sell.jpg")));
    }

    private void btnSellMousePressed(MouseEvent evt) {
        this.btnSell.setIcon(new ImageIcon(this.getClass().getResource("/Images/Sell.jpg")));
    }

    private void btnSellActionPerformed(ActionEvent evt) {
        if (this.cbAccountNo.getSelectedItem().toString().length() < 1) {
            this.lblError.setText("Please Select Account");
            this.lblError.setForeground(MyColors.errorMessageFG);
            this.cbAccountNo.requestFocus();
            return;
        }
        if (this.txtPinCode.getText().length() < 1) {
            this.lblError.setText("Please enter PIN");
            this.lblError.setForeground(MyColors.errorMessageFG);
            this.txtPinCode.requestFocus();
            return;
        }
        if (!this.IsPriceInRange()) {
            return;
        }
        this.lblError.setText(" ");
        this.lblError.setForeground(Color.BLACK);
        int volume = 0;
        try {
            volume = (int)Double.parseDouble(this.spVolume.getValue().toString().trim());
            volume = Math.abs(volume);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        boolean result = false;
        OrderBean bean = new OrderBean();
        bean.setOrderTransactionType("SEL");
        bean.setScrip(this.Scrip);
        bean.setMarket(this.market);
        bean.setPrice(this.spPrice.getValue().toString());
        bean.setVolume(volume);
        bean.setAccount(this.cbAccountNo.getSelectedItem().toString());
        bean.setPIN(this.txtPinCode.getText());
        result = LogsKSE.MarketStauts.equalsIgnoreCase("OHO") || LogsKSE.MarketStauts.equalsIgnoreCase("OHP") ? this.mediator.SendOrder(bean) : this.mediator.SendOrder(bean);
        this.MessageSent(result);
    }

    private void txtPinCodeKeyPressed(KeyEvent evt) {
        if (10 == evt.getKeyCode()) {
            this.btnBuy.requestFocus();
        }
    }

    private void lblSettingsMouseExited(MouseEvent evt) {
        this.lblSettings.setCursor(Cursor.getPredefinedCursor(0));
        this.lblSettings.setText("<html><b>Settings</b></html>");
    }

    private void lblSettingsMouseEntered(MouseEvent evt) {
        this.lblSettings.setCursor(Cursor.getPredefinedCursor(12));
        this.lblSettings.setText("<html><u><b>Settings</b></u></html>");
    }

    private void lblSettingsMousePressed(MouseEvent evt) {
        new TradeOption((Frame)TradeCast.getInstance().frame, true, evt, this);
    }

    private void lblSettingsMouseReleased(MouseEvent evt) {
        this.lblSettings.setText("<html><u><b>Settings</b></u></html>");
    }

    @Override
    public void focusGained(FocusEvent evt) {
        JFormattedTextField textField;
        Object source = evt.getSource();
        if (source == ((JSpinner.DefaultEditor)this.spPrice.getEditor()).getTextField()) {
            textField = (JFormattedTextField)evt.getComponent();
            textField.setText(textField.getText());
            textField.selectAll();
        }
        if (source == ((JSpinner.DefaultEditor)this.spVolume.getEditor()).getTextField()) {
            textField = (JFormattedTextField)evt.getComponent();
            textField.setText(textField.getText());
            textField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public boolean IsPriceInRange() {
        boolean Ret = true;
        if (!LogsKSE.CheckPriceLimit) {
            return Ret;
        }
        double uppercap = 0.0;
        double lowerlock = 0.0;
        try {
            double Price;
            String cps = this.mediator.logsCommon.getCaps(this.Scrip, this.market);
            if (cps.length() > 0) {
                uppercap = Double.parseDouble(cps.split(":")[0]);
                lowerlock = Double.parseDouble(cps.split(":")[1]);
            }
            if (uppercap > 0.0 && lowerlock > 0.0 && ((Price = Double.parseDouble(this.spPrice.getValue().toString())) > uppercap || Price < lowerlock)) {
                PriceOutOfRange pricerange = new PriceOutOfRange(TradeCast.getInstance().frame, true, this.Scrip, Price + "", uppercap + "", lowerlock + "");
                Ret = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Ret;
    }

    static {
        pin = "";
        serviceCalled = false;
    }
}

