/*
 * Decompiled with CFR 0.152.
 */
package RendersNModels;

import CustomComponent.NxGLabelGradeint;
import CustomComponent.NxGTableCellRender;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;

public class AccStatementCellRenderer
extends NxGTableCellRender {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
        NxGLabelGradeint cell = new NxGLabelGradeint();
        String stCol = table.getColumnModel().getColumn(column).getIdentifier().toString();
        cell.setForeground(MyColors.cellRenderFG);
        cell.setVerticalAlignment(0);
        if (obj == null) {
            obj = "";
        }
        if (obj.toString().equalsIgnoreCase("Null")) {
            obj = "";
        }
        if ("Voucher No".equalsIgnoreCase(stCol)) {
            cell.setHorizontalAlignment(2);
            cell.setText(" " + Util.format0digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
        } else if ("Cheque No".equalsIgnoreCase(stCol)) {
            cell.setHorizontalAlignment(2);
            cell.setText(" " + obj.toString().trim().replaceAll("\\,", "") + " ");
        } else if ("Date".equalsIgnoreCase(stCol)) {
            cell.setHorizontalAlignment(2);
            cell.setText(" " + obj.toString().trim() + " ");
        } else if ("Description".equalsIgnoreCase(stCol)) {
            cell.setHorizontalAlignment(2);
            cell.setText(" " + obj.toString().trim() + " ");
        } else if ("Debit".equalsIgnoreCase(stCol)) {
            cell.setHorizontalAlignment(4);
            cell.setText(" " + Util.format2digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
        } else if ("Credit".equalsIgnoreCase(stCol)) {
            cell.setHorizontalAlignment(4);
            cell.setText(" " + Util.format2digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
        } else if ("Balance".equalsIgnoreCase(stCol)) {
            cell.setHorizontalAlignment(4);
            try {
                double d = Double.parseDouble(obj.toString());
                if (d < 0.0) {
                    d = Math.abs(d);
                    obj = Util.format2digit((String)(d + "")) + "(Dr)";
                } else {
                    obj = Util.format2digit((String)(d + "")) + "(Cr)";
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            cell.setText(" " + obj + " ");
        }
        if (row % 2 == 0) {
            cell.setGradient(this.getOddColorStart(), this.getOddColorEnd());
        } else {
            cell.setGradient(this.getEvenColorStart(), this.getEvenColorEnd());
        }
        if (isSelected) {
            cell.setGradient(this.getSelectColorStart(), this.getSelectColorEnd());
            cell.setForeground(Color.WHITE);
        }
        if ((this.getRowNo() != -1 || this.getRowNo() <= row) && this.getRowNo() == row) {
            cell.setGradient(this.getRoleOverColorStart(), this.getRoleOverColorEnd());
            cell.setForeground(Color.WHITE);
        }
        return cell;
    }
}

