/*
 * Decompiled with CFR 0.152.
 */
package RendersNModels;

import Beans.JSFundTransferStatementBean;
import CustomComponent.NxGLabelGradeint;
import CustomComponent.NxGTableCellRender;
import Utilities.LogsTC;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;

public class FundTransferStatementCellRender
extends NxGTableCellRender {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
        NxGLabelGradeint cell = new NxGLabelGradeint();
        cell.setForeground(MyColors.cellRenderFG);
        cell.setVerticalAlignment(0);
        String columnName2 = table.getColumnName(column);
        if (obj == null) {
            obj = "";
        }
        if (obj instanceof JSFundTransferStatementBean) {
            JSFundTransferStatementBean b = (JSFundTransferStatementBean)obj;
            if (columnName2.equalsIgnoreCase("ID")) {
                cell.setHorizontalAlignment(2);
                cell.setText(" " + b.getId() + " ");
                return cell;
            }
            if (columnName2.equalsIgnoreCase("Requested Date")) {
                cell.setHorizontalAlignment(2);
                try {
                    cell.setText(" " + LogsTC.dateFormatAcc.format(b.getRequestedDate()));
                }
                catch (Exception ex) {
                    cell.setText(" " + obj.toString() + " ");
                }
            } else if (columnName2.equalsIgnoreCase("Requested Amount")) {
                cell.setHorizontalAlignment(4);
                cell.setText(" " + Util.format0digit((String)(b.getRequestedAmount() + "")) + " ");
            } else if (columnName2.equalsIgnoreCase("KSE Account") || columnName2.equalsIgnoreCase("Equity Account")) {
                cell.setHorizontalAlignment(2);
                cell.setText(" " + b.getEquityAccount() + " ");
            } else if (columnName2.equalsIgnoreCase("PMEX Account") || columnName2.equalsIgnoreCase("Commodity Account")) {
                cell.setHorizontalAlignment(2);
                cell.setText(" " + b.getCommodityAccount() + " ");
            } else if (columnName2.equalsIgnoreCase("Status")) {
                cell.setHorizontalAlignment(2);
                cell.setText(" " + b.getStatus() + " ");
            } else if (columnName2.equalsIgnoreCase("Type")) {
                cell.setHorizontalAlignment(2);
                cell.setText(" " + b.getType() + " ");
            } else if (columnName2.equalsIgnoreCase("Approved Amount")) {
                cell.setHorizontalAlignment(4);
                cell.setText(" " + Util.format0digit((String)(b.getApprovedAmount() + "")) + " ");
            } else {
                cell.setHorizontalAlignment(2);
                cell.setText(" " + obj.toString() + " ");
            }
            if (row % 2 == 0) {
                cell.setGradient(this.getOddColorStart(), this.getOddColorEnd());
            } else {
                cell.setGradient(this.getEvenColorStart(), this.getEvenColorEnd());
            }
            if (isSelected) {
                cell.setGradient(this.getSelectColorStart(), this.getSelectColorEnd());
                cell.setForeground(Color.WHITE);
            }
            if ((this.getRowNo() != -1 || this.getRowNo() <= row) && this.getRowNo() == row) {
                cell.setGradient(this.getRoleOverColorStart(), this.getRoleOverColorEnd());
                cell.setForeground(Color.WHITE);
            }
        }
        return cell;
    }
}

