/*
 * Decompiled with CFR 0.152.
 */
package RendersNModels;

import RendersNModels.MsgColorData;
import RendersNModels.MsgColumnData;
import RendersNModels.MsgData;
import common.gui.util.AppConfig;
import java.awt.Color;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import languages.LanguageConstant;

public class MsgDataModel
extends AbstractTableModel {
    public static final MsgColumnData[] m_columns = new MsgColumnData[]{new MsgColumnData(LanguageConstant.MessageWindow)};
    protected Vector m_vector;
    protected int m_columnsCount = m_columns.length;
    protected int m_sortCol = 0;
    protected boolean m_sortAsc = true;
    protected int m_result = 0;

    public MsgDataModel() {
        this.m_vector = new Vector();
        this.setDefaultData();
    }

    public void setDefaultData() {
        this.m_vector.removeAllElements();
    }

    @Override
    public int getRowCount() {
        return this.m_vector == null ? 0 : this.m_vector.size();
    }

    @Override
    public int getColumnCount() {
        return this.m_columnsCount;
    }

    @Override
    public boolean isCellEditable(int nRow, int nCol) {
        return false;
    }

    @Override
    public Object getValueAt(int nRow, int nCol) {
        if (nRow < 0 || nRow >= this.getRowCount()) {
            return "";
        }
        MsgData row = (MsgData)this.m_vector.elementAt(nRow);
        switch (nCol) {
            case 0: {
                return row.MsgColData;
            }
        }
        return "";
    }

    public synchronized void addRow(String Msg, Color FColor, Color BColor) {
        if (AppConfig.MessageWindowMessageLimit > 0 && this.m_vector.size() > AppConfig.MessageWindowMessageLimit) {
            this.m_vector.remove(0);
        }
        this.m_vector.addElement(new MsgData(Msg, FColor, BColor));
        this.fireTableDataChanged();
    }

    public void RemoveLastElement() {
        if (this.m_vector.size() > 0) {
            MsgData msgd = (MsgData)this.m_vector.lastElement();
            MsgColorData msgcoldata = msgd.MsgColData;
            if (msgcoldata.str.length() < 2) {
                // empty if block
            }
            this.m_vector.removeElementAt(this.m_vector.size() - 1);
            this.fireTableDataChanged();
        }
    }

    public void deleteRow(int row) {
        this.m_vector.remove(row);
        super.fireTableDataChanged();
    }
}

