/*
 * Decompiled with CFR 0.152.
 */
package RendersNModels;

import CustomComponent.NxGLabelGradeint;
import CustomComponent.NxGTableCellRender;
import common.gui.util.AppConfig;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class ThemeCellRenderer
extends NxGTableCellRender {
    private LanguageCentre languageCentre = new LanguageCentre();
    private Color oddColorStart = new Color(249, 249, 249);
    private Color oddColorEnd = new Color(225, 225, 225);
    private Color evenColorStart = new Color(221, 232, 242);
    private Color evenColorEnd = new Color(192, 207, 220);
    private Color roleOverColorStart = new Color(89, 136, 166);
    private Color roleOverColorEnd = new Color(139, 187, 218);
    private String tabName = "";

    public ThemeCellRenderer(String tabName) {
        this.tabName = tabName;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
        NxGLabelGradeint cell = new NxGLabelGradeint();
        String colName = table.getColumnName(column);
        cell.setForeground(Color.BLACK);
        if (row % 2 == 0) {
            cell.setGradient(this.getOddColorStart(), this.getOddColorEnd());
        } else {
            cell.setGradient(this.getEvenColorStart(), this.getEvenColorEnd());
        }
        if (isSelected) {
            cell.setGradient(this.getSelectColorStart(), this.getSelectColorEnd());
            this.setForeground(Color.WHITE);
        }
        if ((this.getRowNo() != -1 || this.getRowNo() <= row) && this.getRowNo() == row) {
            cell.setGradient(this.getRoleOverColorStart(), this.getRoleOverColorEnd());
            this.setForeground(Color.WHITE);
        }
        if (obj == null) {
            obj = "";
        }
        if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Scrip))) {
            cell.setFont(AppConfig.defaultPlanFont);
            cell.setHorizontalAlignment(2);
            cell.setText(" " + obj.toString().trim() + " ");
        } else if (colName.equalsIgnoreCase(this.languageCentre.getValue("Contract"))) {
            cell.setFont(AppConfig.defaultPlanFont);
            cell.setHorizontalAlignment(2);
            cell.setText(" " + obj.toString().trim() + " ");
        } else if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Company))) {
            cell.setFont(AppConfig.defaultPlanFont);
            cell.setHorizontalAlignment(2);
            cell.setText(" " + Util.format2digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
        } else if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Last))) {
            if (this.tabName.equalsIgnoreCase("TopLoser")) {
                cell.setForeground(MyColors.LooserFontGB);
                cell.setFont(cell.getFont().deriveFont(1));
                cell.setHorizontalAlignment(4);
                cell.setText(" " + Util.format2digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
            } else if (this.tabName.equalsIgnoreCase("MktPercentDecrease") || this.tabName.equalsIgnoreCase("MktPercentIncrease")) {
                cell.setFont(AppConfig.defaultPlanFont);
                cell.setForeground(Color.BLACK);
                cell.setHorizontalAlignment(4);
                cell.setText(" " + Util.format2digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
            } else {
                cell.setForeground(MyColors.GainerFontGB);
                cell.setFont(cell.getFont().deriveFont(1));
                cell.setHorizontalAlignment(4);
                cell.setText(" " + Util.format2digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
            }
        } else if (colName.equalsIgnoreCase(this.languageCentre.getValue("Change"))) {
            if (this.tabName.equalsIgnoreCase("TopLeader")) {
                try {
                    double dd = Double.parseDouble(obj.toString().trim());
                    if (dd > 0.0) {
                        cell.setForeground(MyColors.GainerFontGB);
                    } else if (dd < 0.0) {
                        cell.setForeground(MyColors.LooserFontGB);
                    } else {
                        cell.setForeground(Color.BLUE);
                    }
                }
                catch (NumberFormatException ex) {
                    cell.setForeground(Color.BLUE);
                }
                cell.setFont(cell.getFont().deriveFont(1));
                cell.setHorizontalAlignment(4);
                cell.setText(" " + Util.format2digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
            } else if (this.tabName.equalsIgnoreCase("MktPercentIncrease")) {
                cell.setForeground(MyColors.GainerFontGB);
                cell.setFont(cell.getFont().deriveFont(1));
                cell.setHorizontalAlignment(4);
                cell.setText(" " + Util.format2digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
            } else if (this.tabName.equalsIgnoreCase("MktPercentDecrease")) {
                cell.setForeground(Color.BLACK);
                cell.setForeground(MyColors.LooserFontGB);
                cell.setFont(cell.getFont().deriveFont(1));
                cell.setHorizontalAlignment(4);
                cell.setText(" " + Util.format2digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
            } else {
                cell.setFont(AppConfig.defaultPlanFont);
                cell.setHorizontalAlignment(4);
                cell.setText(" " + Util.format2digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
            }
        } else if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.PercentChange))) {
            if (this.tabName.equalsIgnoreCase("TopLeader")) {
                try {
                    double dd = Double.parseDouble(obj.toString().trim());
                    if (dd > 0.0) {
                        cell.setForeground(MyColors.GainerFontGB);
                    } else if (dd < 0.0) {
                        cell.setForeground(MyColors.LooserFontGB);
                    } else {
                        cell.setForeground(Color.BLACK);
                    }
                }
                catch (NumberFormatException ex) {
                    cell.setForeground(Color.BLACK);
                }
                cell.setFont(cell.getFont().deriveFont(1));
                cell.setHorizontalAlignment(4);
                cell.setText(" " + Util.format2digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
            } else {
                cell.setFont(AppConfig.defaultPlanFont);
                cell.setHorizontalAlignment(4);
                cell.setText(" " + Util.format2digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
            }
        } else if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Volume))) {
            cell.setForeground(MyColors.LeaderFontGB);
            cell.setFont(cell.getFont().deriveFont(1));
            cell.setHorizontalAlignment(4);
            cell.setText(" " + Util.format0digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
        } else if (colName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Trades))) {
            cell.setFont(AppConfig.defaultPlanFont);
            cell.setHorizontalAlignment(4);
            cell.setText(" " + Util.format0digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
        }
        if (row < 31) {
            if (row % 2 == 0) {
                cell.setGradient(this.oddColorStart, this.oddColorEnd);
            } else {
                cell.setGradient(this.evenColorStart, this.evenColorEnd);
            }
        } else {
            cell.setBackground(Color.white);
        }
        if (isSelected) {
            cell.setGradient(this.getSelectColorStart(), this.getSelectColorEnd());
            cell.setForeground(Color.WHITE);
        }
        if ((this.getRowNo() != -1 || this.getRowNo() <= row) && this.getRowNo() == row) {
            cell.setGradient(this.roleOverColorStart, this.roleOverColorEnd);
            cell.setForeground(Color.WHITE);
        }
        return cell;
    }
}

