/*
 * Decompiled with CFR 0.152.
 */
package SC;

import CustomComponent.MyTime;
import MyDocking.Mediator;
import Utilities.LogsTC;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.util.AppConfig;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.filechooser.FileFilter;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class AccountReport
extends JPanel {
    private String type = "";
    Mediator mediator = Mediator.getInstance();
    ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    JFileChooser chooser;
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnDownload;
    private JComboBox cbAccountNo;
    private JLabel jLabel1;
    private JSeparator jSeparator1;
    private JLabel lblMessage;

    public AccountReport() {
        this.initComponents();
        if (LogsTC.accountAll.size() <= 0) {
            this.lblMessage.setText("No Account assigned");
            this.lblMessage.setIcon(null);
            this.cbAccountNo.setEnabled(false);
            this.btnDownload.setEnabled(false);
        } else {
            this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(LogsTC.accountAll.keySet().toArray()));
            AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])LogsTC.accountAll.keySet().toArray()));
            support.setStrict(true);
        }
        this.chooser = new JFileChooser();
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".pdf") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "PDF Files";
            }
        });
    }

    public void setType(String type) {
        this.type = type;
    }

    private void downloadFile(String URL2, String name) {
        try {
            this.lblMessage.setText("Checking file");
            this.lblMessage.setIcon(this.loaderIcon);
            if (Util.isPageExists((String)URL2)) {
                File f = new File(System.getProperty("user.home") + "/" + name);
                this.chooser.setSelectedFile(f);
                int returnVal = this.chooser.showSaveDialog(this);
                if (returnVal == 0) {
                    File file = this.chooser.getSelectedFile();
                    String fileName = file.getName();
                    if (fileName.indexOf(".pdf") < 0) {
                        fileName = fileName + ".pdf";
                    }
                    String parent = file.getParent();
                    String path = parent + Util.FileSeparator + fileName;
                    this.loadFile(URL2, path);
                } else {
                    this.lblMessage.setText(" ");
                    this.lblMessage.setIcon(null);
                }
            } else {
                this.lblMessage.setText("File not found");
                this.lblMessage.setIcon(null);
            }
        }
        catch (MalformedURLException ex) {
            this.lblMessage.setText("Error in checking File");
            this.lblMessage.setIcon(null);
            ex.printStackTrace();
        }
        catch (IOException ex) {
            this.lblMessage.setText("Error in checking File");
            this.lblMessage.setIcon(null);
            ex.printStackTrace();
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cbAccountNo = new JComboBox();
        this.btnDownload = new JButton();
        this.jSeparator1 = new JSeparator();
        this.lblMessage = new JLabel();
        this.setLayout(null);
        this.jLabel1.setText("Account");
        this.jLabel1.setName("jLabel1");
        this.add(this.jLabel1);
        this.jLabel1.setBounds(10, 10, 39, 20);
        this.cbAccountNo.setName("cbAccountNo");
        this.add(this.cbAccountNo);
        this.cbAccountNo.setBounds(56, 10, 110, 20);
        this.btnDownload.setIcon(new ImageIcon(this.getClass().getResource("/Images/download.png")));
        this.btnDownload.setText("Download");
        this.btnDownload.setName("Account Report -> btnDownload");
        this.btnDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountReport.this.btnDownloadActionPerformed(evt);
            }
        });
        this.add(this.btnDownload);
        this.btnDownload.setBounds(180, 10, 100, 25);
        this.jSeparator1.setName("jSeparator1");
        this.add(this.jSeparator1);
        this.jSeparator1.setBounds(0, 40, 290, 2);
        this.lblMessage.setText(" ");
        this.lblMessage.setName("lblMessage");
        this.add(this.lblMessage);
        this.lblMessage.setBounds(10, 45, 240, 14);
    }

    private void btnDownloadActionPerformed(ActionEvent evt) {
        this.lblMessage.setText(" ");
        this.lblMessage.setForeground(Color.BLACK);
        if (this.cbAccountNo.getSelectedItem() == null) {
            this.lblMessage.setForeground(MyColors.errorMessageFG);
            this.lblMessage.setText("Please select Account No");
            this.cbAccountNo.requestFocus();
            return;
        }
        if (this.cbAccountNo.getSelectedItem().toString().trim().equalsIgnoreCase("")) {
            this.lblMessage.setForeground(MyColors.errorMessageFG);
            this.lblMessage.setText("Please select Account No");
            this.cbAccountNo.requestFocus();
            return;
        }
        if (this.type.equalsIgnoreCase("InvestmentReport")) {
            String URL2 = AppConfig.reportURL + "PDFReports/Client%20Statement/" + this.cbAccountNo.getSelectedItem() + "-adv_stat.PDF";
            String file = "InvestmentReport - " + MyTime.getInstance().getDateAndTime() + ".pdf";
            this.downloadFile(URL2, file.replaceAll(":", ""));
        } else if (this.type.equalsIgnoreCase("LedgerActivity")) {
            String URL3 = AppConfig.reportURL + "PDFReports/Ledger/" + this.cbAccountNo.getSelectedItem() + "-Ledger.PDF".replaceAll(":", "");
            String file = "LedgerActivity - " + MyTime.getInstance().getDateAndTime() + ".pdf";
            this.downloadFile(URL3, file.replaceAll(":", ""));
        }
    }

    private void loadFile(final String URL2, final String path) {
        this.lblMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
        this.lblMessage.setIcon(this.loaderIcon);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (Util.FileDownload((String)URL2, (String)path)) {
                        AccountReport.this.lblMessage.setText("File downloaded.");
                        AccountReport.this.lblMessage.setIcon(null);
                        int Option = JOptionPane.showConfirmDialog(null, "Pdf file created. Open Pdf file?", "PDF", 0);
                        if (Option == 0) {
                            try {
                                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + path);
                            }
                            catch (IOException ex) {
                                AccountReport.this.lblMessage.setText("Error in Open file ");
                                AccountReport.this.lblMessage.setIcon(null);
                            }
                        }
                    } else {
                        AccountReport.this.lblMessage.setText("Error in downloading file");
                        AccountReport.this.lblMessage.setIcon(null);
                    }
                }
                catch (Exception ex) {
                    AccountReport.this.lblMessage.setText("Server Unavailable. Please try after few minutes");
                    AccountReport.this.lblMessage.setIcon(null);
                }
            }
        }, "Account Report").start();
    }
}

