/*
 * Decompiled with CFR 0.152.
 */
package SC;

import CATALYST.Control.MarketFeed;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import RendersNModels.MultiLineHeaderRenderer;
import Utilities.LoadLogs;
import common.gui.component.JTextFieldFilter;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;
import kse.util.UtilKSE;

public class FundamentalForm
extends JPanel {
    private boolean isRun = true;
    public static String SCMktSymbols = "";
    DefaultTableModel tableModel = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0 || col == 7;
        }
    };
    public Vector rows = new Vector();
    public Vector columns = new Vector();
    Object[] columnNames = new Object[]{"Scrip", "Current", "PE\n(L.A)", "PE\n(C.AZ)", "PE\n(Est)", "EPS\n(Last Annual)", "EPS (Latest)", "EPS (Est)", "Book Value", "52 W\nHigh", "52 W\nLow", "Details"};
    String removeSymbol = "";
    String allLog = "";
    Font plainFont = AppConfig.defaultPlanFont;
    public static String epsSt = "1";
    Queue symbolQueue = new LinkedList();
    Thread configThread = null;
    JTextField txtSymbol = new JTextField();
    HashMap symbolMap = new HashMap();
    Thread refresh = null;
    Mediator mediator = Mediator.getInstance();
    ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    public static String Symbol = "";
    private JButton btnRefresh;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblMessage;
    private JLabel lblScripName;
    private JLabel lblTime;
    private JTable tblFundamentals;
    Runnable RefreshTimer = new Runnable(){

        @Override
        public void run() {
            try {
                while (FundamentalForm.this.isRun) {
                    Thread.sleep(90000L);
                    FundamentalForm.this.loadPrefrences();
                }
            }
            catch (Exception ex) {
                FundamentalForm.this.mediator.PrintLog(ex, "");
                ex.printStackTrace();
            }
        }
    };

    public FundamentalForm() {
        this.initComponents();
        this.lblScripName.setFont(this.lblScripName.getFont().deriveFont(1));
        this.initTable();
        this.setRender();
        this.mediator.setFundamental(this);
        this.btnRefresh.setVisible(true);
        this.intTableSymbol();
        this.loadPrefrences();
        if (this.refresh == null) {
            this.refresh = new Thread(this.RefreshTimer, "Fundamental Form");
            this.refresh.start();
        }
    }

    public void stopFundamentalForm() {
        this.isRun = false;
    }

    public String getOnlySymbols(String FundamentalSymbols) {
        String sn = "";
        if (FundamentalSymbols.indexOf(";") >= 0) {
            String[] both = FundamentalSymbols.split("\\;", -1);
            for (int i = 0; i < both.length; ++i) {
                if (both[i].indexOf(":") < 0) continue;
                sn = sn + both[i].split("\\:", -1)[0] + ";";
            }
        }
        return sn;
    }

    public void setErrorResult() {
        this.lblMessage.setText("Error in loading data");
        this.lblMessage.setIcon(null);
    }

    public void setResult(String msg) {
        this.lblMessage.setText(msg);
        this.lblMessage.setIcon(null);
    }

    private void intTableSymbol() {
        String sss = LogCommon.FundamentalSymbols;
        if (sss.indexOf(";") >= 0) {
            String[] both = sss.split("\\;", -1);
            for (int i = 0; i < both.length; ++i) {
                if (both[i].indexOf(":") < 0) continue;
                String[] both2 = both[i].split("\\:", -1);
                this.tblFundamentals.setValueAt(both2[0], i, 0);
                this.tblFundamentals.setValueAt(both2[1], i, 7);
            }
        }
    }

    private void saveSymbolString() {
        LogCommon.FundamentalSymbols = "";
        String symbol = "";
        String eps = "";
        for (int i = 0; i < this.tblFundamentals.getRowCount(); ++i) {
            if (this.tblFundamentals.getValueAt(i, 0) != null) {
                symbol = this.tblFundamentals.getValueAt(i, 0).toString();
                if (this.tblFundamentals.getValueAt(i, 7) != null) {
                    eps = this.tblFundamentals.getValueAt(i, 7).toString();
                }
                LogCommon.FundamentalSymbols = LogCommon.FundamentalSymbols + symbol + ":" + eps + ";";
                continue;
            }
            LogCommon.FundamentalSymbols = LogCommon.FundamentalSymbols + ":;";
        }
    }

    private void loadPrefrences() {
        if (LogCommon.FundamentalSymbols.length() > 1) {
            this.lblMessage.setText("Getting data of all Scrip");
            this.lblMessage.setIcon(this.loaderIcon);
            try {
                LoadLogs accSt = new LoadLogs("FundamentalAllSymbols=", true);
                new Thread((Runnable)accSt, "FundamentalAllSymbols").start();
            }
            catch (Exception ex) {
                this.mediator.PrintLog(ex, "");
                ex.printStackTrace();
            }
        } else {
            this.lblMessage.setText(" ");
            this.lblMessage.setIcon(null);
        }
    }

    private void initTable() {
        for (int i = 0; i < this.columnNames.length; ++i) {
            this.columns.addElement((String)this.columnNames[i]);
        }
        for (int k = 0; k < 25; ++k) {
            this.rows.addElement(new Vector());
            this.tblFundamentals.addNotify();
        }
        this.tableModel.setDataVector(this.rows, this.columns);
        this.tblFundamentals.setModel(this.tableModel);
        this.tblFundamentals.getTableHeader().setReorderingAllowed(false);
        this.tblFundamentals.setSelectionMode(0);
        this.tblFundamentals.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.tblFundamentals.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.tblFundamentals.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.tblFundamentals.getColumnModel().getColumn(3).setPreferredWidth(60);
        this.tblFundamentals.getColumnModel().getColumn(4).setPreferredWidth(50);
        this.tblFundamentals.getColumnModel().getColumn(5).setPreferredWidth(100);
        this.tblFundamentals.getColumnModel().getColumn(6).setPreferredWidth(115);
        this.tblFundamentals.getColumnModel().getColumn(7).setPreferredWidth(60);
        this.tblFundamentals.getColumnModel().getColumn(8).setPreferredWidth(90);
        this.tblFundamentals.getColumnModel().getColumn(9).setPreferredWidth(40);
        this.tblFundamentals.getColumnModel().getColumn(10).setPreferredWidth(40);
        this.tblFundamentals.getColumnModel().getColumn(11).setPreferredWidth(50);
        JTableHeader header = this.tblFundamentals.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
        final Cursor handCursor = new Cursor(12);
        final Cursor defaultCursor = new Cursor(0);
        this.tblFundamentals.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                TableColumnModel colModel = FundamentalForm.this.tblFundamentals.getColumnModel();
                int vColIndex = colModel.getColumnIndexAtX(e.getX());
                int mColIndex = FundamentalForm.this.tblFundamentals.convertColumnIndexToModel(vColIndex);
                if ("Details".equalsIgnoreCase(FundamentalForm.this.tblFundamentals.getColumnName(mColIndex).toString())) {
                    FundamentalForm.this.tblFundamentals.setCursor(handCursor);
                } else {
                    FundamentalForm.this.tblFundamentals.setCursor(defaultCursor);
                }
            }
        });
        this.txtSymbol.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ"));
        this.txtSymbol.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 9) {
                    FundamentalForm.this.GetSingalSymbolFeed();
                    FundamentalForm.this.SetName(FundamentalForm.this.txtSymbol.getText());
                }
            }
        });
        this.txtSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FundamentalForm.this.GetSingalSymbolFeed();
                FundamentalForm.this.SetName(FundamentalForm.this.txtSymbol.getText());
            }
        });
        this.txtSymbol.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                FundamentalForm.this.txtSymbol.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                FundamentalForm.this.saveSymbolString();
            }
        });
        DefaultCellEditor editor = new DefaultCellEditor(this.txtSymbol);
        this.tblFundamentals.getColumn("Scrip").setCellEditor(editor);
        final JTextField txtEPS = new JTextField();
        txtEPS.setDocument((Document)new JTextFieldFilter("0123456789"));
        txtEPS.setHorizontalAlignment(4);
        txtEPS.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10 && txtEPS.getText().length() > 0) {
                    String symbol = FundamentalForm.this.tblFundamentals.getValueAt(FundamentalForm.this.tblFundamentals.getSelectedRow(), 0).toString();
                    FundamentalForm.this.updateTableRow(FundamentalForm.this.GetFeed(symbol.trim().toUpperCase(), epsSt));
                }
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                epsSt = txtEPS.getText();
            }
        });
        txtEPS.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                txtEPS.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                FundamentalForm.this.saveSymbolString();
            }
        });
        DefaultCellEditor editor1 = new DefaultCellEditor(txtEPS);
        this.tblFundamentals.getColumn("EPS (Est)").setCellEditor(editor1);
        MultiLineHeaderRenderer renderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> e = this.tblFundamentals.getColumnModel().getColumns();
        while (e.hasMoreElements()) {
            e.nextElement().setHeaderRenderer(renderer);
        }
        this.tblFundamentals.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = FundamentalForm.this.tblFundamentals.getSelectedRow();
                Object ob = FundamentalForm.this.tblFundamentals.getValueAt(row, 0);
                if (ob != null) {
                    FundamentalForm.this.SetName(ob.toString());
                } else {
                    FundamentalForm.this.lblScripName.setText(" ");
                }
            }
        });
    }

    public void SetName(String symbol) {
        if (symbol.indexOf("-") >= 0) {
            symbol = symbol.split("\\-", -1)[0];
        }
        if (symbol.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(symbol.trim())) {
            this.lblScripName.setText("Invalid Scrip");
            this.lblScripName.setIcon(null);
        } else {
            this.lblScripName.setText(this.mediator.getSymbolTitle(symbol));
        }
    }

    private void GetSingalSymbolFeed() {
        Symbol = this.txtSymbol.getText().trim();
        this.lblMessage.setText("");
        int k = this.tblFundamentals.getSelectedRow();
        if (Symbol.equalsIgnoreCase("")) {
            this.emptyRow(k);
            return;
        }
        String abc = "";
        String symbo = this.tblFundamentals.getValueAt(k, 0).toString();
        for (int i = 0; i < this.tblFundamentals.getRowCount(); ++i) {
            if (this.tblFundamentals.getValueAt(i, 0) == null || k == i) continue;
            String symbol = this.tblFundamentals.getValueAt(i, 0).toString();
            abc = abc + symbol + ";";
        }
        if (abc.indexOf(Symbol) >= 0) {
            this.lblMessage.setText("Scrip already added");
            this.emptyRow(k);
            UtilKSE.SelectRow((JTable)this.tblFundamentals, (JScrollPane)this.jScrollPane1, (int)this.GetRow(Symbol));
            return;
        }
        this.lblMessage.setText("Getting data of " + Symbol);
        this.lblMessage.setIcon(this.loaderIcon);
        if (Symbol.length() > 1) {
            if (!this.symbolMap.containsKey(Symbol)) {
                LoadLogs accSt = new LoadLogs("FundamentalSymbol=", true);
                new Thread((Runnable)accSt, "FundamentalAllSymbols").start();
            } else {
                this.updateTableNew();
            }
            this.addSymbolInMarketWatch(this.txtSymbol.getText());
        } else {
            this.updateTableNew();
        }
        this.lblTime.setText("Last Updated Time " + MyTime.getInstance().getTime());
        this.lblMessage.setText(" ");
        this.lblMessage.setIcon(null);
    }

    public String setSingalFeed(String feed) {
        if (feed == null || feed.equals("") || feed.equalsIgnoreCase("Null")) {
            feed = feed + Symbol + ";;;;;;;;;;;";
        }
        this.symbolMap.put(Symbol, feed);
        this.updateTableNew();
        return feed + "|";
    }

    public synchronized void updateTableRow(String Log) {
        int row = this.tblFundamentals.getSelectedRow();
        String[] columnVal = Log.split("\\;", -1);
        double current = 1.0;
        int eps = 1;
        for (int col = 0; col < this.columnNames.length; ++col) {
            if (!columnVal[9].equals("") && columnVal[9] != null) {
                try {
                    eps = Integer.parseInt(columnVal[9]);
                    if (eps <= 0) {
                        eps = 1;
                    }
                }
                catch (Exception ex) {
                    this.mediator.PrintLog(ex, "");
                    ex.printStackTrace();
                }
            }
            String val = "";
            if (col == 0) continue;
            if (col == 1) {
                current = this.GetCurrentRate(columnVal[0].toUpperCase());
                val = current + "";
                this.tblFundamentals.setValueAt(val, row, 1);
                continue;
            }
            if (col == 2) {
                if (columnVal[1] == null || columnVal[1].equals("")) {
                    val = "";
                    this.tblFundamentals.setValueAt(val, row, 2);
                    continue;
                }
                val = Util.round((double)(current / Double.parseDouble(columnVal[1])), (int)2) + "";
                this.tblFundamentals.setValueAt(val, row, 2);
                continue;
            }
            if (col == 3) {
                if (columnVal[2] == null || columnVal[2].equals("")) {
                    val = "";
                    this.tblFundamentals.setValueAt(val, row, 3);
                    continue;
                }
                int month = 0;
                String ss = columnVal[7].split("\\(", -1)[1];
                String stMonth = ss.split("M", -1)[0];
                double div = 0.0;
                try {
                    month = Integer.parseInt(stMonth);
                    if (month == 3) {
                        div = Double.parseDouble(columnVal[2]) * 4.0;
                        val = Util.round((double)(current / div), (int)2) + "";
                        this.tblFundamentals.setValueAt(val, row, 3);
                        continue;
                    }
                    if (month == 6) {
                        div = Double.parseDouble(columnVal[2]) * 2.0;
                        val = Util.round((double)(current / div), (int)2) + "";
                        this.tblFundamentals.setValueAt(val, row, 3);
                        continue;
                    }
                    if (month == 9) {
                        div = Double.parseDouble(columnVal[2]) * 1.333;
                        val = Util.round((double)(current / div), (int)2) + "";
                        this.tblFundamentals.setValueAt(val, row, 3);
                        continue;
                    }
                    if (month == 12) {
                        div = Double.parseDouble(columnVal[2]);
                        val = Util.round((double)(current / div), (int)2) + "";
                        this.tblFundamentals.setValueAt(val, row, 3);
                        continue;
                    }
                    div = Double.parseDouble(columnVal[2]);
                    val = Util.round((double)(current / div), (int)2) + "";
                    this.tblFundamentals.setValueAt(val, row, 3);
                }
                catch (NumberFormatException ex) {
                    div = Double.parseDouble(columnVal[2]);
                    val = Util.round((double)(current / div), (int)2) + "";
                    this.tblFundamentals.setValueAt(val, row, 3);
                    ex.printStackTrace();
                    this.mediator.PrintLog(ex, "");
                }
                continue;
            }
            if (col == 4) {
                val = Util.round((double)(current / (double)eps), (int)2) + "";
                this.tblFundamentals.setValueAt(val, row, 4);
                continue;
            }
            if (col == 5) {
                if (columnVal[1] == null || columnVal[1].equals("")) {
                    val = "";
                    this.tblFundamentals.setValueAt(val, row, 5);
                    continue;
                }
                val = Util.round((double)Double.parseDouble(columnVal[1]), (int)2) + " " + columnVal[6];
                this.tblFundamentals.setValueAt(val, row, 5);
                continue;
            }
            if (col == 6) {
                if (columnVal[2] == null || columnVal[2].equals("")) {
                    val = "";
                    this.tblFundamentals.setValueAt(val, row, 6);
                    continue;
                }
                val = Util.round((double)Double.parseDouble(columnVal[2]), (int)2) + " " + columnVal[7];
                this.tblFundamentals.setValueAt(val, row, 6);
                continue;
            }
            if (col == 7) continue;
            if (col == 8) {
                if (columnVal[3] == null || columnVal[3].equals("")) {
                    val = "";
                    this.tblFundamentals.setValueAt(val, row, 8);
                    continue;
                }
                val = Util.round((double)Double.parseDouble(columnVal[3]), (int)2) + " " + columnVal[8];
                this.tblFundamentals.setValueAt(val, row, 8);
                continue;
            }
            if (col == 9) {
                if (columnVal[4] == null || columnVal[4].equals("")) {
                    val = "";
                    this.tblFundamentals.setValueAt(val, row, 9);
                    continue;
                }
                val = Util.round((double)Double.parseDouble(columnVal[4]), (int)2) + "";
                this.tblFundamentals.setValueAt(val, row, 9);
                continue;
            }
            if (col != 10) continue;
            if (columnVal[5] == null || columnVal[5].equals("")) {
                val = "";
                this.tblFundamentals.setValueAt(val, row, 10);
                continue;
            }
            val = Util.round((double)Double.parseDouble(columnVal[5]), (int)2) + "";
            this.tblFundamentals.setValueAt(val, row, 10);
        }
        this.tblFundamentals.repaint();
    }

    public synchronized void updateTableNew() {
        for (int row = 0; row < this.tblFundamentals.getRowCount(); ++row) {
            String symbol = "";
            String feed = ";;;;;;;;;;;;";
            if (this.tblFundamentals.getValueAt(row, 0) == null) {
                for (int j = 0; j < this.columnNames.length - 2; ++j) {
                    this.tblFundamentals.setValueAt("", row, j + 1);
                }
                continue;
            }
            if (this.tblFundamentals.getValueAt(row, 0).toString().equalsIgnoreCase("")) {
                for (int j = 0; j < this.columnNames.length - 2; ++j) {
                    this.tblFundamentals.setValueAt("", row, j + 1);
                }
                continue;
            }
            symbol = this.tblFundamentals.getValueAt(row, 0).toString();
            if (this.symbolMap.containsKey(symbol) && (feed = this.symbolMap.get(symbol).toString()).equalsIgnoreCase("Null")) continue;
            String[] columnVal = feed.split("\\;", -1);
            String steps = "1";
            steps = this.tblFundamentals.getValueAt(row, 7) == null ? "1" : this.tblFundamentals.getValueAt(row, 7).toString().toString();
            double current = 1.0;
            int eps = 1;
            if (steps.equalsIgnoreCase("")) {
                eps = 1;
            } else {
                try {
                    eps = (int)Double.parseDouble(steps);
                    if (eps <= 0) {
                        eps = 1;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.mediator.PrintLog(ex, "");
                }
            }
            for (int col = 0; col < this.columnNames.length; ++col) {
                String val = "";
                if (col == 0) {
                    val = columnVal[0].toUpperCase();
                    this.tblFundamentals.setValueAt(val, row, 0);
                    continue;
                }
                if (col == 1) {
                    current = this.GetCurrentRate(columnVal[0].toUpperCase());
                    val = current + "";
                    this.tblFundamentals.setValueAt(val, row, 1);
                    continue;
                }
                if (col == 2) {
                    if (columnVal[1] == null || columnVal[1].equals("")) {
                        val = "";
                        this.tblFundamentals.setValueAt(val, row, 2);
                        continue;
                    }
                    val = Util.round((double)(current / Double.parseDouble(columnVal[1])), (int)2) + "";
                    this.tblFundamentals.setValueAt(val, row, 2);
                    continue;
                }
                if (col == 3) {
                    if (columnVal[2] == null || columnVal[2].equals("")) {
                        val = "";
                        this.tblFundamentals.setValueAt(val, row, 3);
                        continue;
                    }
                    int month = 0;
                    String ss = columnVal[7].split("\\(", -1)[1];
                    String stMonth = ss.split("M", -1)[0];
                    double div = 0.0;
                    try {
                        month = Integer.parseInt(stMonth);
                        if (month == 3) {
                            div = Double.parseDouble(columnVal[2]) * 4.0;
                            val = Util.round((double)(current / div), (int)2) + "";
                            this.tblFundamentals.setValueAt(val, row, 3);
                            continue;
                        }
                        if (month == 6) {
                            div = Double.parseDouble(columnVal[2]) * 2.0;
                            val = Util.round((double)(current / div), (int)2) + "";
                            this.tblFundamentals.setValueAt(val, row, 3);
                            continue;
                        }
                        if (month == 9) {
                            div = Double.parseDouble(columnVal[2]) * 1.333;
                            val = Util.round((double)(current / div), (int)2) + "";
                            this.tblFundamentals.setValueAt(val, row, 3);
                            continue;
                        }
                        if (month == 12) {
                            div = Double.parseDouble(columnVal[2]);
                            val = Util.round((double)(current / div), (int)2) + "";
                            this.tblFundamentals.setValueAt(val, row, 3);
                            continue;
                        }
                        div = Double.parseDouble(columnVal[2]);
                        val = Util.round((double)(current / div), (int)2) + "";
                        this.tblFundamentals.setValueAt(val, row, 3);
                    }
                    catch (NumberFormatException ex) {
                        div = Double.parseDouble(columnVal[2]);
                        val = Util.round((double)(current / div), (int)2) + "";
                        this.tblFundamentals.setValueAt(val, row, 3);
                        ex.printStackTrace();
                        this.mediator.PrintLog(ex, "");
                    }
                    continue;
                }
                if (col == 4) {
                    val = Util.round((double)(current / (double)eps), (int)2) + "";
                    this.tblFundamentals.setValueAt(val, row, 4);
                    continue;
                }
                if (col == 5) {
                    if (columnVal[1] == null || columnVal[1].equals("")) {
                        val = "";
                        this.tblFundamentals.setValueAt(val, row, 5);
                        continue;
                    }
                    val = Util.round((double)Double.parseDouble(columnVal[1]), (int)2) + " " + columnVal[6];
                    this.tblFundamentals.setValueAt(val, row, 5);
                    continue;
                }
                if (col == 6) {
                    if (columnVal[2] == null || columnVal[2].equals("")) {
                        val = "";
                        this.tblFundamentals.setValueAt(val, row, 6);
                        continue;
                    }
                    val = Util.round((double)Double.parseDouble(columnVal[2]), (int)2) + " " + columnVal[7];
                    this.tblFundamentals.setValueAt(val, row, 6);
                    continue;
                }
                if (col == 7) continue;
                if (col == 8) {
                    if (columnVal[3] == null || columnVal[3].equals("")) {
                        val = "";
                        this.tblFundamentals.setValueAt(val, row, 8);
                        continue;
                    }
                    val = Util.round((double)Double.parseDouble(columnVal[3]), (int)2) + " " + columnVal[8];
                    this.tblFundamentals.setValueAt(val, row, 8);
                    continue;
                }
                if (col == 9) {
                    if (columnVal[4] == null || columnVal[4].equals("")) {
                        val = "";
                        this.tblFundamentals.setValueAt(val, row, 9);
                        continue;
                    }
                    val = Util.round((double)Double.parseDouble(columnVal[4]), (int)2) + "";
                    this.tblFundamentals.setValueAt(val, row, 9);
                    continue;
                }
                if (col != 10) continue;
                if (columnVal[5] == null || columnVal[5].equals("")) {
                    val = "";
                    this.tblFundamentals.setValueAt(val, row, 10);
                    continue;
                }
                val = Util.round((double)Double.parseDouble(columnVal[5]), (int)2) + "";
                this.tblFundamentals.setValueAt(val, row, 10);
            }
        }
        this.tblFundamentals.addNotify();
        this.tblFundamentals.repaint();
    }

    public synchronized void updateTableNew(String Log) {
        this.setMapValue(Log);
        if (Log.equalsIgnoreCase("")) {
            this.lblMessage.setText("No record found");
            this.lblMessage.setIcon(null);
            return;
        }
        String feed = ";;;;;;;;;";
        int rowVal = this.tblFundamentals.getRowCount();
        for (int row = 0; row < rowVal; ++row) {
            if (this.tblFundamentals.getValueAt(row, 0) == null || this.tblFundamentals.getValueAt(row, 0).toString().equalsIgnoreCase("")) continue;
            String symbol = this.tblFundamentals.getValueAt(row, 0).toString().toUpperCase();
            if (this.symbolMap.containsKey(symbol)) {
                feed = this.symbolMap.get(symbol).toString();
            }
            String steps = "1";
            steps = this.tblFundamentals.getValueAt(row, 7) == null ? "1" : this.tblFundamentals.getValueAt(row, 7).toString().trim();
            String[] columnVal = feed.split("\\;", -1);
            double current = 1.0;
            int eps = 1;
            for (int col = 0; col < this.columnNames.length; ++col) {
                if (!steps.equals("") && steps != null) {
                    try {
                        eps = (int)Double.parseDouble(steps);
                        if (eps <= 0) {
                            eps = 1;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        ex.printStackTrace();
                        this.mediator.PrintLog(ex, "");
                    }
                }
                String val = "";
                if (col == 0) {
                    val = columnVal[0].toUpperCase();
                    this.tblFundamentals.setValueAt(val, row, col);
                    continue;
                }
                if (col == 1) {
                    current = this.GetCurrentRate(columnVal[0].toUpperCase());
                    val = current + "";
                    this.tblFundamentals.setValueAt(val, row, col);
                    continue;
                }
                if (col == 2) {
                    if (columnVal[1] == null || columnVal[1].equals("")) {
                        val = "";
                        this.tblFundamentals.setValueAt(val, row, col);
                        continue;
                    }
                    val = Util.round((double)(current / Double.parseDouble(columnVal[1])), (int)2) + "";
                    this.tblFundamentals.setValueAt(val, row, col);
                    continue;
                }
                if (col == 3) {
                    if (columnVal[2] == null || columnVal[2].equals("")) {
                        val = "";
                        this.tblFundamentals.setValueAt(val, row, col);
                        continue;
                    }
                    int month = 0;
                    String ss = columnVal[7].split("\\(", -1)[1];
                    String stMonth = ss.split("M", -1)[0];
                    double div = 0.0;
                    try {
                        month = Integer.parseInt(stMonth);
                        if (month == 3) {
                            div = Double.parseDouble(columnVal[2]) * 4.0;
                            val = Util.round((double)(current / div), (int)2) + "";
                            this.tblFundamentals.setValueAt(val, row, col);
                            continue;
                        }
                        if (month == 6) {
                            div = Double.parseDouble(columnVal[2]) * 2.0;
                            val = Util.round((double)(current / div), (int)2) + "";
                            this.tblFundamentals.setValueAt(val, row, col);
                            continue;
                        }
                        if (month == 9) {
                            div = Double.parseDouble(columnVal[2]) * 1.333;
                            val = Util.round((double)(current / div), (int)2) + "";
                            this.tblFundamentals.setValueAt(val, row, col);
                            continue;
                        }
                        if (month == 12) {
                            div = Double.parseDouble(columnVal[2]);
                            val = Util.round((double)(current / div), (int)2) + "";
                            this.tblFundamentals.setValueAt(val, row, col);
                            continue;
                        }
                        div = Double.parseDouble(columnVal[2]);
                        val = Util.round((double)(current / div), (int)2) + "";
                        this.tblFundamentals.setValueAt(val, row, col);
                    }
                    catch (NumberFormatException ex) {
                        div = Double.parseDouble(columnVal[2]);
                        val = Util.round((double)(current / div), (int)2) + "";
                        this.tblFundamentals.setValueAt(val, row, col);
                        ex.printStackTrace();
                        this.mediator.PrintLog(ex, "");
                    }
                    continue;
                }
                if (col == 4) {
                    val = Util.round((double)(current / (double)eps), (int)2) + "";
                    this.tblFundamentals.setValueAt(val, row, col);
                    continue;
                }
                if (col == 5) {
                    if (columnVal[1] == null || columnVal[1].equals("")) {
                        val = "";
                        this.tblFundamentals.setValueAt(val, row, col);
                        continue;
                    }
                    val = Util.round((double)Double.parseDouble(columnVal[1]), (int)2) + " " + columnVal[6];
                    this.tblFundamentals.setValueAt(val, row, col);
                    continue;
                }
                if (col == 6) {
                    if (columnVal[2] == null || columnVal[2].equals("")) {
                        val = "";
                        this.tblFundamentals.setValueAt(val, row, col);
                        continue;
                    }
                    val = Util.round((double)Double.parseDouble(columnVal[2]), (int)2) + " " + columnVal[7];
                    this.tblFundamentals.setValueAt(val, row, col);
                    continue;
                }
                if (col == 7) continue;
                if (col == 8) {
                    if (columnVal[3] == null || columnVal[3].equals("")) {
                        val = "";
                        this.tblFundamentals.setValueAt(val, row, col);
                        continue;
                    }
                    val = Util.round((double)Double.parseDouble(columnVal[3]), (int)2) + " " + columnVal[8];
                    this.tblFundamentals.setValueAt(val, row, col);
                    continue;
                }
                if (col == 9) {
                    if (columnVal[4] == null || columnVal[4].equals("")) {
                        val = "";
                        this.tblFundamentals.setValueAt(val, row, col);
                        continue;
                    }
                    val = Util.round((double)Double.parseDouble(columnVal[4]), (int)2) + "";
                    this.tblFundamentals.setValueAt(val, row, col);
                    continue;
                }
                if (col != 10) continue;
                if (columnVal[5] == null || columnVal[5].equals("")) {
                    val = "";
                    this.tblFundamentals.setValueAt(val, row, col);
                    continue;
                }
                val = Util.round((double)Double.parseDouble(columnVal[5]), (int)2) + "";
                this.tblFundamentals.setValueAt(val, row, col);
            }
        }
        this.tblFundamentals.addNotify();
        this.tblFundamentals.repaint();
        this.lblTime.setText("Last Updated Time " + MyTime.getInstance().getTime());
        this.lblMessage.setText(" ");
        this.lblMessage.setIcon(null);
    }

    private void emptyRow(int selectedRow) {
        for (int i = 0; i < this.columnNames.length; ++i) {
            this.tblFundamentals.getModel().setValueAt("", selectedRow, i);
        }
    }

    private int GetRow(String symbol) {
        int k = -1;
        for (int i = 0; i < this.tblFundamentals.getRowCount(); ++i) {
            String sym;
            if (this.tblFundamentals.getValueAt(i, 0) == null || !(sym = this.tblFundamentals.getValueAt(i, 0).toString()).trim().equalsIgnoreCase(symbol)) continue;
            return i;
        }
        return k;
    }

    private void setMapValue(String Log) {
        this.symbolMap.clear();
        String[] rowVal = Log.split("\\|", -1);
        for (int row = 0; row < rowVal.length - 1; ++row) {
            String symbol;
            String[] columnVal;
            if (rowVal[row].trim().equalsIgnoreCase("") || (columnVal = rowVal[row].split("\\;", -1))[0].trim().equalsIgnoreCase("") || columnVal[0].equalsIgnoreCase("null") || columnVal.length < 5 || this.symbolMap.containsKey(symbol = columnVal[0].toString().toUpperCase())) continue;
            this.symbolMap.put(symbol, rowVal[row]);
        }
    }

    private void setRender() {
        this.tblFundamentals.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){
            final Color redColor = new Color(247, 59, 59);
            final Color greenColor = new Color(13, 153, 13);
            final Color mehndiColor = new Color(107, 111, 61);

            @Override
            public Component getTableCellRendererComponent(JTable tblDataTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String val = "";
                JLabel cell = (JLabel)super.getTableCellRendererComponent(tblDataTable, value, isSelected, hasFocus, row, column);
                cell.setBackground(new Color(74, 74, 74));
                if (value == null || value.toString().equalsIgnoreCase("Null")) {
                    val = "";
                } else if (value != null) {
                    val = value.toString();
                }
                if ("Details".equalsIgnoreCase(tblDataTable.getColumnName(column).toString())) {
                    if (tblDataTable.getValueAt(row, 0) != null && !tblDataTable.getValueAt(row, 0).toString().equalsIgnoreCase("")) {
                        cell.setText("<HTMl><U>Details</U></HTML>");
                        cell.setHorizontalAlignment(0);
                        cell.setForeground(MyColors.ForgotPincodeFG);
                        cell.setFont(cell.getFont().deriveFont(1));
                    }
                } else if ("Scrip".equalsIgnoreCase(tblDataTable.getColumnName(column).toString())) {
                    if (tblDataTable.getValueAt(row, 0) != null) {
                        if (!tblDataTable.getValueAt(row, 0).toString().equalsIgnoreCase("")) {
                            cell.setText(" " + val + " ");
                            cell.setHorizontalAlignment(2);
                            cell.setForeground(Color.BLACK);
                            cell.setFont(cell.getFont().deriveFont(1));
                        } else {
                            cell.setText("");
                        }
                    }
                } else if ("Current".equalsIgnoreCase(tblDataTable.getColumnName(column).toString())) {
                    if (tblDataTable.getValueAt(row, 0) != null) {
                        if (!tblDataTable.getValueAt(row, 0).toString().equalsIgnoreCase("")) {
                            cell.setText(Util.format2digit((String)val) + " ");
                            cell.setHorizontalAlignment(4);
                            cell.setForeground(Color.BLACK);
                            cell.setFont(FundamentalForm.this.plainFont);
                        } else {
                            cell.setText("");
                        }
                    }
                } else if ("PE\n(L.A)".equalsIgnoreCase(tblDataTable.getColumnName(column).toString())) {
                    if (tblDataTable.getValueAt(row, 0) != null) {
                        if (!tblDataTable.getValueAt(row, 0).toString().equalsIgnoreCase("")) {
                            cell.setText(Util.format2digit((String)val) + " ");
                            cell.setHorizontalAlignment(4);
                            cell.setForeground(this.redColor);
                            cell.setFont(cell.getFont().deriveFont(1));
                        } else {
                            cell.setText("");
                        }
                    }
                } else if ("PE\n(C.AZ)".equalsIgnoreCase(tblDataTable.getColumnName(column).toString())) {
                    if (tblDataTable.getValueAt(row, 0) != null) {
                        if (!tblDataTable.getValueAt(row, 0).toString().equalsIgnoreCase("")) {
                            cell.setText(Util.format2digit((String)val) + " ");
                            cell.setHorizontalAlignment(4);
                            cell.setForeground(this.mehndiColor);
                            cell.setFont(cell.getFont().deriveFont(1));
                        } else {
                            cell.setText("");
                        }
                    }
                } else if ("PE\n(Est)".equalsIgnoreCase(tblDataTable.getColumnName(column).toString())) {
                    if (tblDataTable.getValueAt(row, 0) != null) {
                        if (!tblDataTable.getValueAt(row, 0).toString().equalsIgnoreCase("")) {
                            cell.setText(Util.format2digit((String)val) + " ");
                            cell.setHorizontalAlignment(4);
                            cell.setForeground(this.greenColor);
                            cell.setFont(cell.getFont().deriveFont(1));
                        } else {
                            cell.setText("");
                        }
                    }
                } else if ("EPS\n(Last Annual)".equalsIgnoreCase(tblDataTable.getColumnName(column).toString())) {
                    if (tblDataTable.getValueAt(row, 0) != null) {
                        if (!tblDataTable.getValueAt(row, 0).toString().equalsIgnoreCase("")) {
                            cell.setText(" " + val + " ");
                            cell.setHorizontalAlignment(4);
                            cell.setForeground(this.redColor);
                            cell.setFont(cell.getFont().deriveFont(1));
                        } else {
                            cell.setText("");
                        }
                    }
                } else if ("EPS (Latest)".equalsIgnoreCase(tblDataTable.getColumnName(column).toString())) {
                    if (tblDataTable.getValueAt(row, 0) != null) {
                        if (!tblDataTable.getValueAt(row, 0).toString().equalsIgnoreCase("")) {
                            cell.setText(" " + val + " ");
                            cell.setHorizontalAlignment(4);
                            cell.setForeground(this.mehndiColor);
                            cell.setFont(cell.getFont().deriveFont(1));
                        } else {
                            cell.setText("");
                        }
                    }
                } else if ("EPS (Est)".equalsIgnoreCase(tblDataTable.getColumnName(column).toString())) {
                    if (tblDataTable.getValueAt(row, 0) != null) {
                        if (!tblDataTable.getValueAt(row, 0).toString().equalsIgnoreCase("")) {
                            cell.setText(Util.format0digit((String)val) + " ");
                            cell.setHorizontalAlignment(4);
                            cell.setForeground(this.greenColor);
                            cell.setFont(cell.getFont().deriveFont(1));
                        } else {
                            cell.setText("");
                        }
                    }
                } else if ("Book Value".equalsIgnoreCase(tblDataTable.getColumnName(column).toString())) {
                    if (tblDataTable.getValueAt(row, 0) != null) {
                        if (!tblDataTable.getValueAt(row, 0).toString().equalsIgnoreCase("")) {
                            cell.setText(" " + val + " ");
                            cell.setHorizontalAlignment(4);
                            cell.setForeground(Color.BLACK);
                            cell.setFont(cell.getFont().deriveFont(1));
                        } else {
                            cell.setText("");
                        }
                    }
                } else if ("52 W\nHigh".equalsIgnoreCase(tblDataTable.getColumnName(column).toString())) {
                    if (tblDataTable.getValueAt(row, 0) != null) {
                        if (!tblDataTable.getValueAt(row, 0).toString().equalsIgnoreCase("")) {
                            cell.setText(Util.format2digit((String)val) + " ");
                            cell.setHorizontalAlignment(4);
                            cell.setForeground(Color.BLACK);
                            cell.setFont(FundamentalForm.this.plainFont);
                        } else {
                            cell.setText("");
                        }
                    }
                } else if ("52 W\nLow".equalsIgnoreCase(tblDataTable.getColumnName(column).toString()) && tblDataTable.getValueAt(row, 0) != null) {
                    if (!tblDataTable.getValueAt(row, 0).toString().equalsIgnoreCase("")) {
                        cell.setText(Util.format2digit((String)val) + " ");
                        cell.setHorizontalAlignment(4);
                        cell.setForeground(Color.BLACK);
                        cell.setFont(FundamentalForm.this.plainFont);
                    } else {
                        cell.setText("");
                    }
                }
                if (row % 2 == 0) {
                    cell.setBackground(MyColors.cellRenderEven);
                } else {
                    cell.setBackground(MyColors.cellRenderOdd);
                }
                if (isSelected) {
                    cell.setBackground(MyColors.SelectionFG);
                }
                return cell;
            }
        });
    }

    public String GetFeed(String symbol, String eps) {
        String feed = "";
        String logFeed = "";
        if (this.symbolMap.containsKey(symbol)) {
            feed = this.symbolMap.get(symbol) + "";
            feed = feed == null || feed.equals("") || feed.equalsIgnoreCase("Null") ? feed + symbol + ";;;;;;;;;;;" : (epsSt == null ? feed + ";" : feed + epsSt + ";");
            logFeed = logFeed + feed + "|";
        } else {
            logFeed = symbol + ";;;;;;;;;;;|";
        }
        return logFeed;
    }

    public void addSymbolInMarketWatch(String symbolList) {
        String symbol2 = symbolList;
        String withmarket = "";
        String[] symbol = symbol2.split(";");
        for (int i = 0; i < symbol.length; ++i) {
            if (symbol[i].equalsIgnoreCase("")) continue;
            withmarket = withmarket + symbol[i] + ":" + UtilKSE.GetMarketFromsymbol((String)symbol[i]) + ";";
        }
        this.mediator.sendFeedSymbols(withmarket, "Fundatental (For SC): addSymbolInMarketWatch ");
    }

    public void removeSymbolFormFeed() {
        this.mediator.sendFeedSymbols("", "Fundatental (For SC): removeSymbolFormFeed ");
    }

    private double GetCurrentRate(String symbol) {
        double rate = 0.0;
        MarketFeed mktFeed = this.mediator.MwPanel.GetSingleFeed(symbol, UtilKSE.GetMarketFromsymbol((String)symbol));
        if (mktFeed != null) {
            rate = Double.parseDouble(mktFeed.lTrdPrice);
        }
        return rate;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tblFundamentals = new JTable();
        this.lblScripName = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.btnRefresh = new JButton();
        this.lblMessage = new JLabel();
        this.lblTime = new JLabel();
        this.jScrollPane1.setName("jScrollPane1");
        this.tblFundamentals.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null, null, null, null, null, null, null, null}}, new String[]{"Symbol*", "Current", "PE(L.A)", "PE(C.AZ)", "PE(Est)", "EPS(Last Annual)", "EPS(Latest)", "EPS(Est)", "Book Value", "52 W High", "52 W Low", "Detail"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, Object.class, Object.class, Object.class, Object.class, Object.class, Object.class, Integer.class, Object.class, Object.class, Object.class, Object.class};
                this.canEdit = new boolean[]{true, false, false, false, false, false, false, true, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tblFundamentals.setName("tblFundamentals");
        this.tblFundamentals.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FundamentalForm.this.tblFundamentalsMouseClicked(evt);
            }
        });
        this.tblFundamentals.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                FundamentalForm.this.tblFundamentalsKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tblFundamentals);
        this.lblScripName.setText(" ");
        this.lblScripName.setName("lblScripName");
        this.jSeparator1.setName("jSeparator1");
        this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/Images/refresh.png")));
        this.btnRefresh.setText("Refresh");
        this.btnRefresh.setName("FundamentalForm -> btnRefresh");
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FundamentalForm.this.btnRefreshActionPerformed(evt);
            }
        });
        this.lblMessage.setText("Message");
        this.lblMessage.setName("lblMessage");
        this.lblTime.setIcon(new ImageIcon(this.getClass().getResource("/Images/lastUpdateTime16.png")));
        this.lblTime.setText("Last updated Time 88:88:88 PKT");
        this.lblTime.setName("lblTime");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.lblScripName, -1, 267, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblMessage, -2, 165, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblTime, -2, 184, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRefresh).addContainerGap()).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING, -1, 751, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 751, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 245, Short.MAX_VALUE).addGap(3, 3, 3).addComponent(this.jSeparator1, -2, -1, -2).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnRefresh).addComponent(this.lblTime).addComponent(this.lblMessage)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.lblScripName).addGap(4, 4, 4)))));
    }

    private void tblFundamentalsMouseClicked(MouseEvent evt) {
        JTable table_ = (JTable)evt.getSource();
        this.removeSymbol = table_.getValueAt(table_.getSelectedRow(), 0) + "";
        TableColumnModel colModel = table_.getColumnModel();
        int vColIndex = colModel.getColumnIndexAtX(evt.getX());
        int mColIndex = this.tblFundamentals.convertColumnIndexToModel(vColIndex);
        if ("Details".equalsIgnoreCase(this.tblFundamentals.getColumnName(mColIndex).toString())) {
            try {
                String symbol = this.tblFundamentals.getValueAt(this.tblFundamentals.getSelectedRow(), 0).toString();
                if (!symbol.equalsIgnoreCase("")) {
                    Desktop.getDesktop().browse(URI.create(AppConfig.fundamentalURL + symbol + "&days=30"));
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.mediator.PrintLog(ex, "");
            }
        }
    }

    private void tblFundamentalsKeyPressed(KeyEvent evt) {
    }

    private void btnRefreshActionPerformed(ActionEvent evt) {
        this.loadPrefrences();
    }
}

