/*
 * Decompiled with CFR 0.152.
 */
package SC;

import CustomComponent.MyTime;
import MyDocking.Mediator;
import SC.TransactionHistoryBean;
import Utilities.LogsTC;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.util.AppConfig;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.JXDatePicker;

public class TransactionHistory
extends JPanel {
    DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    Color sellFG = new Color(153, 128, 54);
    Color buyFG = new Color(18, 117, 166);
    public static Font defaultBoldFont = new Font("Tahoma", 1, 11);
    String[] columnNames = new String[]{"Transaction No", "Trade Date", "Scrip", "Buy Qty", "Sell Qty", "Rate", "Buy Amount", "Sell Amount", "Commission", "Taxes", "Charges", "Amount"};
    public Vector rows = new Vector();
    Vector columns = new Vector();
    public final int iTRNO = 0;
    public final int iTradeDate = 1;
    public final int iSymbol = 2;
    public final int iBuyQuantity = 3;
    public final int iSellQuantity = 4;
    public final int iRate = 5;
    public final int iBuyAmount = 6;
    public final int iSellAmount = 7;
    public final int iCommission = 8;
    public final int iTaxes = 9;
    public final int iCharges = 10;
    public final int iAmount = 11;
    Mediator mediator = Mediator.getInstance();
    TranHistoryModel model = new TranHistoryModel();
    ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    Thread thear1 = new Thread(new Thread(){

        @Override
        public void run() {
        }
    });
    private JButton btnGet;
    private JComboBox cbAccountNo;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblMessage;
    private JTable table;
    private JXDatePicker txtEndDate;
    private JXDatePicker txtStartDate;

    public TransactionHistory() {
        this.initComponents();
        this.txtStartDate.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.txtEndDate.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.table.getTableHeader().setReorderingAllowed(false);
        this.columns = new Vector();
        this.rows = new Vector();
        for (int i = 0; i < this.columnNames.length; ++i) {
            this.columns.addElement(this.columnNames[i]);
        }
        this.table.setModel(this.model);
        this.model.DefualtSort();
        this.setAccounts();
        this.setTable();
        this.setRender();
        this.setSorter();
    }

    public void removeTable() {
        if (this.model != null) {
            this.rows.clear();
        }
    }

    public synchronized void fillTable2(String result) {
        this.lblMessage.setForeground(Color.BLACK);
        this.removeTable();
        if (result.indexOf("=") >= 0) {
            String[] str1 = result.split("=");
            String[] Row2 = str1[1].split("\\|", -1);
            for (int rowCount = 0; rowCount < Row2.length - 1; ++rowCount) {
                this.rows.addElement(this.parse(Row2[rowCount].split("\\;", -1)));
            }
            this.model.refresh();
            this.lblMessage.setText(Util.format0digit((String)(this.model.getRowCount() + "")) + " Record(s)");
            this.lblMessage.setIcon(null);
        } else {
            this.lblMessage.setText(result);
            this.lblMessage.setIcon(null);
        }
        this.table.setModel(this.model);
        this.model.DefualtSort();
    }

    public TransactionHistoryBean parse(String[] data) {
        TransactionHistoryBean tb = new TransactionHistoryBean();
        tb.TRNO = data[0];
        tb.TradeDate = data[1];
        tb.Symbol = data[2];
        try {
            tb.BuyQuantity = Double.parseDouble(data[3]);
        }
        catch (NumberFormatException ex) {
            tb.BuyQuantity = 0.0;
        }
        try {
            tb.SellQuantity = Math.abs(Double.parseDouble(data[4]));
        }
        catch (NumberFormatException ex) {
            tb.SellQuantity = 0.0;
        }
        try {
            tb.Rate = Double.parseDouble(data[5]);
        }
        catch (NumberFormatException ex) {
            tb.Rate = 0.0;
        }
        try {
            tb.BuyAmount = Double.parseDouble(data[6]);
        }
        catch (NumberFormatException ex) {
            tb.BuyAmount = 0.0;
        }
        try {
            tb.SellAmount = Math.abs(Double.parseDouble(data[7]));
        }
        catch (NumberFormatException ex) {
            tb.SellAmount = 0.0;
        }
        try {
            tb.Commission = Double.parseDouble(data[8]);
        }
        catch (NumberFormatException ex) {
            tb.Commission = 0.0;
        }
        try {
            tb.Taxes = Double.parseDouble(data[9]);
        }
        catch (NumberFormatException ex) {
            tb.Taxes = 0.0;
        }
        try {
            tb.Charges = Double.parseDouble(data[10]);
        }
        catch (NumberFormatException ex) {
            tb.Charges = 0.0;
        }
        try {
            tb.Amount = Double.parseDouble(data[11]);
        }
        catch (NumberFormatException ex) {
            tb.Amount = 0.0;
        }
        return tb;
    }

    public void setAccounts() {
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(LogsTC.accountAll.keySet().toArray()));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])LogsTC.accountAll.keySet().toArray()));
        this.removeTable();
        this.lblMessage.setText(" ");
        this.lblMessage.setIcon(null);
        this.txtStartDate.setDate(MyTime.getInstance().getDate2());
        this.txtEndDate.setDate(MyTime.getInstance().getDate2());
    }

    private void getData() {
        if (this.cbAccountNo.getSelectedItem() == null) {
            this.lblMessage.setForeground(Color.RED);
            this.lblMessage.setText("Please select account.");
            this.lblMessage.setIcon(null);
            this.cbAccountNo.requestFocus();
            return;
        }
        if (this.cbAccountNo.getSelectedItem().toString().trim().length() <= 0 || this.cbAccountNo.getSelectedItem().toString().equalsIgnoreCase("")) {
            this.lblMessage.setForeground(Color.RED);
            this.lblMessage.setText("Please select account.");
            this.lblMessage.setIcon(null);
            this.cbAccountNo.requestFocus();
            return;
        }
        if (this.txtStartDate.getDate() == null) {
            this.lblMessage.setForeground(Color.RED);
            this.lblMessage.setText("Please select Start date.");
            this.lblMessage.setIcon(null);
            this.txtStartDate.requestFocus();
            return;
        }
        if (this.txtEndDate.getDate() == null) {
            this.lblMessage.setForeground(Color.RED);
            this.lblMessage.setText("Please select End date.");
            this.lblMessage.setIcon(null);
            this.txtStartDate.requestFocus();
            return;
        }
        if (!this.txtStartDate.getDate().before(this.txtEndDate.getDate())) {
            this.lblMessage.setForeground(Color.RED);
            this.lblMessage.setText("Start date should be less then or equal to end date.");
            this.lblMessage.setIcon(null);
            this.txtStartDate.requestFocus();
            return;
        }
        this.lblMessage.setText("Please wait while loading");
        this.lblMessage.setIcon(null);
        this.lblMessage.setIcon(this.loaderIcon);
        new Thread(this.thear1).start();
    }

    private void setRender() {
        for (int k = 0; k < this.table.getColumnModel().getColumnCount(); ++k) {
            this.table.getColumn(this.columns.elementAt(k)).setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel cell = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    cell.setForeground(Color.BLACK);
                    String stCol = table.getColumnModel().getColumn(column).getIdentifier().toString();
                    if (value == null) {
                        value = "";
                    }
                    if (stCol.equalsIgnoreCase("Transaction No")) {
                        cell.setText(" " + Util.format0digit((String)value.toString().trim()) + " ");
                        cell.setHorizontalAlignment(2);
                    } else if (stCol.equalsIgnoreCase("Trade Date")) {
                        cell.setText(" " + value.toString().trim() + " ");
                        cell.setHorizontalAlignment(2);
                    } else if (stCol.equalsIgnoreCase("Scrip")) {
                        cell.setText(" " + value + " ");
                        cell.setHorizontalAlignment(2);
                    } else if (stCol.equalsIgnoreCase("Buy Qty")) {
                        cell.setText(" " + Util.format0digit((String)value.toString().trim()) + " ");
                        cell.setHorizontalAlignment(4);
                    } else if (stCol.equalsIgnoreCase("Sell Qty")) {
                        cell.setText(" " + Util.format0digit((String)value.toString().trim()) + " ");
                        cell.setHorizontalAlignment(4);
                    } else if (stCol.equalsIgnoreCase("Rate")) {
                        cell.setText(" " + Util.format2digit((String)value.toString().trim()) + " ");
                        cell.setHorizontalAlignment(4);
                    } else if (stCol.equalsIgnoreCase("Buy Amount")) {
                        cell.setText(" " + Util.format2digit((String)value.toString().trim()) + " ");
                        cell.setHorizontalAlignment(4);
                    } else if (stCol.equalsIgnoreCase("Sell Amount")) {
                        cell.setText(" " + Util.format2digit((String)value.toString().trim()) + " ");
                        cell.setHorizontalAlignment(4);
                    } else if (stCol.equalsIgnoreCase("Commission")) {
                        cell.setText(" " + Util.format2digit((String)value.toString().trim()) + " ");
                        cell.setHorizontalAlignment(4);
                    } else if (stCol.equalsIgnoreCase("Taxes")) {
                        cell.setText(" " + Util.format2digit((String)value.toString().trim()) + " ");
                        cell.setHorizontalAlignment(4);
                    } else if (stCol.equalsIgnoreCase("Charges")) {
                        cell.setText(" " + Util.format2digit((String)value.toString().trim()) + " ");
                        cell.setHorizontalAlignment(4);
                    } else if (stCol.equalsIgnoreCase("Amount")) {
                        cell.setText(" " + Util.format2digit((String)value.toString().trim()) + " ");
                        cell.setHorizontalAlignment(4);
                    }
                    if (row % 2 == 0) {
                        cell.setBackground(MyColors.cellRenderEven);
                    } else {
                        cell.setBackground(MyColors.cellRenderOdd);
                    }
                    String val = table.getValueAt(row, 1).toString();
                    if (val.equalsIgnoreCase("Total")) {
                        if (stCol.equalsIgnoreCase("Transaction No") || stCol.equalsIgnoreCase("Rate") || stCol.equalsIgnoreCase("Taxes") || stCol.equalsIgnoreCase("Charges") || stCol.equalsIgnoreCase("Amount")) {
                            cell.setText("");
                        }
                        if (stCol.equalsIgnoreCase("Scrip")) {
                            cell.setText(" " + Util.format2digit((String)value.toString().trim()) + " ");
                            cell.setHorizontalAlignment(4);
                            cell.setForeground(TransactionHistory.this.sellFG);
                        } else if (stCol.equalsIgnoreCase("Sell Qty")) {
                            cell.setText(" " + Util.format2digit((String)value.toString().trim()) + " ");
                            cell.setHorizontalAlignment(4);
                            cell.setForeground(TransactionHistory.this.sellFG);
                        } else if (stCol.equalsIgnoreCase("Buy Amount")) {
                            cell.setText(" " + Util.format2digit((String)value.toString().trim()) + " ");
                            cell.setHorizontalAlignment(4);
                            cell.setForeground(TransactionHistory.this.buyFG);
                        } else if (stCol.equalsIgnoreCase("Commission")) {
                            cell.setText(" " + Util.format2digit((String)value.toString().trim()) + " ");
                            cell.setHorizontalAlignment(4);
                            cell.setForeground(TransactionHistory.this.buyFG);
                        } else if (stCol.equalsIgnoreCase("Buy Qty")) {
                            cell.setText(" " + Util.format0digit((String)value.toString().trim()) + " ");
                            cell.setHorizontalAlignment(4);
                            cell.setForeground(TransactionHistory.this.sellFG);
                        } else if (stCol.equalsIgnoreCase("Sell Amount")) {
                            cell.setText(" " + Util.format0digit((String)value.toString().trim()) + " ");
                            cell.setHorizontalAlignment(4);
                            cell.setForeground(TransactionHistory.this.buyFG);
                        }
                        cell.setFont(cell.getFont().deriveFont(1));
                        cell.setBackground(MyColors.TotalBG);
                    }
                    if (val.equalsIgnoreCase("Grand Total")) {
                        if (stCol.equalsIgnoreCase("Transaction No") || stCol.equalsIgnoreCase("Rate") || stCol.equalsIgnoreCase("Buy Amount") || stCol.equalsIgnoreCase("Taxes") || stCol.equalsIgnoreCase("Charges") || stCol.equalsIgnoreCase("Amount")) {
                            cell.setText("");
                        }
                        if (stCol.equalsIgnoreCase("Sell Qty")) {
                            cell.setText(" " + Util.format2digit((String)value.toString().trim()) + " ");
                            cell.setHorizontalAlignment(4);
                            cell.setForeground(TransactionHistory.this.sellFG);
                        } else if (stCol.equalsIgnoreCase("Commission")) {
                            cell.setText(" " + Util.format2digit((String)value.toString().trim()) + " ");
                            cell.setHorizontalAlignment(4);
                            cell.setForeground(TransactionHistory.this.buyFG);
                        } else if (stCol.equalsIgnoreCase("Buy Qty")) {
                            cell.setText(" " + Util.format0digit((String)value.toString().trim()) + " ");
                            cell.setHorizontalAlignment(4);
                            cell.setForeground(TransactionHistory.this.sellFG);
                        } else if (stCol.equalsIgnoreCase("Sell Amount")) {
                            cell.setText(" " + Util.format0digit((String)value.toString().trim()) + " ");
                            cell.setHorizontalAlignment(4);
                            cell.setForeground(TransactionHistory.this.buyFG);
                        }
                        cell.setFont(cell.getFont().deriveFont(1));
                        cell.setBackground(MyColors.TotalBG);
                    }
                    if (isSelected) {
                        cell.setBackground(MyColors.SelectionFG);
                    }
                    return cell;
                }
            });
        }
    }

    private void setTable() {
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoCreateRowSorter(false);
        JTableHeader header = this.table.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
        int i = 0;
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(75);
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(90);
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(90);
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(90);
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(90);
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(i++).setPreferredWidth(90);
    }

    public void setSorter() {
        JTableHeader header = this.table.getTableHeader();
        TranHistoryModel tranHistoryModel = this.model;
        tranHistoryModel.getClass();
        header.addMouseListener(tranHistoryModel.new TranHistoryModel.ColumnListener(this.table));
        header.setReorderingAllowed(false);
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
    }

    private void initComponents() {
        this.jSeparator1 = new JSeparator();
        this.lblMessage = new JLabel();
        this.jLabel1 = new JLabel();
        this.cbAccountNo = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.btnGet = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.txtStartDate = new JXDatePicker();
        this.txtEndDate = new JXDatePicker();
        this.jSeparator1.setName("jSeparator1");
        this.lblMessage.setText(" ");
        this.lblMessage.setName("lblMessage");
        this.jLabel1.setText("Account");
        this.jLabel1.setName("jLabel1");
        this.cbAccountNo.setEditable(true);
        this.cbAccountNo.setName("cbAccountNo");
        this.cbAccountNo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TransactionHistory.this.cbAccountNoItemStateChanged(evt);
            }
        });
        this.jLabel2.setText("Start Date");
        this.jLabel2.setName("jLabel2");
        this.jLabel3.setText("End Date");
        this.jLabel3.setName("jLabel3");
        this.btnGet.setIcon(new ImageIcon(this.getClass().getResource("/Images/get.png")));
        this.btnGet.setText("Get");
        this.btnGet.setName("TransactionHistory -> btnGet");
        this.btnGet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TransactionHistory.this.btnGetActionPerformed(evt);
            }
        });
        this.jScrollPane1.setName("jScrollPane1");
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null, null, null, null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4", "null", "null", "null", "null", "null", "null", "null"}){
            Class[] types;
            {
                this.types = new Class[]{Object.class, Object.class, Object.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.table.setName("table");
        this.jScrollPane1.setViewportView(this.table);
        this.txtStartDate.setName("txtStartDate");
        this.txtEndDate.setName("txtEndDate");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMessage, -2, 550, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 53, -2).addGap(2, 2, 2).addComponent(this.cbAccountNo, -2, 79, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.txtStartDate, -2, -1, -2).addGap(7, 7, 7).addComponent(this.jLabel3).addGap(5, 5, 5).addComponent((Component)this.txtEndDate, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnGet))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.cbAccountNo, -2, 22, -2).addComponent(this.jLabel2, -2, 18, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3, -2, 18, -2).addComponent((Component)this.txtStartDate, -2, -1, -2).addComponent((Component)this.txtEndDate, -2, -1, -2)).addComponent(this.btnGet, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 238, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMessage, -2, 17, -2)));
        layout.linkSize(1, this.btnGet, this.cbAccountNo, this.jLabel1, this.jLabel2, this.jLabel3);
    }

    private void btnGetActionPerformed(ActionEvent evt) {
        this.getData();
    }

    private void cbAccountNoItemStateChanged(ItemEvent evt) {
        this.getData();
    }

    private void deleteSummrayRows(Vector rows) {
        for (int i = 0; i < rows.size(); ++i) {
            TransactionHistoryBean tb = (TransactionHistoryBean)rows.get(i);
            if (tb.TradeDate.indexOf("Total") < 0) continue;
            rows.removeElementAt(i);
            --i;
        }
    }

    private Vector update2(Vector rows) {
        TransactionHistoryBean tb;
        Vector<TransactionHistoryBean> temp = new Vector<TransactionHistoryBean>();
        String oldSymbol = "";
        String Symbol = "";
        double BuyQuantity = 0.0;
        double BuyAmount = 0.0;
        double SellQuantity = 0.0;
        double SellAmount = 0.0;
        double GBuyQuantity = 0.0;
        double GBuyAmount = 0.0;
        double GSellQuantity = 0.0;
        double GSellAmount = 0.0;
        if (rows != null || rows.size() > 0) {
            tb = (TransactionHistoryBean)rows.get(0);
            oldSymbol = tb.Symbol;
        }
        for (int i = 0; i <= rows.size(); ++i) {
            TransactionHistoryBean tb1;
            if (i == rows.size()) {
                tb1 = new TransactionHistoryBean();
                tb1.SellAmount = BuyQuantity;
                tb1.BuyQuantity = SellQuantity;
                tb1.Charges = 0.0;
                tb1.Rate = 0.0;
                tb1.Amount = 0.0;
                tb1.Commission = BuyAmount;
                tb1.SellQuantity = SellAmount;
                try {
                    tb1.BuyAmount = BuyAmount / BuyQuantity;
                    if (Double.isNaN(tb1.BuyAmount) || Double.isInfinite(tb1.BuyAmount)) {
                        tb1.BuyAmount = 0.0;
                    }
                }
                catch (Exception ex) {
                    tb1.BuyAmount = 0.0;
                }
                try {
                    double res = SellAmount / SellQuantity;
                    tb1.Symbol = res + "";
                    if (Double.isNaN(res) || Double.isInfinite(res)) {
                        tb1.Symbol = "0";
                    }
                }
                catch (Exception ex) {
                    tb1.Symbol = "0";
                }
                tb1.TRNO = "";
                tb1.Taxes = SellAmount;
                tb1.TradeDate = "Total";
                BuyAmount = 0.0;
                BuyQuantity = 0.0;
                SellAmount = 0.0;
                SellQuantity = 0.0;
                temp.addElement(tb1);
                TransactionHistoryBean tb2 = new TransactionHistoryBean();
                tb2.Amount = 0.0;
                tb2.BuyAmount = 0.0;
                tb2.BuyQuantity = GSellQuantity;
                tb2.Commission = GBuyAmount;
                tb2.Charges = 0.0;
                tb2.Rate = 0.0;
                tb2.SellAmount = GBuyQuantity;
                tb2.SellQuantity = GSellAmount;
                tb2.Symbol = "";
                tb2.TRNO = "";
                tb2.Taxes = 0.0;
                tb2.TradeDate = "Grand Total";
                GBuyAmount = 0.0;
                GBuyQuantity = 0.0;
                GSellAmount = 0.0;
                GSellQuantity = 0.0;
                temp.addElement(tb2);
                return temp;
            }
            tb = (TransactionHistoryBean)rows.get(i);
            if (oldSymbol.equalsIgnoreCase(tb.Symbol)) {
                BuyQuantity += tb.BuyQuantity;
                BuyAmount += tb.BuyAmount;
                SellQuantity += tb.SellQuantity;
                SellAmount += tb.SellAmount;
                GBuyAmount += tb.BuyAmount;
                GBuyQuantity += tb.BuyQuantity;
                GSellQuantity += tb.SellQuantity;
                GSellAmount += tb.SellAmount;
                temp.addElement(tb);
            } else {
                --i;
                tb1 = new TransactionHistoryBean();
                tb1.SellAmount = BuyQuantity;
                tb1.BuyQuantity = SellQuantity;
                tb1.Charges = 0.0;
                tb1.Rate = 0.0;
                tb1.Amount = 0.0;
                tb1.Commission = BuyAmount;
                tb1.SellQuantity = SellAmount;
                try {
                    tb1.BuyAmount = BuyAmount / BuyQuantity;
                    if (Double.isNaN(tb1.BuyAmount) || Double.isInfinite(tb1.BuyAmount)) {
                        tb1.BuyAmount = 0.0;
                    }
                }
                catch (Exception ex) {
                    tb1.BuyAmount = 0.0;
                }
                try {
                    double res = SellAmount / SellQuantity;
                    tb1.Symbol = res + "";
                    if (Double.isNaN(res) || Double.isInfinite(res)) {
                        tb1.Symbol = "0";
                    }
                }
                catch (Exception ex) {
                    tb1.Symbol = "0";
                }
                tb1.TRNO = "";
                tb1.Taxes = SellAmount;
                tb1.TradeDate = "Total";
                temp.addElement(tb1);
                BuyAmount = 0.0;
                BuyQuantity = 0.0;
                SellAmount = 0.0;
                SellQuantity = 0.0;
            }
            oldSymbol = tb.Symbol;
        }
        return temp;
    }

    class TranHistoryComparator
    implements Comparator {
        protected int m_sortCol;
        protected boolean m_sortAsc;

        public TranHistoryComparator(int sortCol, boolean sortAsc) {
            this.m_sortCol = sortCol;
            this.m_sortAsc = sortAsc;
        }

        public int compare(Object o1, Object o2) {
            TransactionHistoryBean s1 = null;
            TransactionHistoryBean s2 = null;
            if (o1 instanceof TransactionHistoryBean && o2 instanceof TransactionHistoryBean) {
                s1 = (TransactionHistoryBean)o1;
                s2 = (TransactionHistoryBean)o2;
            }
            int result = 0;
            switch (this.m_sortCol) {
                case 0: {
                    result = s1.TRNO.compareTo(s2.TRNO);
                    break;
                }
                case 11: {
                    double d1 = s1.Amount;
                    double d2 = s2.Amount;
                    result = d1 < d2 ? -1 : (d1 > d2 ? 1 : 0);
                    break;
                }
                case 6: {
                    double d1 = s1.BuyAmount;
                    double d2 = s2.BuyAmount;
                    result = d1 < d2 ? -1 : (d1 > d2 ? 1 : 0);
                    break;
                }
                case 3: {
                    double d1 = s1.BuyQuantity;
                    double d2 = s2.BuyQuantity;
                    result = d1 < d2 ? -1 : (d1 > d2 ? 1 : 0);
                    break;
                }
                case 10: {
                    double d1 = s1.Charges;
                    double d2 = s2.Charges;
                    result = d1 < d2 ? -1 : (d1 > d2 ? 1 : 0);
                    break;
                }
                case 8: {
                    double d1 = s1.Commission;
                    double d2 = s2.Commission;
                    result = d1 < d2 ? -1 : (d1 > d2 ? 1 : 0);
                    break;
                }
                case 5: {
                    double d1 = s1.Rate;
                    double d2 = s2.Rate;
                    result = d1 < d2 ? -1 : (d1 > d2 ? 1 : 0);
                    break;
                }
                case 7: {
                    double d1 = s1.SellAmount;
                    double d2 = s2.SellAmount;
                    result = d1 < d2 ? -1 : (d1 > d2 ? 1 : 0);
                    break;
                }
                case 4: {
                    double d1 = s1.SellQuantity;
                    double d2 = s2.SellQuantity;
                    result = d1 < d2 ? -1 : (d1 > d2 ? 1 : 0);
                    break;
                }
                case 2: {
                    result = s1.Symbol.compareTo(s2.Symbol);
                    break;
                }
                case 9: {
                    double d1 = s1.Taxes;
                    double d2 = s2.Taxes;
                    result = d1 < d2 ? -1 : (d1 > d2 ? 1 : 0);
                    break;
                }
                case 1: {
                    result = s1.TradeDate.compareTo(s2.TradeDate);
                }
            }
            if (!this.m_sortAsc) {
                result = -result;
            }
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof TranHistoryComparator) {
                TranHistoryComparator compObj = (TranHistoryComparator)obj;
                return compObj.m_sortCol == this.m_sortCol && compObj.m_sortAsc == this.m_sortAsc;
            }
            return false;
        }
    }

    class TranHistoryModel
    extends AbstractTableModel {
        protected int sortCol = 0;
        protected boolean isSortAsc = true;
        protected int m_result = 0;
        protected int columnsCount = 1;
        public Hashtable<String, TransactionHistoryBean> ht = new Hashtable();
        Class[] types = new Class[]{Object.class, Object.class, Object.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class};

        TranHistoryModel() {
        }

        public Class getColumnClass(int columnIndex) {
            return this.types[columnIndex];
        }

        public void refresh() {
            super.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return TransactionHistory.this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return TransactionHistory.this.rows == null ? 0 : TransactionHistory.this.rows.size();
        }

        @Override
        public String getColumnName(int col) {
            return TransactionHistory.this.columnNames[col];
        }

        @Override
        public Object getValueAt(int nRow, int nCol) {
            if (nRow < 0 || nRow >= this.getRowCount()) {
                return "";
            }
            TransactionHistoryBean row = (TransactionHistoryBean)TransactionHistory.this.rows.elementAt(nRow);
            switch (nCol) {
                case 0: {
                    return row.TRNO;
                }
                case 11: {
                    return row.Amount;
                }
                case 6: {
                    return row.BuyAmount;
                }
                case 3: {
                    return row.BuyQuantity;
                }
                case 10: {
                    return row.Charges;
                }
                case 8: {
                    return row.Commission;
                }
                case 5: {
                    return row.Rate;
                }
                case 7: {
                    return row.SellAmount;
                }
                case 4: {
                    return row.SellQuantity;
                }
                case 2: {
                    return row.Symbol;
                }
                case 9: {
                    return row.Taxes;
                }
                case 1: {
                    return row.TradeDate;
                }
            }
            return row;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }

        public void redraw() {
            this.fireTableStructureChanged();
        }

        public void DefualtSort() {
            Collections.sort(TransactionHistory.this.rows, new TranHistoryComparator(0, true));
            this.refresh();
        }

        class ColumnListener
        extends MouseAdapter {
            protected JTable table;

            public ColumnListener(JTable t) {
                this.table = t;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel colModel = this.table.getColumnModel();
                int columnModelIndex = colModel.getColumnIndexAtX(e.getX());
                int modelIndex = colModel.getColumn(columnModelIndex).getModelIndex();
                if (columnModelIndex == 2) {
                    if (modelIndex < 0) {
                        return;
                    }
                    if (TranHistoryModel.this.sortCol == modelIndex) {
                        TranHistoryModel.this.isSortAsc = !TranHistoryModel.this.isSortAsc;
                    } else {
                        TranHistoryModel.this.sortCol = modelIndex;
                    }
                    for (int i = 0; i < TranHistoryModel.this.columnsCount; ++i) {
                        TableColumn column = colModel.getColumn(i);
                        column.setHeaderValue(TranHistoryModel.this.getColumnName(column.getModelIndex()));
                    }
                    this.table.getTableHeader().repaint();
                    TransactionHistory.this.deleteSummrayRows(TransactionHistory.this.rows);
                    Collections.sort(TransactionHistory.this.rows, new TranHistoryComparator(TranHistoryModel.this.sortCol, TranHistoryModel.this.isSortAsc));
                    TransactionHistory.this.rows = TransactionHistory.this.update2(TransactionHistory.this.rows);
                    this.table.tableChanged(new TableModelEvent(TranHistoryModel.this));
                    this.table.repaint();
                }
            }
        }
    }
}

