/*
 * Decompiled with CFR 0.152.
 */
package Screener;

import Beans.MarketWatchBean;
import CATALYST.Control.MarketFeed;
import CustomComponent.MyOptionPane;
import CustomComponent.MyTime;
import CustomComponent.NxGTextField;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Screener.CompanySnapShotPanel;
import Screener.HistoricalPanel;
import Screener.Loader;
import Utilities.CompressManager;
import Utilities.LogsTC;
import Utilities.UtilTC;
import catalystchart.ChartActionEvent;
import catalystchart.ChartType;
import catalystchart.PnlIntraday;
import common.gui.component.NxGScrollBarUI;
import common.gui.layout.NxGWrapLayout;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.MyColors;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import kse.util.LogsKSE;
import kse.util.UtilKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import login.LoginServer;

public class ChartGraph
extends JPanel {
    JFrame frame = null;
    JDialog window = null;
    private String Market = "";
    private String Symbol = "";
    private boolean isLoading = false;
    private PnlIntraday pnlIntraday;
    Mediator mediator = null;
    Date BuySellLastDate = null;
    double BuySellLastBid = 0.0;
    double BuySellLastAsk = 0.0;
    int num = 0;
    public String feedSymbol = "";
    HistoricalPanel historicalPanel = null;
    CompanySnapShotPanel companySnapShotPanel = null;
    JPanel pnlComp = null;
    Color disableColor = Color.LIGHT_GRAY.brighter();
    final int schDelay = 10000;
    Timer Timer_Buy = new Timer(10000, null);
    Timer Timer_BuyVol = new Timer(10000, null);
    Timer Timer_Sell = new Timer(10000, null);
    Timer Timer_SellVol = new Timer(10000, null);
    boolean isFirstTimeBuy = true;
    boolean isFirstTimeBuyVol = true;
    boolean isFirstTimeSell = true;
    boolean isFirstTimeSellVol = true;
    boolean isUserChangePrice = false;
    ImageIcon icon = null;
    private LanguageCentre languageCentre = new LanguageCentre();
    boolean LoadingThread = false;
    private JLabel jLabel1;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel9;
    private JPanel jPanel4;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JLabel lblAvgValue;
    private JLabel lblChange;
    private JLabel lblChangePercentage;
    private JLabel lblCloseValue;
    private JLabel lblHigh;
    private JLabel lblHighValue;
    private JLabel lblLastTrdPrice;
    private JLabel lblLow;
    private JLabel lblLowValue;
    private JLabel lblMketValues;
    private JLabel lblOSShares;
    private JLabel lblOpen;
    private JLabel lblOpenValue;
    private JLabel lblPerDirection;
    private JLabel lblTotVolPer;
    private JLabel lblTotalVolume;
    private JLabel lblfUpperLimit;
    private JPanel pnlChartRegion;
    private JPanel pnlComapny;
    private JScrollPane scrollPane;
    private NxGTextField txtfLowerLimit;
    private NxGTextField txtfUpperLimit;

    public ChartGraph(int num) {
        this.initComponents();
        this.pnlComp = new JPanel();
        this.num = num;
        this.mediator = Mediator.getInstance();
        this.mediator.setChartGraph(this);
        PnlIntraday.lastChartType = ChartType.PRICEVOLUME;
        this.pnlIntraday = new PnlIntraday();
        this.pnlIntraday.setWaterMarkText(AppConfig.houseName);
        this.pnlChartRegion.add((Component)this.pnlIntraday);
        this.historicalPanel = new HistoricalPanel(this);
        this.companySnapShotPanel = new CompanySnapShotPanel();
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.pnlComapny.setBorder(BorderFactory.createEmptyBorder());
        this.companySnapShotPanel.setBorder(BorderFactory.createEmptyBorder());
        this.setScrollPane();
        this.setCompanyScrollPane();
        this.resetFeedValues();
        this.setDefaultColors();
        this.setForeColor();
    }

    private void ChangeChart() {
        this.pnlIntraday.setWaterMarkText(this.Market + " - " + this.Symbol);
        this.isLoading = true;
        try {
            String returnMessage = "";
            this.mediator.sendFeedSymbols("", "Scrip Deatil: Chart and Graph : ChangeChart()");
            if (PnlIntraday.lastChartType == ChartType.BUYSELL) {
                ArrayList<Date> date = new ArrayList<Date>();
                ArrayList<Double> buy = new ArrayList<Double>();
                ArrayList<Double> sell = new ArrayList<Double>();
                this.pnlIntraday.initializeChart(this.Market, this.Symbol, PnlIntraday.lastChartType);
                returnMessage = this.getData("BuySell", date, buy, sell);
                this.pnlIntraday.setInitialDataForbuySellChart(date, buy, sell);
                this.pnlIntraday.showChart();
                this.pnlIntraday.scrollBarVertical.setVisible(false);
                this.pnlIntraday.addBuySellTick(this.BuySellLastDate, this.BuySellLastBid, this.BuySellLastAsk);
                this.clearRetaInPanel();
            } else if (PnlIntraday.lastChartType == ChartType.PRICEVOLUME) {
                ArrayList<Date> date = new ArrayList<Date>();
                ArrayList<Double> ltrdPrice = new ArrayList<Double>();
                ArrayList<Double> ltrVolume = new ArrayList<Double>();
                this.pnlIntraday.initializeChart(this.Market, this.Symbol, PnlIntraday.lastChartType);
                returnMessage = this.getData("PriceVolume", date, ltrdPrice, ltrVolume);
                this.pnlIntraday.setInitialDataForPriceVolumeChart(date, ltrdPrice, ltrVolume);
                this.pnlIntraday.showChart();
                this.pnlIntraday.scrollBarVertical.setVisible(false);
                this.updateChart();
                this.clearRetaInPanel();
            }
            if (returnMessage.equalsIgnoreCase("Error")) {
                this.isLoading = false;
                MyOptionPane.showMessage(MessageType.Error, "Error in loading data", this.languageCentre.getValue(LanguageConstant.ScripDetail), true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isLoading = false;
    }

    private String getData(String Type2, List<Date> date, List<Double> data1, List<Double> data2) {
        String returnMessage = "OK";
        try {
            if (AppConfig.GraphURL.equalsIgnoreCase("Service")) {
                LoginServer port = WebService.getInstance().getPort();
                byte[] bdata = port.getCompressedData(LogCommon.UserID, "CHART_DATA", this.Symbol + "|" + Type2 + "|" + this.Market);
                String result = CompressManager.unzipStringFromBytes(bdata);
                if (result.indexOf("=") > 0) {
                    SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
                    this.parseData(result, Type2, date, data1, data2, sdf);
                } else if (result.equalsIgnoreCase("No Record(s) found")) {
                    Mediator.getInstance().println("Historical Data not found!");
                }
            } else {
                String result;
                URL url = new URL(AppConfig.GraphURL + "?action=Market&identifier=" + Type2 + "&market=" + this.Market + "&symbol=" + this.Symbol);
                URLConnection yc = url.openConnection();
                BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
                StringBuffer sb = new StringBuffer();
                while ((result = in.readLine()) != null) {
                    sb.append(result);
                }
                in.close();
                result = "=" + sb.toString();
                if (result.length() > 0) {
                    SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
                    this.parseData(result, Type2, date, data1, data2, sdf);
                } else {
                    Mediator.getInstance().println("Historical Data not found!");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            returnMessage = "Error";
        }
        return returnMessage;
    }

    private void parseData(String result, String Type2, List<Date> date, List<Double> data1, List<Double> data2, DateFormat sdf) throws ParseException {
        String Feed_ = result.split("\\=", -1)[1];
        String[] Tick = Feed_.split("\\|", -1);
        for (int i = 0; i < Tick.length; ++i) {
            if (Tick[i].length() <= 0) continue;
            String[] data = Tick[i].split("\\;", -1);
            Date dt = sdf.parse(data[0]);
            double d1 = Double.parseDouble(data[1]);
            double d2 = Double.parseDouble(data[2]);
            date.add(dt);
            data1.add(d1);
            data2.add(d2);
            if (Type2.indexOf("BuySell") < 0) continue;
            this.BuySellLastDate = dt;
            this.BuySellLastBid = d1;
            this.BuySellLastAsk = d2;
        }
    }

    private void resetFeedValues() {
        this.txtfLowerLimit.setText("0");
        this.txtfUpperLimit.setText("0");
        this.isFirstTimeBuyVol = true;
        this.isFirstTimeBuy = true;
        this.isFirstTimeSellVol = true;
        this.isFirstTimeSell = true;
    }

    private void updateChart() {
        try {
            MarketFeed mktFeed = this.mediator.MwPanel.GetSingleFeed(this.Symbol, this.Market);
            if (this.pnlIntraday != null && mktFeed != null) {
                SimpleDateFormat sdf;
                if (PnlIntraday.lastChartType == ChartType.BUYSELL && (LogsKSE.MarketStauts.toUpperCase().indexOf("OHP") >= 0 || LogsKSE.MarketStauts.toUpperCase().indexOf("OPN") >= 0 || LogsKSE.MarketStauts.toUpperCase().indexOf("PRE") >= 0)) {
                    sdf = new SimpleDateFormat("HH:mm:ss");
                    String time = sdf.format(MyTime.getInstance().getDate2());
                    this.pnlIntraday.addBuySellTick(sdf.parse(time), Double.parseDouble(mktFeed.buy), Double.parseDouble(mktFeed.sell));
                }
                if (PnlIntraday.lastChartType == ChartType.PRICEVOLUME) {
                    sdf = new SimpleDateFormat("HH:mm:ss");
                    if (mktFeed.lTrdTime.trim().length() > 0) {
                        this.pnlIntraday.addPriceVolumeTick(sdf.parse(mktFeed.lTrdTime), Double.parseDouble(mktFeed.lTrdPrice), Double.parseDouble(mktFeed.ltrdVolume));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateMarketRate() {
        MarketWatchBean marketBean;
        MarketFeed mktFeed = this.mediator.MwPanel.GetSingleFeed(this.Symbol, this.Market);
        if (mktFeed != null) {
            String cps = this.mediator.logsCommon.getCaps(this.Symbol, this.Market);
            if (cps.length() > 0) {
                this.txtfLowerLimit.setText(Util.format2digit((String)(Double.parseDouble(cps.split(":")[1]) + "")));
                this.txtfUpperLimit.setText(Util.format2digit((String)(Double.parseDouble(cps.split(":")[0]) + "")));
            }
            double lastTradePrice = Double.parseDouble(mktFeed.lTrdPrice);
            double change = Double.parseDouble(mktFeed.change);
            double changePer = change / (lastTradePrice - change) * 100.0;
            long cVol = Mediator.getInstance().exstats.mktVol;
            double totalVolumePercentage = Double.parseDouble(mktFeed.totVolume) / Double.parseDouble(cVol + "") * 100.0;
            this.lblTotVolPer.setText("(" + Util.format2digit((String)(totalVolumePercentage + "")) + " %)");
            this.lblTotalVolume.setText(Util.format0digit((String)mktFeed.totVolume));
            this.lblOpenValue.setText(Util.format2digit((String)mktFeed.openPrice));
            this.lblHighValue.setText(Util.format2digit((String)mktFeed.high));
            this.lblLowValue.setText(Util.format2digit((String)mktFeed.low));
            this.lblCloseValue.setText(Util.format2digit((String)mktFeed.closePrice));
            this.lblAvgValue.setText(Util.format2digit((String)mktFeed.average));
            this.lblLastTrdPrice.setText(Util.format2digit((String)mktFeed.lTrdPrice));
            if (mktFeed.direction.equalsIgnoreCase("=")) {
                this.lblPerDirection.setIcon(new ImageIcon(this.getClass().getResource("/Images/level.png")));
                this.lblChange.setText(Util.format2digit((String)mktFeed.change));
                this.lblChangePercentage.setText("(" + Util.format2digit((String)(change / (lastTradePrice - change) * 100.0 + "")) + " %)");
                this.lblChange.setForeground(Color.blue.brighter());
                this.lblChangePercentage.setForeground(Color.blue.brighter());
            } else if (mktFeed.direction.equalsIgnoreCase("+")) {
                this.lblPerDirection.setIcon(new ImageIcon(this.getClass().getResource("/Images/up.png")));
                this.lblChange.setText(Util.format2digit((String)mktFeed.change));
                this.lblChangePercentage.setText("(" + Util.format2digit((String)(change / (lastTradePrice - change) * 100.0 + "")) + " %)");
                this.lblChange.setForeground(MyColors.cellFGGreen);
                this.lblChangePercentage.setForeground(MyColors.cellFGGreen);
            } else {
                this.lblPerDirection.setIcon(new ImageIcon(this.getClass().getResource("/Images/down.png")));
                this.lblChange.setText(Util.format2digit((String)mktFeed.change));
                this.lblChangePercentage.setText("(" + Util.format2digit((String)(change / (lastTradePrice - change) * 100.0 + "")) + " %)");
                this.lblChange.setForeground(MyColors.errorMessageFG);
                this.lblChangePercentage.setForeground(MyColors.errorMessageFG);
            }
        }
        if ((marketBean = LogsTC.MarketData.get(this.Symbol)) != null) {
            this.lblMketValues.setText(Util.format0digit((String)marketBean.marketcap) + "m");
            this.lblOSShares.setText(Util.format0digit((String)marketBean.outstandingshares) + "m");
            this.lblMketValues.setToolTipText(this.lblMketValues.getText());
            this.lblOSShares.setToolTipText(this.lblOSShares.getText());
        }
    }

    private void setForeColor() {
        this.lblOpen.setForeground(MyColors.AverageMW);
        this.lblHigh.setForeground(MyColors.HighMW);
        this.lblLow.setForeground(MyColors.LowMW);
        this.lblTotalVolume.setForeground(MyColors.LeaderFontGB);
        this.lblOpenValue.setForeground(MyColors.AverageMW);
        this.lblHighValue.setForeground(MyColors.HighMW);
        this.lblLowValue.setForeground(MyColors.LowMW);
        this.lblAvgValue.setForeground(MyColors.AverageMW);
    }

    private void setDefaultColors() {
        this.txtfUpperLimit.setDisabledTextColor(MyColors.HighMW);
        this.txtfLowerLimit.setDisabledTextColor(MyColors.LowMW);
    }

    private void clearRetaInPanel() {
        Color color = Color.BLUE;
    }

    public void ChartChanged(String str) {
        this.InitilizeWindow();
    }

    public void ZoomIn(ChartActionEvent e) {
        this.pnlIntraday.ZoomIn(e);
    }

    public void ZoomOut(ChartActionEvent e) {
        this.pnlIntraday.ZoomOut(e);
    }

    public void ResetZoom(ChartActionEvent e) {
        this.pnlIntraday.ResetZoom(e);
    }

    public void setInterval(ChartActionEvent e) {
        this.pnlIntraday.setInterval(e);
    }

    public void setChartType(ChartActionEvent e) {
        PnlIntraday.lastChartType = e.getChartType();
        this.InitilizeWindow();
    }

    public void AddIndicator(ChartActionEvent e) {
        this.pnlIntraday.AddIndicator(e);
    }

    private void setTitle() {
        if (this.frame != null) {
            if (PnlIntraday.lastChartType == ChartType.PRICEVOLUME) {
                this.frame.setTitle(this.Symbol + " - Price / Volume Chart");
            } else {
                this.frame.setTitle(this.Symbol + " - Buy / Sell Chart");
            }
        } else if (this.window != null) {
            if (PnlIntraday.lastChartType == ChartType.PRICEVOLUME) {
                this.window.setTitle(this.Symbol + " - Price / Volume Chart");
            } else {
                this.window.setTitle(this.Symbol + " - Buy / Sell Chart");
            }
        }
    }

    public void InitilizeWindow() {
        if (this.LoadingThread) {
            return;
        }
        this.LoadingThread = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                ChartGraph.this.ChangeChart();
                ChartGraph.this.LoadingThread = false;
            }
        }).start();
    }

    public void showInFrmae() {
        this.frame = new JFrame();
        this.frame.setIconImage(AppConfig.houseIcon);
        this.frame.setMinimumSize(new Dimension(770, 500));
        this.frame.setDefaultCloseOperation(2);
        this.window.remove(this);
        this.frame.add(this);
        this.frame.setLocation(this.window.getLocation());
        this.frame.setSize(this.window.getSize());
        this.frame.validate();
        this.window.setVisible(false);
        this.window.validate();
        this.window.dispose();
        this.window = null;
        this.setTitle();
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = this.frame.getRootPane().getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        this.frame.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChartGraph.this.frame.dispose();
            }
        });
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                if (ChartGraph.this.frame != null) {
                    TradeCast.getInstance().GraphWindowHolder.remove(ChartGraph.this.num);
                    LogsTC.GraphSymbol.remove(ChartGraph.this.Symbol);
                }
                if (ChartGraph.this.frame != null) {
                    TradeCast.getInstance().SaveSizeAndLocation(FormName.GraphsAndCharts, ChartGraph.this.frame.getSize(), ChartGraph.this.frame.getLocation());
                }
            }
        });
        TradeCast.getInstance().GraphWindowHolder.put(this.num, this);
        this.frame.setVisible(true);
    }

    public void dispose() {
        if (this.frame != null) {
            this.frame.dispose();
        }
        if (this.window != null) {
            this.window.dispose();
        }
    }

    public JDialog showInJDialog() {
        this.window = new JDialog(TradeCast.getInstance().frame);
        this.window.setMinimumSize(new Dimension(770, 500));
        this.window.setDefaultCloseOperation(2);
        if (this.frame != null) {
            this.window.setLocation(this.frame.getLocation());
            this.window.setSize(this.frame.getSize());
            this.frame.remove(this);
            this.frame.validate();
            this.frame.dispose();
            this.frame = null;
        }
        this.setTitle();
        this.window.add(this);
        this.window.validate();
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = this.window.getRootPane().getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        this.window.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChartGraph.this.window.dispose();
            }
        });
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                if (ChartGraph.this.window != null) {
                    TradeCast.getInstance().GraphWindowHolder.remove(ChartGraph.this.num);
                    LogsTC.GraphSymbol.remove(ChartGraph.this.Symbol);
                }
                if (ChartGraph.this.window != null) {
                    TradeCast.getInstance().SaveSizeAndLocation(FormName.GraphsAndCharts, ChartGraph.this.window.getSize(), ChartGraph.this.window.getLocation());
                }
            }
        });
        TradeCast.getInstance().GraphWindowHolder.put(this.num, this);
        this.window.setVisible(true);
        return this.window;
    }

    public void requestFocusWindow() {
        if (this.window != null) {
            this.window.requestFocus();
        } else if (this.frame != null) {
            this.frame.requestFocus();
        }
    }

    public void setPrefrence(String market, String SelectedSymbol) {
        if (this.isLoading) {
            return;
        }
        this.setFeedEmpty();
        if (market.trim().length() <= 0) {
            market = UtilKSE.GetMarketFromsymbol((String)SelectedSymbol);
        }
        this.Market = market;
        this.Symbol = SelectedSymbol;
        String tempSymbol = SelectedSymbol.trim().split("\\-", -1)[0];
        if (SelectedSymbol.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(tempSymbol)) {
            MyOptionPane.showMessage(MessageType.Error, "Invalid Scrip", "Information", false);
            return;
        }
        this.setTitle();
        this.setInitFeed(market, SelectedSymbol);
        if (!LogsTC.GraphSymbol.contains(this.Symbol)) {
            LogsTC.GraphSymbol.add(this.Symbol);
        }
        String Sector = "";
        if (UtilTC.getScripSector(tempSymbol).length() > 0) {
            Sector = UtilTC.getScripSector(tempSymbol) + " Sector";
        }
        this.InitilizeWindow();
    }

    public void setInitFeed(String market, String symbol) {
        try {
            if (symbol.indexOf(":") > 0) {
                this.feedSymbol = symbol;
                MarketFeed mktFeed = this.mediator.MwPanel.GetSingleFeed(symbol.split(":")[0], symbol.split(":")[1]);
                this.FeedRecieved(mktFeed.feedString);
            } else {
                this.feedSymbol = symbol + ":" + market;
                MarketFeed mktFeed = this.mediator.MwPanel.GetSingleFeed(symbol, market);
                if (mktFeed != null) {
                    this.FeedRecieved(mktFeed.feedString);
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void FeedRecieved(final String Feed2) {
        final String Sym = this.Symbol;
        final String mkt = this.Market;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Feed2.indexOf(Sym) >= 0 && Feed2.indexOf(mkt) >= 0 && !ChartGraph.this.isLoading) {
                    ChartGraph.this.updateChart();
                }
            }
        });
        this.updateMarketRate();
    }

    private void setCompanyScrollPane() {
        NxGWrapLayout layoutData = new NxGWrapLayout(0);
        layoutData.setHgap(0);
        layoutData.setVgap(0);
        this.pnlComp.setBackground(Color.WHITE);
        this.pnlComp.setLayout((LayoutManager)layoutData);
        this.pnlComapny.add((Component)this.companySnapShotPanel, "Center");
    }

    private void setScrollPane() {
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        UIManager.put("ScrollBar.background", 1);
        JScrollBar vbar = this.scrollPane.getVerticalScrollBar();
        NxGScrollBarUI ui2 = new NxGScrollBarUI();
        ui2.setMyScrollBarUI(vbar);
        vbar.setPreferredSize(new Dimension(7, 0));
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        NxGWrapLayout layoutData = new NxGWrapLayout(0);
        layoutData.setHgap(0);
        layoutData.setVgap(0);
        this.scrollPane.setViewportView(this.historicalPanel);
    }

    public void setCompany(String market, String scrip) {
        this.pnlComp.removeAll();
        this.setCompanyScrollPane();
    }

    public void setHistorical(String market, String scrip) {
        this.setLoader();
        this.companySnapShotPanel.empty();
        this.companySnapShotPanel.setLoader();
        this.historicalPanel.addHistoricalData(market, scrip);
        this.repaint();
    }

    private void setLoader() {
        this.historicalPanel.add(new Loader());
    }

    private void initComponents() {
        this.pnlChartRegion = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.pnlComapny = new JPanel();
        this.jPanel4 = new JPanel();
        this.txtfLowerLimit = new NxGTextField();
        this.lblfUpperLimit = new JLabel();
        this.txtfUpperLimit = new NxGTextField();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.lblLastTrdPrice = new JLabel();
        this.lblPerDirection = new JLabel();
        this.lblChange = new JLabel();
        this.lblChangePercentage = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.jSeparator4 = new JSeparator();
        this.jSeparator5 = new JSeparator();
        this.lblMketValues = new JLabel();
        this.lblOSShares = new JLabel();
        this.jLabel5 = new JLabel();
        this.lblOpen = new JLabel();
        this.lblHigh = new JLabel();
        this.lblLow = new JLabel();
        this.jLabel9 = new JLabel();
        this.lblAvgValue = new JLabel();
        this.lblTotVolPer = new JLabel();
        this.lblTotalVolume = new JLabel();
        this.lblOpenValue = new JLabel();
        this.lblHighValue = new JLabel();
        this.lblLowValue = new JLabel();
        this.lblCloseValue = new JLabel();
        this.jLabel12 = new JLabel();
        this.scrollPane = new JScrollPane();
        this.setBackground(new Color(255, 255, 255));
        this.setPreferredSize(new Dimension(800, 489));
        this.pnlChartRegion.setBackground(new Color(0, 0, 0));
        this.pnlChartRegion.setLayout(new BorderLayout());
        this.jSeparator1.setOrientation(1);
        this.pnlComapny.setBackground(new Color(255, 255, 255));
        this.pnlComapny.setLayout(new BorderLayout());
        this.jPanel4.setBackground(new Color(255, 255, 255));
        this.jPanel4.setPreferredSize(new Dimension(825, 61));
        this.txtfLowerLimit.setHorizontalAlignment(0);
        this.txtfLowerLimit.setEnabled(false);
        this.txtfLowerLimit.setFont(new Font("Tahoma", 0, 12));
        this.txtfLowerLimit.setOpaque(false);
        this.lblfUpperLimit.setFont(new Font("Tahoma", 0, 10));
        this.lblfUpperLimit.setForeground(new Color(102, 102, 102));
        this.lblfUpperLimit.setHorizontalAlignment(0);
        this.lblfUpperLimit.setText("Circuit Breakers");
        this.txtfUpperLimit.setHorizontalAlignment(0);
        this.txtfUpperLimit.setEnabled(false);
        this.txtfUpperLimit.setFont(new Font("Tahoma", 0, 12));
        this.txtfUpperLimit.setOpaque(false);
        this.jLabel2.setBackground(new Color(102, 102, 102));
        this.jLabel2.setOpaque(true);
        this.jLabel1.setFont(new Font("Tahoma", 0, 24));
        this.jLabel1.setForeground(new Color(102, 102, 102));
        this.jLabel1.setText("PKR");
        this.lblLastTrdPrice.setFont(new Font("Tahoma", 0, 24));
        this.lblLastTrdPrice.setHorizontalAlignment(4);
        this.lblLastTrdPrice.setToolTipText("Last Trade Price");
        this.lblLastTrdPrice.setHorizontalTextPosition(4);
        this.lblChange.setFont(new Font("Tahoma", 0, 18));
        this.lblChange.setHorizontalAlignment(0);
        this.lblChange.setText("...");
        this.lblChange.setToolTipText("Change");
        this.lblChange.setHorizontalTextPosition(4);
        this.lblChangePercentage.setFont(new Font("Tahoma", 0, 10));
        this.lblChangePercentage.setHorizontalAlignment(0);
        this.lblChangePercentage.setText("...");
        this.lblChangePercentage.setToolTipText("Change Percentage");
        this.lblChangePercentage.setHorizontalTextPosition(4);
        this.jSeparator2.setOrientation(1);
        this.jLabel3.setFont(new Font("Tahoma", 0, 12));
        this.jLabel3.setForeground(new Color(102, 102, 102));
        this.jLabel3.setText("O/S Shares:");
        this.jLabel3.setToolTipText("Outstanding Shares");
        this.jLabel4.setFont(new Font("Tahoma", 0, 12));
        this.jLabel4.setForeground(new Color(102, 102, 102));
        this.jLabel4.setText("Mkt Cap:");
        this.jLabel4.setToolTipText("Market Capitalization");
        this.jSeparator3.setOrientation(1);
        this.jSeparator4.setOrientation(1);
        this.lblMketValues.setFont(new Font("Tahoma", 0, 14));
        this.lblMketValues.setHorizontalAlignment(4);
        this.lblOSShares.setFont(new Font("Tahoma", 0, 14));
        this.lblOSShares.setHorizontalAlignment(4);
        this.jLabel5.setFont(new Font("Tahoma", 0, 12));
        this.jLabel5.setForeground(new Color(102, 102, 102));
        this.jLabel5.setText("Tot Volume:");
        this.jLabel5.setToolTipText("Total Volume");
        this.lblOpen.setFont(new Font("Tahoma", 0, 12));
        this.lblOpen.setForeground(new Color(102, 102, 102));
        this.lblOpen.setText("o:");
        this.lblOpen.setToolTipText("Open");
        this.lblHigh.setFont(new Font("Tahoma", 0, 12));
        this.lblHigh.setForeground(new Color(102, 102, 102));
        this.lblHigh.setText("h:");
        this.lblHigh.setToolTipText("High");
        this.lblLow.setFont(new Font("Tahoma", 0, 12));
        this.lblLow.setForeground(new Color(102, 102, 102));
        this.lblLow.setText("l:");
        this.lblLow.setToolTipText("Low");
        this.jLabel9.setFont(new Font("Tahoma", 0, 12));
        this.jLabel9.setForeground(new Color(102, 102, 102));
        this.jLabel9.setText("Avg Price:");
        this.jLabel9.setToolTipText("Average Price");
        this.lblAvgValue.setFont(new Font("Tahoma", 0, 12));
        this.lblAvgValue.setForeground(new Color(102, 102, 102));
        this.lblTotVolPer.setFont(new Font("Tahoma", 0, 14));
        this.lblTotVolPer.setForeground(new Color(102, 102, 102));
        this.lblTotVolPer.setToolTipText("Total Volume Percentage");
        this.lblTotalVolume.setFont(new Font("Tahoma", 0, 14));
        this.lblTotalVolume.setForeground(new Color(102, 102, 102));
        this.lblOpenValue.setFont(new Font("Tahoma", 0, 14));
        this.lblOpenValue.setForeground(new Color(102, 102, 102));
        this.lblHighValue.setFont(new Font("Tahoma", 0, 14));
        this.lblHighValue.setForeground(new Color(102, 102, 102));
        this.lblHighValue.setHorizontalTextPosition(4);
        this.lblLowValue.setFont(new Font("Tahoma", 0, 14));
        this.lblLowValue.setForeground(new Color(102, 102, 102));
        this.lblLowValue.setHorizontalTextPosition(4);
        this.lblCloseValue.setFont(new Font("Tahoma", 0, 14));
        this.lblCloseValue.setForeground(new Color(102, 102, 102));
        this.lblCloseValue.setHorizontalTextPosition(4);
        this.jLabel12.setFont(new Font("Tahoma", 0, 12));
        this.jLabel12.setForeground(new Color(102, 102, 102));
        this.jLabel12.setText("c:");
        this.jLabel12.setToolTipText("Close");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.jLabel1).addGap(11, 11, 11).addComponent(this.lblLastTrdPrice, -2, 90, -2).addGap(10, 10, 10).addComponent(this.lblPerDirection, -2, 10, -2).addGap(10, 10, 10).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblChange, -2, 45, -2).addComponent(this.lblChangePercentage, -2, 45, -2)).addGap(15, 15, 15).addComponent(this.jSeparator2, -2, -1, -2).addGap(8, 8, 8).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.lblOpen, -2, 12, -2).addGap(0, 0, 0).addComponent(this.lblOpenValue, -2, 55, -2).addGap(3, 3, 3).addComponent(this.lblHigh, -2, 12, -2).addGap(4, 4, 4).addComponent(this.lblHighValue, -2, 50, -2).addGap(4, 4, 4).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.lblLowValue, -2, 65, -2)).addComponent(this.lblLow, -2, 12, -2)).addGap(5, 5, 5).addComponent(this.jLabel12, -2, 12, -2).addGap(8, 8, 8).addComponent(this.lblCloseValue, -2, 70, -2)).addComponent(this.jSeparator5, -2, 310, -2).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel9).addGap(5, 5, 5).addComponent(this.lblAvgValue, -2, 42, -2).addGap(3, 3, 3).addComponent(this.jLabel5, -2, 70, -2).addGap(6, 6, 6).addComponent(this.lblTotalVolume, -2, 70, -2).addGap(3, 3, 3).addComponent(this.lblTotVolPer, -2, 65, -2))).addGap(3, 3, 3).addComponent(this.jSeparator4, -2, -1, -2).addGap(6, 6, 6).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel4, -2, 55, -2).addGap(12, 12, 12).addComponent(this.lblMketValues, -1, 62, Short.MAX_VALUE).addGap(3, 3, 3)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel3, -2, 70, -2).addGap(0, 0, 0).addComponent(this.lblOSShares, -1, 62, Short.MAX_VALUE))).addGap(5, 5, 5).addComponent(this.jSeparator3, -2, -1, -2).addGap(1, 1, 1).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblfUpperLimit, -1, 80, Short.MAX_VALUE).addGroup(jPanel4Layout.createSequentialGroup().addGap(5, 5, 5).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtfUpperLimit, -1, -1, Short.MAX_VALUE).addComponent(this.txtfLowerLimit, -1, -1, Short.MAX_VALUE)).addGap(5, 5, 5)))).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.jLabel1, -2, 20, -2)).addGroup(jPanel4Layout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.lblLastTrdPrice, -2, 20, -2)).addGroup(jPanel4Layout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.lblPerDirection, -2, 20, -2)).addGroup(jPanel4Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.lblChange).addGap(0, 0, 0).addComponent(this.lblChangePercentage, -2, 15, -2)).addGroup(jPanel4Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jSeparator2, -2, 38, -2)).addGroup(jPanel4Layout.createSequentialGroup().addGap(7, 7, 7).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblOpen).addComponent(this.lblHigh).addComponent(this.lblLow).addComponent(this.jLabel12).addGroup(jPanel4Layout.createSequentialGroup().addGap(2, 2, 2).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblOpenValue, -2, 13, -2).addComponent(this.lblHighValue, -2, 13, -2).addComponent(this.lblLowValue, -2, 13, -2).addComponent(this.lblCloseValue, -2, 13, -2)))).addGap(2, 2, 2).addComponent(this.jSeparator5, -2, 1, -2).addGap(3, 3, 3).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.jLabel5).addGroup(jPanel4Layout.createSequentialGroup().addGap(1, 1, 1).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblAvgValue, -2, 15, -2).addComponent(this.lblTotalVolume, -2, 15, -2).addComponent(this.lblTotVolPer, -2, 15, -2))))).addGroup(jPanel4Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jSeparator4, -2, 38, -2)).addGroup(jPanel4Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.lblMketValues, -2, 14, -2)).addGap(7, 7, 7).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.lblOSShares, -2, 14, -2))).addGroup(jPanel4Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jSeparator3, -2, 38, -2)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.lblfUpperLimit).addGap(3, 3, 3).addComponent(this.txtfUpperLimit, -2, 13, -2).addGap(4, 4, 4).addComponent(this.txtfLowerLimit, -2, 13, -2))).addGap(2, 2, 2).addComponent(this.jLabel2, -2, 1, -2)));
        this.scrollPane.setBackground(new Color(255, 255, 255));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -1, 800, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlChartRegion, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.pnlComapny, -1, -1, Short.MAX_VALUE))).addGap(7, 7, 7).addComponent(this.jSeparator1, -2, -1, -2).addGap(5, 5, 5).addComponent(this.scrollPane, -2, 231, -2).addGap(2, 2, 2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel4, -2, 49, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.pnlChartRegion, -1, -1, Short.MAX_VALUE).addGap(2, 2, 2).addComponent(this.pnlComapny, -2, 150, -2)).addComponent(this.jSeparator1, -2, 440, -2).addGroup(layout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.scrollPane)))));
    }

    private void setFeedEmpty() {
        this.lblChange.setText("");
        this.lblChangePercentage.setText("");
        this.lblOpenValue.setText("");
        this.lblHighValue.setText("");
        this.lblLowValue.setText("");
        this.lblCloseValue.setText("");
        this.lblAvgValue.setText("");
        this.lblTotalVolume.setText("");
        this.lblTotVolPer.setText("");
        this.lblMketValues.setText("");
        this.lblOSShares.setText("");
        this.txtfUpperLimit.setText("");
        this.txtfLowerLimit.setText("");
    }
}

