/*
 * Decompiled with CFR 0.152.
 */
package Screener;

import Beans.CompanyInfoBean;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import com.google.gson.Gson;
import common.gui.component.NxGDialogBox;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.ImageUtil;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import kse.util.UtilKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXImagePanel;
import org.jdesktop.swingx.JXLabel;

public class CompanyInfo
extends NxGDialogBox {
    String hyperlink = "";
    Mediator mediator = Mediator.getInstance();
    private AutoCompleteSupport autoCompleteScrip;
    private LanguageCentre languageCentre = new LanguageCentre();
    private JComboBox cmbSymbol;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JLabel lblCDCcode;
    private JLabel lblCDOL;
    private JLabel lblCREGFax;
    private JLabel lblCREGaddr;
    private JLabel lblCREGname;
    private JLabel lblCREGphone;
    private JLabel lblCaddress;
    private JLabel lblCemail;
    private JLabel lblCname;
    private JLabel lblCphone;
    private JLabel lblCsector;
    private JLabel lblCwebsite;
    private JXLabel lblDescription;
    private JLabel lblDetailQuote;
    private JXImagePanel lblLogo1;
    private JLabel lblMessage;
    private JLabel lblScripBrowse;
    private JLabel lblSrch;
    private JLabel lblSymbol;
    private JLabel lblSymbolName;
    private JLabel lblcRdesig;
    private JLabel lblcRname;

    public CompanyInfo(Frame parent, boolean modal, String scrip) {
        super(parent, modal);
        this.initComponents();
        this.setIconImage(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/info16.png")).getImage());
        this.setBounds(0, 0, 600, 555);
        this.setTitle("Company Info");
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setAllScrip();
        this.cmbSymbol.setMaximumRowCount(30);
        String mktSymbol = UtilKSE.GetMarketFromsymbol((String)scrip);
        if (mktSymbol.equalsIgnoreCase("FUT") || mktSymbol.equalsIgnoreCase("IPO")) {
            if (scrip.indexOf("-") > 0) {
                this.cmbSymbol.setSelectedItem(scrip.split("\\-", -1)[0]);
            }
        } else {
            this.cmbSymbol.setSelectedItem(scrip);
        }
        this.lblScripBrowse.setText("<html><b>" + this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></html>");
        this.lblScripBrowse.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CompanyInfo.this.mediator.tradecast.ShowDynamicForm(FormName.ScripBrowse, LanguageConstant.ScripBrowse);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                CompanyInfo.this.lblScripBrowse.setCursor(Cursor.getPredefinedCursor(12));
                CompanyInfo.this.lblScripBrowse.setText("<html><u><b>" + CompanyInfo.this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></u></html>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CompanyInfo.this.lblScripBrowse.setCursor(Cursor.getPredefinedCursor(0));
                CompanyInfo.this.lblScripBrowse.setText("<html><b>" + CompanyInfo.this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></html>");
            }
        });
        this.lblDetailQuote.setText("<html><b>" + this.languageCentre.getValue(LanguageConstant.DetailedQuote) + "</b></html>");
        this.lblDetailQuote.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TradeCast.getInstance().ShowDynamicForm(FormName.DetailedQuote, LanguageConstant.DetailedQuote);
                CompanyInfo.this.mediator.detailedQuote.AddSymbol(UtilKSE.GetMarketFromsymbol((String)CompanyInfo.this.cmbSymbol.getSelectedItem().toString()), CompanyInfo.this.cmbSymbol.getSelectedItem().toString());
                CompanyInfo.this.mediator.detailedQuote.setTitle("");
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                CompanyInfo.this.lblDetailQuote.setCursor(Cursor.getPredefinedCursor(12));
                CompanyInfo.this.lblDetailQuote.setText("<html><u><b>" + CompanyInfo.this.languageCentre.getValue(LanguageConstant.DetailedQuote) + "</b></u></html>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CompanyInfo.this.lblDetailQuote.setCursor(Cursor.getPredefinedCursor(0));
                CompanyInfo.this.lblDetailQuote.setText("<html><b>" + CompanyInfo.this.languageCentre.getValue(LanguageConstant.DetailedQuote) + "</b></html>");
            }
        });
        this.setSymbol();
        this.showCompanyInfo(scrip);
    }

    private void showCompanyInfo(String scrp) {
        try {
            String line;
            String call = AppConfig.JCR_VIS_Data_URL.replaceFirst("TCFeedFetcher", "") + "/CompanyInfoServlet?scrip=" + scrp;
            URL url = new URL(call);
            URLConnection con = url.openConnection();
            con.setDoOutput(true);
            con.setDoInput(true);
            StringBuilder sb = new StringBuilder();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            while ((line = in.readLine()) != null) {
                sb.append(line);
            }
            in.close();
            Gson g = new Gson();
            CompanyInfoBean cb = (CompanyInfoBean)g.fromJson(sb.toString(), CompanyInfoBean.class);
            this.hyperlink = cb.getCompanyWebsite();
            this.lblDescription.setText(cb.getDescription());
            this.lblcRname.setText(cb.getRepresentativeName());
            this.lblcRdesig.setText(cb.getRepresentativeDesignation());
            this.lblCname.setText(cb.getCompanyName());
            this.lblCsector.setText(cb.getCompanySector());
            this.lblCDCcode.setText(cb.getCompanyCDCCode());
            this.lblCaddress.setText(cb.getCompanyAddress());
            this.lblCphone.setText(cb.getCompanyPhone());
            this.lblCemail.setText(cb.getCompanyEmail());
            this.lblCwebsite.setText("<html><b>" + cb.getCompanyWebsite() + "</b></html>");
            this.lblCDOL.setText(cb.getCompanyDateOfListing());
            this.lblCREGname.setText(cb.getRegistrarName());
            this.lblCREGaddr.setText(cb.getRegistrarAddress());
            this.lblCREGphone.setText(cb.getRegistrarPhones());
            this.lblCREGFax.setText(cb.getRegistrarFax());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.lblSymbol = new JLabel();
        this.jLabel17 = new JLabel();
        this.lblSymbolName = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.cmbSymbol = new JComboBox();
        this.lblDescription = new JXLabel();
        this.lblScripBrowse = new JLabel();
        this.lblSrch = new JLabel();
        this.lblDetailQuote = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.lblcRname = new JLabel();
        this.jLabel3 = new JLabel();
        this.lblcRdesig = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel25 = new JLabel();
        this.jLabel26 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jLabel28 = new JLabel();
        this.jLabel29 = new JLabel();
        this.lblCREGname = new JLabel();
        this.lblCREGaddr = new JLabel();
        this.lblCREGphone = new JLabel();
        this.lblCREGFax = new JLabel();
        this.lblCname = new JLabel();
        this.lblCphone = new JLabel();
        this.lblCaddress = new JLabel();
        this.lblCemail = new JLabel();
        this.lblCDOL = new JLabel();
        this.lblCwebsite = new JLabel();
        this.lblCsector = new JLabel();
        this.lblCDCcode = new JLabel();
        this.lblLogo1 = new JXImagePanel();
        this.jSeparator3 = new JSeparator();
        this.jPanel2 = new JPanel();
        this.lblMessage = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setBackground(new Color(255, 255, 255));
        this.getContentPane().setLayout(null);
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setLayout(null);
        this.lblSymbol.setFont(new Font("Tahoma", 1, 14));
        this.lblSymbol.setHorizontalAlignment(0);
        this.lblSymbol.setText(" ");
        this.lblSymbol.setHorizontalTextPosition(0);
        this.jPanel1.add(this.lblSymbol);
        this.lblSymbol.setBounds(10, 10, 70, 17);
        this.jLabel17.setBackground(new Color(153, 153, 153));
        this.jLabel17.setOpaque(true);
        this.jPanel1.add(this.jLabel17);
        this.jLabel17.setBounds(90, 10, 1, 15);
        this.lblSymbolName.setFont(new Font("Tahoma", 1, 14));
        this.lblSymbolName.setText(" ");
        this.jPanel1.add(this.lblSymbolName);
        this.lblSymbolName.setBounds(100, 10, 360, 17);
        this.jPanel1.add(this.jSeparator2);
        this.jSeparator2.setBounds(10, 30, 450, 2);
        this.cmbSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompanyInfo.this.cmbSymbolActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cmbSymbol);
        this.cmbSymbol.setBounds(470, 10, 80, 20);
        this.lblDescription.setLineWrap(true);
        this.lblDescription.setText(" ");
        this.lblDescription.setVerticalAlignment(1);
        this.lblDescription.setVerticalTextPosition(1);
        this.jPanel1.add((Component)this.lblDescription);
        this.lblDescription.setBounds(10, 40, 450, 45);
        this.lblScripBrowse.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/symDetail2.png")));
        this.lblScripBrowse.setText("Scrip Browse");
        this.jPanel1.add(this.lblScripBrowse);
        this.lblScripBrowse.setBounds(470, 40, 100, 16);
        this.lblSrch.setHorizontalAlignment(2);
        this.lblSrch.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/search12.png")));
        this.lblSrch.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                CompanyInfo.this.lblSrchMousePressed(evt);
            }
        });
        this.jPanel1.add(this.lblSrch);
        this.lblSrch.setBounds(560, 10, 20, 20);
        this.lblDetailQuote.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/detailQuote.png")));
        this.lblDetailQuote.setText("Detail Quote");
        this.jPanel1.add(this.lblDetailQuote);
        this.lblDetailQuote.setBounds(470, 60, 115, 16);
        this.getContentPane().add(this.jPanel1);
        this.jPanel1.setBounds(0, 0, 600, 90);
        this.getContentPane().add(this.jSeparator1);
        this.jSeparator1.setBounds(0, 90, 600, 2);
        this.jLabel2.setBackground(new Color(220, 220, 220));
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setText(" Company Representative");
        this.jLabel2.setOpaque(true);
        this.getContentPane().add(this.jLabel2);
        this.jLabel2.setBounds(20, 100, 560, 20);
        this.jLabel1.setBackground(new Color(204, 204, 204));
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText(" Name");
        this.jLabel1.setOpaque(true);
        this.getContentPane().add(this.jLabel1);
        this.jLabel1.setBounds(20, 120, 80, 20);
        this.lblcRname.setBackground(new Color(255, 255, 255));
        this.getContentPane().add(this.lblcRname);
        this.lblcRname.setBounds(105, 120, 470, 20);
        this.jLabel3.setBackground(new Color(204, 204, 204));
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText(" Designation");
        this.jLabel3.setOpaque(true);
        this.getContentPane().add(this.jLabel3);
        this.jLabel3.setBounds(20, 140, 80, 20);
        this.lblcRdesig.setBackground(new Color(255, 255, 255));
        this.getContentPane().add(this.lblcRdesig);
        this.lblcRdesig.setBounds(105, 140, 470, 20);
        this.jLabel7.setBackground(new Color(220, 220, 220));
        this.jLabel7.setFont(new Font("Tahoma", 1, 11));
        this.jLabel7.setText(" Company Details");
        this.jLabel7.setOpaque(true);
        this.getContentPane().add(this.jLabel7);
        this.jLabel7.setBounds(20, 190, 560, 20);
        this.jLabel4.setBackground(new Color(204, 204, 204));
        this.jLabel4.setFont(new Font("Tahoma", 1, 11));
        this.jLabel4.setText(" Name");
        this.jLabel4.setOpaque(true);
        this.getContentPane().add(this.jLabel4);
        this.jLabel4.setBounds(20, 210, 80, 20);
        this.jLabel8.setBackground(new Color(204, 204, 204));
        this.jLabel8.setFont(new Font("Tahoma", 1, 11));
        this.jLabel8.setText(" Sector");
        this.jLabel8.setOpaque(true);
        this.getContentPane().add(this.jLabel8);
        this.jLabel8.setBounds(20, 230, 80, 20);
        this.jLabel9.setBackground(new Color(204, 204, 204));
        this.jLabel9.setFont(new Font("Tahoma", 1, 11));
        this.jLabel9.setText(" CDC Code");
        this.jLabel9.setOpaque(true);
        this.getContentPane().add(this.jLabel9);
        this.jLabel9.setBounds(20, 250, 80, 20);
        this.jLabel10.setBackground(new Color(204, 204, 204));
        this.jLabel10.setFont(new Font("Tahoma", 1, 11));
        this.jLabel10.setText(" Address");
        this.jLabel10.setOpaque(true);
        this.getContentPane().add(this.jLabel10);
        this.jLabel10.setBounds(20, 270, 80, 20);
        this.jLabel12.setBackground(new Color(204, 204, 204));
        this.jLabel12.setFont(new Font("Tahoma", 1, 11));
        this.jLabel12.setText(" Phone");
        this.jLabel12.setOpaque(true);
        this.getContentPane().add(this.jLabel12);
        this.jLabel12.setBounds(20, 290, 80, 20);
        this.jLabel13.setBackground(new Color(204, 204, 204));
        this.jLabel13.setFont(new Font("Tahoma", 1, 11));
        this.jLabel13.setText(" Email");
        this.jLabel13.setOpaque(true);
        this.getContentPane().add(this.jLabel13);
        this.jLabel13.setBounds(20, 310, 80, 20);
        this.jLabel14.setBackground(new Color(204, 204, 204));
        this.jLabel14.setFont(new Font("Tahoma", 1, 11));
        this.jLabel14.setText(" Website");
        this.jLabel14.setOpaque(true);
        this.getContentPane().add(this.jLabel14);
        this.jLabel14.setBounds(20, 330, 80, 20);
        this.jLabel15.setBackground(new Color(204, 204, 204));
        this.jLabel15.setFont(new Font("Tahoma", 1, 11));
        this.jLabel15.setText(" Date Listed");
        this.jLabel15.setOpaque(true);
        this.getContentPane().add(this.jLabel15);
        this.jLabel15.setBounds(20, 350, 80, 20);
        this.jLabel25.setBackground(new Color(220, 220, 220));
        this.jLabel25.setFont(new Font("Tahoma", 1, 11));
        this.jLabel25.setText(" Company Registrar");
        this.jLabel25.setOpaque(true);
        this.getContentPane().add(this.jLabel25);
        this.jLabel25.setBounds(20, 390, 560, 20);
        this.jLabel26.setBackground(new Color(204, 204, 204));
        this.jLabel26.setFont(new Font("Tahoma", 1, 11));
        this.jLabel26.setText(" Name");
        this.jLabel26.setOpaque(true);
        this.getContentPane().add(this.jLabel26);
        this.jLabel26.setBounds(20, 410, 80, 20);
        this.jLabel27.setBackground(new Color(204, 204, 204));
        this.jLabel27.setFont(new Font("Tahoma", 1, 11));
        this.jLabel27.setText(" Address");
        this.jLabel27.setOpaque(true);
        this.getContentPane().add(this.jLabel27);
        this.jLabel27.setBounds(20, 430, 80, 20);
        this.jLabel28.setBackground(new Color(204, 204, 204));
        this.jLabel28.setFont(new Font("Tahoma", 1, 11));
        this.jLabel28.setText(" Phone");
        this.jLabel28.setOpaque(true);
        this.getContentPane().add(this.jLabel28);
        this.jLabel28.setBounds(20, 450, 80, 20);
        this.jLabel29.setBackground(new Color(204, 204, 204));
        this.jLabel29.setFont(new Font("Tahoma", 1, 11));
        this.jLabel29.setText(" Fax");
        this.jLabel29.setOpaque(true);
        this.getContentPane().add(this.jLabel29);
        this.jLabel29.setBounds(20, 470, 80, 20);
        this.lblCREGname.setBackground(new Color(255, 255, 255));
        this.getContentPane().add(this.lblCREGname);
        this.lblCREGname.setBounds(105, 410, 470, 20);
        this.lblCREGaddr.setBackground(new Color(255, 255, 255));
        this.getContentPane().add(this.lblCREGaddr);
        this.lblCREGaddr.setBounds(105, 430, 470, 20);
        this.lblCREGphone.setBackground(new Color(255, 255, 255));
        this.getContentPane().add(this.lblCREGphone);
        this.lblCREGphone.setBounds(105, 450, 470, 20);
        this.lblCREGFax.setBackground(new Color(255, 255, 255));
        this.getContentPane().add(this.lblCREGFax);
        this.lblCREGFax.setBounds(105, 470, 470, 20);
        this.lblCname.setBackground(new Color(255, 255, 255));
        this.getContentPane().add(this.lblCname);
        this.lblCname.setBounds(105, 210, 470, 20);
        this.lblCphone.setBackground(new Color(255, 255, 255));
        this.getContentPane().add(this.lblCphone);
        this.lblCphone.setBounds(105, 290, 470, 20);
        this.lblCaddress.setBackground(new Color(255, 255, 255));
        this.getContentPane().add(this.lblCaddress);
        this.lblCaddress.setBounds(105, 270, 470, 20);
        this.lblCemail.setBackground(new Color(255, 255, 255));
        this.getContentPane().add(this.lblCemail);
        this.lblCemail.setBounds(105, 310, 470, 20);
        this.lblCDOL.setBackground(new Color(255, 255, 255));
        this.getContentPane().add(this.lblCDOL);
        this.lblCDOL.setBounds(105, 350, 470, 20);
        this.lblCwebsite.setBackground(new Color(255, 255, 255));
        this.lblCwebsite.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CompanyInfo.this.lblCwebsiteMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                CompanyInfo.this.lblCwebsiteMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                CompanyInfo.this.lblCwebsiteMousePressed(evt);
            }
        });
        this.getContentPane().add(this.lblCwebsite);
        this.lblCwebsite.setBounds(105, 330, 470, 20);
        this.lblCsector.setBackground(new Color(255, 255, 255));
        this.getContentPane().add(this.lblCsector);
        this.lblCsector.setBounds(105, 230, 470, 20);
        this.lblCDCcode.setBackground(new Color(255, 255, 255));
        this.getContentPane().add(this.lblCDCcode);
        this.lblCDCcode.setBounds(105, 250, 470, 20);
        this.lblLogo1.setAlpha(0.3f);
        this.lblLogo1.setBackground(new Color(255, 255, 255));
        this.lblLogo1.setPreferredSize(new Dimension(65, 65));
        this.lblLogo1.setStyle(JXImagePanel.Style.SCALED_KEEP_ASPECT_RATIO);
        GroupLayout lblLogo1Layout = new GroupLayout((Container)this.lblLogo1);
        this.lblLogo1.setLayout((LayoutManager)lblLogo1Layout);
        lblLogo1Layout.setHorizontalGroup(lblLogo1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        lblLogo1Layout.setVerticalGroup(lblLogo1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        this.getContentPane().add((Component)this.lblLogo1);
        this.lblLogo1.setBounds(180, 150, 300, 300);
        this.getContentPane().add(this.jSeparator3);
        this.jSeparator3.setBounds(0, 500, 600, 2);
        this.jPanel2.setBackground(new Color(255, 255, 255));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 600, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 500, Short.MAX_VALUE));
        this.getContentPane().add(this.jPanel2);
        this.jPanel2.setBounds(0, 0, 600, 500);
        this.getContentPane().add(this.lblMessage);
        this.lblMessage.setBounds(20, 505, 560, 20);
        this.pack();
    }

    private void cmbSymbolActionPerformed(ActionEvent evt) {
        if (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
            this.setSymbol();
        }
    }

    private void lblSrchMousePressed(MouseEvent evt) {
        this.setSymbol();
    }

    private void lblCwebsiteMouseEntered(MouseEvent evt) {
        this.lblCwebsite.setCursor(Cursor.getPredefinedCursor(12));
        this.lblCwebsite.setText("<html><b><u>" + this.hyperlink + "</u></b></html>");
    }

    private void lblCwebsiteMousePressed(MouseEvent evt) {
        TradeCast.getInstance().showWebBrowserFrame();
        this.mediator.webBrowserFrame.openURL(this.hyperlink);
    }

    private void lblCwebsiteMouseExited(MouseEvent evt) {
        this.lblCwebsite.setCursor(Cursor.getPredefinedCursor(0));
        this.lblCwebsite.setText("<html><b>" + this.hyperlink + "</b></html>");
    }

    private void setSymbol() {
        final String symbol = this.cmbSymbol.getSelectedItem().toString();
        this.setImages(symbol);
        new Thread(new Runnable(){

            @Override
            public void run() {
                Util.setMessage((JLabel)CompanyInfo.this.lblMessage, (MessageType)MessageType.Loading, (String)CompanyInfo.this.languageCentre.getValue(LanguageConstant.Loading));
                CompanyInfo.this.lblSymbol.setText(symbol);
                CompanyInfo.this.lblSymbol.setToolTipText(CompanyInfo.this.lblSymbol.getText());
                CompanyInfo.this.lblSymbolName.setText(CompanyInfo.this.mediator.getSymbolTitle(symbol));
                CompanyInfo.this.lblSymbolName.setToolTipText(CompanyInfo.this.lblSymbolName.getText());
                CompanyInfo.this.setEmpty();
                CompanyInfo.this.showCompanyInfo(CompanyInfo.this.cmbSymbol.getSelectedItem().toString());
                Util.setMessage((JLabel)CompanyInfo.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
            }
        }).start();
    }

    private void setAllScrip() {
        try {
            if (this.autoCompleteScrip != null && this.autoCompleteScrip.isInstalled()) {
                this.autoCompleteScrip.uninstall();
            }
            Vector allScrip = new Vector(LogCommon.SymbolAndSymbolName.keySet());
            Vector<String> newScrip = new Vector<String>();
            for (int i = 0; i < allScrip.size(); ++i) {
                Object object = allScrip.elementAt(i);
                if (newScrip.contains(object.toString().split("\\-", -1)[0])) continue;
                newScrip.add(object.toString().split("\\-", -1)[0]);
            }
            Collections.sort(newScrip);
            this.cmbSymbol.setModel(new DefaultComboBoxModel(newScrip));
            this.autoCompleteScrip = AutoCompleteSupport.install((JComboBox)this.cmbSymbol, (EventList)GlazedLists.eventListOf((Object[])newScrip.toArray()));
            this.autoCompleteScrip.setStrict(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setImages(final String symbol) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    CompanyInfo.this.lblLogo1.setImage(null);
                    String call = AppConfig.JCR_VIS_Data_URL.replaceFirst("TCFeedFetcher", "") + "/CompanyImages/" + symbol.toUpperCase() + ".GIF";
                    BufferedImage image = ImageUtil.downloadImage((String)call);
                    if (image != null) {
                        CompanyInfo.this.lblLogo1.setImage((Image)image);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    private void setEmpty() {
        this.hyperlink = "";
        this.lblDescription.setText("");
        this.lblDescription.setToolTipText(null);
        this.lblcRname.setText("");
        this.lblcRdesig.setText("");
        this.lblCname.setText("");
        this.lblCsector.setText("");
        this.lblCDCcode.setText("");
        this.lblCaddress.setText("");
        this.lblCphone.setText("");
        this.lblCemail.setText("");
        this.lblCwebsite.setText("");
        this.lblCDOL.setText("");
        this.lblCREGname.setText("");
        this.lblCREGaddr.setText("");
        this.lblCREGphone.setText("");
        this.lblCREGFax.setText("");
    }
}

