/*
 * Decompiled with CFR 0.152.
 */
package Screener;

import Beans.CompanySnapshotBean;
import Screener.CompanyPanelColumn;
import Screener.HeaderPanel;
import Screener.Loader;
import common.gui.component.NxGScrollBarUI;
import common.gui.layout.NxGWrapLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import kse.util.HistoricalDataType;

public class CompanySnapShotPanel
extends JPanel {
    private final int Width = 220;
    private final int Height = 145;
    private final int HeaderHeightColumn = 20;
    private final int HeaderWidthColumn = 218;
    HeaderPanel lblTitle = new HeaderPanel();
    JPanel pnlSingleData = new JPanel();
    JPanel pnlData = new JPanel();
    JScrollPane scrollPane = new JScrollPane(this.pnlData);

    public CompanySnapShotPanel() {
        this.initComponents();
    }

    public void addData(HistoricalDataType historicalDataType, List<CompanySnapshotBean> list) {
        this.setBackground(Color.WHITE);
        this.empty();
        if (list != null) {
            this.addCompanyValuesPanel(list);
            this.setSizes();
        }
    }

    private void addCompanyHeader(JPanel p) {
        this.lblTitle = new HeaderPanel();
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/Images/snapshot12_1.png"));
        this.lblTitle.setHeader("Company Snapshot", icon);
        p.add(this.lblTitle);
    }

    private void addCompanyValuesPanel(List<CompanySnapshotBean> list) {
        NxGWrapLayout layoutSingleData = new NxGWrapLayout(0);
        layoutSingleData.setHgap(0);
        layoutSingleData.setVgap(0);
        this.pnlSingleData = new JPanel((LayoutManager)layoutSingleData);
        this.pnlSingleData.setBackground(Color.PINK);
        this.pnlSingleData.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.shadow")));
        NxGWrapLayout layoutData = new NxGWrapLayout(0);
        layoutData.setHgap(5);
        layoutData.setVgap(0);
        this.pnlData = new JPanel((LayoutManager)layoutData);
        this.scrollPane = new JScrollPane(this.pnlData);
        this.pnlData.setBorder(BorderFactory.createEmptyBorder());
        this.pnlSingleData.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        UIManager.put("ScrollBar.background", 1);
        JScrollBar vbar = this.scrollPane.getVerticalScrollBar();
        NxGScrollBarUI ui2 = new NxGScrollBarUI();
        ui2.setMyScrollBarUI(vbar);
        vbar.setPreferredSize(new Dimension(7, 0));
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setBackground(Color.WHITE);
        this.scrollPane.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0, 0)));
        this.addCompanyHeader(this.pnlSingleData);
        for (int i = 0; i < list.size(); ++i) {
            CompanySnapshotBean bean = list.get(i);
            CompanyPanelColumn pnlValue = new CompanyPanelColumn(bean.title, bean.value, bean.value, "", "");
            this.pnlData.add(pnlValue);
        }
        this.pnlData.setBackground(Color.WHITE);
        this.pnlSingleData.add(this.scrollPane);
        this.add(this.pnlSingleData);
        this.repaint();
    }

    public void setLoader() {
        Loader loader = new Loader();
        loader.setPreferredSize(new Dimension(533, 188));
        this.add(loader);
    }

    public void empty() {
        this.removeAll();
        this.repaint();
    }

    private void initComponents() {
        this.setBackground(new Color(255, 255, 255));
        this.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorMoved(HierarchyEvent evt) {
            }

            @Override
            public void ancestorResized(HierarchyEvent evt) {
                CompanySnapShotPanel.this.formAncestorResized(evt);
            }
        });
        this.setLayout(new FlowLayout(1, 0, 0));
    }

    private void formAncestorResized(HierarchyEvent evt) {
        this.setSizes();
    }

    private void setSizes() {
        Dimension size = this.getSize();
        this.lblTitle.setPreferredSize(new Dimension(size.width, 20));
        this.pnlSingleData.setPreferredSize(new Dimension(size.width, size.height));
        this.scrollPane.setPreferredSize(new Dimension(size.width, size.height - 20));
    }
}

