/*
 * Decompiled with CFR 0.152.
 */
package Screener;

import Beans.TechnicalsBean;
import Beans.ValueBean;
import BeansContainer.AllContainer;
import BeansContainer.CompanySnapshotContainer;
import BeansContainer.FundamentalsContainer;
import BeansContainer.PerformanceContainer;
import BeansContainer.TechnicalsContainer;
import BeansContainer.ValuationContainer;
import CATALYST.Control.MarketFeed;
import MyDocking.Mediator;
import Screener.ChartGraph;
import Screener.HeaderPanel;
import Screener.HistPanelColumn;
import Utilities.LogsTC;
import com.google.gson.Gson;
import common.gui.layout.NxGWrapLayout;
import common.gui.util.AppConfig;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import kse.util.HistoricalDataType;

public class HistoricalPanel
extends JPanel {
    private Color bgColor = Color.WHITE;
    private String market;
    private String scrip;
    private final int Width = 220;
    private final int Height = 145;
    private final int HeaderHeightColumn = 20;
    private final int HeaderWidthColumn = 218;
    JScrollPane scrollPane = new JScrollPane();
    private ChartGraph chartGraph;

    public HistoricalPanel(ChartGraph chartGraph) {
        this.initComponents();
        this.chartGraph = chartGraph;
        this.setLayout();
    }

    private void setLayout() {
        NxGWrapLayout n = new NxGWrapLayout();
        this.setLayout((LayoutManager)n);
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    public void addHistoricalData(String market, String scrip) {
        this.market = market;
        this.scrip = scrip;
        if (scrip != null && scrip.trim().length() > 0) {
            new Thread(new HistoricalDataLoad(market, scrip)).start();
        }
    }

    private String getHistoricalDataSingleAndAdd(String type, String market, String scrip) {
        Gson gson = new Gson();
        String val = this.getHistoricalDataFromServer(type, market, scrip);
        if (val != null) {
            AllContainer allContainer = (AllContainer)gson.fromJson(val, AllContainer.class);
            LogsTC.HistoricalData.put(scrip, allContainer);
            this.updateTechnicals(market, scrip, allContainer);
            this.setHistoricalData(market, scrip, allContainer);
        } else {
            this.setBackground(Color.WHITE);
            this.empty();
            if (this.chartGraph != null && this.chartGraph.companySnapShotPanel != null) {
                this.chartGraph.companySnapShotPanel.addData(HistoricalDataType.CompanySnapshot, null);
            }
        }
        return "";
    }

    private String getHistoricalDataFromServer(String type, String market, String scrip) {
        try {
            String inputLine;
            System.err.println("Type = " + type + " , Market = " + market + " , Scrip = " + scrip);
            String encodedUrl = URLEncoder.encode(scrip, "UTF-8");
            String call = AppConfig.JCR_VIS_Data_URL.replaceFirst("TCFeedFetcher", "") + "/DataServiceServlet?service=" + type + "&scrip=" + encodedUrl;
            StringBuilder sb = new StringBuilder();
            URL url = new URL(call);
            URLConnection yc = url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                sb.append(inputLine);
            }
            in.close();
            Mediator.getInstance().println("Historical Value URL = " + call);
            Mediator.getInstance().println("Historical Value HTML = " + sb.toString());
            return sb.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void empty() {
        this.removeAll();
        this.repaint();
    }

    private void setHistoricalData(String market, String scrip, final AllContainer allContainer) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HistoricalPanel.this.setBackground(Color.WHITE);
                HistoricalPanel.this.empty();
                if (allContainer != null) {
                    FundamentalsContainer fundamentalsContainer = allContainer.getFundamentalsContainer();
                    PerformanceContainer performanceContainer = allContainer.getPerformanceContainer();
                    TechnicalsContainer technicalsContainer = allContainer.getTechnicalsContainer();
                    ValuationContainer valuationContainer = allContainer.getValuationContainer();
                    CompanySnapshotContainer companySnapshotContainer = allContainer.getCompanySnapshotContainer();
                    HistoricalPanel.this.addValuesPanelColumn(HistoricalDataType.Valuations, valuationContainer.list);
                    HistoricalPanel.this.addValuesPanelColumn(HistoricalDataType.Fundamentals, fundamentalsContainer.list);
                    HistoricalPanel.this.addValuesPanelColumn(HistoricalDataType.Performance, performanceContainer.list);
                    HistoricalPanel.this.addValuesPanelColumn(HistoricalDataType.Technicals, technicalsContainer.list);
                    if (HistoricalPanel.this.chartGraph != null) {
                        if (((HistoricalPanel)HistoricalPanel.this).chartGraph.companySnapShotPanel != null) {
                            ((HistoricalPanel)HistoricalPanel.this).chartGraph.companySnapShotPanel.addData(HistoricalDataType.CompanySnapshot, companySnapshotContainer.list);
                        }
                        HistoricalPanel.this.repaint();
                        HistoricalPanel.this.chartGraph.revalidate();
                    }
                } else if (HistoricalPanel.this.chartGraph != null && ((HistoricalPanel)HistoricalPanel.this).chartGraph.companySnapShotPanel != null) {
                    ((HistoricalPanel)HistoricalPanel.this).chartGraph.companySnapShotPanel.addData(HistoricalDataType.CompanySnapshot, null);
                }
            }
        });
    }

    private void addHeaderColumn(JPanel p, HistoricalDataType type) {
        ImageIcon icon = null;
        if (type == HistoricalDataType.Fundamentals) {
            icon = new ImageIcon(this.getClass().getResource("/Images/fundamental12.png"));
        } else if (type == HistoricalDataType.Performance) {
            icon = new ImageIcon(this.getClass().getResource("/Images/performance12.png"));
        } else if (type == HistoricalDataType.Technicals) {
            icon = new ImageIcon(this.getClass().getResource("/Images/technical12.png"));
        } else if (type == HistoricalDataType.Valuations) {
            icon = new ImageIcon(this.getClass().getResource("/Images/valuation12.png"));
        }
        HeaderPanel lblTitle = new HeaderPanel();
        lblTitle.setHeader(type.toString(), icon);
        lblTitle.setPreferredSize(new Dimension(218, 20));
        p.add(lblTitle);
    }

    private void addValuesPanelColumn(HistoricalDataType type, List list) {
        JLabel lblSpace = new JLabel();
        lblSpace.setPreferredSize(new Dimension(220, 5));
        NxGWrapLayout layoutSingleData = new NxGWrapLayout(0);
        layoutSingleData.setHgap(0);
        layoutSingleData.setVgap(0);
        JPanel pnlSingleData = new JPanel((LayoutManager)layoutSingleData);
        pnlSingleData.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.shadow")));
        pnlSingleData.setPreferredSize(new Dimension(220, 145));
        NxGWrapLayout layoutData = new NxGWrapLayout(1);
        layoutData.setHgap(0);
        layoutData.setVgap(0);
        JPanel pnlData = new JPanel((LayoutManager)layoutData);
        pnlData.setBackground(Color.WHITE);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setPreferredSize(new Dimension(218, 122));
        this.scrollPane.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0, 0)));
        this.addHeaderColumn(pnlData, type);
        for (int i = 0; i < list.size(); ++i) {
            ValueBean bean = (ValueBean)list.get(i);
            HistPanelColumn pnlValue = new HistPanelColumn(bean.title, bean.title_tooltip, bean.value, bean.value_tooltip, bean.color);
            pnlData.add(pnlValue);
        }
        this.add(pnlData);
        this.repaint();
    }

    private void updateTechnicals(String Market, String scrip, AllContainer allContainer) {
        TechnicalsContainer ValCont = allContainer.getTechnicalsContainer();
        ValCont.list.clear();
        MarketFeed feed = Mediator.getInstance().MwPanel.GetSingleFeed(scrip, Market);
        if (feed != null) {
            double high = Double.parseDouble(feed.high);
            double low = Double.parseDouble(feed.low);
            double closePrice = Double.parseDouble(feed.closePrice);
            double pivot = (high + low + closePrice) / 3.0;
            double support1 = 2.0 * pivot - high;
            double support2 = pivot - (high - low);
            double support3 = pivot - 2.0 * (high - low);
            double resistance1 = 2.0 * pivot - low;
            double resistance2 = pivot + (high - low);
            double resistance3 = pivot + 2.0 * (high - low);
            TechnicalsBean highBean = new TechnicalsBean();
            highBean.title = "High";
            highBean.value = Util.format2digit((String)(high + "")) + " PKR";
            ValCont.add(highBean);
            TechnicalsBean lowBean = new TechnicalsBean();
            lowBean.title = "Low";
            lowBean.value = Util.format2digit((String)("" + low)) + " PKR";
            ValCont.add(lowBean);
            TechnicalsBean closePriceBean = new TechnicalsBean();
            closePriceBean.title = "Close Price";
            closePriceBean.value = Util.format2digit((String)("" + closePrice)) + " PKR";
            ValCont.add(closePriceBean);
            TechnicalsBean support1Bean = new TechnicalsBean();
            support1Bean.title = "Support-1";
            support1Bean.value = Util.format2digit((String)("" + support1)) + " PKR";
            ValCont.add(support1Bean);
            TechnicalsBean support2Bean = new TechnicalsBean();
            support2Bean.title = "Support-2";
            support2Bean.value = Util.format2digit((String)("" + support2)) + " PKR";
            ValCont.add(support2Bean);
            TechnicalsBean support3Bean = new TechnicalsBean();
            support3Bean.title = "Support-3";
            support3Bean.value = Util.format2digit((String)("" + support3)) + " PKR";
            ValCont.add(support3Bean);
            TechnicalsBean resistance1Bean = new TechnicalsBean();
            resistance1Bean.title = "Resistance-1";
            resistance1Bean.value = Util.format2digit((String)("" + resistance1)) + " PKR";
            ValCont.add(resistance1Bean);
            TechnicalsBean resistance2Bean = new TechnicalsBean();
            resistance2Bean.title = "Resistance-2";
            resistance2Bean.value = Util.format2digit((String)("" + resistance2)) + " PKR";
            ValCont.add(resistance2Bean);
            TechnicalsBean resistance3Bean = new TechnicalsBean();
            resistance3Bean.title = "Resistance-3";
            resistance3Bean.value = Util.format2digit((String)("" + resistance3)) + " PKR";
            ValCont.add(resistance3Bean);
        }
    }

    private void initComponents() {
        this.setBackground(new Color(255, 255, 255));
    }

    private class HistoricalDataLoad
    extends Thread {
        private final String market2;
        private final String scrip2;

        public HistoricalDataLoad(String market, String scrip) {
            this.market2 = market;
            this.scrip2 = scrip;
            this.setName("loaddata (" + market + " , " + scrip + ")");
        }

        @Override
        public void run() {
            HistoricalPanel.this.empty();
            try {
                if (LogsTC.HistoricalData.containsKey(this.scrip2)) {
                    HistoricalPanel.this.updateTechnicals(HistoricalPanel.this.market, this.scrip2, LogsTC.HistoricalData.get(this.scrip2));
                    HistoricalPanel.this.setHistoricalData(this.market2, this.scrip2, LogsTC.HistoricalData.get(this.scrip2));
                } else {
                    HistoricalPanel.this.getHistoricalDataSingleAndAdd("HistoricalData", this.market2, this.scrip2);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

