/*
 * Decompiled with CFR 0.152.
 */
package Sockets;

import CATALYST.Control.Utilities;
import CATALYST.Socket.MessageRecieveEvent;
import CATALYST.Socket.MessageRecieveListner;
import CATALYST.Socket.MyTcp;
import CATALYST.Socket.SocketStatus;
import CATALYST.Socket.Status;
import Chart.IndexGraph;
import Chart.NewOrder;
import MyDocking.Mediator;
import MyDocking.MessageWindowCenter;
import MyDocking.TradeCast;
import Ticker.TickerFeed;
import Utilities.LogsTC;
import Utilities.Voice;
import common.bean.ExchangeStateBean;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.LoginMode;
import http.HttpStatus;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import kse.util.LogsKSE;
import windows.pmex.PMEX_Ladder;
import windows.pmex.PMEX_MBP;

public class FeedClient
implements MessageRecieveListner {
    public MyTcp tcp = null;
    private Mediator mediator = Mediator.getInstance();
    private MessageWindowCenter msgCenter = MessageWindowCenter.getInstance();
    private boolean FirstAttempt = true;

    public FeedClient() {
        SocketStatus FS = new SocketStatus();
        FS.SocketName = "Feed Server";
        FS.HouseName = AppConfig.houseName;
        FS.UserID = LogCommon.UserID;
        FS.ServerIP = AppConfig.feedServerIP;
        FS.ServerIPList = AppConfig.feedServerIPList;
        FS.Port = AppConfig.feedServerPort;
        FS.ConnectAttempt = 5;
        FS.Debug = false;
        FS.EnablePingPong = true;
        FS.isDoQueueEmptyOnConnect = true;
        FS.PingPongMessage = "HELLO|%";
        FS.PingPongOutDelay = 5000;
        FS.MessageParser = "%";
        FS.isWriteLogIntoFile = LogCommon.isWriteLogIntoFile;
        this.tcp = new MyTcp(FS);
        this.tcp.setName("Feed Client Thread");
        this.tcp.addListener((MessageRecieveListner)this);
        this.tcp.start();
    }

    public void Disconnect() {
        this.tcp.Dispose();
    }

    public void SendMsgToFeedServer(String str, String action) {
        this.mediator.SendMsgToFeedServer(str, action);
    }

    public void SendFeedCounterMessage(String action) {
        this.SendMsgToFeedServer("MKT-COUNTER|" + ++LogsKSE.mktFeedCounter, action);
    }

    public synchronized void MessageRecieved(MessageRecieveEvent Event2) {
        Object obj = Event2.getSource();
        if (obj == this.tcp) {
            this.FeedServerReceivedMessages(Event2);
        } else if (LogsTC.Http_Feed_Status == HttpStatus.Active) {
            this.FeedServerReceivedMessages(Event2);
        }
    }

    private void FeedServerReceivedMessages(MessageRecieveEvent Event2) {
        try {
            this.mediator.println(Event2.getmessage());
            String Msg = Event2.getmessage();
            String[] responseList = Utilities.split((String)Msg, (char)'%');
            for (int i = 0; i < responseList.length; ++i) {
                String singleFeed;
                String[] allFeed;
                String msg;
                int j;
                if (responseList[i].trim().length() <= 0) continue;
                String[] messageString = Utilities.split((String)responseList[i], (char)'*');
                if (messageString[0].compareTo("Welcome") == 0 || messageString[0].compareTo("Hello") == 0 || messageString[0].compareTo("[OnRCV]") == 0 || messageString[0].compareTo("[SHOW]") == 0) {
                    // empty if block
                }
                if (messageString[0].compareTo("Welcome") == 0) {
                    AppConfig._isWelComeRecv = true;
                    if (AppConfig.loginMode == LoginMode.KSE) {
                        this.mediator.sendFeedSymbols("", "Feed Received Welcome : KSE");
                    } else if (AppConfig.loginMode == LoginMode.PMEX) {
                        this.mediator.sendFeedContract("", "Feed Received Welcome : PMEX");
                    } else if (AppConfig.loginMode == LoginMode.KSEPMEX) {
                        this.mediator.sendFeedSymbols("", "Feed Received Welcome : KSEPMEX");
                        this.mediator.sendFeedContract("", "Feed Received Welcome : KSEPMEX");
                    }
                    TradeCast.getInstance().CheckTickerFeed();
                }
                if (messageString[0].compareTo("EXS-FEED") == 0) {
                    this.SendFeedCounterMessage("Feed Received : EXS-FEED");
                    String[] feeds = Utilities.split((String)messageString[1], (char)'$');
                    for (j = 0; j < feeds.length - 1; ++j) {
                        String feed = feeds[j].split("\\^", -1)[1];
                        ExchangeStateBean ExRate = ExchangeStateBean.parse((String)feed);
                        LogCommon.ExStatsFeedMap.put(ExRate.getMarket(), ExRate);
                    }
                    if (this.mediator.exstats != null) {
                        this.mediator.exstats.update((ExchangeStateBean)LogCommon.ExStatsFeedMap.get(this.mediator.exstats.getMarket()));
                    }
                    if (this.mediator.exchangestatssummery != null) {
                        this.mediator.exchangestatssummery.updateExChangeStats();
                    }
                    if (this.msgCenter.priceAlertTab != null) {
                        this.msgCenter.priceAlertTab.ExSReceived();
                    }
                    if (TradeCast.getInstance().GraphWindowHolder.size() > 0) {
                        for (JComponent comp : TradeCast.getInstance().GraphWindowHolder.values()) {
                            if (!(comp instanceof IndexGraph)) continue;
                            IndexGraph indexgraph = (IndexGraph)comp;
                            indexgraph.FeedRecieved();
                        }
                    }
                }
                if (messageString[0].equalsIgnoreCase("AUTHENTICATE_END")) {
                    // empty if block
                }
                if (messageString[0].compareTo("MBO-FEED") == 0) {
                    this.SendFeedCounterMessage("Feed Received : MBO-FEED");
                    if (this.mediator.mbo != null) {
                        this.mediator.mbo.update(messageString[1]);
                    }
                }
                if (messageString[0].compareTo("MBP-FEED") == 0) {
                    this.SendFeedCounterMessage("Feed Received : MBP-FEED");
                    if (this.mediator.mbp != null) {
                        this.mediator.mbp.update(messageString[1]);
                    }
                }
                if (messageString[0].compareTo("DQ-FEED") == 0) {
                    this.SendFeedCounterMessage("Feed Received : DQ-FEED");
                    if (this.mediator.detailedQuote != null) {
                        this.mediator.detailedQuote.updateBidOffer(messageString[1]);
                    }
                }
                if (messageString[0].compareTo("MKT-FEED") == 0) {
                    this.SendFeedCounterMessage("Feed Received : MKT-FEED");
                    if (messageString[1].trim().length() > 0) {
                        if (AppConfig.isHistoricalDataWatch) {
                            this.mediator.MwPanel.MyMarketWatchHistorical1.marketWatch.NotifyMKTFeedRecieved(messageString[1]);
                            this.mediator.MwPanel.MyMarketWatchHistorical2.marketWatch.NotifyMKTFeedRecieved(messageString[1]);
                            this.mediator.MwPanel.MyMarketWatchHistorical3.marketWatch.NotifyMKTFeedRecieved(messageString[1]);
                        } else {
                            this.mediator.MwPanel.MyMarketWatch1.Mwh.NotifyMKTFeedRecieved(messageString[1]);
                            this.mediator.MwPanel.MyMarketWatch2.Mwh.NotifyMKTFeedRecieved(messageString[1]);
                            this.mediator.MwPanel.MyMarketWatch3.Mwh.NotifyMKTFeedRecieved(messageString[1]);
                        }
                        if (AppConfig.isHistoricalDataWatch) {
                            this.mediator.MwPanel.MySectorWatchHistorical.Mwh.NotifyMKTFeedRecieved(messageString[1]);
                        } else {
                            this.mediator.MwPanel.MySectorWatch.Mwh.NotifyMKTFeedRecieved(messageString[1]);
                        }
                        if (AppConfig.isHistoricalDataWatch) {
                            this.mediator.MwPanel.MyINDEXWatchHistorical.NotifyMKTFeedRecieved(messageString[1]);
                        } else {
                            this.mediator.MwPanel.MyINDEXWatch.NotifyMKTFeedRecieved(messageString[1]);
                        }
                        if (AppConfig.isHistoricalDataWatch) {
                            this.mediator.MwPanel.MyCapWatchHistorical.MwhUpperCap.NotifyMKTFeedRecieved(messageString[1]);
                            this.mediator.MwPanel.MyCapWatchHistorical.MwhLowerCap.NotifyMKTFeedRecieved(messageString[1]);
                        } else {
                            this.mediator.MwPanel.MyCapWatch.MwhUpperCap.NotifyMKTFeedRecieved(messageString[1]);
                            this.mediator.MwPanel.MyCapWatch.MwhLowerCap.NotifyMKTFeedRecieved(messageString[1]);
                        }
                        if (AppConfig.isSpotWatch) {
                            if (AppConfig.isHistoricalDataWatch) {
                                this.mediator.spotWatchHistorical.Mwh.NotifyMKTFeedRecieved(messageString[1]);
                            } else {
                                this.mediator.spotWatch.Mwh.NotifyMKTFeedRecieved(messageString[1]);
                            }
                        }
                        if (AppConfig.isHistoricalDataWatch) {
                            this.mediator.shariaWatchHistorical.Mwh.NotifyMKTFeedRecieved(messageString[1]);
                        } else {
                            this.mediator.shariaWatch.Mwh.NotifyMKTFeedRecieved(messageString[1]);
                        }
                        if (AppConfig.isHistoricalDataWatch) {
                            if (!this.mediator.futureWatchHistorical.isSpread) {
                                this.mediator.futureWatchHistorical.Mwh.NotifyMKTFeedRecieved(messageString[1]);
                            } else {
                                this.mediator.futureWatchHistorical.MwhSpread.NotifyMKTFeedRecieved(messageString[1]);
                            }
                        } else if (!this.mediator.futureWatch.isSpread) {
                            this.mediator.futureWatch.Mwh.NotifyMKTFeedRecieved(messageString[1]);
                        } else {
                            this.mediator.futureWatch.MwhSpread.NotifyMKTFeedRecieved(messageString[1]);
                        }
                        if (this.mediator.portfolioWatch != null) {
                            this.mediator.portfolioWatch.Mwh.NotifyMKTFeedRecieved(messageString[1]);
                        }
                        if (this.mediator.portfolioWatchAdv != null) {
                            this.mediator.portfolioWatchAdv.Mwh.NotifyMKTFeedRecieved(messageString[1]);
                            this.mediator.portfolioWatchAdv.FeedReceived();
                        }
                        if (this.mediator.portfolioWatchHistorical != null) {
                            this.mediator.portfolioWatchHistorical.Mwh.NotifyMKTFeedRecieved(messageString[1]);
                            this.mediator.portfolioWatchHistorical.FeedReceived();
                        }
                        if (this.mediator.detailedQuote != null) {
                            this.mediator.detailedQuote.Update("Feed Client : MKT-FEED");
                            this.mediator.detailedQuote.UpdateMkt();
                        }
                        if (this.mediator.bunchOrder != null) {
                            this.mediator.bunchOrder.FeedRecieved(false);
                        }
                        if (this.mediator.buysell != null) {
                            this.mediator.buysell.FeedRecieved(false);
                        }
                        if (this.mediator.shortsell != null) {
                            this.mediator.shortsell.FeedRecieved(false);
                        }
                        if (this.mediator.cancel != null) {
                            this.mediator.cancel.FeedRecieved(false);
                        }
                        if (this.mediator.changeOrder != null) {
                            this.mediator.changeOrder.FeedRecieved(false);
                        }
                        if (this.mediator.fundamentalForm != null) {
                            this.mediator.fundamentalForm.updateTableNew();
                        }
                        if (this.mediator.tradingSignal != null) {
                            this.mediator.tradingSignal.updateTableNew();
                        }
                        if (this.msgCenter.priceAlertTab != null) {
                            this.msgCenter.priceAlertTab.update();
                        }
                        if (this.mediator.scriptDetail != null) {
                            this.mediator.scriptDetail.FeedRecieved(messageString[1]);
                        }
                        if (TradeCast.getInstance().GraphWindowHolder.size() > 0) {
                            for (JComponent comp : TradeCast.getInstance().GraphWindowHolder.values()) {
                                if (!(comp instanceof NewOrder)) continue;
                                NewOrder newOrder = (NewOrder)comp;
                                newOrder.FeedRecieved(messageString[1]);
                            }
                        }
                        TradeCast.getInstance().UpdateCappedAndLocked();
                    }
                }
                if (messageString[0].compareTo("TICKER-FEED") == 0) {
                    this.SendFeedCounterMessage("Feed Received : TICKER-FEED");
                    if (messageString[1].compareTo("BYVOLUME") == 0 || messageString[1].compareTo("BYPRICEINCREASE") == 0 || messageString[1].compareTo("BYPRICEDECREASE") == 0 || messageString[1].compareTo("BYPERCENTINCREASE") == 0 || messageString[1].compareTo("BYPERCENTDECREASE") == 0) {
                        TradeCast.getInstance().SetTopMovers(messageString[2]);
                    } else {
                        TickerFeed.UpdateRate(messageString[1]);
                    }
                    TradeCast.getInstance().UpdateTickerRate();
                }
                if (messageString[0].compareTo("SYMBOL-NAMES") == 0) {
                    this.SendFeedCounterMessage("Feed Received : SYMBOL-NAMES");
                }
                if (messageString[0].compareTo("MARKETNAME") == 0) {
                    // empty if block
                }
                if (messageString[0].compareTo("ADDUCAP") == 0) {
                    this.SendFeedCounterMessage("Feed Received : ADDUCAP");
                    LogsTC.Cap.AddCap(messageString[1], messageString[2], "UpperON");
                    TradeCast.getInstance().AddUpperCapInTicker(messageString[1]);
                    if (LogCommon.isShowCapMessageAlert && AppConfig.loginMode != LoginMode.PMEX) {
                        msg = messageString[1] + " at Upper CAP, Last Trade Price is " + messageString[2];
                        this.speakCapsMessages(msg);
                        this.msgCenter.AddMessageInMsgWin("<>" + this.mediator.myTime.getTime() + " - " + msg, new Color(211, 232, 208), new Color(57, 106, 63));
                    }
                    if (AppConfig.isHistoricalDataWatch) {
                        this.mediator.MwPanel.MyCapWatchHistorical.AddUpperCAPSymbol(messageString[1]);
                    } else {
                        this.mediator.MwPanel.MyCapWatch.AddUpperCAPSymbol(messageString[1]);
                    }
                }
                if (messageString[0].compareTo("RUCAP") == 0) {
                    this.SendFeedCounterMessage("Feed Received : RUCAP");
                    LogsTC.Cap.RemoveCap(messageString[1]);
                    TradeCast.getInstance().RemoveUpperCapInTicker(messageString[1]);
                    if (LogCommon.isShowCapMessageAlert && AppConfig.loginMode != LoginMode.PMEX) {
                        msg = "Upper CAP removed from " + messageString[1].trim() + ", Last Trade Price is " + messageString[2];
                        this.speakCapsMessages(msg);
                        this.msgCenter.AddMessageInMsgWin("<>" + this.mediator.myTime.getTime() + " - " + msg, Color.WHITE, new Color(57, 106, 63));
                    }
                    if (AppConfig.isHistoricalDataWatch) {
                        this.mediator.MwPanel.MyCapWatchHistorical.RemoveUpperCAPSymbol(messageString[1]);
                    } else {
                        this.mediator.MwPanel.MyCapWatch.RemoveUpperCAPSymbol(messageString[1]);
                    }
                }
                if (messageString[0].compareTo("ADDLCAP") == 0) {
                    this.SendFeedCounterMessage("Feed Received : ADDLCAP");
                    LogsTC.Cap.AddCap(messageString[1], messageString[2], "LowerON");
                    TradeCast.getInstance().AddLowerLockInTicker(messageString[1]);
                    if (LogCommon.isShowCapMessageAlert && AppConfig.loginMode != LoginMode.PMEX) {
                        msg = messageString[1].trim() + " at Lower Lock now, Last Trade Price is " + messageString[2];
                        this.speakCapsMessages(msg);
                        this.msgCenter.AddMessageInMsgWin("<>" + this.mediator.myTime.getTime() + " - " + msg, new Color(255, 225, 225), new Color(210, 93, 93));
                    }
                    if (AppConfig.isHistoricalDataWatch) {
                        this.mediator.MwPanel.MyCapWatchHistorical.AddLowerCAPSymbol(messageString[1]);
                    } else {
                        this.mediator.MwPanel.MyCapWatch.AddLowerCAPSymbol(messageString[1]);
                    }
                }
                if (messageString[0].compareTo("RLCAP") == 0) {
                    this.SendFeedCounterMessage("Feed Received : RLCAP");
                    LogsTC.Cap.RemoveCap(messageString[1]);
                    TradeCast.getInstance().RemoveLowerLockInTicker(messageString[1]);
                    if (LogCommon.isShowCapMessageAlert && AppConfig.loginMode != LoginMode.PMEX) {
                        msg = "Lower Lock removed from " + messageString[1].trim() + ", Last Trade Price is " + messageString[2];
                        this.speakCapsMessages(msg);
                        this.msgCenter.AddMessageInMsgWin("<>" + this.mediator.myTime.getTime() + " - " + msg, Color.WHITE, new Color(210, 93, 93));
                    }
                    if (AppConfig.isHistoricalDataWatch) {
                        this.mediator.MwPanel.MyCapWatchHistorical.RemoveLowerCAPSymbol(messageString[1]);
                    } else {
                        this.mediator.MwPanel.MyCapWatch.RemoveLowerCAPSymbol(messageString[1]);
                        TradeCast.getInstance().RemoveLowerLockInTicker(messageString[1]);
                    }
                }
                if (messageString[0].compareTo("CAPS-SYMBOLS") == 0) {
                    this.SendFeedCounterMessage("Feed Received : CAPS-SYMBOLS");
                    this.mediator.logsCommon.addCaps(messageString[1]);
                    if (this.mediator.detailedQuote != null) {
                        this.mediator.detailedQuote.updateMinMax();
                    }
                }
                if (messageString[0].compareTo("ADDSPOT") == 0 && AppConfig.isSpotWatch) {
                    this.SendFeedCounterMessage("Feed Received : ADDSPOT");
                    if (LogCommon.isShowSpotMessageAlert && AppConfig.loginMode != LoginMode.PMEX) {
                        this.msgCenter.AddMessageInMsgWin("<>" + this.mediator.myTime.getTime() + " - " + messageString[1] + " is Spot", new Color(249, 247, 194), new Color(86, 81, 48));
                    }
                    if (AppConfig.isSpotWatch) {
                        if (AppConfig.isHistoricalDataWatch) {
                            this.mediator.MwPanel.MySpotWatchHistorical.AddSymbol(messageString[1]);
                        } else {
                            this.mediator.MwPanel.MySpotWatch.AddSymbol(messageString[1]);
                        }
                    }
                }
                if (messageString[0].compareTo("MKT-PMEXFEED") == 0) {
                    this.SendFeedCounterMessage("Feed Received : MKT-PMEXFEED");
                    if (TradeCast.getInstance().Panel_PMEX_Matrix != null) {
                        TradeCast.getInstance().Panel_PMEX_Matrix.feedReceived(messageString[1]);
                    }
                    this.mediator.println(messageString[1]);
                    if (this.mediator.PMEX_MarketWatchPanel != null) {
                        this.mediator.PMEX_MarketWatchPanel.feedReceived(messageString[1]);
                    }
                    this.mediator.PMEX_FeedReceived(messageString[1]);
                    if (this.mediator.pmex_orderBase != null) {
                        this.mediator.pmex_orderBase.FeedRecieved(false);
                    }
                }
                if (messageString[0].compareTo("MBP-PMEXFEED") != 0) continue;
                this.SendFeedCounterMessage("Feed Received : MBP-PMEXFEED");
                if (TradeCast.getInstance().PMEX_LaderWindowHolder.size() > 0) {
                    if (messageString[1].indexOf("|") > 0) {
                        allFeed = messageString[1].split("\\|", -1);
                        for (j = 0; j < allFeed.length; ++j) {
                            singleFeed = allFeed[j];
                            if (singleFeed.trim().length() <= 0) continue;
                            for (PMEX_Ladder pMEX_Ladder : TradeCast.getInstance().PMEX_LaderWindowHolder) {
                                pMEX_Ladder.updateFeedThread(singleFeed + "|");
                            }
                        }
                    } else {
                        for (PMEX_Ladder comp : TradeCast.getInstance().PMEX_LaderWindowHolder) {
                            comp.updateFeedThread(messageString[1] + "|");
                        }
                    }
                }
                if (TradeCast.getInstance().PMEX_MBPWindowHolder.size() <= 0) continue;
                if (messageString[1].indexOf("|") > 0) {
                    allFeed = messageString[1].split("\\|", -1);
                    for (j = 0; j < allFeed.length; ++j) {
                        singleFeed = allFeed[j];
                        if (singleFeed.trim().length() <= 0) continue;
                        for (PMEX_MBP pMEX_MBP : TradeCast.getInstance().PMEX_MBPWindowHolder) {
                            pMEX_MBP.updateFeed(singleFeed);
                        }
                    }
                    continue;
                }
                for (PMEX_MBP comp : TradeCast.getInstance().PMEX_MBPWindowHolder) {
                    comp.updateFeed(messageString[1]);
                }
            }
        }
        catch (Exception ex) {
            this.mediator.WriteExceptionInClientMachine(ex);
        }
    }

    private void FeedServerConnectionStatus(MessageRecieveEvent Event2) {
        Status status = Event2.getConnectionStatus();
        String Msg = Event2.getmessage();
        if (status != Status.NewIP && status != Status.UnableTosend && status != Status.UnableToReceive) {
            this.mediator.SetConnectionStatus(this, status.toString());
            if (status == Status.Active) {
                LogsKSE.FeedOnTCP = true;
            }
        }
        if (Msg.indexOf("Unable To Connect to server") >= 0) {
            LogsKSE.isAuthenticated = false;
            if (AppConfig.HTTPFeedURL.length() == 0 && AppConfig.HTTPTradeURL.length() == 0) {
                AppConfig.setAllValues();
                JOptionPane.showMessageDialog(null, "You have been disconnected from Feed Server.\nPlease try again!", "Disconnection", 0);
                System.exit(0);
            } else if (LogsTC.Http_Feed_Status == HttpStatus.InActive) {
                if (!this.mediator.ConnectToHttp()) {
                    AppConfig.setAllValues();
                    JOptionPane.showMessageDialog(null, "You have been disconnected from Feed Server.\nPlease try again!", "Disconnection", 0);
                    System.exit(0);
                }
                return;
            }
        }
        if (status == Status.Active) {
            LogsKSE.mktFeedCounter = 0;
            if (this.FirstAttempt) {
                this.msgCenter.AddMessageInMsgWin("<>" + this.mediator.myTime.getTime() + " - Feed Server: " + Event2.getmessage());
                this.FirstAttempt = false;
            } else {
                this.msgCenter.AddMessageInMsgWin("<>" + this.mediator.myTime.getTime() + " - Feed Server: " + Event2.getmessage());
            }
        } else if (status == Status.Reconnecting) {
            this.msgCenter.AddMessageInMsgWin("<>" + this.mediator.myTime.getTime() + " - Feed Server: " + Event2.getmessage());
            this.mediator.WriteConnectionInFile("Feed Server: " + this.mediator.myTime.getTime() + " , " + Event2.getConnectionStatus().name() + " , " + Event2.getmessage());
        }
    }

    public synchronized void ConnectionStatus(MessageRecieveEvent Event2) {
        Object obj = Event2.getSource();
        if (obj == this.tcp) {
            this.FeedServerConnectionStatus(Event2);
            if (this.mediator != null) {
                this.mediator.WriteConnectionInFile("Feed Server: " + Event2.getConnectionStatus().name() + " , " + Event2.getmessage());
            }
        }
    }

    public void ConnectionStrength(MessageRecieveEvent event) {
        if (this.mediator.statusBar != null) {
            this.mediator.statusBar.UpdateStrengthBar(event.getStrength(), false);
        }
    }

    private void speakCapsMessages(String msg) {
        if (LogCommon.VoiceAlert_CapMessage) {
            Voice.getInstance().Speak(msg);
        }
    }
}

