/*
 * Decompiled with CFR 0.152.
 */
package Ticker;

import MyDocking.Mediator;
import MyDocking.TradeCast;
import Ticker.MyListCellThing;
import common.gui.component.JTextFieldFilter;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.Title;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.text.Document;
import kse.util.LogsKSE;
import kse.util.UtilKSE;

public class CustomizeTicker
extends JDialog {
    DefaultListModel addModel = new DefaultListModel();
    DefaultListModel removeModel = new DefaultListModel();
    String[] AddValues = null;
    String[] RemoveValues = null;
    int Addcount = 0;
    int RemoveCount = 0;
    public String value = "";
    public boolean CustomizeTickerIsOpened = false;
    TradeCast tradeCast = TradeCast.getInstance();
    private MyListCellThing renderAdd = new MyListCellThing();
    private MyListCellThing renderRemove = new MyListCellThing();
    private JList AddList;
    private JButton btnAdd;
    private JButton btnCancel;
    private JButton btnRemove;
    private JButton btnSaveAndExit;
    private JCheckBox isSelectAll;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JLabel lblScripName;
    private JList removeList;
    private JTextField txtAddSysmbol;
    private JTextField txtSymbolList;

    public CustomizeTicker() {
        super((Frame)TradeCast.getInstance().frame, false);
        this.initComponents();
        this.AddList.setCellRenderer(this.renderAdd);
        URL url = CustomizeTicker.class.getResource("/Images/option.png");
        Image img = Toolkit.getDefaultToolkit().getImage(url);
        this.setIconImage(img);
        this.txtSymbolList.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-"));
        this.txtAddSysmbol.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-"));
        this.setDialogLocation();
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizeTicker.this.dispose();
            }
        });
    }

    private void setDialogLocation() {
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension d = kit.getScreenSize();
        int x = d.width / 2 - this.getWidth() / 2;
        int y = d.height / 2 - this.getHeight() / 2;
        this.setLocation(x, y);
    }

    public void SetAddList() {
        int SymSize;
        this.addModel.clear();
        if (this.tradeCast.custom != null && this.tradeCast.custom.VP != null && (SymSize = this.tradeCast.custom.VP.ht.size()) > 0) {
            Enumeration<String> enumera = this.tradeCast.custom.VP.ht.keys();
            while (enumera.hasMoreElements()) {
                this.addModel.addElement(enumera.nextElement());
                this.AddList.setModel(this.addModel);
            }
        }
    }

    public void fillCustomizeTickerSymbolData() {
        this.isSelectAll.setSelected(false);
        this.removeModel.clear();
        Vector v = new Vector(LogCommon.SymbolAndSymbolName.keySet());
        Collections.sort(v);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            if (this.getSymbolInfoIn_List(key)) continue;
            this.removeModel.addElement(key);
        }
        this.removeList.setModel(this.removeModel);
        this.removeList.setCellRenderer(this.renderRemove);
    }

    public boolean getSymbolInfoIn_List(String Symbol) {
        boolean sym = false;
        for (int i = 0; i < this.addModel.size(); ++i) {
            if (!this.addModel.get(i).toString().equalsIgnoreCase(Symbol)) continue;
            sym = true;
            break;
        }
        return sym;
    }

    public void AddListData() {
        if (this.AddList.getSelectedIndex() != -1) {
            Object[] addSelectedList = this.AddList.getSelectedValues();
            int[] addSelectedListIndices = this.AddList.getSelectedIndices();
            for (int i = 0; i < addSelectedList.length; ++i) {
                this.removeModel.addElement(addSelectedList[i]);
                this.addModel.remove(addSelectedListIndices[i] - i);
                this.removeList.setModel(this.removeModel);
            }
        }
        this.SortRemoveModel();
    }

    public void RemoveListData() {
        if (this.removeList.getSelectedIndex() != -1) {
            Object[] removeSelectedList = this.removeList.getSelectedValues();
            int[] removeSelectedListIndices = this.removeList.getSelectedIndices();
            if (this.addModel.getSize() + removeSelectedList.length >= AppConfig.customTickerLimit) {
                JOptionPane.showMessageDialog(this, "You can not add more than " + AppConfig.customTickerLimit + " Scrip.");
                return;
            }
            for (int i = 0; i < removeSelectedList.length; ++i) {
                this.addModel.addElement(removeSelectedList[i]);
                this.removeModel.remove(removeSelectedListIndices[i] - i);
                this.AddList.setModel(this.addModel);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Please select Scrip from list to add in Ticker.");
        }
        this.SortAddModel();
    }

    public void SortAddModel() {
        Vector v = new Vector();
        for (int i = 0; i < this.addModel.size(); ++i) {
            v.addElement(this.addModel.getElementAt(i));
        }
        this.addModel.removeAllElements();
        this.AddList.removeAll();
        this.addModel.clear();
        Collections.sort(v);
        Enumeration enu = v.elements();
        while (enu.hasMoreElements()) {
            String sys = enu.nextElement().toString();
            this.addModel.addElement(sys);
            this.AddList.setModel(this.addModel);
        }
    }

    public void SortRemoveModel() {
        Vector v = new Vector();
        for (int i = 0; i < this.removeModel.size(); ++i) {
            v.addElement(this.removeModel.getElementAt(i));
        }
        this.removeModel.removeAllElements();
        this.removeList.removeAll();
        this.removeModel.clear();
        Collections.sort(v);
        Enumeration enu = v.elements();
        while (enu.hasMoreElements()) {
            String sys = enu.nextElement().toString();
            this.removeModel.addElement(sys);
            this.removeList.setModel(this.removeModel);
        }
    }

    public String getListValues() {
        String values = "";
        LogsKSE.CustomScrip = "";
        for (int i = 0; i < this.addModel.size(); ++i) {
            String symbol = this.addModel.get(i).toString();
            String mkt = UtilKSE.GetMarketFromsymbol((String)symbol);
            values = values + symbol + ";";
        }
        return values;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.txtSymbolList = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.removeList = new JList();
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this.jLabel2 = new JLabel();
        this.txtAddSysmbol = new JTextField();
        this.jScrollPane2 = new JScrollPane();
        this.AddList = new JList();
        this.isSelectAll = new JCheckBox();
        this.lblScripName = new JLabel();
        this.btnSaveAndExit = new JButton();
        this.jSeparator1 = new JSeparator();
        this.btnCancel = new JButton();
        this.setTitle("Custom Setting");
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Scrip");
        this.txtSymbolList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizeTicker.this.txtSymbolListActionPerformed(evt);
            }
        });
        this.removeList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CustomizeTicker.this.removeListMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                CustomizeTicker.this.removeListMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                CustomizeTicker.this.removeListMouseExited(evt);
            }
        });
        this.removeList.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                CustomizeTicker.this.removeListMouseMoved(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.removeList);
        this.btnAdd.setText("Add >>");
        this.btnAdd.setName("CustomizeTicker -> btnAdd");
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizeTicker.this.btnAddActionPerformed(evt);
            }
        });
        this.btnRemove.setText("<< Remove");
        this.btnRemove.setName("CustomizeTicker -> btnRemove");
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizeTicker.this.btnRemoveActionPerformed(evt);
            }
        });
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("Added Scrip");
        this.txtAddSysmbol.setPreferredSize(new Dimension(33, 20));
        this.txtAddSysmbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizeTicker.this.txtAddSysmbolActionPerformed(evt);
            }
        });
        this.AddList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CustomizeTicker.this.AddListMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                CustomizeTicker.this.AddListMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                CustomizeTicker.this.AddListMousePressed(evt);
            }
        });
        this.AddList.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                CustomizeTicker.this.AddListMouseMoved(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.AddList);
        this.isSelectAll.setText("Select All");
        this.isSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizeTicker.this.isSelectAllActionPerformed(evt);
            }
        });
        this.lblScripName.setText(" ");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.txtSymbolList)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnAdd, -1, -1, Short.MAX_VALUE).addComponent(this.btnRemove, -1, -1, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.lblScripName, -2, 202, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.isSelectAll).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING, -1, 104, Short.MAX_VALUE).addComponent(this.jLabel2, -1, 104, Short.MAX_VALUE).addComponent(this.txtAddSysmbol, GroupLayout.Alignment.TRAILING, -1, 104, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtAddSysmbol, -2, -1, -2).addComponent(this.txtSymbolList, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane2).addComponent(this.jScrollPane1, -1, 163, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 6, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.isSelectAll).addComponent(this.lblScripName, -2, 18, -2))).addGroup(jPanel1Layout.createSequentialGroup().addGap(60, 60, 60).addComponent(this.btnAdd).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnRemove).addContainerGap(121, Short.MAX_VALUE)));
        this.btnSaveAndExit.setText("Save and Exit");
        this.btnSaveAndExit.setName("CustomizeTicker -> btnSaveAndExit");
        this.btnSaveAndExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizeTicker.this.btnSaveAndExitActionPerformed(evt);
            }
        });
        this.btnCancel.setText("Cancel");
        this.btnCancel.setName("CustomizeTicker -> btnCancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizeTicker.this.btnCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 358, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 134, Short.MAX_VALUE).addComponent(this.btnSaveAndExit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel, -2, 99, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(0, 6, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 2, -2).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSaveAndExit, -2, 25, -2).addComponent(this.btnCancel, -2, 25, -2)).addGap(3, 3, 3)));
        this.pack();
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        this.RemoveListData();
        this.isSelectAll.setSelected(false);
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        this.AddListData();
        this.isSelectAll.setSelected(false);
    }

    private void removeListMouseEntered(MouseEvent evt) {
    }

    private void removeListMouseClicked(MouseEvent evt) {
        this.btnAdd.setSelected(false);
        this.txtSymbolList.setText(this.removeList.getSelectedValue().toString());
    }

    private void txtSymbolListActionPerformed(ActionEvent evt) {
        this.removeList.setSelectedValue(this.txtSymbolList.getText().toUpperCase(), true);
    }

    private void txtAddSysmbolActionPerformed(ActionEvent evt) {
        this.AddList.setSelectedValue(this.txtAddSysmbol.getText().toUpperCase(), true);
        this.isSelectAll.setSelected(false);
    }

    private void AddListMouseEntered(MouseEvent evt) {
    }

    private void removeListMouseMoved(MouseEvent evt) {
        int index = this.removeList.locationToIndex(evt.getPoint());
        this.renderRemove.setRowNo(index);
        this.removeList.repaint();
        if (-1 < index) {
            String item = (String)this.removeModel.getElementAt(index);
            String ttip = Mediator.getInstance().getSymbolTitle(item);
            this.removeList.setToolTipText(ttip);
            this.lblScripName.setText(ttip);
            Mediator.getInstance().getSymbolTitle(ttip);
        }
    }

    private void AddListMouseMoved(MouseEvent evt) {
        int index = this.AddList.locationToIndex(evt.getPoint());
        this.renderAdd.setRowNo(index);
        this.AddList.repaint();
        if (-1 < index) {
            String item = (String)this.addModel.getElementAt(index);
            String ttip = Mediator.getInstance().getSymbolTitle(item);
            this.AddList.setToolTipText(ttip);
            this.lblScripName.setText(ttip);
        }
    }

    private void btnSaveAndExitActionPerformed(ActionEvent evt) {
        String values = this.getListValues();
        Mediator med = Mediator.getInstance();
        if (values.equalsIgnoreCase("") || values == null) {
            int Option = JOptionPane.showConfirmDialog(this, "You have not selected any scrip. Do you want to add it now?", "Confirmation", 0);
            if (Option != 0) {
                if (med.tradecast.custom != null) {
                    med.tradecast.custom.CloseTicker();
                }
                LogCommon.CustomTicker = values;
                this.dispose();
            }
        } else {
            LogCommon.CustomTicker = values;
            med.tradecast.OpenTicker(Title.Custom, true);
            this.dispose();
        }
        AppConfig.setAllValues();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void isSelectAllActionPerformed(ActionEvent evt) {
        if (this.isSelectAll.isSelected()) {
            this.AddList.setSelectedIndices(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
        } else if (!this.isSelectAll.isSelected()) {
            this.AddList.removeSelectionInterval(0, this.AddList.getModel().getSize());
        }
    }

    private void AddListMousePressed(MouseEvent evt) {
        this.isSelectAll.setSelected(false);
    }

    private void removeListMouseExited(MouseEvent evt) {
        this.renderRemove.setRowNo(-1);
        this.removeList.repaint();
    }

    private void AddListMouseExited(MouseEvent evt) {
        this.renderAdd.setRowNo(-1);
        this.AddList.repaint();
    }
}

