/*
 * Decompiled with CFR 0.152.
 */
package Ticker;

import Ticker.ValuePanel;
import common.gui.util.Util;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;

public class DraggableWindow
extends JWindow
implements MouseListener,
MouseMotionListener {
    ValuePanel VP;
    private Cursor lastCursor;
    private static Cursor resizeCursor = Cursor.getPredefinedCursor(11);
    private Cursor NewCursor = null;
    public JPopupMenu popup = new JPopupMenu();
    private int changeX;
    private int changeY;
    private int posX;
    private int posY;
    private int Frame_Start_Width;
    private int Frame_Start_X;
    public int PointX = 0;
    public int PointY = 0;
    int x = 0;
    int y = 0;

    public DraggableWindow() {
        Util.setWindowOpaque((Window)this, (boolean)false);
        this.setAlwaysOnTop(false);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.getCursor() != resizeCursor) {
            this.changeX = e.getX() - this.posX;
            this.changeY = e.getY() - this.posY;
            this.PointX = this.getLocation().x + this.changeX;
            this.PointY = this.getLocation().y + this.changeY;
            this.setLocation(e.getXOnScreen() - this.x, e.getYOnScreen() - this.y);
            this.setCursor(Cursor.getPredefinedCursor(13));
            Toolkit.getDefaultToolkit().sync();
            this.repaint();
        }
        if (this.getCursor() == resizeCursor) {
            int newWidth = this.Frame_Start_Width + e.getX() - this.Frame_Start_X;
            if ((newWidth = Math.max(1, newWidth)) < 300) {
                newWidth = 300;
            }
            this.setSize(newWidth, this.getSize().height);
        }
    }

    public void setWindowsStateChange(int i) {
        this.setFocusableWindowState(true);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.posX = e.getX();
        this.posY = e.getY();
        this.x = e.getX();
        this.y = e.getY();
        if (this.getCursor() == resizeCursor) {
            Point p = e.getPoint();
            this.Frame_Start_X = p.x;
            this.Frame_Start_Width = this.getWidth();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        this.NewCursor = this.isMouseOverRowMarginNew(p, e);
        if (this.NewCursor != null) {
            if (this.lastCursor == null) {
                this.lastCursor = this.getCursor();
            }
            this.setCursor(this.NewCursor);
        } else {
            this.setCursor(this.lastCursor);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.VP.SaveSize(this.getWidth());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.VP != null) {
            this.VP.StopTicker = true;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.VP != null) {
            this.VP.StopTicker = false;
        }
    }

    private Cursor isMouseOverRowMarginNew(Point p, MouseEvent e) {
        if (p.x >= this.getSize().width - 3 && p.x <= this.getSize().width) {
            return resizeCursor;
        }
        return null;
    }

    void setValuePanel(ValuePanel VP) {
        this.VP = VP;
    }
}

