/*
 * Decompiled with CFR 0.152.
 */
package Ticker;

import CATALYST.Control.Utilities;
import CustomComponent.RoundBorderPanel;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Ticker.Direction;
import Ticker.DraggableWindow;
import Ticker.TickerIconButton;
import Ticker.TickerParameters;
import Ticker.ValuePanel;
import Utilities.LogsTC;
import common.gui.util.LogCommon;
import common.gui.util.Title;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import kse.util.LogsKSE;
import kse.util.UtilKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class Ticker {
    public boolean showTitles = true;
    public boolean showScripName = true;
    public boolean showPercantage = true;
    public boolean showVolume = false;
    public boolean AlwaysonTop = true;
    public boolean isLeftToRight = false;
    public int SetInvert = 0;
    public String LastTickerName = "";
    JPanel ValuePanelHolder;
    public DraggableWindow draggablewindow = null;
    JPanel outerPanel = null;
    public ValuePanel VP = null;
    private final MouseListener RBListener;
    public JPopupMenu popup = new JPopupMenu();
    public boolean IsDock = false;
    public boolean TickerIsOpened = false;
    public String TickerName = "";
    private JLabel lblTickerName = new JLabel();
    public Mediator mediator = null;
    JPanel HeadingPanel = null;
    public Color HeadingColorLight = new Color(51, 178, 52);
    public Color HeadingColorDark = new Color(113, 205, 113);
    public Color LabelForGroundColor = new Color(51, 178, 52);
    JMenuItem menuTickerSettings = null;
    JMenuItem chmenuDock = null;
    JMenuItem chmenuUnDock = null;
    JMenuItem chmenuShowTitle = null;
    JMenuItem chmenuLeftToRight = null;
    JMenuItem chmenuShowDescription = null;
    JMenuItem chmenuShowPercantageChange = null;
    JMenuItem chMenuVolume = null;
    JMenuItem chmenuResetDefault = null;
    RoundBorderPanel panel = null;
    TickerIconButton buttonPanel = null;
    JMenuItem chmenuUpperCapped = null;
    JMenuItem chmenuLowerLocked = null;
    JMenu topMoversMenu = null;
    JMenuItem chmenuCustom = null;
    JMenu ChmOption = null;
    JMenuItem chmenuClose = null;
    JMenuItem chmenuByVolume = null;
    JMenuItem chmenuBy_PriceIncrease = null;
    JMenuItem chmenuByPriceDecrease = null;
    JMenuItem chmenuByPerIncrease = null;
    JMenuItem chmenuByPerDecrease = null;
    JMenu ChmTickerSpeed = null;
    JCheckBoxMenuItem chmenuFast = null;
    JCheckBoxMenuItem chmenuSlow = null;
    JCheckBoxMenuItem chmenuMedium = null;
    JMenuItem chmenuSetAlwaysOnTop = new JMenuItem("Set Always On Top");
    public JSplitPane sp1 = new JSplitPane();
    boolean ISsplit = false;
    int TikerDividSize = 0;
    public static final int speedSlow = 36;
    public static final int speedMedium = 18;
    public static final int speedFast = Util.isWindow7() ? 10 : 1;
    private LanguageCentre languageCentre = new LanguageCentre();
    ImageIcon tickIcon = null;

    public Ticker(String title_, String TickerName, Color Light, Color Dark, Color LabelForGround) {
        this.mediator = Mediator.getInstance();
        try {
            this.tickIcon = new ImageIcon(this.getClass().getResource("/Images/tick.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.TickerName = TickerName;
        this.VP = new ValuePanel(TickerName, this);
        this.draggablewindow = new DraggableWindow();
        this.outerPanel = new RoundBorderPanel(new Color(255, 255, 255), new Color(230, 231, 230), 0);
        this.outerPanel.setBorder(BorderFactory.createEtchedBorder(new Color(230, 231, 230), null));
        this.lblTickerName.setHorizontalAlignment(0);
        this.lblTickerName.setText(this.languageCentre.getValue(TickerName));
        this.lblTickerName.setOpaque(false);
        this.lblTickerName.setPreferredSize(new Dimension(90, 30));
        this.lblTickerName.setMaximumSize(new Dimension(90, 30));
        this.lblTickerName.setMinimumSize(new Dimension(90, 30));
        this.HeadingColorLight = Light;
        this.HeadingColorDark = Dark;
        this.LabelForGroundColor = LabelForGround;
        this.lblTickerName.setForeground(this.LabelForGroundColor);
        this.HeadingPanel = new RoundBorderPanel(this.HeadingColorLight, this.HeadingColorDark, 0);
        this.HeadingPanel.setPreferredSize(new Dimension(90, 30));
        this.HeadingPanel.setMaximumSize(new Dimension(90, 30));
        this.HeadingPanel.setMinimumSize(new Dimension(90, 30));
        this.HeadingPanel.add(this.lblTickerName);
        this.ValuePanelHolder = new RoundBorderPanel(new Color(255, 255, 255), new Color(230, 231, 230), 0);
        this.ValuePanelHolder.setLayout(null);
        this.ValuePanelHolder.add(this.VP);
        this.ValuePanelHolder.setOpaque(false);
        this.ValuePanelHolder.setBackground(Color.MAGENTA);
        this.draggablewindow.setValuePanel(this.VP);
        JPanel paddingLeft = new JPanel();
        paddingLeft.setPreferredSize(new Dimension(5, 30));
        paddingLeft.setMaximumSize(new Dimension(5, 30));
        paddingLeft.setMinimumSize(new Dimension(5, 30));
        paddingLeft.setOpaque(false);
        paddingLeft.setVisible(true);
        this.outerPanel.add(this.HeadingPanel);
        this.outerPanel.add(paddingLeft);
        this.outerPanel.add(this.ValuePanelHolder);
        this.buttonPanel = new TickerIconButton(this, TickerName);
        this.buttonPanel.setPreferredSize(new Dimension(14, 25));
        this.buttonPanel.setMaximumSize(new Dimension(14, 25));
        this.buttonPanel.setMinimumSize(new Dimension(14, 25));
        this.buttonPanel.setVisible(true);
        this.outerPanel.add(this.buttonPanel);
        this.draggablewindow.add(this.outerPanel);
        this.RBListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    Point p = e.getPoint();
                    if (Ticker.this.IsDock) {
                        Ticker.this.popup.show(Ticker.this.outerPanel, e.getX(), e.getY());
                    } else {
                        Ticker.this.popup.show(Ticker.this.draggablewindow, e.getX(), e.getY());
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                Ticker.this.VP.StopTicker = true;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Ticker.this.VP.StopTicker = false;
            }
        };
        this.draggablewindow.addMouseListener(this.RBListener);
        this.setMenus();
        this.restoreTickerSettings();
        this.VP.StartTimer();
    }

    public void CloseTicker() {
        this.saveTickerSettings();
        String action = "Ticker : CloseTicker = " + this.TickerName + " , TickerIsOpened = " + this.TickerIsOpened;
        if (this.TickerIsOpened && this.TickerName.equalsIgnoreCase(LanguageConstant.UpperCapped)) {
            this.UnDock(this.mediator.tradecast.TickerDToolBar, true);
            this.outerPanel = null;
            this.draggablewindow.VP.StopTicker();
            this.TickerIsOpened = false;
            LogsKSE.UpperCappedScrip = "";
            this.mediator.sendFeedSymbols("", action);
            TradeCast.getInstance().DisposeTicker(this.TickerName);
            this.draggablewindow.VP = null;
            this.draggablewindow.dispose();
        } else if (this.TickerIsOpened && this.TickerName.equalsIgnoreCase(LanguageConstant.LowerLocked)) {
            this.UnDock(this.mediator.tradecast.TickerDToolBar, true);
            this.outerPanel = null;
            this.draggablewindow.VP.StopTicker();
            this.TickerIsOpened = false;
            LogsKSE.LowerLockedScrip = "";
            this.mediator.sendFeedSymbols("", action);
            TradeCast.getInstance().DisposeTicker(this.TickerName);
            this.draggablewindow.VP = null;
            this.draggablewindow.dispose();
        } else if (this.TickerIsOpened && this.TickerName.equalsIgnoreCase(Title.Custom)) {
            this.UnDock(this.mediator.tradecast.TickerDToolBar, true);
            this.outerPanel = null;
            this.draggablewindow.VP.StopTicker();
            this.TickerIsOpened = false;
            this.mediator.SendMsgToFeedServer("TICKER-FEED|REMOVECUSTOM", action);
            TradeCast.getInstance().DisposeTicker(this.TickerName);
            this.draggablewindow.VP = null;
            this.draggablewindow.dispose();
        } else if (this.TickerIsOpened && this.TickerName.equalsIgnoreCase(LanguageConstant.TopMovers)) {
            this.UnDock(this.mediator.tradecast.TickerDToolBar, true);
            this.outerPanel = null;
            this.draggablewindow.VP.StopTicker();
            this.TickerIsOpened = false;
            this.mediator.SendMsgToFeedServer("TICKER-FEED|REMOVETOPMOVERS", action);
            TradeCast.getInstance().DisposeTicker(this.TickerName);
            this.draggablewindow.VP = null;
            this.draggablewindow.dispose();
        }
    }

    public void ResetDefault(ValuePanel vpp, String TickerName) {
        this.ChangeDirection(Direction.RightToLeft);
        this.VP.Speed = 18;
        this.setSpeed();
        this.ShowHideTitle(TickerName, true);
        this.AlwaysonTop = false;
        this.setAlwaysOnTop();
        this.showTitles = true;
        this.chmenuShowTitle.setSelected(false);
        this.VP.ShowHidePercan(true);
        this.showPercantage = true;
        this.chmenuShowPercantageChange.setText("Hide % Change");
        this.chmenuShowPercantageChange.setSelected(false);
        if (this.LastTickerName.equalsIgnoreCase(LanguageConstant.ByVolume)) {
            this.VP.ShowHideVolume(true);
            this.showVolume = true;
            this.chMenuVolume.setText("Hide Volume");
            this.chMenuVolume.setSelected(false);
        } else {
            this.VP.ShowHideVolume(false);
            this.showVolume = false;
            this.chMenuVolume.setText("Show Volume");
            this.chMenuVolume.setSelected(true);
        }
        this.chmenuFast.setSelected(false);
        this.chmenuSlow.setSelected(false);
        this.chmenuMedium.setSelected(true);
        this.VP.ShowHideScripName(true);
        this.showScripName = true;
        this.chmenuShowDescription.setText("Hide Scrip Name");
        this.chmenuShowDescription.setSelected(false);
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (Ticker.this.VP != null) {
                        Ticker.this.VP.UpdateAllValues();
                    }
                }
            });
        }
    }

    public void setTickerSize(int Size) {
        this.draggablewindow.setSize(LogsTC.tickerMap.get((Object)this.TickerName).width, 30);
        this.lblTickerName.setPreferredSize(new Dimension(90, 30));
        this.lblTickerName.setMaximumSize(new Dimension(90, 30));
        this.lblTickerName.setMinimumSize(new Dimension(90, 30));
        this.HeadingPanel.setPreferredSize(new Dimension(90, 30));
        this.HeadingPanel.setMaximumSize(new Dimension(90, 30));
        this.HeadingPanel.setMinimumSize(new Dimension(90, 30));
        this.VP.SetPanelSize(Size);
    }

    public void ChangeDirection(Direction Dir) {
        this.VP.ChangeDirection(Dir);
    }

    public void SetAlwaysOnTop(boolean b) {
        this.draggablewindow.setAlwaysOnTop(b);
    }

    public void SetVisible(boolean b) {
        this.draggablewindow.setVisible(b);
    }

    public void Dock(JComponent comp) {
        this.TickerIsOpened = true;
        this.chmenuDock.setEnabled(false);
        this.chmenuUnDock.setEnabled(true);
        this.IsDock = true;
        this.draggablewindow.setVisible(false);
        this.draggablewindow.remove(this.outerPanel);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        if (!this.mediator.tradecast.ISTickerDocking) {
            JLabel lab = new JLabel();
            lab.setSize(0, 0);
            this.mediator.tradecast.TickerSplitpane[0].setLeftComponent(lab);
            this.mediator.tradecast.TickerSplitpane[0].setDividerLocation(0);
            this.mediator.tradecast.TickerSplitpane[0].setRightComponent(this.mediator.tradecast.TickerSplitpane[1]);
            this.mediator.tradecast.TickerSplitpane[0].setEnabled(false);
            this.mediator.tradecast.TickerSplitpane[1].setLeftComponent(lab);
            this.mediator.tradecast.TickerSplitpane[1].setDividerLocation(0);
            this.mediator.tradecast.TickerSplitpane[1].setRightComponent(this.mediator.tradecast.TickerSplitpane[2]);
            this.mediator.tradecast.TickerSplitpane[1].setEnabled(false);
            this.mediator.tradecast.TickerSplitpane[2].setLeftComponent(lab);
            this.mediator.tradecast.TickerSplitpane[2].setDividerLocation(0);
            this.mediator.tradecast.TickerSplitpane[2].setRightComponent(lab);
            this.mediator.tradecast.TickerSplitpane[2].setEnabled(false);
            this.mediator.tradecast.ISTickerDocking = true;
            comp.add(this.mediator.tradecast.TickerSplitpane[0]);
        }
        if (this.TickerName.equalsIgnoreCase(LanguageConstant.UpperCapped)) {
            this.mediator.tradecast.TickerArray[0] = true;
            this.mediator.tradecast.TickerSplitpane[0].setLeftComponent(this.outerPanel);
        } else if (this.TickerName.equalsIgnoreCase(LanguageConstant.LowerLocked)) {
            this.mediator.tradecast.TickerArray[1] = true;
            this.mediator.tradecast.TickerSplitpane[1].setLeftComponent(this.outerPanel);
        } else if (this.TickerName.equalsIgnoreCase(LanguageConstant.TopMovers)) {
            this.mediator.tradecast.TickerArray[2] = true;
            this.mediator.tradecast.TickerSplitpane[2].setLeftComponent(this.outerPanel);
        } else if (this.TickerName.equalsIgnoreCase(Title.Custom)) {
            this.mediator.tradecast.TickerArray[3] = true;
            this.mediator.tradecast.TickerSplitpane[2].setRightComponent(this.outerPanel);
        }
        this.getTickerSize();
        this.outerPanel.addMouseListener(this.RBListener);
    }

    public void UnDock(final JComponent comp, boolean isClose) {
        this.IsDock = false;
        this.TickerIsOpened = true;
        TickerParameters tp = LogsTC.tickerMap.get(this.TickerName);
        this.setTickerSize(tp.TickerSize);
        this.chmenuDock.setEnabled(true);
        this.chmenuUnDock.setEnabled(false);
        this.draggablewindow.add(this.outerPanel);
        this.draggablewindow.setVisible(false);
        this.VP.StartFromZero(this.draggablewindow.getWidth());
        this.outerPanel.removeMouseListener(this.RBListener);
        for (int i = 0; i < comp.getComponentCount(); ++i) {
            if (comp.getComponent(i) != this.mediator.tradecast.TickerSplitpane[0]) continue;
            if (this.TickerName.equalsIgnoreCase(LanguageConstant.UpperCapped)) {
                this.mediator.tradecast.TickerArray[0] = false;
            } else if (this.TickerName.equalsIgnoreCase(LanguageConstant.LowerLocked)) {
                this.mediator.tradecast.TickerArray[1] = false;
            } else if (this.TickerName.equalsIgnoreCase(LanguageConstant.TopMovers) || this.lblTickerName.getText().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.ByVolume)) || this.lblTickerName.getText().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.ByPriceIncrease)) || this.lblTickerName.getText().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.ByPriceDecrease)) || this.lblTickerName.getText().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.ByPercentIncrease)) || this.lblTickerName.getText().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.ByPercentDecrease))) {
                this.mediator.tradecast.TickerArray[2] = false;
            } else if (this.TickerName.equalsIgnoreCase(Title.Custom)) {
                this.mediator.tradecast.TickerArray[3] = false;
            }
            if (this.getTickerEmptySize() > 0) break;
            this.mediator.tradecast.TickerSplitpane[0].remove(this.outerPanel);
            this.mediator.tradecast.ISTickerDocking = false;
            comp.remove(this.mediator.tradecast.TickerSplitpane[0]);
            break;
        }
        this.getTickerSize();
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    comp.updateUI();
                    comp.repaint();
                    comp.requestFocus();
                }
            });
        } else {
            comp.updateUI();
            comp.repaint();
            comp.requestFocus();
        }
        if (!isClose) {
            if (this.TickerName.equalsIgnoreCase(LanguageConstant.UpperCapped)) {
                this.VP.StopTicker();
                this.VP = null;
                this.draggablewindow = null;
                this.outerPanel = null;
                TradeCast.getInstance().DisposeTicker(this.TickerName);
                TradeCast.getInstance().OpenTicker(this.TickerName, false);
            } else if (this.TickerName.equalsIgnoreCase(LanguageConstant.LowerLocked)) {
                this.VP.StopTicker();
                this.VP = null;
                this.draggablewindow = null;
                this.outerPanel = null;
                TradeCast.getInstance().DisposeTicker(this.TickerName);
                TradeCast.getInstance().OpenTicker(this.TickerName, false);
            } else if (this.TickerName.equalsIgnoreCase(LanguageConstant.TopMovers)) {
                this.VP.StopTicker();
                this.VP = null;
                this.draggablewindow = null;
                this.outerPanel = null;
                TradeCast.getInstance().DisposeTicker(this.TickerName);
                TradeCast.getInstance().OpenTopMovers(this.LastTickerName, this.TickerName, false);
            } else if (this.TickerName.equalsIgnoreCase(Title.Custom)) {
                this.VP.StopTicker();
                this.VP = null;
                this.draggablewindow = null;
                this.outerPanel = null;
                TradeCast.getInstance().DisposeTicker(this.TickerName);
                TradeCast.getInstance().OpenTicker(this.TickerName, false);
            }
        }
    }

    public int getTickerEmptySize() {
        int size = 4;
        int length = this.mediator.tradecast.TickerArray.length;
        for (int i = 0; i < length; ++i) {
            if (this.mediator.tradecast.TickerArray[i]) continue;
            --size;
        }
        return size;
    }

    public int getTickerSize() {
        int count = 0;
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int size = 0;
        int split1 = 0;
        int DividerSize = 0;
        int length = this.mediator.tradecast.TickerArray.length;
        for (int i = 0; i < length; ++i) {
            if (!this.mediator.tradecast.TickerArray[i]) continue;
            ++count;
        }
        for (int j = 0; j < length; ++j) {
            if (!this.mediator.tradecast.TickerArray[j]) continue;
            if (count == 1) {
                size = d.width;
                DividerSize = j == 2 || j == 3 ? 0 : 2;
            } else if (count == 2) {
                size = d.width / 2;
                DividerSize = 2;
            } else if (count == 3) {
                size = d.width / 3;
                DividerSize = 2;
            } else if (count == 4) {
                size = d.width / 4;
                DividerSize = 2;
            }
            split1 = j >= 3 ? 2 : j;
            final int finalDividerSize = DividerSize;
            final int finalsize = size;
            final int finalsplit1 = split1;
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Ticker.this.mediator.tradecast.TickerSplitpane[2].setDividerSize(finalDividerSize);
                        Ticker.this.mediator.tradecast.TickerSplitpane[1].setDividerSize(finalDividerSize);
                        Ticker.this.mediator.tradecast.TickerSplitpane[0].setDividerSize(finalDividerSize);
                        Ticker.this.mediator.tradecast.TickerSplitpane[finalsplit1].setDividerLocation(finalsize);
                        Ticker.this.mediator.tradecast.TickerSplitpane[finalsplit1].setEnabled(true);
                        Ticker.this.mediator.tradecast.TickerSplitpane[finalsplit1].updateUI();
                        Ticker.this.mediator.tradecast.TickerSplitpane[finalsplit1].repaint();
                    }
                });
                continue;
            }
            this.mediator.tradecast.TickerSplitpane[2].setDividerSize(DividerSize);
            this.mediator.tradecast.TickerSplitpane[1].setDividerSize(DividerSize);
            this.mediator.tradecast.TickerSplitpane[0].setDividerSize(DividerSize);
            this.mediator.tradecast.TickerSplitpane[split1].setDividerLocation(size);
            this.mediator.tradecast.TickerSplitpane[split1].setEnabled(true);
            this.mediator.tradecast.TickerSplitpane[split1].updateUI();
            this.mediator.tradecast.TickerSplitpane[split1].repaint();
        }
        return count;
    }

    public void Remove1Dock(String TickerDock, int size) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    }

    public void SetLowerCappedString(String result) {
        LogsKSE.LowerLockedScrip = "";
        this.VP.RemoveAllSymbols();
        if (result.indexOf(";") >= 0) {
            String[] Symbols = result.split(";");
            for (int i = 0; i < Symbols.length; ++i) {
                if (Symbols[i].indexOf(":") < 0) continue;
                String symbol = Symbols[i].split("\\:")[0];
                LogsKSE.LowerLockedScrip = LogsKSE.LowerLockedScrip + symbol + ":" + UtilKSE.GetMarketFromsymbol((String)symbol) + ";";
                this.VP.addSymbol(symbol);
            }
        }
        this.mediator.sendFeedSymbols("", "Ticker : SetLowerCappedString = " + result);
    }

    public void addNewCapORLockedSymbol(String Symbol_, int CapType) {
        final String Symbol = Symbol_.split("\\:")[0];
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Ticker.this.VP.addNewCapORLockedSymbol(Symbol);
                }
            });
        } else {
            this.VP.addNewCapORLockedSymbol(Symbol);
        }
        if (CapType == 1 && LogsKSE.UpperCappedScrip.indexOf(Symbol) < 0) {
            LogsKSE.UpperCappedScrip = LogsKSE.UpperCappedScrip + Symbol + ":" + UtilKSE.GetMarketFromsymbol((String)Symbol) + ";";
        }
        if (CapType == 2 && LogsKSE.LowerLockedScrip.indexOf(Symbol) < 0) {
            LogsKSE.LowerLockedScrip = LogsKSE.LowerLockedScrip + Symbol + ":" + UtilKSE.GetMarketFromsymbol((String)Symbol) + ";";
        }
        this.mediator.sendFeedSymbols("", "Ticker : addNewCapORLockedSymbol " + Symbol_ + " , " + CapType);
    }

    public void RemoveCapORLockedSymbol(String Symbol_, int CapType) {
        int i;
        StringBuffer sb;
        final String Symbol = Symbol_.split("\\:")[0];
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Ticker.this.VP.RemoveCapORLockedSymbol(Symbol);
                }
            });
        } else {
            this.VP.RemoveCapORLockedSymbol(Symbol);
        }
        if (CapType == 1 && LogsKSE.UpperCappedScrip.toUpperCase().indexOf(Symbol.toUpperCase()) > -1) {
            String[] UCSymbols = Utilities.split((String)LogsKSE.UpperCappedScrip, (char)';');
            sb = new StringBuffer();
            for (i = 0; i < UCSymbols.length; ++i) {
                if (UCSymbols[i].length() <= 0 || UCSymbols[i].equalsIgnoreCase(Symbol + ":" + Utilities.GetMarketFromsymbol((String)Symbol))) continue;
                sb.append(UCSymbols[i]);
                sb.append(";");
            }
            LogsKSE.UpperCappedScrip = sb.toString();
        }
        if (CapType == 2 && LogsKSE.LowerLockedScrip.toUpperCase().indexOf(Symbol.toUpperCase()) > -1) {
            String[] LCSymbols = Utilities.split((String)LogsKSE.LowerLockedScrip, (char)';');
            sb = new StringBuffer();
            for (i = 0; i < LCSymbols.length; ++i) {
                if (LCSymbols[i].length() <= 0 || LCSymbols[i].equalsIgnoreCase(Symbol + ":" + Utilities.GetMarketFromsymbol((String)Symbol))) continue;
                sb.append(LCSymbols[i]);
                sb.append(";");
            }
            LogsKSE.UpperCappedScrip = sb.toString();
        }
        this.mediator.sendFeedSymbols("", "Ticker : RemoveCapORLockedSymbol " + Symbol_ + " , " + CapType);
    }

    public void SetUpperCappedString(String result) {
        LogsKSE.UpperCappedScrip = "";
        this.VP.RemoveAllSymbols();
        if (result.indexOf(";") >= 0) {
            String[] Symbols = result.split(";");
            for (int i = 0; i < Symbols.length; ++i) {
                if (Symbols[i].indexOf(":") < 0) continue;
                String symbol = Symbols[i].split("\\:")[0];
                LogsKSE.UpperCappedScrip = LogsKSE.UpperCappedScrip + symbol + ":" + UtilKSE.GetMarketFromsymbol((String)symbol) + ";";
                this.VP.addSymbol(symbol);
            }
        }
        this.mediator.sendFeedSymbols("", "Ticker : SetUpperCappedString");
    }

    public void updateRate() {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (Ticker.this.VP != null) {
                        Ticker.this.VP.Update();
                    }
                }
            });
        } else if (this.VP != null) {
            this.VP.Update();
        }
    }

    public void UpdateUpperCappedAndLowerLocked() {
        if (this.VP != null) {
            this.VP.UpdateUpperCappedAndLowerLocked();
        }
    }

    public void setCustomValue() {
        if (LogCommon.CustomTicker.indexOf(";") >= 0) {
            String[] Symbols = LogCommon.CustomTicker.split("\\;", -1);
            for (int i = 0; i < Symbols.length; ++i) {
                if (Symbols[i].length() <= 0) continue;
                String mkt = UtilKSE.GetMarketFromsymbol((String)Symbols[i]);
                LogsKSE.CustomScrip = LogsKSE.CustomScrip + Symbols[i] + ":" + mkt + ";";
                this.VP.addSymbol(Symbols[i]);
            }
        }
    }

    public void SetTopMoversString(String result) {
        String[] ss;
        if (result.indexOf(";") >= 0 && (ss = result.split("\\;", -1)).length > 0) {
            for (int i = 0; i < ss.length; ++i) {
                if (ss[i].length() <= 0) continue;
                String symbol = ss[i].split("\\:")[0];
                this.VP.addSymbol(symbol);
            }
        }
        this.mediator.sendFeedSymbols("", "Ticker : SetTopMoversString");
    }

    public void setTitle(String title) {
        this.LastTickerName = title;
        this.lblTickerName.setText(this.languageCentre.getValue(title));
        if (this.LastTickerName.equalsIgnoreCase(LanguageConstant.ByVolume)) {
            this.VP.ShowHideVolume(true);
            this.showVolume = true;
            this.chMenuVolume.setText("Hide Volume");
            this.chMenuVolume.setSelected(false);
        } else {
            this.VP.ShowHideVolume(false);
            this.showVolume = false;
            this.chMenuVolume.setText("Show Volume");
            this.chMenuVolume.setSelected(true);
        }
    }

    private void setMenus() {
        this.chmenuUpperCapped = new JMenuItem(this.languageCentre.getValue(LanguageConstant.UpperCapped));
        this.chmenuUpperCapped.setIcon(new ImageIcon(this.getClass().getResource("/Images/UpperCapped.png")));
        this.chmenuUpperCapped.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Ticker.this.mediator.tradecast.OpenTicker(LanguageConstant.UpperCapped, true);
            }
        });
        this.chmenuLowerLocked = new JMenuItem(this.languageCentre.getValue(LanguageConstant.LowerLocked));
        this.chmenuLowerLocked.setIcon(new ImageIcon(this.getClass().getResource("/Images/LowerLocked.png")));
        this.chmenuLowerLocked.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Ticker.this.mediator.tradecast.OpenTicker(LanguageConstant.LowerLocked, true);
            }
        });
        this.topMoversMenu = new JMenu(this.languageCentre.getValue(LanguageConstant.TopMovers));
        this.topMoversMenu.setIcon(new ImageIcon(this.getClass().getResource("/Images/TickertopMovers.png")));
        String osName = System.getProperty("os.name");
        if (osName.equalsIgnoreCase("Windows XP") || osName.equalsIgnoreCase("Windows 2003")) {
            this.topMoversMenu.setMargin(new Insets(2, -10, 2, 0));
        }
        this.chmenuByVolume = new JMenuItem(LanguageConstant.ByVolume);
        this.chmenuByVolume.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TradeCast.getInstance().OpenTopMovers(LanguageConstant.ByVolume, LanguageConstant.TopMovers, true);
            }
        });
        this.chmenuBy_PriceIncrease = new JMenuItem(this.languageCentre.getValue(LanguageConstant.ByPriceIncrease));
        this.chmenuBy_PriceIncrease.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TradeCast.getInstance().OpenTopMovers(LanguageConstant.ByPriceIncrease, LanguageConstant.TopMovers, true);
            }
        });
        this.chmenuByPriceDecrease = new JMenuItem(this.languageCentre.getValue(LanguageConstant.ByPriceDecrease));
        this.chmenuByPriceDecrease.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TradeCast.getInstance().OpenTopMovers(LanguageConstant.ByPriceDecrease, LanguageConstant.TopMovers, true);
            }
        });
        this.chmenuByPerIncrease = new JMenuItem(this.languageCentre.getValue(LanguageConstant.ByPercentIncrease));
        this.chmenuByPerIncrease.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TradeCast.getInstance().OpenTopMovers(LanguageConstant.ByPercentIncrease, LanguageConstant.TopMovers, true);
            }
        });
        this.chmenuByPerDecrease = new JMenuItem(this.languageCentre.getValue(LanguageConstant.ByPercentDecrease));
        this.chmenuByPerDecrease.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TradeCast.getInstance().OpenTopMovers(LanguageConstant.ByPercentDecrease, LanguageConstant.TopMovers, true);
            }
        });
        this.topMoversMenu.add(this.chmenuByVolume);
        this.topMoversMenu.add(this.chmenuBy_PriceIncrease);
        this.topMoversMenu.add(this.chmenuByPriceDecrease);
        this.topMoversMenu.add(this.chmenuByPerIncrease);
        this.topMoversMenu.add(this.chmenuByPerDecrease);
        this.chmenuCustom = new JMenuItem(this.languageCentre.getValue(LanguageConstant.CustomTicker));
        this.chmenuCustom.setIcon(new ImageIcon(this.getClass().getResource("/Images/Custom-Ticker-1.png")));
        this.chmenuCustom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LogCommon.CustomTicker.length() > 1) {
                    Ticker.this.mediator.tradecast.OpenTicker(Title.Custom, true);
                } else {
                    Ticker.this.mediator.tradecast.OpenTickerCustomizationForm();
                }
            }
        });
        this.ChmOption = new JMenu("Options");
        if (osName.equalsIgnoreCase("Windows XP") || osName.equalsIgnoreCase("Windows 2003")) {
            this.ChmOption.setMargin(new Insets(2, -10, 2, 0));
        }
        this.ChmOption.setIcon(new ImageIcon(this.getClass().getResource("/Images/Toption.png")));
        this.chmenuShowPercantageChange = new JMenuItem("Hide % Change");
        this.chmenuShowPercantageChange.setSelected(false);
        this.chmenuShowPercantageChange.setIcon(new ImageIcon(this.getClass().getResource("/Images/showpercantage.png")));
        this.chmenuShowPercantageChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Ticker.this.showHidePercan(Ticker.this.chmenuShowPercantageChange.isSelected());
            }
        });
        this.chmenuShowDescription = new JMenuItem("Hide Scrip Name");
        this.chmenuShowDescription.setSelected(false);
        this.chmenuShowDescription.setIcon(new ImageIcon(this.getClass().getResource("/Images/Description.png")));
        this.chmenuShowDescription.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Ticker.this.showHideScripName(Ticker.this.chmenuShowDescription.isSelected());
            }
        });
        this.chmenuShowTitle = new JMenuItem("Hide Ticker Title");
        this.chmenuShowTitle.setSelected(false);
        this.chmenuShowTitle.setIcon(new ImageIcon(this.getClass().getResource("/Images/showTitle.png")));
        this.chmenuShowTitle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Ticker.this.ShowHideTitle(Ticker.this.TickerName, Ticker.this.chmenuShowTitle.isSelected());
            }
        });
        this.chMenuVolume = new JMenuItem("Show Volume");
        this.chMenuVolume.setSelected(true);
        this.chMenuVolume.setIcon(new ImageIcon(this.getClass().getResource("/Images/Vol.png")));
        this.chMenuVolume.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Ticker.this.showHideVolume(Ticker.this.chMenuVolume.isSelected());
            }
        });
        this.ChmTickerSpeed = new JMenu("Ticker Speed");
        this.ChmTickerSpeed.setIcon(new ImageIcon(this.getClass().getResource("/Images/TickerSpped.png")));
        if (osName.equalsIgnoreCase("Windows XP") || osName.equalsIgnoreCase("Windows 2003")) {
            this.ChmTickerSpeed.setMargin(new Insets(2, -10, 2, 0));
        }
        this.chmenuFast = new JCheckBoxMenuItem("Fast");
        this.chmenuSlow = new JCheckBoxMenuItem("Slow");
        this.chmenuMedium = new JCheckBoxMenuItem("Medium");
        this.chmenuMedium.setSelected(true);
        this.chmenuFast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Ticker.this.VP.Speed = speedFast;
                Ticker.this.setSpeed();
            }
        });
        this.chmenuSlow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Ticker.this.VP.Speed = 36;
                Ticker.this.setSpeed();
            }
        });
        this.chmenuMedium.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Ticker.this.VP.Speed = 18;
                Ticker.this.setSpeed();
            }
        });
        this.ChmTickerSpeed.add(this.chmenuSlow);
        this.ChmTickerSpeed.add(this.chmenuMedium);
        this.ChmTickerSpeed.add(this.chmenuFast);
        this.chmenuResetDefault = new JMenuItem("Restore Ticker settings");
        this.chmenuResetDefault.setIcon(new ImageIcon(this.getClass().getResource("/Images/restoreDefault.png")));
        this.chmenuResetDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Ticker.this.ResetDefault(Ticker.this.VP, Ticker.this.TickerName);
            }
        });
        this.chmenuDock = new JMenuItem("Dock");
        this.chmenuDock.setIcon(new ImageIcon(this.getClass().getResource("/Images/Dock.png")));
        this.chmenuDock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Ticker.this.saveTickerSettings();
                Ticker.this.Dock(Ticker.this.mediator.tradecast.TickerDToolBar);
            }
        });
        this.chmenuUnDock = new JMenuItem("UnDock");
        this.chmenuUnDock.setIcon(new ImageIcon(this.getClass().getResource("/Images/UnDock.png")));
        this.chmenuUnDock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Ticker.this.saveTickerSettings();
                Ticker.this.UnDock(Ticker.this.mediator.tradecast.TickerDToolBar, false);
            }
        });
        if (this.IsDock) {
            this.chmenuDock.setEnabled(false);
            this.chmenuUnDock.setEnabled(true);
        } else {
            this.chmenuDock.setEnabled(true);
            this.chmenuUnDock.setEnabled(false);
        }
        this.chmenuSetAlwaysOnTop.setSelected(true);
        this.chmenuSetAlwaysOnTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Ticker.this.setAlwaysOnTop();
            }
        });
        this.chmenuLeftToRight = new JMenuItem("Left To Right");
        this.chmenuLeftToRight.setSelected(true);
        this.chmenuLeftToRight.setIcon(new ImageIcon(this.getClass().getResource("/Images/INvert1.png")));
        this.chmenuLeftToRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Ticker.this.showLeftToRight();
            }
        });
        this.menuTickerSettings = new JMenuItem("Custom Settings");
        this.menuTickerSettings.setIcon(new ImageIcon(this.getClass().getResource("/Images/option.png")));
        this.menuTickerSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Ticker.this.mediator.tradecast.OpenTickerCustomizationForm();
            }
        });
        if (this.TickerName.equalsIgnoreCase(Title.Custom)) {
            this.menuTickerSettings.setEnabled(true);
        } else {
            this.menuTickerSettings.setEnabled(false);
        }
        JMenuItem menuCloseItem = new JMenuItem("Close");
        menuCloseItem.setIcon(new ImageIcon(this.getClass().getResource("/Images/close.png")));
        menuCloseItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Ticker.this.CloseTicker();
            }
        });
        this.popup.add(this.chmenuUpperCapped);
        this.popup.add(this.chmenuLowerLocked);
        this.popup.add(this.topMoversMenu);
        this.popup.add(this.chmenuCustom);
        this.popup.add(this.ChmOption);
        this.popup.add(new JSeparator());
        this.popup.add(menuCloseItem);
        this.ChmOption.add(this.chmenuResetDefault);
        this.ChmOption.add(new JSeparator());
        this.ChmOption.add(this.chmenuShowTitle);
        this.ChmOption.add(this.chmenuShowDescription);
        this.ChmOption.add(this.chmenuShowPercantageChange);
        this.ChmOption.add(this.chMenuVolume);
        this.ChmOption.add(new JSeparator());
        this.ChmOption.add(this.chmenuDock);
        this.ChmOption.add(this.chmenuUnDock);
        this.ChmOption.add(this.chmenuSetAlwaysOnTop);
        this.ChmOption.add(new JSeparator());
        this.ChmOption.add(this.ChmTickerSpeed);
        this.ChmOption.add(this.chmenuLeftToRight);
        this.ChmOption.add(new JSeparator());
        this.ChmOption.add(this.menuTickerSettings);
    }

    public void saveTickerSettings() {
        TickerParameters tp = LogsTC.tickerMap.get(this.TickerName);
        if (this.draggablewindow.PointX != 0 && this.draggablewindow.PointY != 0) {
            tp.TickerPoint.x = this.draggablewindow.PointX;
            tp.TickerPoint.y = this.draggablewindow.PointY;
        }
        tp.isShowPercentChange = this.showPercantage;
        tp.isShowScripName = this.showScripName;
        tp.isShowTitle = this.showTitles;
        tp.isShowTradeVolume = this.showVolume;
        tp.speed = this.VP.Speed;
        tp.isDock = this.IsDock;
        tp.isLeftToRigth = this.isLeftToRight;
        tp.alwaysOnTop = this.AlwaysonTop;
        LogsTC.tickerMap.put(this.TickerName, tp);
    }

    private void restoreTickerSettings() {
        TickerParameters tp = LogsTC.tickerMap.get(this.TickerName);
        if (tp != null) {
            this.setTickerSize(tp.TickerSize);
            this.draggablewindow.setSize(tp.width, 30);
            this.draggablewindow.setLocation(tp.TickerPoint);
            this.draggablewindow.setVisible(true);
            this.AlwaysonTop = !tp.alwaysOnTop;
            this.showHideVolume(tp.isShowTradeVolume);
            this.showHidePercan(tp.isShowPercentChange);
            this.showHideScripName(tp.isShowScripName);
            this.ShowHideTitle(this.TickerName, tp.isShowTitle);
            this.setAlwaysOnTop();
            this.VP.Speed = tp.speed;
            this.setSpeedOnStartUP();
            this.SetInvert = tp.isLeftToRigth ? 1 : 0;
            this.showLeftToRight();
        }
    }

    private void setAlwaysOnTop() {
        if (this.AlwaysonTop) {
            this.chmenuSetAlwaysOnTop.setIcon(null);
        } else if (!this.AlwaysonTop) {
            this.chmenuSetAlwaysOnTop.setIcon(this.tickIcon);
        }
        this.SetVisible(TradeCast.getInstance().frame.isFocused());
        this.AlwaysonTop = !this.AlwaysonTop;
    }

    private void showHideVolume(boolean b) {
        this.VP.ShowHideVolume(b);
        this.showVolume = b;
        if (b) {
            this.chMenuVolume.setText("Hide Volume");
        } else if (!b) {
            this.chMenuVolume.setText("Show Volume");
        }
        this.chMenuVolume.setSelected(!b);
        this.VP.UpdateAllValues();
    }

    private void showHidePercan(boolean b) {
        this.VP.ShowHidePercan(b);
        this.showPercantage = b;
        if (b) {
            this.chmenuShowPercantageChange.setText("Hide % Change");
        } else if (!b) {
            this.chmenuShowPercantageChange.setText("Show % Change");
        }
        this.chmenuShowPercantageChange.setSelected(!b);
    }

    private void showHideScripName(boolean b) {
        this.VP.ShowHideScripName(b);
        this.showScripName = b;
        if (b) {
            this.chmenuShowDescription.setText("Hide Scrip Name");
        } else if (!b) {
            this.chmenuShowDescription.setText("Show Scrip Name");
        }
        this.chmenuShowDescription.setSelected(!b);
    }

    private void showLeftToRight() {
        if (this.SetInvert == 1) {
            this.ChangeDirection(Direction.RightToLeft);
            this.isLeftToRight = true;
            this.SetInvert = 0;
            this.chmenuLeftToRight.setText("Left To Right");
        } else if (this.SetInvert == 0) {
            this.ChangeDirection(Direction.LeftToRight);
            this.SetInvert = 1;
            this.isLeftToRight = false;
            this.chmenuLeftToRight.setText("Right To Left");
        }
    }

    public void ShowHideTitle(String TickerName, boolean isVisible) {
        String Name = "";
        this.showTitles = isVisible;
        this.chmenuShowTitle.setSelected(!isVisible);
        Name = TickerName.equalsIgnoreCase(LanguageConstant.TopMovers) ? this.LastTickerName : TickerName;
        if (isVisible) {
            this.chmenuShowTitle.setText("Hide Ticker Title");
            this.HeadingPanel.setVisible(true);
            this.lblTickerName.setText(this.languageCentre.getValue(Name));
        } else {
            this.chmenuShowTitle.setText("Show Ticker Title");
            this.HeadingPanel.setVisible(false);
            this.lblTickerName.setText("");
        }
    }

    private void setSpeed() {
        if (this.VP.Speed == speedFast) {
            this.VP.SetDelay();
            this.chmenuFast.setSelected(true);
            this.chmenuSlow.setSelected(false);
            this.chmenuMedium.setSelected(false);
        } else if (this.VP.Speed == 36) {
            this.VP.SetDelay();
            this.chmenuFast.setSelected(false);
            this.chmenuSlow.setSelected(true);
            this.chmenuMedium.setSelected(false);
        } else {
            this.VP.SetDelay();
            this.chmenuFast.setSelected(false);
            this.chmenuSlow.setSelected(false);
            this.chmenuMedium.setSelected(true);
        }
    }

    private void setSpeedOnStartUP() {
        if (this.VP.Speed == speedFast) {
            this.chmenuFast.setSelected(true);
            this.chmenuSlow.setSelected(false);
            this.chmenuMedium.setSelected(false);
        } else if (this.VP.Speed == 36) {
            this.chmenuFast.setSelected(false);
            this.chmenuSlow.setSelected(true);
            this.chmenuMedium.setSelected(false);
        } else {
            this.chmenuFast.setSelected(false);
            this.chmenuSlow.setSelected(false);
            this.chmenuMedium.setSelected(true);
        }
    }

    public void setDock() {
        this.buttonPanel.setDock();
    }
}

