/*
 * Decompiled with CFR 0.152.
 */
package Ticker;

import MyDocking.Mediator;
import Ticker.Direction;
import Ticker.Ticker;
import Ticker.TickerParameters;
import Utilities.LogsTC;
import common.gui.util.Title;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import languages.LanguageConstant;

public class TickerSetting
extends JFrame {
    private int delay = 0;
    private Font Font_MarketDepth = null;
    private int count = 0;
    private Mediator mediator = Mediator.getInstance();
    private Ticker tick = null;
    private String title = "";
    private TickerParameters tpa = null;
    private JPanel SampleTickerPanel;
    private JSlider SmoothSlider;
    private JSlider SpeedSlider;
    private JButton btnApply;
    private JButton btnClose;
    private JButton btnFont;
    private JButton btnSymbolColor;
    private JButton btn_changeColor;
    private JCheckBox cbInver;
    private JComboBox cmbUpperCapped;
    private JCheckBox jCheckBox2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel4;
    private JSeparator jSeparator1;
    private JLabel lblAddRemove;
    private JPanel panelChangeColor;
    private JPanel panelSymbolColor;
    private JTextField txtFont;

    public TickerSetting(String title, String TickerName) {
        this.initComponents();
        this.title = title;
        this.tick = new Ticker(title, TickerName, new Color(247, 234, 190), new Color(248, 231, 175), new Color(192, 155, 31));
        this.tick.VP.init_components();
        this.tick.draggablewindow.setVisible(false);
        this.tick.draggablewindow.remove(this.tick.outerPanel);
        this.tick.VP.TickerName = TickerName;
        this.SampleTickerPanel.setOpaque(false);
        this.SampleTickerPanel.add(this.tick.outerPanel);
        this.lblAddRemove.setCursor(Cursor.getPredefinedCursor(12));
        this.cmbUpperCapped.setSelectedItem(TickerName);
        this.AddRemoveLable();
        TickerParameters tp = LogsTC.tickerMap.get(TickerName);
        this.txtFont.setText(this.GetFontString(tp.TickerFont));
        this.panelSymbolColor.setBackground(tp.SymbolColor);
        this.panelChangeColor.setBackground(tp.lastTradePriceColor);
    }

    public void AddRemoveLable() {
        if (this.cmbUpperCapped.getSelectedItem().toString().equalsIgnoreCase(Title.Custom)) {
            this.lblAddRemove.setForeground(Color.black);
            this.lblAddRemove.setEnabled(true);
        } else {
            this.lblAddRemove.setForeground(this.getBackground());
            this.lblAddRemove.setEnabled(false);
        }
        if (this.tick != null) {
            String TickerName = this.cmbUpperCapped.getSelectedItem().toString();
            this.tick.setTitle(TickerName);
        }
    }

    private void initComponents() {
        this.cmbUpperCapped = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jPanel4 = new JPanel();
        this.SpeedSlider = new JSlider();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.SmoothSlider = new JSlider();
        this.jLabel3 = new JLabel();
        this.txtFont = new JTextField();
        this.jLabel4 = new JLabel();
        this.panelSymbolColor = new JPanel();
        this.jLabel5 = new JLabel();
        this.panelChangeColor = new JPanel();
        this.btnFont = new JButton();
        this.btnSymbolColor = new JButton();
        this.btn_changeColor = new JButton();
        this.cbInver = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.lblAddRemove = new JLabel();
        this.SampleTickerPanel = new JPanel();
        this.btnClose = new JButton();
        this.btnApply = new JButton();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TickerSetting.this.formWindowClosing(evt);
            }
        });
        this.cmbUpperCapped.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TickerSetting.this.cmbUpperCappedActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(this.cmbUpperCapped.getSelectedItem().toString()));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Speed and Smoothness"));
        this.SpeedSlider.setMajorTickSpacing(2);
        this.SpeedSlider.setMaximum(20);
        this.SpeedSlider.setPaintTicks(true);
        this.SpeedSlider.setToolTipText("SpeedSlider.getValue();");
        this.SpeedSlider.setValue(0);
        this.SpeedSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TickerSetting.this.SpeedSliderStateChanged(evt);
            }
        });
        this.jLabel1.setText("Speed");
        this.jLabel2.setText("Smoothness");
        this.SmoothSlider.setMajorTickSpacing(1);
        this.SmoothSlider.setMaximum(10);
        this.SmoothSlider.setMinimum(1);
        this.SmoothSlider.setMinorTickSpacing(1);
        this.SmoothSlider.setPaintTicks(true);
        this.SmoothSlider.setSnapToTicks(true);
        this.SmoothSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TickerSetting.this.SmoothSliderStateChanged(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jLabel2)).addGroup(jPanel4Layout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.jLabel1)).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.SpeedSlider, -1, 375, Short.MAX_VALUE)).addGroup(jPanel4Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.SmoothSlider, -1, 373, Short.MAX_VALUE))).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(4, 4, 4).addComponent(this.SpeedSlider, -2, 25, -2).addGap(4, 4, 4).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.SmoothSlider, -2, 25, -2)));
        this.jLabel3.setText("Font");
        this.jLabel4.setText("Symbol Color");
        this.panelSymbolColor.setBackground(new Color(51, 0, 255));
        GroupLayout panelSymbolColorLayout = new GroupLayout(this.panelSymbolColor);
        this.panelSymbolColor.setLayout(panelSymbolColorLayout);
        panelSymbolColorLayout.setHorizontalGroup(panelSymbolColorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 252, Short.MAX_VALUE));
        panelSymbolColorLayout.setVerticalGroup(panelSymbolColorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        this.jLabel5.setText("Ltrd Price Color");
        this.panelChangeColor.setBackground(new Color(0, 0, 204));
        this.panelChangeColor.setPreferredSize(new Dimension(120, 18));
        GroupLayout panelChangeColorLayout = new GroupLayout(this.panelChangeColor);
        this.panelChangeColor.setLayout(panelChangeColorLayout);
        panelChangeColorLayout.setHorizontalGroup(panelChangeColorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 252, Short.MAX_VALUE));
        panelChangeColorLayout.setVerticalGroup(panelChangeColorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.btnFont.setText("jButton3");
        this.btnFont.setName("TickerSetting -> btnFont");
        this.btnFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TickerSetting.this.btnFontActionPerformed(evt);
            }
        });
        this.btnSymbolColor.setText("jButton4");
        this.btnSymbolColor.setName("TickerSetting -> btnSymbolColor");
        this.btnSymbolColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TickerSetting.this.btnSymbolColorActionPerformed(evt);
            }
        });
        this.btn_changeColor.setText("jButton6");
        this.btn_changeColor.setName("TickerSetting -> btn_changeColor");
        this.btn_changeColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TickerSetting.this.btn_changeColorActionPerformed(evt);
            }
        });
        this.cbInver.setText("Invert");
        this.cbInver.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TickerSetting.this.cbInverActionPerformed(evt);
            }
        });
        this.jCheckBox2.setText("Always on Top");
        this.jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TickerSetting.this.jCheckBox2ActionPerformed(evt);
            }
        });
        this.lblAddRemove.setText("<html><body>Add / Remove Symbol</body></html>");
        this.lblAddRemove.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TickerSetting.this.lblAddRemoveMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                TickerSetting.this.lblAddRemoveMouseExited(evt);
            }
        });
        this.lblAddRemove.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                TickerSetting.this.lblAddRemoveMouseMoved(evt);
            }
        });
        this.SampleTickerPanel.setBackground(new Color(102, 102, 102));
        this.SampleTickerPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        GroupLayout SampleTickerPanelLayout = new GroupLayout(this.SampleTickerPanel);
        this.SampleTickerPanel.setLayout(SampleTickerPanelLayout);
        SampleTickerPanelLayout.setHorizontalGroup(SampleTickerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 399, Short.MAX_VALUE));
        SampleTickerPanelLayout.setVerticalGroup(SampleTickerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 36, Short.MAX_VALUE));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbInver).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5, -2, 73, -2).addGap(19, 19, 19))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4, -1, 69, Short.MAX_VALUE).addGap(30, 30, 30)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3, -1, 41, Short.MAX_VALUE).addGap(58, 58, 58))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox2).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.txtFont, GroupLayout.Alignment.LEADING, -1, 252, Short.MAX_VALUE).addComponent(this.panelSymbolColor, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.panelChangeColor, GroupLayout.Alignment.LEADING, -1, 252, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btn_changeColor, -2, 32, -2).addComponent(this.btnSymbolColor, -2, 32, -2).addComponent(this.btnFont, -2, 32, -2))))).addGroup(jPanel1Layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.lblAddRemove, -2, -1, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.SampleTickerPanel, -1, -1, Short.MAX_VALUE)).addComponent(this.jPanel4, GroupLayout.Alignment.LEADING, -2, -1, -2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.SampleTickerPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.txtFont, -2, 20, -2).addComponent(this.btnFont, -2, 20, -2)).addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4, -2, 18, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel5)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelSymbolColor, -2, -1, -2).addComponent(this.btnSymbolColor, -2, 20, -2)).addGap(7, 7, 7).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btn_changeColor, -2, 20, -2).addComponent(this.panelChangeColor, -1, 20, Short.MAX_VALUE)))).addGap(10, 10, 10).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbInver).addComponent(this.jCheckBox2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblAddRemove, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.btnClose.setText("Close");
        this.btnClose.setName("TickerSetting -> btnClose");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TickerSetting.this.btnCloseActionPerformed(evt);
            }
        });
        this.btnApply.setText("Apply");
        this.btnApply.setName("TickerSetting -> btnApply");
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TickerSetting.this.btnApplyActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.btnApply).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClose)).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.cmbUpperCapped, -2, 410, -2)).addContainerGap()).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.cmbUpperCapped, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnClose).addComponent(this.btnApply)).addContainerGap()));
        this.pack();
    }

    private void SpeedSliderStateChanged(ChangeEvent evt) {
        int getSpeedValue;
        if (this.tick.VP.TickerName.equalsIgnoreCase(LanguageConstant.UpperCapped)) {
            int getSpeedValue2 = this.SpeedSlider.getValue();
            if (getSpeedValue2 % 2 == 0) {
                this.mediator.tradecast.uppercap.VP.Speed = 20 - getSpeedValue2;
                this.tick.VP.Speed = 20 - getSpeedValue2;
                this.SpeedSlider.setToolTipText(20 - getSpeedValue2 + "");
            }
        } else if (this.tick.VP.TickerName.equalsIgnoreCase(LanguageConstant.LowerLocked)) {
            int getSpeedValue3 = this.SpeedSlider.getValue();
            if (getSpeedValue3 % 2 == 0) {
                this.mediator.tradecast.lowerLock.VP.Speed = 20 - getSpeedValue3;
                this.tick.VP.Speed = 20 - getSpeedValue3;
                this.SpeedSlider.setToolTipText(20 - getSpeedValue3 + "");
            }
        } else if (this.tick.VP.TickerName.equalsIgnoreCase(LanguageConstant.TopMovers)) {
            int getSpeedValue4 = this.SpeedSlider.getValue();
            if (getSpeedValue4 % 2 == 0) {
                this.mediator.tradecast.TopMovers.VP.Speed = 20 - getSpeedValue4;
                this.tick.VP.Speed = 20 - getSpeedValue4;
                this.SpeedSlider.setToolTipText(20 - getSpeedValue4 + "");
            }
        } else if (this.tick.VP.TickerName.equalsIgnoreCase(Title.Custom) && (getSpeedValue = this.SpeedSlider.getValue()) % 2 == 0) {
            this.mediator.tradecast.custom.VP.Speed = 20 - getSpeedValue;
            this.tick.VP.Speed = 20 - getSpeedValue;
            this.SpeedSlider.setToolTipText(20 - getSpeedValue + "");
        }
    }

    private void cmbUpperCappedActionPerformed(ActionEvent evt) {
        this.AddRemoveLable();
    }

    private void lblAddRemoveMouseMoved(MouseEvent evt) {
        this.lblAddRemove.setText("<html><body><u>Add / Remove Symbol</u></body></html>");
    }

    private void lblAddRemoveMouseExited(MouseEvent evt) {
        this.lblAddRemove.setText("<html><body>Add / Remove Symbol</body></html>");
    }

    private void btnFontActionPerformed(ActionEvent evt) {
    }

    private void btnSymbolColorActionPerformed(ActionEvent evt) {
    }

    private void btn_changeColorActionPerformed(ActionEvent evt) {
    }

    private void lblAddRemoveMouseClicked(MouseEvent evt) {
        this.mediator.tradecast.customTicker.SetAddList();
        this.mediator.tradecast.customTicker.fillCustomizeTickerSymbolData();
        this.mediator.tradecast.customTicker.setVisible(true);
        if (this.mediator.tradecast.customTicker.CustomizeTickerIsOpened) {
            this.lblAddRemove.setText("<html><body><b>Add / Remove Symbol<b></body></html>");
        }
    }

    private void jCheckBox2ActionPerformed(ActionEvent evt) {
        if (this.jCheckBox2.isSelected()) {
            this.tick.SetAlwaysOnTop(true);
        } else {
            this.tick.SetAlwaysOnTop(false);
        }
    }

    private void cbInverActionPerformed(ActionEvent evt) {
        if (this.cbInver.isSelected()) {
            if (this.tick.VP.TickerName.equalsIgnoreCase(LanguageConstant.UpperCapped)) {
                this.tick.ChangeDirection(Direction.LeftToRight);
                this.mediator.tradecast.uppercap.ChangeDirection(Direction.LeftToRight);
            } else if (this.tick.VP.TickerName.equalsIgnoreCase(LanguageConstant.LowerLocked)) {
                this.tick.ChangeDirection(Direction.LeftToRight);
                this.mediator.tradecast.lowerLock.ChangeDirection(Direction.LeftToRight);
            } else if (this.tick.VP.TickerName.equalsIgnoreCase(LanguageConstant.TopMovers)) {
                this.tick.ChangeDirection(Direction.LeftToRight);
                this.mediator.tradecast.TopMovers.ChangeDirection(Direction.LeftToRight);
            } else if (this.tick.VP.TickerName.equalsIgnoreCase(Title.Custom)) {
                this.tick.ChangeDirection(Direction.LeftToRight);
                this.mediator.tradecast.custom.ChangeDirection(Direction.LeftToRight);
            }
        } else if (this.tick.VP.TickerName.equalsIgnoreCase(LanguageConstant.UpperCapped)) {
            this.tick.ChangeDirection(Direction.RightToLeft);
            this.mediator.tradecast.uppercap.ChangeDirection(Direction.RightToLeft);
        } else if (this.tick.VP.TickerName.equalsIgnoreCase(LanguageConstant.LowerLocked)) {
            this.tick.ChangeDirection(Direction.RightToLeft);
            this.mediator.tradecast.lowerLock.ChangeDirection(Direction.RightToLeft);
        } else if (this.tick.VP.TickerName.equalsIgnoreCase(LanguageConstant.TopMovers)) {
            this.tick.ChangeDirection(Direction.RightToLeft);
            this.mediator.tradecast.TopMovers.ChangeDirection(Direction.RightToLeft);
        } else if (this.tick.VP.TickerName.equalsIgnoreCase(Title.Custom)) {
            this.tick.ChangeDirection(Direction.RightToLeft);
            this.mediator.tradecast.custom.ChangeDirection(Direction.RightToLeft);
        }
    }

    private void SmoothSliderStateChanged(ChangeEvent evt) {
        if (this.tick.VP.TickerName.equalsIgnoreCase(LanguageConstant.UpperCapped)) {
            this.SmoothSlider.setToolTipText(this.SmoothSlider.getValue() + "");
        } else if (this.tick.VP.TickerName.equalsIgnoreCase(LanguageConstant.LowerLocked)) {
            this.SmoothSlider.setToolTipText(this.SmoothSlider.getValue() + "");
        } else if (this.tick.VP.TickerName.equalsIgnoreCase(LanguageConstant.TopMovers)) {
            this.SmoothSlider.setToolTipText(this.SmoothSlider.getValue() + "");
        } else if (this.tick.VP.TickerName.equalsIgnoreCase(Title.Custom)) {
            this.SmoothSlider.setToolTipText(this.SmoothSlider.getValue() + "");
        }
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void formWindowClosing(WindowEvent evt) {
    }

    private void btnApplyActionPerformed(ActionEvent evt) {
        TickerParameters tp = LogsTC.tickerMap.get(this.tick.VP.TickerName);
        tp.TickerPoint.x = this.tick.draggablewindow.PointX;
        tp.TickerPoint.y = this.tick.draggablewindow.PointY;
        if (this.mediator.readWrite != null) {
            this.mediator.readWrite.write(LogsTC.tickerMap);
            this.dispose();
        }
    }

    public String GetFontString(Font f) {
        String Style2 = "PLAIN";
        if (f.getStyle() == 0) {
            Style2 = "PLAIN";
        } else if (f.getStyle() == 1) {
            Style2 = "BOLD";
        } else if (f.getStyle() == 2) {
            Style2 = "ITALIC";
        }
        return f.getFamily() + " " + Style2 + " " + f.getSize();
    }
}

