/*
 * Decompiled with CFR 0.152.
 */
package Ticker;

import CATALYST.Control.MarketFeed;
import MessageWindow.ReadWrite;
import MyDocking.Mediator;
import Ticker.Direction;
import Ticker.Ticker;
import Ticker.TickerFeed;
import Ticker.TickerPanel;
import Ticker.TickerParameters;
import Utilities.LogsTC;
import common.gui.util.LogCommon;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import kse.util.UtilKSE;

public class ValuePanel
extends JPanel
implements ActionListener {
    public static final int tickerHeight = 30;
    public static Font font = new Font("Tahoma", 0, 11);
    int x;
    public String ChangePersantage = "%";
    public int y = 0;
    int ActualSize;
    Hashtable<String, TickerValues> ht = new Hashtable();
    boolean StopTicker = false;
    private Direction TickerDirection = Direction.RightToLeft;
    public Mediator mediator = Mediator.getInstance();
    public String TickerName = "";
    ReadWrite readWrite = null;
    public Color UpColor = new Color(11, 143, 12);
    public Color DownColor = new Color(225, 28, 43);
    public Color LevelColor = new Color(29, 58, 252);
    public final int smoth = 1;
    public int Speed = 18;
    public int StartDelay = 100;
    Timer timer2 = null;
    static boolean ReadTickerSettingFromFile = true;
    Ticker ticker;
    static ImageIcon upIcon = null;
    static ImageIcon lowIcon = null;
    static ImageIcon levelIcon = null;

    private static ImageIcon icon(String path) {
        URL resource = ValuePanel.class.getResource(path);
        if (resource == null) {
            return new ImageIcon();
        }
        return new ImageIcon(resource);
    }

    public ValuePanel(String TickerName, Ticker tick) {
        this.TickerName = TickerName;
        this.ticker = tick;
        this.setLayout(new BoxLayout(this, 0));
        if (ReadTickerSettingFromFile) {
            this.readWrite = new ReadWrite();
            ReadTickerSettingFromFile = false;
            try {
                if (this.readWrite.ReadTickers() != null) {
                    LogsTC.tickerMap = this.readWrite.ReadTickers();
                }
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
        }
        this.x = this.ActualSize = this.getPreferredSize().width;
    }

    public void StartTimer() {
        this.timer2 = new Timer(this.StartDelay, null);
        ActionListener ac = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValuePanel.this.moveIt();
            }
        };
        this.timer2.addActionListener(ac);
        this.timer2.setDelay(this.Speed);
        this.timer2.setRepeats(true);
        this.timer2.start();
    }

    private void moveIt() {
        try {
            if (!this.StopTicker) {
                if (this.TickerDirection == Direction.RightToLeft) {
                    --this.x;
                    if (this.x <= -this.ActualSize) {
                        this.x = this.getParent().getSize().width;
                    }
                } else if (this.TickerDirection == Direction.LeftToRight) {
                    ++this.x;
                    if (this.x >= this.getParent().getSize().width) {
                        this.x = -this.ActualSize;
                    }
                }
                this.setBounds(this.x, this.y, this.ActualSize, 30);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.moveIt();
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        super.setOpaque(false);
    }

    public void StartFromZero(int Position2) {
        this.x = this.TickerDirection == Direction.RightToLeft ? Position2 - 90 : 0;
    }

    public void ChangeDirection(Direction TickerDirection) {
        this.TickerDirection = TickerDirection;
    }

    public void StopTicker() {
        if (this.timer2 != null) {
            this.timer2.stop();
        }
    }

    public void SetDelay() {
        if (this.timer2 != null) {
            this.timer2.stop();
        }
        this.StartTimer();
    }

    public void SetActualSize() {
        this.ActualSize = this.getPreferredSize().width;
    }

    public void ShowHideVolume(boolean isVisible) {
        Enumeration<String> en = this.ht.keys();
        while (en.hasMoreElements()) {
            String Symbol = en.nextElement().toString();
            TickerValues pnl = this.ht.get(Symbol);
            pnl.tickerPanel.lblTradeVol.setVisible(isVisible);
            pnl.tickerPanel.setSize();
        }
        this.ActualSize = this.getPreferredSize().width;
    }

    public void ShowHidePercan(boolean isVisible) {
        Enumeration<String> en = this.ht.keys();
        while (en.hasMoreElements()) {
            String Symbol = en.nextElement().toString();
            TickerValues pnl = this.ht.get(Symbol);
            pnl.tickerPanel.lblPercentChange.setVisible(isVisible);
            pnl.tickerPanel.setSize();
        }
        this.ActualSize = this.getPreferredSize().width;
    }

    public synchronized void Update() {
        Enumeration<String> en = this.ht.keys();
        while (en.hasMoreElements()) {
            String symbol = en.nextElement().toString();
            TickerFeed tckfeed = TickerFeed.GetTickerFeed(symbol, UtilKSE.GetMarketFromsymbol((String)symbol));
            if (tckfeed == null || this.ht.get(tckfeed.symbol) == null) continue;
            TickerValues pnl = this.ht.get(tckfeed.symbol);
            pnl.tickerPanel.lblScrip.setText(tckfeed.symbol);
            pnl.tickerPanel.lblLtrdPrice.setText(Util.format2digit((String)tckfeed.lTrdPrice));
            pnl.tickerPanel.lblChange.setText("(" + Util.format2digit((String)tckfeed.change));
            double perOld = 0.0;
            String Image2 = "up.png";
            Color SetColor = Color.RED;
            Double per = 0.0;
            if (Double.parseDouble(tckfeed.lTrdPrice.replaceAll("\\,", "")) > 0.0) {
                try {
                    double chg = Double.parseDouble(tckfeed.change.replaceAll("\\,", ""));
                    double lastP = Double.parseDouble(tckfeed.lTrdPrice.replaceAll("\\,", ""));
                    double cloaseP = lastP - chg;
                    per = chg / cloaseP * 100.0;
                }
                catch (Exception ex) {
                    per = 0.0;
                }
            }
            per = Double.parseDouble(Util.format2digit((String)per.toString()));
            double Change = Double.parseDouble(tckfeed.change.replaceAll("\\,", ""));
            if (Change > 0.0) {
                Image2 = "up.png";
                SetColor = this.UpColor;
            } else if (Change < 0.0) {
                Image2 = "down.png";
                SetColor = this.DownColor;
            } else if (Change == 0.0) {
                Image2 = "level.png";
                SetColor = this.LevelColor;
            }
            pnl.tickerPanel.lblScrip.setForeground(SetColor);
            pnl.tickerPanel.lblLtrdPrice.setForeground(SetColor);
            pnl.tickerPanel.lblLtrdPrice.setFont(pnl.tickerPanel.lblLtrdPrice.getFont().deriveFont(1));
            pnl.tickerPanel.lblChangeImage.setIcon(this.loadImage("/Images/" + Image2));
            pnl.tickerPanel.lblChangeImage.setText("");
            if (this.ticker.showPercantage) {
                pnl.tickerPanel.lblPercentChange.setText(per + this.ChangePersantage + ")");
            } else if (!this.ticker.showPercantage) {
                pnl.tickerPanel.lblChangeImage.setText(")");
            }
            pnl.tickerPanel.lblPercentChange.setForeground(SetColor);
            pnl.tickerPanel.lblChange.setForeground(SetColor);
            pnl.tickerPanel.lblChangeImage.setForeground(SetColor);
            pnl.tickerPanel.lblScripName.setForeground(SetColor);
            pnl.tickerPanel.lblTradeVol.setText(Util.format0digit((String)tckfeed.totVolume));
            pnl.tickerPanel.lblTradeVol.setForeground(SetColor);
            pnl.tickerPanel.setSize();
            pnl.repaint();
        }
        this.updateUI();
        this.ActualSize = this.getPreferredSize().width;
    }

    public synchronized void UpdateUpperCappedAndLowerLocked() {
        Enumeration<String> en = this.ht.keys();
        while (en.hasMoreElements()) {
            String symbol = en.nextElement().toString();
            MarketFeed mktFeed = this.mediator.MwPanel.GetSingleFeed(symbol, UtilKSE.GetMarketFromsymbol((String)symbol));
            if (mktFeed == null || this.ht.get(mktFeed.symbol) == null) continue;
            final TickerValues pnl = this.ht.get(mktFeed.symbol);
            pnl.tickerPanel.lblScrip.setText(mktFeed.symbol);
            pnl.tickerPanel.lblLtrdPrice.setText(Util.format2digit((String)mktFeed.lTrdPrice));
            pnl.tickerPanel.lblChange.setText("(" + Util.format2digit((String)mktFeed.change));
            double perOld = 0.0;
            String Image2 = "up.png";
            Color SetColor = Color.RED;
            Double per = 0.0;
            if (Double.parseDouble(mktFeed.lTrdPrice.replaceAll("\\,", "")) > 0.0) {
                try {
                    per = Double.parseDouble(mktFeed.change.replaceAll("\\,", "")) / Double.parseDouble(mktFeed.lTrdPrice.replaceAll("\\,", "")) * 100.0;
                }
                catch (Exception ex) {
                    per = 0.0;
                }
            }
            per = Double.parseDouble(Util.format2digit((String)per.toString()));
            double Change = Double.parseDouble(mktFeed.change.replaceAll("\\,", ""));
            if (Change > 0.0) {
                Image2 = "up.png";
                SetColor = this.UpColor;
            } else if (Change < 0.0) {
                Image2 = "down.png";
                SetColor = this.DownColor;
            } else if (Change == 0.0) {
                Image2 = "level.png";
                SetColor = this.LevelColor;
            }
            pnl.tickerPanel.lblScrip.setForeground(SetColor);
            pnl.tickerPanel.lblLtrdPrice.setForeground(SetColor);
            pnl.tickerPanel.lblLtrdPrice.setFont(pnl.tickerPanel.lblLtrdPrice.getFont().deriveFont(1));
            pnl.tickerPanel.lblChangeImage.setIcon(this.loadImage("/Images/" + Image2));
            pnl.tickerPanel.lblChangeImage.setText("");
            if (this.ticker.showPercantage) {
                pnl.tickerPanel.lblPercentChange.setText(per + this.ChangePersantage + ")");
            } else if (!this.ticker.showPercantage) {
                pnl.tickerPanel.lblChangeImage.setText(")");
            }
            pnl.tickerPanel.lblPercentChange.setForeground(SetColor);
            pnl.tickerPanel.lblChangeImage.setForeground(SetColor);
            pnl.tickerPanel.lblChange.setForeground(SetColor);
            pnl.tickerPanel.lblScripName.setForeground(SetColor);
            pnl.tickerPanel.lblTradeVol.setText(Util.format0digit((String)mktFeed.totVolume));
            pnl.tickerPanel.lblTradeVol.setForeground(SetColor);
            if (SwingUtilities.isEventDispatchThread()) {
                pnl.tickerPanel.setSize();
                pnl.repaint();
                continue;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    pnl.tickerPanel.setSize();
                    pnl.repaint();
                }
            });
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ValuePanel.this.repaint();
                }
            });
        }
        this.repaint();
        this.ActualSize = this.getPreferredSize().width;
    }

    public void SetPanelSize(int Size) {
        this.setBounds(this.x, this.y, this.ActualSize, 30);
    }

    public void ShowHideScripName(boolean isVisible) {
        Enumeration<String> en = this.ht.keys();
        while (en.hasMoreElements()) {
            String symbol = en.nextElement().toString();
            TickerValues pnl = this.ht.get(symbol);
            pnl.tickerPanel.lblScripName.setVisible(isVisible);
            pnl.tickerPanel.setSize();
        }
        this.ActualSize = this.getPreferredSize().width;
    }

    public void addNewCapORLockedSymbol(String Symbol) {
        if (!this.ht.containsKey(Symbol)) {
            this.add(new TickerValues(Symbol, this.ticker));
            this.ActualSize = this.getPreferredSize().width;
        }
    }

    public void RemoveCapORLockedSymbol(String Symbol) {
        if (this.ht.containsKey(Symbol)) {
            TickerValues pnl = this.ht.get(Symbol);
            this.remove(pnl);
            this.ht.remove(Symbol);
            this.ActualSize = this.getPreferredSize().width;
        }
    }

    public void addSymbol(final String Symbol) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ValuePanel.this.add(new TickerValues(Symbol, ValuePanel.this.ticker));
                    ValuePanel.this.ActualSize = ValuePanel.this.getPreferredSize().width;
                }
            });
        } else {
            this.add(new TickerValues(Symbol, this.ticker));
            this.ActualSize = this.getPreferredSize().width;
        }
    }

    public void RemoveAllSymbols() {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Enumeration<String> en = ValuePanel.this.ht.keys();
                    while (en.hasMoreElements()) {
                        String symbol = en.nextElement().toString();
                        TickerValues pnl = ValuePanel.this.ht.get(symbol);
                        ValuePanel.this.remove(pnl);
                    }
                    ValuePanel.this.ht.clear();
                }
            });
        } else {
            Enumeration<String> en = this.ht.keys();
            while (en.hasMoreElements()) {
                String symbol = en.nextElement().toString();
                TickerValues pnl = this.ht.get(symbol);
                this.remove(pnl);
            }
            this.ht.clear();
        }
    }

    public ImageIcon loadImage(String imageNum) {
        if (imageNum.indexOf("up") >= 0) {
            if (upIcon != null) {
                return upIcon;
            }
            upIcon = ValuePanel.icon("/Images/up.png");
            return upIcon;
        }
        if (imageNum.indexOf("down") >= 0) {
            if (lowIcon != null) {
                return lowIcon;
            }
            lowIcon = ValuePanel.icon("/Images/down.png");
            return lowIcon;
        }
        if (levelIcon != null) {
            return levelIcon;
        }
        lowIcon = ValuePanel.icon("/Images/level.png");
        return lowIcon;
    }

    public void init_components() {
        this.add(new TickerValues("PPL", this.ticker));
        this.add(new TickerValues("POL", this.ticker));
        this.add(new TickerValues("PTC", this.ticker));
        this.add(new TickerValues("OGDC", this.ticker));
        this.add(new TickerValues("QUICE", this.ticker));
        this.ActualSize = this.getPreferredSize().width;
    }

    void SaveSize(int Width) {
        TickerParameters tp = LogsTC.tickerMap.get(this.TickerName);
        if (tp != null) {
            tp.width = Width;
        }
    }

    public void UpdateAllValues() {
        this.Update();
        this.UpdateUpperCappedAndLowerLocked();
        this.updateUI();
        this.repaint();
    }

    static {
        try {
            upIcon = ValuePanel.icon("/Images/up.png");
            lowIcon = ValuePanel.icon("/Images/down.png");
            levelIcon = ValuePanel.icon("/Images/level.png");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class TickerValues
    extends JPanel {
        TickerPanel tickerPanel = null;
        Ticker ticker = null;

        public TickerValues(String Val, Ticker tt) {
            this.ticker = tt;
            this.tickerPanel = new TickerPanel(tt);
            this.setLayout(new BoxLayout(this, 0));
            this.MakeTickerSingleValuePanel(Val);
        }

        @Override
        public void setOpaque(boolean isOpaque) {
            super.setOpaque(false);
        }

        private void MakeTickerSingleValuePanel(String Symbol) {
            ValuePanel.this.ht.put(Symbol, this);
            this.tickerPanel.lblScrip.setText(Symbol);
            this.tickerPanel.lblLtrdPrice.setText(Util.format2digit((String)"0"));
            this.tickerPanel.lblChange.setText("(" + Util.format2digit((String)"0"));
            this.tickerPanel.lblChangeImage.setIcon(ValuePanel.this.loadImage("/Images/level.png"));
            this.tickerPanel.lblPercentChange.setText("0.00%)");
            this.tickerPanel.lblTradeVol.setText(Util.format0digit((String)"0"));
            this.tickerPanel.lblTradeVol.setForeground(Color.BLUE);
            this.tickerPanel.lblLtrdPrice.setForeground(Color.BLUE);
            this.tickerPanel.lblScripName.setVisible(this.ticker.showScripName);
            this.tickerPanel.lblPercentChange.setVisible(this.ticker.showPercantage);
            this.tickerPanel.lblTradeVol.setVisible(this.ticker.showVolume);
            String SymFullName = "  ";
            if (LogCommon.SymbolAndSymbolName.containsKey(Symbol)) {
                SymFullName = ((String)LogCommon.SymbolAndSymbolName.get(Symbol)).toString();
            }
            this.tickerPanel.lblScripName.setText(SymFullName);
            this.tickerPanel.setSize();
            this.add(this.tickerPanel);
        }
    }
}

