/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import MyDocking.Mediator;
import common.gui.util.FormName;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import kse.util.UtilKSE;
import pmex.gui.util.UtilPMEX;

public class MyDradAndDrop {
    private Mediator mediator = Mediator.getInstance();
    private int Col = 0;
    private FormName formName = null;
    private JTable table = null;
    final JPopupMenu popup = new JPopupMenu();

    public MyDradAndDrop(JTable tbl, FormName formName) {
        this.table = tbl;
        this.formName = formName;
        this.EnableDradAndDrop(tbl);
    }

    public MyDradAndDrop(JTable tbl, int ColNumber, FormName formName) {
        this.Col = ColNumber;
        this.table = tbl;
        this.formName = formName;
        this.EnableDradAndDrop(tbl);
    }

    private void EnableDradAndDrop(final JTable table) {
        table.setDragEnabled(true);
        table.setTransferHandler(new TransferHandler(){

            @Override
            public int getSourceActions(JComponent c) {
                return 3;
            }

            @Override
            protected Transferable createTransferable(JComponent component) {
                final JTable tbl = (JTable)component;
                Transferable transferable = new Transferable(){

                    @Override
                    public DataFlavor[] getTransferDataFlavors() {
                        DataFlavor[] flavor = new DataFlavor[]{DataFlavor.stringFlavor};
                        return flavor;
                    }

                    @Override
                    public boolean isDataFlavorSupported(DataFlavor flavor) {
                        return true;
                    }

                    @Override
                    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                        String val = "";
                        if (MyDradAndDrop.this.formName != null) {
                            if (MyDradAndDrop.this.formName == FormName.PMEX_MarketWatch || MyDradAndDrop.this.formName == FormName.PMEX_Matrix || MyDradAndDrop.this.formName == FormName.PMEX_TopMovers) {
                                val = "PMEX=";
                                if (table.getSelectionModel().getSelectionMode() == 2) {
                                    for (int i : table.getSelectedRows()) {
                                        String temp = tbl.getModel().getValueAt(i, MyDradAndDrop.this.Col).toString();
                                        val = val + temp + ";" + UtilPMEX.GetMarketFromContract((String)temp) + "|";
                                    }
                                } else {
                                    val = val + tbl.getModel().getValueAt(tbl.getSelectedRow(), MyDradAndDrop.this.Col).toString();
                                    val = val + ";" + UtilPMEX.GetMarketFromContract((String)val);
                                }
                            } else if (MyDradAndDrop.this.formName == FormName.MarketWatch || MyDradAndDrop.this.formName == FormName.TopMovers) {
                                val = "KSE=";
                                if (table.getSelectionModel().getSelectionMode() == 2) {
                                    for (int i : table.getSelectedRows()) {
                                        String temp = tbl.getModel().getValueAt(i, MyDradAndDrop.this.Col).toString();
                                        val = val + temp + ";" + UtilKSE.GetMarketFromsymbol((String)temp) + "|";
                                    }
                                } else {
                                    val = val + tbl.getModel().getValueAt(tbl.getSelectedRow(), MyDradAndDrop.this.Col).toString();
                                    val = val + ";" + UtilKSE.GetMarketFromsymbol((String)val);
                                }
                            }
                        }
                        return val;
                    }
                };
                return transferable;
            }

            @Override
            public boolean canImport(JComponent c, DataFlavor[] flavors) {
                return true;
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                return true;
            }
        });
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (SwingUtilities.isLeftMouseButton(me) && me.getClickCount() % 2 == 0) {
                    String text = (String)table.getModel().getValueAt(table.getSelectedRow(), MyDradAndDrop.this.Col);
                    MyDradAndDrop.this.fireDrop(text);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    int rowNumber = table.rowAtPoint(e.getPoint());
                    if (rowNumber >= 0 && rowNumber < table.getRowCount()) {
                        table.setRowSelectionInterval(rowNumber, rowNumber);
                    } else {
                        table.clearSelection();
                    }
                    int rowindex = table.getSelectedRow();
                    if (rowindex < 0) {
                        return;
                    }
                }
            }
        });
    }

    private void fireDrop(String text) {
        if (this.formName != null) {
            if (this.formName == FormName.PMEX_MarketWatch || this.formName == FormName.PMEX_TopMovers) {
                this.mediator.PMEX_MarketWatchPanel.AddContractInWatch(text + ";" + UtilPMEX.GetMarketFromContract((String)text));
            } else if (this.formName == FormName.PMEX_Matrix) {
                this.mediator.PMEX_Matrix.AddContractInWatch(text);
            } else if (this.formName == FormName.MarketWatch || this.formName == FormName.TopMovers) {
                this.mediator.MwPanel.AddSymbolInWatch(text);
            }
        }
    }

    private void setPopUpMenu() {
        JMenuItem menuItem = new JMenuItem("Add to selected profile");
        this.popup.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String val = "";
                if (MyDradAndDrop.this.formName != null) {
                    if (MyDradAndDrop.this.formName == FormName.PMEX_MarketWatch || MyDradAndDrop.this.formName == FormName.PMEX_TopMovers) {
                        if (MyDradAndDrop.this.table.getSelectionModel().getSelectionMode() == 2) {
                            for (int i : MyDradAndDrop.this.table.getSelectedRows()) {
                                String temp = MyDradAndDrop.this.table.getModel().getValueAt(i, MyDradAndDrop.this.Col).toString();
                                val = val + temp + ";" + UtilPMEX.GetMarketFromContract((String)temp) + "|";
                            }
                        } else {
                            val = MyDradAndDrop.this.table.getModel().getValueAt(MyDradAndDrop.this.table.getSelectedRow(), MyDradAndDrop.this.Col).toString();
                            val = val + ";" + UtilPMEX.GetMarketFromContract((String)val);
                        }
                    } else if (MyDradAndDrop.this.formName == FormName.PMEX_Matrix) {
                        if (MyDradAndDrop.this.table.getSelectionModel().getSelectionMode() == 2) {
                            for (int i : MyDradAndDrop.this.table.getSelectedRows()) {
                                val = val + MyDradAndDrop.this.table.getModel().getValueAt(i, MyDradAndDrop.this.Col).toString() + "|";
                            }
                        } else {
                            val = MyDradAndDrop.this.table.getModel().getValueAt(MyDradAndDrop.this.table.getSelectedRow(), MyDradAndDrop.this.Col).toString() + "|";
                        }
                    } else if (MyDradAndDrop.this.formName == FormName.MarketWatch || MyDradAndDrop.this.formName == FormName.TopMovers) {
                        val = MyDradAndDrop.this.table.getModel().getValueAt(MyDradAndDrop.this.table.getSelectedRow(), MyDradAndDrop.this.Col).toString();
                    }
                }
                MyDradAndDrop.this.fireDrop(val);
            }
        });
    }
}

