/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import MyDocking.Mediator;
import java.util.ArrayList;
import kse.gui.bean.OrderImportBean;
import kse.gui.bean.OutstandingLogBean;
import kse.gui.bean.TradeOutLogBean;
import kse.util.LogsKSE;

public class OutstandingLogUtil {
    public static String GetLogForWebClient(ArrayList<OutstandingLogBean> arrayList) {
        StringBuilder ret = new StringBuilder();
        try {
            if (arrayList == null) {
                return "";
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                OutstandingLogBean olog = arrayList.get(i);
                if (olog == null) continue;
                ret.append(olog.toString());
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return ret.toString();
    }

    public static synchronized boolean RemoveOutstandinglogByOrderNo(String orderno) {
        boolean ret = false;
        try {
            for (int i = 0; i < LogsKSE.OutstandingLogAllRecord.size(); ++i) {
                OutstandingLogBean outstandingLogBean = (OutstandingLogBean)LogsKSE.OutstandingLogAllRecord.get(i);
                if (!outstandingLogBean.Outstandinglog_ORDERNO.equalsIgnoreCase(orderno)) continue;
                LogsKSE.OutstandingLogAllRecord.remove(i);
                LogsKSE.OutstandingLogByOrderNo.remove(orderno.toUpperCase());
                ret = true;
                break;
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return ret;
    }

    public static synchronized OutstandingLogBean AddOutstandinglog(String order_string) {
        OutstandingLogBean ret = null;
        try {
            OutstandingLogBean olog = new OutstandingLogBean();
            if (olog.parse(order_string)) {
                OutstandingLogUtil.RemoveOutstandinglogByOrderNo(olog.Outstandinglog_ORDERNO);
                LogsKSE.OutstandingLogAllRecord.add(olog);
                LogsKSE.OutstandingLogByOrderNo.put(olog.Outstandinglog_ORDERNO.toUpperCase(), olog);
                ret = olog;
            } else {
                Mediator.getInstance().println("AddOutstandinglog() parse error: " + order_string);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return ret;
    }

    public static long ScripInOutstandinglogCount(String scrip) {
        boolean isFound = false;
        long totalSheare = 0L;
        try {
            for (int i = 0; i < LogsKSE.OutstandingLogAllRecord.size(); ++i) {
                OutstandingLogBean olog = (OutstandingLogBean)LogsKSE.OutstandingLogAllRecord.get(i);
                if (olog == null || !olog.Outstandinglog_SYMBOL.equalsIgnoreCase(scrip)) continue;
                isFound = true;
                totalSheare += olog.Outstandinglog_REMAINING;
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        if (!isFound) {
            totalSheare = -1L;
        }
        return totalSheare;
    }

    public static boolean isScripInOutstandinglog(String scrip, String accountNo) {
        boolean isFound = false;
        try {
            for (int i = 0; i < LogsKSE.OutstandingLogAllRecord.size(); ++i) {
                OutstandingLogBean olog = (OutstandingLogBean)LogsKSE.OutstandingLogAllRecord.get(i);
                if (olog == null || !olog.Outstandinglog_SYMBOL.equalsIgnoreCase(scrip) || !olog.Outstandinglog_ACCOUNT.equalsIgnoreCase(accountNo)) continue;
                isFound = true;
                break;
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return isFound;
    }

    public static synchronized OutstandingLogBean UpdateOutstandinglog(String orderno, TradeOutLogBean bean) {
        OutstandingLogBean ret = null;
        try {
            OutstandingLogBean olog = null;
            olog = (OutstandingLogBean)LogsKSE.OutstandingLogByOrderNo.get(orderno.toUpperCase());
            if (olog != null) {
                olog.Outstandinglog_REMAINING = bean.getRemaining();
                olog.Outstandinglog_FLAG = bean.getFlag();
                if (olog.Outstandinglog_REMAINING <= 0L) {
                    LogsKSE.OutstandingLogAllRecord.remove(olog);
                    LogsKSE.OutstandingLogByOrderNo.remove(olog.Outstandinglog_ORDERNO.toUpperCase());
                }
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return ret;
    }

    public static synchronized ArrayList<OutstandingLogBean> GetOrderToCancel(ArrayList<OutstandingLogBean> arrayList, String OrderNumber) {
        ArrayList<OutstandingLogBean> retList = new ArrayList();
        try {
            OutstandingLogBean LastOrderLog = null;
            LastOrderLog = (OutstandingLogBean)LogsKSE.OutstandingLogByOrderNo.get(OrderNumber.toUpperCase());
            if (LastOrderLog != null) {
                retList.add(LastOrderLog);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            retList = arrayList;
        }
        return retList;
    }

    public static synchronized OutstandingLogBean GetOrderToCancel(String OrderNumber) {
        OutstandingLogBean retList = null;
        try {
            OutstandingLogBean LastOrderLog = null;
            LastOrderLog = (OutstandingLogBean)LogsKSE.OutstandingLogByOrderNo.get(OrderNumber.toUpperCase());
            if (LastOrderLog != null) {
                retList = LastOrderLog;
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return retList;
    }

    public static boolean isInOutstaning(OrderImportBean bean) {
        for (int i = 0; i < LogsKSE.OutstandingLogAllRecord.size(); ++i) {
            OutstandingLogBean outstandingLogBean = (OutstandingLogBean)LogsKSE.OutstandingLogAllRecord.get(i);
            if (!outstandingLogBean.Outstandinglog_ACCOUNT.equalsIgnoreCase(bean.getAccount()) || !outstandingLogBean.Outstandinglog_MARKET.equalsIgnoreCase(bean.getMarket()) || !outstandingLogBean.Outstandinglog_SYMBOL.equalsIgnoreCase(bean.getScrip()) || outstandingLogBean.Outstandinglog_TYPE.indexOf(bean.getType()) < 0 || outstandingLogBean.Outstandinglog_PRICE != bean.getPrice()) continue;
            return true;
        }
        return false;
    }
}

