/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import Beans.Tradelog;
import CATALYST.Control.MarketWatch;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Utilities.CompressManager;
import Utilities.LogsTC;
import Utilities.Voice;
import common.bean.AccountBean;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.ImageUtil;
import common.gui.util.LogCommon;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import kse.gui.bean.OutstandingLogBean;
import kse.util.LogsKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import pmex.gui.util.LogsPMEX;

public class UtilTC {
    public static Toolkit kit = Toolkit.getDefaultToolkit();
    static HashMap<String, Long> LateOrderMap = new HashMap();
    public static TrayIcon trayIcon = null;
    private static LanguageCentre languageCentre = new LanguageCentre();
    static SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss.S");

    public static String GetMarketFromsymbol(String Symbol_) {
        Symbol_ = Symbol_.toUpperCase();
        String[] MarketMonth = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
        String[] SIF_Scrip = new String[]{"KSE100", "KSE30", "KMI30", "ALLSHR"};
        String Market = "REG";
        if (Symbol_.indexOf("-") > 1) {
            String[] SymbilWithMarket = Symbol_.split("\\-", -1);
            if (SymbilWithMarket[1].equalsIgnoreCase("PRO")) {
                Market = "IPO";
            } else {
                for (int i = 0; i < MarketMonth.length; ++i) {
                    if (SymbilWithMarket[1].indexOf(MarketMonth[i]) < 0) continue;
                    for (int j = 0; j < SIF_Scrip.length; ++j) {
                        if (!SIF_Scrip[j].equals(SymbilWithMarket[0])) continue;
                        Market = "SIF";
                        break;
                    }
                    if (Market.equals("SIF")) break;
                    Market = "FUT";
                    break;
                }
            }
        }
        return Market;
    }

    public static boolean readFile(String path) {
        boolean status = false;
        File file = new File(path);
        file.setWritable(true);
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        try {
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            if (dis.available() != 0) {
                return true;
            }
            fis.close();
            bis.close();
            dis.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return status;
    }

    public static void saveWindowPositions(Hashtable ht) {
        String filename = AppConfig.userDocuments + AppConfig.houseName;
        File f = new File(filename);
        f.mkdirs();
        filename = AppConfig.userDocuments + AppConfig.houseName + Util.FileSeparator + LogCommon.UserID + Util.FileSeparator + "Layout1.cat";
        try {
            ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(filename));
            output.writeObject(ht);
            output.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static Hashtable getWindowPositions() {
        String filename = System.getProperty("user.home") + Util.FileSeparator + "TradeCast" + Util.FileSeparator + AppConfig.houseName + Util.FileSeparator + LogCommon.UserID;
        File f = new File(filename);
        f.mkdirs();
        filename = System.getProperty("user.home") + Util.FileSeparator + "TradeCast" + Util.FileSeparator + AppConfig.houseName + Util.FileSeparator + LogCommon.UserID + Util.FileSeparator + "Layout1.cat";
        Hashtable ht = null;
        try {
            if (f.exists()) {
                ObjectInputStream input = new ObjectInputStream(new FileInputStream(filename));
                ht = (Hashtable)input.readObject();
                input.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ht;
    }

    public static Dimension getScreenDimension() {
        return kit.getScreenSize();
    }

    public static void makeFile2(String fileName) {
        if (!UtilTC.readFile(fileName)) {
            FileWriter file1 = null;
            try {
                file1 = new FileWriter(fileName);
                BufferedWriter out = new BufferedWriter(file1);
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    file1.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static String getFormattedValue(double d, String Pattern) {
        try {
            Locale loc = new Locale("en", "US");
            NumberFormat nf = NumberFormat.getNumberInstance(loc);
            DecimalFormat df = (DecimalFormat)nf;
            df.applyPattern(Pattern);
            return df.format(d);
        }
        catch (Exception e) {
            return String.valueOf(d);
        }
    }

    public static String getFormattedValue(String ds, String Pattern) {
        try {
            double d = Double.parseDouble(ds);
            Locale loc = new Locale("en", "US");
            NumberFormat nf = NumberFormat.getNumberInstance(loc);
            DecimalFormat df = (DecimalFormat)nf;
            df.applyPattern(Pattern);
            return df.format(d);
        }
        catch (Exception e) {
            return ds;
        }
    }

    public static Point getLocation(Point location) {
        double x = location.getX();
        double y = location.getY();
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension d = kit.getScreenSize();
        double Y = d.getHeight() * y / 100.0;
        double X = d.getWidth() * x / 100.0;
        return new Point((int)X, (int)Y);
    }

    public static Rectangle getBounds(int width, int heigth, double widthPer, double heightPer) {
        Rectangle r = new Rectangle();
        int w = width;
        int h = heigth;
        Toolkit kitt = Toolkit.getDefaultToolkit();
        Dimension d = kitt.getScreenSize();
        double wPer = widthPer / 100.0;
        double hPer = (100.0 - heightPer) / 100.0;
        double wLocation = (double)d.width * wPer;
        double hLocation = (double)d.height * hPer;
        int finalWPoint = (int)(wLocation - (double)w);
        int finalHPoint = (int)(hLocation - (double)h);
        r.setBounds(finalWPoint, finalHPoint, w, h);
        return r;
    }

    public static String getUniqueSymbols(String mrtSymbol, String other) {
        int i;
        HashSet<String> symbolSet = new HashSet<String>();
        String symbols = "";
        String[] sym = mrtSymbol.split("\\;", -1);
        for (i = 0; i < sym.length; ++i) {
            symbolSet.add(sym[i]);
        }
        sym = other.split("\\;", -1);
        for (i = 0; i < sym.length; ++i) {
            symbolSet.add(sym[i]);
        }
        for (String item : symbolSet) {
            if (item.equalsIgnoreCase("")) continue;
            symbols = symbols + item + ";";
        }
        return symbols;
    }

    public static void SelectRow(JTable m_table, JScrollPane scrollPane, int row) {
        if (m_table.getModel().getRowCount() > row) {
            m_table.addRowSelectionInterval(0, m_table.getModel().getRowCount() - 1);
            m_table.addRowSelectionInterval(0, row);
            UtilTC.ScrollToRow(m_table, scrollPane, row);
        }
    }

    private static void ScrollToRow(JTable m_table, JScrollPane scrollPane, int row) {
        int RowHeight = m_table.getRowHeight();
        if ((row + 1) * RowHeight - scrollPane.getVerticalScrollBar().getValue() > scrollPane.getVerticalScrollBar().getVisibleAmount()) {
            JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
            verticalScrollBar.setValue(row * RowHeight);
        } else if (scrollPane.getVerticalScrollBar().getValue() > (row + 1) * RowHeight) {
            JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
            verticalScrollBar.setValue(row * RowHeight);
        }
    }

    public static void PlayLateOrderConfirmationVoice(boolean play, String message) {
        try {
            if (LogCommon.PlayLateOrderConfirmationVoice) {
                Tradelog tlog;
                String[] logList;
                if (!play) {
                    OutstandingLogBean olog;
                    String[] logList2 = message.split("\\|", -1);
                    if (logList2.length > 0 && (olog = new OutstandingLogBean()).parse(logList2[0])) {
                        LateOrderMap.put(olog.Outstandinglog_ORDERNO, System.currentTimeMillis());
                    }
                } else if (play && (logList = message.split("\\|", -1)).length > 0 && (tlog = new Tradelog()).parse(logList[0]) && LateOrderMap.containsKey(tlog.Tradelog_ORDERNO)) {
                    long oldvalue = LateOrderMap.get(tlog.Tradelog_ORDERNO);
                    if (System.currentTimeMillis() - oldvalue > LogCommon.LateOrderConfirmationDelay * 60L * 1000L) {
                        if (tlog.Tradelog_TYPE.toUpperCase().indexOf("BUY") > -1) {
                            Voice.getInstance().Speak(tlog.Tradelog_FILLVOLUME + " " + Util.MakeSingleCharacterVoice((String)tlog.Tradelog_SYMBOL) + " Bought at " + tlog.Tradelog_PRICE);
                        } else if (tlog.Tradelog_TYPE.toUpperCase().indexOf("SEL") > -1) {
                            Voice.getInstance().Speak(tlog.Tradelog_FILLVOLUME + " " + Util.MakeSingleCharacterVoice((String)tlog.Tradelog_SYMBOL) + " Sold at " + tlog.Tradelog_PRICE);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void ExtractAccount(String tradAccounts) {
        Mediator.getInstance().println("Trader Accounts  = " + tradAccounts);
        String[] Row2 = tradAccounts.split("\\|");
        LogsTC.accountAll.clear();
        LogsPMEX.ALL_ACCOUNTS.clear();
        for (int i = 0; i < Row2.length; ++i) {
            if (Row2[i].length() <= 0) continue;
            AccountBean ac = new AccountBean();
            String[] Values2 = Row2[i].split("\\;", -1);
            if (Values2.length > 0) {
                ac.setAccountNo(Values2[0]);
            }
            if (Values2.length > 1) {
                ac.setName(Values2[1]);
            }
            if (Values2.length > 2) {
                ac.setContact(Values2[2]);
            }
            if (Values2.length > 5) {
                ac.setCNIC(Values2[5]);
            }
            if (Values2.length > 4) {
                ac.setType(Values2[4]);
                if (Values2[4].equalsIgnoreCase("pmex") || Values2[4].equalsIgnoreCase("commodity")) {
                    LogsPMEX.accountPrefix = Values2[0].substring(0, 6);
                    LogsPMEX.ALL_ACCOUNTS.put(ac.getAccountNo(), ac);
                    continue;
                }
                LogsTC.accountAll.put(ac.getAccountNo(), ac);
                continue;
            }
            LogsTC.accountAll.put(ac.getAccountNo(), ac);
        }
    }

    public static void GetAccounts(String userID) {
        try {
            UtilTC.ExtractAccount(CompressManager.unzipStringFromBytes(WebService.getInstance().getPort().tradAccounts(userID)));
            boolean found = false;
            if (LogsTC.accountAll.containsKey(LogCommon.preferredAccount)) {
                found = true;
            }
            if (!found) {
                LogCommon.preferredAccount = "";
            }
            if (LogsTC.accountAll.size() == 1) {
                for (String LogCommon.preferredAccount : LogsTC.accountAll.keySet()) {
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getScripSector(String scrip) {
        String sec;
        ArrayList al;
        String sector = "";
        Enumeration er = LogCommon.SectorAndIndicesSymbol.keys();
        while (er.hasMoreElements() && (!(al = (ArrayList)LogCommon.SectorAndIndicesSymbol.get(sector = er.nextElement().toString())).contains(scrip) || (sec = sector.replaceAll(" ", "")).equalsIgnoreCase("100INDEX") || sec.equalsIgnoreCase("30INDEX") || sec.equalsIgnoreCase("KMI30INDEX") || sec.equalsIgnoreCase("OGTIINDEX") || sec.equalsIgnoreCase("BKTIINDEX") || sec.equalsIgnoreCase("KMIALLSHR"))) {
        }
        return sector;
    }

    public static void setTrayIcon() {
        if (trayIcon != null) {
            return;
        }
        SystemTray tray = SystemTray.getSystemTray();
        try {
            if (AppConfig.houseIcon == null) {
                AppConfig.houseIcon = ImageUtil.downloadImage((String)(AppConfig.TradeCastURL + "/HouseImages/small.png"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PopupMenu popup = new PopupMenu();
        popup.setFont(AppConfig.defaultPlanFont);
        MenuItem exitMenu = new MenuItem("Exit");
        exitMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TradeCast.getInstance().Close();
            }
        });
        MenuItem aboutMenu = new MenuItem(languageCentre.getValue(LanguageConstant.AboutTradeCast));
        aboutMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Mediator.getInstance().OpenAboutWindow();
            }
        });
        popup.setFont(AppConfig.defaultPlanFont);
        aboutMenu.setFont(AppConfig.defaultPlanFont);
        exitMenu.setFont(AppConfig.defaultPlanFont);
        popup.add(aboutMenu);
        popup.addSeparator();
        popup.add(exitMenu);
        if (AppConfig.houseIcon != null) {
            trayIcon = new TrayIcon(AppConfig.houseIcon, "Trade Cast v" + AppConfig.version.trim(), popup);
            trayIcon.setImageAutoSize(true);
            trayIcon.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TradeCast.getInstance().toFront(false, false);
                    if (LogsKSE.isGetPinCode) {
                        TradeCast.getInstance().ShowDynamicForm(FormName.CreatePinCode, LanguageConstant.CreatePIN);
                        LogsKSE.isGetPinCode = false;
                    }
                }
            });
        }
        try {
            if (trayIcon != null) {
                tray.add(trayIcon);
            }
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    public static void setTrayMessage(String title, String message, TrayIcon.MessageType type) {
        UtilTC.setTrayIcon();
        if (LogCommon.isShowBubbleHelp && trayIcon != null) {
            trayIcon.displayMessage("Trade Cast v" + AppConfig.version.trim(), message.trim(), type);
        }
    }

    public static void setParam(String appParam) {
        block22: {
            try {
                if (appParam.indexOf("|") <= 0) break block22;
                String[] params = appParam.split("\\|", -1);
                for (int i = 0; i < params.length; ++i) {
                    String param = params[i];
                    if (param.indexOf("~") <= 0) continue;
                    String[] value = param.split("\\~", -1);
                    Mediator.getInstance().println("param[0] = " + value[0] + " param[1] = " + value[1]);
                    if (value[0].equalsIgnoreCase("ScreenerText")) {
                        AppConfig.ScreenerText = value[1];
                    }
                    if (value[0].equalsIgnoreCase("ScreenerLink")) {
                        AppConfig.ScreenerLink = value[1];
                    }
                    if (value[0].equalsIgnoreCase("SnapShotWindowLink")) {
                        AppConfig.SnapShotWindowLink = value[1];
                    }
                    if (value[0].equalsIgnoreCase("ResreachMenuText")) {
                        AppConfig.ResreachMenuText = value[1];
                    }
                    if (value[0].equalsIgnoreCase("ResreachMenuLink")) {
                        AppConfig.ResreachMenuLink = value[1];
                    }
                    if (value[0].equalsIgnoreCase("IsTickerEnable")) {
                        AppConfig.isTickerEnable = value[1].equalsIgnoreCase("1");
                    }
                    if (value[0].equalsIgnoreCase("InactiveTime")) {
                        try {
                            AppConfig.InactiveTime = Integer.parseInt(value[1]);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (value[0].equalsIgnoreCase("IsGeneratePinCode")) {
                        AppConfig.isCreatePinCode = value[1].equalsIgnoreCase("1");
                    }
                    if (value[0].equalsIgnoreCase("IsCashWithdrawalWithBank")) {
                        AppConfig.isCashWithdrawalWithBank = value[1].equalsIgnoreCase("1");
                    }
                    if (value[0].equalsIgnoreCase("IsShariaWatch")) {
                        AppConfig.isShariaWatch = value[1].equalsIgnoreCase("1");
                    }
                    if (value[0].equalsIgnoreCase("IsCalculatePercentage")) {
                        MarketWatch.isCalculatePercentage = value[1].equalsIgnoreCase("1");
                    }
                    if (value[0].equalsIgnoreCase("isPortfolioAdv")) {
                        AppConfig.isPortfolioAdv = value[1].equalsIgnoreCase("1");
                    }
                    if (value[0].equalsIgnoreCase("isHistoricalDataWatch")) {
                        AppConfig.isHistoricalDataWatch = value[1].equalsIgnoreCase("1");
                    }
                    if (value[0].equalsIgnoreCase("GraphURL")) {
                        AppConfig.GraphURL = value[1];
                    }
                    if (value[0].equalsIgnoreCase("HTTPTradeURL")) {
                        AppConfig.HTTPTradeURL = value[1];
                    }
                    if (value[0].equalsIgnoreCase("HTTPFeedURL")) {
                        AppConfig.HTTPFeedURL = value[1];
                    }
                    if (value[0].equalsIgnoreCase("JCR_VIS_Data_URL")) {
                        AppConfig.JCR_VIS_Data_URL = value[1];
                    }
                    if (!value[0].equalsIgnoreCase("CapitalAnalyticDisclaimer")) continue;
                    AppConfig.CapitalAnalyticDisclaimer = value[1];
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static ArrayList getCompanyOfSector(String sector) {
        if (LogCommon.SectorAndIndicesSymbol.containsKey(sector)) {
            return (ArrayList)LogCommon.SectorAndIndicesSymbol.get(sector);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font loadFont(String name, float fontSize) throws FontFormatException, IOException {
        Font font;
        String resourceName = name;
        InputStream is = UtilTC.class.getResourceAsStream(resourceName);
        if (is == null) {
            throw new FileNotFoundException("Font resource '" + resourceName + "' not found.");
        }
        try {
            font = Font.createFont(0, is);
        }
        finally {
            is.close();
        }
        return font.deriveFont(fontSize);
    }

    public static void printDateTime(String title) {
        System.out.println(title + " -> " + formatter.format(new Date(System.currentTimeMillis())));
    }

    public static String GenerateThreadDump() {
        ThreadInfo[] threadInfos;
        StringBuilder dump = new StringBuilder();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : threadInfos = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), 100)) {
            StackTraceElement[] stackTraceElements;
            dump.append('\"');
            dump.append(threadInfo.getThreadName());
            dump.append("\" ");
            Thread.State state = threadInfo.getThreadState();
            dump.append(System.getProperty("line.separator")).append("   java.lang.Thread.State: ");
            dump.append((Object)state);
            for (StackTraceElement stackTraceElement : stackTraceElements = threadInfo.getStackTrace()) {
                dump.append(System.getProperty("line.separator")).append("        at ");
                dump.append(stackTraceElement);
            }
            dump.append(System.getProperty("line.separator")).append("---------------------------------------------------------------").append(System.getProperty("line.separator"));
        }
        return dump.toString();
    }
}

