/*
 * Decompiled with CFR 0.152.
 */
package Watches;

import Beans.MarketWatchBean;
import CATALYST.Control.ColumnData;
import CATALYST.Control.MarketWatch;
import CATALYST.Control.MarketWatchEvent;
import CATALYST.Control.MarketWatchListner;
import CATALYST.Control.Utilities;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Utilities.LoadLogs;
import Utilities.ThreadWithName;
import Watches.HistoricalValuePanelContainer;
import Watches.LowerCapPanel;
import Watches.UpperCapPanel;
import common.gui.component.JTextFieldFilter;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.MyColors;
import common.gui.util.Util;
import common.interfaces.MarketData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import kse.util.LogsKSE;
import kse.util.UtilKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXCollapsiblePane;

public class CapWatchHistorical
extends JPanel
implements MarketWatchListner,
MarketData,
ActionListener {
    public MarketWatch MwhUpperCap;
    public MarketWatch MwhLowerCap;
    public JPopupMenu popup = new JPopupMenu();
    public static String ltPrice = "";
    public static String sys = "";
    public JComboBox comboBox_sectorlist = new JComboBox();
    private Mediator mediator = Mediator.getInstance();
    private boolean FirstLoad = true;
    private String UpperCappedSymbols = "";
    private String LowerCappedSymbols = "";
    private String[] UCSymbols = null;
    private String[] LCSymbols = null;
    JLabel UpperCappedCountLabel = null;
    JLabel LowerLockedCountLabel = null;
    private HistoricalValuePanelContainer pnlHistoricalDataContainer = null;
    private String lastScrip = "";
    private String lastMarket = "";
    private boolean LoadSymbol = true;
    private boolean isScripLoaded = false;
    private UpperCapPanel upperPanel = null;
    private LowerCapPanel lowerPanel = null;
    private boolean isShowHistoricalDataUpperCap = true;
    private boolean isShowHistoricalDataLowerCap = true;
    private int dividerSize = 88;
    private HashMap<String, Integer> columnIndex = new HashMap();
    private LanguageCentre languageCentre = new LanguageCentre();
    private JToggleButton btnChange;
    private JButton btnDetail2;
    private JButton btnQuarter;
    private JButton btnRefresh;
    private JButton btnScripDetail;
    private JButton btnStatement;
    private JXCollapsiblePane collapsiblePane;
    private Box.Filler filler1;
    private JToolBar jToolBar3;
    private JLabel lblNew;
    private JLabel lblScripBrowse;
    private JLabel lblSymbol2;
    private JLabel lblSymbolName;
    private JPanel pnlTools2;
    private JPanel pnlWatch;
    private JSplitPane splitPanel;
    private JTextField txtSymbol;

    private void setColumnIndex() {
        int index = 0;
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Market), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Scrip), index++);
        this.columnIndex.put(this.languageCentre.getValue("BuyVol"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Buy), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Sell), index++);
        this.columnIndex.put(this.languageCentre.getValue("SellVol"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.LastPrice), index++);
        this.columnIndex.put(this.languageCentre.getValue("Change"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.High), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Low), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.TotalVolume), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Average), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.PercentChange), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.LowerLock), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.UpperCap), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Trade), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.CompanySnapshot), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Analytics), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Graph), index++);
        this.columnIndex.put(this.languageCentre.getValue("MarketCap"), index++);
        this.columnIndex.put(this.languageCentre.getValue("Period"), index++);
        this.columnIndex.put(this.languageCentre.getValue("P/E"), index++);
        this.columnIndex.put(this.languageCentre.getValue("DividendYield"), index++);
        this.columnIndex.put(this.languageCentre.getValue("P/B"), index++);
        this.columnIndex.put(this.languageCentre.getValue("EPS"), index++);
        this.columnIndex.put(this.languageCentre.getValue("Dir"), index++);
        this.columnIndex.put(this.languageCentre.getValue("LTrdTime"), index++);
        this.columnIndex.put(this.languageCentre.getValue("TotalTrd"), index++);
        this.columnIndex.put(this.languageCentre.getValue("LTrdVolume"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.ClosePrice), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.OpenPrice), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.State), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Flag), index++);
        this.columnIndex.put(this.languageCentre.getValue("OutstandingShares"), index++);
        this.columnIndex.put(this.languageCentre.getValue("52WeekLow"), index++);
        this.columnIndex.put(this.languageCentre.getValue("52WeekAvg"), index++);
        this.columnIndex.put(this.languageCentre.getValue("52WeekHigh"), index++);
    }

    public CapWatchHistorical() {
        try {
            this.initComponents();
            this.setColumnIndex();
            this.mediator.setCapWatchHistorical(this);
            this.MwhUpperCap = new MarketWatch(LanguageConstant.CapWatch, this.columnIndex);
            this.pnlHistoricalDataContainer = new HistoricalValuePanelContainer(this, this.lblSymbolName);
            this.pnlHistoricalDataContainer.setSize(new Dimension(0, 165));
            this.pnlHistoricalDataContainer.setPreferredSize(new Dimension(0, 165));
            this.pnlHistoricalDataContainer.setMinimumSize(new Dimension(0, 165));
            this.pnlHistoricalDataContainer.setMaximumSize(new Dimension(0, 165));
            ColumnData[] m_columns = new ColumnData[]{new ColumnData(this.MwhUpperCap, this.languageCentre.getValue(LanguageConstant.Market), 50, 2), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue(LanguageConstant.Scrip), 100, 2), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue("BuyVol"), 80, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue(LanguageConstant.Buy), 80, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue(LanguageConstant.Sell), 80, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue("SellVol"), 80, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue(LanguageConstant.LastPrice), 80, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue("Change"), 70, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue(LanguageConstant.High), 70, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue(LanguageConstant.Low), 70, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue(LanguageConstant.TotalVolume), 100, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue(LanguageConstant.Average), 70, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue(LanguageConstant.PercentChange), 70, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue(LanguageConstant.LowerLock), 80, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue(LanguageConstant.UpperCap), 80, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue(LanguageConstant.Trade), 80, 0), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue(LanguageConstant.CompanySnapshot), 150, 0), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue(LanguageConstant.Analytics), 100, 0), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue(LanguageConstant.Graph), 100, 0), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue("MarketCap"), 120, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue("Period"), 80, 0), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue("P/E"), 80, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue("DividendYield"), 120, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue("P/B"), 80, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue("EPS"), 80, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue("Dir"), 40, 0), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue("LTrdTime"), 80, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue("TotalTrd"), 70, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue("LTrdVolume"), 100, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue(LanguageConstant.ClosePrice), 80, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue(LanguageConstant.OpenPrice), 80, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue(LanguageConstant.State), 50, 2), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue(LanguageConstant.Flag), 50, 2), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue("OutstandingShares"), 120, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue("52WeekLow"), 90, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue("52WeekAvg"), 90, 4), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue("52WeekHigh"), 90, 4)};
            ColumnData[] m_columns1 = new ColumnData[]{new ColumnData(this.MwhLowerCap, this.languageCentre.getValue(LanguageConstant.Market), 50, 2), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue(LanguageConstant.Scrip), 100, 2), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue("BuyVol"), 80, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue(LanguageConstant.Buy), 80, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue(LanguageConstant.Sell), 80, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue("SellVol"), 80, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue(LanguageConstant.LastPrice), 80, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue("Change"), 70, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue(LanguageConstant.High), 70, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue(LanguageConstant.Low), 70, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue(LanguageConstant.TotalVolume), 100, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue(LanguageConstant.Average), 70, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue(LanguageConstant.PercentChange), 70, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue(LanguageConstant.LowerLock), 80, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue(LanguageConstant.UpperCap), 80, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue(LanguageConstant.Trade), 80, 0), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue(LanguageConstant.CompanySnapshot), 150, 0), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue(LanguageConstant.Analytics), 100, 0), new ColumnData(this.MwhUpperCap, this.languageCentre.getValue(LanguageConstant.Graph), 100, 0), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue("MarketCap"), 120, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue("Period"), 80, 0), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue("P/E"), 80, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue("DividendYield"), 120, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue("P/B"), 80, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue("EPS"), 80, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue("Dir"), 40, 0), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue("LTrdTime"), 80, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue("TotalTrd"), 70, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue("LTrdVolume"), 100, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue(LanguageConstant.ClosePrice), 80, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue(LanguageConstant.OpenPrice), 80, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue(LanguageConstant.State), 50, 2), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue(LanguageConstant.Flag), 50, 2), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue("OutstandingShares"), 120, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue("52WeekLow"), 90, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue("52WeekAvg"), 90, 4), new ColumnData(this.MwhLowerCap, this.languageCentre.getValue("52WeekHigh"), 90, 4)};
            this.MwhUpperCap.isHistoricalDataWatch = AppConfig.isHistoricalDataWatch;
            this.MwhUpperCap.ChangeAllColorAndFonts(MyColors.MarketWatchRowColor, MyColors.MarketWatchSelectedRowColor, MyColors.MarketWatchIncreaseColor, MyColors.MarketWatchDecreaseColor, LogCommon.MarketWatchFont);
            this.MwhUpperCap.SetHeight = new JFrame().getToolkit().getScreenSize().height - 500;
            this.MwhUpperCap.SetWidth = new JFrame().getToolkit().getScreenSize().width + 130;
            this.MwhUpperCap.setMarket(LogCommon.markets);
            this.MwhUpperCap.Debug = false;
            this.MwhUpperCap.addListener((MarketWatchListner)this);
            this.MwhUpperCap.isUserAddScrip = false;
            this.MwhUpperCap.ShowTradeButton = AppConfig.ShowTradeButton;
            this.MwhUpperCap.ShowCompanySnapButton = AppConfig.ShowCompanySnapshotButton;
            this.MwhUpperCap.ShowGraphButton = AppConfig.ShowGraphButton;
            this.MwhUpperCap.ShowAnalyticsButton = AppConfig.ShowAnalyticsButton;
            this.MwhUpperCap.isStandardCapital = AppConfig.isStandardCapital;
            this.MwhUpperCap.init(m_columns);
            this.MwhUpperCap.setDefaultColumnIndex();
            this.MwhUpperCap.comboBox.setModel(new DefaultComboBoxModel<String>(LogCommon.markets));
            this.MwhUpperCap.comboBox.removeItem("");
            this.MwhLowerCap = new MarketWatch(LanguageConstant.CapWatch, this.columnIndex);
            this.MwhLowerCap.isHistoricalDataWatch = AppConfig.isHistoricalDataWatch;
            this.MwhLowerCap.ChangeAllColorAndFonts(MyColors.MarketWatchRowColor, MyColors.MarketWatchSelectedRowColor, MyColors.MarketWatchIncreaseColor, MyColors.MarketWatchDecreaseColor, LogCommon.MarketWatchFont);
            this.MwhLowerCap.SetHeight = new JFrame().getToolkit().getScreenSize().height - 500;
            this.MwhLowerCap.SetWidth = new JFrame().getToolkit().getScreenSize().width + 130;
            this.MwhLowerCap.setMarket(LogCommon.markets);
            this.MwhLowerCap.Debug = false;
            this.MwhLowerCap.addListener((MarketWatchListner)this);
            this.MwhLowerCap.isUserAddScrip = false;
            this.MwhLowerCap.ShowTradeButton = AppConfig.ShowTradeButton;
            this.MwhLowerCap.ShowCompanySnapButton = AppConfig.ShowCompanySnapshotButton;
            this.MwhLowerCap.ShowGraphButton = AppConfig.ShowGraphButton;
            this.MwhLowerCap.ShowAnalyticsButton = AppConfig.ShowAnalyticsButton;
            this.MwhLowerCap.isStandardCapital = AppConfig.isStandardCapital;
            this.MwhLowerCap.init(m_columns1);
            this.MwhLowerCap.setDefaultColumnIndex();
            this.MwhLowerCap.comboBox.setModel(new DefaultComboBoxModel<String>(LogCommon.markets));
            this.MwhLowerCap.comboBox.removeItem("");
            this.lblScripBrowse.setText("<html><b>" + this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></html>");
            this.btnRefresh.addActionListener(this);
            this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/Images/refresh.png")));
            this.btnRefresh.setToolTipText("Refresh Scrip");
            this.btnRefresh.setText("");
            this.lblSymbol2.setFont(this.lblSymbol2.getFont().deriveFont(1));
            this.lblSymbol2.setText("Scrip ");
            this.lblSymbol2.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
            this.lblSymbol2.setHorizontalTextPosition(2);
            this.lblSymbolName.setFont(this.lblSymbolName.getFont().deriveFont(1));
            this.lblSymbol2.setHorizontalAlignment(4);
            this.lblScripBrowse.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ((CapWatchHistorical)CapWatchHistorical.this).mediator.tradecast.ShowDynamicForm(FormName.ScripBrowse, LanguageConstant.ScripBrowse);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    CapWatchHistorical.this.lblScripBrowse.setCursor(Cursor.getPredefinedCursor(12));
                    CapWatchHistorical.this.lblScripBrowse.setText("<html><u><b>" + CapWatchHistorical.this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></u></html>");
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    CapWatchHistorical.this.lblScripBrowse.setCursor(Cursor.getPredefinedCursor(0));
                    CapWatchHistorical.this.lblScripBrowse.setText("<html><b>" + CapWatchHistorical.this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></html>");
                }
            });
            this.txtSymbol.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-"));
            this.upperPanel = new UpperCapPanel();
            this.upperPanel.addMarketWatch(this.MwhUpperCap);
            this.lowerPanel = new LowerCapPanel();
            this.lowerPanel.addMarketWatch(this.MwhLowerCap);
            this.splitPanel.setTopComponent(this.upperPanel);
            this.splitPanel.setBottomComponent(this.lowerPanel);
            this.splitPanel.setOneTouchExpandable(true);
            this.splitPanel.setDividerLocation(180);
            this.collapsiblePane.add((Component)this.pnlHistoricalDataContainer);
            this.setCollaspe();
            this.empty();
            this.btnScripDetail.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/scripDetail.png")));
            this.btnStatement.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/AnnualStatements.png")));
            this.btnQuarter.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/QuarterlyStatement.png")));
            if (LogCommon.NewCount > 2) {
                this.jToolBar3.remove(this.lblNew);
            }
            this.setLanguageValues();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void AddUpperCAPSymbol(String Symbol) {
        this.MwhUpperCap.AddSymbolInMarketWatch(Symbol + ";" + Utilities.GetMarketFromsymbol((String)Symbol), false, false);
        if (this.UpperCappedSymbols.toUpperCase().indexOf(Symbol.toUpperCase()) <= -1) {
            this.UpperCappedSymbols = this.UpperCappedSymbols + Symbol + ":" + Utilities.GetMarketFromsymbol((String)Symbol) + ";";
            this.SendFeedRequest();
        }
        this.upperPanel.addCount(this.MwhUpperCap.GetTable().getRowCount() - 1 + "");
    }

    public void AddLowerCAPSymbol(String Symbol) {
        this.MwhLowerCap.AddSymbolInMarketWatch(Symbol + ";" + Utilities.GetMarketFromsymbol((String)Symbol), false, false);
        if (this.LowerCappedSymbols.toUpperCase().indexOf(Symbol.toUpperCase()) <= -1) {
            this.LowerCappedSymbols = this.LowerCappedSymbols + Symbol + ":" + Utilities.GetMarketFromsymbol((String)Symbol) + ";";
            this.SendFeedRequest();
        }
        this.lowerPanel.addCount(this.MwhLowerCap.GetTable().getRowCount() - 1 + "");
    }

    public void RemoveUpperCAPSymbol(String Symbol) {
        this.MwhUpperCap.RemoveSymbolFromWatch(Symbol + ";" + Utilities.GetMarketFromsymbol((String)Symbol));
        if (this.UpperCappedSymbols.toUpperCase().indexOf(Symbol.toUpperCase()) > -1) {
            String[] UCSymbols1 = Utilities.split((String)this.UpperCappedSymbols, (char)';');
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < UCSymbols1.length; ++i) {
                if (UCSymbols1[i].length() <= 0 || UCSymbols1[i].equalsIgnoreCase(Symbol + ":" + Utilities.GetMarketFromsymbol((String)Symbol))) continue;
                sb.append(UCSymbols1[i]);
                sb.append(";");
            }
            this.UpperCappedSymbols = sb.toString();
            this.SendFeedRequest();
        }
        this.upperPanel.addCount(this.MwhUpperCap.GetTable().getRowCount() - 1 + "");
    }

    public void RemoveLowerCAPSymbol(String Symbol) {
        this.MwhLowerCap.RemoveSymbolFromWatch(Symbol + ";" + Utilities.GetMarketFromsymbol((String)Symbol));
        if (this.LowerCappedSymbols.toUpperCase().indexOf(Symbol.toUpperCase()) > -1) {
            String[] LCSymbols = Utilities.split((String)this.LowerCappedSymbols, (char)';');
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < LCSymbols.length; ++i) {
                if (LCSymbols[i].length() <= 0 || LCSymbols[i].equalsIgnoreCase(Symbol + ":" + Utilities.GetMarketFromsymbol((String)Symbol))) continue;
                sb.append(LCSymbols[i]);
                sb.append(";");
            }
            this.LowerCappedSymbols = sb.toString();
            this.SendFeedRequest();
        }
        this.lowerPanel.addCount(this.MwhLowerCap.GetTable().getRowCount() - 1 + "");
    }

    public void SetUpperCappedString(String str) {
        this.isShowHistoricalDataUpperCap = false;
        this.UpperCappedSymbols = str;
        this.SendFeedRequest();
        this.isScripLoaded = true;
        this.MwhUpperCap.RemoveAllSymbolFromWatch();
        this.UCSymbols = Utilities.split((String)str, (char)';');
        for (int i = 0; i < this.UCSymbols.length; ++i) {
            if (this.UCSymbols[i].length() <= 0) continue;
            this.MwhUpperCap.AddSymbolInMarketWatch(this.UCSymbols[i].replace(':', ';'), false, false);
        }
        this.MwhUpperCap.SelectRow(0);
        this.mediator.setMarketData("MarketWatchAllScrip", str.replaceAll("\\|", ";"), "", null, this);
        Util.ScrollToFirstOrLastRow((boolean)true, (JTable)this.MwhUpperCap.GetTable(), (JScrollPane)this.MwhUpperCap.scrollPane);
        this.upperPanel.addCount(this.UCSymbols.length - 1 + "");
    }

    public void SetLowerCappedString(String str) {
        this.isShowHistoricalDataLowerCap = false;
        this.LowerCappedSymbols = str;
        this.SendFeedRequest();
        this.isScripLoaded = true;
        this.MwhLowerCap.RemoveAllSymbolFromWatch();
        this.LCSymbols = Utilities.split((String)str, (char)';');
        for (int i = 0; i < this.LCSymbols.length; ++i) {
            if (this.LCSymbols[i].length() <= 0) continue;
            this.MwhLowerCap.AddSymbolInMarketWatch(this.LCSymbols[i].replace(':', ';'), false, false);
        }
        this.MwhLowerCap.SelectRow(0);
        this.mediator.setMarketData("MarketWatchAllScrip", str.replaceAll("\\|", ";"), "", null, this);
        Util.ScrollToFirstOrLastRow((boolean)true, (JTable)this.MwhLowerCap.GetTable(), (JScrollPane)this.MwhLowerCap.scrollPane);
        this.lowerPanel.addCount(this.LCSymbols.length - 1 + "");
    }

    private void setCollaspe() {
        boolean state = this.collapsiblePane.isCollapsed();
        this.pnlHistoricalDataContainer.setPreferredSize(new Dimension(0, this.dividerSize));
        if (state) {
            this.btnDetail2.setIcon(new ImageIcon(this.getClass().getResource("/Images/uparrowgray.png")));
            this.addHistoricalData(this.lastMarket, this.lastScrip);
        } else {
            this.btnDetail2.setIcon(new ImageIcon(this.getClass().getResource("/Images/downarrowgray.png")));
        }
        this.collapsiblePane.setCollapsed(!state);
    }

    private void initComponents() {
        this.pnlTools2 = new JPanel();
        this.lblScripBrowse = new JLabel();
        this.lblSymbol2 = new JLabel();
        this.txtSymbol = new JTextField();
        this.lblSymbolName = new JLabel();
        this.jToolBar3 = new JToolBar();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.lblNew = new JLabel();
        this.btnScripDetail = new JButton();
        this.btnStatement = new JButton();
        this.btnQuarter = new JButton();
        this.btnRefresh = new JButton();
        this.btnDetail2 = new JButton();
        this.btnChange = new JToggleButton();
        this.collapsiblePane = new JXCollapsiblePane();
        this.pnlWatch = new JPanel();
        this.splitPanel = new JSplitPane();
        this.pnlTools2.setPreferredSize(new Dimension(470, 26));
        this.lblScripBrowse.setIcon(new ImageIcon(this.getClass().getResource("/Images/symDetail2.png")));
        this.lblScripBrowse.setText("Scrip Browse");
        this.lblScripBrowse.setMaximumSize(new Dimension(95, 16));
        this.lblScripBrowse.setMinimumSize(new Dimension(95, 16));
        this.lblScripBrowse.setPreferredSize(new Dimension(95, 16));
        this.lblSymbol2.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
        this.lblSymbol2.setText("Scrip");
        this.lblSymbol2.setHorizontalTextPosition(2);
        this.txtSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CapWatchHistorical.this.txtSymbolActionPerformed(evt);
            }
        });
        this.txtSymbol.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CapWatchHistorical.this.txtSymbolFocusGained(evt);
            }
        });
        this.lblSymbolName.setText("name");
        this.lblSymbolName.setMinimumSize(new Dimension(0, 14));
        this.jToolBar3.setFloatable(false);
        this.jToolBar3.setRollover(true);
        this.jToolBar3.setPreferredSize(new Dimension(67, 25));
        this.jToolBar3.add(this.filler1);
        this.lblNew.setIcon(new ImageIcon(this.getClass().getResource("/Images/new.gif")));
        this.lblNew.setMaximumSize(new Dimension(30, 21));
        this.lblNew.setMinimumSize(new Dimension(30, 21));
        this.lblNew.setPreferredSize(new Dimension(30, 21));
        this.jToolBar3.add(this.lblNew);
        this.btnScripDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")));
        this.btnScripDetail.setToolTipText("Scrip Details");
        this.btnScripDetail.setFocusable(false);
        this.btnScripDetail.setHorizontalTextPosition(0);
        this.btnScripDetail.setName("CapWatchHistorical -> btnScripDetail");
        this.btnScripDetail.setVerticalTextPosition(3);
        this.btnScripDetail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CapWatchHistorical.this.btnScripDetailActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.btnScripDetail);
        this.btnStatement.setIcon(new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")));
        this.btnStatement.setToolTipText("Annual Statements");
        this.btnStatement.setFocusable(false);
        this.btnStatement.setHorizontalTextPosition(0);
        this.btnStatement.setName("CapWatchHistorical -> btnStatement");
        this.btnStatement.setVerticalTextPosition(3);
        this.btnStatement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CapWatchHistorical.this.btnStatementActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.btnStatement);
        this.btnQuarter.setIcon(new ImageIcon(this.getClass().getResource("/Images/Annoucements16x16.png")));
        this.btnQuarter.setToolTipText("Quarterly Statements");
        this.btnQuarter.setFocusable(false);
        this.btnQuarter.setHorizontalTextPosition(0);
        this.btnQuarter.setName("CapWatchHistorical -> btnQuarter");
        this.btnQuarter.setVerticalTextPosition(3);
        this.btnQuarter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CapWatchHistorical.this.btnQuarterActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.btnQuarter);
        this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/Images/refresh.png")));
        this.btnRefresh.setName("CapWatchHistorical -> btnRefresh");
        this.jToolBar3.add(this.btnRefresh);
        this.btnDetail2.setIcon(new ImageIcon(this.getClass().getResource("/Images/uparrowgray.png")));
        this.btnDetail2.setText("Details");
        this.btnDetail2.setToolTipText("Details");
        this.btnDetail2.setFocusable(false);
        this.btnDetail2.setHorizontalTextPosition(4);
        this.btnDetail2.setMaximumSize(new Dimension(65, 23));
        this.btnDetail2.setMinimumSize(new Dimension(65, 23));
        this.btnDetail2.setName("CapWatchHistorical -> btnDetail2");
        this.btnDetail2.setPreferredSize(new Dimension(65, 23));
        this.btnDetail2.setVerticalTextPosition(3);
        this.btnDetail2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CapWatchHistorical.this.btnDetail2ActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.btnDetail2);
        this.btnChange.setIcon(new ImageIcon(this.getClass().getResource("/Images/switch16.png")));
        this.btnChange.setFocusable(false);
        this.btnChange.setHorizontalTextPosition(0);
        this.btnChange.setName("CapWatchHistorical -> btnChange");
        this.btnChange.setVerticalTextPosition(3);
        this.btnChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CapWatchHistorical.this.btnChangeActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.btnChange);
        GroupLayout pnlTools2Layout = new GroupLayout(this.pnlTools2);
        this.pnlTools2.setLayout(pnlTools2Layout);
        pnlTools2Layout.setHorizontalGroup(pnlTools2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlTools2Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.lblScripBrowse, -2, 95, -2).addGap(10, 10, 10).addComponent(this.lblSymbol2, -2, 50, -2).addGap(8, 8, 8).addComponent(this.txtSymbol, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblSymbolName, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jToolBar3, -2, 215, -2)));
        pnlTools2Layout.setVerticalGroup(pnlTools2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlTools2Layout.createSequentialGroup().addGap(2, 2, 2).addGroup(pnlTools2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblScripBrowse, -2, 22, -2).addComponent(this.lblSymbol2, -2, 22, -2).addGroup(pnlTools2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtSymbol, -2, 22, -2).addComponent(this.lblSymbolName, -2, 22, -2)).addComponent(this.jToolBar3, -2, 22, -2))));
        this.collapsiblePane.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.splitPanel.setOrientation(0);
        this.splitPanel.setContinuousLayout(true);
        GroupLayout pnlWatchLayout = new GroupLayout(this.pnlWatch);
        this.pnlWatch.setLayout(pnlWatchLayout);
        pnlWatchLayout.setHorizontalGroup(pnlWatchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splitPanel, GroupLayout.Alignment.TRAILING, -1, 613, Short.MAX_VALUE));
        pnlWatchLayout.setVerticalGroup(pnlWatchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splitPanel, GroupLayout.Alignment.TRAILING, -1, 298, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlTools2, -1, 613, Short.MAX_VALUE).addComponent((Component)this.collapsiblePane, -1, -1, Short.MAX_VALUE).addComponent(this.pnlWatch, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlTools2, -2, -1, -2).addGap(0, 0, 0).addComponent((Component)this.collapsiblePane, -2, -1, -2).addGap(0, 0, 0).addComponent(this.pnlWatch, -1, -1, Short.MAX_VALUE)));
    }

    private void txtSymbolActionPerformed(ActionEvent evt) {
        int InUpperORLowerORNotExist = this.SymbolExist();
        String symbol = this.txtSymbol.getText();
        String[] sm = null;
        if (symbol.indexOf("-") <= 1) {
            if (InUpperORLowerORNotExist == 1) {
                this.MwhUpperCap.AddSymbolInMarketWatch(symbol + ";REG", false, false);
            }
            if (InUpperORLowerORNotExist == 2) {
                this.MwhLowerCap.AddSymbolInMarketWatch(symbol + ";REG", false, false);
            }
            this.txtSymbol.select(0, this.txtSymbol.getText().length());
            return;
        }
        sm = this.txtSymbol.getText().split("-");
        if ("REG".equalsIgnoreCase(UtilKSE.GetMarketFromsymbol((String)symbol))) {
            if (InUpperORLowerORNotExist == 1) {
                this.MwhUpperCap.AddSymbolInMarketWatch(sm[0] + ";REG", false, false);
            }
            if (InUpperORLowerORNotExist == 2) {
                this.MwhUpperCap.AddSymbolInMarketWatch(sm[0] + ";REG", false, false);
            }
        } else {
            if (InUpperORLowerORNotExist == 1) {
                this.MwhUpperCap.AddSymbolInMarketWatch(sm[0] + ";" + UtilKSE.GetMarketFromsymbol((String)this.txtSymbol.getText()), false, false);
            }
            if (InUpperORLowerORNotExist == 2) {
                this.MwhLowerCap.AddSymbolInMarketWatch(sm[0] + ";" + UtilKSE.GetMarketFromsymbol((String)this.txtSymbol.getText()), false, false);
            }
        }
        this.txtSymbol.select(0, this.txtSymbol.getText().length());
    }

    private void txtSymbolFocusGained(FocusEvent evt) {
        this.txtSymbol.selectAll();
    }

    private void btnDetail2ActionPerformed(ActionEvent evt) {
        this.setCollaspe();
    }

    private void btnChangeActionPerformed(ActionEvent evt) {
        this.pnlHistoricalDataContainer.setLayout();
        this.dividerSize = this.btnChange.isSelected() ? 160 : 88;
        this.pnlHistoricalDataContainer.setPreferredSize(new Dimension(0, this.dividerSize));
    }

    private void btnStatementActionPerformed(ActionEvent evt) {
        TradeCast.getInstance().ShowDynamicForm(FormName.Statement, LanguageConstant.AnnualStatements);
    }

    private void btnQuarterActionPerformed(ActionEvent evt) {
        TradeCast.getInstance().ShowDynamicForm(FormName.QuarterStatement, LanguageConstant.QuarterlyStatements);
    }

    private void btnScripDetailActionPerformed(ActionEvent evt) {
        this.mediator.openScripDetails(LogsKSE.SelectedSymbol);
        LogCommon.NewCount += 2;
    }

    public synchronized void MarketWatchMessageReceived(MarketWatchEvent event) {
        this.mediator.MarketWatchMessageReceived(event, this);
    }

    private int SymbolExist() {
        int i;
        String symbol = this.txtSymbol.getText() + ":" + UtilKSE.GetMarketFromsymbol((String)this.txtSymbol.getText());
        for (i = 0; i < this.UCSymbols.length; ++i) {
            if (!this.UCSymbols[i].equalsIgnoreCase(symbol)) continue;
            return 1;
        }
        for (i = 0; i < this.LCSymbols.length; ++i) {
            if (!this.LCSymbols[i].equalsIgnoreCase(symbol)) continue;
            return 2;
        }
        return 0;
    }

    public void addHistoricalData(final String market, final String scrip) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Util.setMessage((JLabel)CapWatchHistorical.this.lblSymbolName, (MessageType)MessageType.Loading, (String)CapWatchHistorical.this.languageCentre.getValue(LanguageConstant.Loading));
                CapWatchHistorical.this.pnlHistoricalDataContainer.addHistoricalData(market, scrip);
                Util.setMessage((JLabel)CapWatchHistorical.this.lblSymbolName, (MessageType)MessageType.Normal, (String)CapWatchHistorical.this.mediator.getSymbolTitle(scrip));
            }
        });
    }

    public void setMarketData(String market, String scrip, MarketWatchBean b) {
        this.MwhUpperCap.setMarketData(market, scrip, b.period, b.marketcap, b.pricetoearning, b.dividendYield, b.pricetobook, b.eps, b.outstandingshares, b._52weekavgvol, b._52weekhigh, b._52weeklow);
        this.MwhLowerCap.setMarketData(market, scrip, b.period, b.marketcap, b.pricetoearning, b.dividendYield, b.pricetobook, b.eps, b.outstandingshares, b._52weekavgvol, b._52weekhigh, b._52weeklow);
    }

    public void SymbolRemove(String Symbol, String Market, MarketWatch Mwh) {
        Mwh.RemoveSymbolFromWatch(Symbol + ";" + Market);
    }

    public void SymbolRemove(String string, boolean b, MarketWatch mwh) {
        this.empty();
    }

    private void empty() {
        this.lblSymbolName.setText("");
        this.txtSymbol.setText("");
        this.pnlHistoricalDataContainer.empty();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnRefresh) {
            this.FirstLoad = true;
            this.GetUpperCapAndLowerCapSymbol();
        }
    }

    protected void GetUpperCapAndLowerCapSymbol() {
        if (this.FirstLoad) {
            this.FirstLoad = false;
            LoadLogs UPPERCAPPEDSYMBOLS = new LoadLogs("UPPERCAPPEDSYMBOLS=", true);
            new ThreadWithName(UPPERCAPPEDSYMBOLS, "UPPERCAPPEDSYMBOLS").start();
            LoadLogs LOWERCAPPEDSYMBOLS = new LoadLogs("LOWERCAPPEDSYMBOLS=", true);
            new ThreadWithName(LOWERCAPPEDSYMBOLS, "LOWERCAPPEDSYMBOLS").start();
        } else {
            this.SendFeedRequest();
        }
    }

    public void SendFeedRequest() {
        String str = "";
        if (this.mediator.MwPanel.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.CapWatch))) {
            this.mediator.SendMsgToFeedServer("MKT-FEED|" + this.UpperCappedSymbols + this.LowerCappedSymbols, " Cap Watch Historical : SendFeedRequest");
        }
    }

    public void SetSymbolUpperCap(String symbol, boolean isNew) {
        this.txtSymbol.setText(symbol);
        String market = UtilKSE.GetMarketFromsymbol((String)symbol);
        if (symbol.indexOf("-") >= 0) {
            symbol = symbol.split("\\-", -1)[0];
        }
        if (symbol.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(symbol.trim())) {
            this.lblSymbolName.setText("Invalid Scrip");
        } else {
            this.lblSymbolName.setText(this.mediator.getSymbolTitle(symbol));
        }
        this.lastMarket = market;
        this.lastScrip = symbol;
        if (this.isShowHistoricalDataUpperCap && !isNew && !this.collapsiblePane.isCollapsed()) {
            this.addHistoricalData(market, symbol);
        }
    }

    public void SetSymbolLowerCap(String symbol, boolean isNew) {
        this.txtSymbol.setText(symbol);
        String market = UtilKSE.GetMarketFromsymbol((String)symbol);
        if (symbol.indexOf("-") >= 0) {
            symbol = symbol.split("\\-", -1)[0];
        }
        if (symbol.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(symbol.trim())) {
            this.lblSymbolName.setText("Invalid Scrip");
        } else {
            this.lblSymbolName.setText(this.mediator.getSymbolTitle(symbol));
        }
        this.lastMarket = market;
        this.lastScrip = symbol;
        if (this.isShowHistoricalDataLowerCap && !isNew && !this.collapsiblePane.isCollapsed()) {
            this.addHistoricalData(market, symbol);
        }
    }

    public void SetEmpty(String symbol, boolean isNew) {
        this.txtSymbol.setText("");
        this.lblSymbolName.setText("");
        this.lastMarket = "";
        this.lastScrip = "";
        this.pnlHistoricalDataContainer.empty();
    }

    public void addHistoricalDataUpperCap() {
        this.isShowHistoricalDataUpperCap = true;
    }

    public void addHistoricalDataLowerCap() {
        this.isShowHistoricalDataLowerCap = true;
    }

    private void setLanguageValues() {
        this.lblScripBrowse.setText(this.languageCentre.getValue(LanguageConstant.ScripBrowse));
        this.lblSymbol2.setText(this.languageCentre.getValue(LanguageConstant.Scrip));
        this.btnScripDetail.setToolTipText(this.languageCentre.getValue(LanguageConstant.ScripDetail));
        this.btnStatement.setToolTipText(this.languageCentre.getValue(LanguageConstant.AnnualStatements));
        this.btnQuarter.setToolTipText(this.languageCentre.getValue(LanguageConstant.QuarterlyStatements));
        this.btnDetail2.setText(this.languageCentre.getValue(LanguageConstant.Details));
        this.btnDetail2.setToolTipText(this.languageCentre.getValue(LanguageConstant.Details));
    }
}

