/*
 * Decompiled with CFR 0.152.
 */
package Watches;

import CATALYST.Control.ColumnData;
import CATALYST.Control.MarketWatch;
import CATALYST.Control.MarketWatchEvent;
import CATALYST.Control.MarketWatchListner;
import MyDocking.Mediator;
import common.gui.component.JTextFieldFilter;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.Document;
import kse.util.UtilKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class IndexWatch
extends JPanel
implements MarketWatchListner,
ActionListener {
    public MarketWatch Mwh;
    private JTextField txtSymbol;
    private JLabel lblSymbol;
    private JComboBox cbIndices;
    private JLabel lblIndex;
    public JPopupMenu popup = new JPopupMenu();
    public static String ltPrice = "";
    public static String sys = "";
    private Mediator mediator = Mediator.getInstance();
    private String LastIndex = "";
    JLabel lblSymbolName = new JLabel();
    private boolean isUpdateCurrentDayPrice = true;
    private HashMap<String, Integer> columnIndex = new HashMap();
    private LanguageCentre languageCentre = new LanguageCentre();

    private void setColumnIndex() {
        int index = 0;
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Market), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Scrip), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.LowerLock), index++);
        this.columnIndex.put(this.languageCentre.getValue("BuyVol"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Buy), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Sell), index++);
        this.columnIndex.put(this.languageCentre.getValue("SellVol"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.UpperCap), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.LastPrice), index++);
        this.columnIndex.put(this.languageCentre.getValue("Change"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.PercentChange), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Trade), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.CompanySnapshot), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Analytics), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Graph), index++);
        this.columnIndex.put(this.languageCentre.getValue("Dir"), index++);
        this.columnIndex.put(this.languageCentre.getValue("LTrdTime"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.TotalVolume), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Low), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Average), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.High), index++);
        this.columnIndex.put(this.languageCentre.getValue("TotalTrd"), index++);
        this.columnIndex.put(this.languageCentre.getValue("LTrdVolume"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.ClosePrice), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.OpenPrice), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.State), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Flag), index++);
        this.columnIndex.put(this.languageCentre.getValue("FreeFloat"), index++);
        this.columnIndex.put(this.languageCentre.getValue("LP/CP/LDCP"), index++);
        this.columnIndex.put(this.languageCentre.getValue("CurrentMarketCapital"), index++);
        this.columnIndex.put(this.languageCentre.getValue("CurrentDayPoint"), index++);
        this.columnIndex.put(this.languageCentre.getValue("LastDayPoint"), index++);
        this.columnIndex.put(this.languageCentre.getValue("PointChange"), index++);
    }

    public IndexWatch() {
        this.setColumnIndex();
        this.Mwh = new MarketWatch(LanguageConstant.IndexWatch, this.columnIndex);
        this.mediator.setIndexWatch(this);
        ColumnData[] m_columns = new ColumnData[]{new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Market), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Scrip), 100, 2), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.LowerLock), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("BuyVol"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Buy), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Sell), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("SellVol"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.UpperCap), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.LastPrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("Change"), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.PercentChange), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("Dir"), 40, 0), new ColumnData(this.Mwh, this.languageCentre.getValue("LTrdTime"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.TotalVolume), 100, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Low), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Average), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.High), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("TotalTrd"), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("LTrdVolume"), 100, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.ClosePrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.OpenPrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.State), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Flag), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Trade), 80, 0), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.CompanySnapshot), 150, 0), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Analytics), 100, 0), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Graph), 100, 0), new ColumnData(this.Mwh, this.languageCentre.getValue("FreeFloat"), 110, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("LP/CP/LDCP"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("CurrentMarketCapital"), 120, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("CurrentDayPoint"), 110, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("LastDayPoint"), 100, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("PointChange"), 100, 4)};
        this.Mwh.isHistoricalDataWatch = false;
        this.Mwh.ChangeAllColorAndFonts(MyColors.MarketWatchRowColor, MyColors.MarketWatchSelectedRowColor, MyColors.MarketWatchIncreaseColor, MyColors.MarketWatchDecreaseColor, LogCommon.MarketWatchFont);
        this.Mwh.SetHeight = new JFrame().getToolkit().getScreenSize().height - 500;
        this.Mwh.SetWidth = new JFrame().getToolkit().getScreenSize().width + 130;
        this.Mwh.setMarket(LogCommon.markets);
        this.Mwh.Debug = true;
        this.Mwh.addListener((MarketWatchListner)this);
        this.Mwh.isUserAddScrip = false;
        this.Mwh.ShowTradeButton = AppConfig.ShowTradeButton;
        this.Mwh.ShowCompanySnapButton = AppConfig.ShowCompanySnapshotButton;
        this.Mwh.ShowGraphButton = AppConfig.ShowGraphButton;
        this.Mwh.ShowAnalyticsButton = AppConfig.ShowAnalyticsButton;
        this.Mwh.isStandardCapital = AppConfig.isStandardCapital;
        this.Mwh.init(m_columns);
        this.Mwh.m_table.moveColumn(this.Mwh.m_table.getColumnModel().getColumnIndex(this.languageCentre.getValue(LanguageConstant.Trade)), 9);
        if (this.Mwh.m_table.isColumnExist(this.languageCentre.getValue(LanguageConstant.CompanySnapshot))) {
            this.Mwh.m_table.moveColumn(this.Mwh.m_table.getColumnModel().getColumnIndex(this.languageCentre.getValue(LanguageConstant.CompanySnapshot)), 10);
        }
        if (this.Mwh.m_table.isColumnExist(this.languageCentre.getValue(LanguageConstant.Analytics))) {
            this.Mwh.m_table.moveColumn(this.Mwh.m_table.getColumnModel().getColumnIndex(this.languageCentre.getValue(LanguageConstant.Analytics)), 11);
        }
        if (this.Mwh.m_table.isColumnExist(this.languageCentre.getValue(LanguageConstant.Graph))) {
            this.Mwh.m_table.moveColumn(this.Mwh.m_table.getColumnModel().getColumnIndex(this.languageCentre.getValue(LanguageConstant.Graph)), 12);
        }
        this.lblSymbol = new JLabel();
        this.lblSymbol.setText(this.languageCentre.getValue(LanguageConstant.Scrip) + " ");
        this.lblSymbol.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
        this.lblSymbol.setHorizontalTextPosition(2);
        this.lblIndex = new JLabel();
        this.lblIndex.setText(this.languageCentre.getValue(LanguageConstant.SelectIndex));
        this.lblIndex.setFont(this.lblIndex.getFont().deriveFont(1));
        this.cbIndices = new JComboBox();
        this.txtSymbol = new JTextField();
        this.txtSymbol.setPreferredSize(new Dimension(50, 20));
        this.txtSymbol.setMinimumSize(new Dimension(50, 20));
        this.txtSymbol.setMaximumSize(new Dimension(50, 20));
        this.txtSymbol.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                IndexWatch.this.txtSymbol.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.txtSymbol.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-"));
        this.cbIndices.addActionListener(this);
        this.cbIndices.setModel(new DefaultComboBoxModel<String>("100 INDEX|30 INDEX|KMI 30|OGTi|BKTi|KMI ALL SHR|UPP9|NITPGI|NBPPGI|MZNPI".split("\\|", -1)));
        this.lblSymbolName.setFont(this.lblSymbolName.getFont().deriveFont(1));
        this.lblSymbolName.setPreferredSize(new Dimension(0, 20));
        this.lblSymbolName.setMaximumSize(new Dimension(1000, 20));
        this.lblSymbolName.setMinimumSize(new Dimension(0, 20));
        JPanel p1 = new JPanel();
        p1.setMaximumSize(new Dimension(Short.MAX_VALUE, 27));
        p1.setMinimumSize(new Dimension(0, 27));
        p1.setPreferredSize(new Dimension(473, 27));
        GroupLayout layout = new GroupLayout(p1);
        p1.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblIndex, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbIndices, -2, 114, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblSymbol, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtSymbol, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblSymbolName, -1, 135, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblSymbol, -2, 22, -2).addComponent(this.txtSymbol, -2, 22, -2).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSymbolName, -2, 22, -2).addComponent(this.cbIndices, -2, -1, -2).addComponent(this.lblIndex, -2, 22, -2))).addGap(3, 3, 3)));
        JPanel p2 = new JPanel(false);
        p2.setLayout(new GridLayout(1, 1));
        p2.add((Component)this.Mwh, "Center");
        this.setLayout(new BoxLayout(this, 1));
        this.add(p1);
        this.add(p2);
        this.setAlignmentX(0.0f);
        this.txtSymbol.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && IndexWatch.this.SymbolExist()) {
                    String symbol = IndexWatch.this.txtSymbol.getText();
                    String[] sm = null;
                    if (symbol.indexOf("-") <= 1) {
                        IndexWatch.this.Mwh.AddSymbolInMarketWatch(symbol + ";REG", false, false);
                        IndexWatch.this.txtSymbol.select(0, IndexWatch.this.txtSymbol.getText().length());
                        return;
                    }
                    sm = IndexWatch.this.txtSymbol.getText().split("-");
                    if ("REG".equalsIgnoreCase(UtilKSE.GetMarketFromsymbol((String)symbol))) {
                        IndexWatch.this.Mwh.AddSymbolInMarketWatch(sm[0] + ";REG", false, false);
                    } else {
                        IndexWatch.this.Mwh.AddSymbolInMarketWatch(sm[0] + ";" + UtilKSE.GetMarketFromsymbol((String)IndexWatch.this.txtSymbol.getText()), false, false);
                    }
                    IndexWatch.this.txtSymbol.select(0, IndexWatch.this.txtSymbol.getText().length());
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    private boolean SymbolExist() {
        ArrayList Arr;
        String INDEX;
        return this.cbIndices.getSelectedItem() != null && LogCommon.SectorAndIndicesSymbol.containsKey(INDEX = (String)LogCommon.IndicesName.get(this.cbIndices.getSelectedItem() + "")) && (Arr = (ArrayList)LogCommon.SectorAndIndicesSymbol.get(INDEX)).contains(this.txtSymbol.getText());
    }

    public synchronized void MarketWatchMessageReceived(MarketWatchEvent event) {
        this.mediator.MarketWatchMessageReceived(event, null);
    }

    void SetIndexInCombo(ArrayList SectorName) {
    }

    private void MarketWatchKeyEvent(KeyEvent e) {
    }

    public void SetSymbol(String symbol) {
        this.txtSymbol.setText(symbol);
        String market = UtilKSE.GetMarketFromsymbol((String)symbol);
        if (symbol.indexOf("-") >= 0) {
            symbol = symbol.split("\\-", -1)[0];
        }
        if (symbol.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(symbol.trim())) {
            this.lblSymbolName.setText(this.languageCentre.getValue(LanguageConstant.InvalidScrip));
        } else {
            this.lblSymbolName.setText(this.mediator.getSymbolTitle(symbol));
        }
    }

    public void SetEmpty(String symbol) {
        this.txtSymbol.setText("");
        this.lblSymbolName.setText("");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                IndexWatch.this.addAndsendIndexFeedRequest();
            }
        }, "Index Watch: index changed").start();
    }

    public void sendIndexFeedRequest() {
        if (this.cbIndices.getSelectedItem() != null) {
            if (this.Mwh.GetTable().getRowCount() <= 0) {
                this.addAndsendIndexFeedRequest();
            } else {
                String INDEX = (String)LogCommon.IndicesName.get(this.cbIndices.getSelectedItem().toString());
                this.mediator.SendMsgToFeedServer("MKT-FEED|SECTOR:" + INDEX, "Index Watch (" + INDEX + "): SendFeedRequest");
            }
        }
    }

    private void addAndsendIndexFeedRequest() {
        if (this.cbIndices.getSelectedItem() != null) {
            String INDEX = (String)LogCommon.IndicesName.get(this.cbIndices.getSelectedItem().toString());
            this.Mwh.RemoveAllSymbolFromWatch();
            this.mediator.SendMsgToFeedServer("MKT-FEED|SECTOR:" + INDEX, "Index Watch (" + INDEX + "): SendFeedRequest");
            if (LogCommon.SectorAndIndicesSymbol.containsKey(INDEX)) {
                StringBuilder sb = new StringBuilder();
                StringBuilder sb2 = new StringBuilder();
                ArrayList Arr = (ArrayList)LogCommon.SectorAndIndicesSymbol.get(INDEX);
                for (int i = 0; i < Arr.size(); ++i) {
                    if (Arr.get(i).toString().trim().length() <= 0) continue;
                    sb.append(Arr.get(i).toString().trim()).append(":REG;");
                    sb2.append(Arr.get(i).toString().trim()).append(";REG|");
                }
                this.Mwh.AddSymbolInMarketWatch(sb2.toString(), false, false);
                this.Mwh.SelectRow(0);
                Util.ScrollToFirstOrLastRow((boolean)true, (JTable)this.Mwh.GetTable(), (JScrollPane)this.Mwh.scrollPane);
            }
            this.isUpdateCurrentDayPrice = true;
            this.LastIndex = INDEX;
        }
    }

    private String getSeletectedIndex() {
        if (this.cbIndices.getSelectedItem() == null) {
            return "";
        }
        return this.cbIndices.getSelectedItem() + "";
    }

    private void updateCurrentDayPoint() {
        this.Mwh.m_table.getRowCount();
        for (int i = 0; i < this.Mwh.m_table.getRowCount(); ++i) {
            String symbol = this.Mwh.m_table.getValueAt(i, 1) + "";
            if (symbol.trim().length() <= 0) continue;
            this.Mwh.updateCurrentDayPoint(symbol, "REG");
        }
        this.Mwh.m_table.refresh();
    }

    public void NotifyMKTFeedRecieved(String string) {
        this.Mwh.NotifyMKTFeedRecieved(this.getSeletectedIndex(), string);
        if (this.isUpdateCurrentDayPrice) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    IndexWatch.this.isUpdateCurrentDayPrice = false;
                    IndexWatch.this.updateCurrentDayPoint();
                }
            }).start();
        }
    }
}

