/*
 * Decompiled with CFR 0.152.
 */
package Watches;

import Beans.MarketWatchBean;
import CATALYST.Control.MarketFeed;
import CATALYST.Control.MarketWatch;
import CATALYST.Control.MarketWatchEvent;
import CATALYST.Control.Utilities;
import MyDocking.Mediator;
import Utilities.LogsTC;
import Watches.CapWatch;
import Watches.CapWatchHistorical;
import Watches.FutureWatch;
import Watches.FutureWatchHistorical;
import Watches.IndexWatch;
import Watches.IndexWatchHistorical;
import Watches.MyMarketWatch;
import Watches.MyMarketWatchHistorical;
import Watches.PortfolioWatch;
import Watches.PortfolioWatchAdv;
import Watches.PortfolioWatchHistorical;
import Watches.SectorWatch;
import Watches.SectorWatchHistorical;
import Watches.ShariaWatch;
import Watches.ShariaWatchHistorical;
import Watches.SpotWatch;
import Watches.SpotWatchHistorical;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.MyColors;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kse.util.LogsKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class MarketWatchPanel
extends JPanel
implements ActionListener {
    Mediator mediator = Mediator.getInstance();
    public MyMarketWatch MyMarketWatch1 = null;
    public MyMarketWatch MyMarketWatch2 = null;
    public MyMarketWatch MyMarketWatch3 = null;
    public MyMarketWatchHistorical MyMarketWatchHistorical1 = null;
    public MyMarketWatchHistorical MyMarketWatchHistorical2 = null;
    public MyMarketWatchHistorical MyMarketWatchHistorical3 = null;
    public SectorWatch MySectorWatch = null;
    public SectorWatchHistorical MySectorWatchHistorical = null;
    public IndexWatch MyINDEXWatch = null;
    public IndexWatchHistorical MyINDEXWatchHistorical = null;
    private PortfolioWatch MyPortfolioWatch = null;
    public PortfolioWatchAdv MyPortfolioWatchAdv = null;
    public PortfolioWatchHistorical MyPortfolioWatchHistorical = null;
    public CapWatch MyCapWatch = null;
    public CapWatchHistorical MyCapWatchHistorical = null;
    public SpotWatch MySpotWatch = null;
    public SpotWatchHistorical MySpotWatchHistorical = null;
    public ShariaWatch MyShariaWatch = null;
    public ShariaWatchHistorical MyShariaWatchHistorical = null;
    public FutureWatch MyFutureWatch = null;
    public FutureWatchHistorical MyFutureWatchHistorical = null;
    private JPanel Panel_1;
    private JPanel Panel_2;
    private JPanel Panel_3;
    private JPanel Panel_4;
    private JPanel Panel_5;
    private JPanel Panel_6;
    private JPanel Panel_7;
    private JPanel Panel_8;
    private JPanel Panel_9;
    private JPanel Panel_Sharia;
    private JScrollPane ScrollPane_1;
    private JScrollPane ScrollPane_2;
    private JScrollPane ScrollPane_3;
    private JScrollPane ScrollPane_4;
    private JScrollPane ScrollPane_5;
    private JScrollPane ScrollPane_7;
    private JScrollPane ScrollPane_8;
    private JScrollPane ScrollPane_9;
    private JScrollPane ScrollPane_Sharia;
    private JTabbedPane tabbedPane = null;
    private LanguageCentre languageCentre = new LanguageCentre();
    public static final String _Spot = "Spot Watch";
    public String tabName = this.languageCentre.getValue(LanguageConstant._1stProfile);
    public JPopupMenu popup = new JPopupMenu();

    public MarketWatchPanel() {
        this.mediator.setMarketWatchPanel(this);
        this.init();
    }

    public MarketFeed GetSingleFeed(String Symbol, String Market) {
        MarketFeed MktFeed = null;
        String Key2 = Symbol + ";" + Market;
        if (AppConfig.isHistoricalDataWatch) {
            return this.GetSingleFeedHistorical(Symbol, Market);
        }
        if (this.MyMarketWatch1.Mwh.liveMarket.containsKey(Key2)) {
            MktFeed = (MarketFeed)this.MyMarketWatch1.Mwh.liveMarket.get(Key2);
        } else if (this.MyMarketWatch2.Mwh.liveMarket.containsKey(Key2)) {
            MktFeed = (MarketFeed)this.MyMarketWatch2.Mwh.liveMarket.get(Key2);
        } else if (this.MyMarketWatch3.Mwh.liveMarket.containsKey(Key2)) {
            MktFeed = (MarketFeed)this.MyMarketWatch3.Mwh.liveMarket.get(Key2);
        } else if (this.MySectorWatch.Mwh.liveMarket.containsKey(Key2)) {
            MktFeed = (MarketFeed)this.MySectorWatch.Mwh.liveMarket.get(Key2);
        } else if (this.MyINDEXWatch.Mwh.liveMarket.containsKey(Key2)) {
            MktFeed = (MarketFeed)this.MyINDEXWatch.Mwh.liveMarket.get(Key2);
        } else if (AppConfig.isPortfolioAdv && this.MyPortfolioWatchAdv != null && this.MyPortfolioWatchAdv.Mwh.liveMarket.containsKey(Key2)) {
            MktFeed = (MarketFeed)this.MyPortfolioWatchAdv.Mwh.liveMarket.get(Key2);
        } else if (!AppConfig.isPortfolioAdv && this.MyPortfolioWatch != null && this.MyPortfolioWatch.Mwh.liveMarket.containsKey(Key2)) {
            MktFeed = (MarketFeed)this.MyPortfolioWatch.Mwh.liveMarket.get(Key2);
        } else if (AppConfig.isHistoricalDataWatch && this.MyPortfolioWatchHistorical != null && this.MyPortfolioWatchHistorical.Mwh.liveMarket.containsKey(Key2)) {
            MktFeed = (MarketFeed)this.MyPortfolioWatchHistorical.Mwh.liveMarket.get(Key2);
        } else if (!AppConfig.isHistoricalDataWatch && this.MyPortfolioWatch != null && this.MyPortfolioWatch.Mwh.liveMarket.containsKey(Key2)) {
            MktFeed = (MarketFeed)this.MyPortfolioWatch.Mwh.liveMarket.get(Key2);
        }
        return MktFeed;
    }

    private MarketFeed GetSingleFeedHistorical(String Symbol, String Market) {
        MarketFeed MktFeed = null;
        String Key2 = Symbol + ";" + Market;
        if (this.MyMarketWatchHistorical1.marketWatch.liveMarket.containsKey(Key2)) {
            MktFeed = (MarketFeed)this.MyMarketWatchHistorical1.marketWatch.liveMarket.get(Key2);
        } else if (this.MyMarketWatchHistorical2.marketWatch.liveMarket.containsKey(Key2)) {
            MktFeed = (MarketFeed)this.MyMarketWatchHistorical2.marketWatch.liveMarket.get(Key2);
        } else if (this.MyMarketWatchHistorical3.marketWatch.liveMarket.containsKey(Key2)) {
            MktFeed = (MarketFeed)this.MyMarketWatchHistorical3.marketWatch.liveMarket.get(Key2);
        } else if (this.MySectorWatchHistorical.Mwh.liveMarket.containsKey(Key2)) {
            MktFeed = (MarketFeed)this.MySectorWatchHistorical.Mwh.liveMarket.get(Key2);
        } else if (this.MyINDEXWatchHistorical.Mwh.liveMarket.containsKey(Key2)) {
            MktFeed = (MarketFeed)this.MyINDEXWatchHistorical.Mwh.liveMarket.get(Key2);
        } else if (AppConfig.isPortfolioAdv && this.MyPortfolioWatchAdv != null && this.MyPortfolioWatchAdv.Mwh.liveMarket.containsKey(Key2)) {
            MktFeed = (MarketFeed)this.MyPortfolioWatchAdv.Mwh.liveMarket.get(Key2);
        } else if (!AppConfig.isPortfolioAdv && this.MyPortfolioWatch != null && this.MyPortfolioWatch.Mwh.liveMarket.containsKey(Key2)) {
            MktFeed = (MarketFeed)this.MyPortfolioWatch.Mwh.liveMarket.get(Key2);
        } else if (AppConfig.isHistoricalDataWatch && this.MyPortfolioWatchHistorical != null && this.MyPortfolioWatchHistorical.Mwh.liveMarket.containsKey(Key2)) {
            MktFeed = (MarketFeed)this.MyPortfolioWatchHistorical.Mwh.liveMarket.get(Key2);
        } else if (!AppConfig.isHistoricalDataWatch && this.MyPortfolioWatch != null && this.MyPortfolioWatch.Mwh.liveMarket.containsKey(Key2)) {
            MktFeed = (MarketFeed)this.MyPortfolioWatch.Mwh.liveMarket.get(Key2);
        }
        return MktFeed;
    }

    public MarketFeed GetSingleFeedAdv(String Symbol, String Market) {
        MarketFeed MktFeed = null;
        String Key2 = Symbol + ";" + Market;
        if (AppConfig.isPortfolioAdv && this.MyPortfolioWatchAdv != null && this.MyPortfolioWatchAdv.Mwh.liveMarket.containsKey(Key2)) {
            MktFeed = (MarketFeed)this.MyPortfolioWatchAdv.Mwh.liveMarket.get(Key2);
        } else if (AppConfig.isHistoricalDataWatch && this.MyPortfolioWatchHistorical != null && this.MyPortfolioWatchHistorical.Mwh.liveMarket.containsKey(Key2)) {
            MktFeed = (MarketFeed)this.MyPortfolioWatchHistorical.Mwh.liveMarket.get(Key2);
        }
        return MktFeed;
    }

    public void SymbolEmpty(MarketWatchEvent event) {
        if (AppConfig.isHistoricalDataWatch) {
            if (event.getSource() == this.MyMarketWatchHistorical1.marketWatch) {
                this.MyMarketWatchHistorical1.SetEmpty(event.getmessage(), false);
            } else if (event.getSource() == this.MyMarketWatchHistorical2.marketWatch) {
                this.MyMarketWatchHistorical2.SetEmpty(event.getmessage(), false);
            } else if (event.getSource() == this.MyMarketWatchHistorical3.marketWatch) {
                this.MyMarketWatchHistorical3.SetEmpty(event.getmessage(), false);
            } else if (event.getSource() == this.MyShariaWatchHistorical.Mwh) {
                this.MyShariaWatchHistorical.SetEmpty(event.getmessage(), false);
            } else if (event.getSource() == this.MyINDEXWatchHistorical.Mwh) {
                this.MyINDEXWatchHistorical.SetEmpty(event.getmessage(), false);
            } else if (event.getSource() == this.MySectorWatchHistorical.Mwh) {
                this.MySectorWatchHistorical.SetEmpty(event.getmessage(), false);
            } else if (event.getSource() == this.MyFutureWatchHistorical.Mwh) {
                this.MyFutureWatchHistorical.SetEmpty(event.getmessage(), false);
            } else if (event.getSource() == this.MyCapWatchHistorical.MwhUpperCap || event.getSource() == this.MyCapWatchHistorical.MwhLowerCap) {
                this.MyCapWatchHistorical.SetEmpty(event.getmessage(), false);
            } else if (event.getSource() == this.MyPortfolioWatchHistorical.Mwh) {
                this.MyPortfolioWatchHistorical.SetEmpty(event.getmessage(), false);
            }
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant._1stProfile)) && event.getSource() == this.MyMarketWatch1.Mwh) {
            this.MyMarketWatch1.SetEmpty(event.getmessage());
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant._2ndProfile)) && event.getSource() == this.MyMarketWatch2.Mwh) {
            this.MyMarketWatch2.SetEmpty(event.getmessage());
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant._3rdProfile)) && event.getSource() == this.MyMarketWatch3.Mwh) {
            this.MyMarketWatch3.SetEmpty(event.getmessage());
        } else if (this.getSelectedTab().equalsIgnoreCase(_Spot) && event.getSource() == this.MySpotWatch.Mwh) {
            this.MySpotWatch.SetEmpty(event.getmessage());
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.ShariahWatch)) && event.getSource() == this.MyShariaWatch.Mwh) {
            this.MyShariaWatch.SetEmpty(event.getmessage());
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.IndexWatch)) && event.getSource() == this.MyINDEXWatch.Mwh) {
            this.MyINDEXWatch.SetEmpty(event.getmessage());
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.SectorWatch)) && event.getSource() == this.MySectorWatch.Mwh) {
            this.MySectorWatch.SetEmpty(event.getmessage());
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.FutureWatch)) && event.getSource() == this.MyFutureWatch.Mwh) {
            this.MyFutureWatch.SetEmpty(event.getmessage());
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.FutureWatch)) && event.getSource() == this.MyFutureWatch.MwhSpread) {
            this.MyFutureWatch.SetEmpty(event.getmessage());
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.CapWatch)) && (event.getSource() == this.MyCapWatch.MwhUpperCap || event.getSource() == this.MyCapWatch.MwhLowerCap)) {
            this.MyCapWatch.SetEmpty(event.getmessage());
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.PortfolioWatch)) && this.MyPortfolioWatch != null && event.getSource() == this.MyPortfolioWatch.Mwh) {
            this.MyPortfolioWatch.SetEmpty(event.getmessage());
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.PortfolioWatch)) && this.MyPortfolioWatchAdv != null && event.getSource() == this.MyPortfolioWatchAdv.Mwh && !LogsKSE.SelectedSymbol.equalsIgnoreCase("")) {
            this.MyPortfolioWatchAdv.SetEmpty(event.getmessage());
        }
    }

    public void setSymbolChange(MarketWatchEvent event, String scrip) {
        if (AppConfig.isHistoricalDataWatch) {
            if (event.getSource() == this.MyMarketWatchHistorical1.marketWatch) {
                MarketWatchBean marketBean = LogsTC.MarketData.get(scrip);
                this.MyMarketWatchHistorical1.setMarketData(marketBean.market, marketBean.scrip, marketBean);
            } else if (event.getSource() == this.MyMarketWatchHistorical2.marketWatch) {
                MarketWatchBean marketBean = LogsTC.MarketData.get(scrip);
                this.MyMarketWatchHistorical2.setMarketData(marketBean.market, marketBean.scrip, marketBean);
            } else if (event.getSource() == this.MyMarketWatchHistorical3.marketWatch) {
                MarketWatchBean marketBean = LogsTC.MarketData.get(scrip);
                this.MyMarketWatchHistorical3.setMarketData(marketBean.market, marketBean.scrip, marketBean);
            } else if (event.getSource() == this.MyShariaWatchHistorical.Mwh) {
                MarketWatchBean marketBean = LogsTC.MarketData.get(scrip);
                this.MyShariaWatchHistorical.setMarketData(marketBean.market, marketBean.scrip, marketBean);
            } else if (event.getSource() == this.MyINDEXWatchHistorical.Mwh) {
                MarketWatchBean marketBean = LogsTC.MarketData.get(scrip);
                this.MyINDEXWatchHistorical.setMarketData(marketBean.market, marketBean.scrip, marketBean);
            } else if (event.getSource() == this.MySectorWatchHistorical.Mwh) {
                MarketWatchBean marketBean = LogsTC.MarketData.get(scrip);
                this.MySectorWatchHistorical.setMarketData(marketBean.market, marketBean.scrip, marketBean);
            } else if (event.getSource() == this.MyFutureWatchHistorical.Mwh) {
                MarketWatchBean marketBean = LogsTC.MarketData.get(scrip);
                this.MyFutureWatchHistorical.setMarketData(marketBean.market, marketBean.scrip, marketBean);
            } else if (event.getSource() == this.MyCapWatchHistorical.MwhUpperCap) {
                MarketWatchBean marketBean = LogsTC.MarketData.get(scrip);
                this.MyCapWatchHistorical.setMarketData(marketBean.market, marketBean.scrip, marketBean);
            } else if (event.getSource() == this.MyCapWatchHistorical.MwhLowerCap) {
                MarketWatchBean marketBean = LogsTC.MarketData.get(scrip);
                this.MyCapWatchHistorical.setMarketData(marketBean.market, marketBean.scrip, marketBean);
            } else if (event.getSource() == this.MyPortfolioWatchHistorical.Mwh) {
                MarketWatchBean marketBean = LogsTC.MarketData.get(scrip);
                this.MyPortfolioWatchHistorical.setMarketData(marketBean.market, marketBean.scrip, marketBean);
            }
        }
    }

    public void SymbolChange(MarketWatchEvent event) {
        if (AppConfig.isHistoricalDataWatch) {
            if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant._1stProfile)) && event.getSource() == this.MyMarketWatchHistorical1.marketWatch) {
                LogsKSE.SelectedSymbol = Utilities.split((String)event.getmessage(), (char)':')[0];
                LogsKSE.SelectedMarket = Utilities.split((String)event.getmessage(), (char)':')[1];
                this.MyMarketWatchHistorical1.SetSymbol(Utilities.split((String)event.getmessage(), (char)':')[0], false);
            } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant._2ndProfile)) && event.getSource() == this.MyMarketWatchHistorical2.marketWatch) {
                LogsKSE.SelectedSymbol = Utilities.split((String)event.getmessage(), (char)':')[0];
                LogsKSE.SelectedMarket = Utilities.split((String)event.getmessage(), (char)':')[1];
                this.MyMarketWatchHistorical2.SetSymbol(Utilities.split((String)event.getmessage(), (char)':')[0], false);
            } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant._3rdProfile)) && event.getSource() == this.MyMarketWatchHistorical3.marketWatch) {
                LogsKSE.SelectedSymbol = Utilities.split((String)event.getmessage(), (char)':')[0];
                LogsKSE.SelectedMarket = Utilities.split((String)event.getmessage(), (char)':')[1];
                this.MyMarketWatchHistorical3.SetSymbol(Utilities.split((String)event.getmessage(), (char)':')[0], false);
            } else if (this.getSelectedTab().equalsIgnoreCase(_Spot) && event.getSource() == this.MySpotWatchHistorical.Mwh && AppConfig.isSpotWatch) {
                LogsKSE.SelectedSymbol = Utilities.split((String)event.getmessage(), (char)':')[0];
                LogsKSE.SelectedMarket = Utilities.split((String)event.getmessage(), (char)':')[1];
                this.MySpotWatchHistorical.SetSymbol(Utilities.split((String)event.getmessage(), (char)':')[0], false);
            } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.ShariahWatch)) && event.getSource() == this.MyShariaWatchHistorical.Mwh) {
                LogsKSE.SelectedSymbol = Utilities.split((String)event.getmessage(), (char)':')[0];
                LogsKSE.SelectedMarket = Utilities.split((String)event.getmessage(), (char)':')[1];
                this.MyShariaWatchHistorical.SetSymbol(Utilities.split((String)event.getmessage(), (char)':')[0], false);
            } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.IndexWatch)) && event.getSource() == this.MyINDEXWatchHistorical.Mwh) {
                LogsKSE.SelectedSymbol = Utilities.split((String)event.getmessage(), (char)':')[0];
                LogsKSE.SelectedMarket = Utilities.split((String)event.getmessage(), (char)':')[1];
                this.MyINDEXWatchHistorical.SetSymbol(Utilities.split((String)event.getmessage(), (char)':')[0], false);
            } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.SectorWatch)) && event.getSource() == this.MySectorWatchHistorical.Mwh) {
                LogsKSE.SelectedSymbol = Utilities.split((String)event.getmessage(), (char)':')[0];
                LogsKSE.SelectedMarket = Utilities.split((String)event.getmessage(), (char)':')[1];
                this.MySectorWatchHistorical.SetSymbol(Utilities.split((String)event.getmessage(), (char)':')[0], false);
            } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.FutureWatch)) && event.getSource() == this.MyFutureWatchHistorical.Mwh) {
                LogsKSE.SelectedSymbol = Utilities.split((String)event.getmessage(), (char)':')[0];
                LogsKSE.SelectedMarket = Utilities.split((String)event.getmessage(), (char)':')[1];
                this.MyFutureWatchHistorical.SetSymbol(Utilities.split((String)event.getmessage(), (char)':')[0], false);
            } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.FutureWatch)) && event.getSource() == this.MyFutureWatchHistorical.MwhSpread) {
                LogsKSE.SelectedSymbol = Utilities.split((String)event.getmessage(), (char)':')[0];
                LogsKSE.SelectedMarket = Utilities.split((String)event.getmessage(), (char)':')[1];
                this.MyFutureWatchHistorical.SetSymbol(Utilities.split((String)event.getmessage(), (char)':')[0], false);
            } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.CapWatch)) && event.getSource() == this.MyCapWatchHistorical.MwhUpperCap) {
                LogsKSE.SelectedSymbol = Utilities.split((String)event.getmessage(), (char)':')[0];
                LogsKSE.SelectedMarket = Utilities.split((String)event.getmessage(), (char)':')[1];
                this.MyCapWatchHistorical.SetSymbolUpperCap(Utilities.split((String)event.getmessage(), (char)':')[0], false);
            } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.CapWatch)) && event.getSource() == this.MyCapWatchHistorical.MwhLowerCap) {
                LogsKSE.SelectedSymbol = Utilities.split((String)event.getmessage(), (char)':')[0];
                LogsKSE.SelectedMarket = Utilities.split((String)event.getmessage(), (char)':')[1];
                this.MyCapWatchHistorical.SetSymbolLowerCap(Utilities.split((String)event.getmessage(), (char)':')[0], false);
            } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.PortfolioWatch)) && event.getSource() == this.MyPortfolioWatchHistorical.Mwh) {
                LogsKSE.SelectedSymbol = Utilities.split((String)event.getmessage(), (char)':')[0];
                LogsKSE.SelectedMarket = Utilities.split((String)event.getmessage(), (char)':')[1];
                this.MyPortfolioWatchHistorical.SetSymbol(Utilities.split((String)event.getmessage(), (char)':')[0], false);
            }
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant._1stProfile)) && event.getSource() == this.MyMarketWatch1.Mwh) {
            LogsKSE.SelectedSymbol = Utilities.split((String)event.getmessage(), (char)':')[0];
            LogsKSE.SelectedMarket = Utilities.split((String)event.getmessage(), (char)':')[1];
            this.MyMarketWatch1.SetSymbol(Utilities.split((String)event.getmessage(), (char)':')[0]);
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant._2ndProfile)) && event.getSource() == this.MyMarketWatch2.Mwh) {
            LogsKSE.SelectedSymbol = Utilities.split((String)event.getmessage(), (char)':')[0];
            LogsKSE.SelectedMarket = Utilities.split((String)event.getmessage(), (char)':')[1];
            this.MyMarketWatch2.SetSymbol(Utilities.split((String)event.getmessage(), (char)':')[0]);
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant._3rdProfile)) && event.getSource() == this.MyMarketWatch3.Mwh) {
            LogsKSE.SelectedSymbol = Utilities.split((String)event.getmessage(), (char)':')[0];
            LogsKSE.SelectedMarket = Utilities.split((String)event.getmessage(), (char)':')[1];
            this.MyMarketWatch3.SetSymbol(Utilities.split((String)event.getmessage(), (char)':')[0]);
        } else if (this.getSelectedTab().equalsIgnoreCase(_Spot) && event.getSource() == this.MySpotWatch.Mwh) {
            LogsKSE.SelectedSymbol = Utilities.split((String)event.getmessage(), (char)':')[0];
            LogsKSE.SelectedMarket = Utilities.split((String)event.getmessage(), (char)':')[1];
            this.MySpotWatch.SetSymbol(Utilities.split((String)event.getmessage(), (char)':')[0]);
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.ShariahWatch)) && event.getSource() == this.MyShariaWatch.Mwh) {
            LogsKSE.SelectedSymbol = Utilities.split((String)event.getmessage(), (char)':')[0];
            LogsKSE.SelectedMarket = Utilities.split((String)event.getmessage(), (char)':')[1];
            this.MyShariaWatch.SetSymbol(Utilities.split((String)event.getmessage(), (char)':')[0]);
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.IndexWatch)) && event.getSource() == this.MyINDEXWatch.Mwh) {
            LogsKSE.SelectedSymbol = Utilities.split((String)event.getmessage(), (char)':')[0];
            LogsKSE.SelectedMarket = Utilities.split((String)event.getmessage(), (char)':')[1];
            this.MyINDEXWatch.SetSymbol(Utilities.split((String)event.getmessage(), (char)':')[0]);
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.SectorWatch)) && event.getSource() == this.MySectorWatch.Mwh) {
            LogsKSE.SelectedSymbol = Utilities.split((String)event.getmessage(), (char)':')[0];
            LogsKSE.SelectedMarket = Utilities.split((String)event.getmessage(), (char)':')[1];
            this.MySectorWatch.SetSymbol(Utilities.split((String)event.getmessage(), (char)':')[0]);
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.FutureWatch)) && event.getSource() == this.MyFutureWatch.Mwh) {
            LogsKSE.SelectedSymbol = Utilities.split((String)event.getmessage(), (char)':')[0];
            LogsKSE.SelectedMarket = Utilities.split((String)event.getmessage(), (char)':')[1];
            this.MyFutureWatch.SetSymbol(Utilities.split((String)event.getmessage(), (char)':')[0]);
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.FutureWatch)) && event.getSource() == this.MyFutureWatch.MwhSpread) {
            LogsKSE.SelectedSymbol = Utilities.split((String)event.getmessage(), (char)':')[0];
            LogsKSE.SelectedMarket = Utilities.split((String)event.getmessage(), (char)':')[1];
            this.MyFutureWatch.SetSymbol(Utilities.split((String)event.getmessage(), (char)':')[0]);
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.CapWatch)) && (event.getSource() == this.MyCapWatch.MwhUpperCap || event.getSource() == this.MyCapWatch.MwhLowerCap)) {
            LogsKSE.SelectedSymbol = Utilities.split((String)event.getmessage(), (char)':')[0];
            LogsKSE.SelectedMarket = Utilities.split((String)event.getmessage(), (char)':')[1];
            this.MyCapWatch.SetSymbol(Utilities.split((String)event.getmessage(), (char)':')[0]);
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.PortfolioWatch)) && this.MyPortfolioWatch != null && event.getSource() == this.MyPortfolioWatch.Mwh) {
            LogsKSE.SelectedSymbol = Utilities.split((String)event.getmessage(), (char)':')[0];
            LogsKSE.SelectedMarket = Utilities.split((String)event.getmessage(), (char)':')[1];
            this.MyPortfolioWatch.SetSymbol(Utilities.split((String)event.getmessage(), (char)':')[0]);
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.PortfolioWatch)) && this.MyPortfolioWatchAdv != null && event.getSource() == this.MyPortfolioWatchAdv.Mwh) {
            LogsKSE.SelectedSymbol = Utilities.split((String)event.getmessage(), (char)':')[0];
            LogsKSE.SelectedMarket = Utilities.split((String)event.getmessage(), (char)':')[1];
            if (!LogsKSE.SelectedSymbol.equalsIgnoreCase("")) {
                this.MyPortfolioWatchAdv.SetSymbol(LogsKSE.SelectedSymbol);
            }
        }
    }

    public void SymbolRemove(MarketWatchEvent event) {
        if (AppConfig.isHistoricalDataWatch) {
            if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant._1stProfile)) && event.getSource() == this.MyMarketWatchHistorical1.marketWatch) {
                LogsKSE.page1Symbol = event.getmessage();
                this.MyMarketWatchHistorical1.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], false);
                this.MyMarketWatchHistorical1.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], Utilities.split((String)event.getmessage(), (char)':')[1]);
            } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant._2ndProfile)) && event.getSource() == this.MyMarketWatchHistorical2.marketWatch) {
                LogsKSE.page2Symbol = event.getmessage();
                this.MyMarketWatchHistorical2.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], false);
                this.MyMarketWatchHistorical2.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], Utilities.split((String)event.getmessage(), (char)':')[1]);
            } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant._3rdProfile)) && event.getSource() == this.MyMarketWatchHistorical3.marketWatch) {
                LogsKSE.page3Symbol = event.getmessage();
                this.MyMarketWatchHistorical3.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], false);
                this.MyMarketWatchHistorical3.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], Utilities.split((String)event.getmessage(), (char)':')[1]);
            } else if (this.getSelectedTab().equalsIgnoreCase(_Spot) && event.getSource() == this.MySpotWatchHistorical.Mwh && AppConfig.isSpotWatch) {
                this.MySpotWatchHistorical.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], false);
                this.MySpotWatchHistorical.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], Utilities.split((String)event.getmessage(), (char)':')[1]);
            } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.ShariahWatch)) && event.getSource() == this.MyShariaWatchHistorical.Mwh) {
                this.MyShariaWatchHistorical.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], false);
                this.MyShariaWatchHistorical.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], Utilities.split((String)event.getmessage(), (char)':')[1]);
            } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.IndexWatch)) && event.getSource() == this.MyINDEXWatchHistorical.Mwh) {
                this.MyINDEXWatchHistorical.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], false);
                this.MyINDEXWatchHistorical.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], Utilities.split((String)event.getmessage(), (char)':')[1]);
            } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.SectorWatch)) && event.getSource() == this.MySectorWatchHistorical.Mwh) {
                this.MySectorWatchHistorical.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], false);
                this.MySectorWatchHistorical.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], Utilities.split((String)event.getmessage(), (char)':')[1]);
            } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.FutureWatch)) && event.getSource() == this.MyFutureWatchHistorical.MwhSpread) {
                this.MyFutureWatchHistorical.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], false);
                this.MyFutureWatchHistorical.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], Utilities.split((String)event.getmessage(), (char)':')[1]);
            } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.CapWatch)) && event.getSource() == this.MyCapWatchHistorical.MwhUpperCap) {
                this.MyCapWatchHistorical.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], false, this.MyCapWatchHistorical.MwhUpperCap);
                this.MyCapWatchHistorical.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], Utilities.split((String)event.getmessage(), (char)':')[1], this.MyCapWatchHistorical.MwhUpperCap);
            } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.CapWatch)) && event.getSource() == this.MyCapWatchHistorical.MwhLowerCap) {
                this.MyCapWatchHistorical.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], false, this.MyCapWatchHistorical.MwhLowerCap);
                this.MyCapWatchHistorical.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], Utilities.split((String)event.getmessage(), (char)':')[1], this.MyCapWatchHistorical.MwhLowerCap);
            } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.PortfolioWatch)) && event.getSource() == this.MyPortfolioWatchHistorical.Mwh) {
                this.MyPortfolioWatchHistorical.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], false);
                this.MyPortfolioWatchHistorical.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], Utilities.split((String)event.getmessage(), (char)':')[1]);
            } else {
                this.symbolRemove(event);
            }
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant._1stProfile)) && event.getSource() == this.MyMarketWatch1.Mwh) {
            LogsKSE.page1Symbol = event.getmessage();
            this.MyMarketWatch1.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0]);
            this.MyMarketWatch1.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], Utilities.split((String)event.getmessage(), (char)':')[1]);
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant._2ndProfile)) && event.getSource() == this.MyMarketWatch2.Mwh) {
            LogsKSE.page2Symbol = event.getmessage();
            this.MyMarketWatch2.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0]);
            this.MyMarketWatch2.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], Utilities.split((String)event.getmessage(), (char)':')[1]);
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant._3rdProfile)) && event.getSource() == this.MyMarketWatch3.Mwh) {
            LogsKSE.page3Symbol = event.getmessage();
            this.MyMarketWatch3.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0]);
            this.MyMarketWatch3.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], Utilities.split((String)event.getmessage(), (char)':')[1]);
        } else if (this.getSelectedTab().equalsIgnoreCase(_Spot) && event.getSource() == this.MySpotWatch.Mwh) {
            this.MySpotWatch.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0]);
        } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.ShariahWatch)) && event.getSource() == this.MyShariaWatch.Mwh) {
            this.MyShariaWatch.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0]);
        } else if (!this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.IndexWatch)) || event.getSource() != this.MyINDEXWatch.Mwh) {
            if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.SectorWatch)) && event.getSource() == this.MySectorWatch.Mwh) {
                this.MySectorWatch.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0]);
            } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.FutureWatch)) && event.getSource() == this.MyFutureWatch.Mwh) {
                this.MyFutureWatch.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0]);
            } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.FutureWatch)) && event.getSource() == this.MyFutureWatch.MwhSpread) {
                this.MyFutureWatch.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0]);
            } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.CapWatch)) && event.getSource() == this.MyCapWatch.MwhUpperCap || event.getSource() == this.MyCapWatch.MwhLowerCap) {
                this.MyCapWatch.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0]);
            } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.PortfolioWatch)) && this.MyPortfolioWatch != null && event.getSource() == this.MyPortfolioWatch.Mwh) {
                this.MyPortfolioWatch.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0]);
            } else if (this.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.PortfolioWatch)) && this.MyPortfolioWatchAdv != null && event.getSource() == this.MyPortfolioWatchAdv.Mwh) {
                if (!LogsKSE.SelectedSymbol.equalsIgnoreCase("")) {
                    this.MyPortfolioWatchAdv.SymbolRemove(LogsKSE.SelectedSymbol);
                }
            } else {
                this.symbolRemove(event);
            }
        }
    }

    private void symbolRemove(MarketWatchEvent event) {
    }

    public void init() {
        if (AppConfig.isHistoricalDataWatch) {
            this.MyMarketWatchHistorical1 = new MyMarketWatchHistorical(this, LanguageConstant._1stProfile);
            this.MyMarketWatchHistorical2 = new MyMarketWatchHistorical(this, LanguageConstant._2ndProfile);
            this.MyMarketWatchHistorical3 = new MyMarketWatchHistorical(this, LanguageConstant._3rdProfile);
        } else {
            this.MyMarketWatch1 = new MyMarketWatch(this, LanguageConstant._1stProfile);
            this.MyMarketWatch2 = new MyMarketWatch(this, LanguageConstant._2ndProfile);
            this.MyMarketWatch3 = new MyMarketWatch(this, LanguageConstant._3rdProfile);
        }
        if (AppConfig.isHistoricalDataWatch) {
            this.MySectorWatchHistorical = new SectorWatchHistorical();
        } else {
            this.MySectorWatch = new SectorWatch();
        }
        if (AppConfig.isHistoricalDataWatch) {
            this.MyINDEXWatchHistorical = new IndexWatchHistorical();
        } else {
            this.MyINDEXWatch = new IndexWatch();
        }
        if (AppConfig.isHistoricalDataWatch) {
            this.MyCapWatchHistorical = new CapWatchHistorical();
        } else {
            this.MyCapWatch = new CapWatch();
        }
        if (AppConfig.isSpotWatch) {
            if (AppConfig.isHistoricalDataWatch) {
                this.MySpotWatchHistorical = new SpotWatchHistorical();
            } else {
                this.MySpotWatch = new SpotWatch();
            }
        }
        if (AppConfig.isHistoricalDataWatch) {
            this.MyShariaWatchHistorical = new ShariaWatchHistorical();
        } else {
            this.MyShariaWatch = new ShariaWatch();
        }
        if (AppConfig.isHistoricalDataWatch) {
            this.MyFutureWatchHistorical = new FutureWatchHistorical();
        } else {
            this.MyFutureWatch = new FutureWatch();
        }
        try {
            if (AppConfig.isHistoricalDataWatch) {
                this.MyPortfolioWatchHistorical = new PortfolioWatchHistorical();
            } else if (AppConfig.isPortfolioAdv) {
                this.MyPortfolioWatchAdv = new PortfolioWatchAdv();
            } else {
                this.MyPortfolioWatch = new PortfolioWatch();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.mediator.PrintLog(ex, "");
        }
        this.Panel_1 = new JPanel();
        this.Panel_1.setLayout(new BorderLayout());
        if (AppConfig.isHistoricalDataWatch) {
            this.Panel_1.add((Component)this.MyMarketWatchHistorical1, "Center");
        } else {
            this.ScrollPane_1 = new JScrollPane();
            this.ScrollPane_1.getViewport().add(this.MyMarketWatch1);
            this.Panel_1.add((Component)this.ScrollPane_1, "Center");
        }
        this.Panel_2 = new JPanel();
        this.Panel_2.setLayout(new BorderLayout());
        if (AppConfig.isHistoricalDataWatch) {
            this.Panel_2.add((Component)this.MyMarketWatchHistorical2, "Center");
        } else {
            this.ScrollPane_2 = new JScrollPane();
            this.ScrollPane_2.getViewport().add(this.MyMarketWatch2);
            this.Panel_2.add((Component)this.ScrollPane_2, "Center");
        }
        this.Panel_3 = new JPanel();
        this.Panel_3.setLayout(new BorderLayout());
        if (AppConfig.isHistoricalDataWatch) {
            this.Panel_3.add((Component)this.MyMarketWatchHistorical3, "Center");
        } else {
            this.ScrollPane_3 = new JScrollPane();
            this.ScrollPane_3.getViewport().add(this.MyMarketWatch3);
            this.Panel_3.add((Component)this.ScrollPane_3, "Center");
        }
        this.Panel_4 = new JPanel();
        this.Panel_4.setLayout(new BorderLayout());
        if (AppConfig.isHistoricalDataWatch) {
            this.Panel_4.add((Component)this.MySectorWatchHistorical, "Center");
        } else {
            this.ScrollPane_4 = new JScrollPane();
            this.ScrollPane_4.getViewport().add(this.MySectorWatch);
            this.Panel_4.add((Component)this.ScrollPane_4, "Center");
        }
        this.Panel_5 = new JPanel();
        this.Panel_5.setLayout(new BorderLayout());
        if (AppConfig.isHistoricalDataWatch) {
            this.Panel_5.add((Component)this.MyINDEXWatchHistorical, "Center");
        } else {
            this.ScrollPane_5 = new JScrollPane();
            this.ScrollPane_5.getViewport().add(this.MyINDEXWatch);
            this.Panel_5.add((Component)this.ScrollPane_5, "Center");
        }
        this.Panel_6 = new JPanel();
        this.Panel_6.setLayout(new BorderLayout());
        if (AppConfig.isHistoricalDataWatch) {
            this.Panel_6.add((Component)this.MyCapWatchHistorical, "Center");
        } else {
            this.Panel_6.add((Component)this.MyCapWatch, "Center");
        }
        if (AppConfig.isSpotWatch) {
            this.Panel_7 = new JPanel();
            this.Panel_7.setLayout(new BorderLayout());
            if (AppConfig.isHistoricalDataWatch) {
                this.Panel_7.add((Component)this.MySpotWatchHistorical, "Center");
            } else {
                this.ScrollPane_7 = new JScrollPane();
                this.ScrollPane_7.getViewport().add(this.MySpotWatch);
                this.Panel_7.add((Component)this.ScrollPane_7, "Center");
            }
        }
        this.Panel_8 = new JPanel();
        this.Panel_8.setLayout(new BorderLayout());
        if (AppConfig.isHistoricalDataWatch) {
            this.Panel_8.add((Component)this.MyFutureWatchHistorical, "Center");
        } else {
            this.ScrollPane_8 = new JScrollPane();
            this.ScrollPane_8.getViewport().add(this.MyFutureWatch);
            this.Panel_8.add((Component)this.ScrollPane_8, "Center");
        }
        this.Panel_9 = new JPanel();
        this.Panel_9.setLayout(new BorderLayout());
        this.ScrollPane_9 = new JScrollPane();
        if (AppConfig.isHistoricalDataWatch) {
            this.ScrollPane_9.getViewport().add(this.MyPortfolioWatchHistorical);
        } else if (AppConfig.isPortfolioAdv) {
            this.ScrollPane_9.getViewport().add(this.MyPortfolioWatchAdv);
        } else {
            this.ScrollPane_9.getViewport().add(this.MyPortfolioWatch);
        }
        this.Panel_9.add((Component)this.ScrollPane_9, "Center");
        this.Panel_Sharia = new JPanel();
        this.Panel_Sharia.setLayout(new BorderLayout());
        if (AppConfig.isHistoricalDataWatch) {
            this.Panel_Sharia.add((Component)this.MyShariaWatchHistorical, "Center");
        } else {
            this.ScrollPane_Sharia = new JScrollPane();
            this.ScrollPane_Sharia.getViewport().add(this.MyShariaWatch);
            this.Panel_Sharia.add((Component)this.ScrollPane_Sharia, "Center");
        }
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add(this.languageCentre.getValue(LanguageConstant._1stProfile), this.Panel_1);
        this.tabbedPane.add(this.languageCentre.getValue(LanguageConstant._2ndProfile), this.Panel_2);
        this.tabbedPane.add(this.languageCentre.getValue(LanguageConstant._3rdProfile), this.Panel_3);
        this.tabbedPane.add(this.languageCentre.getValue(LanguageConstant.SectorWatch), this.Panel_4);
        this.tabbedPane.add(this.languageCentre.getValue(LanguageConstant.IndexWatch), this.Panel_5);
        if (AppConfig.isSpotWatch) {
            this.tabbedPane.add(_Spot, this.Panel_7);
        }
        this.tabbedPane.add(this.languageCentre.getValue(LanguageConstant.FutureWatch), this.Panel_8);
        this.tabbedPane.add(this.languageCentre.getValue(LanguageConstant.CapWatch), this.Panel_6);
        if (AppConfig.isShariaWatch) {
            this.tabbedPane.add(this.languageCentre.getValue(LanguageConstant.ShariahWatch), this.Panel_Sharia);
        }
        if (AppConfig.isPortfolioWatch) {
            this.tabbedPane.add(this.languageCentre.getValue(LanguageConstant.PortfolioWatch), this.Panel_9);
        }
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.tabbedPane);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MarketWatchPanel.this.sendSymbolForFeed("Market Watch Tabbed Pane Changed : ");
            }
        });
        this.setMWmenu();
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    Point p = e.getPoint();
                    MarketWatchPanel.this.popup.show(MarketWatchPanel.this.tabbedPane, e.getX(), e.getY());
                }
            }
        });
        String style = "PLAIN";
        if (LogCommon.MarketWatchFont.getStyle() == 1) {
            style = "BOLD";
        } else if (LogCommon.MarketWatchFont.getStyle() == 2) {
            style = "ITALIC";
        } else if (LogCommon.MarketWatchFont.getStyle() == 0) {
            style = "PLAIN";
        }
        if (AppConfig.isHistoricalDataWatch) {
            this.MyMarketWatchHistorical1.marketWatch.ChangeFont(LogCommon.MarketWatchFont.getFamily(), style, LogCommon.MarketWatchFont.getSize());
        } else {
            this.MyMarketWatch1.Mwh.ChangeFont(LogCommon.MarketWatchFont.getFamily(), style, LogCommon.MarketWatchFont.getSize());
        }
    }

    public void setSecterTabDefault() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (!this.tabbedPane.getTitleAt(i).equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.SectorWatch))) continue;
            this.tabbedPane.setSelectedIndex(i);
        }
    }

    public void sendSymbolForFeed(String action) {
        this.tabName = this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex());
        action = action + this.tabName;
        if (this.tabName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant._1stProfile))) {
            if (LogsKSE.page1Symbol.indexOf("|") > 0) {
                LogsKSE.page1Symbol = LogsKSE.page1Symbol.replaceAll("\\;", ":");
                LogsKSE.page1Symbol = LogsKSE.page1Symbol.replaceAll("\\|", ";");
            }
            this.mediator.SendMsgToFeedServer("MKT-FEED|" + LogsKSE.page1Symbol, action);
        } else if (this.tabName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant._2ndProfile))) {
            if (LogsKSE.page2Symbol.indexOf("|") > 0) {
                LogsKSE.page2Symbol = LogsKSE.page2Symbol.replaceAll("\\;", ":");
                LogsKSE.page2Symbol = LogsKSE.page2Symbol.replaceAll("\\|", ";");
            }
            this.mediator.SendMsgToFeedServer("MKT-FEED|" + LogsKSE.page2Symbol, action);
        } else if (this.tabName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant._3rdProfile))) {
            if (LogsKSE.page3Symbol.indexOf("|") > 0) {
                LogsKSE.page3Symbol = LogsKSE.page3Symbol.replaceAll("\\;", ":");
                LogsKSE.page3Symbol = LogsKSE.page3Symbol.replaceAll("\\|", ";");
            }
            this.mediator.SendMsgToFeedServer("MKT-FEED|" + LogsKSE.page3Symbol, action);
        } else if (this.tabName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.SectorWatch))) {
            if (AppConfig.isHistoricalDataWatch) {
                this.MySectorWatchHistorical.SetSectorInCombo(LogCommon.SectorName);
                this.MySectorWatchHistorical.SendFeedRequest();
            } else {
                this.MySectorWatch.SetSectorInCombo(LogCommon.SectorName);
                this.MySectorWatch.SendFeedRequest();
                this.MySectorWatch.setFocus();
            }
        } else if (this.tabName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.IndexWatch))) {
            if (AppConfig.isHistoricalDataWatch) {
                this.MyINDEXWatchHistorical.sendIndexFeedRequest();
            } else {
                this.MyINDEXWatch.sendIndexFeedRequest();
            }
        } else if (this.tabName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.CapWatch))) {
            if (AppConfig.isHistoricalDataWatch) {
                this.MyCapWatchHistorical.GetUpperCapAndLowerCapSymbol();
            } else {
                this.MyCapWatch.GetUpperCapAndLowerCapSymbol();
            }
        } else if (this.tabName.equalsIgnoreCase(_Spot)) {
            if (AppConfig.isSpotWatch) {
                if (AppConfig.isHistoricalDataWatch) {
                    this.MySpotWatchHistorical.GetSymbol();
                } else {
                    this.MySpotWatch.GetSymbol();
                }
            }
        } else if (this.tabName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.ShariahWatch))) {
            if (AppConfig.isHistoricalDataWatch) {
                this.MyShariaWatchHistorical.GetSymbol();
            } else {
                this.MyShariaWatch.GetSymbol();
            }
        } else if (this.tabName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.FutureWatch))) {
            if (AppConfig.isHistoricalDataWatch) {
                this.MyFutureWatchHistorical.GetSymbol();
            } else {
                this.MyFutureWatch.GetSymbol();
            }
        } else if (this.tabName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.PortfolioWatch))) {
            if (AppConfig.isHistoricalDataWatch) {
                this.MyPortfolioWatchHistorical.SendScripRequest();
            } else if (AppConfig.isPortfolioAdv) {
                this.MyPortfolioWatchAdv.SendScripRequest();
            } else {
                this.MyPortfolioWatch.SendScripRequest();
            }
        }
    }

    public String getSelectedTab() {
        return this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex());
    }

    public MarketWatch getSelectedMarketWatch() {
        if (this.mediator.MwPanel.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant._1stProfile))) {
            if (AppConfig.isHistoricalDataWatch) {
                return this.mediator.MwPanel.MyMarketWatchHistorical1.marketWatch;
            }
            return this.mediator.MwPanel.MyMarketWatch1.Mwh;
        }
        if (this.mediator.MwPanel.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant._2ndProfile))) {
            if (AppConfig.isHistoricalDataWatch) {
                return this.mediator.MwPanel.MyMarketWatchHistorical2.marketWatch;
            }
            return this.mediator.MwPanel.MyMarketWatch2.Mwh;
        }
        if (this.mediator.MwPanel.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant._3rdProfile))) {
            if (AppConfig.isHistoricalDataWatch) {
                return this.mediator.MwPanel.MyMarketWatchHistorical3.marketWatch;
            }
            return this.mediator.MwPanel.MyMarketWatch3.Mwh;
        }
        if (this.mediator.MwPanel.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.CapWatch))) {
            if (AppConfig.isHistoricalDataWatch) {
                return this.mediator.MwPanel.MyCapWatchHistorical.MwhUpperCap;
            }
            return this.mediator.MwPanel.MyCapWatch.MwhUpperCap;
        }
        if (this.mediator.MwPanel.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.FutureWatch))) {
            if (AppConfig.isHistoricalDataWatch) {
                return this.mediator.MwPanel.MyFutureWatchHistorical.Mwh;
            }
            return this.mediator.MwPanel.MyFutureWatch.Mwh;
        }
        if (this.mediator.MwPanel.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.IndexWatch))) {
            if (AppConfig.isHistoricalDataWatch) {
                return this.mediator.MwPanel.MyINDEXWatchHistorical.Mwh;
            }
            return this.mediator.MwPanel.MyINDEXWatch.Mwh;
        }
        if (this.mediator.MwPanel.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.PortfolioWatch))) {
            if (AppConfig.isHistoricalDataWatch) {
                return this.mediator.MwPanel.MyPortfolioWatchHistorical.Mwh;
            }
            if (AppConfig.isPortfolioAdv) {
                return this.mediator.MwPanel.MyPortfolioWatchAdv.Mwh;
            }
            return this.mediator.MwPanel.MyPortfolioWatch.Mwh;
        }
        if (this.mediator.MwPanel.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.SectorWatch))) {
            if (AppConfig.isHistoricalDataWatch) {
                return this.mediator.MwPanel.MySectorWatchHistorical.Mwh;
            }
            return this.mediator.MwPanel.MySectorWatch.Mwh;
        }
        if (this.mediator.MwPanel.getSelectedTab().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.ShariahWatch))) {
            if (AppConfig.isHistoricalDataWatch) {
                return this.mediator.MwPanel.MyShariaWatchHistorical.Mwh;
            }
            return this.mediator.MwPanel.MyShariaWatch.Mwh;
        }
        if (this.mediator.MwPanel.getSelectedTab().equalsIgnoreCase(_Spot) && AppConfig.isSpotWatch) {
            if (AppConfig.isHistoricalDataWatch) {
                return this.mediator.MwPanel.MySpotWatchHistorical.Mwh;
            }
            return this.mediator.MwPanel.MySpotWatch.Mwh;
        }
        return null;
    }

    public void setMWmenu() {
        boolean isOpenGraph = false;
        if (AppConfig.GraphURL.length() > 0) {
            isOpenGraph = true;
        }
        if (AppConfig.isHistoricalDataWatch) {
            this.MyMarketWatchHistorical1.marketWatch.createPopupMenu(isOpenGraph);
            this.MyMarketWatchHistorical2.marketWatch.createPopupMenu(isOpenGraph);
            this.MyMarketWatchHistorical3.marketWatch.createPopupMenu(isOpenGraph);
        } else {
            this.MyMarketWatch1.Mwh.createPopupMenu(isOpenGraph);
            this.MyMarketWatch2.Mwh.createPopupMenu(isOpenGraph);
            this.MyMarketWatch3.Mwh.createPopupMenu(isOpenGraph);
        }
        if (AppConfig.isHistoricalDataWatch) {
            this.MySectorWatchHistorical.Mwh.createPopupMenu(isOpenGraph);
        } else {
            this.MySectorWatch.Mwh.createPopupMenu(isOpenGraph);
        }
        if (AppConfig.isHistoricalDataWatch) {
            this.MyINDEXWatchHistorical.Mwh.createPopupMenu(isOpenGraph);
        } else {
            this.MyINDEXWatch.Mwh.createPopupMenu(isOpenGraph);
        }
        if (AppConfig.isHistoricalDataWatch) {
            this.MyCapWatchHistorical.MwhUpperCap.createPopupMenu(isOpenGraph);
            this.MyCapWatchHistorical.MwhLowerCap.createPopupMenu(isOpenGraph);
        } else {
            this.MyCapWatch.MwhUpperCap.createPopupMenu(isOpenGraph);
            this.MyCapWatch.MwhLowerCap.createPopupMenu(isOpenGraph);
        }
        if (AppConfig.isSpotWatch) {
            if (AppConfig.isHistoricalDataWatch) {
                this.MySpotWatchHistorical.Mwh.createPopupMenu(isOpenGraph);
            } else {
                this.MySpotWatch.Mwh.createPopupMenu(isOpenGraph);
            }
        }
        if (AppConfig.isHistoricalDataWatch) {
            this.MyShariaWatchHistorical.Mwh.createPopupMenu(isOpenGraph);
        } else {
            this.MyShariaWatch.Mwh.createPopupMenu(isOpenGraph);
        }
        if (AppConfig.isHistoricalDataWatch) {
            this.MyFutureWatchHistorical.Mwh.createPopupMenu(isOpenGraph);
        } else {
            this.MyFutureWatch.Mwh.createPopupMenu(isOpenGraph);
        }
        if (AppConfig.isHistoricalDataWatch) {
            this.MyPortfolioWatchHistorical.Mwh.createPopupMenu(isOpenGraph);
        } else if (AppConfig.isPortfolioAdv) {
            this.MyPortfolioWatchAdv.Mwh.createPopupMenu(isOpenGraph);
        } else {
            this.MyPortfolioWatch.Mwh.createPopupMenu(isOpenGraph);
        }
    }

    public void SetColumnToSave() {
        try {
            if (AppConfig.isHistoricalDataWatch) {
                LogCommon.Profile1Col = this.MyMarketWatchHistorical1.marketWatch.getColumOrder();
                LogCommon.Profile2Col = this.MyMarketWatchHistorical2.marketWatch.getColumOrder();
                LogCommon.Profile3Col = this.MyMarketWatchHistorical3.marketWatch.getColumOrder();
                LogCommon.IndexCol = this.MyINDEXWatchHistorical.Mwh.getColumOrder();
                LogCommon.SectorCol = this.MySectorWatchHistorical.Mwh.getColumOrder();
                LogCommon.CapUpperCol = this.MyCapWatchHistorical.MwhUpperCap.getColumOrder();
                LogCommon.CapLowerCol = this.MyCapWatchHistorical.MwhLowerCap.getColumOrder();
                LogCommon.FutureCol = this.MyFutureWatchHistorical.Mwh.getColumOrder();
                LogCommon.ShariaCol = this.MyShariaWatchHistorical.Mwh.getColumOrder();
                if (AppConfig.isSpotWatch) {
                    LogCommon.SpotCol = this.MySpotWatchHistorical.Mwh.getColumOrder();
                }
                LogCommon.PortfolioCol = this.MyPortfolioWatchHistorical.Mwh.getColumOrder();
                LogCommon.Profile1ColWidth = this.MyMarketWatchHistorical1.marketWatch.getColumWidth();
                LogCommon.Profile2ColWidth = this.MyMarketWatchHistorical2.marketWatch.getColumWidth();
                LogCommon.Profile3ColWidth = this.MyMarketWatchHistorical3.marketWatch.getColumWidth();
                LogCommon.IndexColWidth = this.MyINDEXWatchHistorical.Mwh.getColumWidth();
                LogCommon.SectorColWidth = this.MySectorWatchHistorical.Mwh.getColumWidth();
                LogCommon.CapUpperColWidth = this.MyCapWatchHistorical.MwhUpperCap.getColumWidth();
                LogCommon.CapLowerColWidth = this.MyCapWatchHistorical.MwhLowerCap.getColumWidth();
                LogCommon.FutureColWidth = this.MyFutureWatchHistorical.Mwh.getColumWidth();
                LogCommon.ShariaColWidth = this.MyShariaWatchHistorical.Mwh.getColumWidth();
                if (AppConfig.isSpotWatch) {
                    LogCommon.SpotColWidth = this.MySpotWatchHistorical.Mwh.getColumWidth();
                }
                LogCommon.PortfolioColWidth = this.MyPortfolioWatchHistorical.Mwh.getColumWidth();
            } else {
                LogCommon.Profile1Col = this.MyMarketWatch1.Mwh.getColumOrder();
                LogCommon.Profile2Col = this.MyMarketWatch2.Mwh.getColumOrder();
                LogCommon.Profile3Col = this.MyMarketWatch3.Mwh.getColumOrder();
                LogCommon.IndexCol = this.MyINDEXWatch.Mwh.getColumOrder();
                LogCommon.SectorCol = this.MySectorWatch.Mwh.getColumOrder();
                LogCommon.CapUpperCol = this.MyCapWatch.MwhUpperCap.getColumOrder();
                LogCommon.CapLowerCol = this.MyCapWatch.MwhLowerCap.getColumOrder();
                LogCommon.FutureCol = this.MyFutureWatch.Mwh.getColumOrder();
                LogCommon.ShariaCol = this.MyShariaWatch.Mwh.getColumOrder();
                if (AppConfig.isSpotWatch) {
                    LogCommon.SpotCol = this.MySpotWatch.Mwh.getColumOrder();
                }
                LogCommon.PortfolioCol = this.MyPortfolioWatchAdv.Mwh.getColumOrder();
                LogCommon.Profile1ColWidth = this.MyMarketWatch1.Mwh.getColumWidth();
                LogCommon.Profile2ColWidth = this.MyMarketWatch2.Mwh.getColumWidth();
                LogCommon.Profile3ColWidth = this.MyMarketWatch3.Mwh.getColumWidth();
                LogCommon.IndexColWidth = this.MyINDEXWatch.Mwh.getColumWidth();
                LogCommon.SectorColWidth = this.MySectorWatch.Mwh.getColumWidth();
                LogCommon.CapUpperColWidth = this.MyCapWatch.MwhUpperCap.getColumWidth();
                LogCommon.CapLowerColWidth = this.MyCapWatch.MwhLowerCap.getColumWidth();
                LogCommon.FutureColWidth = this.MyFutureWatch.Mwh.getColumWidth();
                LogCommon.ShariaColWidth = this.MyShariaWatch.Mwh.getColumWidth();
                if (AppConfig.isSpotWatch) {
                    LogCommon.SpotColWidth = this.MySpotWatch.Mwh.getColumWidth();
                }
                LogCommon.PortfolioColWidth = this.MyPortfolioWatchAdv.Mwh.getColumWidth();
            }
        }
        catch (Exception e) {
            this.mediator.PrintLog(e, "");
        }
    }

    public void SetMWColumnFromFile() {
        try {
            if (AppConfig.isHistoricalDataWatch) {
                this.MyMarketWatchHistorical1.marketWatch.setColumOrder(LogCommon.Profile1Col);
                this.MyMarketWatchHistorical2.marketWatch.setColumOrder(LogCommon.Profile2Col);
                this.MyMarketWatchHistorical3.marketWatch.setColumOrder(LogCommon.Profile3Col);
                this.MyINDEXWatchHistorical.Mwh.setColumOrder(LogCommon.IndexCol);
                this.MySectorWatchHistorical.Mwh.setColumOrder(LogCommon.SectorCol);
                this.MyCapWatchHistorical.MwhUpperCap.setColumOrder(LogCommon.CapUpperCol);
                this.MyCapWatchHistorical.MwhLowerCap.setColumOrder(LogCommon.CapLowerCol);
                this.MyFutureWatchHistorical.Mwh.setColumOrder(LogCommon.FutureCol);
                this.MyShariaWatchHistorical.Mwh.setColumOrder(LogCommon.ShariaCol);
                if (AppConfig.isSpotWatch) {
                    this.MySpotWatchHistorical.Mwh.setColumOrder(LogCommon.SpotCol);
                }
                this.MyPortfolioWatchHistorical.Mwh.setColumOrder(LogCommon.PortfolioCol);
                this.MyMarketWatchHistorical1.marketWatch.setColumWidth(LogCommon.Profile1ColWidth);
                this.MyMarketWatchHistorical2.marketWatch.setColumWidth(LogCommon.Profile2ColWidth);
                this.MyMarketWatchHistorical3.marketWatch.setColumWidth(LogCommon.Profile3ColWidth);
                this.MyINDEXWatchHistorical.Mwh.setColumWidth(LogCommon.IndexColWidth);
                this.MySectorWatchHistorical.Mwh.setColumWidth(LogCommon.SectorColWidth);
                this.MyCapWatchHistorical.MwhUpperCap.setColumWidth(LogCommon.CapUpperColWidth);
                this.MyCapWatchHistorical.MwhLowerCap.setColumWidth(LogCommon.CapLowerColWidth);
                this.MyFutureWatchHistorical.Mwh.setColumWidth(LogCommon.FutureColWidth);
                this.MyShariaWatchHistorical.Mwh.setColumWidth(LogCommon.ShariaColWidth);
                if (AppConfig.isSpotWatch) {
                    this.MySpotWatchHistorical.Mwh.setColumWidth(LogCommon.SpotColWidth);
                }
                this.MyPortfolioWatchHistorical.Mwh.setColumWidth(LogCommon.PortfolioColWidth);
            } else {
                this.MyMarketWatch1.Mwh.setColumOrder(LogCommon.Profile1Col);
                this.MyMarketWatch2.Mwh.setColumOrder(LogCommon.Profile2Col);
                this.MyMarketWatch3.Mwh.setColumOrder(LogCommon.Profile3Col);
                this.MyINDEXWatch.Mwh.setColumOrder(LogCommon.IndexCol);
                this.MySectorWatch.Mwh.setColumOrder(LogCommon.SectorCol);
                this.MyCapWatch.MwhUpperCap.setColumOrder(LogCommon.CapUpperCol);
                this.MyCapWatch.MwhLowerCap.setColumOrder(LogCommon.CapLowerCol);
                this.MyFutureWatch.Mwh.setColumOrder(LogCommon.FutureCol);
                this.MyShariaWatch.Mwh.setColumOrder(LogCommon.ShariaCol);
                if (AppConfig.isSpotWatch) {
                    this.MySpotWatch.Mwh.setColumOrder(LogCommon.SpotCol);
                }
                this.MyPortfolioWatchAdv.Mwh.setColumOrder(LogCommon.PortfolioCol);
                this.MyMarketWatch1.Mwh.setColumWidth(LogCommon.Profile1ColWidth);
                this.MyMarketWatch2.Mwh.setColumWidth(LogCommon.Profile2ColWidth);
                this.MyMarketWatch3.Mwh.setColumWidth(LogCommon.Profile3ColWidth);
                this.MyINDEXWatch.Mwh.setColumWidth(LogCommon.IndexColWidth);
                this.MySectorWatch.Mwh.setColumWidth(LogCommon.SectorColWidth);
                this.MyCapWatch.MwhUpperCap.setColumWidth(LogCommon.CapUpperColWidth);
                this.MyCapWatch.MwhLowerCap.setColumWidth(LogCommon.CapLowerColWidth);
                this.MyFutureWatch.Mwh.setColumWidth(LogCommon.FutureColWidth);
                this.MyShariaWatch.Mwh.setColumWidth(LogCommon.ShariaColWidth);
                if (AppConfig.isSpotWatch) {
                    this.MySpotWatch.Mwh.setColumWidth(LogCommon.SpotColWidth);
                }
                this.MyPortfolioWatchAdv.Mwh.setColumWidth(LogCommon.PortfolioColWidth);
            }
        }
        catch (Exception e) {
            this.mediator.PrintLog(e, "SetMWColumnFromFile");
        }
    }

    public void AddSymbolInWatch(String str) {
        String mkt = Utilities.GetMarketFromsymbol((String)str);
        str = str + ";" + mkt;
        this.tabName = this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex());
        if (this.tabName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant._1stProfile))) {
            if (AppConfig.isHistoricalDataWatch) {
                this.MyMarketWatchHistorical1.marketWatch.AddSymbolInMarketWatch(str, true, false);
            } else {
                this.MyMarketWatch1.Mwh.AddSymbolInMarketWatch(str, false, false);
            }
        } else if (this.tabName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant._2ndProfile))) {
            if (AppConfig.isHistoricalDataWatch) {
                this.MyMarketWatchHistorical2.marketWatch.AddSymbolInMarketWatch(str, true, false);
            } else {
                this.MyMarketWatch2.Mwh.AddSymbolInMarketWatch(str, false, false);
            }
        } else if (this.tabName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant._3rdProfile))) {
            if (AppConfig.isHistoricalDataWatch) {
                this.MyMarketWatchHistorical3.marketWatch.AddSymbolInMarketWatch(str, true, false);
            } else {
                this.MyMarketWatch3.Mwh.AddSymbolInMarketWatch(str, false, false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
    }

    public void SetAllWatchFontsAndColors(Font F) {
        String style = "PLAIN";
        if (F.getStyle() == 1) {
            style = "BOLD";
        } else if (F.getStyle() == 2) {
            style = "ITALIC";
        } else if (F.getStyle() == 0) {
            style = "PLAIN";
        }
        if (AppConfig.isHistoricalDataWatch) {
            if (this.MyMarketWatchHistorical1 != null) {
                this.MyMarketWatchHistorical1.marketWatch.ChangeFont(F.getFamily(), style, F.getSize());
                this.MyMarketWatchHistorical1.marketWatch.setRowBackGroundColor(MyColors.MarketWatchRowColor);
                this.MyMarketWatchHistorical1.marketWatch.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
                this.MyMarketWatchHistorical1.marketWatch.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
                this.MyMarketWatchHistorical1.marketWatch.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
            }
            if (this.MyMarketWatchHistorical2 != null) {
                this.MyMarketWatchHistorical2.marketWatch.ChangeFont(F.getFamily(), style, F.getSize());
                this.MyMarketWatchHistorical2.marketWatch.setRowBackGroundColor(MyColors.MarketWatchRowColor);
                this.MyMarketWatchHistorical2.marketWatch.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
                this.MyMarketWatchHistorical2.marketWatch.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
                this.MyMarketWatchHistorical2.marketWatch.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
            }
            if (this.MyMarketWatchHistorical3 != null) {
                this.MyMarketWatchHistorical3.marketWatch.ChangeFont(F.getFamily(), style, F.getSize());
                this.MyMarketWatchHistorical3.marketWatch.setRowBackGroundColor(MyColors.MarketWatchRowColor);
                this.MyMarketWatchHistorical3.marketWatch.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
                this.MyMarketWatchHistorical3.marketWatch.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
                this.MyMarketWatchHistorical3.marketWatch.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
            }
            if (this.MySpotWatchHistorical != null) {
                this.MySpotWatchHistorical.Mwh.ChangeFont(F.getFamily(), style, F.getSize());
                this.MySpotWatchHistorical.Mwh.setRowBackGroundColor(MyColors.MarketWatchRowColor);
                this.MySpotWatchHistorical.Mwh.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
                this.MySpotWatchHistorical.Mwh.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
                this.MySpotWatchHistorical.Mwh.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
            }
            if (this.MyShariaWatchHistorical != null) {
                this.MyShariaWatchHistorical.Mwh.ChangeFont(F.getFamily(), style, F.getSize());
                this.MyShariaWatchHistorical.Mwh.setRowBackGroundColor(MyColors.MarketWatchRowColor);
                this.MyShariaWatchHistorical.Mwh.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
                this.MyShariaWatchHistorical.Mwh.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
                this.MyShariaWatchHistorical.Mwh.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
            }
            if (this.MyINDEXWatchHistorical != null) {
                this.MyINDEXWatchHistorical.Mwh.ChangeFont(F.getFamily(), style, F.getSize());
                this.MyINDEXWatchHistorical.Mwh.setRowBackGroundColor(MyColors.MarketWatchRowColor);
                this.MyINDEXWatchHistorical.Mwh.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
                this.MyINDEXWatchHistorical.Mwh.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
                this.MyINDEXWatchHistorical.Mwh.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
            }
            if (this.MySectorWatchHistorical != null) {
                this.MySectorWatchHistorical.Mwh.ChangeFont(F.getFamily(), style, F.getSize());
                this.MySectorWatchHistorical.Mwh.setRowBackGroundColor(MyColors.MarketWatchRowColor);
                this.MySectorWatchHistorical.Mwh.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
                this.MySectorWatchHistorical.Mwh.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
                this.MySectorWatchHistorical.Mwh.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
            }
            if (this.MyFutureWatchHistorical.Mwh != null) {
                this.MyFutureWatchHistorical.Mwh.ChangeFont(F.getFamily(), style, F.getSize());
                this.MyFutureWatchHistorical.Mwh.setRowBackGroundColor(MyColors.MarketWatchRowColor);
                this.MyFutureWatchHistorical.Mwh.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
                this.MyFutureWatchHistorical.Mwh.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
                this.MyFutureWatchHistorical.Mwh.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
            }
            if (this.MyFutureWatchHistorical.MwhSpread != null) {
                this.MyFutureWatchHistorical.MwhSpread.ChangeFont(F.getFamily(), style, F.getSize());
                this.MyFutureWatchHistorical.Mwh.setRowBackGroundColor(MyColors.MarketWatchRowColor);
                this.MyFutureWatchHistorical.MwhSpread.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
                this.MyFutureWatchHistorical.MwhSpread.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
                this.MyFutureWatchHistorical.MwhSpread.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
            }
            if (this.MyCapWatchHistorical != null) {
                this.MyCapWatchHistorical.MwhUpperCap.ChangeFont(F.getFamily(), style, F.getSize());
                this.MyCapWatchHistorical.MwhUpperCap.setRowBackGroundColor(MyColors.MarketWatchRowColor);
                this.MyCapWatchHistorical.MwhUpperCap.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
                this.MyCapWatchHistorical.MwhUpperCap.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
                this.MyCapWatchHistorical.MwhUpperCap.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
                this.MyCapWatchHistorical.MwhLowerCap.ChangeFont(F.getFamily(), style, F.getSize());
                this.MyCapWatchHistorical.MwhLowerCap.setRowBackGroundColor(MyColors.MarketWatchRowColor);
                this.MyCapWatchHistorical.MwhLowerCap.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
                this.MyCapWatchHistorical.MwhLowerCap.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
                this.MyCapWatchHistorical.MwhLowerCap.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
            }
            if (this.MyPortfolioWatchHistorical.Mwh != null) {
                this.MyPortfolioWatchHistorical.Mwh.ChangeFont(F.getFamily(), style, F.getSize());
                this.MyPortfolioWatchHistorical.Mwh.setRowBackGroundColor(MyColors.MarketWatchRowColor);
                this.MyPortfolioWatchHistorical.Mwh.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
                this.MyPortfolioWatchHistorical.Mwh.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
                this.MyPortfolioWatchHistorical.Mwh.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
            }
        } else {
            if (this.MyMarketWatch1 != null) {
                this.MyMarketWatch1.Mwh.ChangeFont(F.getFamily(), style, F.getSize());
                this.MyMarketWatch1.Mwh.setRowBackGroundColor(MyColors.MarketWatchRowColor);
                this.MyMarketWatch1.Mwh.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
                this.MyMarketWatch1.Mwh.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
                this.MyMarketWatch1.Mwh.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
            }
            if (this.MyMarketWatch2 != null) {
                this.MyMarketWatch2.Mwh.ChangeFont(F.getFamily(), style, F.getSize());
                this.MyMarketWatch2.Mwh.setRowBackGroundColor(MyColors.MarketWatchRowColor);
                this.MyMarketWatch2.Mwh.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
                this.MyMarketWatch2.Mwh.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
                this.MyMarketWatch2.Mwh.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
            }
            if (this.MyMarketWatch3 != null) {
                this.MyMarketWatch3.Mwh.ChangeFont(F.getFamily(), style, F.getSize());
                this.MyMarketWatch3.Mwh.setRowBackGroundColor(MyColors.MarketWatchRowColor);
                this.MyMarketWatch3.Mwh.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
                this.MyMarketWatch3.Mwh.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
                this.MyMarketWatch3.Mwh.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
            }
            if (this.MySpotWatch != null) {
                this.MySpotWatch.Mwh.ChangeFont(F.getFamily(), style, F.getSize());
                this.MySpotWatch.Mwh.setRowBackGroundColor(MyColors.MarketWatchRowColor);
                this.MySpotWatch.Mwh.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
                this.MySpotWatch.Mwh.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
                this.MySpotWatch.Mwh.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
            }
        }
        if (this.MySectorWatch != null) {
            this.MySectorWatch.Mwh.ChangeFont(F.getFamily(), style, F.getSize());
            this.MySectorWatch.Mwh.setRowBackGroundColor(MyColors.MarketWatchRowColor);
            this.MySectorWatch.Mwh.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
            this.MySectorWatch.Mwh.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
            this.MySectorWatch.Mwh.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
        }
        if (this.MyINDEXWatch != null) {
            this.MyINDEXWatch.Mwh.ChangeFont(F.getFamily(), style, F.getSize());
            this.MyINDEXWatch.Mwh.setRowBackGroundColor(MyColors.MarketWatchRowColor);
            this.MyINDEXWatch.Mwh.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
            this.MyINDEXWatch.Mwh.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
            this.MyINDEXWatch.Mwh.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
        }
        if (this.MyPortfolioWatch != null) {
            this.MyPortfolioWatch.Mwh.ChangeFont(F.getFamily(), style, F.getSize());
            this.MyPortfolioWatch.Mwh.setRowBackGroundColor(MyColors.MarketWatchRowColor);
            this.MyPortfolioWatch.Mwh.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
            this.MyPortfolioWatch.Mwh.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
            this.MyPortfolioWatch.Mwh.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
        }
        if (this.MyPortfolioWatchAdv != null) {
            this.MyPortfolioWatchAdv.Mwh.ChangeFont(F.getFamily(), style, F.getSize());
            this.MyPortfolioWatchAdv.Mwh.setRowBackGroundColor(MyColors.MarketWatchRowColor);
            this.MyPortfolioWatchAdv.Mwh.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
            this.MyPortfolioWatchAdv.Mwh.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
            this.MyPortfolioWatchAdv.Mwh.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
        }
        if (this.MyCapWatch != null) {
            this.MyCapWatch.MwhUpperCap.ChangeFont(F.getFamily(), style, F.getSize());
            this.MyCapWatch.MwhUpperCap.setRowBackGroundColor(MyColors.MarketWatchRowColor);
            this.MyCapWatch.MwhUpperCap.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
            this.MyCapWatch.MwhUpperCap.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
            this.MyCapWatch.MwhUpperCap.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
            this.MyCapWatch.MwhLowerCap.ChangeFont(F.getFamily(), style, F.getSize());
            this.MyCapWatch.MwhLowerCap.setRowBackGroundColor(MyColors.MarketWatchRowColor);
            this.MyCapWatch.MwhLowerCap.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
            this.MyCapWatch.MwhLowerCap.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
            this.MyCapWatch.MwhLowerCap.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
        }
        if (this.MyShariaWatch != null) {
            this.MyShariaWatch.Mwh.ChangeFont(F.getFamily(), style, F.getSize());
            this.MyShariaWatch.Mwh.setRowBackGroundColor(MyColors.MarketWatchRowColor);
            this.MyShariaWatch.Mwh.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
            this.MyShariaWatch.Mwh.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
            this.MyShariaWatch.Mwh.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
        }
        if (this.MyPortfolioWatch != null) {
            this.MyPortfolioWatch.Mwh.ChangeFont(F.getFamily(), style, F.getSize());
            this.MyPortfolioWatch.Mwh.setRowBackGroundColor(MyColors.MarketWatchRowColor);
            this.MyPortfolioWatch.Mwh.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
            this.MyPortfolioWatch.Mwh.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
            this.MyPortfolioWatch.Mwh.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
        }
        if (this.MyFutureWatch != null) {
            if (this.MyFutureWatch.Mwh != null) {
                this.MyFutureWatch.Mwh.ChangeFont(F.getFamily(), style, F.getSize());
                this.MyFutureWatch.Mwh.setRowBackGroundColor(MyColors.MarketWatchRowColor);
                this.MyFutureWatch.Mwh.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
                this.MyFutureWatch.Mwh.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
                this.MyFutureWatch.Mwh.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
            }
            if (this.MyFutureWatch.MwhSpread != null) {
                this.MyFutureWatch.MwhSpread.ChangeFont(F.getFamily(), style, F.getSize());
                this.MyFutureWatch.MwhSpread.setRowBackGroundColor(MyColors.MarketWatchRowColor);
                this.MyFutureWatch.MwhSpread.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
                this.MyFutureWatch.MwhSpread.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
                this.MyFutureWatch.MwhSpread.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
            }
        }
    }

    public void setMarketStatus(boolean status) {
        if (AppConfig.isHistoricalDataWatch) {
            if (this.MyMarketWatchHistorical1 != null) {
                this.MyMarketWatchHistorical1.marketWatch.isMarketOpen = status;
            }
            if (this.MyMarketWatchHistorical2 != null) {
                this.MyMarketWatchHistorical2.marketWatch.isMarketOpen = status;
            }
            if (this.MyMarketWatchHistorical3 != null) {
                this.MyMarketWatchHistorical3.marketWatch.isMarketOpen = status;
            }
            if (this.MySpotWatchHistorical != null) {
                this.MySpotWatchHistorical.Mwh.isMarketOpen = status;
            }
            if (this.MyShariaWatchHistorical != null) {
                this.MyShariaWatchHistorical.Mwh.isMarketOpen = status;
            }
            if (this.MyINDEXWatchHistorical != null) {
                this.MyINDEXWatchHistorical.Mwh.isMarketOpen = status;
            }
            if (this.MySectorWatchHistorical != null) {
                this.MySectorWatchHistorical.Mwh.isMarketOpen = status;
            }
            if (this.MyFutureWatchHistorical != null) {
                this.MyFutureWatchHistorical.Mwh.isMarketOpen = status;
            }
            if (this.MyCapWatchHistorical != null) {
                this.MyCapWatchHistorical.MwhUpperCap.isMarketOpen = status;
                this.MyCapWatchHistorical.MwhLowerCap.isMarketOpen = status;
            }
            if (this.MyPortfolioWatchHistorical != null) {
                this.MyPortfolioWatchHistorical.Mwh.isMarketOpen = status;
            }
        } else {
            if (this.MyMarketWatch1 != null) {
                this.MyMarketWatch1.Mwh.isMarketOpen = status;
            }
            if (this.MyMarketWatch2 != null) {
                this.MyMarketWatch2.Mwh.isMarketOpen = status;
            }
            if (this.MyMarketWatch3 != null) {
                this.MyMarketWatch3.Mwh.isMarketOpen = status;
            }
            if (this.MySpotWatch != null) {
                this.MySpotWatch.Mwh.isMarketOpen = status;
            }
            if (this.MyFutureWatch != null) {
                this.MyFutureWatch.Mwh.isMarketOpen = status;
            }
            if (this.MySectorWatch != null) {
                this.MySectorWatch.Mwh.isMarketOpen = status;
            }
            if (this.MyINDEXWatch != null) {
                this.MyINDEXWatch.Mwh.isMarketOpen = status;
            }
            if (this.MyPortfolioWatch != null) {
                this.MyPortfolioWatch.Mwh.isMarketOpen = status;
            }
            if (this.MyPortfolioWatchAdv != null) {
                this.MyPortfolioWatchAdv.Mwh.isMarketOpen = status;
            }
            if (this.MyCapWatch != null) {
                this.MyCapWatch.MwhUpperCap.isMarketOpen = status;
                this.MyCapWatch.MwhLowerCap.isMarketOpen = status;
            }
            if (this.MyShariaWatch != null) {
                this.MyShariaWatch.Mwh.isMarketOpen = status;
            }
        }
        if (this.MyCapWatch != null) {
            this.MyCapWatch.MwhUpperCap.isMarketOpen = status;
        }
    }

    public void setCapsValues() {
        if (AppConfig.isHistoricalDataWatch) {
            if (this.MyMarketWatchHistorical1 != null) {
                this.MyMarketWatchHistorical1.marketWatch.setCapsValues();
            }
            if (this.MyMarketWatchHistorical2 != null) {
                this.MyMarketWatchHistorical2.marketWatch.setCapsValues();
            }
            if (this.MyMarketWatchHistorical3 != null) {
                this.MyMarketWatchHistorical3.marketWatch.setCapsValues();
            }
            if (this.MySpotWatchHistorical != null) {
                this.MySpotWatchHistorical.Mwh.setCapsValues();
            }
            if (this.MyShariaWatchHistorical != null) {
                this.MyShariaWatchHistorical.Mwh.setCapsValues();
            }
            if (this.MyINDEXWatchHistorical != null) {
                this.MyINDEXWatchHistorical.Mwh.setCapsValues();
            }
            if (this.MySectorWatchHistorical != null) {
                this.MySectorWatchHistorical.Mwh.setCapsValues();
            }
            if (this.MyFutureWatchHistorical != null) {
                this.MyFutureWatchHistorical.Mwh.setCapsValues();
            }
            if (this.MyCapWatchHistorical != null) {
                this.MyCapWatchHistorical.MwhUpperCap.setCapsValues();
                this.MyCapWatchHistorical.MwhLowerCap.setCapsValues();
            }
            if (this.MyPortfolioWatchHistorical != null) {
                this.MyPortfolioWatchHistorical.Mwh.setCapsValues();
            }
        } else {
            if (this.MyMarketWatch1 != null) {
                this.MyMarketWatch1.Mwh.setCapsValues();
            }
            if (this.MyMarketWatch2 != null) {
                this.MyMarketWatch2.Mwh.setCapsValues();
            }
            if (this.MyMarketWatch3 != null) {
                this.MyMarketWatch3.Mwh.setCapsValues();
            }
            if (this.MySpotWatch != null) {
                this.MySpotWatch.Mwh.setCapsValues();
            }
            if (this.MyFutureWatch != null) {
                this.MyFutureWatch.Mwh.setCapsValues();
            }
            if (this.MySectorWatch != null) {
                this.MySectorWatch.Mwh.setCapsValues();
            }
            if (this.MyINDEXWatch != null) {
                this.MyINDEXWatch.Mwh.setCapsValues();
            }
            if (this.MyPortfolioWatch != null) {
                this.MyPortfolioWatch.Mwh.setCapsValues();
            }
            if (this.MyPortfolioWatchAdv != null) {
                this.MyPortfolioWatchAdv.Mwh.setCapsValues();
            }
            if (this.MyCapWatch != null) {
                this.MyCapWatch.MwhUpperCap.setCapsValues();
                this.MyCapWatch.MwhLowerCap.setCapsValues();
            }
            if (this.MyShariaWatch != null) {
                this.MyShariaWatch.Mwh.setCapsValues();
            }
        }
        if (this.MyCapWatch != null) {
            this.MyCapWatch.MwhUpperCap.setCapsValues();
        }
    }

    public void closePortfolioWatch() {
        this.tabbedPane.setEnabledAt(this.tabbedPane.getComponentCount() - 1, false);
        if (AppConfig.isHistoricalDataWatch) {
            this.MyPortfolioWatchHistorical.setVisible(false);
        } else if (AppConfig.isPortfolioAdv) {
            this.MyPortfolioWatchAdv.setVisible(false);
        } else {
            this.MyPortfolioWatch.setVisible(false);
        }
    }

    public void openPortfolioWatch() {
        this.tabbedPane.setEnabledAt(this.tabbedPane.getComponentCount() - 1, true);
        if (AppConfig.isHistoricalDataWatch) {
            this.MyPortfolioWatchHistorical.setVisible(true);
        } else if (AppConfig.isPortfolioAdv) {
            this.MyPortfolioWatchAdv.setVisible(true);
        } else {
            this.MyPortfolioWatch.setVisible(true);
        }
    }
}

