/*
 * Decompiled with CFR 0.152.
 */
package Watches;

import CATALYST.Control.MarketWatch;
import common.gui.component.JTextFieldFilter;
import common.gui.component.NxGDialogBox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.text.Document;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class MarketWatchScripSettingDialog
extends NxGDialogBox {
    private MarketWatch marketWatch;
    private DefaultListModel oldSettingModel = new DefaultListModel();
    private DefaultListModel newSettingModel = new DefaultListModel();
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnCancel;
    private JButton btnDown;
    private JButton btnSaveAndExit;
    private JButton btnShiftAllToNew;
    private JButton btnShiftNewToOld;
    private JButton btnShiftToNew;
    private JButton btnShiftToOld;
    private JButton btnUp;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JToolBar jToolBar1;
    private JToolBar jToolBar2;
    private JList newSettingList;
    private JList oldSettingList;
    private JTextField txtWatchScripNew;
    private JTextField txtWatchScripOld;

    public MarketWatchScripSettingDialog(Frame parent, boolean modal, MarketWatch marketWatch, String symbolScrip) {
        super(parent, modal);
        this.marketWatch = marketWatch;
        this.initComponents();
        this.txtWatchScripOld.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-:"));
        this.txtWatchScripNew.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-:"));
        this.setTitle(this.languageCentre.getValue("MarketWatchScripSetting"));
        this.setLocationRelativeTo(null);
        this.oldSettingList.setModel(this.oldSettingModel);
        this.newSettingList.setModel(this.newSettingModel);
        this.setLanguageValues();
        this.SetAddList(symbolScrip);
    }

    public void SetAddList(String symbolScrip) {
        this.oldSettingModel.clear();
        if (symbolScrip.indexOf(";") > 0) {
            String[] all = symbolScrip.split("\\;", -1);
            for (int i = 0; i < all.length; ++i) {
                this.oldSettingModel.addElement(all[i]);
            }
        }
        this.oldSettingList.repaint();
    }

    private void initComponents() {
        this.txtWatchScripNew = new JTextField();
        this.jLabel2 = new JLabel();
        this.txtWatchScripOld = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.oldSettingList = new JList();
        this.jToolBar2 = new JToolBar();
        this.btnUp = new JButton();
        this.btnDown = new JButton();
        this.jToolBar1 = new JToolBar();
        this.btnShiftToNew = new JButton();
        this.btnShiftAllToNew = new JButton();
        this.btnShiftNewToOld = new JButton();
        this.btnShiftToOld = new JButton();
        this.btnCancel = new JButton();
        this.jSeparator1 = new JSeparator();
        this.btnSaveAndExit = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.newSettingList = new JList();
        this.setDefaultCloseOperation(2);
        this.txtWatchScripNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarketWatchScripSettingDialog.this.txtWatchScripNewActionPerformed(evt);
            }
        });
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("Scrip New Order");
        this.txtWatchScripOld.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarketWatchScripSettingDialog.this.txtWatchScripOldActionPerformed(evt);
            }
        });
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Scrip Old Order");
        this.oldSettingList.setSelectionMode(1);
        this.jScrollPane1.setViewportView(this.oldSettingList);
        this.jToolBar2.setFloatable(false);
        this.jToolBar2.setOrientation(1);
        this.jToolBar2.setRollover(true);
        this.btnUp.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/up_2.png")));
        this.btnUp.setFocusable(false);
        this.btnUp.setHorizontalTextPosition(0);
        this.btnUp.setName("MarketWatchScripSettingDialog -> btnUp");
        this.btnUp.setVerticalTextPosition(3);
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarketWatchScripSettingDialog.this.btnUpActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.btnUp);
        this.btnDown.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/down_1.png")));
        this.btnDown.setFocusable(false);
        this.btnDown.setHorizontalTextPosition(0);
        this.btnDown.setName("MarketWatchScripSettingDialog -> btnDown");
        this.btnDown.setVerticalTextPosition(3);
        this.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarketWatchScripSettingDialog.this.btnDownActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.btnDown);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setOrientation(1);
        this.jToolBar1.setRollover(true);
        this.btnShiftToNew.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/play.png")));
        this.btnShiftToNew.setFocusable(false);
        this.btnShiftToNew.setHorizontalTextPosition(0);
        this.btnShiftToNew.setName("MarketWatchScripSettingDialog -> btnShiftToNew");
        this.btnShiftToNew.setVerticalTextPosition(3);
        this.btnShiftToNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarketWatchScripSettingDialog.this.btnShiftToNewActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnShiftToNew);
        this.btnShiftAllToNew.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/forward.png")));
        this.btnShiftAllToNew.setFocusable(false);
        this.btnShiftAllToNew.setHorizontalTextPosition(0);
        this.btnShiftAllToNew.setName("MarketWatchScripSettingDialog -> btnShiftAllToNew");
        this.btnShiftAllToNew.setVerticalTextPosition(3);
        this.btnShiftAllToNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarketWatchScripSettingDialog.this.btnShiftAllToNewActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnShiftAllToNew);
        this.btnShiftNewToOld.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/rewind.png")));
        this.btnShiftNewToOld.setFocusable(false);
        this.btnShiftNewToOld.setHorizontalTextPosition(0);
        this.btnShiftNewToOld.setName("MarketWatchScripSettingDialog -> btnShiftNewToOld");
        this.btnShiftNewToOld.setVerticalTextPosition(3);
        this.btnShiftNewToOld.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarketWatchScripSettingDialog.this.btnShiftNewToOldActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnShiftNewToOld);
        this.btnShiftToOld.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/back.png")));
        this.btnShiftToOld.setFocusable(false);
        this.btnShiftToOld.setHorizontalTextPosition(0);
        this.btnShiftToOld.setName("MarketWatchScripSettingDialog -> btnShiftToOld");
        this.btnShiftToOld.setVerticalTextPosition(3);
        this.btnShiftToOld.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarketWatchScripSettingDialog.this.btnShiftToOldActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnShiftToOld);
        this.btnCancel.setText("Cancel");
        this.btnCancel.setName("MarketWatchScripSettingDialog -> btnCancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarketWatchScripSettingDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.btnSaveAndExit.setText("Save and Exit");
        this.btnSaveAndExit.setName("MarketWatchScripSettingDialog -> btnSaveAndExit");
        this.btnSaveAndExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarketWatchScripSettingDialog.this.btnSaveAndExitActionPerformed(evt);
            }
        });
        this.newSettingList.setSelectionMode(1);
        this.jScrollPane2.setViewportView(this.newSettingList);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.btnSaveAndExit, -2, 112, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnCancel, -2, 86, -2).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(14, 14, 14).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 130, -2).addComponent(this.txtWatchScripOld, -2, 130, -2).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToolBar1, -2, 30, -2))).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtWatchScripNew, -2, 130, -2).addComponent(this.jLabel2, -2, 130, -2).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToolBar2, -2, 30, -2))).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, 22, -2).addComponent(this.jLabel2, -2, 22, -2)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtWatchScripOld, -2, -1, -2).addComponent(this.txtWatchScripNew, -2, -1, -2)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane1, -1, 206, Short.MAX_VALUE).addComponent(this.jScrollPane2).addGroup(layout.createSequentialGroup().addGap(42, 42, 42).addComponent(this.jToolBar1, -2, 151, -2))).addGap(11, 11, 11)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jToolBar2, -2, 74, -2).addGap(75, 75, 75))).addComponent(this.jSeparator1, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnSaveAndExit).addComponent(this.btnCancel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void txtWatchScripNewActionPerformed(ActionEvent evt) {
        this.newSettingList.setSelectedValue(this.txtWatchScripNew.getText().toUpperCase(), true);
    }

    private void txtWatchScripOldActionPerformed(ActionEvent evt) {
        this.oldSettingList.setSelectedValue(this.txtWatchScripOld.getText().toUpperCase(), true);
    }

    private void btnUpActionPerformed(ActionEvent evt) {
        this.shiftUp();
    }

    private void btnShiftToNewActionPerformed(ActionEvent evt) {
        this.shiftSelectedOldToNew();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void btnShiftAllToNewActionPerformed(ActionEvent evt) {
        this.shiftAllOldToNew();
    }

    private void btnShiftToOldActionPerformed(ActionEvent evt) {
        this.shiftSelectedNewToOld();
    }

    private void btnShiftNewToOldActionPerformed(ActionEvent evt) {
        this.shiftAllNewToOld();
    }

    private void btnDownActionPerformed(ActionEvent evt) {
        this.shiftDown();
    }

    private void btnSaveAndExitActionPerformed(ActionEvent evt) {
        this.marketWatch.RemoveAllSymbolFromWatch();
        for (int i = 0; i < this.newSettingModel.getSize(); ++i) {
            this.marketWatch.AddSymbolInMarketWatch((this.newSettingModel.get(i) + "").replace(":", ";"), true, false);
        }
        this.dispose();
    }

    private void shiftSelectedOldToNew() {
        if (this.oldSettingList.getSelectedIndex() != -1) {
            Object[] removeSelectedList = this.oldSettingList.getSelectedValues();
            int[] removeSelectedListIndices = this.oldSettingList.getSelectedIndices();
            for (int i = 0; i < removeSelectedList.length; ++i) {
                this.newSettingModel.addElement(removeSelectedList[i]);
                this.oldSettingModel.remove(removeSelectedListIndices[i] - i);
            }
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), this.languageCentre.getValue("PleaseSelectScripFromListToAdd"));
        }
    }

    private void shiftSelectedNewToOld() {
        if (this.newSettingList.getSelectedIndex() != -1) {
            Object[] removeSelectedList = this.newSettingList.getSelectedValues();
            int[] removeSelectedListIndices = this.newSettingList.getSelectedIndices();
            for (int i = 0; i < removeSelectedList.length; ++i) {
                this.oldSettingModel.addElement(removeSelectedList[i]);
                this.newSettingModel.remove(removeSelectedListIndices[i] - i);
            }
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), this.languageCentre.getValue("PleaseSelectScripFromListToAdd"));
        }
    }

    private void shiftAllNewToOld() {
        for (int i = 0; i < this.newSettingModel.getSize(); ++i) {
            this.oldSettingModel.addElement(this.newSettingModel.get(i));
        }
        this.newSettingModel.clear();
    }

    private void shiftAllOldToNew() {
        for (int i = 0; i < this.oldSettingModel.getSize(); ++i) {
            this.newSettingModel.addElement(this.oldSettingModel.get(i));
        }
        this.oldSettingModel.clear();
    }

    private void shiftUp() {
        if (this.newSettingList.getSelectedIndex() != -1) {
            Object[] newSelectedList = this.newSettingList.getSelectedValues();
            int[] newSelectedListIndices = this.newSettingList.getSelectedIndices();
            for (int i = 0; i < newSelectedListIndices.length && newSelectedListIndices[i] > 0; ++i) {
                this.newSettingModel.remove(newSelectedListIndices[i]);
                this.newSettingModel.add(newSelectedListIndices[i] - 1, newSelectedList[i]);
                this.newSettingList.setSelectedIndex(newSelectedListIndices[i] - 1);
            }
            this.newSettingList.setSelectionInterval(newSelectedListIndices[0] - 1, newSelectedListIndices[newSelectedListIndices.length - 1] - 1);
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), this.languageCentre.getValue("PleaseSelectScripFromListToAdd"));
        }
    }

    private void shiftDown() {
        if (this.newSettingList.getSelectedIndex() != -1) {
            Object[] newSelectedList = this.newSettingList.getSelectedValues();
            int[] newSelectedListIndices = this.newSettingList.getSelectedIndices();
            if (newSelectedListIndices[newSelectedListIndices.length - 1] == this.newSettingModel.getSize() - 1) {
                return;
            }
            for (int i = newSelectedListIndices.length; i > 0; --i) {
                this.newSettingModel.remove(newSelectedListIndices[i - 1]);
                this.newSettingModel.add(newSelectedListIndices[i - 1] + 1, newSelectedList[i - 1]);
            }
            this.newSettingList.setSelectionInterval(newSelectedListIndices[0] + 1, newSelectedListIndices[newSelectedListIndices.length - 1] + 1);
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), this.languageCentre.getValue("PleaseSelectScripFromListToAdd"));
        }
    }

    private void setLanguageValues() {
        this.jLabel2.setText(this.languageCentre.getValue("ScripNewOrder"));
        this.jLabel1.setText(this.languageCentre.getValue("ScripOldOrder"));
        this.btnCancel.setText(this.languageCentre.getValue(LanguageConstant.Cancel));
        this.btnSaveAndExit.setText(this.languageCentre.getValue("SaveAndExit"));
    }
}

