/*
 * Decompiled with CFR 0.152.
 */
package Watches;

import CATALYST.Control.ColumnData;
import CATALYST.Control.MarketWatch;
import CATALYST.Control.MarketWatchEvent;
import CATALYST.Control.MarketWatchListner;
import MyDocking.Mediator;
import Utilities.LoadLogs;
import Utilities.LogsTC;
import Utilities.ThreadWithName;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.component.JTextFieldFilter;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import kse.util.LogsKSE;
import kse.util.UtilKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class PortfolioWatch
extends JPanel
implements MarketWatchListner,
ActionListener {
    public MarketWatch Mwh;
    private JTextField txtSymbol;
    private JLabel lblSymbol;
    private JButton btnRefresh;
    public JComboBox cbAccountNo;
    private JLabel lblAccount;
    public JPopupMenu popup = new JPopupMenu();
    AutoCompleteSupport autoComplete = null;
    public static String ltPrice = "";
    public static String sys = "";
    private Mediator mediator = Mediator.getInstance();
    private String LastIndex = "";
    JRadioButton rdOpenPosition;
    JRadioButton rdCollateral;
    JLabel lblSymbolName = new JLabel();
    private Hashtable<String, String> Tab = new Hashtable();
    private JToolBar toolBar = new JToolBar();
    private HashMap<String, Integer> columnIndex = new HashMap();
    private LanguageCentre languageCentre = new LanguageCentre();

    private void setColumnIndex() {
        int index = 0;
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Market), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Scrip), index++);
        this.columnIndex.put(this.languageCentre.getValue("BuyVol"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Buy), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Sell), index++);
        this.columnIndex.put(this.languageCentre.getValue("SellVol"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.LastPrice), index++);
        this.columnIndex.put(this.languageCentre.getValue("Change"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.High), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Low), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.TotalVolume), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Average), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.PercentChange), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.LowerLock), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.UpperCap), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Trade), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.CompanySnapshot), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Analytics), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Graph), index++);
        this.columnIndex.put(this.languageCentre.getValue("NetQuantity"), index++);
        this.columnIndex.put(this.languageCentre.getValue("AveragePrice"), index++);
        this.columnIndex.put(this.languageCentre.getValue("Dir"), index++);
        this.columnIndex.put(this.languageCentre.getValue("LTrdTime"), index++);
        this.columnIndex.put(this.languageCentre.getValue("TotalTrd"), index++);
        this.columnIndex.put(this.languageCentre.getValue("LTrdVolume"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.ClosePrice), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.OpenPrice), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.State), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Flag), index++);
    }

    public PortfolioWatch() {
        this.mediator.setPortfolioWatch(this);
        this.setColumnIndex();
        this.Mwh = new MarketWatch("Portfolio", this.columnIndex);
        ColumnData[] m_columns = new ColumnData[]{new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Market), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Scrip), 100, 2), new ColumnData(this.Mwh, this.languageCentre.getValue("BuyVol"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Buy), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Sell), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("SellVol"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.LastPrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("Change"), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.High), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Low), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.TotalVolume), 100, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Average), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.PercentChange), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.LowerLock), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.UpperCap), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Trade), 90, 0), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.CompanySnapshot), 150, 0), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Analytics), 100, 0), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Graph), 100, 0), new ColumnData(this.Mwh, this.languageCentre.getValue("NetQuantity"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("AveragePrice"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("Dir"), 40, 0), new ColumnData(this.Mwh, this.languageCentre.getValue("LTrdTime"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("TotalTrd"), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("LTrdVolume"), 100, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.ClosePrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.OpenPrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.State), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Flag), 50, 2)};
        this.Mwh.isHistoricalDataWatch = false;
        this.Mwh.ChangeAllColorAndFonts(MyColors.MarketWatchRowColor, MyColors.MarketWatchSelectedRowColor, MyColors.MarketWatchIncreaseColor, MyColors.MarketWatchDecreaseColor, LogCommon.MarketWatchFont);
        this.Mwh.SetHeight = new JFrame().getToolkit().getScreenSize().height - 500;
        this.Mwh.SetWidth = new JFrame().getToolkit().getScreenSize().width + 130;
        this.Mwh.setMarket(LogCommon.markets);
        this.Mwh.Debug = false;
        this.Mwh.addListener((MarketWatchListner)this);
        this.Mwh.isUserAddScrip = false;
        this.Mwh.ShowTradeButton = AppConfig.ShowTradeButton;
        this.Mwh.ShowCompanySnapButton = AppConfig.ShowCompanySnapshotButton;
        this.Mwh.ShowGraphButton = AppConfig.ShowGraphButton;
        this.Mwh.ShowAnalyticsButton = AppConfig.ShowAnalyticsButton;
        this.Mwh.isStandardCapital = AppConfig.isStandardCapital;
        this.Mwh.init(m_columns);
        this.Mwh.m_table.moveColumn(this.Mwh.m_table.getColumnModel().getColumnIndex(this.languageCentre.getValue(LanguageConstant.Trade)), 11);
        if (this.Mwh.m_table.isColumnExist(this.languageCentre.getValue(LanguageConstant.CompanySnapshot))) {
            this.Mwh.m_table.moveColumn(this.Mwh.m_table.getColumnModel().getColumnIndex(this.languageCentre.getValue(LanguageConstant.CompanySnapshot)), 12);
        }
        this.lblSymbol = new JLabel();
        this.lblSymbol.setFont(new Font("Tahoma", 1, 11));
        this.lblSymbol.setText(this.languageCentre.getValue(LanguageConstant.Scrip));
        this.txtSymbol = new JTextField();
        this.txtSymbol.setPreferredSize(new Dimension(50, 20));
        this.txtSymbol.setMinimumSize(new Dimension(50, 20));
        this.txtSymbol.setMaximumSize(new Dimension(50, 20));
        this.txtSymbol.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                PortfolioWatch.this.txtSymbol.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.txtSymbol.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-"));
        this.lblAccount = new JLabel();
        this.cbAccountNo = new JComboBox();
        this.btnRefresh = new JButton();
        this.btnRefresh.setName("PortfolioWatch -> btnRefresh");
        this.lblAccount.setText(this.languageCentre.getValue("Account"));
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(LogsTC.accountAll.keySet().toArray()));
        this.autoComplete = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])LogsTC.accountAll.keySet().toArray()));
        this.autoComplete.setStrict(true);
        this.cbAccountNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt.getModifiers() == 16) {
                    PortfolioWatch.this.SendScripRequest();
                } else if (evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
                    PortfolioWatch.this.SendScripRequest();
                }
            }
        });
        this.lblSymbol.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
        this.lblSymbol.setHorizontalTextPosition(2);
        this.rdOpenPosition = new JRadioButton(this.languageCentre.getValue("OpenPosition"));
        this.rdCollateral = new JRadioButton(this.languageCentre.getValue("Collateral"));
        this.rdOpenPosition.addActionListener(this);
        this.rdCollateral.addActionListener(this);
        this.btnRefresh.addActionListener(this);
        this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/Images/refresh.png")));
        this.btnRefresh.setToolTipText(this.languageCentre.getValue("RefreshScrip"));
        this.btnRefresh.setText("");
        this.btnRefresh.setMaximumSize(new Dimension(21, 21));
        this.btnRefresh.setMinimumSize(new Dimension(21, 21));
        this.btnRefresh.setPreferredSize(new Dimension(21, 21));
        this.toolBar.add(this.btnRefresh);
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.rdCollateral.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rdOpenPosition);
        group.add(this.rdCollateral);
        this.lblSymbolName.setFont(this.lblSymbolName.getFont().deriveFont(1));
        this.lblSymbolName.setPreferredSize(new Dimension(0, 20));
        this.lblSymbolName.setMaximumSize(new Dimension(1000, 20));
        this.lblSymbolName.setMinimumSize(new Dimension(0, 20));
        JPanel p1 = new JPanel();
        p1.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        p1.setMinimumSize(new Dimension(0, 25));
        p1.setPreferredSize(new Dimension(473, 25));
        GroupLayout layout = new GroupLayout(p1);
        p1.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.lblAccount).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAccountNo, -2, 82, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblSymbol).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtSymbol, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblSymbolName, -1, 162, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.rdCollateral).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rdOpenPosition).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toolBar, -2, -1, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSymbolName).addComponent(this.toolBar, -2, 25, -2).addComponent(this.rdOpenPosition).addComponent(this.rdCollateral).addComponent(this.lblAccount, -2, 24, -2).addComponent(this.cbAccountNo, -2, -1, -2).addComponent(this.lblSymbol).addComponent(this.txtSymbol, -2, -1, -2)));
        JPanel p2 = new JPanel(false);
        p2.setLayout(new GridLayout(1, 1));
        p2.add((Component)this.Mwh, "Center");
        this.setLayout(new BoxLayout(this, 1));
        this.add(p1);
        this.add(p2);
        this.setAlignmentX(0.0f);
        this.txtSymbol.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    String symbol = PortfolioWatch.this.txtSymbol.getText();
                    Object sm = null;
                    if (symbol.indexOf("-") < 1) {
                        if (LogsKSE.PortfolioWatchScrip.indexOf(symbol) > 0) {
                            PortfolioWatch.this.Mwh.AddSymbolInMarketWatch(symbol + ";REG", false, false);
                        }
                    } else {
                        if (LogsKSE.PortfolioWatchScrip.indexOf(symbol) > 0) {
                            PortfolioWatch.this.Mwh.AddSymbolInMarketWatch(symbol + ";" + UtilKSE.GetMarketFromsymbol((String)PortfolioWatch.this.txtSymbol.getText()), false, false);
                        } else {
                            PortfolioWatch.this.txtSymbol.select(0, PortfolioWatch.this.txtSymbol.getText().length());
                        }
                        return;
                    }
                    PortfolioWatch.this.txtSymbol.select(0, PortfolioWatch.this.txtSymbol.getText().length());
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.Tab.put("a", this.languageCentre.getValue("ClientInfo"));
        this.Tab.put("b", this.languageCentre.getValue("Portfolio"));
        this.Tab.put("c", this.languageCentre.getValue("Collaterals"));
        this.Tab.put("d", this.languageCentre.getValue("OpenPosition"));
        this.Tab.put("g", this.languageCentre.getValue("CumulativeSummary"));
    }

    public void setRBName() {
        if (LogsKSE.Portfolio_Tab_Detail != null && LogsKSE.Portfolio_Tab_Detail.length() > 0) {
            LogsKSE.Portfolio_Tab_Detail = LogsKSE.Portfolio_Tab_Detail.replaceAll("\\|", "");
            String[] TabList = LogsKSE.Portfolio_Tab_Detail.split("\\;", -1);
            for (int i = 0; i < TabList.length; ++i) {
                if (TabList[i].length() <= 0) continue;
                this.Tab.put(TabList[i].split("\\,", -1)[1], TabList[i].split("\\,", -1)[0]);
            }
        }
        this.SetTabNames();
    }

    private void SetTabNames() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.rdCollateral.setText(this.Tab.get("c"));
            this.rdOpenPosition.setText(this.Tab.get("d"));
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PortfolioWatch.this.rdCollateral.setText((String)PortfolioWatch.this.Tab.get("c"));
                    PortfolioWatch.this.rdOpenPosition.setText((String)PortfolioWatch.this.Tab.get("d"));
                }
            });
        }
    }

    public synchronized void MarketWatchMessageReceived(MarketWatchEvent event) {
        this.mediator.MarketWatchMessageReceived(event, null);
    }

    public void SetSymbol(String symbol) {
        this.txtSymbol.setText(symbol);
        if (symbol.indexOf("-") >= 0) {
            symbol = symbol.split("\\-", -1)[0];
        }
        if (symbol.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(symbol.trim())) {
            this.lblSymbolName.setText(this.languageCentre.getValue(LanguageConstant.InvalidScrip));
        } else {
            this.lblSymbolName.setText(this.mediator.getSymbolTitle(symbol));
        }
    }

    public void SetEmpty(String symbol) {
        this.txtSymbol.setText("");
        this.lblSymbolName.setText("");
    }

    public void updateAccount() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (PortfolioWatch.this.autoComplete != null) {
                        PortfolioWatch.this.autoComplete.uninstall();
                        PortfolioWatch.this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(LogsTC.accountAll.keySet().toArray()));
                        PortfolioWatch.this.autoComplete = AutoCompleteSupport.install((JComboBox)PortfolioWatch.this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])LogsTC.accountAll.keySet().toArray()));
                        PortfolioWatch.this.autoComplete.setStrict(true);
                        PortfolioWatch.this.SendScripRequest();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.SendScripRequest();
    }

    public void SendScripRequest() {
        if (this.rdOpenPosition.isSelected()) {
            LoadLogs OpenPositionScrip = new LoadLogs("OpenPositionScrip=", true);
            new ThreadWithName(OpenPositionScrip, "OpenPositionScrip").start();
        } else if (this.rdCollateral.isSelected()) {
            LoadLogs CollateralScrip = new LoadLogs("CollateralScrip=", true);
            new ThreadWithName(CollateralScrip, "CollateralScrip").start();
        }
    }

    public void setScrip(String scrip) {
        LogsKSE.PortfolioWatchScrip = "";
        this.Mwh.RemoveAllSymbolFromWatch();
        if (scrip.indexOf("|") >= 0) {
            String[] row = scrip.split("\\|", -1);
            for (int i = 0; i < row.length; ++i) {
                if (row[i].equalsIgnoreCase("")) continue;
                String[] data = row[i].split("\\;", -1);
                for (int j = 0; j < data.length; ++j) {
                    String sym = data[0] + ":" + UtilKSE.GetMarketFromsymbol((String)data[0]) + ";";
                    LogsKSE.PortfolioWatchScrip = LogsKSE.PortfolioWatchScrip + sym;
                    this.Mwh.AddSymbolInPortfolioMarketWatch(data[0], UtilKSE.GetMarketFromsymbol((String)data[0]), data[1], data[2], data[3], false, false);
                }
            }
        }
        Util.ScrollToFirstOrLastRow((boolean)true, (JTable)this.Mwh.GetTable(), (JScrollPane)this.Mwh.scrollPane);
        this.mediator.SendMsgToFeedServer("MKT-FEED|" + LogsKSE.PortfolioWatchScrip, "Portfolio Watch : setScrip");
    }

    void SymbolRemove(String string) {
    }
}

